/***************************************************************************
                          kickpimeventview.h  -  description
                             -------------------
    begin                : Die Jan 14 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMEVENTVIEW_H
#define KICKPIMEVENTVIEW_H

#include <qscrollview.h>

#include "kickpim.h"

class KPEvent;
class QPixmap;
class QGridLayout;

/**
  *@author Bert Speckels
  */

class KickPimEventView : public QScrollView
{
   Q_OBJECT

public:

  KickPimEventView(QWidget *parent=0, const char *name=0);
  ~KickPimEventView();  

  int preferredHeight();

  void updateEventList();

protected:

  void addEvent(KPEvent* event, QWidget* parent, QGridLayout* grid, bool displayDate = false, int dayDist=0);

protected:

  QWidget* m_box;
  QPixmap* m_pixmapBirthday;
  QPixmap* m_pixmapAnniversary;
  QPixmap* m_pixmapEvent;

};

#endif
