/***************************************************************************
                          kickpim.cpp  -  description
                             -------------------
    begin                : Don Okt 24 23:17:09 CEST 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string>
// #include <iostream>
// #include <fstream>

// #include <qlayout.h>
// #include <qlabel.h>

#include <kcrash.h>
#include <kdebug.h>
#include <klocale.h>
//#include <kmessagebox.h>

#include "kickpim.h"
#include "kickpimwidget.h"

using namespace std;

KickPimRepository* KickPIM::s_repository = 0;

extern "C"
{
  KPanelApplet* init( QWidget *parent, const QString& configFile)
  {
    KGlobal::locale()->insertCatalogue("kickpim");
    return new KickPIM(configFile, KPanelApplet::Normal,
                      KPanelApplet::About/* | KPanelApplet::Help | KPanelApplet::Preferences*/,
                      parent, "KickPIM-Applet");
  }
}

void KickPimMessageHandler( QtMsgType type, const char *msg )
{
  #ifdef DEBUG_OUTPUT
  switch ( type )
  {
    case QtDebugMsg:
      break;
    case QtWarningMsg:
      if (strstr(msg,"connect")>0)
        kdWarning() << "  QT(Warn): " << msg << endl;
      break;
    case QtFatalMsg:
      kdFatal() << "  QT(Fatal): " << msg << endl;
      break;
  };
  #endif
}

KickPIM::KickPIM(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
       : KPanelApplet(configFile, type, actions, parent, name)
{
  KCrash::setCrashHandler( crashHandler );
  setAcceptDrops(true);

  LogService::construct( "KickPIM" );
  kdDebug() << endl; 
  kdDebug() << "KickPIM - Version " << VERSION << endl << endl;

  qInstallMsgHandler(KickPimMessageHandler);

  // setBackgroundMode(X11ParentRelative);

  // Create Repository-Object early, but initialize its data later ...
  if (s_repository!=0) delete s_repository;
  s_repository = new KickPimRepository(this);

  // main widget
  m_kickPimWidget = new KickPimWidget( this , "KickPim");

  // create icon
  m_iconKickPim = new QPixmap( KickPIM::rep()->dirOfIcons()+"hi32-kickpim-icon.png" );
  setIcon( *m_iconKickPim );

  // create global keys before initializing repository data (i.e. loading the configuration)
  opt()->globalAccel->insert("MenuToggle",      i18n("Menu Toggle"),              i18n("Toggles the KickPIM menu"),                0, 0, m_kickPimWidget, SLOT(toggleMenu()));
  opt()->globalAccel->insert("MenuShow",        i18n("Menu: Show"),               i18n("Displays the KickPIM menu"),              0, 0, m_kickPimWidget, SLOT(showMenu()));
  opt()->globalAccel->insert("MenuHide",        i18n("Menu: Hide"),               i18n("Hides the KickPIM menu"),                 0, 0, m_kickPimWidget, SLOT(hideMenu()));
  opt()->globalAccel->insert("ContactAdd",      i18n("Contacts: Add Contact"),    i18n("Adds a new contact to the addressbook"),  0, 0, m_kickPimWidget, SLOT(addContact()));
  opt()->globalAccel->insert("MailCheck",       i18n("Emails: Check Now"),        i18n("Checks the mails accounts."),             0, 0, m_kickPimWidget, SLOT(checkMailAccounts()));
  opt()->globalAccel->insert("MailCheckToggle", i18n("Emails: Toggle Autocheck"), i18n("Toggles automatic mail polling."),        0, 0, m_kickPimWidget, SLOT(toggleMailCheck()));
  opt()->load();

  m_kickPimWidget->init();

  LogService::setLogCategoryFlag ( opt()->logCategories );
  LogService::setLogLevel        ( opt()->logLevel      );

  s_repository->initData();

  setAcceptDrops(TRUE);
}

KickPIM::~KickPIM()
{
  LogService::destruct( "KickPIM" );

  delete m_iconKickPim;   m_iconKickPim   = 0;
  delete m_kickPimWidget; m_kickPimWidget = 0;

  delete s_repository;    s_repository    = 0;
}

/*
bool KickPIM::process(const QCString &fun, const QByteArray &data, QCString &replyType, QByteArray &replyData)
{
  cout << "DCOP-Message: "+fun << endl;

  if (fun == "help()")
  {
    QString result="functions:\n"
                   "  show: display the KickPIM menu\n"
                   "  hide: hide the KickPIM menu\n";
    QDataStream reply(replyData, IO_WriteOnly);
    reply << result;
    replyType = "QString";
    return true;
  }
  else if (fun == "show()")
  {
    QString result="KickPIM menu is already visible";
    if (setMenuVisible(true)) result="KickPIM menu displayed!";
    QDataStream reply(replyData, IO_WriteOnly);
    reply << result;
    replyType = "QString";
    return true;
  }
  else if (fun == "hide()")
  {
    QString result="KickPIM menu is not visible";
    if (setMenuVisible(false)) result="KickPIM menu hidden!";
    QDataStream reply(replyData, IO_WriteOnly);
    reply << result;
    replyType = "QString";
    return true;
  }
  else if (fun == "toggle()")
  {
    QString result="KickPIM menu toggled: now visible";

    if (!setMenuVisible(true))
    {
      setMenuVisible(false);
      result="KickPIM menu toggled: now hidden";
    }

    QDataStream reply(replyData, IO_WriteOnly);
    reply << result;
    replyType = "QString";
    return true;
  }
  else
  {
    qDebug("unknown function call to KickPIM::process()");
    return false;
  }
}
*/

bool  KickPIM::close( bool alsoDelete )
{
  LogService::call("KickPIM","close");
  
  delete m_iconKickPim;   m_iconKickPim   = 0;
  delete m_kickPimWidget; m_kickPimWidget = 0;
  delete s_repository;    s_repository    = 0;

  LogService::log(LogService::LVL_INFO, LogService::CAT_KICKPIM,"KickPIM closed.");

  return KPanelApplet::close( alsoDelete );
}

void KickPIM::about()
{
  if (m_kickPimWidget) m_kickPimWidget->displayAboutDialog();
}

void KickPIM::help()
{
   //KMessageBox::information(0, i18n("This is a help box"));
}

void KickPIM::preferences()
{
   //KMessageBox::information(0, i18n("This is a preferences box"));
}

int KickPIM::widthForHeight( int /*height*/ ) const
{
  return 24;
  // return (height > 40) ? 24 : 42;
}

int KickPIM::heightForWidth( int /*width*/ ) const
{
   return 24;  
   // return (width > 40) ? 24 : 42;  
}

bool KickPIM::isVertical() const
{
   return orientation() == Qt::Vertical;
}


void KickPIM::resizeEvent( QResizeEvent*)
{
  if (m_kickPimWidget)
  {
    m_kickPimWidget->setFixedSize(width(),height() );
  }
}

void KickPIM::crashHandler( int signal ) {
  fprintf(stderr,"KickPIM: Crash :-[ \n");
  rep()->emergencySave();

  KCrash::defaultCrashHandler( signal );
}
