/***************************************************************************
                          kickpimemaildialog.h  -  description
                             -------------------
    begin                : Son Feb 2 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMEMAILDIALOG_H
#define KICKPIMEMAILDIALOG_H

#include <qwidget.h>
#include <qlistview.h>

#include "kickpimemaildlg.h"

#include "../kpcontact.h"



/**
  *@author Bert Speckels
  */

class KickPimEmailDlgItem : public QListViewItem
{
public:
  KickPimEmailDlgItem  ( QListView* parent, QString col1, QString col2 ) : QListViewItem(parent,col1,col2)
  { m_contact=0; }

  virtual ~KickPimEmailDlgItem ( )
  { m_contact=0; }

  void setContact ( KPContact* contact) { m_contact = contact; };
  KPContact*        contact ( ) { return m_contact; }

protected:

  KPContact*        m_contact;
};


/**
  *@author Bert Speckels
  */

class KickPimEmailDialog : public KickPimEmailDlg
{
   Q_OBJECT
public: 
  KickPimEmailDialog(QWidget *parent=0, const char *name=0);
  ~KickPimEmailDialog();

  void setText    ( QString    text    );
  void addContact ( KPContact* contact );

  int  count();

public slots:

  virtual void accept();

};

#endif
