/***************************************************************************
                          kickpimcontactdialog.cpp  -  description
                             -------------------
    begin                : Mon Feb 3 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qdatetimeedit.h>

#include <klocale.h>
#include <klistview.h>
#include <klineedit.h>
#include <keditlistbox.h>
#include <kdatewidget.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include "../kpcontact.h"
#include "../kickpim.h"

#include "kickpimcontactdialog.h"

KickPimContactDialog::KickPimContactDialog(QWidget *parent, const char *name ) : KickPimContactDlg(parent,name)
{
  m_contact = 0;

  KIconLoader loader;
  
  IconNames ->setPixmap( loader.loadIcon("kuser", KIcon::NoGroup) );
  IconDates ->setPixmap( loader.loadIcon("korganizer",KIcon::NoGroup) );
  IconEmails->setPixmap( loader.loadIcon("kmail",KIcon::NoGroup) );
  IconPhones->setPixmap( loader.loadIcon("kppp",KIcon::NoGroup) );
  
  connect( OkButton,     SIGNAL(clicked()), this, SLOT(accept()) );
  connect( CancelButton, SIGNAL(clicked()), this, SLOT(reject()) );

  connect( CheckBirthday,    SIGNAL(stateChanged(int)), this, SLOT(onBirthdayStateChanged(int)) );
  connect( CheckAnniversary, SIGNAL(stateChanged(int)), this, SLOT(onAnniversaryStateChanged(int)) );  
}

KickPimContactDialog::~KickPimContactDialog()
{
  m_contact = 0;
}

void KickPimContactDialog::setContact(KPContact* contact)
{
  if (!contact) return;
  m_contact = contact;

  QString displayName = KickPIM::rep()->displayName(contact);
  if (!displayName.isEmpty()) setCaption( KickPIM::rep()->displayName(contact) );

  // names
  QStringMap nameMap = m_contact->names();
  NameGiven        ->setText( nameMap["givenName"] );
  NameFamily       ->setText( nameMap["familyName"] );
  NameOrganization ->setText( nameMap["organizationName"] );
  NameNick         ->setText( nameMap["nickName"] );

  // emails
  QStringList emails = m_contact->emailAddresses();
  QStringList::iterator itor = emails.begin();
  while (itor != emails.end()) {
    EmailAddressList->insertItem( (*itor) );
    ++itor;
  }

  // dates
  CheckBirthday    -> setChecked(m_contact->birthday().isValid());
  BirthdayDate     -> setDate( m_contact->birthday() );
  BirthdayDate     -> setEnabled( CheckBirthday->isChecked() );

  CheckAnniversary -> setChecked(m_contact->anniversary().isValid());
  AnniversaryDate  -> setDate( m_contact->anniversary() );
  AnniversaryDate  -> setEnabled( CheckAnniversary->isChecked() );

  // phones
  QStringMap phoneMap = m_contact->phoneNumbers();
  PhoneHome   -> setText( phoneMap["home phone"] );
  PhoneWork   -> setText( phoneMap["work phone"] );
  PhoneMobile -> setText( phoneMap["mobile phone"] );
  Fax         -> setText( phoneMap["Fax Number"] );
}


void KickPimContactDialog::accept()
{
  FUNC_CALL(KickPimContactDialog::accept);
  
  if (m_contact)
  {
    // names
    m_contact->setName( NameGiven->text(), "givenName" );
    m_contact->setName( NameFamily->text(),"familyName" );
    m_contact->setName( NameOrganization->text(), "organizationName" );
    m_contact->setName( NameNick->text(), "nickName" );

    // emails
    m_contact->clearEmailAddresses();
    QStringList list = EmailAddressList->items();
    QStringList::iterator itor = list.begin();
    while (itor != list.end())
    {
      m_contact->addEmailAddress( *itor );
      ++itor;
    }
    
    // dates
    if (CheckBirthday->isChecked())
         m_contact->setBirthday    ( BirthdayDate->date() );
    else m_contact->setBirthday    ( QDate(99,99,99) );

    if (CheckAnniversary->isChecked())
         m_contact->setAnniversary ( AnniversaryDate->date() );
    else m_contact->setAnniversary ( QDate(99,99,99) );

    // Phones
    m_contact->clearPhoneNumbers();
    m_contact->addPhoneNumber( PhoneHome->text()   ,"home phone"   );
    m_contact->addPhoneNumber( PhoneWork->text()   ,"work phone" );
    m_contact->addPhoneNumber( PhoneMobile->text() ,"mobile phone"    );
    m_contact->addPhoneNumber( Fax->text()         ,"Fax Number"   );    
  }  

  QDialog::accept();  
}

void KickPimContactDialog::onBirthdayStateChanged( int state )
{
  BirthdayDate->setEnabled(state==QCheckBox::On);
}

void KickPimContactDialog::onAnniversaryStateChanged( int state )
{
  AnniversaryDate->setEnabled(state==QCheckBox::On);  
}
