/***************************************************************************
 *   Copyright (C) 2003 by Bert Speckels                                   *
 *   bert.speckels@web.de                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qstring.h>

#ifndef _LogService_h_
#define _LogService_h_

class LogService
{
public:

  static const int CAT_KICKPIM    = 1;
  static const int CAT_REPOSITORY = 2;
  static const int CAT_CONTACTS   = 4;
  static const int CAT_EVENTS     = 8;
  static const int CAT_MAIL       = 16;

  static const int LVL_DEBUG      = 5;
  static const int LVL_INFO       = 4;
  static const int LVL_WARN       = 3;
  static const int LVL_ERROR      = 2;
  static const int LVL_FATAL      = 1;

  static bool doLogConstruct;
  static bool doLogCall;
  static bool doLogInfo;

  LogService();
  ~LogService();

  static QString categoryText ( int category  = -1 );
  static QString levelText    ( int level     = -1 );

  static void construct( QString className );
  static void destruct ( QString className );
  static void call( QString className, QString methodName );
  static void log( int level, int category, QString text );
  static void logInfo ( int category, QString text );
  static void logWarn ( int category, QString text );
  static void logError( int category, QString text );

  static void setLogLevel( int level );
  static void setLogCategoryFlag( int flag );

protected:
  static int logCategories;
  static int logLevel;
};

#endif
