/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSASCIIDOC_H
#define _KDISSASCIIDOC_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdissasciidocFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 * Plain text document generator
 *
 * @short Plain text document generator
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class kdissasciidoc : public DGenerator
{
    public:
	kdissasciidoc();
	~kdissasciidoc() {}

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

    protected:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);
	void outputLinks(DDataItem* item, QTextStream & s);

	int m_cnt_lev1;
	int m_cnt_lev2;
	int m_cnt_lev3;
};

#endif // _KDISSASCIIDOC_H
