/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <klocale.h>
#include <klistview.h>
#include "linksPopup.h"

linksPopup::linksPopup(KListView *parent) : KPopupMenu(parent)
{
	insertItem(i18n("Add Link..."), e_add);
	insertItem(i18n("Modify Link..."), e_modify);
	insertItem(i18n("Launch Link"), e_launch);
	insertItem(i18n("Remove Link"), e_remove);

	setItemEnabled(e_modify, parent->selectedItem());
	setItemEnabled(e_launch, parent->selectedItem());
	setItemEnabled(e_remove, parent->selectedItem());
}
