/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qspinbox.h>

#include <kdebug.h>
#include <kcombobox.h>
#include <kcolorbutton.h>
#include <klineedit.h>
#include <klocale.h>
#include <kfontrequester.h>

#include "DDataControl.h"
#include "docsettings.h"
#include "docsettingsdlg.h"

docsettingsdlg::docsettingsdlg( QWidget*parent, DDataControl* data ) : 
	KDialogBase(parent, 0, true, i18n("Edit Document Properties"), Ok|Apply|Cancel)
{
	m_data = data;
	m_content = new docsettings(this);
	setMainWidget(m_content);

	connect(this, SIGNAL(applyClicked()), this, SLOT(slotApply()));
	connect(this, SIGNAL(okClicked()), this, SLOT(slotApply()));

	m_content->fname->setText( m_data->m_fname );
	m_content->sname->setText( m_data->m_sname );
	m_content->email->setText( m_data->m_email );
	m_content->company->setText( m_data->m_company );
	m_content->pixSize->setValue( m_data->m_pixSize );

	m_content->col_background->setColor( m_data->m_col_background );
	m_content->col_link->setColor( m_data->m_col_link );
	m_content->col_ref->setColor( m_data->m_col_ref );
	m_content->canvasFont->setFont( m_data->m_canvasFont );

	m_content->picturesOnCanvas->setChecked( m_data->m_picturesOnCanvas );
	m_content->showDirectionSize->setValue( m_data->m_showDirectionSize );

	m_content->linkStyle->setCurrentItem( m_data->m_linkstyle );
}

docsettingsdlg::~docsettingsdlg()
{
	delete m_content;
}

void docsettingsdlg::slotApply()
{
	m_data->docChanged();
	m_data->m_fname = m_content->fname->text();
	m_data->m_sname = m_content->sname->text();
	m_data->m_email = m_content->email->text();
	m_data->m_company = m_content->company->text();

	m_data->m_pixSize = m_content->pixSize->value();

	m_data->m_col_background = m_content->col_background->color();
	m_data->m_col_link = m_content->col_link->color();
	m_data->m_col_ref = m_content->col_ref->color();

	m_data->m_canvasFont = m_content->canvasFont->font();
	
	m_data->m_picturesOnCanvas = m_content->picturesOnCanvas->isChecked();
	m_data->m_showDirectionSize = m_content->showDirectionSize->value();

	m_data->m_linkstyle = m_content->linkStyle->currentItem();

	m_data->updateSettings();
}

#include "docsettingsdlg.moc"
