/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DISSERTBASE_H
#define _DISSERTBASE_H

#include <qmap.h>
#include "DItem.h"

/**
 * This class is the necessary parent for all
 * mindmap handlers (views and data)
 *
 * @short Common handler for mindmap items
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DBase
{
	public:
		/// default constructor
		DBase(QWidget* parent=0, const char* name=0);
		/// destructor
		virtual ~DBase();

		/// return the item corresponding to the id given
		DItem * Item(int) const;

		/// adding a new mindmap item must call this method to register it
		void registerItem(DItem *);

		/// deleting a mindmap item must unregister it first
		void unregisterItem(int);

		/// this method is used to check if a particular id corresponds to an existing mindmap item
		bool isRegistered(int) const;


		/// count of objects registered
		int Total() const;

		/// debugging method, prints how items are handled
		void printallids();

		/// debugging tool, check if the mindmap items are properly handled
		virtual void checkConsistency() {}

	protected:
		/// this dictionnary holds the registered mindmap items
		QMap<int, DItem*> m_map;
};

#endif // _DISSERTBASE_H
