/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DCANVASFLAG_H
#define _DCANVASFLAG_H

#include <qcanvas.h>
#include <qpixmap.h>

static const int Rtti_DCanvasFlag = 11112;

class DCanvasItem;
class DCanvasFlag : public QCanvasRectangle
{
	public:
		DCanvasFlag(QCanvas*, DCanvasItem*, int);
		virtual ~DCanvasFlag();

		void drawShape(QPainter& p);

		DCanvasItem* m_parent;

		int rtti() const { return Rtti_DCanvasFlag; };

	private:
		int m_flagidx;
		QPixmap m_pixmap;
};

#endif // _DCANVASFLAG_H

