//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CONFIRMATIONTAB_H
#define CONFIRMATIONTAB_H

#include "confirmationtabbase.h"
#include <qstringlist.h>

class DCOPClient;

/**
@author Fred Schaettgen
*/
class ConfirmationTab : public ConfirmationTabBase
{
Q_OBJECT
public:
    ConfirmationTab(QWidget *parent, const char* name);
    ~ConfirmationTab();
public slots:
    void apply();
    void defaults();
signals:
    void dirty();
private:
    DCOPClient *client;
    QStringList serviceList;
    QStringList policyList;
    void disableInterface(QString message);
    void readRules();
    const int policyColumn;
    const int addrColumn;
    const int serviceColumn;
    const int nameColumn;
    void updateNameFromAddr(int row);
    void setRow(int n, QString policy, QString service, QString addrStr);
    void swapRows(int oldRow, int newRow);
    void removeRowSelection(int row);

private slots:
    void moveUp();
    void moveDown();
    void deleteRule();
    void insertRule();
    void valueChanged(int row, int col);
    void selectionChanged();
};

#endif
