/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUESCANNER_H
#define KBLUESCANNER_H

#include <qguardedptr.h>
#include <qthread.h>
#include <qobject.h>

#include <libkbluetooth/inquiry.h>
#include <libkbluetooth/namerequest.h>

#include "kbluelockrc.h"
#include "KBlueLockHandleProcess.h"

#define DEV_ID 0

namespace KBluetooth {
  class DeviceAddress;
  class Inquiry;
}

#ifdef SCAN_RESULT_DEF
struct scan_result {
  char bdaddr[18];
  char name[248];
  char dev_type[100];
} scan_results[7];
#endif

class KBlueLockScanner : public QObject, public QThread {
Q_OBJECT

public:
    KBlueLockScanner();
    ~KBlueLockScanner();
    static KBlueLockScanner* getDefaultScanner(); // singleton implementation
    void registerLockProcess(KBlueLockHandleProcess* _process) {
      process = _process;
    } // termination event handling function
    bool init();
    virtual void run();

private:
    static KBlueLockScanner* _instance; // singleton pattern instance
    kbluelockrc* config;
    KBlueLockHandleProcess* process;
    int inquiry_scan();
    bool checkTrustedDevice(QString _bdaddr);
    bool validate_bdaddr(QString _bdaddr);
    bool validate_name(QString _name);
    bool validate_devtype(int count);
    QGuardedPtr< KBluetooth::Inquiry > inquiry;
    bool inquiry_finished;
    bool exit_condition;
    bool trustedDeviceFound;
    int notFoundCounter;

private slots:
    void slotInquiryDeviceFound(const KBluetooth::DeviceAddress& addr);
    void slotInquiryFinnished();

};
#endif
