/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUELOCKCONFIG_H
#define KBLUELOCKCONFIG_H

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
#include <qguardedptr.h>
#include <kprocess.h>

#include "kbluelockrc.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QCheckBox;
class QFrame;
class QLabel;
class QListBox;
class QListBoxItem;
class QPushButton;
class QRadioButton;
class QSpinBox;

namespace KBluetooth {
    class DeviceAddress;
    class Inquiry;
}

class KBlueLockConfig : public QDialog
{
    Q_OBJECT

public:
    KBlueLockConfig( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~KBlueLockConfig();

    void closeEvent(QCloseEvent*);
    void modified();
    int has_been_modified();
    void save_changes();
    void quit();

    QButtonGroup* buttongroup_bottom_buttons;
    QFrame* line2;
    QPushButton* pushbutton_exit;
    QPushButton* pushbutton_save;
    QPushButton* pushbutton_test;
    QPushButton* pushbutton_default_screenlock;
    QButtonGroup* buttonGroup_main;
    QButtonGroup* button_group_devices_found;
    QListBox* listbox_devices_found;
    QPushButton* pushbutton_scan;
    QPushButton* pushbutton_query;
    QButtonGroup* button_group_trusted_devices;
    QListBox* listbox_trusted_devices;
    QButtonGroup* buttongroup_scan_options;
    QRadioButton* radiobutton_timed;
    QRadioButton* radiobutton_continuous;
    QLabel* label_interval;
    QSpinBox* spin_interval;
    QButtonGroup* buttongroup_authentication;
    QCheckBox* check_validate_name;
    QCheckBox* check_validate_bdaddr;
    QCheckBox* check_validate_device_type;
    QFrame* line1;
    QPushButton* pushbutton_trash;
    QPushButton* pushbutton_add;
    QPushButton* pushbutton_add_all;

protected:

protected slots:
    virtual void languageChange();
    virtual void pushbutton_add_clicked();
    virtual void pushbutton_add_all_clicked();
    virtual void pushbutton_trash_clicked();
    virtual void pushbutton_exit_clicked();
    virtual void pushbutton_save_clicked();
    virtual void pushbutton_test_clicked();
    virtual void pushbutton_default_screenlock_clicked();
    virtual void pushbutton_scan_clicked();
    virtual void pushbutton_query_clicked();
    virtual void check_validate_name_toggled( bool );
    virtual void check_validate_bdaddr_toggled( bool );
    virtual void check_validate_device_type_toggled( bool );
    virtual void spin_interval_value_changed( int );
    virtual void radiobutton_timed_toggled( bool );
    virtual void radiobutton_continuous_toggled( bool );

private slots:
    void slotInquiryDeviceFound(const KBluetooth::DeviceAddress& addr);
    void slotInquiryFinnished();
    void slotSetDefaultLockProcessExited(KProcess* proc);

private:
    QGuardedPtr< KBluetooth::Inquiry > inquiry;
    QPixmap image0;
    QPixmap image1;
    QPixmap image2;
    kbluelockrc* config;
    int old_spin_interval_value;
    bool scanning;
    bool proc_ok;

    QStringList* scan_addrs;
    QStringList* scan_names;
    QStringList* scan_types;

    void setFormValues();
};

#endif // KBLUELOCKCONFIG_H
