// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Romain Behar (romainbehar@yahoo.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the gts plugin module, to protect public symbols from name clashes with other modules
namespace libk3dgts
{

extern k3d::iplugin_factory& boolean_factory();
extern k3d::iplugin_factory& coarsen_polyhedra_factory();
extern k3d::iplugin_factory& poly_sphere_tessellation_factory();

} // namespace libk3dgts

K3D_MODULE_START(libk3dgts, k3d::uuid(0x6de566da, 0x79e84505, 0x8b1ce84a, 0x58d85f4c), Registry)
	Registry.register_factory(libk3dgts::boolean_factory());
	Registry.register_factory(libk3dgts::coarsen_polyhedra_factory());
	Registry.register_factory(libk3dgts::poly_sphere_tessellation_factory());
K3D_MODULE_END

