#include <k3dsdk/path.h>

#include <iostream>
#include <stdexcept>

int main(int argc, char* argv[])
{
	try
	{
		if(argc != 3)
			throw std::runtime_error("Usage: relative_path [ABSOLUTE PATH] [REFERENCE PATH]");

		const boost::filesystem::path absolute_path(argv[1], boost::filesystem::native);
		const boost::filesystem::path reference_path(argv[2], boost::filesystem::native);

//		std::cerr << "path: " << absolute_path.string() << std::endl;
//		std::cerr << "path: " << absolute_path.native_file_string() << std::endl;
//		std::cerr << "root path: " << absolute_path.root_path().string() << std::endl;
//		std::cerr << "root name: " << absolute_path.root_name() << std::endl;
		
		std::cout << k3d::filesystem::make_relative_path(absolute_path, reference_path).native_file_string() << std::endl;
	}
	catch(std::exception& e)
	{
		std::cerr << e.what() << std::endl;
		return 1;
	}
	
	return 0;
}

