//
// XorgのComposeデータをコード化したですよ。
//

namespace Honoka {
struct MultiKeySequence {
    String first;
    String second;
    wchar_t character;
};

MultiKeySequence multikey_table[] = {
	{"plus", "plus",		 '#'},
	{"apostrophe", "space",	 '\''},
	{"space", "apostrophe",	 '\''},
	{"A", "T",	 '@'},
	{"parenleft", "parenleft",	 '['},
	{"slash", "slash",		 '\\'},
	{"slash", "less",		 '\\'},
	{"less", "slash",		 '\\'},
	{"parenright", "parenright",	 ']'},
	{"asciicircum", "space",	 '^'},
	{"space", "asciicircum",	 '^'},
	{"greater", "space",		 '^'},
	{"space", "greater",		 '^'},
	{"grave", "space",		 '`'},
	{"space", "grave",		 '`'},
	{"parenleft", "minus",		 '{'},
	{"minus", "parenleft",		 '{'},
	{"slash", "asciicircum",	 '|'},
	{"asciicircum", "slash",	 '|'},
	{"V", "L",	 '|'},
	{"L", "V",	 '|'},
	{"v", "l",	 '|'},
	{"l", "v",	 '|'},
	{"parenright", "minus",	 '}'},
	{"minus", "parenright",	 '}'},
	{"asciitilde", "space",	 '~'},
	{"space", "asciitilde",	 '~'},
	{"minus", "space",		 '~'},
	{"space", "minus",		 '~'},
	{"exclam", "exclam",		 0241},
	{"c", "slash",	 0242},
	{"slash", "c",	 0242},
	{"C", "slash",	 0242},
	{"slash", "C",	 0242},
	{"C", "bar",	 0242},
	{"bar", "C",	 0242},
	{"c", "bar",	 0242},
	{"bar", "c",	 0242},
	{"l", "minus",	 0243},
	{"minus", "l",	 0243},
	{"L", "minus",	 0243},
	{"minus", "L",	 0243},
	{"l", "equal",	 0243},
	{"equal", "l",	 0243},
	{"L", "equal",	 0243},
	{"equal", "L",	 0243},
	{"y", "minus",	 0245},
	{"minus", "y",	 0245},
	{"Y", "minus",	 0245},
	{"minus", "Y",	 0245},
	{"y", "equal",	 0245},
	{"equal", "y",	 0245},
	{"Y", "equal",	 0245},
	{"equal", "Y",	 0245},
	{"s", "o",	 0247},
	{"o", "s",	 0247},
	{"S", "O",	 0247},
	{"O", "S",	 0247},
	{"S", "exclam",		 0247},
	{"exclam", "S",		 0247},
	{"s", "exclam",		 0247},
	{"exclam", "s",		 0247},
	{"S", "0",	 0247},
	{"0", "S",	 0247},
	{"s", "0",	 0247},
	{"0", "s",	 0247},
	{"x", "o",	 0244},
	{"o", "x",	 0244},
	{"X", "O",	 0244},
	{"O", "X",	 0244},
	{"x", "O",	 0244},
	{"O", "x",	 0244},
	{"X", "o",	 0244},
	{"o", "X",	 0244},
	{"x", "0",	 0244},
	{"0", "x",	 0244},
	{"X", "0",	 0244},
	{"0", "X",	 0244},
	{"c", "o",	 0251},
	{"o", "c",	 0251},
	{"C", "O",	 0251},
	{"O", "C",	 0251},
	{"c", "O",	 0251},
	{"O", "c",	 0251},
	{"C", "o",	 0251},
	{"o", "C",	 0251},
	{"c", "0",	 0251},
	{"0", "c",	 0251},
	{"C", "0",	 0251},
	{"0", "C",	 0251},
	{"parenleft", "c",		 0251},
	{"a", "underscore",		 0252},
	{"underscore", "a",		 0252},
	{"A", "underscore",		 0252},
	{"underscore", "A",		 0252},
	{"o", "underscore",		 0272},
	{"underscore", "o",		 0272},
	{"O", "underscore",		 0272},
	{"underscore", "O",		 0272},
	{"less", "less",		 0253},
	{"greater", "greater",		 0273},
	{"0", "asciicircum",		 0260},
	{"asciicircum", "0",		 0260},
	{"0", "asterisk",		 0260},
	{"asterisk", "0",		 0260},
	{"plus", "minus",		 0261},
	{"minus", "plus",		 0261},
	{"slash", "u",	 0265},
	{"u", "slash",	 0265},
	{"slash", "U",	 0265},
	{"U", "slash",	 0265},
	{"1", "asciicircum",		 0271},
	{"asciicircum", "1",		 0271},
	{"S", "1",	 0271},
	{"1", "S",	 0271},
	{"s", "1",	 0271},
	{"1", "s",	 0271},
	{"2", "asciicircum",		 0262},
	{"asciicircum", "2",		 0262},
	{"S", "2",	 0262},
	{"2", "S",	 0262},
	{"s", "2",	 0262},
	{"2", "s",	 0262},
	{"3", "asciicircum",		 0263},
	{"asciicircum", "3",		 0263},
	{"S", "3",	 0263},
	{"3", "S",	 0263},
	{"s", "3",	 0263},
	{"3", "s",	 0263},
	{"p", "exclam",		 0266},
	{"exclam", "p",		 0266},
	{"P", "exclam",		 0266},
	{"exclam", "P",		 0266},
	{"period", "asciicircum",	 0267},
	{"asciicircum", "period",	 0267},
	{"period", "period",		 0267},
	{"1", "4",	 0274},
	{"1", "2",	 0275},
	{"3", "4",	 0276},
	{"question", "question",	 0277},
	{"space", "space",		 0240},
	{"bar", "bar",	 0246},
	{"exclam", "asciicircum",	 0246},
	{"asciicircum", "exclam",	 0246},
	{"V", "B",	 0246},
	{"B", "V",	 0246},
	{"v", "b",	 0246},
	{"b", "v",	 0246},
	{"minus", "comma",		 0254},
	{"comma", "minus",		 0254},
	{"minus", "minus",		 0255},
	{"R", "O",	 0256},
	{"O", "R",	 0256},
	{"parenleft", "r",		 0256},
	{"minus", "asciicircum",	 0257},
	{"asciicircum", "minus",	 0257},
	{"underscore", "asciicircum",	 0257},
	{"asciicircum", "underscore",	 0257},
	{"underscore", "underscore",	 0257},
	{"minus", "colon",		 0367},
	{"colon", "minus",		 0367},
	{"x", "x",	 0327},
	{"apostrophe", "apostrophe",	 0264},
	{"comma", "comma",		 0270},
	{"quotedbl", "quotedbl",	 0250},
// Accented Alphabet
	{"A", "grave",	 0300},
	{"grave", "A",	 0300},
	{"A", "acute",	 0301},
	{"acute", "A",	 0301},
	{"A", "apostrophe",		 0301},
	{"apostrophe", "A",		 0301},
	{"A", "asciicircum",		 0302},
	{"asciicircum", "A",		 0302},
	{"A", "greater",		 0302},
	{"greater", "A",		 0302},
	{"A", "asciitilde",		 0303},
	{"asciitilde", "A",		 0303},
	{"A", "minus",	 0303},
	{"minus", "A",	 0303},
	{"A", "quotedbl",		 0304},
	{"quotedbl", "A",		 0304},
	{"A", "diaeresis",		 0304},
	{"diaeresis", "A",		 0304},
	{"A", "asterisk",		 0305},
	{"asterisk", "A",		 0305},
	{"A", "A",	 0305},
	{"A", "O",	 0305},
	{"A", "E",	 0306},
	{"a", "grave",	 0340},
	{"grave", "a",	 0340},
	{"a", "acute",	 0341},
	{"acute", "a",	 0341},
	{"a", "apostrophe",		 0341},
	{"apostrophe", "a",		 0341},
	{"a", "asciicircum",		 0342},
	{"asciicircum", "a",		 0342},
	{"a", "greater",		 0342},
	{"greater", "a",		 0342},
	{"a", "asciitilde",		 0343},
	{"asciitilde", "a",		 0343},
	{"a", "minus",	 0343},
	{"minus", "a",	 0343},
	{"a", "quotedbl",		 0344},
	{"quotedbl", "a",		 0344},
	{"a", "diaeresis",		 0344},
	{"diaeresis", "a",		 0344},
	{"a", "asterisk",		 0345},
	{"asterisk", "a",		 0345},
	{"a", "a",	 0345},
	{"a", "o",	 0345},
	{"a", "e",	 0346},
	{"acute", "C",	 0307},
	{"acute", "c",	 0347},
	{"C", "comma",	 0307},
	{"comma", "C",	 0307},
	{"c", "comma",	 0347},
	{"comma", "c",	 0347},
	{"minus", "D",	 0320},
	{"D", "minus",	 0320},
	{"minus", "d",	 0360},
	{"d", "minus",	 0360},
	{"E", "grave",	 0310},
	{"grave", "E",	 0310},
	{"E", "acute",	 0311},
	{"acute", "E",	 0311},
	{"E", "apostrophe",		 0311},
	{"apostrophe", "E",		 0311},
	{"E", "asciicircum",		 0312},
	{"asciicircum", "E",		 0312},
	{"E", "greater",		 0312},
	{"greater", "E",		 0312},
	{"E", "quotedbl",		 0313},
	{"quotedbl", "E",		 0313},
	{"E", "diaeresis",		 0313},
	{"diaeresis", "E",		 0313},
	{"e", "grave",	 0350},
	{"grave", "e",	 0350},
	{"e", "acute",	 0351},
	{"acute", "e",	 0351},
	{"e", "apostrophe",		 0351},
	{"apostrophe", "e",		 0351},
	{"e", "asciicircum",		 0352},
	{"asciicircum", "e",		 0352},
	{"e", "greater",		 0352},
	{"greater", "e",		 0352},
	{"e", "quotedbl",		 0353},
	{"quotedbl", "e",		 0353},
	{"e", "diaeresis",		 0353},
	{"diaeresis", "e",		 0353},
	{"I", "grave",	 0314},
	{"grave", "I",	 0314},
	{"I", "acute",	 0315},
	{"acute", "I",	 0315},
	{"I", "apostrophe",		 0315},
	{"apostrophe", "I",		 0315},
	{"I", "asciicircum",		 0316},
	{"asciicircum", "I",		 0316},
	{"I", "greater",		 0316},
	{"greater", "I",		 0316},
	{"I", "quotedbl",		 0317},
	{"quotedbl", "I",		 0317},
	{"I", "diaeresis",		 0317},
	{"diaeresis", "I",		 0317},
	{"i", "grave",	 0354},
	{"grave", "i",	 0354},
	{"i", "acute",	 0355},
	{"acute", "i",	 0355},
	{"i", "apostrophe",		 0355},
	{"apostrophe", "i",		 0355},
	{"i", "asciicircum",		 0356},
	{"asciicircum", "i",		 0356},
	{"i", "greater",		 0356},
	{"greater", "i",		 0356},
	{"i", "quotedbl",		 0357},
	{"quotedbl", "i",		 0357},
	{"i", "diaeresis",		 0357},
	{"diaeresis", "i",		 0357},
	{"N", "asciitilde",		 0321},
	{"asciitilde", "N",		 0321},
	{"N", "minus",	 0321},
	{"minus", "N",	 0321},
	{"n", "asciitilde",		 0361},
	{"asciitilde", "n",		 0361},
	{"n", "minus",	 0361},
	{"minus", "n",	 0361},
	{"O", "grave",	 0322},
	{"grave", "O",	 0322},
	{"O", "acute",	 0323},
	{"acute", "O",	 0323},
	{"O", "apostrophe",		 0323},
	{"apostrophe", "O",		 0323},
	{"O", "asciicircum",		 0324},
	{"asciicircum", "O",		 0324},
	{"O", "greater",		 0324},
	{"greater", "O",		 0324},
	{"O", "asciitilde",		 0325},
	{"asciitilde", "O",		 0325},
	{"O", "minus",	 0325},
	{"minus", "O",	 0325},
	{"O", "quotedbl",		 0326},
	{"quotedbl", "O",		 0326},
	{"O", "diaeresis",		 0326},
	{"diaeresis", "O",		 0326},
	{"O", "slash",	 0330},
	{"slash", "O",	 0330},
	{"o", "grave",	 0362},
	{"grave", "o",	 0362},
	{"o", "acute",	 0363},
	{"acute", "o",	 0363},
	{"o", "apostrophe",		 0363},
	{"apostrophe", "o",		 0363},
	{"o", "asciicircum",		 0364},
	{"asciicircum", "o",		 0364},
	{"o", "greater",		 0364},
	{"greater", "o",		 0364},
	{"o", "asciitilde",		 0365},
	{"asciitilde", "o",		 0365},
	{"o", "minus",	 0365},
	{"minus", "o",	 0365},
	{"o", "quotedbl",		 0366},
	{"quotedbl", "o",		 0366},
	{"o", "diaeresis",		 0366},
	{"diaeresis", "o",		 0366},
	{"o", "slash",	 0370},
	{"slash", "o",	 0370},
	{"U", "grave",	 0331},
	{"grave", "U",	 0331},
	{"U", "acute",	 0332},
	{"acute", "U",	 0332},
	{"U", "apostrophe",		 0332},
	{"apostrophe", "U",		 0332},
	{"U", "asciicircum",		 0333},
	{"asciicircum", "U",		 0333},
	{"U", "greater",		 0333},
	{"greater", "U",		 0333},
	{"U", "quotedbl",		 0334},
	{"quotedbl", "U",		 0334},
	{"U", "diaeresis",		 0334},
	{"diaeresis", "U",		 0334},
	{"u", "grave",	 0371},
	{"grave", "u",	 0371},
	{"u", "acute",	 0372},
	{"acute", "u",	 0372},
	{"u", "apostrophe",		 0372},
	{"apostrophe", "u",		 0372},
	{"u", "asciicircum",		 0373},
	{"asciicircum", "u",		 0373},
	{"u", "greater",		 0373},
	{"greater", "u",		 0373},
	{"u", "quotedbl",		 0374},
	{"quotedbl", "u",		 0374},
	{"u", "diaeresis",		 0374},
	{"diaeresis", "u",		 0374},
	{"s", "s",	 0337},
	{"T", "H",	 0336},
	{"t", "h",	 0376},
	{"Y", "acute",	 0335},
	{"acute", "Y",	 0335},
	{"Y", "apostrophe",		 0335},
	{"apostrophe", "Y",		 0335},
	{"y", "acute",	 0375},
	{"acute", "y",	 0375},
	{"y", "apostrophe",		 0375},
	{"apostrophe", "y",		 0375},
	{"y", "quotedbl",		 0377},
	{"quotedbl", "y",		 0377},
	{"y", "diaeresis",		 0377},
	{"diaeresis", "y",		 0377},
// dead key accent keysyms
// Special Character
	{"dead_circumflex", "slash",		 '|'},
	{"dead_circumflex", "space",		 '^'},
	{"dead_circumflex", "dead_circumflex",	 '^'},
	{"dead_tilde", "space",	 '~'},
	{"dead_tilde", "dead_tilde",		 '~'},
	{"dead_grave", "space",	 '`'},
	{"dead_grave", "dead_grave",		 '`'},
// These are for us_intl, that does not have diaeresis, etc
	{"dead_acute", "space",	 '\''},
	{"dead_acute", "dead_acute",		 0264},
	{"dead_diaeresis", "space",		 '\"'},
	{"dead_diaeresis", "dead_diaeresis",	 0250},
	{"dead_doubleacute", "space",		 '\"'},
	{"dead_abovering", "space",		 0260},
	{"dead_abovering", "dead_abovering",	 0260},
	{"dead_circumflex", "0",	 0260},
	{"dead_circumflex", "1",	 0271},
	{"dead_circumflex", "2",	 0262},
	{"dead_circumflex", "3",	 0263},
	{"dead_circumflex", "period",		 0267},
	{"dead_circumflex", "exclam",		 0246},
	{"dead_cedilla", "minus",	 0254},
	{"dead_circumflex", "minus",		 0257},
	{"dead_circumflex", "underscore",		 0257},
	{"dead_acute", "apostrophe",		 0264},
	{"dead_cedilla", "comma",	 0270},
	{"dead_diaeresis", "quotedbl",		 0250},
// Accented Alphabet
	{"dead_abovering", "A",	 0305},
	{"dead_grave", "A",	 0300},
	{"dead_acute", "A",	 0301},
	{"dead_circumflex", "A",	 0302},
	{"dead_tilde", "A",	 0303},
	{"dead_diaeresis", "A",	 0304},
	{"dead_abovering", "a",	 0345},
	{"dead_grave", "a",	 0340},
	{"dead_acute", "a",	 0341},
	{"dead_circumflex", "a",	 0342},
	{"dead_tilde", "a",	 0343},
	{"dead_diaeresis", "a",	 0344},
	{"dead_cedilla", "C",	 0307},
	{"dead_cedilla", "c",	 0347},
	{"dead_grave", "E",	 0310},
	{"dead_acute", "E",	 0311},
	{"dead_circumflex", "E",	 0312},
	{"dead_diaeresis", "E",	 0313},
	{"dead_grave", "e",	 0350},
	{"dead_acute", "e",	 0351},
	{"dead_circumflex", "e",	 0352},
	{"dead_diaeresis", "e",	 0353},
	{"dead_grave", "I",	 0314},
	{"dead_acute", "I",	 0315},
	{"dead_circumflex", "I",	 0316},
	{"dead_diaeresis", "I",	 0317},
	{"dead_grave", "i",	 0354},
	{"dead_acute", "i",	 0355},
	{"dead_circumflex", "i",	 0356},
	{"dead_diaeresis", "i",	 0357},
	{"dead_tilde", "N",	 0321},
	{"dead_tilde", "n",	 0361},
	{"dead_grave", "O",	 0322},
	{"dead_acute", "O",	 0323},
	{"dead_circumflex", "O",	 0324},
	{"dead_tilde", "O",	 0325},
	{"dead_diaeresis", "O",	 0326},
	{"dead_grave", "o",	 0362},
	{"dead_acute", "o",	 0363},
	{"dead_circumflex", "o",	 0364},
	{"dead_tilde", "o",	 0365},
	{"dead_diaeresis", "o",	 0366},
	{"dead_grave", "U",	 0331},
	{"dead_acute", "U",	 0332},
	{"dead_circumflex", "U",	 0333},
	{"dead_doubleacute", "U",	 0334},
	{"dead_diaeresis", "U",	 0334},
	{"dead_grave", "u",	 0371},
	{"dead_acute", "u",	 0372},
	{"dead_circumflex", "u",	 0373},
	{"dead_doubleacute", "u",	 0374},
	{"dead_diaeresis", "u",	 0374},
	{"dead_acute", "Y",	 0335},
	{"dead_acute", "y",	 0375},
	{"dead_diaeresis", "y",	 0377},
// Useful for portuguese language
	{"dead_acute", "C",	 0307},
	{"dead_acute", "c",	 0347},
    {"","",0000}
};

}
