/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ASCIIPLUGIN_H
#define ASCIIPLUGIN_H

#include <cstdio>
#include <cstdlib>
#include <scim.h>
#include <scim_iconv.h>
#include <scim_attribute.h>

#include <honokamultiplepluginbase.h>
#include <honokasetupcore.h>

#include <wordsprediction.h>
#include <asciiinput.h>

#define HONOKA_CONFIG_WORDSPREDICTION_FILE          "/IMEngine/Honoka/WordsPrediction/WordsFile"
#define HONOKA_DEFAULT_WORDSPREDICTION_FILE         "/usr/share/dict/words"
#define HONOKA_CONFIG_WORDSPREDICTION_ADDSAW        "/IMEngine/Honoka/WordsPrediction/AddSpaceAfterWord"
#define HONOKA_DEFAULT_WORDSPREDICTION_ADDSAW       false
#define HONOKA_CONFIG_WORDSPREDICTION_LIMIT         "/IMEngine/Honoka/WordsPrediction/LimitOfResults"
#define HONOKA_DEFAULT_WORDSPREDICTION_LIMIT        20
#define HONOKA_CONFIG_ASCIIINPUT_LOW_PRIORITY_KEY   "/IMEngine/Honoka/AsciiInput/LowPriorityKey"
#define HONOKA_DEFAULT_ASCIIINPUT_LOW_PRIORITY_KEY  ""
#define HONOKA_CONFIG_ASCIIINPUT_AUTO_COMMIT_KEY    "/IMEngine/Honoka/AsciiInput/AutoCommitKey"
#define HONOKA_DEFAULT_ASCIIINPUT_AUTO_COMMIT_KEY   "space,comma,period"
#define HONOKA_CONFIG_ASCIIINPUT_AUTO_COMMIT        "/IMEngine/Honoka/AsciiInput/AutoCommit"
#define HONOKA_DEFAULT_ASCIIINPUT_AUTO_COMMIT       false
#define HONOKA_CONFIG_ASCIIINPUT_COMPOSE_KEY        "/IMEngine/Honoka/AsciiInput/ComposeKey"
#define HONOKA_DEFAULT_ASCIIINPUT_COMPOSE_KEY       ""
#define HONOKA_CONFIG_ASCIIINPUT_ABOVERING_KEY      "/IMEngine/Honoka/AsciiInput/DeadAboveringKey"
#define HONOKA_DEFAULT_ASCIIINPUT_ABOVERING_KEY     ""
#define HONOKA_CONFIG_ASCIIINPUT_ACUTE_KEY          "/IMEngine/Honoka/AsciiInput/DeadAcuteKey"
#define HONOKA_DEFAULT_ASCIIINPUT_ACUTE_KEY         ""
#define HONOKA_CONFIG_ASCIIINPUT_CEDILLA_KEY        "/IMEngine/Honoka/AsciiInput/DeadCedillaKey"
#define HONOKA_DEFAULT_ASCIIINPUT_CEDILLA_KEY       ""
#define HONOKA_CONFIG_ASCIIINPUT_CIRCUMFLEX_KEY     "/IMEngine/Honoka/AsciiInput/DeadCircumflexKey"
#define HONOKA_DEFAULT_ASCIIINPUT_CIRCUMFLEX_KEY    ""
#define HONOKA_CONFIG_ASCIIINPUT_DIAERESIS_KEY      "/IMEngine/Honoka/AsciiInput/DeadDiaeresisKey"
#define HONOKA_DEFAULT_ASCIIINPUT_DIAERESIS_KEY     ""
#define HONOKA_CONFIG_ASCIIINPUT_DOUBLEACUTE_KEY    "/IMEngine/Honoka/AsciiInput/DeadDoubleacuteKey"
#define HONOKA_DEFAULT_ASCIIINPUT_DOUBLEACUTE_KEY   ""
#define HONOKA_CONFIG_ASCIIINPUT_GRAVE_KEY          "/IMEngine/Honoka/AsciiInput/DeadGraveKey"
#define HONOKA_DEFAULT_ASCIIINPUT_GRAVE_KEY         ""
#define HONOKA_CONFIG_ASCIIINPUT_TILDE_KEY          "/IMEngine/Honoka/AsciiInput/DeadTildeKey"
#define HONOKA_DEFAULT_ASCIIINPUT_TILDE_KEY         ""

using namespace std;
using namespace scim;


/**
@author TAM (Teppei Tamra)
*/
namespace Honoka {

class AsciiPlugin;

class AsciiPlugin : public HonokaMultiplePluginBase {
public:
    AsciiPlugin(ConfigPointer cfg);

    ~AsciiPlugin();
    virtual HonokaPluginBase * getPluginInstanceAt(int p);
    virtual int getPluginCount();
    virtual String getName();
    static HonokaSetupCorePage *setup();

protected:
    WordsPrediction *predictor;
    AsciiInput *preeditor;
};
}
#endif
