
#==============================================================================#
# $Id: axis.rb,v 1.2 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/composite/axis.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/property/major_minor'
require 'grb/chart/base/property/font'

#==============================================================================#

module GRb

  module Chart

    class AxisProperty < PropertyBase

      def initialize
        @grid  = MajorMinorProperty.new(AxisGridProperty.new, AxisGridProperty.new)
        @tics  = MajorMinorProperty.new(AxisTicsProperty.new, AxisTicsProperty.new)
        @label = AxisLabelProperty.new
      end

      attr_reader :grid, :tics, :label

      class AxisGridProperty < PropertyBase

        def initialize
          @visible = nil
          @color   = nil
        end

        attr_accessor :visible, :color

      end # AxisGridProperty

      class AxisTicsProperty < PropertyBase

        def initialize
          @visible = nil
          @color   = nil
          @size    = nil
          @inside  = nil
          @outside = nil
        end

        attr_accessor :visible, :color, :size, :inside, :outside

      end # AxisTicsProperty

      class AxisLabelProperty < PropertyBase

        def initialize
          @visible = nil
          @text    = nil
          @font    = FontProperty.new
        end

        attr_accessor :visible, :text
        attr_reader   :font

      end # AxisLabelProperty

    end # AxisProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
