
#==============================================================================#
# $Id: gradation.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/gradation.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/singular_base'

#==============================================================================#

module GRb

  module Chart

    class GradationDecorator < SingularDecoratorBase

      def initialize(child = nil)
        super(child)

        @color_start = GRb::Color.new(0, 0, 0)
        @color_end   = GRb::Color.new(255, 255, 255)
        @direction   = 0
        @opacity     = 100
      end

      attr_accessor :color_start, :color_end, :direction, :opacity

      def draw_self(image, box)
        image.gradation(box.x, box.y, box.x2, box.y2, @color_start, @color_end, @direction, @opacity)
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end # GradationDecorator

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
