#! /usr/bin/ruby

#==============================================================================#
# $Id: font.rb,v 1.4 2004/01/23 23:13:51 yuya Exp $
#==============================================================================#

require 'grb/grb'

#==============================================================================#

img = GRb::Image.create(300, 200)

grid  = GRb::Color.new(208, 208, 208)
red   = GRb::Color.red(128)
green = GRb::Color.green(128)
blue  = GRb::Color.blue(128)

0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

img.string(GRb::Font::Giant,            20, 20, 0, red, "Giant")
img.string(GRb::Font::BoldGiant,        80, 20, 0, red, "Giant")
img.string(GRb::Font::ItalicGiant,     140, 20, 0, red, "Giant")
img.string(GRb::Font::BoldItalicGiant, 200, 20, 0, red, "Giant")

img.string(GRb::Font::Large,            20, 40, 0, red, "Large")
img.string(GRb::Font::BoldLarge,        80, 40, 0, red, "Large")
img.string(GRb::Font::ItalicLarge,     140, 40, 0, red, "Large")
img.string(GRb::Font::BoldItalicLarge, 200, 40, 0, red, "Large")

img.string(GRb::Font::Medium,            20, 60, 0, red, "Medium")
img.string(GRb::Font::BoldMedium,        80, 60, 0, red, "Medium")
img.string(GRb::Font::ItalicMedium,     140, 60, 0, red, "Medium")
img.string(GRb::Font::BoldItalicMedium, 200, 60, 0, red, "Medium")

img.string(GRb::Font::Small,            20, 80, 0, red, "Small")
img.string(GRb::Font::BoldSmall,        80, 80, 0, red, "Small")
img.string(GRb::Font::ItalicSmall,     140, 80, 0, red, "Small")
img.string(GRb::Font::BoldItalicSmall, 200, 80, 0, red, "Small")

img.string(GRb::Font::Tiny,            20, 100, 0, red, "Tiny")
img.string(GRb::Font::BoldTiny,        80, 100, 0, red, "Tiny")
img.string(GRb::Font::ItalicTiny,     140, 100, 0, red, "Tiny")
img.string(GRb::Font::BoldItalicTiny, 200, 100, 0, red, "Tiny")

ttf = GRb::Font.truetype('/cygdrive/c/WINDOWS/Fonts/CENTURY.TTF', 26)
img.string(ttf, 20, 140, 0, red, "TrueType Font")

img.write_png_file('font.png')

#==============================================================================#
#==============================================================================#
