#! /usr/bin/ruby

#==============================================================================#
# $Id: arc.rb,v 1.3 2004/01/13 05:35:22 yuya Exp $
#==============================================================================#

require 'grb/grb'

#==============================================================================#

img = GRb::Image.create(300, 200)

grid  = GRb::Color.new(208, 208, 208)
red   = GRb::Color.red(128)
green = GRb::Color.green(128)
blue  = GRb::Color.blue(128)

0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

img.circle( 30, 25, 40, 30, :color => green, :width => 1)
img.circle( 90, 25, 40, 30, :color => green, :width => 2)
img.circle(150, 25, 40, 30, :color => green, :width => 3)
img.circle(210, 25, 40, 30, :color => green, :width => 4)
img.circle(270, 25, 40, 30, :color => green, :width => 5)

img.arc( 30, 25, 40, 30,   0,  72, {:color => red, :width => 1}, {:color => blue})
img.arc( 90, 25, 40, 30,  72, 144, {:color => red, :width => 2}, {:color => blue})
img.arc(150, 25, 40, 30, 144, 216, {:color => red, :width => 3}, {:color => blue})
img.arc(210, 25, 40, 30, 216, 288, {:color => red, :width => 4}, {:color => blue})
img.arc(270, 25, 40, 30, 288, 360, {:color => red, :width => 5}, {:color => blue})

img.circle( 30, 75, 40, 30, :color => red, :width => 5, :opacity => 100)
img.circle( 90, 75, 40, 30, :color => red, :width => 5, :opacity =>  80)
img.circle(150, 75, 40, 30, :color => red, :width => 5, :opacity =>  60)
img.circle(210, 75, 40, 30, :color => red, :width => 5, :opacity =>  40)
img.circle(270, 75, 40, 30, :color => red, :width => 5, :opacity =>  20)

img.circle( 30, 125, 40, 30, nil, :color => blue, :opacity => 100)
img.circle( 90, 125, 40, 30, nil, :color => blue, :opacity =>  80)
img.circle(150, 125, 40, 30, nil, :color => blue, :opacity =>  60)
img.circle(210, 125, 40, 30, nil, :color => blue, :opacity =>  40)
img.circle(270, 125, 40, 30, nil, :color => blue, :opacity =>  20)

img.circle( 30, 175, 40, 30, {:color => red, :width => 3, :pattern => [5, 25], :opacity => 100}, {:color => blue, :opacity => 100})
img.circle( 90, 175, 40, 30, {:color => red, :width => 3, :pattern => [5, 25], :opacity =>  80}, {:color => blue, :opacity =>  80})
img.circle(150, 175, 40, 30, {:color => red, :width => 3, :pattern => [5, 25], :opacity =>  60}, {:color => blue, :opacity =>  60})
img.circle(210, 175, 40, 30, {:color => red, :width => 3, :pattern => [5, 25], :opacity =>  40}, {:color => blue, :opacity =>  40})
img.circle(270, 175, 40, 30, {:color => red, :width => 3, :pattern => [5, 25], :opacity =>  20}, {:color => blue, :opacity =>  20})

img.write_png_file('arc.png')

#==============================================================================#
#==============================================================================#
