/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     LABEL = 258,
     IDENTIFIER = 259,
     CBLOCK = 260,
     DEBUG_LINE = 261,
     ENDC = 262,
     ERRORLEVEL = 263,
     FILL = 264,
     LIST = 265,
     NUMBER = 266,
     PROCESSOR = 267,
     STRING = 268,
     INCLUDE = 269,
     UPPER = 270,
     HIGH = 271,
     LOW = 272,
     LSH = 273,
     RSH = 274,
     GREATER_EQUAL = 275,
     LESS_EQUAL = 276,
     EQUAL = 277,
     NOT_EQUAL = 278,
     LOGICAL_AND = 279,
     LOGICAL_OR = 280,
     ASSIGN_PLUS = 281,
     ASSIGN_MINUS = 282,
     ASSIGN_MULTIPLY = 283,
     ASSIGN_DIVIDE = 284,
     ASSIGN_MODULUS = 285,
     ASSIGN_LSH = 286,
     ASSIGN_RSH = 287,
     ASSIGN_AND = 288,
     ASSIGN_OR = 289,
     ASSIGN_XOR = 290,
     INCREMENT = 291,
     DECREMENT = 292,
     TBL_NO_CHANGE = 293,
     TBL_POST_INC = 294,
     TBL_POST_DEC = 295,
     TBL_PRE_INC = 296,
     CONCAT = 297,
     VAR = 298,
     VARLAB_BEGIN = 299,
     VAR_BEGIN = 300,
     VAR_END = 301
   };
#endif
#define LABEL 258
#define IDENTIFIER 259
#define CBLOCK 260
#define DEBUG_LINE 261
#define ENDC 262
#define ERRORLEVEL 263
#define FILL 264
#define LIST 265
#define NUMBER 266
#define PROCESSOR 267
#define STRING 268
#define INCLUDE 269
#define UPPER 270
#define HIGH 271
#define LOW 272
#define LSH 273
#define RSH 274
#define GREATER_EQUAL 275
#define LESS_EQUAL 276
#define EQUAL 277
#define NOT_EQUAL 278
#define LOGICAL_AND 279
#define LOGICAL_OR 280
#define ASSIGN_PLUS 281
#define ASSIGN_MINUS 282
#define ASSIGN_MULTIPLY 283
#define ASSIGN_DIVIDE 284
#define ASSIGN_MODULUS 285
#define ASSIGN_LSH 286
#define ASSIGN_RSH 287
#define ASSIGN_AND 288
#define ASSIGN_OR 289
#define ASSIGN_XOR 290
#define INCREMENT 291
#define DECREMENT 292
#define TBL_NO_CHANGE 293
#define TBL_POST_INC 294
#define TBL_POST_DEC 295
#define TBL_PRE_INC 296
#define CONCAT 297
#define VAR 298
#define VARLAB_BEGIN 299
#define VAR_BEGIN 300
#define VAR_END 301




/* Copy the first part of user declarations.  */
#line 1 "parse.y"

/* Parser for gpasm
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005
   James Bowman, Craig Franklin

This file is part of gputils.

gputils is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gputils is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gputils; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "libgputils.h"
#include "gpasm.h"
#include "evaluate.h"
#include "gperror.h"
#include "directive.h"
#include "lst.h"
#include "macro.h"
#include "coff.h"
#include "scan.h"

void yyerror(char *message)
{
  gperror(103, message);
}

int yylex(void);
extern int _16bit_core;

/************************************************************************/

/* Some simple functions for building parse trees */

static struct pnode *mk_pnode(enum pnode_tag tag)
{
  struct pnode *new = malloc(sizeof(*new));
  new->tag = tag;
  return new;
}

struct pnode *mk_constant(int value)
{
  struct pnode *new = mk_pnode(constant);
  new->value.constant = value;
  return new;
}

struct pnode *mk_offset(struct pnode *p)
{
  struct pnode *new = mk_pnode(offset);
  new->value.offset = p;
  return new;
}

static struct pnode *mk_symbol(char *value)
{
  struct pnode *new = mk_pnode(symbol);
  new->value.symbol = value;
  return new;
}

static struct pnode *mk_string(char *value)
{
  struct pnode *new = mk_pnode(string);
  new->value.string = value;
  return new;
}

struct pnode *mk_list(struct pnode *head, struct pnode *tail)
{
  struct pnode *new = mk_pnode(list);
  new->value.list.head = head;
  new->value.list.tail = tail;
  return new;
}

static struct pnode *mk_2op(int op, struct pnode *p0, struct pnode *p1)
{
  struct pnode *new = mk_pnode(binop);
  new->value.binop.op = op;
  new->value.binop.p0 = p0;
  new->value.binop.p1 = p1;
  return new;
}

static struct pnode *mk_1op(int op, struct pnode *p0)
{
  struct pnode *new = mk_pnode(unop);  new->value.unop.op = op;
  new->value.unop.p0 = p0;
  return new;
}

/************************************************************************/
/* shared functions */

gpasmVal set_label(char *label, struct pnode *parms)
{
  gpasmVal value = 0;

  if (asm_enabled()) {
    value = do_or_append_insn("set", parms);
    if (!state.mac_prev) {
      set_global(label, value, TEMPORARY, gvt_constant);
    }
  }

  return value;
}

int return_op(int operation) 
{
  /* returns an operator for the replacement of i+=1 with i=i+1*/
  switch(operation) {
  case ASSIGN_PLUS:     return '+';
  case ASSIGN_MINUS:    return '-';
  case ASSIGN_MULTIPLY: return '*';
  case ASSIGN_DIVIDE:   return '/';
  case ASSIGN_MODULUS:  return '%';
  case ASSIGN_LSH:      return LSH;
  case ASSIGN_RSH:      return RSH;
  case ASSIGN_AND:      return '&';
  case ASSIGN_OR:       return '|';
  case ASSIGN_XOR:      return '^'; 
  default:
    assert(0); /* Unhandled operator */ 
  }

  return 0;
}

void next_line(int value)
{
  char l[BUFSIZ];
  char *e = l;

  if ((state.src->type == src_macro) || 
      (state.src->type == src_while)) {
    /* while loops can be defined inside a macro or nested */
    if (state.mac_prev) {
      state.lst.line.linetype = none;
      if (state.mac_body)
	state.mac_body->src_line = strdup(state.src->lst.m->src_line);
    }

    if (((state.src->type == src_while) || (state.lst.expand)) &&
        (state.pass == 2)) {
      assert(state.src->lst.m->src_line != NULL);
      lst_format_line(state.src->lst.m->src_line, value);
    }
    
    if (state.src->lst.m->next) {
      state.src->lst.m = state.src->lst.m->next;
    }
  } else if ((state.src->type == src_file) &&
             (state.src->lst.f != NULL)) {
    fgets(l, BUFSIZ, state.src->lst.f);
    l[strlen(l) - 1] = '\0';	/* Eat the trailing newline */

    if (state.mac_prev) {
      state.lst.line.linetype = none;
      if (state.mac_body)
	state.mac_body->src_line = strdup(l);
    }

    if (state.pass == 2) {
      lst_format_line(e, value);
    }
  }

  state.src->line_number++;

  switch (state.next_state) {
    case state_exitmacro:
      execute_exitm();
      break;

    case state_include:
      open_src(state.next_buffer.file, 1);
      free(state.next_buffer.file);
      break;

    case state_macro:
      /* push the label for local directive */
      state.stTop = push_macro_symbol_table(state.stTop);
      execute_macro(state.next_buffer.macro, 0);
      break;

    case state_section:
      /* create a new coff section */
      coff_new_section(state.obj.new_sec_name, 
                       state.obj.new_sec_addr, 
                       state.obj.new_sec_flags);
      break;

    case state_while:
      execute_macro(state.next_buffer.macro, 1);
      break;

    default:
      break;
  }
 
}


/************************************************************************/



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 225 "parse.y"
typedef union YYSTYPE {
  gpasmVal i;
  char *s;
  struct pnode *p;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 396 "parse.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 408 "parse.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   413

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  68
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  42
/* YYNRULES -- Number of rules. */
#define YYNRULES  120
/* YYNRULES -- Number of states. */
#define YYNSTATES  181

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   301

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      62,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    60,     2,     2,    66,    59,    26,     2,
      67,    63,    57,    55,    64,    56,     2,    58,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    65,     2,
      24,    31,    25,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    53,     2,    54,    28,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    27,     2,    61,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    29,
      30,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     5,     9,    13,    18,    23,    27,
      31,    34,    36,    38,    40,    42,    45,    46,    51,    54,
      55,    60,    61,    66,    69,    73,    80,    88,    89,    97,
      98,   105,   110,   111,   114,   116,   119,   122,   126,   128,
     132,   134,   138,   140,   142,   144,   146,   148,   150,   152,
     154,   156,   158,   160,   163,   167,   169,   171,   173,   177,
     179,   181,   185,   187,   189,   193,   195,   197,   201,   203,
     205,   207,   209,   213,   215,   217,   219,   221,   223,   225,
     227,   231,   233,   235,   237,   241,   243,   245,   247,   251,
     253,   255,   257,   259,   262,   264,   266,   268,   270,   272,
     274,   276,   278,   280,   282,   286,   290,   292,   294,   296,
     298,   300,   304,   308,   310,   314,   318,   320,   324,   325,
     330
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      69,     0,    -1,    -1,    -1,    69,    70,    71,    -1,    69,
       1,    62,    -1,   106,    83,    85,    62,    -1,   106,    31,
      85,    62,    -1,   106,    43,    62,    -1,   106,    42,    62,
      -1,   106,    73,    -1,    73,    -1,     8,    -1,     6,    -1,
      62,    -1,    14,    62,    -1,    -1,    12,    74,     4,    62,
      -1,    10,    62,    -1,    -1,    10,    75,   107,    62,    -1,
      -1,    72,    76,    84,    62,    -1,     4,    62,    -1,     4,
      84,    62,    -1,     9,     4,    63,    64,    85,    62,    -1,
       9,     4,    84,    63,    64,    85,    62,    -1,    -1,     5,
      85,    62,    77,    79,     7,    62,    -1,    -1,     5,    62,
      78,    79,     7,    62,    -1,     5,     1,     7,    62,    -1,
      -1,    79,    80,    -1,    62,    -1,    81,    62,    -1,   106,
      62,    -1,   106,    85,    62,    -1,    82,    -1,    81,    64,
      82,    -1,   105,    -1,   105,    65,    85,    -1,    32,    -1,
      33,    -1,    34,    -1,    35,    -1,    36,    -1,    37,    -1,
      38,    -1,    39,    -1,    40,    -1,    41,    -1,    85,    -1,
      85,    64,    -1,    85,    64,    84,    -1,    86,    -1,    13,
      -1,    88,    -1,    86,    87,    88,    -1,    31,    -1,    90,
      -1,    88,    89,    90,    -1,    30,    -1,    92,    -1,    90,
      91,    92,    -1,    29,    -1,    94,    -1,    92,    93,    94,
      -1,    26,    -1,    27,    -1,    28,    -1,    96,    -1,    94,
      95,    96,    -1,    24,    -1,    25,    -1,    22,    -1,    23,
      -1,    20,    -1,    21,    -1,    98,    -1,    96,    97,    98,
      -1,    18,    -1,    19,    -1,   100,    -1,    98,    99,   100,
      -1,    55,    -1,    56,    -1,   102,    -1,   100,   101,   102,
      -1,    57,    -1,    58,    -1,    59,    -1,   104,    -1,   103,
     104,    -1,    15,    -1,    16,    -1,    17,    -1,    56,    -1,
      60,    -1,    61,    -1,    55,    -1,   105,    -1,    11,    -1,
      66,    -1,    67,    85,    63,    -1,    53,    85,    54,    -1,
      57,    -1,    45,    -1,    46,    -1,    47,    -1,     4,    -1,
      51,    85,    63,    -1,    51,    85,    52,    -1,     3,    -1,
      50,    85,    63,    -1,    50,    85,    52,    -1,   108,    -1,
     108,    64,   107,    -1,    -1,     4,   109,    87,    88,    -1,
      88,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   324,   324,   328,   327,   333,   340,   352,   361,   370,
     379,   444,   456,   456,   459,   468,   473,   473,   480,   485,
     485,   492,   492,   499,   504,   509,   525,   542,   541,   560,
     559,   575,   581,   583,   590,   592,   599,   608,   619,   621,
     625,   632,   640,   640,   640,   641,   641,   641,   641,   642,
     642,   642,   645,   650,   656,   663,   665,   672,   674,   680,
     683,   685,   691,   694,   696,   702,   705,   707,   713,   713,
     713,   716,   718,   724,   724,   724,   724,   724,   724,   727,
     729,   735,   735,   738,   740,   746,   746,   749,   751,   757,
     757,   757,   760,   762,   768,   768,   768,   768,   768,   768,
     768,   771,   776,   781,   786,   791,   796,   801,   806,   811,
     818,   823,   828,   836,   841,   849,   859,   864,   872,   871,
     883
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LABEL", "IDENTIFIER", "CBLOCK",
  "DEBUG_LINE", "ENDC", "ERRORLEVEL", "FILL", "LIST", "NUMBER",
  "PROCESSOR", "STRING", "INCLUDE", "UPPER", "HIGH", "LOW", "LSH", "RSH",
  "GREATER_EQUAL", "LESS_EQUAL", "EQUAL", "NOT_EQUAL", "'<'", "'>'", "'&'",
  "'|'", "'^'", "LOGICAL_AND", "LOGICAL_OR", "'='", "ASSIGN_PLUS",
  "ASSIGN_MINUS", "ASSIGN_MULTIPLY", "ASSIGN_DIVIDE", "ASSIGN_MODULUS",
  "ASSIGN_LSH", "ASSIGN_RSH", "ASSIGN_AND", "ASSIGN_OR", "ASSIGN_XOR",
  "INCREMENT", "DECREMENT", "TBL_NO_CHANGE", "TBL_POST_INC",
  "TBL_POST_DEC", "TBL_PRE_INC", "CONCAT", "VAR", "VARLAB_BEGIN",
  "VAR_BEGIN", "VAR_END", "'['", "']'", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'!'", "'~'", "'\\n'", "')'", "','", "':'", "'$'", "'('", "$accept",
  "program", "@1", "line", "decimal_ops", "statement", "@2", "@3", "@4",
  "@5", "@6", "const_block", "const_line", "const_def_list", "const_def",
  "assign_equal_ops", "parameter_list", "expr", "e9", "e9op", "e8", "e8op",
  "e7", "e7op", "e6", "e6op", "e5", "e5op", "e4", "e4op", "e3", "e3op",
  "e2", "e2op", "e1", "e1op", "e0", "cidentifier", "label_concat",
  "list_block", "list_expr", "@7", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    60,    62,    38,   124,    94,   279,
     280,    61,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,    91,    93,    43,    45,    42,    47,    37,
      33,   126,    10,    41,    44,    58,    36,    40
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    68,    69,    70,    69,    69,    71,    71,    71,    71,
      71,    71,    72,    72,    73,    73,    74,    73,    73,    75,
      73,    76,    73,    73,    73,    73,    73,    77,    73,    78,
      73,    73,    79,    79,    80,    80,    80,    80,    81,    81,
      82,    82,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    84,    84,    84,    85,    85,    86,    86,    87,
      88,    88,    89,    90,    90,    91,    92,    92,    93,    93,
      93,    94,    94,    95,    95,    95,    95,    95,    95,    96,
      96,    97,    97,    98,    98,    99,    99,   100,   100,   101,
     101,   101,   102,   102,   103,   103,   103,   103,   103,   103,
     103,   104,   104,   104,   104,   104,   104,   104,   104,   104,
     105,   105,   105,   106,   106,   106,   107,   107,   109,   108,
     108
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     0,     3,     3,     4,     4,     3,     3,
       2,     1,     1,     1,     1,     2,     0,     4,     2,     0,
       4,     0,     4,     2,     3,     6,     7,     0,     7,     0,
       6,     4,     0,     2,     1,     2,     2,     3,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     3,     1,
       1,     3,     1,     1,     3,     1,     1,     3,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     1,     1,     1,     1,
       1,     3,     3,     1,     3,     3,     1,     3,     0,     4,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     1,     0,     0,     5,   113,     0,     0,    13,
      12,     0,    19,    16,     0,     0,    14,     4,    21,    11,
       0,   110,   102,    56,    94,    95,    96,   107,   108,   109,
       0,     0,   100,    97,   106,    98,    99,    23,   103,     0,
       0,    52,    55,    57,    60,    63,    66,    71,    79,    83,
      87,     0,    92,   101,     0,    29,     0,     0,    18,     0,
       0,    15,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,     0,     0,    10,     0,     0,
       0,     0,    24,    53,    59,     0,    62,     0,    65,     0,
      68,    69,    70,     0,    77,    78,    75,    76,    73,    74,
       0,    81,    82,     0,    85,    86,     0,    89,    90,    91,
       0,    93,     0,    32,    27,     0,     0,   110,   120,     0,
     116,     0,   115,   114,     0,     0,     9,     8,     0,   112,
     111,   105,   104,    54,    58,    61,    64,    67,    72,    80,
      84,    88,    31,     0,    32,     0,     0,     0,    20,     0,
      17,    22,     7,     6,     0,    34,    33,     0,    38,    40,
       0,     0,     0,     0,     0,   117,    30,    35,     0,     0,
      36,     0,     0,    25,     0,   119,    39,    41,    37,    28,
      26
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     4,    17,    18,    19,    60,    59,    63,   144,
     113,   143,   156,   157,   158,    78,    40,    41,    42,    85,
      43,    87,    44,    89,    45,    93,    46,   100,    47,   103,
      48,   106,    49,   110,    50,    51,    52,    53,   160,   119,
     120,   147
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -133
static const short yypact[] =
{
    -133,   319,  -133,   -48,    91,  -133,  -133,    26,     2,  -133,
    -133,    17,   -27,  -133,   -24,   186,  -133,  -133,  -133,  -133,
     351,  -133,  -133,  -133,  -133,  -133,  -133,  -133,  -133,  -133,
     186,   186,  -133,  -133,  -133,  -133,  -133,  -133,  -133,   186,
     -22,   -20,    19,    22,    25,    -2,    88,    27,     5,   -25,
    -133,   234,  -133,  -133,    58,  -133,     4,   103,  -133,   203,
      63,  -133,   -47,   186,   186,  -133,  -133,  -133,  -133,  -133,
    -133,  -133,  -133,  -133,  -133,    14,    18,  -133,   186,   -43,
      30,    35,  -133,   186,  -133,   251,  -133,   251,  -133,   251,
    -133,  -133,  -133,   251,  -133,  -133,  -133,  -133,  -133,  -133,
     251,  -133,  -133,   251,  -133,  -133,   251,  -133,  -133,  -133,
     251,  -133,    23,  -133,  -133,    38,    41,    59,    22,    53,
      60,    55,  -133,  -133,    61,    64,  -133,  -133,    65,  -133,
    -133,  -133,  -133,  -133,    22,    25,    -2,    88,    27,     5,
     -25,  -133,  -133,    71,  -133,   186,    66,    19,  -133,   203,
    -133,  -133,  -133,  -133,    67,  -133,  -133,   -52,  -133,    24,
     127,   172,    70,   186,   251,  -133,  -133,  -133,     0,   186,
    -133,    72,    73,  -133,    74,    22,  -133,  -133,  -133,  -133,
    -133
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -133,  -133,  -133,  -133,  -133,   105,  -133,  -133,  -133,  -133,
    -133,   -16,  -133,  -133,   -29,  -133,   -55,    -8,  -133,    -1,
     -58,  -133,    75,  -133,    56,  -133,    54,  -133,    51,  -133,
      62,  -133,    79,  -133,    47,  -133,   116,  -132,   164,    28,
    -133,  -133
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -119
static const short yytable[] =
{
      56,   118,   116,    54,    21,   122,    21,    62,   124,   129,
     167,   159,   168,    22,     5,    23,   123,    24,    25,    26,
     130,    57,    79,    80,    90,    91,    92,   134,   133,   159,
      21,    81,   107,   108,   109,    58,   159,    22,    61,    23,
      82,    24,    25,    26,    83,   101,   102,    27,    28,    29,
      84,    30,    86,    30,    88,    31,   125,    32,    33,    34,
     104,   105,    35,    36,    55,   112,   114,   121,    38,    39,
     128,    27,    28,    29,     6,    21,   126,    30,   154,    31,
     127,    32,    33,    34,   131,   142,    35,    36,    37,   169,
    -118,   118,    38,    39,     6,     7,     8,     9,   132,    10,
      11,    12,   145,    13,   146,    14,   175,    21,    94,    95,
      96,    97,    98,    99,    22,   148,    23,   150,    24,    25,
      26,    15,    30,   151,   149,    77,   152,   153,   161,   166,
     163,    21,   173,   155,   178,   179,   180,   162,    22,   176,
      23,    15,    24,    25,    26,   136,   164,   137,    27,    28,
      29,   138,   171,    16,    30,   174,    31,   141,    32,    33,
      34,   177,   135,    35,    36,   139,   115,   111,    20,    38,
      39,     0,    27,    28,    29,     6,    21,   165,    30,   172,
      31,     0,    32,    33,    34,   140,     0,    35,    36,   170,
      21,     0,     0,    38,    39,     0,     0,    22,     0,    23,
       0,    24,    25,    26,     0,     0,     0,   117,     0,     0,
       0,     0,     0,     0,    22,     0,     0,     0,    24,    25,
      26,     0,    15,    30,     0,     0,     0,     0,     0,     0,
       0,    27,    28,    29,   155,     0,     0,    30,    21,    31,
       0,    32,    33,    34,     0,    22,    35,    36,    27,    28,
      29,     0,    38,    39,    30,    21,    31,     0,    32,    33,
      34,     0,    22,    35,    36,     0,    24,    25,    26,    38,
      39,     0,     0,     0,     0,     0,     0,     0,     0,    27,
      28,    29,     0,     0,     0,    30,     0,    31,     0,     0,
       0,    34,     0,     0,     0,     0,    27,    28,    29,     0,
      38,    39,    30,     0,    31,     0,    32,    33,    34,     0,
       0,    35,    36,     0,     0,     0,     0,    38,    39,     2,
       3,     0,    -3,    -3,    -3,    -3,     0,    -3,    -3,    -3,
       0,    -3,     0,    -3,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     8,     9,     0,    10,
      11,    12,     0,    13,     0,    14,     0,     0,     0,    -3,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    -3,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    16
};

static const short yycheck[] =
{
       8,    59,    57,     1,     4,    52,     4,    15,    63,    52,
      62,   143,    64,    11,    62,    13,    63,    15,    16,    17,
      63,     4,    30,    31,    26,    27,    28,    85,    83,   161,
       4,    39,    57,    58,    59,    62,   168,    11,    62,    13,
      62,    15,    16,    17,    64,    18,    19,    45,    46,    47,
      31,    51,    30,    51,    29,    53,    64,    55,    56,    57,
      55,    56,    60,    61,    62,     7,    62,     4,    66,    67,
      78,    45,    46,    47,     3,     4,    62,    51,     7,    53,
      62,    55,    56,    57,    54,    62,    60,    61,    62,    65,
      31,   149,    66,    67,     3,     4,     5,     6,    63,     8,
       9,    10,    64,    12,    63,    14,   164,     4,    20,    21,
      22,    23,    24,    25,    11,    62,    13,    62,    15,    16,
      17,    50,    51,    62,    64,    20,    62,    62,   144,    62,
      64,     4,    62,    62,    62,    62,    62,   145,    11,   168,
      13,    50,    15,    16,    17,    89,   147,    93,    45,    46,
      47,   100,   160,    62,    51,   163,    53,   110,    55,    56,
      57,   169,    87,    60,    61,   103,    63,    51,     4,    66,
      67,    -1,    45,    46,    47,     3,     4,   149,    51,     7,
      53,    -1,    55,    56,    57,   106,    -1,    60,    61,    62,
       4,    -1,    -1,    66,    67,    -1,    -1,    11,    -1,    13,
      -1,    15,    16,    17,    -1,    -1,    -1,     4,    -1,    -1,
      -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,    15,    16,
      17,    -1,    50,    51,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    62,    -1,    -1,    51,     4,    53,
      -1,    55,    56,    57,    -1,    11,    60,    61,    45,    46,
      47,    -1,    66,    67,    51,     4,    53,    -1,    55,    56,
      57,    -1,    11,    60,    61,    -1,    15,    16,    17,    66,
      67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    -1,    -1,    -1,    51,    -1,    53,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    45,    46,    47,    -1,
      66,    67,    51,    -1,    53,    -1,    55,    56,    57,    -1,
      -1,    60,    61,    -1,    -1,    -1,    -1,    66,    67,     0,
       1,    -1,     3,     4,     5,     6,    -1,     8,     9,    10,
      -1,    12,    -1,    14,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,     5,     6,    -1,     8,
       9,    10,    -1,    12,    -1,    14,    -1,    -1,    -1,    50,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    62
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    69,     0,     1,    70,    62,     3,     4,     5,     6,
       8,     9,    10,    12,    14,    50,    62,    71,    72,    73,
     106,     4,    11,    13,    15,    16,    17,    45,    46,    47,
      51,    53,    55,    56,    57,    60,    61,    62,    66,    67,
      84,    85,    86,    88,    90,    92,    94,    96,    98,   100,
     102,   103,   104,   105,     1,    62,    85,     4,    62,    75,
      74,    62,    85,    76,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    73,    83,    85,
      85,    85,    62,    64,    31,    87,    30,    89,    29,    91,
      26,    27,    28,    93,    20,    21,    22,    23,    24,    25,
      95,    18,    19,    97,    55,    56,    99,    57,    58,    59,
     101,   104,     7,    78,    62,    63,    84,     4,    88,   107,
     108,     4,    52,    63,    84,    85,    62,    62,    85,    52,
      63,    54,    63,    84,    88,    90,    92,    94,    96,    98,
     100,   102,    62,    79,    77,    64,    63,   109,    62,    64,
      62,    62,    62,    62,     7,    62,    80,    81,    82,   105,
     106,    79,    85,    64,    87,   107,    62,    62,    64,    65,
      62,    85,     7,    62,    85,    88,    82,    85,    62,    62,
      62
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 328 "parse.y"
    { 
          state.lst.line.was_org = state.org; 
          state.lst.line.linetype = none; 
          state.next_state = state_nochange;
        }
    break;

  case 5:
#line 334 "parse.y"
    { 
	  next_line(0);
	}
    break;

  case 6:
#line 341 "parse.y"
    {
	  struct pnode *parms;
	  int exp_result;

          exp_result = do_insn("set", mk_list(yyvsp[-1].p, NULL));          
          parms = mk_list(mk_2op(return_op(yyvsp[-2].i), 
                                 mk_symbol(yyvsp[-3].s), 
                                 mk_constant(exp_result)), NULL);
	  next_line(set_label(yyvsp[-3].s, parms));
	}
    break;

  case 7:
#line 353 "parse.y"
    {
	  struct pnode *parms;

	  /* implements i = 6 + 1 */           
	  parms = mk_list(yyvsp[-1].p, NULL);
	  next_line(set_label(yyvsp[-3].s, parms));
	}
    break;

  case 8:
#line 362 "parse.y"
    {
	  struct pnode *parms;

	  /* implements i-- */           
	  parms = mk_list(mk_1op(DECREMENT, mk_symbol(yyvsp[-2].s)), NULL);
	  next_line(set_label(yyvsp[-2].s, parms));
	}
    break;

  case 9:
#line 371 "parse.y"
    {
          struct pnode *parms;

	  /* implements i++ */          
	  parms = mk_list(mk_1op(INCREMENT, mk_symbol(yyvsp[-2].s)), NULL);
	  next_line(set_label(yyvsp[-2].s, parms));
	}
    break;

  case 10:
#line 380 "parse.y"
    {
	  if (asm_enabled() && (state.lst.line.linetype == none))
	    state.lst.line.linetype = insn;
	  
	  if (asm_enabled()) {
	    if (state.mac_head) {
	      /* This is a macro definition.  Set it up */
	      struct symbol *mac;
	      struct macro_head *h = NULL;

	      mac = get_symbol(state.stMacros, yyvsp[-1].s);
	      if (mac)
		h = get_symbol_annotation(mac);

	      /* It's not an error if macro was defined on pass 1 and
		 we're in pass 2. */
	      if (h &&
		  !((h->pass == 1) && (state.pass == 2))) {
		gperror(GPE_DUPLICATE_MACRO, NULL);
	      } else {
		if (!mac)
		  mac = add_symbol(state.stMacros, yyvsp[-1].s);
		annotate_symbol(mac, state.mac_head);
		h = state.mac_head;
		h->line_number = state.src->line_number;
		h->file_symbol = state.src->file_symbol;
	      }
	      h->pass = state.pass;
 	      
	      /* The macro is defined so allow calls. */
	      if (state.pass == 2)
	        h->defined = 1;

	      state.mac_head = NULL;
	    } else if (!state.mac_prev) {
	      /* Outside a macro, just define the label. */
	      switch (state.lst.line.linetype) {
	      case sec:
		strncpy(state.obj.new_sec_name, yyvsp[-1].s, 78);
		break;
	      case set:
		set_global(yyvsp[-1].s, yyvsp[0].i, TEMPORARY, gvt_constant);
		break;
              case org:
	      case equ:
		set_global(yyvsp[-1].s, yyvsp[0].i, PERMANENT, gvt_constant);
		break;
	      case insn:
		set_global(yyvsp[-1].s, yyvsp[0].i << _16bit_core, PERMANENT, gvt_address);
		break;
	      case res:
		set_global(yyvsp[-1].s, yyvsp[0].i, PERMANENT, gvt_static);
                break;
	      case dir:
                gperror(GPE_ILLEGAL_LABEL, NULL);
                break;
              default:
		break;
	      }
	    }
	  }
	  next_line(yyvsp[0].i);
	}
    break;

  case 11:
#line 445 "parse.y"
    {
	  if (state.mac_head) {
	    /* This is a macro definition, but the label was missing */
	    state.mac_head = NULL;
	    gperror(GPE_NO_MACRO_NAME, NULL);
	  } else {
	    next_line(0);
	  }
	}
    break;

  case 14:
#line 460 "parse.y"
    {
	  if (!state.mac_prev) {
	    yyval.i = state.org;
	  } else {
	    macro_append();
	  }
	}
    break;

  case 15:
#line 469 "parse.y"
    {
	  yyval.i = do_or_append_insn("include", mk_list(mk_string(yyvsp[-1].s), NULL));
	}
    break;

  case 16:
#line 473 "parse.y"
    {  force_ident = 1; }
    break;

  case 17:
#line 475 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, mk_list(mk_symbol(yyvsp[-1].s), NULL));
	  force_ident = 0;
	}
    break;

  case 18:
#line 481 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-1].s, NULL);
	}
    break;

  case 19:
#line 485 "parse.y"
    {  force_decimal = 1; }
    break;

  case 20:
#line 487 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, yyvsp[-1].p);
	  force_decimal = 0;
	}
    break;

  case 21:
#line 492 "parse.y"
    {  force_decimal = 1; }
    break;

  case 22:
#line 494 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, yyvsp[-1].p);
	  force_decimal = 0;
	}
    break;

  case 23:
#line 500 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-1].s, NULL);
	}
    break;

  case 24:
#line 505 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-2].s, yyvsp[-1].p);
	}
    break;

  case 25:
#line 510 "parse.y"
    {
	  int number;
	  int i;

          if (!state.mac_prev) {
            number = eval_fill_number(yyvsp[-1].p);

            for (i = 0; i < number; i++) {
              yyval.i = do_insn(yyvsp[-4].s, NULL);
            }
          } else {
	    macro_append();
	  }
	}
    break;

  case 26:
#line 526 "parse.y"
    {
	  int number;
	  int i;

          if (!state.mac_prev) {
            number = eval_fill_number(yyvsp[-1].p);

            for (i = 0; i < number; i++) {
              yyval.i = do_insn(yyvsp[-5].s, yyvsp[-4].p);
            }
          } else {
	    macro_append();
	  }
	}
    break;

  case 27:
#line 542 "parse.y"
    {
	  if (!state.mac_prev) {
	    begin_cblock(yyvsp[-1].p);
	  } else {
	    macro_append();
	  }
	  next_line(0);
	}
    break;

  case 28:
#line 552 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  yyval.i = 0;
	}
    break;

  case 29:
#line 560 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  next_line(0);
	}
    break;

  case 30:
#line 568 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  yyval.i = 0;
	}
    break;

  case 31:
#line 576 "parse.y"
    {
	  yyval.i = 0;
  	}
    break;

  case 33:
#line 584 "parse.y"
    {
	  next_line(0);
	}
    break;

  case 35:
#line 593 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	}
    break;

  case 36:
#line 600 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr(mk_symbol(yyvsp[-1].s));
	  } else {
	    macro_append();
	  }
	}
    break;

  case 37:
#line 609 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr_incr(mk_symbol(yyvsp[-2].s), yyvsp[-1].p);
	  } else {
	    macro_append();
	  }
	}
    break;

  case 40:
#line 626 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr(yyvsp[0].p);
	  }
	}
    break;

  case 41:
#line 633 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr_incr(yyvsp[-2].p, yyvsp[0].p);
	  }
	}
    break;

  case 52:
#line 646 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[0].p, NULL);
	}
    break;

  case 53:
#line 651 "parse.y"
    {
	  gperror(GPE_BADCHAR, "Illegal Character (,)");
          yyval.p = mk_list(yyvsp[-1].p, NULL);
	}
    break;

  case 54:
#line 657 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 56:
#line 666 "parse.y"
    {
	  yyval.p = mk_string(yyvsp[0].s);
        }
    break;

  case 58:
#line 675 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 61:
#line 686 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 64:
#line 697 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 67:
#line 708 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 72:
#line 719 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 80:
#line 730 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 84:
#line 741 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 88:
#line 752 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 93:
#line 763 "parse.y"
    {
	  yyval.p = mk_1op(yyvsp[-1].i, yyvsp[0].p);
	}
    break;

  case 101:
#line 772 "parse.y"
    {
	  yyval.p = yyvsp[0].p;
        }
    break;

  case 102:
#line 777 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 103:
#line 782 "parse.y"
    {
	  yyval.p = mk_symbol("$");
	}
    break;

  case 104:
#line 787 "parse.y"
    {
	  yyval.p = yyvsp[-1].p;
	}
    break;

  case 105:
#line 792 "parse.y"
    {
	  yyval.p = mk_offset(yyvsp[-1].p);
	}
    break;

  case 106:
#line 797 "parse.y"
    {
	  yyval.p = mk_constant(TBL_NO_CHANGE);
	}
    break;

  case 107:
#line 802 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 108:
#line 807 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 109:
#line 812 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 110:
#line 819 "parse.y"
    { 
          yyval.p = mk_symbol(yyvsp[0].s);
        }
    break;

  case 111:
#line 824 "parse.y"
    {
          yyval.p = mk_2op(CONCAT, mk_symbol(yyvsp[-2].s), mk_1op(VAR, yyvsp[-1].p));
        }
    break;

  case 112:
#line 829 "parse.y"
    {
          yyval.p = mk_2op(CONCAT, mk_symbol(yyvsp[-2].s), 
                        mk_2op(CONCAT, mk_1op(VAR, yyvsp[-1].p), mk_symbol(yyvsp[0].s)));
        }
    break;

  case 113:
#line 837 "parse.y"
    { 
          yyval.s = yyvsp[0].s;
        }
    break;

  case 114:
#line 842 "parse.y"
    {
          if (asm_enabled() && !state.mac_prev) {
	    yyval.s = evaluate_concatenation(mk_2op(CONCAT,  mk_symbol(yyvsp[-2].s), 
                           mk_1op(VAR, yyvsp[-1].p)));
	  }
        }
    break;

  case 115:
#line 850 "parse.y"
    {
          if (asm_enabled() && !state.mac_prev) {
            yyval.s = evaluate_concatenation(mk_2op(CONCAT,  mk_symbol(yyvsp[-2].s), 
                      mk_2op(CONCAT, mk_1op(VAR, yyvsp[-1].p), mk_symbol(yyvsp[0].s))));
	  }
        }
    break;

  case 116:
#line 860 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[0].p, NULL);
	}
    break;

  case 117:
#line 865 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 118:
#line 872 "parse.y"
    {
	  if ((strcasecmp(yyvsp[0].s, "p") == 0) || (strcasecmp(yyvsp[0].s, "pe") == 0)) { 
            force_ident = 1;
          }
        }
    break;

  case 119:
#line 878 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, mk_symbol(yyvsp[-3].s), yyvsp[0].p);
	  force_ident = 0;
	}
    break;

  case 120:
#line 884 "parse.y"
    {
	  yyval.p = yyvsp[0].p;
	}
    break;


    }

/* Line 1000 of yacc.c.  */
#line 2131 "parse.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 889 "parse.y"


