
#ifndef __XMMS_DGA_H
#define __XMMS_DGA_H 1

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

typedef struct {
	guchar *mem;
	gint width, height, pitch;
	gint depth, bytes_per_pixel;

	int banksize, memsize;
} xmms_dga_info_t;

#ifdef __cplusplus
extern "C" {
#endif

/* DO NOT USE THIS FUNCTION. XMMS CALLS IT FOR YOU. */
extern gboolean xmms_dga_init(Display *dpy);

/* Returns TRUE if DGA is initialized and available */
extern gboolean xmms_dga_available();

/* Returns TRUE if DGA wasn't already on, and it was successfully set. */
extern gboolean xmms_dga_enter(xmms_dga_info_t *info_return);

/* Turns off DGA, this is always successful.  Please don't call this unless
   you already set DGA successfully... You might be turning off some other
   poor plugin's DGA otherwise.. */
extern void xmms_dga_leave();

/* Draws 32bit ?BGR images to DGA memory (same format gdk_draw_rgb_32_image uses) */
void xmms_dga_draw_32_image(gint destx, gint desty, gint width, gint height, guint32 *src, gint rowstride);

/* Draws indexed images in to DGA memory */
void xmms_dga_draw_indexed_image(gint destx, gint desty, gint width, gint height, guchar *src, gint rowstride, GdkRgbCmap *cmap);


#ifdef __cplusplus
}
#endif
	
#endif

