namespace Cms {
	public class CctTable {
		public static void GetXY (int temp, out double x, out double y)
		{
			x = XY[temp - 1000, 0];
			y = XY[temp - 1000, 1];
		}

		private static readonly double [,] XY = {
			{0.652756059, 0.344456906}, // 1000K
			{0.652614831, 0.344582115}, // 1001K
			{0.652473628, 0.344707233}, // 1002K
			{0.652332449, 0.344832258}, // 1003K
			{0.652191295, 0.344957192}, // 1004K
			{0.652050164, 0.345082033}, // 1005K
			{0.651909059, 0.345206781}, // 1006K
			{0.651767978, 0.345331436}, // 1007K
			{0.651626922, 0.345455998}, // 1008K
			{0.65148589, 0.345580467}, // 1009K
			{0.651344883, 0.345704843}, // 1010K
			{0.651203901, 0.345829125}, // 1011K
			{0.651062944, 0.345953312}, // 1012K
			{0.650922012, 0.346077406}, // 1013K
			{0.650781105, 0.346201406}, // 1014K
			{0.650640222, 0.346325311}, // 1015K
			{0.650499365, 0.346449121}, // 1016K
			{0.650358534, 0.346572837}, // 1017K
			{0.650217727, 0.346696457}, // 1018K
			{0.650076946, 0.346819982}, // 1019K
			{0.64993619, 0.346943412}, // 1020K
			{0.64979546, 0.347066746}, // 1021K
			{0.649654755, 0.347189984}, // 1022K
			{0.649514075, 0.347313126}, // 1023K
			{0.649373422, 0.347436172}, // 1024K
			{0.649232794, 0.347559121}, // 1025K
			{0.649092191, 0.347681974}, // 1026K
			{0.648951615, 0.34780473}, // 1027K
			{0.648811064, 0.347927389}, // 1028K
			{0.648670539, 0.348049951}, // 1029K
			{0.64853004, 0.348172415}, // 1030K
			{0.648389567, 0.348294782}, // 1031K
			{0.648249119, 0.348417051}, // 1032K
			{0.648108699, 0.348539223}, // 1033K
			{0.647968304, 0.348661296}, // 1034K
			{0.647827935, 0.34878327}, // 1035K
			{0.647687592, 0.348905147}, // 1036K
			{0.647547276, 0.349026924}, // 1037K
			{0.647406986, 0.349148603}, // 1038K
			{0.647266723, 0.349270183}, // 1039K
			{0.647126486, 0.349391664}, // 1040K
			{0.646986275, 0.349513045}, // 1041K
			{0.646846091, 0.349634327}, // 1042K
			{0.646705933, 0.349755509}, // 1043K
			{0.646565802, 0.349876591}, // 1044K
			{0.646425698, 0.349997574}, // 1045K
			{0.64628562, 0.350118455}, // 1046K
			{0.64614557, 0.350239237}, // 1047K
			{0.646005545, 0.350359918}, // 1048K
			{0.645865548, 0.350480498}, // 1049K
			{0.645725578, 0.350600977}, // 1050K
			{0.645585634, 0.350721356}, // 1051K
			{0.645445718, 0.350841633}, // 1052K
			{0.645305828, 0.350961808}, // 1053K
			{0.645165965, 0.351081882}, // 1054K
			{0.64502613, 0.351201854}, // 1055K
			{0.644886321, 0.351321725}, // 1056K
			{0.64474654, 0.351441493}, // 1057K
			{0.644606786, 0.351561159}, // 1058K
			{0.644467059, 0.351680723}, // 1059K
			{0.64432736, 0.351800184}, // 1060K
			{0.644187687, 0.351919542}, // 1061K
			{0.644048042, 0.352038797}, // 1062K
			{0.643908425, 0.35215795}, // 1063K
			{0.643768835, 0.352276999}, // 1064K
			{0.643629272, 0.352395945}, // 1065K
			{0.643489737, 0.352514787}, // 1066K
			{0.643350229, 0.352633526}, // 1067K
			{0.643210749, 0.352752161}, // 1068K
			{0.643071296, 0.352870692}, // 1069K
			{0.642931872, 0.352989119}, // 1070K
			{0.642792474, 0.353107441}, // 1071K
			{0.642653105, 0.353225659}, // 1072K
			{0.642513763, 0.353343773}, // 1073K
			{0.642374449, 0.353461782}, // 1074K
			{0.642235163, 0.353579685}, // 1075K
			{0.642095904, 0.353697484}, // 1076K
			{0.641956674, 0.353815178}, // 1077K
			{0.641817471, 0.353932766}, // 1078K
			{0.641678296, 0.354050249}, // 1079K
			{0.641539149, 0.354167626}, // 1080K
			{0.641400031, 0.354284898}, // 1081K
			{0.64126094, 0.354402063}, // 1082K
			{0.641121877, 0.354519123}, // 1083K
			{0.640982842, 0.354636076}, // 1084K
			{0.640843836, 0.354752923}, // 1085K
			{0.640704857, 0.354869664}, // 1086K
			{0.640565907, 0.354986298}, // 1087K
			{0.640426985, 0.355102825}, // 1088K
			{0.640288091, 0.355219245}, // 1089K
			{0.640149225, 0.355335558}, // 1090K
			{0.640010388, 0.355451764}, // 1091K
			{0.639871579, 0.355567863}, // 1092K
			{0.639732798, 0.355683854}, // 1093K
			{0.639594046, 0.355799738}, // 1094K
			{0.639455322, 0.355915514}, // 1095K
			{0.639316626, 0.356031182}, // 1096K
			{0.639177959, 0.356146742}, // 1097K
			{0.63903932, 0.356262194}, // 1098K
			{0.63890071, 0.356377538}, // 1099K
			{0.638762128, 0.356492773}, // 1100K
			{0.638623575, 0.3566079}, // 1101K
			{0.63848505, 0.356722918}, // 1102K
			{0.638346554, 0.356837828}, // 1103K
			{0.638208087, 0.356952628}, // 1104K
			{0.638069648, 0.35706732}, // 1105K
			{0.637931237, 0.357181902}, // 1106K
			{0.637792856, 0.357296375}, // 1107K
			{0.637654503, 0.357410739}, // 1108K
			{0.637516179, 0.357524993}, // 1109K
			{0.637377883, 0.357639137}, // 1110K
			{0.637239617, 0.357753172}, // 1111K
			{0.637101379, 0.357867097}, // 1112K
			{0.63696317, 0.357980912}, // 1113K
			{0.636824989, 0.358094616}, // 1114K
			{0.636686838, 0.358208211}, // 1115K
			{0.636548715, 0.358321695}, // 1116K
			{0.636410621, 0.358435068}, // 1117K
			{0.636272557, 0.358548331}, // 1118K
			{0.636134521, 0.358661483}, // 1119K
			{0.635996514, 0.358774524}, // 1120K
			{0.635858536, 0.358887454}, // 1121K
			{0.635720587, 0.359000274}, // 1122K
			{0.635582667, 0.359112982}, // 1123K
			{0.635444775, 0.359225578}, // 1124K
			{0.635306913, 0.359338063}, // 1125K
			{0.63516908, 0.359450437}, // 1126K
			{0.635031277, 0.359562699}, // 1127K
			{0.634893502, 0.359674849}, // 1128K
			{0.634755756, 0.359786888}, // 1129K
			{0.634618039, 0.359898814}, // 1130K
			{0.634480352, 0.360010628}, // 1131K
			{0.634342694, 0.36012233}, // 1132K
			{0.634205064, 0.36023392}, // 1133K
			{0.634067464, 0.360345397}, // 1134K
			{0.633929894, 0.360456762}, // 1135K
			{0.633792352, 0.360568014}, // 1136K
			{0.63365484, 0.360679153}, // 1137K
			{0.633517357, 0.360790179}, // 1138K
			{0.633379903, 0.360901093}, // 1139K
			{0.633242478, 0.361011893}, // 1140K
			{0.633105083, 0.36112258}, // 1141K
			{0.632967717, 0.361233154}, // 1142K
			{0.63283038, 0.361343615}, // 1143K
			{0.632693073, 0.361453962}, // 1144K
			{0.632555795, 0.361564195}, // 1145K
			{0.632418546, 0.361674315}, // 1146K
			{0.632281327, 0.361784321}, // 1147K
			{0.632144137, 0.361894213}, // 1148K
			{0.632006977, 0.362003991}, // 1149K
			{0.631869846, 0.362113655}, // 1150K
			{0.631732744, 0.362223205}, // 1151K
			{0.631595672, 0.362332641}, // 1152K
			{0.631458629, 0.362441962}, // 1153K
			{0.631321616, 0.362551169}, // 1154K
			{0.631184632, 0.362660261}, // 1155K
			{0.631047678, 0.362769238}, // 1156K
			{0.630910753, 0.362878101}, // 1157K
			{0.630773858, 0.362986849}, // 1158K
			{0.630636992, 0.363095482}, // 1159K
			{0.630500156, 0.363204}, // 1160K
			{0.630363349, 0.363312403}, // 1161K
			{0.630226572, 0.363420691}, // 1162K
			{0.630089824, 0.363528863}, // 1163K
			{0.629953106, 0.36363692}, // 1164K
			{0.629816418, 0.363744861}, // 1165K
			{0.629679759, 0.363852687}, // 1166K
			{0.62954313, 0.363960398}, // 1167K
			{0.629406531, 0.364067992}, // 1168K
			{0.629269961, 0.364175471}, // 1169K
			{0.62913342, 0.364282834}, // 1170K
			{0.62899691, 0.36439008}, // 1171K
			{0.628860429, 0.364497211}, // 1172K
			{0.628723978, 0.364604226}, // 1173K
			{0.628587556, 0.364711124}, // 1174K
			{0.628451164, 0.364817906}, // 1175K
			{0.628314802, 0.364924571}, // 1176K
			{0.628178469, 0.36503112}, // 1177K
			{0.628042167, 0.365137553}, // 1178K
			{0.627905893, 0.365243869}, // 1179K
			{0.62776965, 0.365350068}, // 1180K
			{0.627633437, 0.36545615}, // 1181K
			{0.627497253, 0.365562115}, // 1182K
			{0.627361099, 0.365667963}, // 1183K
			{0.627224974, 0.365773695}, // 1184K
			{0.62708888, 0.365879309}, // 1185K
			{0.626952815, 0.365984806}, // 1186K
			{0.62681678, 0.366090186}, // 1187K
			{0.626680775, 0.366195448}, // 1188K
			{0.6265448, 0.366300593}, // 1189K
			{0.626408854, 0.36640562}, // 1190K
			{0.626272938, 0.36651053}, // 1191K
			{0.626137053, 0.366615322}, // 1192K
			{0.626001197, 0.366719996}, // 1193K
			{0.62586537, 0.366824553}, // 1194K
			{0.625729574, 0.366928992}, // 1195K
			{0.625593807, 0.367033312}, // 1196K
			{0.625458071, 0.367137515}, // 1197K
			{0.625322364, 0.3672416}, // 1198K
			{0.625186687, 0.367345566}, // 1199K
			{0.62505104, 0.367449415}, // 1200K
			{0.624915423, 0.367553145}, // 1201K
			{0.624779836, 0.367656756}, // 1202K
			{0.624644279, 0.367760249}, // 1203K
			{0.624508751, 0.367863624}, // 1204K
			{0.624373254, 0.36796688}, // 1205K
			{0.624237786, 0.368070018}, // 1206K
			{0.624102349, 0.368173037}, // 1207K
			{0.623966941, 0.368275937}, // 1208K
			{0.623831563, 0.368378718}, // 1209K
			{0.623696216, 0.36848138}, // 1210K
			{0.623560898, 0.368583924}, // 1211K
			{0.62342561, 0.368686348}, // 1212K
			{0.623290352, 0.368788654}, // 1213K
			{0.623155124, 0.36889084}, // 1214K
			{0.623019926, 0.368992907}, // 1215K
			{0.622884758, 0.369094855}, // 1216K
			{0.62274962, 0.369196683}, // 1217K
			{0.622614512, 0.369298392}, // 1218K
			{0.622479434, 0.369399982}, // 1219K
			{0.622344386, 0.369501452}, // 1220K
			{0.622209368, 0.369602803}, // 1221K
			{0.62207438, 0.369704034}, // 1222K
			{0.621939422, 0.369805145}, // 1223K
			{0.621804494, 0.369906137}, // 1224K
			{0.621669596, 0.370007009}, // 1225K
			{0.621534728, 0.370107761}, // 1226K
			{0.621399891, 0.370208393}, // 1227K
			{0.621265083, 0.370308906}, // 1228K
			{0.621130305, 0.370409298}, // 1229K
			{0.620995557, 0.37050957}, // 1230K
			{0.620860839, 0.370609722}, // 1231K
			{0.620726152, 0.370709754}, // 1232K
			{0.620591494, 0.370809666}, // 1233K
			{0.620456867, 0.370909458}, // 1234K
			{0.620322269, 0.371009129}, // 1235K
			{0.620187702, 0.37110868}, // 1236K
			{0.620053165, 0.371208111}, // 1237K
			{0.619918658, 0.371307421}, // 1238K
			{0.61978418, 0.37140661}, // 1239K
			{0.619649733, 0.371505679}, // 1240K
			{0.619515316, 0.371604628}, // 1241K
			{0.61938093, 0.371703456}, // 1242K
			{0.619246573, 0.371802163}, // 1243K
			{0.619112246, 0.371900749}, // 1244K
			{0.61897795, 0.371999215}, // 1245K
			{0.618843683, 0.37209756}, // 1246K
			{0.618709447, 0.372195784}, // 1247K
			{0.618575241, 0.372293887}, // 1248K
			{0.618441065, 0.372391869}, // 1249K
			{0.618306919, 0.37248973}, // 1250K
			{0.618172803, 0.37258747}, // 1251K
			{0.618038717, 0.372685089}, // 1252K
			{0.617904662, 0.372782587}, // 1253K
			{0.617770637, 0.372879964}, // 1254K
			{0.617636641, 0.37297722}, // 1255K
			{0.617502676, 0.373074354}, // 1256K
			{0.617368741, 0.373171367}, // 1257K
			{0.617234837, 0.373268259}, // 1258K
			{0.617100962, 0.373365029}, // 1259K
			{0.616967117, 0.373461678}, // 1260K
			{0.616833303, 0.373558206}, // 1261K
			{0.616699519, 0.373654612}, // 1262K
			{0.616565765, 0.373750896}, // 1263K
			{0.616432041, 0.373847059}, // 1264K
			{0.616298348, 0.373943101}, // 1265K
			{0.616164684, 0.374039021}, // 1266K
			{0.616031051, 0.374134819}, // 1267K
			{0.615897448, 0.374230495}, // 1268K
			{0.615763875, 0.37432605}, // 1269K
			{0.615630333, 0.374421483}, // 1270K
			{0.61549682, 0.374516794}, // 1271K
			{0.615363338, 0.374611984}, // 1272K
			{0.615229886, 0.374707051}, // 1273K
			{0.615096464, 0.374801997}, // 1274K
			{0.614963072, 0.374896821}, // 1275K
			{0.614829711, 0.374991523}, // 1276K
			{0.61469638, 0.375086103}, // 1277K
			{0.614563079, 0.37518056}, // 1278K
			{0.614429808, 0.375274896}, // 1279K
			{0.614296567, 0.37536911}, // 1280K
			{0.614163357, 0.375463202}, // 1281K
			{0.614030177, 0.375557171}, // 1282K
			{0.613897027, 0.375651019}, // 1283K
			{0.613763907, 0.375744744}, // 1284K
			{0.613630818, 0.375838347}, // 1285K
			{0.613497759, 0.375931828}, // 1286K
			{0.61336473, 0.376025186}, // 1287K
			{0.613231731, 0.376118423}, // 1288K
			{0.613098763, 0.376211537}, // 1289K
			{0.612965825, 0.376304528}, // 1290K
			{0.612832917, 0.376397398}, // 1291K
			{0.612700039, 0.376490145}, // 1292K
			{0.612567192, 0.376582769}, // 1293K
			{0.612434375, 0.376675272}, // 1294K
			{0.612301588, 0.376767651}, // 1295K
			{0.612168831, 0.376859908}, // 1296K
			{0.612036105, 0.376952043}, // 1297K
			{0.611903409, 0.377044056}, // 1298K
			{0.611770743, 0.377135945}, // 1299K
			{0.611638108, 0.377227712}, // 1300K
			{0.611505502, 0.377319357}, // 1301K
			{0.611372928, 0.377410879}, // 1302K
			{0.611240383, 0.377502279}, // 1303K
			{0.611107869, 0.377593555}, // 1304K
			{0.610975385, 0.37768471}, // 1305K
			{0.610842931, 0.377775741}, // 1306K
			{0.610710508, 0.37786665}, // 1307K
			{0.610578115, 0.377957436}, // 1308K
			{0.610445752, 0.378048099}, // 1309K
			{0.610313419, 0.37813864}, // 1310K
			{0.610181117, 0.378229058}, // 1311K
			{0.610048845, 0.378319353}, // 1312K
			{0.609916604, 0.378409526}, // 1313K
			{0.609784393, 0.378499576}, // 1314K
			{0.609652212, 0.378589502}, // 1315K
			{0.609520061, 0.378679307}, // 1316K
			{0.609387941, 0.378768988}, // 1317K
			{0.609255851, 0.378858546}, // 1318K
			{0.609123792, 0.378947982}, // 1319K
			{0.608991763, 0.379037294}, // 1320K
			{0.608859764, 0.379126484}, // 1321K
			{0.608727795, 0.379215551}, // 1322K
			{0.608595857, 0.379304495}, // 1323K
			{0.608463949, 0.379393317}, // 1324K
			{0.608332072, 0.379482015}, // 1325K
			{0.608200225, 0.37957059}, // 1326K
			{0.608068408, 0.379659043}, // 1327K
			{0.607936622, 0.379747372}, // 1328K
			{0.607804866, 0.379835579}, // 1329K
			{0.607673141, 0.379923662}, // 1330K
			{0.607541446, 0.380011623}, // 1331K
			{0.607409781, 0.38009946}, // 1332K
			{0.607278146, 0.380187175}, // 1333K
			{0.607146542, 0.380274767}, // 1334K
			{0.607014969, 0.380362235}, // 1335K
			{0.606883426, 0.380449581}, // 1336K
			{0.606751913, 0.380536804}, // 1337K
			{0.60662043, 0.380623903}, // 1338K
			{0.606488978, 0.38071088}, // 1339K
			{0.606357557, 0.380797734}, // 1340K
			{0.606226166, 0.380884465}, // 1341K
			{0.606094805, 0.380971072}, // 1342K
			{0.605963475, 0.381057557}, // 1343K
			{0.605832175, 0.381143918}, // 1344K
			{0.605700905, 0.381230157}, // 1345K
			{0.605569666, 0.381316273}, // 1346K
			{0.605438458, 0.381402265}, // 1347K
			{0.605307279, 0.381488135}, // 1348K
			{0.605176132, 0.381573881}, // 1349K
			{0.605045014, 0.381659505}, // 1350K
			{0.604913928, 0.381745005}, // 1351K
			{0.604782871, 0.381830383}, // 1352K
			{0.604651845, 0.381915637}, // 1353K
			{0.60452085, 0.382000768}, // 1354K
			{0.604389885, 0.382085777}, // 1355K
			{0.604258951, 0.382170662}, // 1356K
			{0.604128047, 0.382255424}, // 1357K
			{0.603997173, 0.382340064}, // 1358K
			{0.60386633, 0.38242458}, // 1359K
			{0.603735517, 0.382508973}, // 1360K
			{0.603604735, 0.382593244}, // 1361K
			{0.603473984, 0.382677391}, // 1362K
			{0.603343263, 0.382761415}, // 1363K
			{0.603212572, 0.382845317}, // 1364K
			{0.603081912, 0.382929095}, // 1365K
			{0.602951283, 0.38301275}, // 1366K
			{0.602820684, 0.383096283}, // 1367K
			{0.602690115, 0.383179692}, // 1368K
			{0.602559577, 0.383262979}, // 1369K
			{0.60242907, 0.383346142}, // 1370K
			{0.602298593, 0.383429183}, // 1371K
			{0.602168146, 0.3835121}, // 1372K
			{0.602037731, 0.383594895}, // 1373K
			{0.601907345, 0.383677567}, // 1374K
			{0.601776991, 0.383760116}, // 1375K
			{0.601646666, 0.383842542}, // 1376K
			{0.601516373, 0.383924845}, // 1377K
			{0.60138611, 0.384007025}, // 1378K
			{0.601255877, 0.384089083}, // 1379K
			{0.601125676, 0.384171017}, // 1380K
			{0.600995504, 0.384252829}, // 1381K
			{0.600865364, 0.384334518}, // 1382K
			{0.600735253, 0.384416084}, // 1383K
			{0.600605174, 0.384497527}, // 1384K
			{0.600475125, 0.384578848}, // 1385K
			{0.600345107, 0.384660045}, // 1386K
			{0.600215119, 0.38474112}, // 1387K
			{0.600085162, 0.384822073}, // 1388K
			{0.599955236, 0.384902902}, // 1389K
			{0.59982534, 0.384983609}, // 1390K
			{0.599695474, 0.385064193}, // 1391K
			{0.59956564, 0.385144654}, // 1392K
			{0.599435836, 0.385224993}, // 1393K
			{0.599306063, 0.385305209}, // 1394K
			{0.59917632, 0.385385302}, // 1395K
			{0.599046608, 0.385465273}, // 1396K
			{0.598916927, 0.385545121}, // 1397K
			{0.598787276, 0.385624846}, // 1398K
			{0.598657656, 0.385704449}, // 1399K
			{0.598528067, 0.385783929}, // 1400K
			{0.598398509, 0.385863287}, // 1401K
			{0.598268981, 0.385942522}, // 1402K
			{0.598139483, 0.386021635}, // 1403K
			{0.598010017, 0.386100625}, // 1404K
			{0.597880581, 0.386179493}, // 1405K
			{0.597751176, 0.386258239}, // 1406K
			{0.597621802, 0.386336861}, // 1407K
			{0.597492458, 0.386415362}, // 1408K
			{0.597363145, 0.38649374}, // 1409K
			{0.597233863, 0.386571996}, // 1410K
			{0.597104612, 0.386650129}, // 1411K
			{0.596975391, 0.38672814}, // 1412K
			{0.596846201, 0.386806029}, // 1413K
			{0.596717042, 0.386883796}, // 1414K
			{0.596587914, 0.38696144}, // 1415K
			{0.596458816, 0.387038962}, // 1416K
			{0.596329749, 0.387116362}, // 1417K
			{0.596200713, 0.387193639}, // 1418K
			{0.596071708, 0.387270795}, // 1419K
			{0.595942734, 0.387347828}, // 1420K
			{0.59581379, 0.387424739}, // 1421K
			{0.595684877, 0.387501528}, // 1422K
			{0.595555995, 0.387578195}, // 1423K
			{0.595427144, 0.38765474}, // 1424K
			{0.595298324, 0.387731163}, // 1425K
			{0.595169534, 0.387807464}, // 1426K
			{0.595040776, 0.387883643}, // 1427K
			{0.594912048, 0.3879597}, // 1428K
			{0.594783351, 0.388035636}, // 1429K
			{0.594654685, 0.388111449}, // 1430K
			{0.59452605, 0.38818714}, // 1431K
			{0.594397445, 0.38826271}, // 1432K
			{0.594268872, 0.388338158}, // 1433K
			{0.594140329, 0.388413484}, // 1434K
			{0.594011818, 0.388488688}, // 1435K
			{0.593883337, 0.388563771}, // 1436K
			{0.593754887, 0.388638732}, // 1437K
			{0.593626468, 0.388713571}, // 1438K
			{0.59349808, 0.388788289}, // 1439K
			{0.593369723, 0.388862885}, // 1440K
			{0.593241397, 0.388937359}, // 1441K
			{0.593113102, 0.389011712}, // 1442K
			{0.592984838, 0.389085944}, // 1443K
			{0.592856604, 0.389160054}, // 1444K
			{0.592728402, 0.389234042}, // 1445K
			{0.592600231, 0.38930791}, // 1446K
			{0.592472091, 0.389381655}, // 1447K
			{0.592343981, 0.38945528}, // 1448K
			{0.592215903, 0.389528783}, // 1449K
			{0.592087856, 0.389602165}, // 1450K
			{0.591959839, 0.389675426}, // 1451K
			{0.591831854, 0.389748565}, // 1452K
			{0.5917039, 0.389821583}, // 1453K
			{0.591575977, 0.38989448}, // 1454K
			{0.591448085, 0.389967256}, // 1455K
			{0.591320223, 0.390039911}, // 1456K
			{0.591192393, 0.390112445}, // 1457K
			{0.591064594, 0.390184858}, // 1458K
			{0.590936827, 0.39025715}, // 1459K
			{0.59080909, 0.390329321}, // 1460K
			{0.590681384, 0.390401371}, // 1461K
			{0.590553709, 0.390473301}, // 1462K
			{0.590426066, 0.390545109}, // 1463K
			{0.590298454, 0.390616797}, // 1464K
			{0.590170872, 0.390688364}, // 1465K
			{0.590043322, 0.39075981}, // 1466K
			{0.589915803, 0.390831136}, // 1467K
			{0.589788315, 0.390902341}, // 1468K
			{0.589660859, 0.390973425}, // 1469K
			{0.589533433, 0.391044389}, // 1470K
			{0.589406039, 0.391115232}, // 1471K
			{0.589278676, 0.391185955}, // 1472K
			{0.589151344, 0.391256557}, // 1473K
			{0.589024043, 0.391327039}, // 1474K
			{0.588896774, 0.391397401}, // 1475K
			{0.588769535, 0.391467642}, // 1476K
			{0.588642328, 0.391537763}, // 1477K
			{0.588515152, 0.391607764}, // 1478K
			{0.588388008, 0.391677645}, // 1479K
			{0.588260894, 0.391747405}, // 1480K
			{0.588133812, 0.391817046}, // 1481K
			{0.588006762, 0.391886566}, // 1482K
			{0.587879742, 0.391955966}, // 1483K
			{0.587752754, 0.392025247}, // 1484K
			{0.587625797, 0.392094407}, // 1485K
			{0.587498871, 0.392163447}, // 1486K
			{0.587371977, 0.392232368}, // 1487K
			{0.587245114, 0.392301169}, // 1488K
			{0.587118282, 0.39236985}, // 1489K
			{0.586991482, 0.392438411}, // 1490K
			{0.586864713, 0.392506853}, // 1491K
			{0.586737975, 0.392575175}, // 1492K
			{0.586611269, 0.392643377}, // 1493K
			{0.586484594, 0.39271146}, // 1494K
			{0.586357951, 0.392779424}, // 1495K
			{0.586231339, 0.392847268}, // 1496K
			{0.586104758, 0.392914992}, // 1497K
			{0.585978209, 0.392982597}, // 1498K
			{0.585851691, 0.393050083}, // 1499K
			{0.585725205, 0.39311745}, // 1500K
			{0.58559875, 0.393184697}, // 1501K
			{0.585472326, 0.393251825}, // 1502K
			{0.585345934, 0.393318834}, // 1503K
			{0.585219574, 0.393385724}, // 1504K
			{0.585093245, 0.393452495}, // 1505K
			{0.584966947, 0.393519147}, // 1506K
			{0.584840681, 0.39358568}, // 1507K
			{0.584714447, 0.393652094}, // 1508K
			{0.584588244, 0.39371839}, // 1509K
			{0.584462072, 0.393784566}, // 1510K
			{0.584335933, 0.393850624}, // 1511K
			{0.584209824, 0.393916563}, // 1512K
			{0.584083747, 0.393982383}, // 1513K
			{0.583957702, 0.394048085}, // 1514K
			{0.583831689, 0.394113668}, // 1515K
			{0.583705707, 0.394179133}, // 1516K
			{0.583579756, 0.39424448}, // 1517K
			{0.583453838, 0.394309708}, // 1518K
			{0.58332795, 0.394374817}, // 1519K
			{0.583202095, 0.394439808}, // 1520K
			{0.583076271, 0.394504682}, // 1521K
			{0.582950479, 0.394569436}, // 1522K
			{0.582824718, 0.394634073}, // 1523K
			{0.582698989, 0.394698592}, // 1524K
			{0.582573292, 0.394762993}, // 1525K
			{0.582447627, 0.394827275}, // 1526K
			{0.582321993, 0.39489144}, // 1527K
			{0.582196391, 0.394955487}, // 1528K
			{0.582070821, 0.395019416}, // 1529K
			{0.581945282, 0.395083227}, // 1530K
			{0.581819775, 0.395146921}, // 1531K
			{0.5816943, 0.395210497}, // 1532K
			{0.581568857, 0.395273955}, // 1533K
			{0.581443446, 0.395337296}, // 1534K
			{0.581318066, 0.395400519}, // 1535K
			{0.581192718, 0.395463625}, // 1536K
			{0.581067402, 0.395526613}, // 1537K
			{0.580942118, 0.395589484}, // 1538K
			{0.580816866, 0.395652238}, // 1539K
			{0.580691645, 0.395714875}, // 1540K
			{0.580566457, 0.395777394}, // 1541K
			{0.5804413, 0.395839797}, // 1542K
			{0.580316175, 0.395902082}, // 1543K
			{0.580191082, 0.39596425}, // 1544K
			{0.580066021, 0.396026302}, // 1545K
			{0.579940992, 0.396088236}, // 1546K
			{0.579815995, 0.396150054}, // 1547K
			{0.579691029, 0.396211755}, // 1548K
			{0.579566096, 0.396273339}, // 1549K
			{0.579441195, 0.396334806}, // 1550K
			{0.579316325, 0.396396157}, // 1551K
			{0.579191488, 0.396457392}, // 1552K
			{0.579066683, 0.396518509}, // 1553K
			{0.578941909, 0.396579511}, // 1554K
			{0.578817168, 0.396640396}, // 1555K
			{0.578692459, 0.396701165}, // 1556K
			{0.578567781, 0.396761818}, // 1557K
			{0.578443136, 0.396822354}, // 1558K
			{0.578318523, 0.396882774}, // 1559K
			{0.578193942, 0.396943078}, // 1560K
			{0.578069393, 0.397003267}, // 1561K
			{0.577944876, 0.397063339}, // 1562K
			{0.577820391, 0.397123295}, // 1563K
			{0.577695939, 0.397183136}, // 1564K
			{0.577571518, 0.397242861}, // 1565K
			{0.57744713, 0.39730247}, // 1566K
			{0.577322774, 0.397361963}, // 1567K
			{0.57719845, 0.397421341}, // 1568K
			{0.577074158, 0.397480604}, // 1569K
			{0.576949899, 0.39753975}, // 1570K
			{0.576825671, 0.397598782}, // 1571K
			{0.576701476, 0.397657698}, // 1572K
			{0.576577313, 0.397716499}, // 1573K
			{0.576453183, 0.397775185}, // 1574K
			{0.576329085, 0.397833755}, // 1575K
			{0.576205018, 0.397892211}, // 1576K
			{0.576080985, 0.397950551}, // 1577K
			{0.575956983, 0.398008777}, // 1578K
			{0.575833014, 0.398066887}, // 1579K
			{0.575709077, 0.398124883}, // 1580K
			{0.575585173, 0.398182764}, // 1581K
			{0.5754613, 0.398240531}, // 1582K
			{0.575337461, 0.398298182}, // 1583K
			{0.575213653, 0.398355719}, // 1584K
			{0.575089878, 0.398413142}, // 1585K
			{0.574966136, 0.39847045}, // 1586K
			{0.574842425, 0.398527644}, // 1587K
			{0.574718747, 0.398584723}, // 1588K
			{0.574595102, 0.398641689}, // 1589K
			{0.574471489, 0.39869854}, // 1590K
			{0.574347909, 0.398755277}, // 1591K
			{0.574224361, 0.398811899}, // 1592K
			{0.574100845, 0.398868408}, // 1593K
			{0.573977362, 0.398924803}, // 1594K
			{0.573853912, 0.398981084}, // 1595K
			{0.573730494, 0.399037252}, // 1596K
			{0.573607108, 0.399093305}, // 1597K
			{0.573483756, 0.399149245}, // 1598K
			{0.573360435, 0.399205072}, // 1599K
			{0.573237148, 0.399260785}, // 1600K
			{0.573113892, 0.399316384}, // 1601K
			{0.57299067, 0.39937187}, // 1602K
			{0.57286748, 0.399427243}, // 1603K
			{0.572744323, 0.399482502}, // 1604K
			{0.572621198, 0.399537649}, // 1605K
			{0.572498106, 0.399592682}, // 1606K
			{0.572375047, 0.399647602}, // 1607K
			{0.57225202, 0.399702409}, // 1608K
			{0.572129026, 0.399757103}, // 1609K
			{0.572006065, 0.399811685}, // 1610K
			{0.571883137, 0.399866153}, // 1611K
			{0.571760241, 0.399920509}, // 1612K
			{0.571637378, 0.399974753}, // 1613K
			{0.571514548, 0.400028883}, // 1614K
			{0.57139175, 0.400082902}, // 1615K
			{0.571268985, 0.400136807}, // 1616K
			{0.571146254, 0.400190601}, // 1617K
			{0.571023554, 0.400244282}, // 1618K
			{0.570900888, 0.400297851}, // 1619K
			{0.570778255, 0.400351308}, // 1620K
			{0.570655654, 0.400404653}, // 1621K
			{0.570533087, 0.400457885}, // 1622K
			{0.570410552, 0.400511006}, // 1623K
			{0.57028805, 0.400564015}, // 1624K
			{0.570165581, 0.400616913}, // 1625K
			{0.570043145, 0.400669698}, // 1626K
			{0.569920742, 0.400722372}, // 1627K
			{0.569798372, 0.400774934}, // 1628K
			{0.569676034, 0.400827385}, // 1629K
			{0.56955373, 0.400879724}, // 1630K
			{0.569431459, 0.400931952}, // 1631K
			{0.569309221, 0.400984069}, // 1632K
			{0.569187015, 0.401036075}, // 1633K
			{0.569064843, 0.401087969}, // 1634K
			{0.568942704, 0.401139752}, // 1635K
			{0.568820598, 0.401191424}, // 1636K
			{0.568698525, 0.401242986}, // 1637K
			{0.568576485, 0.401294436}, // 1638K
			{0.568454478, 0.401345776}, // 1639K
			{0.568332504, 0.401397005}, // 1640K
			{0.568210564, 0.401448124}, // 1641K
			{0.568088656, 0.401499132}, // 1642K
			{0.567966782, 0.401550029}, // 1643K
			{0.567844941, 0.401600816}, // 1644K
			{0.567723133, 0.401651493}, // 1645K
			{0.567601358, 0.401702059}, // 1646K
			{0.567479617, 0.401752515}, // 1647K
			{0.567357908, 0.401802861}, // 1648K
			{0.567236233, 0.401853098}, // 1649K
			{0.567114591, 0.401903224}, // 1650K
			{0.566992983, 0.40195324}, // 1651K
			{0.566871408, 0.402003146}, // 1652K
			{0.566749866, 0.402052943}, // 1653K
			{0.566628357, 0.40210263}, // 1654K
			{0.566506882, 0.402152208}, // 1655K
			{0.56638544, 0.402201676}, // 1656K
			{0.566264031, 0.402251034}, // 1657K
			{0.566142656, 0.402300283}, // 1658K
			{0.566021314, 0.402349423}, // 1659K
			{0.565900005, 0.402398454}, // 1660K
			{0.56577873, 0.402447376}, // 1661K
			{0.565657488, 0.402496188}, // 1662K
			{0.56553628, 0.402544892}, // 1663K
			{0.565415105, 0.402593487}, // 1664K
			{0.565293964, 0.402641972}, // 1665K
			{0.565172856, 0.40269035}, // 1666K
			{0.565051782, 0.402738618}, // 1667K
			{0.564930741, 0.402786778}, // 1668K
			{0.564809733, 0.402834829}, // 1669K
			{0.56468876, 0.402882772}, // 1670K
			{0.564567819, 0.402930607}, // 1671K
			{0.564446913, 0.402978333}, // 1672K
			{0.56432604, 0.403025951}, // 1673K
			{0.5642052, 0.403073461}, // 1674K
			{0.564084394, 0.403120863}, // 1675K
			{0.563963622, 0.403168157}, // 1676K
			{0.563842883, 0.403215343}, // 1677K
			{0.563722178, 0.403262422}, // 1678K
			{0.563601507, 0.403309392}, // 1679K
			{0.563480869, 0.403356255}, // 1680K
			{0.563360265, 0.40340301}, // 1681K
			{0.563239695, 0.403449658}, // 1682K
			{0.563119158, 0.403496199}, // 1683K
			{0.562998655, 0.403542632}, // 1684K
			{0.562878186, 0.403588958}, // 1685K
			{0.562757751, 0.403635176}, // 1686K
			{0.56263735, 0.403681288}, // 1687K
			{0.562516982, 0.403727292}, // 1688K
			{0.562396648, 0.40377319}, // 1689K
			{0.562276348, 0.403818981}, // 1690K
			{0.562156082, 0.403864665}, // 1691K
			{0.562035849, 0.403910242}, // 1692K
			{0.561915651, 0.403955713}, // 1693K
			{0.561795486, 0.404001077}, // 1694K
			{0.561675355, 0.404046335}, // 1695K
			{0.561555258, 0.404091486}, // 1696K
			{0.561435195, 0.404136531}, // 1697K
			{0.561315166, 0.40418147}, // 1698K
			{0.561195171, 0.404226303}, // 1699K
			{0.56107521, 0.404271029}, // 1700K
			{0.560955283, 0.40431565}, // 1701K
			{0.56083539, 0.404360165}, // 1702K
			{0.560715531, 0.404404574}, // 1703K
			{0.560595706, 0.404448877}, // 1704K
			{0.560475915, 0.404493075}, // 1705K
			{0.560356158, 0.404537167}, // 1706K
			{0.560236435, 0.404581153}, // 1707K
			{0.560116746, 0.404625034}, // 1708K
			{0.559997092, 0.40466881}, // 1709K
			{0.559877471, 0.404712481}, // 1710K
			{0.559757885, 0.404756046}, // 1711K
			{0.559638332, 0.404799507}, // 1712K
			{0.559518814, 0.404842862}, // 1713K
			{0.55939933, 0.404886113}, // 1714K
			{0.55927988, 0.404929258}, // 1715K
			{0.559160465, 0.404972299}, // 1716K
			{0.559041083, 0.405015236}, // 1717K
			{0.558921736, 0.405058067}, // 1718K
			{0.558802423, 0.405100795}, // 1719K
			{0.558683145, 0.405143418}, // 1720K
			{0.5585639, 0.405185936}, // 1721K
			{0.55844469, 0.40522835}, // 1722K
			{0.558325515, 0.40527066}, // 1723K
			{0.558206373, 0.405312866}, // 1724K
			{0.558087266, 0.405354969}, // 1725K
			{0.557968193, 0.405396967}, // 1726K
			{0.557849155, 0.405438861}, // 1727K
			{0.557730151, 0.405480652}, // 1728K
			{0.557611181, 0.405522339}, // 1729K
			{0.557492246, 0.405563922}, // 1730K
			{0.557373345, 0.405605402}, // 1731K
			{0.557254479, 0.405646778}, // 1732K
			{0.557135647, 0.405688051}, // 1733K
			{0.557016849, 0.405729221}, // 1734K
			{0.556898086, 0.405770288}, // 1735K
			{0.556779358, 0.405811252}, // 1736K
			{0.556660664, 0.405852112}, // 1737K
			{0.556542004, 0.40589287}, // 1738K
			{0.55642338, 0.405933525}, // 1739K
			{0.556304789, 0.405974078}, // 1740K
			{0.556186233, 0.406014527}, // 1741K
			{0.556067712, 0.406054874}, // 1742K
			{0.555949226, 0.406095119}, // 1743K
			{0.555830774, 0.406135261}, // 1744K
			{0.555712356, 0.406175301}, // 1745K
			{0.555593974, 0.406215239}, // 1746K
			{0.555475626, 0.406255074}, // 1747K
			{0.555357312, 0.406294808}, // 1748K
			{0.555239034, 0.40633444}, // 1749K
			{0.55512079, 0.406373969}, // 1750K
			{0.55500258, 0.406413397}, // 1751K
			{0.554884406, 0.406452723}, // 1752K
			{0.554766266, 0.406491948}, // 1753K
			{0.554648161, 0.406531071}, // 1754K
			{0.554530091, 0.406570093}, // 1755K
			{0.554412055, 0.406609013}, // 1756K
			{0.554294054, 0.406647832}, // 1757K
			{0.554176089, 0.40668655}, // 1758K
			{0.554058158, 0.406725167}, // 1759K
			{0.553940261, 0.406763683}, // 1760K
			{0.5538224, 0.406802097}, // 1761K
			{0.553704574, 0.406840411}, // 1762K
			{0.553586782, 0.406878625}, // 1763K
			{0.553469026, 0.406916737}, // 1764K
			{0.553351304, 0.406954749}, // 1765K
			{0.553233617, 0.406992661}, // 1766K
			{0.553115965, 0.407030472}, // 1767K
			{0.552998348, 0.407068182}, // 1768K
			{0.552880767, 0.407105793}, // 1769K
			{0.55276322, 0.407143303}, // 1770K
			{0.552645708, 0.407180714}, // 1771K
			{0.552528231, 0.407218024}, // 1772K
			{0.552410789, 0.407255235}, // 1773K
			{0.552293383, 0.407292346}, // 1774K
			{0.552176011, 0.407329357}, // 1775K
			{0.552058674, 0.407366268}, // 1776K
			{0.551941373, 0.40740308}, // 1777K
			{0.551824106, 0.407439792}, // 1778K
			{0.551706875, 0.407476405}, // 1779K
			{0.551589679, 0.407512919}, // 1780K
			{0.551472518, 0.407549334}, // 1781K
			{0.551355392, 0.407585649}, // 1782K
			{0.551238302, 0.407621866}, // 1783K
			{0.551121246, 0.407657984}, // 1784K
			{0.551004226, 0.407694003}, // 1785K
			{0.550887241, 0.407729923}, // 1786K
			{0.550770291, 0.407765744}, // 1787K
			{0.550653377, 0.407801467}, // 1788K
			{0.550536498, 0.407837091}, // 1789K
			{0.550419654, 0.407872617}, // 1790K
			{0.550302845, 0.407908045}, // 1791K
			{0.550186072, 0.407943375}, // 1792K
			{0.550069334, 0.407978606}, // 1793K
			{0.549952631, 0.40801374}, // 1794K
			{0.549835964, 0.408048775}, // 1795K
			{0.549719332, 0.408083713}, // 1796K
			{0.549602736, 0.408118553}, // 1797K
			{0.549486175, 0.408153295}, // 1798K
			{0.549369649, 0.408187939}, // 1799K
			{0.549253159, 0.408222487}, // 1800K
			{0.549136704, 0.408256936}, // 1801K
			{0.549020285, 0.408291289}, // 1802K
			{0.548903901, 0.408325544}, // 1803K
			{0.548787553, 0.408359702}, // 1804K
			{0.54867124, 0.408393763}, // 1805K
			{0.548554962, 0.408427727}, // 1806K
			{0.548438721, 0.408461594}, // 1807K
			{0.548322514, 0.408495365}, // 1808K
			{0.548206344, 0.408529038}, // 1809K
			{0.548090209, 0.408562616}, // 1810K
			{0.547974109, 0.408596096}, // 1811K
			{0.547858045, 0.40862948}, // 1812K
			{0.547742017, 0.408662768}, // 1813K
			{0.547626024, 0.40869596}, // 1814K
			{0.547510067, 0.408729055}, // 1815K
			{0.547394146, 0.408762055}, // 1816K
			{0.54727826, 0.408794958}, // 1817K
			{0.54716241, 0.408827766}, // 1818K
			{0.547046596, 0.408860478}, // 1819K
			{0.546930817, 0.408893094}, // 1820K
			{0.546815074, 0.408925614}, // 1821K
			{0.546699367, 0.408958039}, // 1822K
			{0.546583696, 0.408990369}, // 1823K
			{0.546468061, 0.409022603}, // 1824K
			{0.546352461, 0.409054742}, // 1825K
			{0.546236897, 0.409086786}, // 1826K
			{0.546121369, 0.409118735}, // 1827K
			{0.546005876, 0.409150589}, // 1828K
			{0.54589042, 0.409182348}, // 1829K
			{0.545774999, 0.409214012}, // 1830K
			{0.545659615, 0.409245581}, // 1831K
			{0.545544266, 0.409277056}, // 1832K
			{0.545428953, 0.409308436}, // 1833K
			{0.545313676, 0.409339722}, // 1834K
			{0.545198435, 0.409370914}, // 1835K
			{0.54508323, 0.409402011}, // 1836K
			{0.54496806, 0.409433014}, // 1837K
			{0.544852927, 0.409463923}, // 1838K
			{0.54473783, 0.409494738}, // 1839K
			{0.544622769, 0.409525459}, // 1840K
			{0.544507744, 0.409556087}, // 1841K
			{0.544392754, 0.40958662}, // 1842K
			{0.544277801, 0.409617061}, // 1843K
			{0.544162884, 0.409647407}, // 1844K
			{0.544048003, 0.40967766}, // 1845K
			{0.543933158, 0.40970782}, // 1846K
			{0.543818349, 0.409737887}, // 1847K
			{0.543703577, 0.40976786}, // 1848K
			{0.54358884, 0.409797741}, // 1849K
			{0.54347414, 0.409827528}, // 1850K
			{0.543359475, 0.409857222}, // 1851K
			{0.543244847, 0.409886824}, // 1852K
			{0.543130255, 0.409916333}, // 1853K
			{0.5430157, 0.40994575}, // 1854K
			{0.54290118, 0.409975074}, // 1855K
			{0.542786697, 0.410004305}, // 1856K
			{0.54267225, 0.410033444}, // 1857K
			{0.542557839, 0.410062491}, // 1858K
			{0.542443464, 0.410091446}, // 1859K
			{0.542329126, 0.410120309}, // 1860K
			{0.542214824, 0.410149079}, // 1861K
			{0.542100558, 0.410177758}, // 1862K
			{0.541986329, 0.410206345}, // 1863K
			{0.541872136, 0.410234841}, // 1864K
			{0.541757979, 0.410263245}, // 1865K
			{0.541643859, 0.410291557}, // 1866K
			{0.541529775, 0.410319778}, // 1867K
			{0.541415727, 0.410347908}, // 1868K
			{0.541301716, 0.410375946}, // 1869K
			{0.541187741, 0.410403893}, // 1870K
			{0.541073803, 0.410431749}, // 1871K
			{0.540959901, 0.410459515}, // 1872K
			{0.540846035, 0.410487189}, // 1873K
			{0.540732206, 0.410514773}, // 1874K
			{0.540618414, 0.410542266}, // 1875K
			{0.540504658, 0.410569668}, // 1876K
			{0.540390938, 0.41059698}, // 1877K
			{0.540277255, 0.410624201}, // 1878K
			{0.540163609, 0.410651333}, // 1879K
			{0.540049999, 0.410678374}, // 1880K
			{0.539936426, 0.410705324}, // 1881K
			{0.539822889, 0.410732185}, // 1882K
			{0.539709389, 0.410758956}, // 1883K
			{0.539595925, 0.410785637}, // 1884K
			{0.539482498, 0.410812229}, // 1885K
			{0.539369108, 0.41083873}, // 1886K
			{0.539255754, 0.410865142}, // 1887K
			{0.539142437, 0.410891465}, // 1888K
			{0.539029156, 0.410917698}, // 1889K
			{0.538915913, 0.410943842}, // 1890K
			{0.538802706, 0.410969897}, // 1891K
			{0.538689535, 0.410995862}, // 1892K
			{0.538576402, 0.411021739}, // 1893K
			{0.538463305, 0.411047527}, // 1894K
			{0.538350245, 0.411073226}, // 1895K
			{0.538237221, 0.411098836}, // 1896K
			{0.538124234, 0.411124357}, // 1897K
			{0.538011285, 0.41114979}, // 1898K
			{0.537898372, 0.411175135}, // 1899K
			{0.537785495, 0.411200391}, // 1900K
			{0.537672656, 0.411225559}, // 1901K
			{0.537559853, 0.411250638}, // 1902K
			{0.537447088, 0.41127563}, // 1903K
			{0.537334359, 0.411300533}, // 1904K
			{0.537221667, 0.411325349}, // 1905K
			{0.537109012, 0.411350077}, // 1906K
			{0.536996393, 0.411374717}, // 1907K
			{0.536883812, 0.41139927}, // 1908K
			{0.536771268, 0.411423735}, // 1909K
			{0.53665876, 0.411448112}, // 1910K
			{0.53654629, 0.411472403}, // 1911K
			{0.536433856, 0.411496606}, // 1912K
			{0.536321459, 0.411520722}, // 1913K
			{0.5362091, 0.41154475}, // 1914K
			{0.536096777, 0.411568692}, // 1915K
			{0.535984492, 0.411592547}, // 1916K
			{0.535872243, 0.411616315}, // 1917K
			{0.535760031, 0.411639997}, // 1918K
			{0.535647857, 0.411663592}, // 1919K
			{0.535535719, 0.4116871}, // 1920K
			{0.535423619, 0.411710522}, // 1921K
			{0.535311556, 0.411733858}, // 1922K
			{0.53519953, 0.411757107}, // 1923K
			{0.535087541, 0.41178027}, // 1924K
			{0.534975589, 0.411803347}, // 1925K
			{0.534863674, 0.411826339}, // 1926K
			{0.534751796, 0.411849244}, // 1927K
			{0.534639956, 0.411872064}, // 1928K
			{0.534528152, 0.411894798}, // 1929K
			{0.534416386, 0.411917446}, // 1930K
			{0.534304657, 0.411940009}, // 1931K
			{0.534192965, 0.411962486}, // 1932K
			{0.534081311, 0.411984879}, // 1933K
			{0.533969694, 0.412007186}, // 1934K
			{0.533858113, 0.412029408}, // 1935K
			{0.533746571, 0.412051544}, // 1936K
			{0.533635065, 0.412073596}, // 1937K
			{0.533523597, 0.412095564}, // 1938K
			{0.533412166, 0.412117446}, // 1939K
			{0.533300772, 0.412139244}, // 1940K
			{0.533189416, 0.412160957}, // 1941K
			{0.533078097, 0.412182586}, // 1942K
			{0.532966815, 0.41220413}, // 1943K
			{0.532855571, 0.41222559}, // 1944K
			{0.532744364, 0.412246966}, // 1945K
			{0.532633194, 0.412268258}, // 1946K
			{0.532522062, 0.412289465}, // 1947K
			{0.532410967, 0.412310589}, // 1948K
			{0.53229991, 0.412331629}, // 1949K
			{0.53218889, 0.412352586}, // 1950K
			{0.532077907, 0.412373459}, // 1951K
			{0.531966962, 0.412394248}, // 1952K
			{0.531856054, 0.412414953}, // 1953K
			{0.531745184, 0.412435576}, // 1954K
			{0.531634352, 0.412456115}, // 1955K
			{0.531523556, 0.412476571}, // 1956K
			{0.531412799, 0.412496944}, // 1957K
			{0.531302078, 0.412517234}, // 1958K
			{0.531191396, 0.412537441}, // 1959K
			{0.531080751, 0.412557565}, // 1960K
			{0.530970143, 0.412577607}, // 1961K
			{0.530859573, 0.412597566}, // 1962K
			{0.53074904, 0.412617442}, // 1963K
			{0.530638546, 0.412637236}, // 1964K
			{0.530528088, 0.412656948}, // 1965K
			{0.530417669, 0.412676578}, // 1966K
			{0.530307286, 0.412696125}, // 1967K
			{0.530196942, 0.41271559}, // 1968K
			{0.530086635, 0.412734974}, // 1969K
			{0.529976366, 0.412754275}, // 1970K
			{0.529866135, 0.412773495}, // 1971K
			{0.529755941, 0.412792633}, // 1972K
			{0.529645785, 0.41281169}, // 1973K
			{0.529535666, 0.412830665}, // 1974K
			{0.529425585, 0.412849558}, // 1975K
			{0.529315542, 0.412868371}, // 1976K
			{0.529205537, 0.412887102}, // 1977K
			{0.529095569, 0.412905752}, // 1978K
			{0.52898564, 0.412924321}, // 1979K
			{0.528875747, 0.412942809}, // 1980K
			{0.528765893, 0.412961216}, // 1981K
			{0.528656077, 0.412979542}, // 1982K
			{0.528546298, 0.412997788}, // 1983K
			{0.528436557, 0.413015953}, // 1984K
			{0.528326854, 0.413034038}, // 1985K
			{0.528217188, 0.413052042}, // 1986K
			{0.528107561, 0.413069967}, // 1987K
			{0.527997971, 0.41308781}, // 1988K
			{0.52788842, 0.413105574}, // 1989K
			{0.527778906, 0.413123258}, // 1990K
			{0.52766943, 0.413140862}, // 1991K
			{0.527559992, 0.413158386}, // 1992K
			{0.527450591, 0.41317583}, // 1993K
			{0.527341229, 0.413193195}, // 1994K
			{0.527231905, 0.41321048}, // 1995K
			{0.527122618, 0.413227686}, // 1996K
			{0.527013369, 0.413244812}, // 1997K
			{0.526904159, 0.413261859}, // 1998K
			{0.526794986, 0.413278827}, // 1999K
			{0.526685851, 0.413295716}, // 2000K
			{0.526576755, 0.413312526}, // 2001K
			{0.526467696, 0.413329257}, // 2002K
			{0.526358675, 0.413345909}, // 2003K
			{0.526249693, 0.413362483}, // 2004K
			{0.526140748, 0.413378978}, // 2005K
			{0.526031841, 0.413395394}, // 2006K
			{0.525922973, 0.413411732}, // 2007K
			{0.525814142, 0.413427991}, // 2008K
			{0.52570535, 0.413444173}, // 2009K
			{0.525596595, 0.413460276}, // 2010K
			{0.525487879, 0.413476301}, // 2011K
			{0.525379201, 0.413492248}, // 2012K
			{0.52527056, 0.413508117}, // 2013K
			{0.525161958, 0.413523909}, // 2014K
			{0.525053394, 0.413539623}, // 2015K
			{0.524944869, 0.413555259}, // 2016K
			{0.524836381, 0.413570817}, // 2017K
			{0.524727931, 0.413586299}, // 2018K
			{0.52461952, 0.413601703}, // 2019K
			{0.524511147, 0.413617029}, // 2020K
			{0.524402812, 0.413632279}, // 2021K
			{0.524294515, 0.413647451}, // 2022K
			{0.524186256, 0.413662547}, // 2023K
			{0.524078036, 0.413677565}, // 2024K
			{0.523969854, 0.413692507}, // 2025K
			{0.52386171, 0.413707373}, // 2026K
			{0.523753604, 0.413722161}, // 2027K
			{0.523645536, 0.413736873}, // 2028K
			{0.523537507, 0.413751509}, // 2029K
			{0.523429516, 0.413766068}, // 2030K
			{0.523321563, 0.413780552}, // 2031K
			{0.523213649, 0.413794959}, // 2032K
			{0.523105773, 0.41380929}, // 2033K
			{0.522997935, 0.413823545}, // 2034K
			{0.522890135, 0.413837724}, // 2035K
			{0.522782374, 0.413851828}, // 2036K
			{0.522674651, 0.413865855}, // 2037K
			{0.522566967, 0.413879808}, // 2038K
			{0.522459321, 0.413893684}, // 2039K
			{0.522351713, 0.413907486}, // 2040K
			{0.522244143, 0.413921212}, // 2041K
			{0.522136612, 0.413934862}, // 2042K
			{0.522029119, 0.413948438}, // 2043K
			{0.521921665, 0.413961939}, // 2044K
			{0.521814249, 0.413975365}, // 2045K
			{0.521706871, 0.413988715}, // 2046K
			{0.521599532, 0.414001992}, // 2047K
			{0.521492232, 0.414015193}, // 2048K
			{0.521384969, 0.41402832}, // 2049K
			{0.521277745, 0.414041372}, // 2050K
			{0.52117056, 0.41405435}, // 2051K
			{0.521063413, 0.414067254}, // 2052K
			{0.520956305, 0.414080084}, // 2053K
			{0.520849235, 0.414092839}, // 2054K
			{0.520742203, 0.41410552}, // 2055K
			{0.52063521, 0.414118128}, // 2056K
			{0.520528256, 0.414130662}, // 2057K
			{0.52042134, 0.414143121}, // 2058K
			{0.520314462, 0.414155508}, // 2059K
			{0.520207623, 0.41416782}, // 2060K
			{0.520100823, 0.414180059}, // 2061K
			{0.519994061, 0.414192225}, // 2062K
			{0.519887338, 0.414204318}, // 2063K
			{0.519780653, 0.414216337}, // 2064K
			{0.519674007, 0.414228283}, // 2065K
			{0.519567399, 0.414240156}, // 2066K
			{0.51946083, 0.414251956}, // 2067K
			{0.5193543, 0.414263684}, // 2068K
			{0.519247808, 0.414275338}, // 2069K
			{0.519141355, 0.41428692}, // 2070K
			{0.51903494, 0.41429843}, // 2071K
			{0.518928564, 0.414309867}, // 2072K
			{0.518822227, 0.414321231}, // 2073K
			{0.518715928, 0.414332523}, // 2074K
			{0.518609668, 0.414343743}, // 2075K
			{0.518503447, 0.414354891}, // 2076K
			{0.518397264, 0.414365967}, // 2077K
			{0.51829112, 0.414376971}, // 2078K
			{0.518185015, 0.414387903}, // 2079K
			{0.518078948, 0.414398763}, // 2080K
			{0.51797292, 0.414409552}, // 2081K
			{0.517866931, 0.414420269}, // 2082K
			{0.517760981, 0.414430915}, // 2083K
			{0.517655069, 0.414441489}, // 2084K
			{0.517549196, 0.414451992}, // 2085K
			{0.517443361, 0.414462423}, // 2086K
			{0.517337566, 0.414472784}, // 2087K
			{0.517231809, 0.414483074}, // 2088K
			{0.517126091, 0.414493292}, // 2089K
			{0.517020411, 0.41450344}, // 2090K
			{0.516914771, 0.414513517}, // 2091K
			{0.516809169, 0.414523523}, // 2092K
			{0.516703606, 0.414533459}, // 2093K
			{0.516598082, 0.414543324}, // 2094K
			{0.516492596, 0.414553119}, // 2095K
			{0.51638715, 0.414562844}, // 2096K
			{0.516281742, 0.414572498}, // 2097K
			{0.516176373, 0.414582082}, // 2098K
			{0.516071043, 0.414591596}, // 2099K
			{0.515965752, 0.41460104}, // 2100K
			{0.515860499, 0.414610415}, // 2101K
			{0.515755286, 0.414619719}, // 2102K
			{0.515650111, 0.414628954}, // 2103K
			{0.515544975, 0.414638119}, // 2104K
			{0.515439878, 0.414647215}, // 2105K
			{0.51533482, 0.414656241}, // 2106K
			{0.5152298, 0.414665198}, // 2107K
			{0.51512482, 0.414674086}, // 2108K
			{0.515019879, 0.414682904}, // 2109K
			{0.514914976, 0.414691654}, // 2110K
			{0.514810112, 0.414700335}, // 2111K
			{0.514705288, 0.414708946}, // 2112K
			{0.514600502, 0.414717489}, // 2113K
			{0.514495755, 0.414725963}, // 2114K
			{0.514391047, 0.414734369}, // 2115K
			{0.514286378, 0.414742706}, // 2116K
			{0.514181748, 0.414750975}, // 2117K
			{0.514077157, 0.414759175}, // 2118K
			{0.513972605, 0.414767307}, // 2119K
			{0.513868092, 0.414775371}, // 2120K
			{0.513763618, 0.414783366}, // 2121K
			{0.513659182, 0.414791294}, // 2122K
			{0.513554786, 0.414799154}, // 2123K
			{0.513450429, 0.414806946}, // 2124K
			{0.513346111, 0.41481467}, // 2125K
			{0.513241832, 0.414822327}, // 2126K
			{0.513137592, 0.414829916}, // 2127K
			{0.51303339, 0.414837438}, // 2128K
			{0.512929228, 0.414844892}, // 2129K
			{0.512825105, 0.414852279}, // 2130K
			{0.512721021, 0.414859599}, // 2131K
			{0.512616976, 0.414866851}, // 2132K
			{0.51251297, 0.414874037}, // 2133K
			{0.512409003, 0.414881156}, // 2134K
			{0.512305075, 0.414888208}, // 2135K
			{0.512201187, 0.414895193}, // 2136K
			{0.512097337, 0.414902111}, // 2137K
			{0.511993526, 0.414908963}, // 2138K
			{0.511889755, 0.414915749}, // 2139K
			{0.511786022, 0.414922468}, // 2140K
			{0.511682329, 0.41492912}, // 2141K
			{0.511578675, 0.414935707}, // 2142K
			{0.51147506, 0.414942227}, // 2143K
			{0.511371484, 0.414948681}, // 2144K
			{0.511267947, 0.41495507}, // 2145K
			{0.511164449, 0.414961392}, // 2146K
			{0.51106099, 0.414967649}, // 2147K
			{0.510957571, 0.41497384}, // 2148K
			{0.510854191, 0.414979965}, // 2149K
			{0.510750849, 0.414986025}, // 2150K
			{0.510647547, 0.414992019}, // 2151K
			{0.510544284, 0.414997948}, // 2152K
			{0.510441061, 0.415003812}, // 2153K
			{0.510337876, 0.41500961}, // 2154K
			{0.510234731, 0.415015344}, // 2155K
			{0.510131625, 0.415021012}, // 2156K
			{0.510028557, 0.415026616}, // 2157K
			{0.50992553, 0.415032154}, // 2158K
			{0.509822541, 0.415037628}, // 2159K
			{0.509719592, 0.415043038}, // 2160K
			{0.509616681, 0.415048382}, // 2161K
			{0.50951381, 0.415053663}, // 2162K
			{0.509410978, 0.415058879}, // 2163K
			{0.509308186, 0.41506403}, // 2164K
			{0.509205432, 0.415069118}, // 2165K
			{0.509102718, 0.415074141}, // 2166K
			{0.509000043, 0.4150791}, // 2167K
			{0.508897408, 0.415083995}, // 2168K
			{0.508794811, 0.415088826}, // 2169K
			{0.508692254, 0.415093594}, // 2170K
			{0.508589736, 0.415098298}, // 2171K
			{0.508487257, 0.415102938}, // 2172K
			{0.508384818, 0.415107515}, // 2173K
			{0.508282418, 0.415112028}, // 2174K
			{0.508180057, 0.415116478}, // 2175K
			{0.508077735, 0.415120864}, // 2176K
			{0.507975453, 0.415125188}, // 2177K
			{0.50787321, 0.415129448}, // 2178K
			{0.507771006, 0.415133645}, // 2179K
			{0.507668841, 0.41513778}, // 2180K
			{0.507566716, 0.415141851}, // 2181K
			{0.50746463, 0.41514586}, // 2182K
			{0.507362584, 0.415149806}, // 2183K
			{0.507260576, 0.41515369}, // 2184K
			{0.507158608, 0.415157511}, // 2185K
			{0.50705668, 0.41516127}, // 2186K
			{0.50695479, 0.415164966}, // 2187K
			{0.50685294, 0.4151686}, // 2188K
			{0.50675113, 0.415172172}, // 2189K
			{0.506649358, 0.415175682}, // 2190K
			{0.506547626, 0.415179129}, // 2191K
			{0.506445934, 0.415182515}, // 2192K
			{0.50634428, 0.41518584}, // 2193K
			{0.506242666, 0.415189102}, // 2194K
			{0.506141092, 0.415192303}, // 2195K
			{0.506039557, 0.415195442}, // 2196K
			{0.505938061, 0.41519852}, // 2197K
			{0.505836604, 0.415201536}, // 2198K
			{0.505735187, 0.415204491}, // 2199K
			{0.505633809, 0.415207385}, // 2200K
			{0.505532471, 0.415210218}, // 2201K
			{0.505431172, 0.415212989}, // 2202K
			{0.505329912, 0.4152157}, // 2203K
			{0.505228692, 0.41521835}, // 2204K
			{0.505127511, 0.415220939}, // 2205K
			{0.505026369, 0.415223467}, // 2206K
			{0.504925267, 0.415225935}, // 2207K
			{0.504824204, 0.415228342}, // 2208K
			{0.504723181, 0.415230688}, // 2209K
			{0.504622197, 0.415232975}, // 2210K
			{0.504521253, 0.415235201}, // 2211K
			{0.504420348, 0.415237366}, // 2212K
			{0.504319482, 0.415239472}, // 2213K
			{0.504218656, 0.415241518}, // 2214K
			{0.504117869, 0.415243503}, // 2215K
			{0.504017121, 0.415245429}, // 2216K
			{0.503916413, 0.415247295}, // 2217K
			{0.503815745, 0.415249102}, // 2218K
			{0.503715116, 0.415250848}, // 2219K
			{0.503614526, 0.415252536}, // 2220K
			{0.503513976, 0.415254163}, // 2221K
			{0.503413465, 0.415255732}, // 2222K
			{0.503312994, 0.415257241}, // 2223K
			{0.503212562, 0.415258691}, // 2224K
			{0.503112169, 0.415260081}, // 2225K
			{0.503011816, 0.415261413}, // 2226K
			{0.502911503, 0.415262686}, // 2227K
			{0.502811229, 0.4152639}, // 2228K
			{0.502710994, 0.415265055}, // 2229K
			{0.502610799, 0.415266151}, // 2230K
			{0.502510643, 0.415267189}, // 2231K
			{0.502410527, 0.415268169}, // 2232K
			{0.50231045, 0.415269089}, // 2233K
			{0.502210413, 0.415269952}, // 2234K
			{0.502110415, 0.415270756}, // 2235K
			{0.502010457, 0.415271502}, // 2236K
			{0.501910538, 0.41527219}, // 2237K
			{0.501810659, 0.41527282}, // 2238K
			{0.501710819, 0.415273392}, // 2239K
			{0.501611018, 0.415273906}, // 2240K
			{0.501511258, 0.415274362}, // 2241K
			{0.501411536, 0.415274761}, // 2242K
			{0.501311854, 0.415275101}, // 2243K
			{0.501212212, 0.415275385}, // 2244K
			{0.501112609, 0.415275611}, // 2245K
			{0.501013045, 0.415275779}, // 2246K
			{0.500913522, 0.41527589}, // 2247K
			{0.500814037, 0.415275944}, // 2248K
			{0.500714592, 0.415275941}, // 2249K
			{0.500615187, 0.415275881}, // 2250K
			{0.500515821, 0.415275764}, // 2251K
			{0.500416495, 0.41527559}, // 2252K
			{0.500317208, 0.415275359}, // 2253K
			{0.500217961, 0.415275072}, // 2254K
			{0.500118753, 0.415274728}, // 2255K
			{0.500019584, 0.415274327}, // 2256K
			{0.499920456, 0.41527387}, // 2257K
			{0.499821366, 0.415273356}, // 2258K
			{0.499722317, 0.415272786}, // 2259K
			{0.499623307, 0.41527216}, // 2260K
			{0.499524336, 0.415271478}, // 2261K
			{0.499425405, 0.41527074}, // 2262K
			{0.499326513, 0.415269945}, // 2263K
			{0.499227661, 0.415269095}, // 2264K
			{0.499128849, 0.415268189}, // 2265K
			{0.499030076, 0.415267227}, // 2266K
			{0.498931342, 0.41526621}, // 2267K
			{0.498832648, 0.415265137}, // 2268K
			{0.498733994, 0.415264008}, // 2269K
			{0.498635379, 0.415262824}, // 2270K
			{0.498536804, 0.415261585}, // 2271K
			{0.498438268, 0.41526029}, // 2272K
			{0.498339772, 0.41525894}, // 2273K
			{0.498241315, 0.415257536}, // 2274K
			{0.498142898, 0.415256076}, // 2275K
			{0.49804452, 0.415254561}, // 2276K
			{0.497946182, 0.415252991}, // 2277K
			{0.497847884, 0.415251367}, // 2278K
			{0.497749625, 0.415249688}, // 2279K
			{0.497651406, 0.415247954}, // 2280K
			{0.497553226, 0.415246166}, // 2281K
			{0.497455085, 0.415244323}, // 2282K
			{0.497356985, 0.415242426}, // 2283K
			{0.497258924, 0.415240475}, // 2284K
			{0.497160902, 0.415238469}, // 2285K
			{0.49706292, 0.415236409}, // 2286K
			{0.496964977, 0.415234295}, // 2287K
			{0.496867075, 0.415232128}, // 2288K
			{0.496769211, 0.415229906}, // 2289K
			{0.496671387, 0.41522763}, // 2290K
			{0.496573603, 0.415225301}, // 2291K
			{0.496475858, 0.415222918}, // 2292K
			{0.496378153, 0.415220482}, // 2293K
			{0.496280488, 0.415217992}, // 2294K
			{0.496182862, 0.415215448}, // 2295K
			{0.496085275, 0.415212852}, // 2296K
			{0.495987728, 0.415210202}, // 2297K
			{0.495890221, 0.415207499}, // 2298K
			{0.495792753, 0.415204742}, // 2299K
			{0.495695325, 0.415201933}, // 2300K
			{0.495597937, 0.415199071}, // 2301K
			{0.495500588, 0.415196156}, // 2302K
			{0.495403278, 0.415193188}, // 2303K
			{0.495306008, 0.415190167}, // 2304K
			{0.495208778, 0.415187094}, // 2305K
			{0.495111587, 0.415183968}, // 2306K
			{0.495014436, 0.41518079}, // 2307K
			{0.494917324, 0.415177559}, // 2308K
			{0.494820252, 0.415174276}, // 2309K
			{0.494723219, 0.415170941}, // 2310K
			{0.494626226, 0.415167553}, // 2311K
			{0.494529273, 0.415164114}, // 2312K
			{0.494432359, 0.415160623}, // 2313K
			{0.494335485, 0.415157079}, // 2314K
			{0.49423865, 0.415153484}, // 2315K
			{0.494141855, 0.415149837}, // 2316K
			{0.494045099, 0.415146138}, // 2317K
			{0.493948383, 0.415142388}, // 2318K
			{0.493851707, 0.415138586}, // 2319K
			{0.49375507, 0.415134733}, // 2320K
			{0.493658473, 0.415130828}, // 2321K
			{0.493561915, 0.415126872}, // 2322K
			{0.493465397, 0.415122865}, // 2323K
			{0.493368918, 0.415118806}, // 2324K
			{0.493272479, 0.415114697}, // 2325K
			{0.493176079, 0.415110536}, // 2326K
			{0.493079719, 0.415106325}, // 2327K
			{0.492983399, 0.415102063}, // 2328K
			{0.492887118, 0.41509775}, // 2329K
			{0.492790877, 0.415093386}, // 2330K
			{0.492694675, 0.415088972}, // 2331K
			{0.492598513, 0.415084507}, // 2332K
			{0.49250239, 0.415079991}, // 2333K
			{0.492406307, 0.415075426}, // 2334K
			{0.492310264, 0.41507081}, // 2335K
			{0.49221426, 0.415066144}, // 2336K
			{0.492118295, 0.415061427}, // 2337K
			{0.49202237, 0.415056661}, // 2338K
			{0.491926485, 0.415051844}, // 2339K
			{0.491830639, 0.415046978}, // 2340K
			{0.491734833, 0.415042062}, // 2341K
			{0.491639066, 0.415037096}, // 2342K
			{0.491543339, 0.41503208}, // 2343K
			{0.491447652, 0.415027015}, // 2344K
			{0.491352004, 0.4150219}, // 2345K
			{0.491256395, 0.415016736}, // 2346K
			{0.491160826, 0.415011522}, // 2347K
			{0.491065297, 0.415006259}, // 2348K
			{0.490969807, 0.415000947}, // 2349K
			{0.490874356, 0.414995585}, // 2350K
			{0.490778946, 0.414990175}, // 2351K
			{0.490683574, 0.414984715}, // 2352K
			{0.490588242, 0.414979207}, // 2353K
			{0.49049295, 0.41497365}, // 2354K
			{0.490397698, 0.414968044}, // 2355K
			{0.490302484, 0.414962389}, // 2356K
			{0.490207311, 0.414956685}, // 2357K
			{0.490112177, 0.414950934}, // 2358K
			{0.490017082, 0.414945133}, // 2359K
			{0.489922027, 0.414939284}, // 2360K
			{0.489827011, 0.414933387}, // 2361K
			{0.489732035, 0.414927441}, // 2362K
			{0.489637099, 0.414921448}, // 2363K
			{0.489542202, 0.414915406}, // 2364K
			{0.489447344, 0.414909316}, // 2365K
			{0.489352526, 0.414903178}, // 2366K
			{0.489257748, 0.414896993}, // 2367K
			{0.489163009, 0.414890759}, // 2368K
			{0.489068309, 0.414884478}, // 2369K
			{0.488973649, 0.414878149}, // 2370K
			{0.488879029, 0.414871773}, // 2371K
			{0.488784448, 0.414865349}, // 2372K
			{0.488689907, 0.414858877}, // 2373K
			{0.488595405, 0.414852359}, // 2374K
			{0.488500942, 0.414845793}, // 2375K
			{0.488406519, 0.414839179}, // 2376K
			{0.488312136, 0.414832519}, // 2377K
			{0.488217792, 0.414825811}, // 2378K
			{0.488123487, 0.414819057}, // 2379K
			{0.488029222, 0.414812255}, // 2380K
			{0.487934997, 0.414805407}, // 2381K
			{0.487840811, 0.414798512}, // 2382K
			{0.487746664, 0.41479157}, // 2383K
			{0.487652557, 0.414784582}, // 2384K
			{0.487558489, 0.414777547}, // 2385K
			{0.487464461, 0.414770465}, // 2386K
			{0.487370472, 0.414763338}, // 2387K
			{0.487276523, 0.414756163}, // 2388K
			{0.487182613, 0.414748943}, // 2389K
			{0.487088743, 0.414741676}, // 2390K
			{0.486994912, 0.414734364}, // 2391K
			{0.48690112, 0.414727005}, // 2392K
			{0.486807369, 0.4147196}, // 2393K
			{0.486713656, 0.414712149}, // 2394K
			{0.486619983, 0.414704653}, // 2395K
			{0.486526349, 0.41469711}, // 2396K
			{0.486432755, 0.414689522}, // 2397K
			{0.4863392, 0.414681889}, // 2398K
			{0.486245685, 0.41467421}, // 2399K
			{0.486152209, 0.414666485}, // 2400K
			{0.486058773, 0.414658715}, // 2401K
			{0.485965376, 0.4146509}, // 2402K
			{0.485872018, 0.414643039}, // 2403K
			{0.4857787, 0.414635134}, // 2404K
			{0.485685421, 0.414627183}, // 2405K
			{0.485592182, 0.414619187}, // 2406K
			{0.485498982, 0.414611146}, // 2407K
			{0.485405821, 0.41460306}, // 2408K
			{0.4853127, 0.41459493}, // 2409K
			{0.485219618, 0.414586755}, // 2410K
			{0.485126576, 0.414578535}, // 2411K
			{0.485033573, 0.41457027}, // 2412K
			{0.484940609, 0.414561961}, // 2413K
			{0.484847685, 0.414553607}, // 2414K
			{0.4847548, 0.414545209}, // 2415K
			{0.484661955, 0.414536767}, // 2416K
			{0.484569149, 0.414528281}, // 2417K
			{0.484476382, 0.41451975}, // 2418K
			{0.484383655, 0.414511175}, // 2419K
			{0.484290967, 0.414502556}, // 2420K
			{0.484198318, 0.414493893}, // 2421K
			{0.484105709, 0.414485187}, // 2422K
			{0.484013139, 0.414476436}, // 2423K
			{0.483920609, 0.414467642}, // 2424K
			{0.483828118, 0.414458804}, // 2425K
			{0.483735666, 0.414449922}, // 2426K
			{0.483643254, 0.414440997}, // 2427K
			{0.48355088, 0.414432029}, // 2428K
			{0.483458547, 0.414423017}, // 2429K
			{0.483366252, 0.414413961}, // 2430K
			{0.483273997, 0.414404863}, // 2431K
			{0.483181781, 0.414395721}, // 2432K
			{0.483089605, 0.414386536}, // 2433K
			{0.482997468, 0.414377308}, // 2434K
			{0.48290537, 0.414368037}, // 2435K
			{0.482813311, 0.414358723}, // 2436K
			{0.482721292, 0.414349367}, // 2437K
			{0.482629312, 0.414339967}, // 2438K
			{0.482537372, 0.414330525}, // 2439K
			{0.48244547, 0.41432104}, // 2440K
			{0.482353608, 0.414311513}, // 2441K
			{0.482261786, 0.414301943}, // 2442K
			{0.482170002, 0.414292331}, // 2443K
			{0.482078258, 0.414282676}, // 2444K
			{0.481986553, 0.414272979}, // 2445K
			{0.481894887, 0.41426324}, // 2446K
			{0.481803261, 0.414253459}, // 2447K
			{0.481711674, 0.414243636}, // 2448K
			{0.481620126, 0.41423377}, // 2449K
			{0.481528618, 0.414223863}, // 2450K
			{0.481437148, 0.414213914}, // 2451K
			{0.481345718, 0.414203923}, // 2452K
			{0.481254327, 0.41419389}, // 2453K
			{0.481162976, 0.414183816}, // 2454K
			{0.481071663, 0.4141737}, // 2455K
			{0.48098039, 0.414163542}, // 2456K
			{0.480889156, 0.414153343}, // 2457K
			{0.480797961, 0.414143103}, // 2458K
			{0.480706806, 0.414132821}, // 2459K
			{0.480615689, 0.414122498}, // 2460K
			{0.480524612, 0.414112134}, // 2461K
			{0.480433574, 0.414101729}, // 2462K
			{0.480342576, 0.414091283}, // 2463K
			{0.480251616, 0.414080795}, // 2464K
			{0.480160696, 0.414070267}, // 2465K
			{0.480069815, 0.414059698}, // 2466K
			{0.479978973, 0.414049088}, // 2467K
			{0.47988817, 0.414038438}, // 2468K
			{0.479797406, 0.414027746}, // 2469K
			{0.479706682, 0.414017015}, // 2470K
			{0.479615996, 0.414006242}, // 2471K
			{0.47952535, 0.41399543}, // 2472K
			{0.479434743, 0.413984576}, // 2473K
			{0.479344175, 0.413973683}, // 2474K
			{0.479253647, 0.413962749}, // 2475K
			{0.479163157, 0.413951776}, // 2476K
			{0.479072706, 0.413940762}, // 2477K
			{0.478982295, 0.413929708}, // 2478K
			{0.478891923, 0.413918614}, // 2479K
			{0.47880159, 0.41390748}, // 2480K
			{0.478711296, 0.413896306}, // 2481K
			{0.478621041, 0.413885092}, // 2482K
			{0.478530825, 0.413873839}, // 2483K
			{0.478440648, 0.413862546}, // 2484K
			{0.47835051, 0.413851214}, // 2485K
			{0.478260412, 0.413839842}, // 2486K
			{0.478170352, 0.413828431}, // 2487K
			{0.478080332, 0.41381698}, // 2488K
			{0.47799035, 0.41380549}, // 2489K
			{0.477900408, 0.41379396}, // 2490K
			{0.477810505, 0.413782392}, // 2491K
			{0.477720641, 0.413770784}, // 2492K
			{0.477630816, 0.413759138}, // 2493K
			{0.477541029, 0.413747452}, // 2494K
			{0.477451282, 0.413735727}, // 2495K
			{0.477361574, 0.413723964}, // 2496K
			{0.477271905, 0.413712162}, // 2497K
			{0.477182275, 0.413700321}, // 2498K
			{0.477092684, 0.413688441}, // 2499K
			{0.477003132, 0.413676523}, // 2500K
			{0.476913619, 0.413664566}, // 2501K
			{0.476824145, 0.413652571}, // 2502K
			{0.47673471, 0.413640538}, // 2503K
			{0.476645314, 0.413628466}, // 2504K
			{0.476555957, 0.413616356}, // 2505K
			{0.476466639, 0.413604207}, // 2506K
			{0.47637736, 0.413592021}, // 2507K
			{0.476288119, 0.413579796}, // 2508K
			{0.476198918, 0.413567534}, // 2509K
			{0.476109756, 0.413555233}, // 2510K
			{0.476020633, 0.413542895}, // 2511K
			{0.475931548, 0.413530519}, // 2512K
			{0.475842503, 0.413518105}, // 2513K
			{0.475753496, 0.413505653}, // 2514K
			{0.475664529, 0.413493164}, // 2515K
			{0.4755756, 0.413480638}, // 2516K
			{0.47548671, 0.413468073}, // 2517K
			{0.475397859, 0.413455472}, // 2518K
			{0.475309047, 0.413442833}, // 2519K
			{0.475220274, 0.413430156}, // 2520K
			{0.47513154, 0.413417443}, // 2521K
			{0.475042844, 0.413404692}, // 2522K
			{0.474954188, 0.413391904}, // 2523K
			{0.47486557, 0.413379079}, // 2524K
			{0.474776991, 0.413366217}, // 2525K
			{0.474688451, 0.413353319}, // 2526K
			{0.47459995, 0.413340383}, // 2527K
			{0.474511488, 0.413327411}, // 2528K
			{0.474423065, 0.413314401}, // 2529K
			{0.47433468, 0.413301356}, // 2530K
			{0.474246334, 0.413288273}, // 2531K
			{0.474158027, 0.413275154}, // 2532K
			{0.474069759, 0.413261999}, // 2533K
			{0.47398153, 0.413248807}, // 2534K
			{0.473893339, 0.413235579}, // 2535K
			{0.473805187, 0.413222315}, // 2536K
			{0.473717074, 0.413209014}, // 2537K
			{0.473629, 0.413195677}, // 2538K
			{0.473540965, 0.413182304}, // 2539K
			{0.473452968, 0.413168895}, // 2540K
			{0.47336501, 0.41315545}, // 2541K
			{0.473277091, 0.41314197}, // 2542K
			{0.47318921, 0.413128453}, // 2543K
			{0.473101369, 0.413114901}, // 2544K
			{0.473013566, 0.413101312}, // 2545K
			{0.472925801, 0.413087689}, // 2546K
			{0.472838076, 0.413074029}, // 2547K
			{0.472750389, 0.413060334}, // 2548K
			{0.472662741, 0.413046604}, // 2549K
			{0.472575131, 0.413032838}, // 2550K
			{0.472487561, 0.413019037}, // 2551K
			{0.472400029, 0.4130052}, // 2552K
			{0.472312535, 0.412991329}, // 2553K
			{0.47222508, 0.412977422}, // 2554K
			{0.472137664, 0.41296348}, // 2555K
			{0.472050287, 0.412949503}, // 2556K
			{0.471962948, 0.412935491}, // 2557K
			{0.471875648, 0.412921444}, // 2558K
			{0.471788386, 0.412907362}, // 2559K
			{0.471701163, 0.412893246}, // 2560K
			{0.471613979, 0.412879095}, // 2561K
			{0.471526833, 0.412864909}, // 2562K
			{0.471439726, 0.412850688}, // 2563K
			{0.471352658, 0.412836433}, // 2564K
			{0.471265628, 0.412822144}, // 2565K
			{0.471178637, 0.412807819}, // 2566K
			{0.471091684, 0.412793461}, // 2567K
			{0.47100477, 0.412779068}, // 2568K
			{0.470917894, 0.412764642}, // 2569K
			{0.470831057, 0.41275018}, // 2570K
			{0.470744259, 0.412735685}, // 2571K
			{0.470657499, 0.412721156}, // 2572K
			{0.470570777, 0.412706593}, // 2573K
			{0.470484094, 0.412691995}, // 2574K
			{0.47039745, 0.412677364}, // 2575K
			{0.470310844, 0.412662699}, // 2576K
			{0.470224277, 0.412648}, // 2577K
			{0.470137748, 0.412633268}, // 2578K
			{0.470051257, 0.412618502}, // 2579K
			{0.469964805, 0.412603702}, // 2580K
			{0.469878392, 0.412588869}, // 2581K
			{0.469792017, 0.412574002}, // 2582K
			{0.46970568, 0.412559102}, // 2583K
			{0.469619382, 0.412544169}, // 2584K
			{0.469533122, 0.412529202}, // 2585K
			{0.469446901, 0.412514202}, // 2586K
			{0.469360718, 0.412499169}, // 2587K
			{0.469274574, 0.412484103}, // 2588K
			{0.469188468, 0.412469004}, // 2589K
			{0.4691024, 0.412453872}, // 2590K
			{0.469016371, 0.412438706}, // 2591K
			{0.46893038, 0.412423508}, // 2592K
			{0.468844428, 0.412408278}, // 2593K
			{0.468758514, 0.412393014}, // 2594K
			{0.468672638, 0.412377718}, // 2595K
			{0.468586801, 0.412362389}, // 2596K
			{0.468501002, 0.412347027}, // 2597K
			{0.468415241, 0.412331633}, // 2598K
			{0.468329519, 0.412316207}, // 2599K
			{0.468243835, 0.412300748}, // 2600K
			{0.468158189, 0.412285257}, // 2601K
			{0.468072582, 0.412269733}, // 2602K
			{0.467987013, 0.412254177}, // 2603K
			{0.467901482, 0.412238589}, // 2604K
			{0.46781599, 0.412222969}, // 2605K
			{0.467730535, 0.412207317}, // 2606K
			{0.467645119, 0.412191633}, // 2607K
			{0.467559742, 0.412175917}, // 2608K
			{0.467474402, 0.412160169}, // 2609K
			{0.467389101, 0.41214439}, // 2610K
			{0.467303838, 0.412128578}, // 2611K
			{0.467218613, 0.412112735}, // 2612K
			{0.467133427, 0.41209686}, // 2613K
			{0.467048279, 0.412080954}, // 2614K
			{0.466963169, 0.412065016}, // 2615K
			{0.466878097, 0.412049046}, // 2616K
			{0.466793063, 0.412033045}, // 2617K
			{0.466708067, 0.412017013}, // 2618K
			{0.46662311, 0.41200095}, // 2619K
			{0.466538191, 0.411984855}, // 2620K
			{0.46645331, 0.411968729}, // 2621K
			{0.466368467, 0.411952572}, // 2622K
			{0.466283662, 0.411936384}, // 2623K
			{0.466198895, 0.411920165}, // 2624K
			{0.466114167, 0.411903914}, // 2625K
			{0.466029476, 0.411887633}, // 2626K
			{0.465944824, 0.411871322}, // 2627K
			{0.46586021, 0.411854979}, // 2628K
			{0.465775634, 0.411838605}, // 2629K
			{0.465691096, 0.411822201}, // 2630K
			{0.465606596, 0.411805767}, // 2631K
			{0.465522134, 0.411789301}, // 2632K
			{0.46543771, 0.411772806}, // 2633K
			{0.465353324, 0.411756279}, // 2634K
			{0.465268976, 0.411739723}, // 2635K
			{0.465184666, 0.411723136}, // 2636K
			{0.465100395, 0.411706518}, // 2637K
			{0.465016161, 0.411689871}, // 2638K
			{0.464931965, 0.411673193}, // 2639K
			{0.464847807, 0.411656485}, // 2640K
			{0.464763687, 0.411639748}, // 2641K
			{0.464679606, 0.41162298}, // 2642K
			{0.464595562, 0.411606182}, // 2643K
			{0.464511556, 0.411589354}, // 2644K
			{0.464427588, 0.411572497}, // 2645K
			{0.464343658, 0.411555609}, // 2646K
			{0.464259766, 0.411538692}, // 2647K
			{0.464175911, 0.411521746}, // 2648K
			{0.464092095, 0.411504769}, // 2649K
			{0.464008317, 0.411487763}, // 2650K
			{0.463924576, 0.411470728}, // 2651K
			{0.463840874, 0.411453663}, // 2652K
			{0.463757209, 0.411436569}, // 2653K
			{0.463673582, 0.411419445}, // 2654K
			{0.463589993, 0.411402292}, // 2655K
			{0.463506442, 0.41138511}, // 2656K
			{0.463422929, 0.411367899}, // 2657K
			{0.463339453, 0.411350658}, // 2658K
			{0.463256015, 0.411333389}, // 2659K
			{0.463172616, 0.41131609}, // 2660K
			{0.463089253, 0.411298763}, // 2661K
			{0.463005929, 0.411281406}, // 2662K
			{0.462922643, 0.411264021}, // 2663K
			{0.462839394, 0.411246607}, // 2664K
			{0.462756183, 0.411229164}, // 2665K
			{0.46267301, 0.411211693}, // 2666K
			{0.462589874, 0.411194193}, // 2667K
			{0.462506777, 0.411176664}, // 2668K
			{0.462423717, 0.411159107}, // 2669K
			{0.462340694, 0.411141521}, // 2670K
			{0.46225771, 0.411123907}, // 2671K
			{0.462174763, 0.411106264}, // 2672K
			{0.462091854, 0.411088594}, // 2673K
			{0.462008982, 0.411070895}, // 2674K
			{0.461926149, 0.411053167}, // 2675K
			{0.461843352, 0.411035412}, // 2676K
			{0.461760594, 0.411017628}, // 2677K
			{0.461677873, 0.410999817}, // 2678K
			{0.46159519, 0.410981977}, // 2679K
			{0.461512544, 0.41096411}, // 2680K
			{0.461429936, 0.410946214}, // 2681K
			{0.461347366, 0.410928291}, // 2682K
			{0.461264833, 0.41091034}, // 2683K
			{0.461182338, 0.410892361}, // 2684K
			{0.46109988, 0.410874355}, // 2685K
			{0.46101746, 0.410856321}, // 2686K
			{0.460935078, 0.410838259}, // 2687K
			{0.460852733, 0.41082017}, // 2688K
			{0.460770425, 0.410802054}, // 2689K
			{0.460688155, 0.41078391}, // 2690K
			{0.460605923, 0.410765738}, // 2691K
			{0.460523728, 0.41074754}, // 2692K
			{0.460441571, 0.410729314}, // 2693K
			{0.460359451, 0.410711061}, // 2694K
			{0.460277369, 0.41069278}, // 2695K
			{0.460195324, 0.410674473}, // 2696K
			{0.460113316, 0.410656139}, // 2697K
			{0.460031346, 0.410637777}, // 2698K
			{0.459949414, 0.410619389}, // 2699K
			{0.459867518, 0.410600974}, // 2700K
			{0.459785661, 0.410582531}, // 2701K
			{0.45970384, 0.410564063}, // 2702K
			{0.459622058, 0.410545567}, // 2703K
			{0.459540312, 0.410527045}, // 2704K
			{0.459458604, 0.410508496}, // 2705K
			{0.459376933, 0.41048992}, // 2706K
			{0.4592953, 0.410471318}, // 2707K
			{0.459213704, 0.41045269}, // 2708K
			{0.459132145, 0.410434035}, // 2709K
			{0.459050624, 0.410415354}, // 2710K
			{0.45896914, 0.410396646}, // 2711K
			{0.458887693, 0.410377912}, // 2712K
			{0.458806283, 0.410359152}, // 2713K
			{0.458724911, 0.410340366}, // 2714K
			{0.458643576, 0.410321553}, // 2715K
			{0.458562279, 0.410302715}, // 2716K
			{0.458481018, 0.41028385}, // 2717K
			{0.458399795, 0.41026496}, // 2718K
			{0.458318609, 0.410246043}, // 2719K
			{0.458237461, 0.410227101}, // 2720K
			{0.458156349, 0.410208133}, // 2721K
			{0.458075275, 0.410189139}, // 2722K
			{0.457994238, 0.41017012}, // 2723K
			{0.457913238, 0.410151074}, // 2724K
			{0.457832276, 0.410132004}, // 2725K
			{0.45775135, 0.410112907}, // 2726K
			{0.457670462, 0.410093785}, // 2727K
			{0.457589611, 0.410074638}, // 2728K
			{0.457508797, 0.410055465}, // 2729K
			{0.45742802, 0.410036267}, // 2730K
			{0.45734728, 0.410017044}, // 2731K
			{0.457266578, 0.409997795}, // 2732K
			{0.457185912, 0.409978521}, // 2733K
			{0.457105284, 0.409959222}, // 2734K
			{0.457024692, 0.409939898}, // 2735K
			{0.456944138, 0.409920548}, // 2736K
			{0.456863621, 0.409901174}, // 2737K
			{0.45678314, 0.409881775}, // 2738K
			{0.456702697, 0.409862351}, // 2739K
			{0.456622291, 0.409842902}, // 2740K
			{0.456541922, 0.409823428}, // 2741K
			{0.45646159, 0.409803929}, // 2742K
			{0.456381294, 0.409784406}, // 2743K
			{0.456301036, 0.409764858}, // 2744K
			{0.456220815, 0.409745285}, // 2745K
			{0.456140631, 0.409725688}, // 2746K
			{0.456060484, 0.409706066}, // 2747K
			{0.455980373, 0.40968642}, // 2748K
			{0.4559003, 0.409666749}, // 2749K
			{0.455820263, 0.409647054}, // 2750K
			{0.455740264, 0.409627335}, // 2751K
			{0.455660301, 0.409607591}, // 2752K
			{0.455580375, 0.409587823}, // 2753K
			{0.455500486, 0.409568031}, // 2754K
			{0.455420634, 0.409548215}, // 2755K
			{0.455340819, 0.409528375}, // 2756K
			{0.45526104, 0.40950851}, // 2757K
			{0.455181299, 0.409488622}, // 2758K
			{0.455101594, 0.40946871}, // 2759K
			{0.455021926, 0.409448774}, // 2760K
			{0.454942295, 0.409428814}, // 2761K
			{0.454862701, 0.40940883}, // 2762K
			{0.454783143, 0.409388822}, // 2763K
			{0.454703622, 0.409368791}, // 2764K
			{0.454624138, 0.409348736}, // 2765K
			{0.454544691, 0.409328658}, // 2766K
			{0.454465281, 0.409308556}, // 2767K
			{0.454385907, 0.40928843}, // 2768K
			{0.45430657, 0.409268281}, // 2769K
			{0.454227269, 0.409248109}, // 2770K
			{0.454148005, 0.409227913}, // 2771K
			{0.454068778, 0.409207694}, // 2772K
			{0.453989588, 0.409187451}, // 2773K
			{0.453910434, 0.409167186}, // 2774K
			{0.453831317, 0.409146897}, // 2775K
			{0.453752237, 0.409126585}, // 2776K
			{0.453673193, 0.40910625}, // 2777K
			{0.453594186, 0.409085892}, // 2778K
			{0.453515215, 0.409065511}, // 2779K
			{0.453436281, 0.409045107}, // 2780K
			{0.453357384, 0.40902468}, // 2781K
			{0.453278523, 0.40900423}, // 2782K
			{0.453199699, 0.408983757}, // 2783K
			{0.453120911, 0.408963262}, // 2784K
			{0.45304216, 0.408942744}, // 2785K
			{0.452963445, 0.408922203}, // 2786K
			{0.452884767, 0.40890164}, // 2787K
			{0.452806125, 0.408881054}, // 2788K
			{0.45272752, 0.408860446}, // 2789K
			{0.452648951, 0.408839815}, // 2790K
			{0.452570419, 0.408819161}, // 2791K
			{0.452491924, 0.408798486}, // 2792K
			{0.452413464, 0.408777788}, // 2793K
			{0.452335041, 0.408757067}, // 2794K
			{0.452256655, 0.408736325}, // 2795K
			{0.452178305, 0.40871556}, // 2796K
			{0.452099991, 0.408694773}, // 2797K
			{0.452021714, 0.408673964}, // 2798K
			{0.451943473, 0.408653133}, // 2799K
			{0.451865269, 0.408632279}, // 2800K
			{0.451787101, 0.408611404}, // 2801K
			{0.451708969, 0.408590507}, // 2802K
			{0.451630873, 0.408569588}, // 2803K
			{0.451552814, 0.408548647}, // 2804K
			{0.451474791, 0.408527685}, // 2805K
			{0.451396805, 0.4085067}, // 2806K
			{0.451318855, 0.408485694}, // 2807K
			{0.451240941, 0.408464667}, // 2808K
			{0.451163063, 0.408443617}, // 2809K
			{0.451085222, 0.408422546}, // 2810K
			{0.451007416, 0.408401454}, // 2811K
			{0.450929647, 0.40838034}, // 2812K
			{0.450851915, 0.408359205}, // 2813K
			{0.450774218, 0.408338048}, // 2814K
			{0.450696558, 0.40831687}, // 2815K
			{0.450618934, 0.408295671}, // 2816K
			{0.450541346, 0.40827445}, // 2817K
			{0.450463794, 0.408253208}, // 2818K
			{0.450386278, 0.408231945}, // 2819K
			{0.450308799, 0.408210661}, // 2820K
			{0.450231355, 0.408189356}, // 2821K
			{0.450153948, 0.40816803}, // 2822K
			{0.450076577, 0.408146683}, // 2823K
			{0.449999242, 0.408125314}, // 2824K
			{0.449921943, 0.408103925}, // 2825K
			{0.44984468, 0.408082516}, // 2826K
			{0.449767453, 0.408061085}, // 2827K
			{0.449690262, 0.408039633}, // 2828K
			{0.449613107, 0.408018161}, // 2829K
			{0.449535988, 0.407996668}, // 2830K
			{0.449458906, 0.407975155}, // 2831K
			{0.449381859, 0.407953621}, // 2832K
			{0.449304848, 0.407932066}, // 2833K
			{0.449227873, 0.407910491}, // 2834K
			{0.449150935, 0.407888895}, // 2835K
			{0.449074032, 0.407867279}, // 2836K
			{0.448997165, 0.407845643}, // 2837K
			{0.448920334, 0.407823986}, // 2838K
			{0.448843539, 0.407802309}, // 2839K
			{0.448766779, 0.407780612}, // 2840K
			{0.448690056, 0.407758894}, // 2841K
			{0.448613369, 0.407737157}, // 2842K
			{0.448536717, 0.407715399}, // 2843K
			{0.448460101, 0.407693621}, // 2844K
			{0.448383522, 0.407671823}, // 2845K
			{0.448306978, 0.407650005}, // 2846K
			{0.448230469, 0.407628168}, // 2847K
			{0.448153997, 0.40760631}, // 2848K
			{0.44807756, 0.407584432}, // 2849K
			{0.44800116, 0.407562535}, // 2850K
			{0.447924795, 0.407540618}, // 2851K
			{0.447848465, 0.407518681}, // 2852K
			{0.447772172, 0.407496725}, // 2853K
			{0.447695914, 0.407474749}, // 2854K
			{0.447619692, 0.407452753}, // 2855K
			{0.447543506, 0.407430737}, // 2856K
			{0.447467355, 0.407408703}, // 2857K
			{0.44739124, 0.407386648}, // 2858K
			{0.447315161, 0.407364575}, // 2859K
			{0.447239117, 0.407342481}, // 2860K
			{0.447163109, 0.407320369}, // 2861K
			{0.447087137, 0.407298237}, // 2862K
			{0.4470112, 0.407276086}, // 2863K
			{0.446935299, 0.407253916}, // 2864K
			{0.446859434, 0.407231726}, // 2865K
			{0.446783604, 0.407209518}, // 2866K
			{0.44670781, 0.40718729}, // 2867K
			{0.446632051, 0.407165043}, // 2868K
			{0.446556328, 0.407142777}, // 2869K
			{0.44648064, 0.407120493}, // 2870K
			{0.446404988, 0.407098189}, // 2871K
			{0.446329372, 0.407075867}, // 2872K
			{0.446253791, 0.407053525}, // 2873K
			{0.446178245, 0.407031165}, // 2874K
			{0.446102735, 0.407008786}, // 2875K
			{0.446027261, 0.406986388}, // 2876K
			{0.445951822, 0.406963972}, // 2877K
			{0.445876418, 0.406941537}, // 2878K
			{0.44580105, 0.406919083}, // 2879K
			{0.445725717, 0.406896611}, // 2880K
			{0.445650419, 0.40687412}, // 2881K
			{0.445575157, 0.406851611}, // 2882K
			{0.445499931, 0.406829084}, // 2883K
			{0.44542474, 0.406806538}, // 2884K
			{0.445349584, 0.406783973}, // 2885K
			{0.445274463, 0.406761391}, // 2886K
			{0.445199378, 0.40673879}, // 2887K
			{0.445124328, 0.40671617}, // 2888K
			{0.445049314, 0.406693533}, // 2889K
			{0.444974334, 0.406670878}, // 2890K
			{0.44489939, 0.406648204}, // 2891K
			{0.444824482, 0.406625512}, // 2892K
			{0.444749608, 0.406602803}, // 2893K
			{0.44467477, 0.406580075}, // 2894K
			{0.444599967, 0.406557329}, // 2895K
			{0.444525199, 0.406534566}, // 2896K
			{0.444450467, 0.406511784}, // 2897K
			{0.44437577, 0.406488985}, // 2898K
			{0.444301108, 0.406466168}, // 2899K
			{0.444226481, 0.406443333}, // 2900K
			{0.444151889, 0.40642048}, // 2901K
			{0.444077332, 0.40639761}, // 2902K
			{0.444002811, 0.406374722}, // 2903K
			{0.443928324, 0.406351817}, // 2904K
			{0.443853873, 0.406328894}, // 2905K
			{0.443779457, 0.406305953}, // 2906K
			{0.443705076, 0.406282995}, // 2907K
			{0.44363073, 0.40626002}, // 2908K
			{0.443556419, 0.406237027}, // 2909K
			{0.443482143, 0.406214017}, // 2910K
			{0.443407903, 0.40619099}, // 2911K
			{0.443333697, 0.406167945}, // 2912K
			{0.443259526, 0.406144883}, // 2913K
			{0.44318539, 0.406121804}, // 2914K
			{0.443111289, 0.406098707}, // 2915K
			{0.443037224, 0.406075594}, // 2916K
			{0.442963193, 0.406052463}, // 2917K
			{0.442889197, 0.406029316}, // 2918K
			{0.442815236, 0.406006151}, // 2919K
			{0.44274131, 0.40598297}, // 2920K
			{0.442667419, 0.405959771}, // 2921K
			{0.442593563, 0.405936556}, // 2922K
			{0.442519741, 0.405913324}, // 2923K
			{0.442445955, 0.405890075}, // 2924K
			{0.442372203, 0.405866809}, // 2925K
			{0.442298487, 0.405843526}, // 2926K
			{0.442224805, 0.405820227}, // 2927K
			{0.442151158, 0.405796911}, // 2928K
			{0.442077545, 0.405773579}, // 2929K
			{0.442003968, 0.40575023}, // 2930K
			{0.441930425, 0.405726864}, // 2931K
			{0.441856917, 0.405703482}, // 2932K
			{0.441783444, 0.405680083}, // 2933K
			{0.441710006, 0.405656668}, // 2934K
			{0.441636602, 0.405633237}, // 2935K
			{0.441563233, 0.405609789}, // 2936K
			{0.441489899, 0.405586325}, // 2937K
			{0.4414166, 0.405562845}, // 2938K
			{0.441343335, 0.405539348}, // 2939K
			{0.441270105, 0.405515836}, // 2940K
			{0.441196909, 0.405492307}, // 2941K
			{0.441123748, 0.405468762}, // 2942K
			{0.441050622, 0.405445201}, // 2943K
			{0.44097753, 0.405421623}, // 2944K
			{0.440904473, 0.40539803}, // 2945K
			{0.440831451, 0.405374421}, // 2946K
			{0.440758463, 0.405350796}, // 2947K
			{0.44068551, 0.405327155}, // 2948K
			{0.440612591, 0.405303498}, // 2949K
			{0.440539707, 0.405279825}, // 2950K
			{0.440466857, 0.405256137}, // 2951K
			{0.440394042, 0.405232433}, // 2952K
			{0.440321262, 0.405208713}, // 2953K
			{0.440248516, 0.405184977}, // 2954K
			{0.440175804, 0.405161226}, // 2955K
			{0.440103127, 0.405137459}, // 2956K
			{0.440030484, 0.405113677}, // 2957K
			{0.439957876, 0.405089879}, // 2958K
			{0.439885302, 0.405066065}, // 2959K
			{0.439812763, 0.405042236}, // 2960K
			{0.439740258, 0.405018392}, // 2961K
			{0.439667787, 0.404994533}, // 2962K
			{0.439595351, 0.404970657}, // 2963K
			{0.439522949, 0.404946767}, // 2964K
			{0.439450581, 0.404922862}, // 2965K
			{0.439378248, 0.404898941}, // 2966K
			{0.439305949, 0.404875005}, // 2967K
			{0.439233685, 0.404851053}, // 2968K
			{0.439161454, 0.404827087}, // 2969K
			{0.439089258, 0.404803106}, // 2970K
			{0.439017097, 0.404779109}, // 2971K
			{0.438944969, 0.404755098}, // 2972K
			{0.438872876, 0.404731071}, // 2973K
			{0.438800817, 0.40470703}, // 2974K
			{0.438728792, 0.404682973}, // 2975K
			{0.438656802, 0.404658902}, // 2976K
			{0.438584845, 0.404634816}, // 2977K
			{0.438512923, 0.404610715}, // 2978K
			{0.438441035, 0.4045866}, // 2979K
			{0.438369181, 0.404562469}, // 2980K
			{0.438297362, 0.404538324}, // 2981K
			{0.438225576, 0.404514164}, // 2982K
			{0.438153824, 0.40448999}, // 2983K
			{0.438082107, 0.404465801}, // 2984K
			{0.438010424, 0.404441598}, // 2985K
			{0.437938775, 0.40441738}, // 2986K
			{0.437867159, 0.404393147}, // 2987K
			{0.437795578, 0.4043689}, // 2988K
			{0.437724031, 0.404344639}, // 2989K
			{0.437652518, 0.404320363}, // 2990K
			{0.437581039, 0.404296073}, // 2991K
			{0.437509594, 0.404271769}, // 2992K
			{0.437438183, 0.40424745}, // 2993K
			{0.437366806, 0.404223117}, // 2994K
			{0.437295463, 0.40419877}, // 2995K
			{0.437224154, 0.404174409}, // 2996K
			{0.437152879, 0.404150033}, // 2997K
			{0.437081637, 0.404125644}, // 2998K
			{0.43701043, 0.40410124}, // 2999K
			{0.436939256, 0.404076823}, // 3000K
			{0.436868117, 0.404052391}, // 3001K
			{0.436797011, 0.404027945}, // 3002K
			{0.436725939, 0.404003486}, // 3003K
			{0.436654901, 0.403979013}, // 3004K
			{0.436583897, 0.403954525}, // 3005K
			{0.436512926, 0.403930024}, // 3006K
			{0.43644199, 0.403905509}, // 3007K
			{0.436371087, 0.403880981}, // 3008K
			{0.436300218, 0.403856439}, // 3009K
			{0.436229382, 0.403831883}, // 3010K
			{0.436158581, 0.403807313}, // 3011K
			{0.436087813, 0.40378273}, // 3012K
			{0.436017079, 0.403758133}, // 3013K
			{0.435946378, 0.403733522}, // 3014K
			{0.435875711, 0.403708899}, // 3015K
			{0.435805078, 0.403684261}, // 3016K
			{0.435734479, 0.40365961}, // 3017K
			{0.435663913, 0.403634946}, // 3018K
			{0.435593381, 0.403610268}, // 3019K
			{0.435522883, 0.403585577}, // 3020K
			{0.435452418, 0.403560873}, // 3021K
			{0.435381987, 0.403536156}, // 3022K
			{0.435311589, 0.403511425}, // 3023K
			{0.435241225, 0.403486681}, // 3024K
			{0.435170894, 0.403461924}, // 3025K
			{0.435100597, 0.403437153}, // 3026K
			{0.435030334, 0.40341237}, // 3027K
			{0.434960104, 0.403387573}, // 3028K
			{0.434889907, 0.403362764}, // 3029K
			{0.434819744, 0.403337941}, // 3030K
			{0.434749615, 0.403313105}, // 3031K
			{0.434679519, 0.403288257}, // 3032K
			{0.434609456, 0.403263395}, // 3033K
			{0.434539427, 0.403238521}, // 3034K
			{0.434469432, 0.403213634}, // 3035K
			{0.434399469, 0.403188734}, // 3036K
			{0.43432954, 0.403163821}, // 3037K
			{0.434259645, 0.403138896}, // 3038K
			{0.434189783, 0.403113957}, // 3039K
			{0.434119954, 0.403089006}, // 3040K
			{0.434050159, 0.403064043}, // 3041K
			{0.433980397, 0.403039067}, // 3042K
			{0.433910668, 0.403014078}, // 3043K
			{0.433840972, 0.402989077}, // 3044K
			{0.43377131, 0.402964063}, // 3045K
			{0.433701681, 0.402939036}, // 3046K
			{0.433632086, 0.402913998}, // 3047K
			{0.433562523, 0.402888946}, // 3048K
			{0.433492994, 0.402863883}, // 3049K
			{0.433423498, 0.402838807}, // 3050K
			{0.433354035, 0.402813719}, // 3051K
			{0.433284606, 0.402788618}, // 3052K
			{0.43321521, 0.402763505}, // 3053K
			{0.433145846, 0.40273838}, // 3054K
			{0.433076516, 0.402713243}, // 3055K
			{0.43300722, 0.402688093}, // 3056K
			{0.432937956, 0.402662932}, // 3057K
			{0.432868725, 0.402637758}, // 3058K
			{0.432799528, 0.402612572}, // 3059K
			{0.432730363, 0.402587375}, // 3060K
			{0.432661232, 0.402562165}, // 3061K
			{0.432592134, 0.402536943}, // 3062K
			{0.432523069, 0.402511709}, // 3063K
			{0.432454036, 0.402486464}, // 3064K
			{0.432385037, 0.402461206}, // 3065K
			{0.432316071, 0.402435937}, // 3066K
			{0.432247138, 0.402410656}, // 3067K
			{0.432178238, 0.402385363}, // 3068K
			{0.43210937, 0.402360058}, // 3069K
			{0.432040536, 0.402334742}, // 3070K
			{0.431971735, 0.402309414}, // 3071K
			{0.431902966, 0.402284074}, // 3072K
			{0.431834231, 0.402258722}, // 3073K
			{0.431765528, 0.402233359}, // 3074K
			{0.431696859, 0.402207985}, // 3075K
			{0.431628222, 0.402182599}, // 3076K
			{0.431559618, 0.402157201}, // 3077K
			{0.431491047, 0.402131792}, // 3078K
			{0.431422508, 0.402106371}, // 3079K
			{0.431354003, 0.402080939}, // 3080K
			{0.43128553, 0.402055496}, // 3081K
			{0.43121709, 0.402030041}, // 3082K
			{0.431148683, 0.402004575}, // 3083K
			{0.431080309, 0.401979098}, // 3084K
			{0.431011967, 0.401953609}, // 3085K
			{0.430943658, 0.40192811}, // 3086K
			{0.430875382, 0.401902599}, // 3087K
			{0.430807139, 0.401877077}, // 3088K
			{0.430738928, 0.401851543}, // 3089K
			{0.43067075, 0.401825999}, // 3090K
			{0.430602605, 0.401800443}, // 3091K
			{0.430534492, 0.401774877}, // 3092K
			{0.430466412, 0.401749299}, // 3093K
			{0.430398364, 0.401723711}, // 3094K
			{0.430330349, 0.401698111}, // 3095K
			{0.430262367, 0.401672501}, // 3096K
			{0.430194417, 0.40164688}, // 3097K
			{0.4301265, 0.401621247}, // 3098K
			{0.430058616, 0.401595604}, // 3099K
			{0.429990764, 0.401569951}, // 3100K
			{0.429922944, 0.401544286}, // 3101K
			{0.429855157, 0.401518611}, // 3102K
			{0.429787403, 0.401492925}, // 3103K
			{0.429719681, 0.401467228}, // 3104K
			{0.429651992, 0.40144152}, // 3105K
			{0.429584335, 0.401415802}, // 3106K
			{0.42951671, 0.401390074}, // 3107K
			{0.429449118, 0.401364335}, // 3108K
			{0.429381558, 0.401338585}, // 3109K
			{0.429314031, 0.401312825}, // 3110K
			{0.429246536, 0.401287054}, // 3111K
			{0.429179073, 0.401261273}, // 3112K
			{0.429111643, 0.401235481}, // 3113K
			{0.429044245, 0.401209679}, // 3114K
			{0.42897688, 0.401183867}, // 3115K
			{0.428909547, 0.401158044}, // 3116K
			{0.428842246, 0.401132211}, // 3117K
			{0.428774977, 0.401106368}, // 3118K
			{0.428707741, 0.401080514}, // 3119K
			{0.428640537, 0.401054651}, // 3120K
			{0.428573365, 0.401028777}, // 3121K
			{0.428506226, 0.401002893}, // 3122K
			{0.428439119, 0.400976999}, // 3123K
			{0.428372044, 0.400951094}, // 3124K
			{0.428305001, 0.40092518}, // 3125K
			{0.42823799, 0.400899255}, // 3126K
			{0.428171012, 0.400873321}, // 3127K
			{0.428104065, 0.400847377}, // 3128K
			{0.428037151, 0.400821422}, // 3129K
			{0.427970269, 0.400795458}, // 3130K
			{0.427903419, 0.400769484}, // 3131K
			{0.427836601, 0.4007435}, // 3132K
			{0.427769816, 0.400717506}, // 3133K
			{0.427703062, 0.400691502}, // 3134K
			{0.42763634, 0.400665489}, // 3135K
			{0.427569651, 0.400639465}, // 3136K
			{0.427502993, 0.400613432}, // 3137K
			{0.427436368, 0.40058739}, // 3138K
			{0.427369775, 0.400561337}, // 3139K
			{0.427303213, 0.400535275}, // 3140K
			{0.427236684, 0.400509204}, // 3141K
			{0.427170186, 0.400483122}, // 3142K
			{0.42710372, 0.400457032}, // 3143K
			{0.427037287, 0.400430931}, // 3144K
			{0.426970885, 0.400404822}, // 3145K
			{0.426904515, 0.400378702}, // 3146K
			{0.426838177, 0.400352574}, // 3147K
			{0.426771871, 0.400326435}, // 3148K
			{0.426705597, 0.400300288}, // 3149K
			{0.426639355, 0.400274131}, // 3150K
			{0.426573145, 0.400247965}, // 3151K
			{0.426506966, 0.400221789}, // 3152K
			{0.426440819, 0.400195604}, // 3153K
			{0.426374704, 0.40016941}, // 3154K
			{0.426308621, 0.400143207}, // 3155K
			{0.42624257, 0.400116994}, // 3156K
			{0.42617655, 0.400090773}, // 3157K
			{0.426110562, 0.400064542}, // 3158K
			{0.426044606, 0.400038302}, // 3159K
			{0.425978681, 0.400012053}, // 3160K
			{0.425912788, 0.399985795}, // 3161K
			{0.425846927, 0.399959528}, // 3162K
			{0.425781098, 0.399933252}, // 3163K
			{0.4257153, 0.399906966}, // 3164K
			{0.425649534, 0.399880672}, // 3165K
			{0.4255838, 0.399854369}, // 3166K
			{0.425518097, 0.399828057}, // 3167K
			{0.425452426, 0.399801737}, // 3168K
			{0.425386786, 0.399775407}, // 3169K
			{0.425321178, 0.399749069}, // 3170K
			{0.425255601, 0.399722721}, // 3171K
			{0.425190056, 0.399696365}, // 3172K
			{0.425124543, 0.399670001}, // 3173K
			{0.425059061, 0.399643627}, // 3174K
			{0.424993611, 0.399617245}, // 3175K
			{0.424928192, 0.399590854}, // 3176K
			{0.424862804, 0.399564455}, // 3177K
			{0.424797449, 0.399538047}, // 3178K
			{0.424732124, 0.39951163}, // 3179K
			{0.424666831, 0.399485205}, // 3180K
			{0.424601569, 0.399458772}, // 3181K
			{0.424536339, 0.399432329}, // 3182K
			{0.42447114, 0.399405879}, // 3183K
			{0.424405973, 0.39937942}, // 3184K
			{0.424340837, 0.399352952}, // 3185K
			{0.424275732, 0.399326476}, // 3186K
			{0.424210659, 0.399299992}, // 3187K
			{0.424145617, 0.399273499}, // 3188K
			{0.424080606, 0.399246999}, // 3189K
			{0.424015627, 0.399220489}, // 3190K
			{0.423950679, 0.399193972}, // 3191K
			{0.423885762, 0.399167446}, // 3192K
			{0.423820876, 0.399140912}, // 3193K
			{0.423756022, 0.39911437}, // 3194K
			{0.423691199, 0.39908782}, // 3195K
			{0.423626407, 0.399061262}, // 3196K
			{0.423561646, 0.399034695}, // 3197K
			{0.423496917, 0.399008121}, // 3198K
			{0.423432219, 0.398981538}, // 3199K
			{0.423367552, 0.398954947}, // 3200K
			{0.423302916, 0.398928349}, // 3201K
			{0.423238311, 0.398901742}, // 3202K
			{0.423173737, 0.398875127}, // 3203K
			{0.423109194, 0.398848505}, // 3204K
			{0.423044683, 0.398821875}, // 3205K
			{0.422980202, 0.398795236}, // 3206K
			{0.422915753, 0.39876859}, // 3207K
			{0.422851335, 0.398741936}, // 3208K
			{0.422786947, 0.398715274}, // 3209K
			{0.422722591, 0.398688605}, // 3210K
			{0.422658266, 0.398661928}, // 3211K
			{0.422593972, 0.398635243}, // 3212K
			{0.422529708, 0.39860855}, // 3213K
			{0.422465476, 0.39858185}, // 3214K
			{0.422401275, 0.398555142}, // 3215K
			{0.422337104, 0.398528426}, // 3216K
			{0.422272965, 0.398501703}, // 3217K
			{0.422208856, 0.398474972}, // 3218K
			{0.422144778, 0.398448234}, // 3219K
			{0.422080732, 0.398421488}, // 3220K
			{0.422016716, 0.398394734}, // 3221K
			{0.421952731, 0.398367973}, // 3222K
			{0.421888776, 0.398341205}, // 3223K
			{0.421824853, 0.398314429}, // 3224K
			{0.42176096, 0.398287646}, // 3225K
			{0.421697098, 0.398260856}, // 3226K
			{0.421633267, 0.398234058}, // 3227K
			{0.421569467, 0.398207253}, // 3228K
			{0.421505698, 0.39818044}, // 3229K
			{0.421441959, 0.398153621}, // 3230K
			{0.421378251, 0.398126794}, // 3231K
			{0.421314574, 0.39809996}, // 3232K
			{0.421250927, 0.398073118}, // 3233K
			{0.421187311, 0.39804627}, // 3234K
			{0.421123726, 0.398019414}, // 3235K
			{0.421060171, 0.397992551}, // 3236K
			{0.420996648, 0.397965681}, // 3237K
			{0.420933154, 0.397938804}, // 3238K
			{0.420869692, 0.39791192}, // 3239K
			{0.42080626, 0.397885029}, // 3240K
			{0.420742858, 0.39785813}, // 3241K
			{0.420679487, 0.397831225}, // 3242K
			{0.420616147, 0.397804313}, // 3243K
			{0.420552837, 0.397777394}, // 3244K
			{0.420489558, 0.397750468}, // 3245K
			{0.420426309, 0.397723535}, // 3246K
			{0.420363091, 0.397696596}, // 3247K
			{0.420299903, 0.397669649}, // 3248K
			{0.420236746, 0.397642696}, // 3249K
			{0.420173619, 0.397615736}, // 3250K
			{0.420110523, 0.397588769}, // 3251K
			{0.420047457, 0.397561795}, // 3252K
			{0.419984421, 0.397534815}, // 3253K
			{0.419921416, 0.397507828}, // 3254K
			{0.419858442, 0.397480834}, // 3255K
			{0.419795497, 0.397453834}, // 3256K
			{0.419732584, 0.397426827}, // 3257K
			{0.4196697, 0.397399813}, // 3258K
			{0.419606847, 0.397372793}, // 3259K
			{0.419544024, 0.397345766}, // 3260K
			{0.419481231, 0.397318733}, // 3261K
			{0.419418469, 0.397291693}, // 3262K
			{0.419355737, 0.397264647}, // 3263K
			{0.419293035, 0.397237594}, // 3264K
			{0.419230364, 0.397210535}, // 3265K
			{0.419167723, 0.397183469}, // 3266K
			{0.419105112, 0.397156397}, // 3267K
			{0.419042531, 0.397129319}, // 3268K
			{0.41897998, 0.397102234}, // 3269K
			{0.41891746, 0.397075143}, // 3270K
			{0.41885497, 0.397048046}, // 3271K
			{0.41879251, 0.397020942}, // 3272K
			{0.41873008, 0.396993832}, // 3273K
			{0.41866768, 0.396966716}, // 3274K
			{0.41860531, 0.396939594}, // 3275K
			{0.418542971, 0.396912466}, // 3276K
			{0.418480661, 0.396885331}, // 3277K
			{0.418418382, 0.39685819}, // 3278K
			{0.418356132, 0.396831043}, // 3279K
			{0.418293913, 0.39680389}, // 3280K
			{0.418231724, 0.396776731}, // 3281K
			{0.418169565, 0.396749566}, // 3282K
			{0.418107435, 0.396722395}, // 3283K
			{0.418045336, 0.396695218}, // 3284K
			{0.417983267, 0.396668035}, // 3285K
			{0.417921228, 0.396640846}, // 3286K
			{0.417859218, 0.396613651}, // 3287K
			{0.417797239, 0.39658645}, // 3288K
			{0.417735289, 0.396559243}, // 3289K
			{0.41767337, 0.39653203}, // 3290K
			{0.41761148, 0.396504812}, // 3291K
			{0.41754962, 0.396477587}, // 3292K
			{0.41748779, 0.396450357}, // 3293K
			{0.41742599, 0.396423121}, // 3294K
			{0.41736422, 0.396395879}, // 3295K
			{0.417302479, 0.396368632}, // 3296K
			{0.417240769, 0.396341379}, // 3297K
			{0.417179088, 0.39631412}, // 3298K
			{0.417117437, 0.396286855}, // 3299K
			{0.417055815, 0.396259585}, // 3300K
			{0.416994224, 0.396232309}, // 3301K
			{0.416932662, 0.396205028}, // 3302K
			{0.41687113, 0.396177741}, // 3303K
			{0.416809628, 0.396150448}, // 3304K
			{0.416748155, 0.39612315}, // 3305K
			{0.416686712, 0.396095847}, // 3306K
			{0.416625299, 0.396068538}, // 3307K
			{0.416563915, 0.396041223}, // 3308K
			{0.416502561, 0.396013903}, // 3309K
			{0.416441237, 0.395986578}, // 3310K
			{0.416379942, 0.395959247}, // 3311K
			{0.416318677, 0.39593191}, // 3312K
			{0.416257441, 0.395904569}, // 3313K
			{0.416196235, 0.395877222}, // 3314K
			{0.416135059, 0.39584987}, // 3315K
			{0.416073912, 0.395822512}, // 3316K
			{0.416012794, 0.395795149}, // 3317K
			{0.415951706, 0.395767781}, // 3318K
			{0.415890648, 0.395740408}, // 3319K
			{0.415829619, 0.395713029}, // 3320K
			{0.41576862, 0.395685645}, // 3321K
			{0.41570765, 0.395658256}, // 3322K
			{0.415646709, 0.395630862}, // 3323K
			{0.415585798, 0.395603463}, // 3324K
			{0.415524917, 0.395576059}, // 3325K
			{0.415464064, 0.395548649}, // 3326K
			{0.415403242, 0.395521235}, // 3327K
			{0.415342448, 0.395493815}, // 3328K
			{0.415281684, 0.395466391}, // 3329K
			{0.415220949, 0.395438961}, // 3330K
			{0.415160244, 0.395411527}, // 3331K
			{0.415099568, 0.395384087}, // 3332K
			{0.415038921, 0.395356643}, // 3333K
			{0.414978304, 0.395329193}, // 3334K
			{0.414917715, 0.395301739}, // 3335K
			{0.414857156, 0.39527428}, // 3336K
			{0.414796627, 0.395246816}, // 3337K
			{0.414736126, 0.395219347}, // 3338K
			{0.414675655, 0.395191873}, // 3339K
			{0.414615213, 0.395164395}, // 3340K
			{0.4145548, 0.395136912}, // 3341K
			{0.414494417, 0.395109424}, // 3342K
			{0.414434062, 0.395081931}, // 3343K
			{0.414373737, 0.395054434}, // 3344K
			{0.414313441, 0.395026931}, // 3345K
			{0.414253173, 0.394999425}, // 3346K
			{0.414192936, 0.394971913}, // 3347K
			{0.414132727, 0.394944397}, // 3348K
			{0.414072547, 0.394916876}, // 3349K
			{0.414012396, 0.394889351}, // 3350K
			{0.413952275, 0.394861821}, // 3351K
			{0.413892182, 0.394834287}, // 3352K
			{0.413832119, 0.394806748}, // 3353K
			{0.413772084, 0.394779204}, // 3354K
			{0.413712078, 0.394751656}, // 3355K
			{0.413652102, 0.394724104}, // 3356K
			{0.413592154, 0.394696547}, // 3357K
			{0.413532236, 0.394668986}, // 3358K
			{0.413472346, 0.39464142}, // 3359K
			{0.413412485, 0.39461385}, // 3360K
			{0.413352653, 0.394586276}, // 3361K
			{0.413292851, 0.394558697}, // 3362K
			{0.413233077, 0.394531114}, // 3363K
			{0.413173331, 0.394503526}, // 3364K
			{0.413113615, 0.394475934}, // 3365K
			{0.413053928, 0.394448338}, // 3366K
			{0.412994269, 0.394420738}, // 3367K
			{0.412934639, 0.394393134}, // 3368K
			{0.412875038, 0.394365525}, // 3369K
			{0.412815466, 0.394337912}, // 3370K
			{0.412755923, 0.394310295}, // 3371K
			{0.412696408, 0.394282674}, // 3372K
			{0.412636922, 0.394255048}, // 3373K
			{0.412577465, 0.394227419}, // 3374K
			{0.412518037, 0.394199785}, // 3375K
			{0.412458637, 0.394172147}, // 3376K
			{0.412399266, 0.394144506}, // 3377K
			{0.412339924, 0.39411686}, // 3378K
			{0.41228061, 0.39408921}, // 3379K
			{0.412221325, 0.394061556}, // 3380K
			{0.412162069, 0.394033899}, // 3381K
			{0.412102841, 0.394006237}, // 3382K
			{0.412043642, 0.393978571}, // 3383K
			{0.411984471, 0.393950902}, // 3384K
			{0.411925329, 0.393923228}, // 3385K
			{0.411866216, 0.393895551}, // 3386K
			{0.411807131, 0.39386787}, // 3387K
			{0.411748075, 0.393840185}, // 3388K
			{0.411689047, 0.393812496}, // 3389K
			{0.411630048, 0.393784803}, // 3390K
			{0.411571077, 0.393757107}, // 3391K
			{0.411512135, 0.393729406}, // 3392K
			{0.411453221, 0.393701702}, // 3393K
			{0.411394336, 0.393673995}, // 3394K
			{0.411335479, 0.393646283}, // 3395K
			{0.411276651, 0.393618568}, // 3396K
			{0.411217851, 0.393590849}, // 3397K
			{0.411159079, 0.393563127}, // 3398K
			{0.411100336, 0.393535401}, // 3399K
			{0.411041621, 0.393507671}, // 3400K
			{0.410982935, 0.393479938}, // 3401K
			{0.410924276, 0.393452201}, // 3402K
			{0.410865647, 0.39342446}, // 3403K
			{0.410807045, 0.393396716}, // 3404K
			{0.410748472, 0.393368969}, // 3405K
			{0.410689927, 0.393341218}, // 3406K
			{0.410631411, 0.393313463}, // 3407K
			{0.410572922, 0.393285705}, // 3408K
			{0.410514462, 0.393257944}, // 3409K
			{0.410456031, 0.393230179}, // 3410K
			{0.410397627, 0.393202411}, // 3411K
			{0.410339252, 0.393174639}, // 3412K
			{0.410280904, 0.393146864}, // 3413K
			{0.410222585, 0.393119086}, // 3414K
			{0.410164295, 0.393091304}, // 3415K
			{0.410106032, 0.393063519}, // 3416K
			{0.410047798, 0.39303573}, // 3417K
			{0.409989591, 0.393007939}, // 3418K
			{0.409931413, 0.392980144}, // 3419K
			{0.409873263, 0.392952346}, // 3420K
			{0.409815141, 0.392924544}, // 3421K
			{0.409757047, 0.39289674}, // 3422K
			{0.409698981, 0.392868932}, // 3423K
			{0.409640943, 0.392841121}, // 3424K
			{0.409582933, 0.392813307}, // 3425K
			{0.409524951, 0.392785489}, // 3426K
			{0.409466997, 0.392757669}, // 3427K
			{0.409409071, 0.392729845}, // 3428K
			{0.409351174, 0.392702019}, // 3429K
			{0.409293304, 0.392674189}, // 3430K
			{0.409235462, 0.392646356}, // 3431K
			{0.409177648, 0.39261852}, // 3432K
			{0.409119862, 0.392590682}, // 3433K
			{0.409062103, 0.39256284}, // 3434K
			{0.409004373, 0.392534995}, // 3435K
			{0.408946671, 0.392507147}, // 3436K
			{0.408888996, 0.392479297}, // 3437K
			{0.40883135, 0.392451443}, // 3438K
			{0.408773731, 0.392423586}, // 3439K
			{0.40871614, 0.392395727}, // 3440K
			{0.408658577, 0.392367865}, // 3441K
			{0.408601041, 0.39234}, // 3442K
			{0.408543533, 0.392312132}, // 3443K
			{0.408486054, 0.392284261}, // 3444K
			{0.408428602, 0.392256387}, // 3445K
			{0.408371177, 0.392228511}, // 3446K
			{0.408313781, 0.392200631}, // 3447K
			{0.408256412, 0.39217275}, // 3448K
			{0.408199071, 0.392144865}, // 3449K
			{0.408141757, 0.392116977}, // 3450K
			{0.408084471, 0.392089087}, // 3451K
			{0.408027213, 0.392061194}, // 3452K
			{0.407969983, 0.392033299}, // 3453K
			{0.40791278, 0.392005401}, // 3454K
			{0.407855604, 0.3919775}, // 3455K
			{0.407798457, 0.391949597}, // 3456K
			{0.407741337, 0.391921691}, // 3457K
			{0.407684244, 0.391893782}, // 3458K
			{0.407627179, 0.391865871}, // 3459K
			{0.407570142, 0.391837957}, // 3460K
			{0.407513132, 0.391810041}, // 3461K
			{0.40745615, 0.391782123}, // 3462K
			{0.407399195, 0.391754201}, // 3463K
			{0.407342268, 0.391726278}, // 3464K
			{0.407285368, 0.391698351}, // 3465K
			{0.407228496, 0.391670423}, // 3466K
			{0.407171651, 0.391642492}, // 3467K
			{0.407114833, 0.391614558}, // 3468K
			{0.407058043, 0.391586622}, // 3469K
			{0.407001281, 0.391558684}, // 3470K
			{0.406944546, 0.391530744}, // 3471K
			{0.406887838, 0.391502801}, // 3472K
			{0.406831157, 0.391474855}, // 3473K
			{0.406774504, 0.391446908}, // 3474K
			{0.406717879, 0.391418958}, // 3475K
			{0.40666128, 0.391391006}, // 3476K
			{0.406604709, 0.391363051}, // 3477K
			{0.406548165, 0.391335094}, // 3478K
			{0.406491649, 0.391307136}, // 3479K
			{0.40643516, 0.391279174}, // 3480K
			{0.406378698, 0.391251211}, // 3481K
			{0.406322263, 0.391223245}, // 3482K
			{0.406265856, 0.391195278}, // 3483K
			{0.406209476, 0.391167308}, // 3484K
			{0.406153123, 0.391139336}, // 3485K
			{0.406096797, 0.391111362}, // 3486K
			{0.406040498, 0.391083386}, // 3487K
			{0.405984227, 0.391055407}, // 3488K
			{0.405927983, 0.391027427}, // 3489K
			{0.405871765, 0.390999444}, // 3490K
			{0.405815576, 0.39097146}, // 3491K
			{0.405759413, 0.390943474}, // 3492K
			{0.405703277, 0.390915485}, // 3493K
			{0.405647168, 0.390887495}, // 3494K
			{0.405591087, 0.390859502}, // 3495K
			{0.405535032, 0.390831508}, // 3496K
			{0.405479005, 0.390803511}, // 3497K
			{0.405423004, 0.390775513}, // 3498K
			{0.405367031, 0.390747513}, // 3499K
			{0.405311084, 0.390719511}, // 3500K
			{0.405255165, 0.390691507}, // 3501K
			{0.405199272, 0.390663501}, // 3502K
			{0.405143407, 0.390635493}, // 3503K
			{0.405087568, 0.390607484}, // 3504K
			{0.405031757, 0.390579472}, // 3505K
			{0.404975972, 0.390551459}, // 3506K
			{0.404920214, 0.390523444}, // 3507K
			{0.404864483, 0.390495428}, // 3508K
			{0.404808779, 0.390467409}, // 3509K
			{0.404753102, 0.390439389}, // 3510K
			{0.404697452, 0.390411367}, // 3511K
			{0.404641829, 0.390383344}, // 3512K
			{0.404586232, 0.390355318}, // 3513K
			{0.404530662, 0.390327291}, // 3514K
			{0.404475119, 0.390299263}, // 3515K
			{0.404419603, 0.390271232}, // 3516K
			{0.404364114, 0.3902432}, // 3517K
			{0.404308651, 0.390215167}, // 3518K
			{0.404253215, 0.390187132}, // 3519K
			{0.404197806, 0.390159095}, // 3520K
			{0.404142424, 0.390131057}, // 3521K
			{0.404087068, 0.390103017}, // 3522K
			{0.404031739, 0.390074976}, // 3523K
			{0.403976437, 0.390046933}, // 3524K
			{0.403921161, 0.390018888}, // 3525K
			{0.403865912, 0.389990842}, // 3526K
			{0.40381069, 0.389962795}, // 3527K
			{0.403755494, 0.389934746}, // 3528K
			{0.403700325, 0.389906696}, // 3529K
			{0.403645182, 0.389878644}, // 3530K
			{0.403590067, 0.389850591}, // 3531K
			{0.403534977, 0.389822537}, // 3532K
			{0.403479914, 0.389794481}, // 3533K
			{0.403424878, 0.389766423}, // 3534K
			{0.403369869, 0.389738365}, // 3535K
			{0.403314885, 0.389710305}, // 3536K
			{0.403259929, 0.389682243}, // 3537K
			{0.403204999, 0.389654181}, // 3538K
			{0.403150095, 0.389626117}, // 3539K
			{0.403095218, 0.389598052}, // 3540K
			{0.403040367, 0.389569985}, // 3541K
			{0.402985543, 0.389541917}, // 3542K
			{0.402930745, 0.389513848}, // 3543K
			{0.402875973, 0.389485778}, // 3544K
			{0.402821228, 0.389457707}, // 3545K
			{0.402766509, 0.389429634}, // 3546K
			{0.402711817, 0.38940156}, // 3547K
			{0.402657151, 0.389373485}, // 3548K
			{0.402602511, 0.389345409}, // 3549K
			{0.402547898, 0.389317332}, // 3550K
			{0.402493311, 0.389289254}, // 3551K
			{0.402438751, 0.389261174}, // 3552K
			{0.402384216, 0.389233094}, // 3553K
			{0.402329708, 0.389205012}, // 3554K
			{0.402275226, 0.389176929}, // 3555K
			{0.402220771, 0.389148846}, // 3556K
			{0.402166341, 0.389120761}, // 3557K
			{0.402111938, 0.389092675}, // 3558K
			{0.402057561, 0.389064588}, // 3559K
			{0.402003211, 0.3890365}, // 3560K
			{0.401948886, 0.389008412}, // 3561K
			{0.401894588, 0.388980322}, // 3562K
			{0.401840316, 0.388952231}, // 3563K
			{0.40178607, 0.38892414}, // 3564K
			{0.40173185, 0.388896047}, // 3565K
			{0.401677656, 0.388867954}, // 3566K
			{0.401623489, 0.388839859}, // 3567K
			{0.401569347, 0.388811764}, // 3568K
			{0.401515231, 0.388783668}, // 3569K
			{0.401461142, 0.388755571}, // 3570K
			{0.401407079, 0.388727473}, // 3571K
			{0.401353041, 0.388699374}, // 3572K
			{0.40129903, 0.388671275}, // 3573K
			{0.401245045, 0.388643175}, // 3574K
			{0.401191085, 0.388615074}, // 3575K
			{0.401137152, 0.388586972}, // 3576K
			{0.401083245, 0.38855887}, // 3577K
			{0.401029363, 0.388530766}, // 3578K
			{0.400975508, 0.388502662}, // 3579K
			{0.400921679, 0.388474558}, // 3580K
			{0.400867875, 0.388446452}, // 3581K
			{0.400814097, 0.388418346}, // 3582K
			{0.400760346, 0.388390239}, // 3583K
			{0.40070662, 0.388362132}, // 3584K
			{0.40065292, 0.388334024}, // 3585K
			{0.400599245, 0.388305915}, // 3586K
			{0.400545597, 0.388277806}, // 3587K
			{0.400491975, 0.388249696}, // 3588K
			{0.400438378, 0.388221586}, // 3589K
			{0.400384807, 0.388193475}, // 3590K
			{0.400331262, 0.388165363}, // 3591K
			{0.400277743, 0.388137251}, // 3592K
			{0.400224249, 0.388109138}, // 3593K
			{0.400170781, 0.388081025}, // 3594K
			{0.400117339, 0.388052911}, // 3595K
			{0.400063923, 0.388024797}, // 3596K
			{0.400010532, 0.387996682}, // 3597K
			{0.399957167, 0.387968567}, // 3598K
			{0.399903828, 0.387940451}, // 3599K
			{0.399850514, 0.387912335}, // 3600K
			{0.399797226, 0.387884219}, // 3601K
			{0.399743964, 0.387856102}, // 3602K
			{0.399690727, 0.387827984}, // 3603K
			{0.399637516, 0.387799867}, // 3604K
			{0.399584331, 0.387771749}, // 3605K
			{0.399531171, 0.38774363}, // 3606K
			{0.399478037, 0.387715511}, // 3607K
			{0.399424928, 0.387687392}, // 3608K
			{0.399371845, 0.387659273}, // 3609K
			{0.399318787, 0.387631153}, // 3610K
			{0.399265755, 0.387603033}, // 3611K
			{0.399212748, 0.387574913}, // 3612K
			{0.399159767, 0.387546792}, // 3613K
			{0.399106811, 0.387518671}, // 3614K
			{0.399053881, 0.38749055}, // 3615K
			{0.399000977, 0.387462429}, // 3616K
			{0.398948097, 0.387434307}, // 3617K
			{0.398895243, 0.387406186}, // 3618K
			{0.398842415, 0.387378064}, // 3619K
			{0.398789612, 0.387349941}, // 3620K
			{0.398736834, 0.387321819}, // 3621K
			{0.398684082, 0.387293697}, // 3622K
			{0.398631355, 0.387265574}, // 3623K
			{0.398578654, 0.387237451}, // 3624K
			{0.398525978, 0.387209329}, // 3625K
			{0.398473327, 0.387181206}, // 3626K
			{0.398420701, 0.387153083}, // 3627K
			{0.398368101, 0.38712496}, // 3628K
			{0.398315526, 0.387096836}, // 3629K
			{0.398262976, 0.387068713}, // 3630K
			{0.398210452, 0.38704059}, // 3631K
			{0.398157953, 0.387012467}, // 3632K
			{0.398105479, 0.386984343}, // 3633K
			{0.39805303, 0.38695622}, // 3634K
			{0.398000606, 0.386928097}, // 3635K
			{0.397948208, 0.386899973}, // 3636K
			{0.397895835, 0.38687185}, // 3637K
			{0.397843487, 0.386843727}, // 3638K
			{0.397791164, 0.386815604}, // 3639K
			{0.397738866, 0.386787481}, // 3640K
			{0.397686594, 0.386759358}, // 3641K
			{0.397634346, 0.386731235}, // 3642K
			{0.397582124, 0.386703112}, // 3643K
			{0.397529927, 0.38667499}, // 3644K
			{0.397477755, 0.386646867}, // 3645K
			{0.397425608, 0.386618745}, // 3646K
			{0.397373486, 0.386590623}, // 3647K
			{0.397321389, 0.386562501}, // 3648K
			{0.397269317, 0.386534379}, // 3649K
			{0.39721727, 0.386506257}, // 3650K
			{0.397165248, 0.386478136}, // 3651K
			{0.397113251, 0.386450015}, // 3652K
			{0.397061279, 0.386421894}, // 3653K
			{0.397009332, 0.386393773}, // 3654K
			{0.396957409, 0.386365652}, // 3655K
			{0.396905512, 0.386337532}, // 3656K
			{0.39685364, 0.386309412}, // 3657K
			{0.396801793, 0.386281293}, // 3658K
			{0.39674997, 0.386253173}, // 3659K
			{0.396698173, 0.386225054}, // 3660K
			{0.3966464, 0.386196936}, // 3661K
			{0.396594652, 0.386168817}, // 3662K
			{0.396542929, 0.386140699}, // 3663K
			{0.396491231, 0.386112582}, // 3664K
			{0.396439558, 0.386084465}, // 3665K
			{0.396387909, 0.386056348}, // 3666K
			{0.396336285, 0.386028231}, // 3667K
			{0.396284686, 0.386000115}, // 3668K
			{0.396233112, 0.385972}, // 3669K
			{0.396181563, 0.385943884}, // 3670K
			{0.396130038, 0.38591577}, // 3671K
			{0.396078538, 0.385887655}, // 3672K
			{0.396027063, 0.385859542}, // 3673K
			{0.395975612, 0.385831428}, // 3674K
			{0.395924186, 0.385803316}, // 3675K
			{0.395872785, 0.385775203}, // 3676K
			{0.395821409, 0.385747091}, // 3677K
			{0.395770057, 0.38571898}, // 3678K
			{0.395718729, 0.385690869}, // 3679K
			{0.395667427, 0.385662759}, // 3680K
			{0.395616149, 0.38563465}, // 3681K
			{0.395564895, 0.385606541}, // 3682K
			{0.395513667, 0.385578432}, // 3683K
			{0.395462462, 0.385550324}, // 3684K
			{0.395411283, 0.385522217}, // 3685K
			{0.395360127, 0.385494111}, // 3686K
			{0.395308997, 0.385466005}, // 3687K
			{0.395257891, 0.385437899}, // 3688K
			{0.395206809, 0.385409795}, // 3689K
			{0.395155752, 0.385381691}, // 3690K
			{0.395104719, 0.385353587}, // 3691K
			{0.395053711, 0.385325485}, // 3692K
			{0.395002728, 0.385297383}, // 3693K
			{0.394951768, 0.385269281}, // 3694K
			{0.394900834, 0.385241181}, // 3695K
			{0.394849923, 0.385213081}, // 3696K
			{0.394799037, 0.385184982}, // 3697K
			{0.394748176, 0.385156884}, // 3698K
			{0.394697338, 0.385128786}, // 3699K
			{0.394646526, 0.38510069}, // 3700K
			{0.394595737, 0.385072594}, // 3701K
			{0.394544973, 0.385044499}, // 3702K
			{0.394494233, 0.385016404}, // 3703K
			{0.394443518, 0.384988311}, // 3704K
			{0.394392826, 0.384960218}, // 3705K
			{0.39434216, 0.384932126}, // 3706K
			{0.394291517, 0.384904035}, // 3707K
			{0.394240899, 0.384875945}, // 3708K
			{0.394190304, 0.384847856}, // 3709K
			{0.394139735, 0.384819768}, // 3710K
			{0.394089189, 0.38479168}, // 3711K
			{0.394038667, 0.384763594}, // 3712K
			{0.39398817, 0.384735508}, // 3713K
			{0.393937697, 0.384707424}, // 3714K
			{0.393887248, 0.38467934}, // 3715K
			{0.393836824, 0.384651257}, // 3716K
			{0.393786423, 0.384623175}, // 3717K
			{0.393736047, 0.384595094}, // 3718K
			{0.393685694, 0.384567015}, // 3719K
			{0.393635366, 0.384538936}, // 3720K
			{0.393585062, 0.384510858}, // 3721K
			{0.393534782, 0.384482781}, // 3722K
			{0.393484526, 0.384454705}, // 3723K
			{0.393434294, 0.384426631}, // 3724K
			{0.393384087, 0.384398557}, // 3725K
			{0.393333903, 0.384370484}, // 3726K
			{0.393283743, 0.384342413}, // 3727K
			{0.393233607, 0.384314342}, // 3728K
			{0.393183496, 0.384286273}, // 3729K
			{0.393133408, 0.384258205}, // 3730K
			{0.393083344, 0.384230138}, // 3731K
			{0.393033304, 0.384202072}, // 3732K
			{0.392983288, 0.384174007}, // 3733K
			{0.392933296, 0.384145943}, // 3734K
			{0.392883328, 0.384117881}, // 3735K
			{0.392833384, 0.384089819}, // 3736K
			{0.392783464, 0.384061759}, // 3737K
			{0.392733568, 0.3840337}, // 3738K
			{0.392683695, 0.384005642}, // 3739K
			{0.392633847, 0.383977585}, // 3740K
			{0.392584022, 0.38394953}, // 3741K
			{0.392534221, 0.383921476}, // 3742K
			{0.392484444, 0.383893423}, // 3743K
			{0.392434691, 0.383865371}, // 3744K
			{0.392384961, 0.383837321}, // 3745K
			{0.392335256, 0.383809272}, // 3746K
			{0.392285574, 0.383781224}, // 3747K
			{0.392235916, 0.383753177}, // 3748K
			{0.392186281, 0.383725132}, // 3749K
			{0.39213667, 0.383697088}, // 3750K
			{0.392087083, 0.383669045}, // 3751K
			{0.39203752, 0.383641004}, // 3752K
			{0.391987981, 0.383612964}, // 3753K
			{0.391938465, 0.383584925}, // 3754K
			{0.391888973, 0.383556888}, // 3755K
			{0.391839504, 0.383528852}, // 3756K
			{0.391790059, 0.383500818}, // 3757K
			{0.391740638, 0.383472785}, // 3758K
			{0.39169124, 0.383444753}, // 3759K
			{0.391641866, 0.383416723}, // 3760K
			{0.391592516, 0.383388694}, // 3761K
			{0.391543189, 0.383360666}, // 3762K
			{0.391493886, 0.38333264}, // 3763K
			{0.391444606, 0.383304616}, // 3764K
			{0.39139535, 0.383276593}, // 3765K
			{0.391346117, 0.383248571}, // 3766K
			{0.391296908, 0.383220551}, // 3767K
			{0.391247722, 0.383192532}, // 3768K
			{0.39119856, 0.383164515}, // 3769K
			{0.391149422, 0.3831365}, // 3770K
			{0.391100306, 0.383108486}, // 3771K
			{0.391051215, 0.383080473}, // 3772K
			{0.391002146, 0.383052462}, // 3773K
			{0.390953102, 0.383024452}, // 3774K
			{0.39090408, 0.382996445}, // 3775K
			{0.390855082, 0.382968438}, // 3776K
			{0.390806108, 0.382940433}, // 3777K
			{0.390757156, 0.38291243}, // 3778K
			{0.390708228, 0.382884429}, // 3779K
			{0.390659324, 0.382856429}, // 3780K
			{0.390610443, 0.38282843}, // 3781K
			{0.390561585, 0.382800434}, // 3782K
			{0.39051275, 0.382772439}, // 3783K
			{0.390463939, 0.382744445}, // 3784K
			{0.390415151, 0.382716453}, // 3785K
			{0.390366387, 0.382688463}, // 3786K
			{0.390317646, 0.382660475}, // 3787K
			{0.390268927, 0.382632488}, // 3788K
			{0.390220233, 0.382604503}, // 3789K
			{0.390171561, 0.38257652}, // 3790K
			{0.390122913, 0.382548538}, // 3791K
			{0.390074288, 0.382520558}, // 3792K
			{0.390025686, 0.38249258}, // 3793K
			{0.389977107, 0.382464603}, // 3794K
			{0.389928551, 0.382436629}, // 3795K
			{0.389880019, 0.382408656}, // 3796K
			{0.389831509, 0.382380685}, // 3797K
			{0.389783023, 0.382352715}, // 3798K
			{0.38973456, 0.382324748}, // 3799K
			{0.38968612, 0.382296782}, // 3800K
			{0.389637704, 0.382268818}, // 3801K
			{0.38958931, 0.382240856}, // 3802K
			{0.389540939, 0.382212895}, // 3803K
			{0.389492592, 0.382184937}, // 3804K
			{0.389444267, 0.38215698}, // 3805K
			{0.389395966, 0.382129025}, // 3806K
			{0.389347687, 0.382101072}, // 3807K
			{0.389299432, 0.382073121}, // 3808K
			{0.389251199, 0.382045172}, // 3809K
			{0.38920299, 0.382017225}, // 3810K
			{0.389154803, 0.381989279}, // 3811K
			{0.38910664, 0.381961336}, // 3812K
			{0.389058499, 0.381933394}, // 3813K
			{0.389010381, 0.381905454}, // 3814K
			{0.388962287, 0.381877517}, // 3815K
			{0.388914215, 0.381849581}, // 3816K
			{0.388866166, 0.381821647}, // 3817K
			{0.38881814, 0.381793715}, // 3818K
			{0.388770137, 0.381765785}, // 3819K
			{0.388722157, 0.381737857}, // 3820K
			{0.388674199, 0.381709931}, // 3821K
			{0.388626265, 0.381682007}, // 3822K
			{0.388578353, 0.381654085}, // 3823K
			{0.388530464, 0.381626165}, // 3824K
			{0.388482598, 0.381598248}, // 3825K
			{0.388434755, 0.381570332}, // 3826K
			{0.388386934, 0.381542418}, // 3827K
			{0.388339136, 0.381514506}, // 3828K
			{0.388291361, 0.381486596}, // 3829K
			{0.388243609, 0.381458689}, // 3830K
			{0.38819588, 0.381430783}, // 3831K
			{0.388148173, 0.38140288}, // 3832K
			{0.388100489, 0.381374978}, // 3833K
			{0.388052827, 0.381347079}, // 3834K
			{0.388005188, 0.381319182}, // 3835K
			{0.387957572, 0.381291287}, // 3836K
			{0.387909979, 0.381263394}, // 3837K
			{0.387862408, 0.381235503}, // 3838K
			{0.38781486, 0.381207614}, // 3839K
			{0.387767335, 0.381179728}, // 3840K
			{0.387719832, 0.381151843}, // 3841K
			{0.387672352, 0.381123961}, // 3842K
			{0.387624894, 0.381096081}, // 3843K
			{0.387577459, 0.381068203}, // 3844K
			{0.387530046, 0.381040328}, // 3845K
			{0.387482656, 0.381012454}, // 3846K
			{0.387435289, 0.380984583}, // 3847K
			{0.387387944, 0.380956714}, // 3848K
			{0.387340621, 0.380928847}, // 3849K
			{0.387293321, 0.380900983}, // 3850K
			{0.387246044, 0.380873121}, // 3851K
			{0.387198789, 0.380845261}, // 3852K
			{0.387151557, 0.380817403}, // 3853K
			{0.387104346, 0.380789547}, // 3854K
			{0.387057159, 0.380761694}, // 3855K
			{0.387009994, 0.380733843}, // 3856K
			{0.386962851, 0.380705995}, // 3857K
			{0.386915731, 0.380678149}, // 3858K
			{0.386868633, 0.380650305}, // 3859K
			{0.386821557, 0.380622463}, // 3860K
			{0.386774504, 0.380594624}, // 3861K
			{0.386727473, 0.380566787}, // 3862K
			{0.386680465, 0.380538952}, // 3863K
			{0.386633478, 0.38051112}, // 3864K
			{0.386586515, 0.38048329}, // 3865K
			{0.386539573, 0.380455462}, // 3866K
			{0.386492654, 0.380427637}, // 3867K
			{0.386445757, 0.380399814}, // 3868K
			{0.386398882, 0.380371994}, // 3869K
			{0.38635203, 0.380344176}, // 3870K
			{0.3863052, 0.38031636}, // 3871K
			{0.386258392, 0.380288547}, // 3872K
			{0.386211606, 0.380260737}, // 3873K
			{0.386164843, 0.380232928}, // 3874K
			{0.386118101, 0.380205122}, // 3875K
			{0.386071382, 0.380177319}, // 3876K
			{0.386024685, 0.380149518}, // 3877K
			{0.38597801, 0.38012172}, // 3878K
			{0.385931358, 0.380093924}, // 3879K
			{0.385884727, 0.38006613}, // 3880K
			{0.385838119, 0.380038339}, // 3881K
			{0.385791533, 0.380010551}, // 3882K
			{0.385744969, 0.379982765}, // 3883K
			{0.385698427, 0.379954981}, // 3884K
			{0.385651907, 0.3799272}, // 3885K
			{0.385605409, 0.379899422}, // 3886K
			{0.385558933, 0.379871646}, // 3887K
			{0.38551248, 0.379843873}, // 3888K
			{0.385466048, 0.379816102}, // 3889K
			{0.385419638, 0.379788334}, // 3890K
			{0.38537325, 0.379760568}, // 3891K
			{0.385326885, 0.379732805}, // 3892K
			{0.385280541, 0.379705044}, // 3893K
			{0.385234219, 0.379677287}, // 3894K
			{0.38518792, 0.379649531}, // 3895K
			{0.385141642, 0.379621779}, // 3896K
			{0.385095386, 0.379594029}, // 3897K
			{0.385049152, 0.379566281}, // 3898K
			{0.38500294, 0.379538536}, // 3899K
			{0.38495675, 0.379510794}, // 3900K
			{0.384910582, 0.379483055}, // 3901K
			{0.384864436, 0.379455318}, // 3902K
			{0.384818311, 0.379427584}, // 3903K
			{0.384772208, 0.379399852}, // 3904K
			{0.384726128, 0.379372123}, // 3905K
			{0.384680069, 0.379344397}, // 3906K
			{0.384634032, 0.379316674}, // 3907K
			{0.384588016, 0.379288953}, // 3908K
			{0.384542023, 0.379261235}, // 3909K
			{0.384496051, 0.379233519}, // 3910K
			{0.384450101, 0.379205807}, // 3911K
			{0.384404173, 0.379178097}, // 3912K
			{0.384358267, 0.37915039}, // 3913K
			{0.384312382, 0.379122685}, // 3914K
			{0.384266519, 0.379094984}, // 3915K
			{0.384220678, 0.379067285}, // 3916K
			{0.384174858, 0.379039589}, // 3917K
			{0.384129061, 0.379011895}, // 3918K
			{0.384083285, 0.378984205}, // 3919K
			{0.38403753, 0.378956517}, // 3920K
			{0.383991797, 0.378928832}, // 3921K
			{0.383946086, 0.37890115}, // 3922K
			{0.383900397, 0.37887347}, // 3923K
			{0.383854729, 0.378845794}, // 3924K
			{0.383809082, 0.37881812}, // 3925K
			{0.383763458, 0.378790449}, // 3926K
			{0.383717855, 0.378762781}, // 3927K
			{0.383672273, 0.378735116}, // 3928K
			{0.383626713, 0.378707454}, // 3929K
			{0.383581175, 0.378679794}, // 3930K
			{0.383535658, 0.378652138}, // 3931K
			{0.383490162, 0.378624484}, // 3932K
			{0.383444689, 0.378596833}, // 3933K
			{0.383399236, 0.378569185}, // 3934K
			{0.383353805, 0.37854154}, // 3935K
			{0.383308396, 0.378513898}, // 3936K
			{0.383263008, 0.378486259}, // 3937K
			{0.383217642, 0.378458622}, // 3938K
			{0.383172297, 0.378430989}, // 3939K
			{0.383126973, 0.378403359}, // 3940K
			{0.383081671, 0.378375731}, // 3941K
			{0.383036391, 0.378348106}, // 3942K
			{0.382991131, 0.378320485}, // 3943K
			{0.382945893, 0.378292866}, // 3944K
			{0.382900677, 0.378265251}, // 3945K
			{0.382855482, 0.378237638}, // 3946K
			{0.382810308, 0.378210028}, // 3947K
			{0.382765156, 0.378182421}, // 3948K
			{0.382720025, 0.378154818}, // 3949K
			{0.382674915, 0.378127217}, // 3950K
			{0.382629826, 0.378099619}, // 3951K
			{0.382584759, 0.378072024}, // 3952K
			{0.382539713, 0.378044433}, // 3953K
			{0.382494689, 0.378016844}, // 3954K
			{0.382449685, 0.377989258}, // 3955K
			{0.382404703, 0.377961676}, // 3956K
			{0.382359742, 0.377934096}, // 3957K
			{0.382314803, 0.37790652}, // 3958K
			{0.382269884, 0.377878947}, // 3959K
			{0.382224987, 0.377851376}, // 3960K
			{0.382180111, 0.377823809}, // 3961K
			{0.382135256, 0.377796245}, // 3962K
			{0.382090422, 0.377768684}, // 3963K
			{0.38204561, 0.377741126}, // 3964K
			{0.382000819, 0.377713571}, // 3965K
			{0.381956048, 0.377686019}, // 3966K
			{0.381911299, 0.377658471}, // 3967K
			{0.381866571, 0.377630925}, // 3968K
			{0.381821864, 0.377603383}, // 3969K
			{0.381777179, 0.377575843}, // 3970K
			{0.381732514, 0.377548307}, // 3971K
			{0.38168787, 0.377520774}, // 3972K
			{0.381643248, 0.377493245}, // 3973K
			{0.381598646, 0.377465718}, // 3974K
			{0.381554066, 0.377438195}, // 3975K
			{0.381509506, 0.377410674}, // 3976K
			{0.381464968, 0.377383157}, // 3977K
			{0.38142045, 0.377355643}, // 3978K
			{0.381375954, 0.377328133}, // 3979K
			{0.381331478, 0.377300625}, // 3980K
			{0.381287024, 0.377273121}, // 3981K
			{0.38124259, 0.37724562}, // 3982K
			{0.381198178, 0.377218122}, // 3983K
			{0.381153786, 0.377190627}, // 3984K
			{0.381109415, 0.377163136}, // 3985K
			{0.381065065, 0.377135648}, // 3986K
			{0.381020736, 0.377108163}, // 3987K
			{0.380976428, 0.377080682}, // 3988K
			{0.380932141, 0.377053203}, // 3989K
			{0.380887875, 0.377025728}, // 3990K
			{0.380843629, 0.376998256}, // 3991K
			{0.380799404, 0.376970788}, // 3992K
			{0.380755201, 0.376943323}, // 3993K
			{0.380711018, 0.376915861}, // 3994K
			{0.380666855, 0.376888402}, // 3995K
			{0.380622714, 0.376860947}, // 3996K
			{0.380578593, 0.376833495}, // 3997K
			{0.380534494, 0.376806046}, // 3998K
			{0.380490414, 0.376778601}, // 3999K
			{0.380446356, 0.376751159}, // 4000K
			{0.380402319, 0.37672372}, // 4001K
			{0.380358302, 0.376696284}, // 4002K
			{0.380314305, 0.376668852}, // 4003K
			{0.38027033, 0.376641424}, // 4004K
			{0.380226375, 0.376613999}, // 4005K
			{0.380182441, 0.376586577}, // 4006K
			{0.380138528, 0.376559158}, // 4007K
			{0.380094635, 0.376531743}, // 4008K
			{0.380050763, 0.376504331}, // 4009K
			{0.380006911, 0.376476923}, // 4010K
			{0.379963081, 0.376449518}, // 4011K
			{0.37991927, 0.376422116}, // 4012K
			{0.379875481, 0.376394718}, // 4013K
			{0.379831712, 0.376367323}, // 4014K
			{0.379787963, 0.376339932}, // 4015K
			{0.379744236, 0.376312544}, // 4016K
			{0.379700528, 0.37628516}, // 4017K
			{0.379656841, 0.376257779}, // 4018K
			{0.379613175, 0.376230401}, // 4019K
			{0.37956953, 0.376203027}, // 4020K
			{0.379525904, 0.376175656}, // 4021K
			{0.3794823, 0.376148289}, // 4022K
			{0.379438715, 0.376120926}, // 4023K
			{0.379395152, 0.376093565}, // 4024K
			{0.379351609, 0.376066209}, // 4025K
			{0.379308086, 0.376038855}, // 4026K
			{0.379264583, 0.376011506}, // 4027K
			{0.379221102, 0.375984159}, // 4028K
			{0.37917764, 0.375956817}, // 4029K
			{0.379134199, 0.375929477}, // 4030K
			{0.379090778, 0.375902142}, // 4031K
			{0.379047378, 0.375874809}, // 4032K
			{0.379003998, 0.375847481}, // 4033K
			{0.378960639, 0.375820156}, // 4034K
			{0.3789173, 0.375792834}, // 4035K
			{0.378873981, 0.375765516}, // 4036K
			{0.378830682, 0.375738202}, // 4037K
			{0.378787404, 0.375710891}, // 4038K
			{0.378744146, 0.375683583}, // 4039K
			{0.378700909, 0.37565628}, // 4040K
			{0.378657692, 0.375628979}, // 4041K
			{0.378614495, 0.375601683}, // 4042K
			{0.378571318, 0.37557439}, // 4043K
			{0.378528162, 0.3755471}, // 4044K
			{0.378485025, 0.375519814}, // 4045K
			{0.378441909, 0.375492532}, // 4046K
			{0.378398814, 0.375465254}, // 4047K
			{0.378355738, 0.375437979}, // 4048K
			{0.378312683, 0.375410707}, // 4049K
			{0.378269648, 0.375383439}, // 4050K
			{0.378226633, 0.375356175}, // 4051K
			{0.378183638, 0.375328915}, // 4052K
			{0.378140664, 0.375301658}, // 4053K
			{0.378097709, 0.375274405}, // 4054K
			{0.378054775, 0.375247155}, // 4055K
			{0.378011861, 0.375219909}, // 4056K
			{0.377968967, 0.375192667}, // 4057K
			{0.377926093, 0.375165429}, // 4058K
			{0.377883239, 0.375138194}, // 4059K
			{0.377840405, 0.375110963}, // 4060K
			{0.377797591, 0.375083735}, // 4061K
			{0.377754798, 0.375056511}, // 4062K
			{0.377712024, 0.375029291}, // 4063K
			{0.377669271, 0.375002075}, // 4064K
			{0.377626537, 0.374974862}, // 4065K
			{0.377583823, 0.374947653}, // 4066K
			{0.37754113, 0.374920448}, // 4067K
			{0.377498456, 0.374893247}, // 4068K
			{0.377455803, 0.374866049}, // 4069K
			{0.377413169, 0.374838855}, // 4070K
			{0.377370556, 0.374811665}, // 4071K
			{0.377327962, 0.374784478}, // 4072K
			{0.377285388, 0.374757295}, // 4073K
			{0.377242835, 0.374730116}, // 4074K
			{0.377200301, 0.374702941}, // 4075K
			{0.377157787, 0.37467577}, // 4076K
			{0.377115293, 0.374648602}, // 4077K
			{0.377072819, 0.374621438}, // 4078K
			{0.377030364, 0.374594278}, // 4079K
			{0.37698793, 0.374567122}, // 4080K
			{0.376945515, 0.374539969}, // 4081K
			{0.376903121, 0.37451282}, // 4082K
			{0.376860746, 0.374485675}, // 4083K
			{0.376818391, 0.374458534}, // 4084K
			{0.376776056, 0.374431397}, // 4085K
			{0.37673374, 0.374404263}, // 4086K
			{0.376691444, 0.374377134}, // 4087K
			{0.376649169, 0.374350008}, // 4088K
			{0.376606912, 0.374322886}, // 4089K
			{0.376564676, 0.374295768}, // 4090K
			{0.376522459, 0.374268654}, // 4091K
			{0.376480263, 0.374241543}, // 4092K
			{0.376438085, 0.374214437}, // 4093K
			{0.376395928, 0.374187334}, // 4094K
			{0.37635379, 0.374160235}, // 4095K
			{0.376311672, 0.37413314}, // 4096K
			{0.376269574, 0.374106049}, // 4097K
			{0.376227495, 0.374078962}, // 4098K
			{0.376185436, 0.374051878}, // 4099K
			{0.376143397, 0.374024799}, // 4100K
			{0.376101377, 0.373997723}, // 4101K
			{0.376059377, 0.373970652}, // 4102K
			{0.376017396, 0.373943584}, // 4103K
			{0.375975435, 0.37391652}, // 4104K
			{0.375933494, 0.37388946}, // 4105K
			{0.375891572, 0.373862405}, // 4106K
			{0.37584967, 0.373835353}, // 4107K
			{0.375807788, 0.373808304}, // 4108K
			{0.375765925, 0.37378126}, // 4109K
			{0.375724081, 0.37375422}, // 4110K
			{0.375682257, 0.373727184}, // 4111K
			{0.375640453, 0.373700152}, // 4112K
			{0.375598668, 0.373673123}, // 4113K
			{0.375556902, 0.373646099}, // 4114K
			{0.375515156, 0.373619078}, // 4115K
			{0.37547343, 0.373592062}, // 4116K
			{0.375431723, 0.37356505}, // 4117K
			{0.375390035, 0.373538041}, // 4118K
			{0.375348367, 0.373511037}, // 4119K
			{0.375306718, 0.373484036}, // 4120K
			{0.375265089, 0.37345704}, // 4121K
			{0.375223479, 0.373430047}, // 4122K
			{0.375181889, 0.373403059}, // 4123K
			{0.375140318, 0.373376074}, // 4124K
			{0.375098766, 0.373349094}, // 4125K
			{0.375057234, 0.373322117}, // 4126K
			{0.375015721, 0.373295145}, // 4127K
			{0.374974227, 0.373268177}, // 4128K
			{0.374932753, 0.373241212}, // 4129K
			{0.374891298, 0.373214252}, // 4130K
			{0.374849863, 0.373187296}, // 4131K
			{0.374808446, 0.373160344}, // 4132K
			{0.374767049, 0.373133395}, // 4133K
			{0.374725672, 0.373106451}, // 4134K
			{0.374684313, 0.373079511}, // 4135K
			{0.374642974, 0.373052575}, // 4136K
			{0.374601654, 0.373025643}, // 4137K
			{0.374560354, 0.372998716}, // 4138K
			{0.374519072, 0.372971792}, // 4139K
			{0.37447781, 0.372944872}, // 4140K
			{0.374436567, 0.372917957}, // 4141K
			{0.374395343, 0.372891045}, // 4142K
			{0.374354139, 0.372864138}, // 4143K
			{0.374312953, 0.372837235}, // 4144K
			{0.374271787, 0.372810336}, // 4145K
			{0.37423064, 0.372783441}, // 4146K
			{0.374189512, 0.37275655}, // 4147K
			{0.374148403, 0.372729663}, // 4148K
			{0.374107313, 0.37270278}, // 4149K
			{0.374066243, 0.372675902}, // 4150K
			{0.374025191, 0.372649028}, // 4151K
			{0.373984159, 0.372622157}, // 4152K
			{0.373943146, 0.372595291}, // 4153K
			{0.373902151, 0.372568429}, // 4154K
			{0.373861176, 0.372541572}, // 4155K
			{0.37382022, 0.372514718}, // 4156K
			{0.373779283, 0.372487869}, // 4157K
			{0.373738365, 0.372461023}, // 4158K
			{0.373697466, 0.372434182}, // 4159K
			{0.373656586, 0.372407345}, // 4160K
			{0.373615725, 0.372380513}, // 4161K
			{0.373574883, 0.372353684}, // 4162K
			{0.37353406, 0.37232686}, // 4163K
			{0.373493256, 0.372300039}, // 4164K
			{0.373452471, 0.372273224}, // 4165K
			{0.373411705, 0.372246412}, // 4166K
			{0.373370958, 0.372219604}, // 4167K
			{0.37333023, 0.372192801}, // 4168K
			{0.373289521, 0.372166002}, // 4169K
			{0.37324883, 0.372139207}, // 4170K
			{0.373208159, 0.372112416}, // 4171K
			{0.373167506, 0.37208563}, // 4172K
			{0.373126872, 0.372058848}, // 4173K
			{0.373086258, 0.37203207}, // 4174K
			{0.373045662, 0.372005296}, // 4175K
			{0.373005084, 0.371978526}, // 4176K
			{0.372964526, 0.371951761}, // 4177K
			{0.372923987, 0.371925}, // 4178K
			{0.372883466, 0.371898243}, // 4179K
			{0.372842964, 0.371871491}, // 4180K
			{0.372802481, 0.371844743}, // 4181K
			{0.372762017, 0.371817999}, // 4182K
			{0.372721571, 0.371791259}, // 4183K
			{0.372681144, 0.371764524}, // 4184K
			{0.372640736, 0.371737793}, // 4185K
			{0.372600347, 0.371711066}, // 4186K
			{0.372559977, 0.371684344}, // 4187K
			{0.372519625, 0.371657625}, // 4188K
			{0.372479292, 0.371630911}, // 4189K
			{0.372438977, 0.371604202}, // 4190K
			{0.372398682, 0.371577497}, // 4191K
			{0.372358405, 0.371550796}, // 4192K
			{0.372318146, 0.371524099}, // 4193K
			{0.372277907, 0.371497407}, // 4194K
			{0.372237686, 0.371470719}, // 4195K
			{0.372197483, 0.371444035}, // 4196K
			{0.372157299, 0.371417356}, // 4197K
			{0.372117134, 0.371390681}, // 4198K
			{0.372076988, 0.37136401}, // 4199K
			{0.37203686, 0.371337344}, // 4200K
			{0.37199675, 0.371310682}, // 4201K
			{0.37195666, 0.371284024}, // 4202K
			{0.371916588, 0.371257371}, // 4203K
			{0.371876534, 0.371230722}, // 4204K
			{0.371836499, 0.371204078}, // 4205K
			{0.371796482, 0.371177437}, // 4206K
			{0.371756484, 0.371150802}, // 4207K
			{0.371716505, 0.37112417}, // 4208K
			{0.371676544, 0.371097543}, // 4209K
			{0.371636601, 0.371070921}, // 4210K
			{0.371596677, 0.371044302}, // 4211K
			{0.371556772, 0.371017689}, // 4212K
			{0.371516885, 0.370991079}, // 4213K
			{0.371477016, 0.370964474}, // 4214K
			{0.371437166, 0.370937873}, // 4215K
			{0.371397334, 0.370911277}, // 4216K
			{0.371357521, 0.370884685}, // 4217K
			{0.371317726, 0.370858098}, // 4218K
			{0.37127795, 0.370831515}, // 4219K
			{0.371238192, 0.370804936}, // 4220K
			{0.371198452, 0.370778362}, // 4221K
			{0.371158731, 0.370751793}, // 4222K
			{0.371119028, 0.370725227}, // 4223K
			{0.371079343, 0.370698667}, // 4224K
			{0.371039677, 0.37067211}, // 4225K
			{0.371000029, 0.370645558}, // 4226K
			{0.3709604, 0.370619011}, // 4227K
			{0.370920788, 0.370592468}, // 4228K
			{0.370881195, 0.370565929}, // 4229K
			{0.370841621, 0.370539395}, // 4230K
			{0.370802064, 0.370512865}, // 4231K
			{0.370762526, 0.37048634}, // 4232K
			{0.370723007, 0.37045982}, // 4233K
			{0.370683505, 0.370433303}, // 4234K
			{0.370644022, 0.370406792}, // 4235K
			{0.370604557, 0.370380284}, // 4236K
			{0.37056511, 0.370353782}, // 4237K
			{0.370525681, 0.370327283}, // 4238K
			{0.370486271, 0.37030079}, // 4239K
			{0.370446878, 0.3702743}, // 4240K
			{0.370407504, 0.370247816}, // 4241K
			{0.370368149, 0.370221335}, // 4242K
			{0.370328811, 0.37019486}, // 4243K
			{0.370289491, 0.370168388}, // 4244K
			{0.37025019, 0.370141922}, // 4245K
			{0.370210907, 0.370115459}, // 4246K
			{0.370171641, 0.370089002}, // 4247K
			{0.370132394, 0.370062549}, // 4248K
			{0.370093166, 0.3700361}, // 4249K
			{0.370053955, 0.370009656}, // 4250K
			{0.370014762, 0.369983216}, // 4251K
			{0.369975587, 0.369956781}, // 4252K
			{0.369936431, 0.369930351}, // 4253K
			{0.369897292, 0.369903925}, // 4254K
			{0.369858172, 0.369877504}, // 4255K
			{0.369819069, 0.369851087}, // 4256K
			{0.369779985, 0.369824675}, // 4257K
			{0.369740918, 0.369798267}, // 4258K
			{0.36970187, 0.369771864}, // 4259K
			{0.36966284, 0.369745465}, // 4260K
			{0.369623827, 0.369719071}, // 4261K
			{0.369584833, 0.369692682}, // 4262K
			{0.369545856, 0.369666297}, // 4263K
			{0.369506898, 0.369639917}, // 4264K
			{0.369467957, 0.369613541}, // 4265K
			{0.369429035, 0.36958717}, // 4266K
			{0.36939013, 0.369560804}, // 4267K
			{0.369351243, 0.369534442}, // 4268K
			{0.369312374, 0.369508085}, // 4269K
			{0.369273523, 0.369481732}, // 4270K
			{0.36923469, 0.369455384}, // 4271K
			{0.369195875, 0.369429041}, // 4272K
			{0.369157078, 0.369402702}, // 4273K
			{0.369118298, 0.369376368}, // 4274K
			{0.369079536, 0.369350038}, // 4275K
			{0.369040793, 0.369323713}, // 4276K
			{0.369002067, 0.369297393}, // 4277K
			{0.368963359, 0.369271077}, // 4278K
			{0.368924668, 0.369244766}, // 4279K
			{0.368885996, 0.36921846}, // 4280K
			{0.368847341, 0.369192158}, // 4281K
			{0.368808704, 0.369165861}, // 4282K
			{0.368770085, 0.369139568}, // 4283K
			{0.368731483, 0.369113281}, // 4284K
			{0.3686929, 0.369086997}, // 4285K
			{0.368654334, 0.369060719}, // 4286K
			{0.368615785, 0.369034445}, // 4287K
			{0.368577255, 0.369008176}, // 4288K
			{0.368538742, 0.368981911}, // 4289K
			{0.368500247, 0.368955651}, // 4290K
			{0.36846177, 0.368929396}, // 4291K
			{0.36842331, 0.368903146}, // 4292K
			{0.368384868, 0.3688769}, // 4293K
			{0.368346444, 0.368850659}, // 4294K
			{0.368308037, 0.368824422}, // 4295K
			{0.368269648, 0.368798191}, // 4296K
			{0.368231276, 0.368771964}, // 4297K
			{0.368192923, 0.368745741}, // 4298K
			{0.368154586, 0.368719524}, // 4299K
			{0.368116268, 0.368693311}, // 4300K
			{0.368077967, 0.368667102}, // 4301K
			{0.368039683, 0.368640899}, // 4302K
			{0.368001418, 0.3686147}, // 4303K
			{0.367963169, 0.368588506}, // 4304K
			{0.367924939, 0.368562316}, // 4305K
			{0.367886725, 0.368536132}, // 4306K
			{0.36784853, 0.368509952}, // 4307K
			{0.367810352, 0.368483777}, // 4308K
			{0.367772191, 0.368457606}, // 4309K
			{0.367734048, 0.36843144}, // 4310K
			{0.367695922, 0.368405279}, // 4311K
			{0.367657814, 0.368379123}, // 4312K
			{0.367619724, 0.368352972}, // 4313K
			{0.367581651, 0.368326825}, // 4314K
			{0.367543595, 0.368300683}, // 4315K
			{0.367505557, 0.368274545}, // 4316K
			{0.367467536, 0.368248413}, // 4317K
			{0.367429533, 0.368222285}, // 4318K
			{0.367391547, 0.368196162}, // 4319K
			{0.367353578, 0.368170044}, // 4320K
			{0.367315627, 0.36814393}, // 4321K
			{0.367277693, 0.368117822}, // 4322K
			{0.367239777, 0.368091718}, // 4323K
			{0.367201878, 0.368065618}, // 4324K
			{0.367163996, 0.368039524}, // 4325K
			{0.367126132, 0.368013434}, // 4326K
			{0.367088285, 0.36798735}, // 4327K
			{0.367050456, 0.36796127}, // 4328K
			{0.367012643, 0.367935194}, // 4329K
			{0.366974849, 0.367909124}, // 4330K
			{0.366937071, 0.367883058}, // 4331K
			{0.366899311, 0.367856997}, // 4332K
			{0.366861568, 0.367830941}, // 4333K
			{0.366823842, 0.36780489}, // 4334K
			{0.366786133, 0.367778844}, // 4335K
			{0.366748442, 0.367752802}, // 4336K
			{0.366710768, 0.367726765}, // 4337K
			{0.366673111, 0.367700733}, // 4338K
			{0.366635472, 0.367674706}, // 4339K
			{0.36659785, 0.367648684}, // 4340K
			{0.366560245, 0.367622666}, // 4341K
			{0.366522657, 0.367596653}, // 4342K
			{0.366485086, 0.367570645}, // 4343K
			{0.366447533, 0.367544642}, // 4344K
			{0.366409996, 0.367518644}, // 4345K
			{0.366372477, 0.367492651}, // 4346K
			{0.366334975, 0.367466662}, // 4347K
			{0.36629749, 0.367440679}, // 4348K
			{0.366260023, 0.3674147}, // 4349K
			{0.366222572, 0.367388726}, // 4350K
			{0.366185139, 0.367362757}, // 4351K
			{0.366147722, 0.367336792}, // 4352K
			{0.366110323, 0.367310833}, // 4353K
			{0.366072941, 0.367284878}, // 4354K
			{0.366035576, 0.367258929}, // 4355K
			{0.365998228, 0.367232984}, // 4356K
			{0.365960897, 0.367207044}, // 4357K
			{0.365923583, 0.367181109}, // 4358K
			{0.365886286, 0.367155178}, // 4359K
			{0.365849006, 0.367129253}, // 4360K
			{0.365811743, 0.367103333}, // 4361K
			{0.365774498, 0.367077417}, // 4362K
			{0.365737269, 0.367051506}, // 4363K
			{0.365700057, 0.367025601}, // 4364K
			{0.365662862, 0.3669997}, // 4365K
			{0.365625684, 0.366973804}, // 4366K
			{0.365588523, 0.366947912}, // 4367K
			{0.36555138, 0.366922026}, // 4368K
			{0.365514253, 0.366896145}, // 4369K
			{0.365477143, 0.366870268}, // 4370K
			{0.36544005, 0.366844397}, // 4371K
			{0.365402973, 0.36681853}, // 4372K
			{0.365365914, 0.366792669}, // 4373K
			{0.365328872, 0.366766812}, // 4374K
			{0.365291846, 0.36674096}, // 4375K
			{0.365254838, 0.366715113}, // 4376K
			{0.365217846, 0.366689271}, // 4377K
			{0.365180871, 0.366663434}, // 4378K
			{0.365143913, 0.366637602}, // 4379K
			{0.365106972, 0.366611774}, // 4380K
			{0.365070048, 0.366585952}, // 4381K
			{0.36503314, 0.366560135}, // 4382K
			{0.36499625, 0.366534322}, // 4383K
			{0.364959376, 0.366508515}, // 4384K
			{0.364922519, 0.366482712}, // 4385K
			{0.364885679, 0.366456915}, // 4386K
			{0.364848855, 0.366431122}, // 4387K
			{0.364812049, 0.366405334}, // 4388K
			{0.364775259, 0.366379551}, // 4389K
			{0.364738485, 0.366353773}, // 4390K
			{0.364701729, 0.366328001}, // 4391K
			{0.364664989, 0.366302233}, // 4392K
			{0.364628266, 0.36627647}, // 4393K
			{0.36459156, 0.366250712}, // 4394K
			{0.364554871, 0.366224959}, // 4395K
			{0.364518198, 0.366199211}, // 4396K
			{0.364481542, 0.366173468}, // 4397K
			{0.364444902, 0.36614773}, // 4398K
			{0.364408279, 0.366121996}, // 4399K
			{0.364371673, 0.366096268}, // 4400K
			{0.364335084, 0.366070545}, // 4401K
			{0.364298511, 0.366044827}, // 4402K
			{0.364261955, 0.366019114}, // 4403K
			{0.364225415, 0.365993405}, // 4404K
			{0.364188892, 0.365967702}, // 4405K
			{0.364152386, 0.365942004}, // 4406K
			{0.364115896, 0.365916311}, // 4407K
			{0.364079423, 0.365890623}, // 4408K
			{0.364042966, 0.365864939}, // 4409K
			{0.364006526, 0.365839261}, // 4410K
			{0.363970103, 0.365813588}, // 4411K
			{0.363933696, 0.36578792}, // 4412K
			{0.363897305, 0.365762256}, // 4413K
			{0.363860932, 0.365736598}, // 4414K
			{0.363824574, 0.365710945}, // 4415K
			{0.363788234, 0.365685297}, // 4416K
			{0.363751909, 0.365659654}, // 4417K
			{0.363715601, 0.365634015}, // 4418K
			{0.36367931, 0.365608382}, // 4419K
			{0.363643035, 0.365582754}, // 4420K
			{0.363606777, 0.365557131}, // 4421K
			{0.363570535, 0.365531513}, // 4422K
			{0.36353431, 0.3655059}, // 4423K
			{0.363498101, 0.365480292}, // 4424K
			{0.363461908, 0.365454689}, // 4425K
			{0.363425732, 0.365429091}, // 4426K
			{0.363389572, 0.365403498}, // 4427K
			{0.363353429, 0.365377911}, // 4428K
			{0.363317302, 0.365352328}, // 4429K
			{0.363281192, 0.36532675}, // 4430K
			{0.363245097, 0.365301177}, // 4431K
			{0.36320902, 0.36527561}, // 4432K
			{0.363172958, 0.365250047}, // 4433K
			{0.363136913, 0.36522449}, // 4434K
			{0.363100885, 0.365198937}, // 4435K
			{0.363064872, 0.36517339}, // 4436K
			{0.363028876, 0.365147848}, // 4437K
			{0.362992896, 0.36512231}, // 4438K
			{0.362956933, 0.365096778}, // 4439K
			{0.362920986, 0.365071251}, // 4440K
			{0.362885055, 0.365045729}, // 4441K
			{0.36284914, 0.365020212}, // 4442K
			{0.362813242, 0.3649947}, // 4443K
			{0.36277736, 0.364969193}, // 4444K
			{0.362741494, 0.364943691}, // 4445K
			{0.362705645, 0.364918195}, // 4446K
			{0.362669812, 0.364892703}, // 4447K
			{0.362633995, 0.364867217}, // 4448K
			{0.362598194, 0.364841735}, // 4449K
			{0.362562409, 0.364816259}, // 4450K
			{0.362526641, 0.364790788}, // 4451K
			{0.362490888, 0.364765322}, // 4452K
			{0.362455152, 0.36473986}, // 4453K
			{0.362419433, 0.364714405}, // 4454K
			{0.362383729, 0.364688954}, // 4455K
			{0.362348041, 0.364663508}, // 4456K
			{0.36231237, 0.364638067}, // 4457K
			{0.362276715, 0.364612632}, // 4458K
			{0.362241075, 0.364587201}, // 4459K
			{0.362205452, 0.364561776}, // 4460K
			{0.362169846, 0.364536356}, // 4461K
			{0.362134255, 0.364510941}, // 4462K
			{0.36209868, 0.364485531}, // 4463K
			{0.362063121, 0.364460126}, // 4464K
			{0.362027579, 0.364434726}, // 4465K
			{0.361992052, 0.364409331}, // 4466K
			{0.361956542, 0.364383942}, // 4467K
			{0.361921048, 0.364358558}, // 4468K
			{0.361885569, 0.364333178}, // 4469K
			{0.361850107, 0.364307804}, // 4470K
			{0.361814661, 0.364282435}, // 4471K
			{0.36177923, 0.364257071}, // 4472K
			{0.361743816, 0.364231713}, // 4473K
			{0.361708418, 0.364206359}, // 4474K
			{0.361673036, 0.364181011}, // 4475K
			{0.361637669, 0.364155667}, // 4476K
			{0.361602319, 0.364130329}, // 4477K
			{0.361566985, 0.364104996}, // 4478K
			{0.361531666, 0.364079668}, // 4479K
			{0.361496364, 0.364054346}, // 4480K
			{0.361461077, 0.364029028}, // 4481K
			{0.361425807, 0.364003716}, // 4482K
			{0.361390552, 0.363978408}, // 4483K
			{0.361355313, 0.363953106}, // 4484K
			{0.36132009, 0.363927809}, // 4485K
			{0.361284883, 0.363902518}, // 4486K
			{0.361249692, 0.363877231}, // 4487K
			{0.361214517, 0.363851949}, // 4488K
			{0.361179358, 0.363826673}, // 4489K
			{0.361144214, 0.363801402}, // 4490K
			{0.361109087, 0.363776136}, // 4491K
			{0.361073975, 0.363750875}, // 4492K
			{0.361038879, 0.36372562}, // 4493K
			{0.361003799, 0.363700369}, // 4494K
			{0.360968734, 0.363675124}, // 4495K
			{0.360933686, 0.363649884}, // 4496K
			{0.360898653, 0.363624649}, // 4497K
			{0.360863636, 0.363599419}, // 4498K
			{0.360828635, 0.363574195}, // 4499K
			{0.360793649, 0.363548975}, // 4500K
			{0.36075868, 0.363523761}, // 4501K
			{0.360723726, 0.363498552}, // 4502K
			{0.360688788, 0.363473349}, // 4503K
			{0.360653865, 0.36344815}, // 4504K
			{0.360618959, 0.363422957}, // 4505K
			{0.360584068, 0.363397768}, // 4506K
			{0.360549192, 0.363372585}, // 4507K
			{0.360514333, 0.363347407}, // 4508K
			{0.360479489, 0.363322235}, // 4509K
			{0.360444661, 0.363297067}, // 4510K
			{0.360409848, 0.363271905}, // 4511K
			{0.360375051, 0.363246748}, // 4512K
			{0.36034027, 0.363221596}, // 4513K
			{0.360305505, 0.36319645}, // 4514K
			{0.360270755, 0.363171309}, // 4515K
			{0.36023602, 0.363146172}, // 4516K
			{0.360201302, 0.363121041}, // 4517K
			{0.360166599, 0.363095916}, // 4518K
			{0.360131911, 0.363070795}, // 4519K
			{0.36009724, 0.36304568}, // 4520K
			{0.360062583, 0.36302057}, // 4521K
			{0.360027943, 0.362995465}, // 4522K
			{0.359993318, 0.362970365}, // 4523K
			{0.359958708, 0.362945271}, // 4524K
			{0.359924114, 0.362920182}, // 4525K
			{0.359889536, 0.362895098}, // 4526K
			{0.359854973, 0.362870019}, // 4527K
			{0.359820425, 0.362844946}, // 4528K
			{0.359785894, 0.362819877}, // 4529K
			{0.359751377, 0.362794814}, // 4530K
			{0.359716876, 0.362769757}, // 4531K
			{0.359682391, 0.362744704}, // 4532K
			{0.359647921, 0.362719657}, // 4533K
			{0.359613467, 0.362694615}, // 4534K
			{0.359579028, 0.362669578}, // 4535K
			{0.359544604, 0.362644546}, // 4536K
			{0.359510196, 0.36261952}, // 4537K
			{0.359475804, 0.362594499}, // 4538K
			{0.359441427, 0.362569483}, // 4539K
			{0.359407065, 0.362544473}, // 4540K
			{0.359372719, 0.362519467}, // 4541K
			{0.359338388, 0.362494467}, // 4542K
			{0.359304073, 0.362469472}, // 4543K
			{0.359269773, 0.362444483}, // 4544K
			{0.359235488, 0.362419499}, // 4545K
			{0.359201219, 0.36239452}, // 4546K
			{0.359166965, 0.362369546}, // 4547K
			{0.359132726, 0.362344577}, // 4548K
			{0.359098503, 0.362319614}, // 4549K
			{0.359064295, 0.362294656}, // 4550K
			{0.359030102, 0.362269703}, // 4551K
			{0.358995925, 0.362244756}, // 4552K
			{0.358961763, 0.362219814}, // 4553K
			{0.358927617, 0.362194877}, // 4554K
			{0.358893485, 0.362169945}, // 4555K
			{0.358859369, 0.362145019}, // 4556K
			{0.358825269, 0.362120098}, // 4557K
			{0.358791183, 0.362095182}, // 4558K
			{0.358757113, 0.362070271}, // 4559K
			{0.358723058, 0.362045366}, // 4560K
			{0.358689018, 0.362020466}, // 4561K
			{0.358654994, 0.361995572}, // 4562K
			{0.358620985, 0.361970682}, // 4563K
			{0.358586991, 0.361945798}, // 4564K
			{0.358553012, 0.361920919}, // 4565K
			{0.358519049, 0.361896046}, // 4566K
			{0.3584851, 0.361871178}, // 4567K
			{0.358451167, 0.361846315}, // 4568K
			{0.358417249, 0.361821457}, // 4569K
			{0.358383346, 0.361796605}, // 4570K
			{0.358349459, 0.361771758}, // 4571K
			{0.358315586, 0.361746916}, // 4572K
			{0.358281729, 0.361722079}, // 4573K
			{0.358247887, 0.361697248}, // 4574K
			{0.35821406, 0.361672422}, // 4575K
			{0.358180248, 0.361647602}, // 4576K
			{0.358146451, 0.361622787}, // 4577K
			{0.358112669, 0.361597977}, // 4578K
			{0.358078903, 0.361573172}, // 4579K
			{0.358045151, 0.361548373}, // 4580K
			{0.358011415, 0.361523579}, // 4581K
			{0.357977693, 0.36149879}, // 4582K
			{0.357943987, 0.361474006}, // 4583K
			{0.357910296, 0.361449228}, // 4584K
			{0.35787662, 0.361424456}, // 4585K
			{0.357842958, 0.361399688}, // 4586K
			{0.357809312, 0.361374926}, // 4587K
			{0.357775681, 0.361350169}, // 4588K
			{0.357742065, 0.361325418}, // 4589K
			{0.357708464, 0.361300671}, // 4590K
			{0.357674878, 0.361275931}, // 4591K
			{0.357641307, 0.361251195}, // 4592K
			{0.357607751, 0.361226465}, // 4593K
			{0.35757421, 0.36120174}, // 4594K
			{0.357540684, 0.36117702}, // 4595K
			{0.357507172, 0.361152306}, // 4596K
			{0.357473676, 0.361127597}, // 4597K
			{0.357440195, 0.361102894}, // 4598K
			{0.357406729, 0.361078195}, // 4599K
			{0.357373277, 0.361053503}, // 4600K
			{0.357339841, 0.361028815}, // 4601K
			{0.357306419, 0.361004133}, // 4602K
			{0.357273012, 0.360979456}, // 4603K
			{0.357239621, 0.360954784}, // 4604K
			{0.357206244, 0.360930118}, // 4605K
			{0.357172882, 0.360905457}, // 4606K
			{0.357139535, 0.360880802}, // 4607K
			{0.357106202, 0.360856152}, // 4608K
			{0.357072885, 0.360831507}, // 4609K
			{0.357039582, 0.360806867}, // 4610K
			{0.357006294, 0.360782233}, // 4611K
			{0.356973021, 0.360757604}, // 4612K
			{0.356939763, 0.360732981}, // 4613K
			{0.35690652, 0.360708363}, // 4614K
			{0.356873292, 0.36068375}, // 4615K
			{0.356840078, 0.360659142}, // 4616K
			{0.356806879, 0.36063454}, // 4617K
			{0.356773695, 0.360609944}, // 4618K
			{0.356740525, 0.360585352}, // 4619K
			{0.356707371, 0.360560766}, // 4620K
			{0.356674231, 0.360536186}, // 4621K
			{0.356641106, 0.360511611}, // 4622K
			{0.356607995, 0.360487041}, // 4623K
			{0.3565749, 0.360462476}, // 4624K
			{0.356541819, 0.360437917}, // 4625K
			{0.356508753, 0.360413363}, // 4626K
			{0.356475701, 0.360388815}, // 4627K
			{0.356442664, 0.360364272}, // 4628K
			{0.356409642, 0.360339734}, // 4629K
			{0.356376635, 0.360315201}, // 4630K
			{0.356343642, 0.360290674}, // 4631K
			{0.356310664, 0.360266153}, // 4632K
			{0.356277701, 0.360241637}, // 4633K
			{0.356244752, 0.360217126}, // 4634K
			{0.356211818, 0.36019262}, // 4635K
			{0.356178898, 0.36016812}, // 4636K
			{0.356145993, 0.360143625}, // 4637K
			{0.356113103, 0.360119136}, // 4638K
			{0.356080228, 0.360094652}, // 4639K
			{0.356047367, 0.360070173}, // 4640K
			{0.35601452, 0.3600457}, // 4641K
			{0.355981688, 0.360021232}, // 4642K
			{0.355948871, 0.35999677}, // 4643K
			{0.355916068, 0.359972313}, // 4644K
			{0.35588328, 0.359947861}, // 4645K
			{0.355850507, 0.359923415}, // 4646K
			{0.355817748, 0.359898974}, // 4647K
			{0.355785003, 0.359874538}, // 4648K
			{0.355752273, 0.359850108}, // 4649K
			{0.355719558, 0.359825683}, // 4650K
			{0.355686857, 0.359801264}, // 4651K
			{0.35565417, 0.35977685}, // 4652K
			{0.355621498, 0.359752441}, // 4653K
			{0.355588841, 0.359728038}, // 4654K
			{0.355556198, 0.35970364}, // 4655K
			{0.35552357, 0.359679248}, // 4656K
			{0.355490956, 0.359654861}, // 4657K
			{0.355458356, 0.359630479}, // 4658K
			{0.355425771, 0.359606103}, // 4659K
			{0.3553932, 0.359581732}, // 4660K
			{0.355360644, 0.359557367}, // 4661K
			{0.355328102, 0.359533007}, // 4662K
			{0.355295575, 0.359508652}, // 4663K
			{0.355263062, 0.359484303}, // 4664K
			{0.355230563, 0.359459959}, // 4665K
			{0.355198079, 0.359435621}, // 4666K
			{0.355165609, 0.359411288}, // 4667K
			{0.355133154, 0.35938696}, // 4668K
			{0.355100713, 0.359362638}, // 4669K
			{0.355068286, 0.359338321}, // 4670K
			{0.355035874, 0.35931401}, // 4671K
			{0.355003476, 0.359289704}, // 4672K
			{0.354971093, 0.359265403}, // 4673K
			{0.354938723, 0.359241108}, // 4674K
			{0.354906368, 0.359216818}, // 4675K
			{0.354874028, 0.359192534}, // 4676K
			{0.354841701, 0.359168255}, // 4677K
			{0.354809389, 0.359143981}, // 4678K
			{0.354777092, 0.359119713}, // 4679K
			{0.354744808, 0.359095451}, // 4680K
			{0.354712539, 0.359071193}, // 4681K
			{0.354680284, 0.359046942}, // 4682K
			{0.354648043, 0.359022695}, // 4683K
			{0.354615817, 0.358998454}, // 4684K
			{0.354583605, 0.358974219}, // 4685K
			{0.354551407, 0.358949988}, // 4686K
			{0.354519223, 0.358925764}, // 4687K
			{0.354487054, 0.358901544}, // 4688K
			{0.354454899, 0.35887733}, // 4689K
			{0.354422758, 0.358853122}, // 4690K
			{0.354390631, 0.358828919}, // 4691K
			{0.354358518, 0.358804721}, // 4692K
			{0.35432642, 0.358780529}, // 4693K
			{0.354294336, 0.358756342}, // 4694K
			{0.354262266, 0.358732161}, // 4695K
			{0.35423021, 0.358707985}, // 4696K
			{0.354198168, 0.358683815}, // 4697K
			{0.35416614, 0.35865965}, // 4698K
			{0.354134127, 0.35863549}, // 4699K
			{0.354102127, 0.358611336}, // 4700K
			{0.354070142, 0.358587187}, // 4701K
			{0.354038171, 0.358563044}, // 4702K
			{0.354006214, 0.358538906}, // 4703K
			{0.353974271, 0.358514774}, // 4704K
			{0.353942342, 0.358490647}, // 4705K
			{0.353910428, 0.358466525}, // 4706K
			{0.353878527, 0.358442409}, // 4707K
			{0.35384664, 0.358418298}, // 4708K
			{0.353814768, 0.358394193}, // 4709K
			{0.353782909, 0.358370093}, // 4710K
			{0.353751065, 0.358345999}, // 4711K
			{0.353719234, 0.35832191}, // 4712K
			{0.353687418, 0.358297826}, // 4713K
			{0.353655616, 0.358273748}, // 4714K
			{0.353623827, 0.358249676}, // 4715K
			{0.353592053, 0.358225609}, // 4716K
			{0.353560293, 0.358201547}, // 4717K
			{0.353528546, 0.358177491}, // 4718K
			{0.353496814, 0.35815344}, // 4719K
			{0.353465096, 0.358129394}, // 4720K
			{0.353433391, 0.358105354}, // 4721K
			{0.353401701, 0.35808132}, // 4722K
			{0.353370024, 0.358057291}, // 4723K
			{0.353338362, 0.358033267}, // 4724K
			{0.353306713, 0.358009249}, // 4725K
			{0.353275079, 0.357985237}, // 4726K
			{0.353243458, 0.357961229}, // 4727K
			{0.353211851, 0.357937228}, // 4728K
			{0.353180258, 0.357913231}, // 4729K
			{0.353148679, 0.35788924}, // 4730K
			{0.353117114, 0.357865255}, // 4731K
			{0.353085563, 0.357841275}, // 4732K
			{0.353054025, 0.357817301}, // 4733K
			{0.353022502, 0.357793332}, // 4734K
			{0.352990992, 0.357769368}, // 4735K
			{0.352959497, 0.35774541}, // 4736K
			{0.352928015, 0.357721457}, // 4737K
			{0.352896546, 0.35769751}, // 4738K
			{0.352865092, 0.357673568}, // 4739K
			{0.352833652, 0.357649632}, // 4740K
			{0.352802225, 0.357625701}, // 4741K
			{0.352770812, 0.357601776}, // 4742K
			{0.352739413, 0.357577856}, // 4743K
			{0.352708028, 0.357553941}, // 4744K
			{0.352676657, 0.357530032}, // 4745K
			{0.352645299, 0.357506129}, // 4746K
			{0.352613955, 0.357482231}, // 4747K
			{0.352582625, 0.357458338}, // 4748K
			{0.352551309, 0.357434451}, // 4749K
			{0.352520006, 0.357410569}, // 4750K
			{0.352488717, 0.357386693}, // 4751K
			{0.352457442, 0.357362823}, // 4752K
			{0.352426181, 0.357338957}, // 4753K
			{0.352394933, 0.357315098}, // 4754K
			{0.352363699, 0.357291243}, // 4755K
			{0.352332479, 0.357267394}, // 4756K
			{0.352301272, 0.357243551}, // 4757K
			{0.352270079, 0.357219713}, // 4758K
			{0.3522389, 0.357195881}, // 4759K
			{0.352207735, 0.357172054}, // 4760K
			{0.352176583, 0.357148232}, // 4761K
			{0.352145445, 0.357124416}, // 4762K
			{0.35211432, 0.357100606}, // 4763K
			{0.352083209, 0.357076801}, // 4764K
			{0.352052112, 0.357053001}, // 4765K
			{0.352021028, 0.357029207}, // 4766K
			{0.351989958, 0.357005418}, // 4767K
			{0.351958902, 0.356981635}, // 4768K
			{0.351927859, 0.356957857}, // 4769K
			{0.35189683, 0.356934085}, // 4770K
			{0.351865815, 0.356910318}, // 4771K
			{0.351834812, 0.356886557}, // 4772K
			{0.351803824, 0.356862801}, // 4773K
			{0.351772849, 0.356839051}, // 4774K
			{0.351741888, 0.356815306}, // 4775K
			{0.35171094, 0.356791567}, // 4776K
			{0.351680006, 0.356767833}, // 4777K
			{0.351649085, 0.356744105}, // 4778K
			{0.351618178, 0.356720382}, // 4779K
			{0.351587285, 0.356696664}, // 4780K
			{0.351556405, 0.356672952}, // 4781K
			{0.351525538, 0.356649246}, // 4782K
			{0.351494685, 0.356625545}, // 4783K
			{0.351463845, 0.356601849}, // 4784K
			{0.351433019, 0.356578159}, // 4785K
			{0.351402207, 0.356554475}, // 4786K
			{0.351371408, 0.356530796}, // 4787K
			{0.351340622, 0.356507122}, // 4788K
			{0.35130985, 0.356483454}, // 4789K
			{0.351279091, 0.356459792}, // 4790K
			{0.351248346, 0.356436134}, // 4791K
			{0.351217614, 0.356412483}, // 4792K
			{0.351186896, 0.356388837}, // 4793K
			{0.351156191, 0.356365196}, // 4794K
			{0.351125499, 0.356341561}, // 4795K
			{0.351094821, 0.356317931}, // 4796K
			{0.351064156, 0.356294307}, // 4797K
			{0.351033505, 0.356270688}, // 4798K
			{0.351002867, 0.356247075}, // 4799K
			{0.350972242, 0.356223468}, // 4800K
			{0.350941631, 0.356199865}, // 4801K
			{0.350911033, 0.356176269}, // 4802K
			{0.350880448, 0.356152677}, // 4803K
			{0.350849877, 0.356129092}, // 4804K
			{0.35081932, 0.356105511}, // 4805K
			{0.350788775, 0.356081937}, // 4806K
			{0.350758244, 0.356058367}, // 4807K
			{0.350727726, 0.356034804}, // 4808K
			{0.350697222, 0.356011245}, // 4809K
			{0.35066673, 0.355987692}, // 4810K
			{0.350636252, 0.355964145}, // 4811K
			{0.350605788, 0.355940603}, // 4812K
			{0.350575336, 0.355917067}, // 4813K
			{0.350544898, 0.355893536}, // 4814K
			{0.350514474, 0.355870011}, // 4815K
			{0.350484062, 0.355846491}, // 4816K
			{0.350453664, 0.355822977}, // 4817K
			{0.350423279, 0.355799468}, // 4818K
			{0.350392907, 0.355775965}, // 4819K
			{0.350362548, 0.355752467}, // 4820K
			{0.350332203, 0.355728975}, // 4821K
			{0.350301871, 0.355705488}, // 4822K
			{0.350271552, 0.355682006}, // 4823K
			{0.350241247, 0.355658531}, // 4824K
			{0.350210954, 0.35563506}, // 4825K
			{0.350180675, 0.355611595}, // 4826K
			{0.350150409, 0.355588136}, // 4827K
			{0.350120156, 0.355564682}, // 4828K
			{0.350089916, 0.355541234}, // 4829K
			{0.350059689, 0.355517791}, // 4830K
			{0.350029476, 0.355494354}, // 4831K
			{0.349999276, 0.355470922}, // 4832K
			{0.349969088, 0.355447495}, // 4833K
			{0.349938914, 0.355424075}, // 4834K
			{0.349908754, 0.355400659}, // 4835K
			{0.349878606, 0.355377249}, // 4836K
			{0.349848471, 0.355353845}, // 4837K
			{0.34981835, 0.355330446}, // 4838K
			{0.349788241, 0.355307053}, // 4839K
			{0.349758146, 0.355283665}, // 4840K
			{0.349728064, 0.355260283}, // 4841K
			{0.349697994, 0.355236906}, // 4842K
			{0.349667938, 0.355213535}, // 4843K
			{0.349637895, 0.355190169}, // 4844K
			{0.349607865, 0.355166808}, // 4845K
			{0.349577848, 0.355143454}, // 4846K
			{0.349547844, 0.355120104}, // 4847K
			{0.349517853, 0.355096761}, // 4848K
			{0.349487876, 0.355073422}, // 4849K
			{0.349457911, 0.35505009}, // 4850K
			{0.349427959, 0.355026762}, // 4851K
			{0.34939802, 0.35500344}, // 4852K
			{0.349368094, 0.354980124}, // 4853K
			{0.349338181, 0.354956813}, // 4854K
			{0.349308282, 0.354933508}, // 4855K
			{0.349278395, 0.354910208}, // 4856K
			{0.349248521, 0.354886914}, // 4857K
			{0.34921866, 0.354863625}, // 4858K
			{0.349188812, 0.354840342}, // 4859K
			{0.349158977, 0.354817064}, // 4860K
			{0.349129155, 0.354793792}, // 4861K
			{0.349099346, 0.354770526}, // 4862K
			{0.349069549, 0.354747264}, // 4863K
			{0.349039766, 0.354724009}, // 4864K
			{0.349009996, 0.354700758}, // 4865K
			{0.348980238, 0.354677514}, // 4866K
			{0.348950494, 0.354654275}, // 4867K
			{0.348920762, 0.354631041}, // 4868K
			{0.348891043, 0.354607813}, // 4869K
			{0.348861337, 0.35458459}, // 4870K
			{0.348831644, 0.354561373}, // 4871K
			{0.348801964, 0.354538161}, // 4872K
			{0.348772297, 0.354514955}, // 4873K
			{0.348742642, 0.354491755}, // 4874K
			{0.348713001, 0.35446856}, // 4875K
			{0.348683372, 0.35444537}, // 4876K
			{0.348653756, 0.354422186}, // 4877K
			{0.348624153, 0.354399007}, // 4878K
			{0.348594562, 0.354375834}, // 4879K
			{0.348564985, 0.354352667}, // 4880K
			{0.34853542, 0.354329505}, // 4881K
			{0.348505868, 0.354306348}, // 4882K
			{0.348476329, 0.354283197}, // 4883K
			{0.348446803, 0.354260052}, // 4884K
			{0.348417289, 0.354236912}, // 4885K
			{0.348387789, 0.354213777}, // 4886K
			{0.348358301, 0.354190648}, // 4887K
			{0.348328825, 0.354167525}, // 4888K
			{0.348299363, 0.354144407}, // 4889K
			{0.348269913, 0.354121294}, // 4890K
			{0.348240476, 0.354098188}, // 4891K
			{0.348211052, 0.354075086}, // 4892K
			{0.34818164, 0.35405199}, // 4893K
			{0.348152241, 0.3540289}, // 4894K
			{0.348122855, 0.354005815}, // 4895K
			{0.348093481, 0.353982736}, // 4896K
			{0.348064121, 0.353959662}, // 4897K
			{0.348034772, 0.353936593}, // 4898K
			{0.348005437, 0.353913531}, // 4899K
			{0.347976114, 0.353890473}, // 4900K
			{0.347946804, 0.353867421}, // 4901K
			{0.347917507, 0.353844375}, // 4902K
			{0.347888222, 0.353821334}, // 4903K
			{0.34785895, 0.353798299}, // 4904K
			{0.34782969, 0.353775269}, // 4905K
			{0.347800443, 0.353752245}, // 4906K
			{0.347771209, 0.353729226}, // 4907K
			{0.347741988, 0.353706213}, // 4908K
			{0.347712778, 0.353683206}, // 4909K
			{0.347683582, 0.353660203}, // 4910K
			{0.347654398, 0.353637207}, // 4911K
			{0.347625227, 0.353614216}, // 4912K
			{0.347596068, 0.35359123}, // 4913K
			{0.347566922, 0.35356825}, // 4914K
			{0.347537789, 0.353545275}, // 4915K
			{0.347508668, 0.353522306}, // 4916K
			{0.347479559, 0.353499342}, // 4917K
			{0.347450464, 0.353476384}, // 4918K
			{0.34742138, 0.353453432}, // 4919K
			{0.347392309, 0.353430485}, // 4920K
			{0.347363251, 0.353407543}, // 4921K
			{0.347334206, 0.353384607}, // 4922K
			{0.347305172, 0.353361677}, // 4923K
			{0.347276152, 0.353338752}, // 4924K
			{0.347247143, 0.353315832}, // 4925K
			{0.347218148, 0.353292918}, // 4926K
			{0.347189164, 0.35327001}, // 4927K
			{0.347160194, 0.353247107}, // 4928K
			{0.347131235, 0.353224209}, // 4929K
			{0.34710229, 0.353201317}, // 4930K
			{0.347073356, 0.353178431}, // 4931K
			{0.347044435, 0.35315555}, // 4932K
			{0.347015527, 0.353132675}, // 4933K
			{0.346986631, 0.353109805}, // 4934K
			{0.346957747, 0.35308694}, // 4935K
			{0.346928876, 0.353064082}, // 4936K
			{0.346900018, 0.353041228}, // 4937K
			{0.346871171, 0.35301838}, // 4938K
			{0.346842337, 0.352995538}, // 4939K
			{0.346813516, 0.352972701}, // 4940K
			{0.346784707, 0.35294987}, // 4941K
			{0.34675591, 0.352927044}, // 4942K
			{0.346727126, 0.352904224}, // 4943K
			{0.346698354, 0.352881409}, // 4944K
			{0.346669594, 0.3528586}, // 4945K
			{0.346640847, 0.352835796}, // 4946K
			{0.346612112, 0.352812998}, // 4947K
			{0.34658339, 0.352790205}, // 4948K
			{0.346554679, 0.352767418}, // 4949K
			{0.346525982, 0.352744637}, // 4950K
			{0.346497296, 0.35272186}, // 4951K
			{0.346468623, 0.35269909}, // 4952K
			{0.346439962, 0.352676325}, // 4953K
			{0.346411313, 0.352653565}, // 4954K
			{0.346382677, 0.352630811}, // 4955K
			{0.346354053, 0.352608062}, // 4956K
			{0.346325441, 0.352585319}, // 4957K
			{0.346296842, 0.352562582}, // 4958K
			{0.346268255, 0.35253985}, // 4959K
			{0.34623968, 0.352517123}, // 4960K
			{0.346211117, 0.352494402}, // 4961K
			{0.346182567, 0.352471687}, // 4962K
			{0.346154029, 0.352448977}, // 4963K
			{0.346125503, 0.352426272}, // 4964K
			{0.346096989, 0.352403573}, // 4965K
			{0.346068488, 0.35238088}, // 4966K
			{0.346039998, 0.352358192}, // 4967K
			{0.346011521, 0.352335509}, // 4968K
			{0.345983057, 0.352312832}, // 4969K
			{0.345954604, 0.352290161}, // 4970K
			{0.345926163, 0.352267495}, // 4971K
			{0.345897735, 0.352244834}, // 4972K
			{0.345869319, 0.35222218}, // 4973K
			{0.345840915, 0.35219953}, // 4974K
			{0.345812524, 0.352176886}, // 4975K
			{0.345784144, 0.352154248}, // 4976K
			{0.345755777, 0.352131615}, // 4977K
			{0.345727422, 0.352108988}, // 4978K
			{0.345699078, 0.352086366}, // 4979K
			{0.345670747, 0.352063749}, // 4980K
			{0.345642429, 0.352041139}, // 4981K
			{0.345614122, 0.352018533}, // 4982K
			{0.345585827, 0.351995934}, // 4983K
			{0.345557545, 0.351973339}, // 4984K
			{0.345529274, 0.35195075}, // 4985K
			{0.345501016, 0.351928167}, // 4986K
			{0.34547277, 0.351905589}, // 4987K
			{0.345444536, 0.351883017}, // 4988K
			{0.345416314, 0.35186045}, // 4989K
			{0.345388104, 0.351837889}, // 4990K
			{0.345359906, 0.351815333}, // 4991K
			{0.34533172, 0.351792783}, // 4992K
			{0.345303546, 0.351770238}, // 4993K
			{0.345275385, 0.351747699}, // 4994K
			{0.345247235, 0.351725165}, // 4995K
			{0.345219097, 0.351702637}, // 4996K
			{0.345190971, 0.351680114}, // 4997K
			{0.345162858, 0.351657597}, // 4998K
			{0.345134756, 0.351635086}, // 4999K
			{0.345106666, 0.351612579}, // 5000K
			{0.345078589, 0.351590079}, // 5001K
			{0.345050523, 0.351567583}, // 5002K
			{0.34502247, 0.351545094}, // 5003K
			{0.344994428, 0.35152261}, // 5004K
			{0.344966398, 0.351500131}, // 5005K
			{0.34493838, 0.351477658}, // 5006K
			{0.344910375, 0.35145519}, // 5007K
			{0.344882381, 0.351432728}, // 5008K
			{0.344854399, 0.351410271}, // 5009K
			{0.344826429, 0.35138782}, // 5010K
			{0.344798471, 0.351365375}, // 5011K
			{0.344770525, 0.351342934}, // 5012K
			{0.344742591, 0.3513205}, // 5013K
			{0.344714668, 0.351298071}, // 5014K
			{0.344686758, 0.351275647}, // 5015K
			{0.34465886, 0.351253229}, // 5016K
			{0.344630973, 0.351230816}, // 5017K
			{0.344603098, 0.351208409}, // 5018K
			{0.344575236, 0.351186007}, // 5019K
			{0.344547385, 0.351163611}, // 5020K
			{0.344519546, 0.351141221}, // 5021K
			{0.344491718, 0.351118836}, // 5022K
			{0.344463903, 0.351096456}, // 5023K
			{0.3444361, 0.351074082}, // 5024K
			{0.344408308, 0.351051713}, // 5025K
			{0.344380528, 0.35102935}, // 5026K
			{0.34435276, 0.351006992}, // 5027K
			{0.344325004, 0.35098464}, // 5028K
			{0.34429726, 0.350962294}, // 5029K
			{0.344269527, 0.350939953}, // 5030K
			{0.344241807, 0.350917617}, // 5031K
			{0.344214098, 0.350895287}, // 5032K
			{0.344186401, 0.350872962}, // 5033K
			{0.344158715, 0.350850643}, // 5034K
			{0.344131042, 0.350828329}, // 5035K
			{0.34410338, 0.350806021}, // 5036K
			{0.34407573, 0.350783719}, // 5037K
			{0.344048092, 0.350761421}, // 5038K
			{0.344020465, 0.35073913}, // 5039K
			{0.343992851, 0.350716844}, // 5040K
			{0.343965248, 0.350694563}, // 5041K
			{0.343937656, 0.350672288}, // 5042K
			{0.343910077, 0.350650018}, // 5043K
			{0.343882509, 0.350627754}, // 5044K
			{0.343854953, 0.350605495}, // 5045K
			{0.343827409, 0.350583242}, // 5046K
			{0.343799876, 0.350560994}, // 5047K
			{0.343772355, 0.350538752}, // 5048K
			{0.343744846, 0.350516516}, // 5049K
			{0.343717348, 0.350494284}, // 5050K
			{0.343689862, 0.350472059}, // 5051K
			{0.343662388, 0.350449838}, // 5052K
			{0.343634925, 0.350427624}, // 5053K
			{0.343607474, 0.350405414}, // 5054K
			{0.343580035, 0.350383211}, // 5055K
			{0.343552608, 0.350361012}, // 5056K
			{0.343525192, 0.35033882}, // 5057K
			{0.343497787, 0.350316632}, // 5058K
			{0.343470395, 0.350294451}, // 5059K
			{0.343443013, 0.350272274}, // 5060K
			{0.343415644, 0.350250103}, // 5061K
			{0.343388286, 0.350227938}, // 5062K
			{0.34336094, 0.350205778}, // 5063K
			{0.343333605, 0.350183624}, // 5064K
			{0.343306282, 0.350161475}, // 5065K
			{0.343278971, 0.350139332}, // 5066K
			{0.343251671, 0.350117194}, // 5067K
			{0.343224382, 0.350095061}, // 5068K
			{0.343197106, 0.350072934}, // 5069K
			{0.343169841, 0.350050813}, // 5070K
			{0.343142587, 0.350028697}, // 5071K
			{0.343115345, 0.350006587}, // 5072K
			{0.343088114, 0.349984482}, // 5073K
			{0.343060895, 0.349962382}, // 5074K
			{0.343033688, 0.349940288}, // 5075K
			{0.343006492, 0.3499182}, // 5076K
			{0.342979307, 0.349896117}, // 5077K
			{0.342952134, 0.349874039}, // 5078K
			{0.342924973, 0.349851967}, // 5079K
			{0.342897823, 0.3498299}, // 5080K
			{0.342870685, 0.349807839}, // 5081K
			{0.342843558, 0.349785784}, // 5082K
			{0.342816442, 0.349763734}, // 5083K
			{0.342789338, 0.349741689}, // 5084K
			{0.342762246, 0.34971965}, // 5085K
			{0.342735165, 0.349697616}, // 5086K
			{0.342708095, 0.349675588}, // 5087K
			{0.342681037, 0.349653565}, // 5088K
			{0.34265399, 0.349631548}, // 5089K
			{0.342626955, 0.349609536}, // 5090K
			{0.342599931, 0.34958753}, // 5091K
			{0.342572918, 0.349565529}, // 5092K
			{0.342545917, 0.349543534}, // 5093K
			{0.342518928, 0.349521544}, // 5094K
			{0.34249195, 0.349499559}, // 5095K
			{0.342464983, 0.34947758}, // 5096K
			{0.342438027, 0.349455607}, // 5097K
			{0.342411083, 0.349433639}, // 5098K
			{0.342384151, 0.349411677}, // 5099K
			{0.34235723, 0.34938972}, // 5100K
			{0.34233032, 0.349367768}, // 5101K
			{0.342303421, 0.349345822}, // 5102K
			{0.342276534, 0.349323881}, // 5103K
			{0.342249658, 0.349301946}, // 5104K
			{0.342222794, 0.349280017}, // 5105K
			{0.342195941, 0.349258092}, // 5106K
			{0.342169099, 0.349236174}, // 5107K
			{0.342142268, 0.34921426}, // 5108K
			{0.342115449, 0.349192353}, // 5109K
			{0.342088641, 0.34917045}, // 5110K
			{0.342061845, 0.349148554}, // 5111K
			{0.34203506, 0.349126662}, // 5112K
			{0.342008286, 0.349104776}, // 5113K
			{0.341981523, 0.349082896}, // 5114K
			{0.341954772, 0.349061021}, // 5115K
			{0.341928032, 0.349039152}, // 5116K
			{0.341901303, 0.349017287}, // 5117K
			{0.341874585, 0.348995429}, // 5118K
			{0.341847879, 0.348973576}, // 5119K
			{0.341821184, 0.348951728}, // 5120K
			{0.3417945, 0.348929886}, // 5121K
			{0.341767828, 0.348908049}, // 5122K
			{0.341741166, 0.348886218}, // 5123K
			{0.341714516, 0.348864392}, // 5124K
			{0.341687878, 0.348842572}, // 5125K
			{0.34166125, 0.348820757}, // 5126K
			{0.341634634, 0.348798948}, // 5127K
			{0.341608028, 0.348777144}, // 5128K
			{0.341581434, 0.348755346}, // 5129K
			{0.341554852, 0.348733553}, // 5130K
			{0.34152828, 0.348711765}, // 5131K
			{0.34150172, 0.348689983}, // 5132K
			{0.34147517, 0.348668206}, // 5133K
			{0.341448632, 0.348646435}, // 5134K
			{0.341422105, 0.34862467}, // 5135K
			{0.34139559, 0.348602909}, // 5136K
			{0.341369085, 0.348581155}, // 5137K
			{0.341342591, 0.348559405}, // 5138K
			{0.341316109, 0.348537661}, // 5139K
			{0.341289638, 0.348515923}, // 5140K
			{0.341263178, 0.34849419}, // 5141K
			{0.341236729, 0.348472463}, // 5142K
			{0.341210291, 0.348450741}, // 5143K
			{0.341183864, 0.348429024}, // 5144K
			{0.341157449, 0.348407313}, // 5145K
			{0.341131044, 0.348385607}, // 5146K
			{0.341104651, 0.348363907}, // 5147K
			{0.341078269, 0.348342212}, // 5148K
			{0.341051897, 0.348320523}, // 5149K
			{0.341025537, 0.348298839}, // 5150K
			{0.340999188, 0.348277161}, // 5151K
			{0.34097285, 0.348255488}, // 5152K
			{0.340946523, 0.34823382}, // 5153K
			{0.340920207, 0.348212158}, // 5154K
			{0.340893902, 0.348190502}, // 5155K
			{0.340867609, 0.34816885}, // 5156K
			{0.340841326, 0.348147205}, // 5157K
			{0.340815054, 0.348125564}, // 5158K
			{0.340788793, 0.34810393}, // 5159K
			{0.340762544, 0.3480823}, // 5160K
			{0.340736305, 0.348060676}, // 5161K
			{0.340710077, 0.348039058}, // 5162K
			{0.34068386, 0.348017445}, // 5163K
			{0.340657655, 0.347995837}, // 5164K
			{0.34063146, 0.347974235}, // 5165K
			{0.340605276, 0.347952638}, // 5166K
			{0.340579103, 0.347931047}, // 5167K
			{0.340552942, 0.347909461}, // 5168K
			{0.340526791, 0.347887881}, // 5169K
			{0.340500651, 0.347866306}, // 5170K
			{0.340474522, 0.347844736}, // 5171K
			{0.340448404, 0.347823172}, // 5172K
			{0.340422297, 0.347801614}, // 5173K
			{0.340396201, 0.347780061}, // 5174K
			{0.340370116, 0.347758513}, // 5175K
			{0.340344041, 0.34773697}, // 5176K
			{0.340317978, 0.347715434}, // 5177K
			{0.340291926, 0.347693902}, // 5178K
			{0.340265884, 0.347672376}, // 5179K
			{0.340239853, 0.347650856}, // 5180K
			{0.340213834, 0.34762934}, // 5181K
			{0.340187825, 0.347607831}, // 5182K
			{0.340161827, 0.347586326}, // 5183K
			{0.34013584, 0.347564828}, // 5184K
			{0.340109864, 0.347543334}, // 5185K
			{0.340083898, 0.347521846}, // 5186K
			{0.340057944, 0.347500364}, // 5187K
			{0.340032, 0.347478887}, // 5188K
			{0.340006067, 0.347457415}, // 5189K
			{0.339980145, 0.347435949}, // 5190K
			{0.339954234, 0.347414488}, // 5191K
			{0.339928334, 0.347393033}, // 5192K
			{0.339902444, 0.347371583}, // 5193K
			{0.339876566, 0.347350138}, // 5194K
			{0.339850698, 0.347328699}, // 5195K
			{0.339824841, 0.347307265}, // 5196K
			{0.339798995, 0.347285837}, // 5197K
			{0.339773159, 0.347264414}, // 5198K
			{0.339747335, 0.347242997}, // 5199K
			{0.339721521, 0.347221585}, // 5200K
			{0.339695718, 0.347200178}, // 5201K
			{0.339669925, 0.347178777}, // 5202K
			{0.339644144, 0.347157381}, // 5203K
			{0.339618373, 0.347135991}, // 5204K
			{0.339592613, 0.347114606}, // 5205K
			{0.339566864, 0.347093227}, // 5206K
			{0.339541125, 0.347071853}, // 5207K
			{0.339515398, 0.347050484}, // 5208K
			{0.339489681, 0.347029121}, // 5209K
			{0.339463974, 0.347007763}, // 5210K
			{0.339438279, 0.346986411}, // 5211K
			{0.339412594, 0.346965064}, // 5212K
			{0.33938692, 0.346943722}, // 5213K
			{0.339361256, 0.346922386}, // 5214K
			{0.339335603, 0.346901055}, // 5215K
			{0.339309961, 0.34687973}, // 5216K
			{0.33928433, 0.34685841}, // 5217K
			{0.339258709, 0.346837096}, // 5218K
			{0.339233099, 0.346815787}, // 5219K
			{0.3392075, 0.346794483}, // 5220K
			{0.339181911, 0.346773185}, // 5221K
			{0.339156333, 0.346751892}, // 5222K
			{0.339130765, 0.346730605}, // 5223K
			{0.339105209, 0.346709322}, // 5224K
			{0.339079663, 0.346688046}, // 5225K
			{0.339054127, 0.346666775}, // 5226K
			{0.339028602, 0.346645509}, // 5227K
			{0.339003088, 0.346624249}, // 5228K
			{0.338977584, 0.346602994}, // 5229K
			{0.338952092, 0.346581744}, // 5230K
			{0.338926609, 0.3465605}, // 5231K
			{0.338901137, 0.346539261}, // 5232K
			{0.338875676, 0.346518028}, // 5233K
			{0.338850226, 0.3464968}, // 5234K
			{0.338824786, 0.346475577}, // 5235K
			{0.338799356, 0.34645436}, // 5236K
			{0.338773937, 0.346433148}, // 5237K
			{0.338748529, 0.346411942}, // 5238K
			{0.338723131, 0.346390741}, // 5239K
			{0.338697744, 0.346369545}, // 5240K
			{0.338672368, 0.346348355}, // 5241K
			{0.338647001, 0.34632717}, // 5242K
			{0.338621646, 0.346305991}, // 5243K
			{0.338596301, 0.346284817}, // 5244K
			{0.338570966, 0.346263649}, // 5245K
			{0.338545643, 0.346242485}, // 5246K
			{0.338520329, 0.346221328}, // 5247K
			{0.338495026, 0.346200175}, // 5248K
			{0.338469734, 0.346179028}, // 5249K
			{0.338444452, 0.346157887}, // 5250K
			{0.338419181, 0.34613675}, // 5251K
			{0.33839392, 0.34611562}, // 5252K
			{0.338368669, 0.346094494}, // 5253K
			{0.338343429, 0.346073374}, // 5254K
			{0.3383182, 0.346052259}, // 5255K
			{0.338292981, 0.34603115}, // 5256K
			{0.338267772, 0.346010046}, // 5257K
			{0.338242574, 0.345988948}, // 5258K
			{0.338217386, 0.345967855}, // 5259K
			{0.338192209, 0.345946767}, // 5260K
			{0.338167043, 0.345925685}, // 5261K
			{0.338141886, 0.345904608}, // 5262K
			{0.33811674, 0.345883536}, // 5263K
			{0.338091605, 0.34586247}, // 5264K
			{0.33806648, 0.345841409}, // 5265K
			{0.338041365, 0.345820353}, // 5266K
			{0.338016261, 0.345799303}, // 5267K
			{0.337991167, 0.345778259}, // 5268K
			{0.337966084, 0.345757219}, // 5269K
			{0.337941011, 0.345736186}, // 5270K
			{0.337915948, 0.345715157}, // 5271K
			{0.337890896, 0.345694134}, // 5272K
			{0.337865854, 0.345673116}, // 5273K
			{0.337840822, 0.345652104}, // 5274K
			{0.337815801, 0.345631097}, // 5275K
			{0.33779079, 0.345610095}, // 5276K
			{0.33776579, 0.345589099}, // 5277K
			{0.3377408, 0.345568108}, // 5278K
			{0.33771582, 0.345547122}, // 5279K
			{0.33769085, 0.345526142}, // 5280K
			{0.337665891, 0.345505167}, // 5281K
			{0.337640943, 0.345484198}, // 5282K
			{0.337616004, 0.345463234}, // 5283K
			{0.337591076, 0.345442275}, // 5284K
			{0.337566158, 0.345421321}, // 5285K
			{0.337541251, 0.345400373}, // 5286K
			{0.337516353, 0.345379431}, // 5287K
			{0.337491466, 0.345358494}, // 5288K
			{0.33746659, 0.345337562}, // 5289K
			{0.337441723, 0.345316635}, // 5290K
			{0.337416867, 0.345295714}, // 5291K
			{0.337392021, 0.345274798}, // 5292K
			{0.337367186, 0.345253888}, // 5293K
			{0.33734236, 0.345232983}, // 5294K
			{0.337317545, 0.345212083}, // 5295K
			{0.337292741, 0.345191189}, // 5296K
			{0.337267946, 0.3451703}, // 5297K
			{0.337243162, 0.345149416}, // 5298K
			{0.337218388, 0.345128538}, // 5299K
			{0.337193624, 0.345107665}, // 5300K
			{0.33716887, 0.345086797}, // 5301K
			{0.337144127, 0.345065935}, // 5302K
			{0.337119393, 0.345045078}, // 5303K
			{0.33709467, 0.345024227}, // 5304K
			{0.337069958, 0.34500338}, // 5305K
			{0.337045255, 0.34498254}, // 5306K
			{0.337020562, 0.344961704}, // 5307K
			{0.33699588, 0.344940874}, // 5308K
			{0.336971208, 0.344920049}, // 5309K
			{0.336946546, 0.34489923}, // 5310K
			{0.336921894, 0.344878416}, // 5311K
			{0.336897253, 0.344857607}, // 5312K
			{0.336872621, 0.344836804}, // 5313K
			{0.336848, 0.344816006}, // 5314K
			{0.336823389, 0.344795213}, // 5315K
			{0.336798788, 0.344774426}, // 5316K
			{0.336774197, 0.344753644}, // 5317K
			{0.336749617, 0.344732867}, // 5318K
			{0.336725046, 0.344712096}, // 5319K
			{0.336700485, 0.34469133}, // 5320K
			{0.336675935, 0.344670569}, // 5321K
			{0.336651395, 0.344649814}, // 5322K
			{0.336626865, 0.344629064}, // 5323K
			{0.336602345, 0.344608319}, // 5324K
			{0.336577835, 0.34458758}, // 5325K
			{0.336553335, 0.344566846}, // 5326K
			{0.336528845, 0.344546117}, // 5327K
			{0.336504365, 0.344525394}, // 5328K
			{0.336479896, 0.344504676}, // 5329K
			{0.336455436, 0.344483964}, // 5330K
			{0.336430987, 0.344463256}, // 5331K
			{0.336406547, 0.344442554}, // 5332K
			{0.336382118, 0.344421858}, // 5333K
			{0.336357698, 0.344401166}, // 5334K
			{0.336333289, 0.34438048}, // 5335K
			{0.33630889, 0.3443598}, // 5336K
			{0.336284501, 0.344339125}, // 5337K
			{0.336260121, 0.344318455}, // 5338K
			{0.336235752, 0.34429779}, // 5339K
			{0.336211393, 0.344277131}, // 5340K
			{0.336187044, 0.344256477}, // 5341K
			{0.336162704, 0.344235828}, // 5342K
			{0.336138375, 0.344215185}, // 5343K
			{0.336114056, 0.344194547}, // 5344K
			{0.336089747, 0.344173914}, // 5345K
			{0.336065448, 0.344153286}, // 5346K
			{0.336041158, 0.344132664}, // 5347K
			{0.336016879, 0.344112048}, // 5348K
			{0.33599261, 0.344091436}, // 5349K
			{0.33596835, 0.34407083}, // 5350K
			{0.335944101, 0.344050229}, // 5351K
			{0.335919861, 0.344029634}, // 5352K
			{0.335895632, 0.344009044}, // 5353K
			{0.335871412, 0.343988459}, // 5354K
			{0.335847203, 0.343967879}, // 5355K
			{0.335823003, 0.343947305}, // 5356K
			{0.335798813, 0.343926736}, // 5357K
			{0.335774633, 0.343906172}, // 5358K
			{0.335750463, 0.343885614}, // 5359K
			{0.335726303, 0.343865061}, // 5360K
			{0.335702153, 0.343844513}, // 5361K
			{0.335678013, 0.343823971}, // 5362K
			{0.335653883, 0.343803434}, // 5363K
			{0.335629762, 0.343782902}, // 5364K
			{0.335605651, 0.343762376}, // 5365K
			{0.335581551, 0.343741855}, // 5366K
			{0.33555746, 0.343721339}, // 5367K
			{0.335533379, 0.343700828}, // 5368K
			{0.335509308, 0.343680323}, // 5369K
			{0.335485247, 0.343659823}, // 5370K
			{0.335461195, 0.343639328}, // 5371K
			{0.335437154, 0.343618839}, // 5372K
			{0.335413122, 0.343598355}, // 5373K
			{0.3353891, 0.343577876}, // 5374K
			{0.335365088, 0.343557403}, // 5375K
			{0.335341086, 0.343536934}, // 5376K
			{0.335317093, 0.343516472}, // 5377K
			{0.335293111, 0.343496014}, // 5378K
			{0.335269138, 0.343475562}, // 5379K
			{0.335245175, 0.343455115}, // 5380K
			{0.335221222, 0.343434673}, // 5381K
			{0.335197278, 0.343414237}, // 5382K
			{0.335173345, 0.343393805}, // 5383K
			{0.335149421, 0.34337338}, // 5384K
			{0.335125507, 0.343352959}, // 5385K
			{0.335101603, 0.343332544}, // 5386K
			{0.335077708, 0.343312134}, // 5387K
			{0.335053823, 0.343291729}, // 5388K
			{0.335029948, 0.34327133}, // 5389K
			{0.335006083, 0.343250936}, // 5390K
			{0.334982228, 0.343230547}, // 5391K
			{0.334958382, 0.343210163}, // 5392K
			{0.334934546, 0.343189785}, // 5393K
			{0.33491072, 0.343169412}, // 5394K
			{0.334886903, 0.343149044}, // 5395K
			{0.334863096, 0.343128682}, // 5396K
			{0.334839299, 0.343108325}, // 5397K
			{0.334815512, 0.343087973}, // 5398K
			{0.334791734, 0.343067626}, // 5399K
			{0.334767966, 0.343047285}, // 5400K
			{0.334744208, 0.343026949}, // 5401K
			{0.334720459, 0.343006618}, // 5402K
			{0.334696721, 0.342986292}, // 5403K
			{0.334672991, 0.342965972}, // 5404K
			{0.334649272, 0.342945657}, // 5405K
			{0.334625562, 0.342925348}, // 5406K
			{0.334601862, 0.342905043}, // 5407K
			{0.334578171, 0.342884744}, // 5408K
			{0.33455449, 0.34286445}, // 5409K
			{0.334530819, 0.342844161}, // 5410K
			{0.334507157, 0.342823878}, // 5411K
			{0.334483505, 0.3428036}, // 5412K
			{0.334459863, 0.342783327}, // 5413K
			{0.33443623, 0.342763059}, // 5414K
			{0.334412607, 0.342742797}, // 5415K
			{0.334388994, 0.34272254}, // 5416K
			{0.33436539, 0.342702288}, // 5417K
			{0.334341796, 0.342682042}, // 5418K
			{0.334318211, 0.3426618}, // 5419K
			{0.334294636, 0.342641564}, // 5420K
			{0.334271071, 0.342621334}, // 5421K
			{0.334247515, 0.342601108}, // 5422K
			{0.334223969, 0.342580888}, // 5423K
			{0.334200432, 0.342560673}, // 5424K
			{0.334176905, 0.342540463}, // 5425K
			{0.334153388, 0.342520259}, // 5426K
			{0.33412988, 0.342500059}, // 5427K
			{0.334106381, 0.342479865}, // 5428K
			{0.334082893, 0.342459677}, // 5429K
			{0.334059413, 0.342439493}, // 5430K
			{0.334035944, 0.342419315}, // 5431K
			{0.334012483, 0.342399142}, // 5432K
			{0.333989033, 0.342378974}, // 5433K
			{0.333965592, 0.342358812}, // 5434K
			{0.33394216, 0.342338654}, // 5435K
			{0.333918738, 0.342318502}, // 5436K
			{0.333895325, 0.342298356}, // 5437K
			{0.333871922, 0.342278214}, // 5438K
			{0.333848529, 0.342258078}, // 5439K
			{0.333825145, 0.342237947}, // 5440K
			{0.33380177, 0.342217821}, // 5441K
			{0.333778405, 0.3421977}, // 5442K
			{0.33375505, 0.342177585}, // 5443K
			{0.333731703, 0.342157475}, // 5444K
			{0.333708367, 0.34213737}, // 5445K
			{0.33368504, 0.34211727}, // 5446K
			{0.333661722, 0.342097176}, // 5447K
			{0.333638414, 0.342077087}, // 5448K
			{0.333615115, 0.342057003}, // 5449K
			{0.333591826, 0.342036924}, // 5450K
			{0.333568546, 0.342016851}, // 5451K
			{0.333545275, 0.341996782}, // 5452K
			{0.333522014, 0.341976719}, // 5453K
			{0.333498763, 0.341956661}, // 5454K
			{0.333475521, 0.341936609}, // 5455K
			{0.333452288, 0.341916561}, // 5456K
			{0.333429065, 0.341896519}, // 5457K
			{0.333405851, 0.341876482}, // 5458K
			{0.333382646, 0.341856451}, // 5459K
			{0.333359451, 0.341836424}, // 5460K
			{0.333336266, 0.341816403}, // 5461K
			{0.333313089, 0.341796387}, // 5462K
			{0.333289923, 0.341776376}, // 5463K
			{0.333266765, 0.341756371}, // 5464K
			{0.333243617, 0.34173637}, // 5465K
			{0.333220478, 0.341716375}, // 5466K
			{0.333197349, 0.341696385}, // 5467K
			{0.333174229, 0.3416764}, // 5468K
			{0.333151118, 0.341656421}, // 5469K
			{0.333128017, 0.341636447}, // 5470K
			{0.333104925, 0.341616477}, // 5471K
			{0.333081842, 0.341596514}, // 5472K
			{0.333058769, 0.341576555}, // 5473K
			{0.333035705, 0.341556601}, // 5474K
			{0.33301265, 0.341536653}, // 5475K
			{0.332989605, 0.34151671}, // 5476K
			{0.332966569, 0.341496772}, // 5477K
			{0.332943542, 0.34147684}, // 5478K
			{0.332920525, 0.341456912}, // 5479K
			{0.332897517, 0.34143699}, // 5480K
			{0.332874518, 0.341417073}, // 5481K
			{0.332851529, 0.341397161}, // 5482K
			{0.332828548, 0.341377254}, // 5483K
			{0.332805578, 0.341357353}, // 5484K
			{0.332782616, 0.341337457}, // 5485K
			{0.332759664, 0.341317566}, // 5486K
			{0.332736721, 0.34129768}, // 5487K
			{0.332713787, 0.341277799}, // 5488K
			{0.332690862, 0.341257924}, // 5489K
			{0.332667947, 0.341238053}, // 5490K
			{0.332645041, 0.341218188}, // 5491K
			{0.332622144, 0.341198328}, // 5492K
			{0.332599257, 0.341178474}, // 5493K
			{0.332576378, 0.341158624}, // 5494K
			{0.332553509, 0.34113878}, // 5495K
			{0.332530649, 0.341118941}, // 5496K
			{0.332507799, 0.341099107}, // 5497K
			{0.332484957, 0.341079278}, // 5498K
			{0.332462125, 0.341059454}, // 5499K
			{0.332439302, 0.341039636}, // 5500K
			{0.332416488, 0.341019823}, // 5501K
			{0.332393684, 0.341000015}, // 5502K
			{0.332370888, 0.340980212}, // 5503K
			{0.332348102, 0.340960414}, // 5504K
			{0.332325325, 0.340940622}, // 5505K
			{0.332302557, 0.340920834}, // 5506K
			{0.332279799, 0.340901052}, // 5507K
			{0.332257049, 0.340881275}, // 5508K
			{0.332234309, 0.340861503}, // 5509K
			{0.332211578, 0.340841737}, // 5510K
			{0.332188855, 0.340821975}, // 5511K
			{0.332166143, 0.340802219}, // 5512K
			{0.332143439, 0.340782468}, // 5513K
			{0.332120744, 0.340762722}, // 5514K
			{0.332098059, 0.340742981}, // 5515K
			{0.332075383, 0.340723246}, // 5516K
			{0.332052715, 0.340703515}, // 5517K
			{0.332030057, 0.34068379}, // 5518K
			{0.332007408, 0.34066407}, // 5519K
			{0.331984768, 0.340644355}, // 5520K
			{0.331962138, 0.340624645}, // 5521K
			{0.331939516, 0.340604941}, // 5522K
			{0.331916904, 0.340585241}, // 5523K
			{0.3318943, 0.340565547}, // 5524K
			{0.331871706, 0.340545858}, // 5525K
			{0.331849121, 0.340526174}, // 5526K
			{0.331826544, 0.340506495}, // 5527K
			{0.331803977, 0.340486821}, // 5528K
			{0.331781419, 0.340467153}, // 5529K
			{0.33175887, 0.340447489}, // 5530K
			{0.33173633, 0.340427831}, // 5531K
			{0.331713799, 0.340408178}, // 5532K
			{0.331691278, 0.34038853}, // 5533K
			{0.331668765, 0.340368887}, // 5534K
			{0.331646261, 0.34034925}, // 5535K
			{0.331623766, 0.340329617}, // 5536K
			{0.331601281, 0.34030999}, // 5537K
			{0.331578804, 0.340290368}, // 5538K
			{0.331556337, 0.340270751}, // 5539K
			{0.331533878, 0.340251139}, // 5540K
			{0.331511428, 0.340231532}, // 5541K
			{0.331488988, 0.340211931}, // 5542K
			{0.331466556, 0.340192334}, // 5543K
			{0.331444134, 0.340172743}, // 5544K
			{0.33142172, 0.340153157}, // 5545K
			{0.331399316, 0.340133576}, // 5546K
			{0.33137692, 0.340114}, // 5547K
			{0.331354533, 0.340094429}, // 5548K
			{0.331332156, 0.340074863}, // 5549K
			{0.331309787, 0.340055303}, // 5550K
			{0.331287427, 0.340035748}, // 5551K
			{0.331265077, 0.340016197}, // 5552K
			{0.331242735, 0.339996652}, // 5553K
			{0.331220402, 0.339977112}, // 5554K
			{0.331198078, 0.339957577}, // 5555K
			{0.331175763, 0.339938048}, // 5556K
			{0.331153457, 0.339918523}, // 5557K
			{0.33113116, 0.339899004}, // 5558K
			{0.331108872, 0.339879489}, // 5559K
			{0.331086593, 0.33985998}, // 5560K
			{0.331064323, 0.339840476}, // 5561K
			{0.331042061, 0.339820977}, // 5562K
			{0.331019809, 0.339801483}, // 5563K
			{0.330997565, 0.339781995}, // 5564K
			{0.330975331, 0.339762511}, // 5565K
			{0.330953105, 0.339743033}, // 5566K
			{0.330930888, 0.339723559}, // 5567K
			{0.33090868, 0.339704091}, // 5568K
			{0.330886481, 0.339684628}, // 5569K
			{0.330864291, 0.33966517}, // 5570K
			{0.330842109, 0.339645717}, // 5571K
			{0.330819937, 0.339626269}, // 5572K
			{0.330797773, 0.339606826}, // 5573K
			{0.330775619, 0.339587389}, // 5574K
			{0.330753473, 0.339567956}, // 5575K
			{0.330731336, 0.339548529}, // 5576K
			{0.330709208, 0.339529107}, // 5577K
			{0.330687088, 0.33950969}, // 5578K
			{0.330664978, 0.339490278}, // 5579K
			{0.330642876, 0.339470871}, // 5580K
			{0.330620783, 0.339451469}, // 5581K
			{0.330598699, 0.339432072}, // 5582K
			{0.330576624, 0.33941268}, // 5583K
			{0.330554558, 0.339393294}, // 5584K
			{0.3305325, 0.339373912}, // 5585K
			{0.330510451, 0.339354536}, // 5586K
			{0.330488411, 0.339335165}, // 5587K
			{0.33046638, 0.339315799}, // 5588K
			{0.330444358, 0.339296438}, // 5589K
			{0.330422344, 0.339277082}, // 5590K
			{0.330400339, 0.339257731}, // 5591K
			{0.330378343, 0.339238385}, // 5592K
			{0.330356356, 0.339219044}, // 5593K
			{0.330334378, 0.339199709}, // 5594K
			{0.330312408, 0.339180378}, // 5595K
			{0.330290447, 0.339161053}, // 5596K
			{0.330268495, 0.339141732}, // 5597K
			{0.330246551, 0.339122417}, // 5598K
			{0.330224617, 0.339103107}, // 5599K
			{0.330202691, 0.339083802}, // 5600K
			{0.330180773, 0.339064502}, // 5601K
			{0.330158865, 0.339045207}, // 5602K
			{0.330136965, 0.339025917}, // 5603K
			{0.330115074, 0.339006632}, // 5604K
			{0.330093192, 0.338987353}, // 5605K
			{0.330071318, 0.338968078}, // 5606K
			{0.330049453, 0.338948809}, // 5607K
			{0.330027597, 0.338929544}, // 5608K
			{0.33000575, 0.338910285}, // 5609K
			{0.329983911, 0.33889103}, // 5610K
			{0.329962081, 0.338871781}, // 5611K
			{0.329940259, 0.338852537}, // 5612K
			{0.329918447, 0.338833298}, // 5613K
			{0.329896643, 0.338814064}, // 5614K
			{0.329874847, 0.338794835}, // 5615K
			{0.329853061, 0.338775611}, // 5616K
			{0.329831283, 0.338756392}, // 5617K
			{0.329809513, 0.338737178}, // 5618K
			{0.329787752, 0.33871797}, // 5619K
			{0.329766, 0.338698766}, // 5620K
			{0.329744257, 0.338679567}, // 5621K
			{0.329722522, 0.338660374}, // 5622K
			{0.329700796, 0.338641186}, // 5623K
			{0.329679079, 0.338622002}, // 5624K
			{0.32965737, 0.338602824}, // 5625K
			{0.329635669, 0.33858365}, // 5626K
			{0.329613978, 0.338564482}, // 5627K
			{0.329592295, 0.338545319}, // 5628K
			{0.32957062, 0.338526161}, // 5629K
			{0.329548955, 0.338507008}, // 5630K
			{0.329527298, 0.33848786}, // 5631K
			{0.329505649, 0.338468717}, // 5632K
			{0.329484009, 0.338449579}, // 5633K
			{0.329462378, 0.338430446}, // 5634K
			{0.329440755, 0.338411318}, // 5635K
			{0.329419141, 0.338392195}, // 5636K
			{0.329397535, 0.338373078}, // 5637K
			{0.329375938, 0.338353965}, // 5638K
			{0.329354349, 0.338334857}, // 5639K
			{0.329332769, 0.338315755}, // 5640K
			{0.329311198, 0.338296657}, // 5641K
			{0.329289635, 0.338277564}, // 5642K
			{0.329268081, 0.338258477}, // 5643K
			{0.329246535, 0.338239394}, // 5644K
			{0.329224998, 0.338220317}, // 5645K
			{0.329203469, 0.338201245}, // 5646K
			{0.329181949, 0.338182177}, // 5647K
			{0.329160438, 0.338163115}, // 5648K
			{0.329138935, 0.338144058}, // 5649K
			{0.32911744, 0.338125005}, // 5650K
			{0.329095954, 0.338105958}, // 5651K
			{0.329074476, 0.338086916}, // 5652K
			{0.329053007, 0.338067879}, // 5653K
			{0.329031547, 0.338048847}, // 5654K
			{0.329010095, 0.338029819}, // 5655K
			{0.328988651, 0.338010797}, // 5656K
			{0.328967216, 0.33799178}, // 5657K
			{0.32894579, 0.337972768}, // 5658K
			{0.328924372, 0.337953761}, // 5659K
			{0.328902962, 0.337934759}, // 5660K
			{0.328881561, 0.337915762}, // 5661K
			{0.328860168, 0.33789677}, // 5662K
			{0.328838784, 0.337877783}, // 5663K
			{0.328817408, 0.337858801}, // 5664K
			{0.328796041, 0.337839824}, // 5665K
			{0.328774682, 0.337820852}, // 5666K
			{0.328753332, 0.337801885}, // 5667K
			{0.32873199, 0.337782923}, // 5668K
			{0.328710657, 0.337763966}, // 5669K
			{0.328689332, 0.337745015}, // 5670K
			{0.328668015, 0.337726068}, // 5671K
			{0.328646707, 0.337707126}, // 5672K
			{0.328625407, 0.337688189}, // 5673K
			{0.328604116, 0.337669257}, // 5674K
			{0.328582833, 0.33765033}, // 5675K
			{0.328561558, 0.337631408}, // 5676K
			{0.328540292, 0.337612491}, // 5677K
			{0.328519034, 0.33759358}, // 5678K
			{0.328497785, 0.337574673}, // 5679K
			{0.328476544, 0.337555771}, // 5680K
			{0.328455311, 0.337536874}, // 5681K
			{0.328434087, 0.337517982}, // 5682K
			{0.328412871, 0.337499095}, // 5683K
			{0.328391664, 0.337480213}, // 5684K
			{0.328370465, 0.337461336}, // 5685K
			{0.328349274, 0.337442464}, // 5686K
			{0.328328091, 0.337423598}, // 5687K
			{0.328306917, 0.337404736}, // 5688K
			{0.328285752, 0.337385879}, // 5689K
			{0.328264594, 0.337367027}, // 5690K
			{0.328243445, 0.33734818}, // 5691K
			{0.328222305, 0.337329338}, // 5692K
			{0.328201173, 0.337310501}, // 5693K
			{0.328180049, 0.337291669}, // 5694K
			{0.328158933, 0.337272842}, // 5695K
			{0.328137826, 0.33725402}, // 5696K
			{0.328116727, 0.337235203}, // 5697K
			{0.328095636, 0.337216391}, // 5698K
			{0.328074553, 0.337197583}, // 5699K
			{0.328053479, 0.337178781}, // 5700K
			{0.328032414, 0.337159984}, // 5701K
			{0.328011356, 0.337141192}, // 5702K
			{0.327990307, 0.337122405}, // 5703K
			{0.327969266, 0.337103623}, // 5704K
			{0.327948233, 0.337084845}, // 5705K
			{0.327927209, 0.337066073}, // 5706K
			{0.327906193, 0.337047306}, // 5707K
			{0.327885185, 0.337028543}, // 5708K
			{0.327864186, 0.337009786}, // 5709K
			{0.327843194, 0.336991033}, // 5710K
			{0.327822211, 0.336972286}, // 5711K
			{0.327801237, 0.336953543}, // 5712K
			{0.32778027, 0.336934806}, // 5713K
			{0.327759312, 0.336916073}, // 5714K
			{0.327738362, 0.336897346}, // 5715K
			{0.32771742, 0.336878623}, // 5716K
			{0.327696486, 0.336859905}, // 5717K
			{0.327675561, 0.336841192}, // 5718K
			{0.327654644, 0.336822485}, // 5719K
			{0.327633735, 0.336803782}, // 5720K
			{0.327612834, 0.336785084}, // 5721K
			{0.327591942, 0.336766391}, // 5722K
			{0.327571058, 0.336747703}, // 5723K
			{0.327550181, 0.33672902}, // 5724K
			{0.327529314, 0.336710342}, // 5725K
			{0.327508454, 0.336691669}, // 5726K
			{0.327487602, 0.336673001}, // 5727K
			{0.327466759, 0.336654337}, // 5728K
			{0.327445924, 0.336635679}, // 5729K
			{0.327425097, 0.336617026}, // 5730K
			{0.327404278, 0.336598377}, // 5731K
			{0.327383468, 0.336579734}, // 5732K
			{0.327362665, 0.336561095}, // 5733K
			{0.327341871, 0.336542462}, // 5734K
			{0.327321085, 0.336523833}, // 5735K
			{0.327300307, 0.336505209}, // 5736K
			{0.327279537, 0.33648659}, // 5737K
			{0.327258776, 0.336467976}, // 5738K
			{0.327238022, 0.336449368}, // 5739K
			{0.327217277, 0.336430764}, // 5740K
			{0.327196539, 0.336412164}, // 5741K
			{0.32717581, 0.33639357}, // 5742K
			{0.327155089, 0.336374981}, // 5743K
			{0.327134376, 0.336356397}, // 5744K
			{0.327113672, 0.336337818}, // 5745K
			{0.327092975, 0.336319243}, // 5746K
			{0.327072286, 0.336300674}, // 5747K
			{0.327051606, 0.336282109}, // 5748K
			{0.327030934, 0.336263549}, // 5749K
			{0.327010269, 0.336244995}, // 5750K
			{0.326989613, 0.336226445}, // 5751K
			{0.326968965, 0.3362079}, // 5752K
			{0.326948325, 0.33618936}, // 5753K
			{0.326927693, 0.336170825}, // 5754K
			{0.326907069, 0.336152295}, // 5755K
			{0.326886454, 0.336133769}, // 5756K
			{0.326865846, 0.336115249}, // 5757K
			{0.326845246, 0.336096734}, // 5758K
			{0.326824655, 0.336078223}, // 5759K
			{0.326804071, 0.336059718}, // 5760K
			{0.326783496, 0.336041217}, // 5761K
			{0.326762928, 0.336022721}, // 5762K
			{0.326742369, 0.33600423}, // 5763K
			{0.326721817, 0.335985744}, // 5764K
			{0.326701274, 0.335967263}, // 5765K
			{0.326680739, 0.335948787}, // 5766K
			{0.326660211, 0.335930316}, // 5767K
			{0.326639692, 0.335911849}, // 5768K
			{0.326619181, 0.335893388}, // 5769K
			{0.326598678, 0.335874931}, // 5770K
			{0.326578182, 0.33585648}, // 5771K
			{0.326557695, 0.335838033}, // 5772K
			{0.326537216, 0.335819591}, // 5773K
			{0.326516745, 0.335801154}, // 5774K
			{0.326496281, 0.335782722}, // 5775K
			{0.326475826, 0.335764295}, // 5776K
			{0.326455379, 0.335745873}, // 5777K
			{0.32643494, 0.335727455}, // 5778K
			{0.326414508, 0.335709043}, // 5779K
			{0.326394085, 0.335690635}, // 5780K
			{0.32637367, 0.335672232}, // 5781K
			{0.326353262, 0.335653834}, // 5782K
			{0.326332863, 0.335635441}, // 5783K
			{0.326312471, 0.335617053}, // 5784K
			{0.326292088, 0.33559867}, // 5785K
			{0.326271712, 0.335580292}, // 5786K
			{0.326251345, 0.335561918}, // 5787K
			{0.326230985, 0.33554355}, // 5788K
			{0.326210633, 0.335525186}, // 5789K
			{0.326190289, 0.335506827}, // 5790K
			{0.326169953, 0.335488473}, // 5791K
			{0.326149625, 0.335470124}, // 5792K
			{0.326129305, 0.33545178}, // 5793K
			{0.326108993, 0.335433441}, // 5794K
			{0.326088689, 0.335415106}, // 5795K
			{0.326068393, 0.335396776}, // 5796K
			{0.326048104, 0.335378452}, // 5797K
			{0.326027824, 0.335360132}, // 5798K
			{0.326007551, 0.335341817}, // 5799K
			{0.325987286, 0.335323507}, // 5800K
			{0.325967029, 0.335305201}, // 5801K
			{0.32594678, 0.335286901}, // 5802K
			{0.325926539, 0.335268605}, // 5803K
			{0.325906306, 0.335250315}, // 5804K
			{0.325886081, 0.335232029}, // 5805K
			{0.325865863, 0.335213748}, // 5806K
			{0.325845654, 0.335195472}, // 5807K
			{0.325825452, 0.335177201}, // 5808K
			{0.325805258, 0.335158934}, // 5809K
			{0.325785072, 0.335140673}, // 5810K
			{0.325764894, 0.335122416}, // 5811K
			{0.325744723, 0.335104164}, // 5812K
			{0.325724561, 0.335085917}, // 5813K
			{0.325704406, 0.335067675}, // 5814K
			{0.325684259, 0.335049438}, // 5815K
			{0.32566412, 0.335031205}, // 5816K
			{0.325643989, 0.335012978}, // 5817K
			{0.325623865, 0.334994755}, // 5818K
			{0.32560375, 0.334976537}, // 5819K
			{0.325583642, 0.334958324}, // 5820K
			{0.325563542, 0.334940116}, // 5821K
			{0.32554345, 0.334921912}, // 5822K
			{0.325523366, 0.334903714}, // 5823K
			{0.325503289, 0.33488552}, // 5824K
			{0.32548322, 0.334867331}, // 5825K
			{0.325463159, 0.334849147}, // 5826K
			{0.325443106, 0.334830968}, // 5827K
			{0.325423061, 0.334812793}, // 5828K
			{0.325403023, 0.334794624}, // 5829K
			{0.325382993, 0.334776459}, // 5830K
			{0.325362971, 0.334758299}, // 5831K
			{0.325342957, 0.334740144}, // 5832K
			{0.32532295, 0.334721994}, // 5833K
			{0.325302951, 0.334703848}, // 5834K
			{0.32528296, 0.334685708}, // 5835K
			{0.325262977, 0.334667572}, // 5836K
			{0.325243001, 0.334649441}, // 5837K
			{0.325223034, 0.334631315}, // 5838K
			{0.325203073, 0.334613193}, // 5839K
			{0.325183121, 0.334595077}, // 5840K
			{0.325163176, 0.334576965}, // 5841K
			{0.32514324, 0.334558858}, // 5842K
			{0.32512331, 0.334540756}, // 5843K
			{0.325103389, 0.334522659}, // 5844K
			{0.325083475, 0.334504567}, // 5845K
			{0.325063569, 0.334486479}, // 5846K
			{0.325043671, 0.334468396}, // 5847K
			{0.32502378, 0.334450318}, // 5848K
			{0.325003897, 0.334432245}, // 5849K
			{0.324984022, 0.334414177}, // 5850K
			{0.324964154, 0.334396113}, // 5851K
			{0.324944294, 0.334378054}, // 5852K
			{0.324924442, 0.33436}, // 5853K
			{0.324904598, 0.334341951}, // 5854K
			{0.324884761, 0.334323907}, // 5855K
			{0.324864932, 0.334305867}, // 5856K
			{0.32484511, 0.334287833}, // 5857K
			{0.324825296, 0.334269803}, // 5858K
			{0.32480549, 0.334251777}, // 5859K
			{0.324785692, 0.334233757}, // 5860K
			{0.324765901, 0.334215741}, // 5861K
			{0.324746117, 0.334197731}, // 5862K
			{0.324726342, 0.334179725}, // 5863K
			{0.324706574, 0.334161723}, // 5864K
			{0.324686814, 0.334143727}, // 5865K
			{0.324667061, 0.334125735}, // 5866K
			{0.324647316, 0.334107749}, // 5867K
			{0.324627578, 0.334089767}, // 5868K
			{0.324607849, 0.334071789}, // 5869K
			{0.324588126, 0.334053817}, // 5870K
			{0.324568412, 0.334035849}, // 5871K
			{0.324548705, 0.334017886}, // 5872K
			{0.324529005, 0.333999928}, // 5873K
			{0.324509314, 0.333981975}, // 5874K
			{0.324489629, 0.333964026}, // 5875K
			{0.324469953, 0.333946082}, // 5876K
			{0.324450284, 0.333928143}, // 5877K
			{0.324430622, 0.333910209}, // 5878K
			{0.324410969, 0.33389228}, // 5879K
			{0.324391322, 0.333874355}, // 5880K
			{0.324371684, 0.333856435}, // 5881K
			{0.324352053, 0.33383852}, // 5882K
			{0.324332429, 0.333820609}, // 5883K
			{0.324312813, 0.333802704}, // 5884K
			{0.324293205, 0.333784803}, // 5885K
			{0.324273604, 0.333766907}, // 5886K
			{0.32425401, 0.333749015}, // 5887K
			{0.324234425, 0.333731129}, // 5888K
			{0.324214847, 0.333713247}, // 5889K
			{0.324195276, 0.33369537}, // 5890K
			{0.324175713, 0.333677498}, // 5891K
			{0.324156157, 0.33365963}, // 5892K
			{0.324136609, 0.333641767}, // 5893K
			{0.324117068, 0.333623909}, // 5894K
			{0.324097535, 0.333606056}, // 5895K
			{0.32407801, 0.333588208}, // 5896K
			{0.324058492, 0.333570364}, // 5897K
			{0.324038981, 0.333552525}, // 5898K
			{0.324019478, 0.333534691}, // 5899K
			{0.323999983, 0.333516861}, // 5900K
			{0.323980495, 0.333499036}, // 5901K
			{0.323961014, 0.333481216}, // 5902K
			{0.323941541, 0.333463401}, // 5903K
			{0.323922076, 0.333445591}, // 5904K
			{0.323902618, 0.333427785}, // 5905K
			{0.323883167, 0.333409984}, // 5906K
			{0.323863724, 0.333392188}, // 5907K
			{0.323844289, 0.333374396}, // 5908K
			{0.32382486, 0.333356609}, // 5909K
			{0.32380544, 0.333338827}, // 5910K
			{0.323786027, 0.33332105}, // 5911K
			{0.323766621, 0.333303277}, // 5912K
			{0.323747222, 0.333285509}, // 5913K
			{0.323727832, 0.333267746}, // 5914K
			{0.323708448, 0.333249988}, // 5915K
			{0.323689072, 0.333232234}, // 5916K
			{0.323669704, 0.333214485}, // 5917K
			{0.323650343, 0.333196741}, // 5918K
			{0.323630989, 0.333179001}, // 5919K
			{0.323611643, 0.333161267}, // 5920K
			{0.323592304, 0.333143537}, // 5921K
			{0.323572972, 0.333125811}, // 5922K
			{0.323553648, 0.333108091}, // 5923K
			{0.323534332, 0.333090375}, // 5924K
			{0.323515023, 0.333072664}, // 5925K
			{0.323495721, 0.333054957}, // 5926K
			{0.323476427, 0.333037255}, // 5927K
			{0.32345714, 0.333019558}, // 5928K
			{0.32343786, 0.333001866}, // 5929K
			{0.323418588, 0.332984179}, // 5930K
			{0.323399323, 0.332966496}, // 5931K
			{0.323380066, 0.332948817}, // 5932K
			{0.323360816, 0.332931144}, // 5933K
			{0.323341573, 0.332913475}, // 5934K
			{0.323322338, 0.332895811}, // 5935K
			{0.32330311, 0.332878152}, // 5936K
			{0.323283889, 0.332860497}, // 5937K
			{0.323264676, 0.332842847}, // 5938K
			{0.32324547, 0.332825202}, // 5939K
			{0.323226272, 0.332807562}, // 5940K
			{0.323207081, 0.332789926}, // 5941K
			{0.323187897, 0.332772295}, // 5942K
			{0.32316872, 0.332754668}, // 5943K
			{0.323149551, 0.332737047}, // 5944K
			{0.323130389, 0.33271943}, // 5945K
			{0.323111235, 0.332701817}, // 5946K
			{0.323092088, 0.33268421}, // 5947K
			{0.323072948, 0.332666607}, // 5948K
			{0.323053816, 0.332649009}, // 5949K
			{0.32303469, 0.332631415}, // 5950K
			{0.323015573, 0.332613826}, // 5951K
			{0.322996462, 0.332596242}, // 5952K
			{0.322977359, 0.332578663}, // 5953K
			{0.322958263, 0.332561088}, // 5954K
			{0.322939174, 0.332543518}, // 5955K
			{0.322920093, 0.332525952}, // 5956K
			{0.322901019, 0.332508391}, // 5957K
			{0.322881952, 0.332490835}, // 5958K
			{0.322862893, 0.332473284}, // 5959K
			{0.32284384, 0.332455737}, // 5960K
			{0.322824795, 0.332438195}, // 5961K
			{0.322805758, 0.332420658}, // 5962K
			{0.322786727, 0.332403125}, // 5963K
			{0.322767704, 0.332385597}, // 5964K
			{0.322748688, 0.332368074}, // 5965K
			{0.32272968, 0.332350555}, // 5966K
			{0.322710678, 0.332333041}, // 5967K
			{0.322691684, 0.332315532}, // 5968K
			{0.322672698, 0.332298027}, // 5969K
			{0.322653718, 0.332280527}, // 5970K
			{0.322634746, 0.332263032}, // 5971K
			{0.32261578, 0.332245541}, // 5972K
			{0.322596822, 0.332228055}, // 5973K
			{0.322577872, 0.332210574}, // 5974K
			{0.322558928, 0.332193097}, // 5975K
			{0.322539992, 0.332175625}, // 5976K
			{0.322521063, 0.332158158}, // 5977K
			{0.322502141, 0.332140695}, // 5978K
			{0.322483227, 0.332123237}, // 5979K
			{0.322464319, 0.332105784}, // 5980K
			{0.322445419, 0.332088335}, // 5981K
			{0.322426526, 0.332070891}, // 5982K
			{0.32240764, 0.332053452}, // 5983K
			{0.322388762, 0.332036017}, // 5984K
			{0.32236989, 0.332018587}, // 5985K
			{0.322351026, 0.332001161}, // 5986K
			{0.322332169, 0.33198374}, // 5987K
			{0.322313319, 0.331966324}, // 5988K
			{0.322294477, 0.331948913}, // 5989K
			{0.322275641, 0.331931506}, // 5990K
			{0.322256813, 0.331914103}, // 5991K
			{0.322237992, 0.331896706}, // 5992K
			{0.322219178, 0.331879313}, // 5993K
			{0.322200371, 0.331861924}, // 5994K
			{0.322181571, 0.331844541}, // 5995K
			{0.322162778, 0.331827162}, // 5996K
			{0.322143993, 0.331809787}, // 5997K
			{0.322125215, 0.331792417}, // 5998K
			{0.322106444, 0.331775052}, // 5999K
			{0.32208768, 0.331757692}, // 6000K
			{0.322068923, 0.331740336}, // 6001K
			{0.322050173, 0.331722985}, // 6002K
			{0.32203143, 0.331705638}, // 6003K
			{0.322012695, 0.331688296}, // 6004K
			{0.321993967, 0.331670958}, // 6005K
			{0.321975245, 0.331653626}, // 6006K
			{0.321956531, 0.331636298}, // 6007K
			{0.321937824, 0.331618974}, // 6008K
			{0.321919124, 0.331601655}, // 6009K
			{0.321900431, 0.331584341}, // 6010K
			{0.321881746, 0.331567031}, // 6011K
			{0.321863067, 0.331549726}, // 6012K
			{0.321844395, 0.331532426}, // 6013K
			{0.321825731, 0.33151513}, // 6014K
			{0.321807073, 0.331497839}, // 6015K
			{0.321788423, 0.331480552}, // 6016K
			{0.32176978, 0.33146327}, // 6017K
			{0.321751144, 0.331445993}, // 6018K
			{0.321732515, 0.33142872}, // 6019K
			{0.321713893, 0.331411452}, // 6020K
			{0.321695278, 0.331394188}, // 6021K
			{0.32167667, 0.331376929}, // 6022K
			{0.321658069, 0.331359675}, // 6023K
			{0.321639475, 0.331342425}, // 6024K
			{0.321620888, 0.33132518}, // 6025K
			{0.321602308, 0.331307939}, // 6026K
			{0.321583736, 0.331290703}, // 6027K
			{0.32156517, 0.331273472}, // 6028K
			{0.321546612, 0.331256245}, // 6029K
			{0.32152806, 0.331239023}, // 6030K
			{0.321509515, 0.331221806}, // 6031K
			{0.321490978, 0.331204593}, // 6032K
			{0.321472447, 0.331187384}, // 6033K
			{0.321453924, 0.331170181}, // 6034K
			{0.321435407, 0.331152981}, // 6035K
			{0.321416898, 0.331135787}, // 6036K
			{0.321398395, 0.331118597}, // 6037K
			{0.3213799, 0.331101411}, // 6038K
			{0.321361411, 0.33108423}, // 6039K
			{0.32134293, 0.331067054}, // 6040K
			{0.321324455, 0.331049882}, // 6041K
			{0.321305988, 0.331032715}, // 6042K
			{0.321287527, 0.331015553}, // 6043K
			{0.321269074, 0.330998395}, // 6044K
			{0.321250627, 0.330981242}, // 6045K
			{0.321232188, 0.330964093}, // 6046K
			{0.321213755, 0.330946949}, // 6047K
			{0.321195329, 0.330929809}, // 6048K
			{0.321176911, 0.330912674}, // 6049K
			{0.321158499, 0.330895543}, // 6050K
			{0.321140094, 0.330878417}, // 6051K
			{0.321121696, 0.330861296}, // 6052K
			{0.321103306, 0.330844179}, // 6053K
			{0.321084922, 0.330827067}, // 6054K
			{0.321066545, 0.330809959}, // 6055K
			{0.321048175, 0.330792856}, // 6056K
			{0.321029811, 0.330775758}, // 6057K
			{0.321011455, 0.330758664}, // 6058K
			{0.320993106, 0.330741574}, // 6059K
			{0.320974764, 0.33072449}, // 6060K
			{0.320956428, 0.330707409}, // 6061K
			{0.3209381, 0.330690334}, // 6062K
			{0.320919778, 0.330673262}, // 6063K
			{0.320901464, 0.330656196}, // 6064K
			{0.320883156, 0.330639134}, // 6065K
			{0.320864855, 0.330622076}, // 6066K
			{0.320846561, 0.330605023}, // 6067K
			{0.320828274, 0.330587975}, // 6068K
			{0.320809994, 0.330570931}, // 6069K
			{0.320791721, 0.330553892}, // 6070K
			{0.320773454, 0.330536857}, // 6071K
			{0.320755195, 0.330519827}, // 6072K
			{0.320736942, 0.330502801}, // 6073K
			{0.320718696, 0.33048578}, // 6074K
			{0.320700458, 0.330468763}, // 6075K
			{0.320682226, 0.330451751}, // 6076K
			{0.320664, 0.330434744}, // 6077K
			{0.320645782, 0.330417741}, // 6078K
			{0.320627571, 0.330400742}, // 6079K
			{0.320609366, 0.330383749}, // 6080K
			{0.320591169, 0.330366759}, // 6081K
			{0.320572978, 0.330349774}, // 6082K
			{0.320554794, 0.330332794}, // 6083K
			{0.320536617, 0.330315818}, // 6084K
			{0.320518446, 0.330298847}, // 6085K
			{0.320500283, 0.33028188}, // 6086K
			{0.320482126, 0.330264918}, // 6087K
			{0.320463976, 0.33024796}, // 6088K
			{0.320445833, 0.330231007}, // 6089K
			{0.320427697, 0.330214059}, // 6090K
			{0.320409568, 0.330197115}, // 6091K
			{0.320391445, 0.330180175}, // 6092K
			{0.32037333, 0.33016324}, // 6093K
			{0.320355221, 0.33014631}, // 6094K
			{0.320337119, 0.330129384}, // 6095K
			{0.320319023, 0.330112462}, // 6096K
			{0.320300935, 0.330095545}, // 6097K
			{0.320282853, 0.330078633}, // 6098K
			{0.320264778, 0.330061725}, // 6099K
			{0.32024671, 0.330044821}, // 6100K
			{0.320228649, 0.330027922}, // 6101K
			{0.320210594, 0.330011028}, // 6102K
			{0.320192547, 0.329994138}, // 6103K
			{0.320174506, 0.329977253}, // 6104K
			{0.320156471, 0.329960372}, // 6105K
			{0.320138444, 0.329943495}, // 6106K
			{0.320120423, 0.329926624}, // 6107K
			{0.320102409, 0.329909756}, // 6108K
			{0.320084402, 0.329892893}, // 6109K
			{0.320066402, 0.329876035}, // 6110K
			{0.320048408, 0.329859181}, // 6111K
			{0.320030421, 0.329842332}, // 6112K
			{0.320012441, 0.329825487}, // 6113K
			{0.319994468, 0.329808646}, // 6114K
			{0.319976501, 0.32979181}, // 6115K
			{0.319958541, 0.329774979}, // 6116K
			{0.319940588, 0.329758152}, // 6117K
			{0.319922641, 0.32974133}, // 6118K
			{0.319904702, 0.329724512}, // 6119K
			{0.319886769, 0.329707698}, // 6120K
			{0.319868842, 0.329690889}, // 6121K
			{0.319850923, 0.329674085}, // 6122K
			{0.31983301, 0.329657285}, // 6123K
			{0.319815104, 0.329640489}, // 6124K
			{0.319797204, 0.329623698}, // 6125K
			{0.319779312, 0.329606912}, // 6126K
			{0.319761426, 0.32959013}, // 6127K
			{0.319743546, 0.329573352}, // 6128K
			{0.319725674, 0.329556579}, // 6129K
			{0.319707808, 0.329539811}, // 6130K
			{0.319689948, 0.329523046}, // 6131K
			{0.319672096, 0.329506287}, // 6132K
			{0.31965425, 0.329489532}, // 6133K
			{0.31963641, 0.329472781}, // 6134K
			{0.319618578, 0.329456035}, // 6135K
			{0.319600752, 0.329439293}, // 6136K
			{0.319582933, 0.329422555}, // 6137K
			{0.31956512, 0.329405823}, // 6138K
			{0.319547314, 0.329389094}, // 6139K
			{0.319529515, 0.32937237}, // 6140K
			{0.319511722, 0.329355651}, // 6141K
			{0.319493936, 0.329338936}, // 6142K
			{0.319476157, 0.329322225}, // 6143K
			{0.319458384, 0.329305519}, // 6144K
			{0.319440618, 0.329288818}, // 6145K
			{0.319422859, 0.32927212}, // 6146K
			{0.319405106, 0.329255428}, // 6147K
			{0.31938736, 0.329238739}, // 6148K
			{0.319369621, 0.329222056}, // 6149K
			{0.319351888, 0.329205376}, // 6150K
			{0.319334162, 0.329188701}, // 6151K
			{0.319316442, 0.329172031}, // 6152K
			{0.319298729, 0.329155365}, // 6153K
			{0.319281022, 0.329138703}, // 6154K
			{0.319263323, 0.329122046}, // 6155K
			{0.319245629, 0.329105393}, // 6156K
			{0.319227943, 0.329088745}, // 6157K
			{0.319210263, 0.329072101}, // 6158K
			{0.31919259, 0.329055462}, // 6159K
			{0.319174923, 0.329038827}, // 6160K
			{0.319157262, 0.329022197}, // 6161K
			{0.319139609, 0.329005571}, // 6162K
			{0.319121962, 0.328988949}, // 6163K
			{0.319104321, 0.328972332}, // 6164K
			{0.319086687, 0.328955719}, // 6165K
			{0.31906906, 0.328939111}, // 6166K
			{0.319051439, 0.328922507}, // 6167K
			{0.319033825, 0.328905908}, // 6168K
			{0.319016217, 0.328889313}, // 6169K
			{0.318998616, 0.328872722}, // 6170K
			{0.318981022, 0.328856136}, // 6171K
			{0.318963434, 0.328839554}, // 6172K
			{0.318945853, 0.328822977}, // 6173K
			{0.318928278, 0.328806404}, // 6174K
			{0.318910709, 0.328789836}, // 6175K
			{0.318893148, 0.328773272}, // 6176K
			{0.318875592, 0.328756712}, // 6177K
			{0.318858044, 0.328740157}, // 6178K
			{0.318840501, 0.328723606}, // 6179K
			{0.318822966, 0.32870706}, // 6180K
			{0.318805437, 0.328690518}, // 6181K
			{0.318787914, 0.32867398}, // 6182K
			{0.318770398, 0.328657447}, // 6183K
			{0.318752888, 0.328640919}, // 6184K
			{0.318735385, 0.328624394}, // 6185K
			{0.318717889, 0.328607874}, // 6186K
			{0.318700399, 0.328591359}, // 6187K
			{0.318682915, 0.328574848}, // 6188K
			{0.318665438, 0.328558341}, // 6189K
			{0.318647967, 0.328541839}, // 6190K
			{0.318630503, 0.328525341}, // 6191K
			{0.318613046, 0.328508848}, // 6192K
			{0.318595595, 0.328492359}, // 6193K
			{0.31857815, 0.328475874}, // 6194K
			{0.318560712, 0.328459394}, // 6195K
			{0.31854328, 0.328442918}, // 6196K
			{0.318525855, 0.328426446}, // 6197K
			{0.318508436, 0.328409979}, // 6198K
			{0.318491024, 0.328393517}, // 6199K
			{0.318473618, 0.328377058}, // 6200K
			{0.318456219, 0.328360605}, // 6201K
			{0.318438826, 0.328344155}, // 6202K
			{0.31842144, 0.32832771}, // 6203K
			{0.31840406, 0.328311269}, // 6204K
			{0.318386686, 0.328294833}, // 6205K
			{0.318369319, 0.328278401}, // 6206K
			{0.318351959, 0.328261973}, // 6207K
			{0.318334604, 0.32824555}, // 6208K
			{0.318317257, 0.328229131}, // 6209K
			{0.318299915, 0.328212717}, // 6210K
			{0.31828258, 0.328196307}, // 6211K
			{0.318265252, 0.328179901}, // 6212K
			{0.31824793, 0.3281635}, // 6213K
			{0.318230614, 0.328147103}, // 6214K
			{0.318213305, 0.32813071}, // 6215K
			{0.318196002, 0.328114322}, // 6216K
			{0.318178706, 0.328097939}, // 6217K
			{0.318161416, 0.328081559}, // 6218K
			{0.318144132, 0.328065184}, // 6219K
			{0.318126855, 0.328048813}, // 6220K
			{0.318109584, 0.328032447}, // 6221K
			{0.31809232, 0.328016085}, // 6222K
			{0.318075062, 0.327999727}, // 6223K
			{0.31805781, 0.327983374}, // 6224K
			{0.318040565, 0.327967025}, // 6225K
			{0.318023326, 0.327950681}, // 6226K
			{0.318006094, 0.327934341}, // 6227K
			{0.317988868, 0.327918005}, // 6228K
			{0.317971648, 0.327901674}, // 6229K
			{0.317954435, 0.327885346}, // 6230K
			{0.317937228, 0.327869024}, // 6231K
			{0.317920027, 0.327852705}, // 6232K
			{0.317902833, 0.327836391}, // 6233K
			{0.317885645, 0.327820082}, // 6234K
			{0.317868463, 0.327803776}, // 6235K
			{0.317851288, 0.327787475}, // 6236K
			{0.317834119, 0.327771179}, // 6237K
			{0.317816957, 0.327754887}, // 6238K
			{0.317799801, 0.327738599}, // 6239K
			{0.317782651, 0.327722315}, // 6240K
			{0.317765507, 0.327706036}, // 6241K
			{0.31774837, 0.327689761}, // 6242K
			{0.317731239, 0.32767349}, // 6243K
			{0.317714115, 0.327657224}, // 6244K
			{0.317696997, 0.327640962}, // 6245K
			{0.317679885, 0.327624705}, // 6246K
			{0.317662779, 0.327608452}, // 6247K
			{0.31764568, 0.327592203}, // 6248K
			{0.317628587, 0.327575958}, // 6249K
			{0.3176115, 0.327559718}, // 6250K
			{0.31759442, 0.327543482}, // 6251K
			{0.317577346, 0.327527251}, // 6252K
			{0.317560278, 0.327511023}, // 6253K
			{0.317543217, 0.327494801}, // 6254K
			{0.317526162, 0.327478582}, // 6255K
			{0.317509113, 0.327462368}, // 6256K
			{0.317492071, 0.327446158}, // 6257K
			{0.317475034, 0.327429952}, // 6258K
			{0.317458004, 0.327413751}, // 6259K
			{0.317440981, 0.327397554}, // 6260K
			{0.317423963, 0.327381361}, // 6261K
			{0.317406952, 0.327365173}, // 6262K
			{0.317389947, 0.327348989}, // 6263K
			{0.317372948, 0.32733281}, // 6264K
			{0.317355956, 0.327316634}, // 6265K
			{0.31733897, 0.327300463}, // 6266K
			{0.31732199, 0.327284296}, // 6267K
			{0.317305017, 0.327268134}, // 6268K
			{0.317288049, 0.327251976}, // 6269K
			{0.317271088, 0.327235822}, // 6270K
			{0.317254133, 0.327219673}, // 6271K
			{0.317237185, 0.327203527}, // 6272K
			{0.317220242, 0.327187386}, // 6273K
			{0.317203306, 0.32717125}, // 6274K
			{0.317186376, 0.327155118}, // 6275K
			{0.317169452, 0.32713899}, // 6276K
			{0.317152535, 0.327122866}, // 6277K
			{0.317135624, 0.327106747}, // 6278K
			{0.317118719, 0.327090631}, // 6279K
			{0.31710182, 0.327074521}, // 6280K
			{0.317084927, 0.327058414}, // 6281K
			{0.317068041, 0.327042312}, // 6282K
			{0.317051161, 0.327026214}, // 6283K
			{0.317034287, 0.327010121}, // 6284K
			{0.317017419, 0.326994031}, // 6285K
			{0.317000557, 0.326977946}, // 6286K
			{0.316983702, 0.326961865}, // 6287K
			{0.316966853, 0.326945789}, // 6288K
			{0.31695001, 0.326929717}, // 6289K
			{0.316933173, 0.326913649}, // 6290K
			{0.316916342, 0.326897585}, // 6291K
			{0.316899518, 0.326881526}, // 6292K
			{0.3168827, 0.326865471}, // 6293K
			{0.316865887, 0.32684942}, // 6294K
			{0.316849082, 0.326833374}, // 6295K
			{0.316832282, 0.326817331}, // 6296K
			{0.316815488, 0.326801294}, // 6297K
			{0.316798701, 0.32678526}, // 6298K
			{0.316781919, 0.32676923}, // 6299K
			{0.316765144, 0.326753205}, // 6300K
			{0.316748375, 0.326737185}, // 6301K
			{0.316731612, 0.326721168}, // 6302K
			{0.316714856, 0.326705156}, // 6303K
			{0.316698105, 0.326689148}, // 6304K
			{0.316681361, 0.326673144}, // 6305K
			{0.316664623, 0.326657144}, // 6306K
			{0.316647891, 0.326641149}, // 6307K
			{0.316631165, 0.326625158}, // 6308K
			{0.316614445, 0.326609171}, // 6309K
			{0.316597731, 0.326593189}, // 6310K
			{0.316581023, 0.326577211}, // 6311K
			{0.316564322, 0.326561237}, // 6312K
			{0.316547626, 0.326545267}, // 6313K
			{0.316530937, 0.326529302}, // 6314K
			{0.316514254, 0.326513341}, // 6315K
			{0.316497577, 0.326497384}, // 6316K
			{0.316480906, 0.326481431}, // 6317K
			{0.316464241, 0.326465483}, // 6318K
			{0.316447583, 0.326449538}, // 6319K
			{0.31643093, 0.326433599}, // 6320K
			{0.316414283, 0.326417663}, // 6321K
			{0.316397643, 0.326401731}, // 6322K
			{0.316381009, 0.326385804}, // 6323K
			{0.31636438, 0.326369881}, // 6324K
			{0.316347758, 0.326353963}, // 6325K
			{0.316331142, 0.326338048}, // 6326K
			{0.316314532, 0.326322138}, // 6327K
			{0.316297928, 0.326306232}, // 6328K
			{0.31628133, 0.32629033}, // 6329K
			{0.316264738, 0.326274433}, // 6330K
			{0.316248152, 0.32625854}, // 6331K
			{0.316231573, 0.326242651}, // 6332K
			{0.316214999, 0.326226766}, // 6333K
			{0.316198431, 0.326210885}, // 6334K
			{0.31618187, 0.326195009}, // 6335K
			{0.316165314, 0.326179137}, // 6336K
			{0.316148765, 0.326163269}, // 6337K
			{0.316132222, 0.326147405}, // 6338K
			{0.316115684, 0.326131546}, // 6339K
			{0.316099153, 0.326115691}, // 6340K
			{0.316082628, 0.32609984}, // 6341K
			{0.316066108, 0.326083993}, // 6342K
			{0.316049595, 0.32606815}, // 6343K
			{0.316033088, 0.326052312}, // 6344K
			{0.316016587, 0.326036478}, // 6345K
			{0.316000092, 0.326020648}, // 6346K
			{0.315983602, 0.326004823}, // 6347K
			{0.315967119, 0.325989001}, // 6348K
			{0.315950642, 0.325973184}, // 6349K
			{0.315934171, 0.325957371}, // 6350K
			{0.315917706, 0.325941562}, // 6351K
			{0.315901247, 0.325925757}, // 6352K
			{0.315884794, 0.325909957}, // 6353K
			{0.315868347, 0.325894161}, // 6354K
			{0.315851906, 0.325878369}, // 6355K
			{0.31583547, 0.325862581}, // 6356K
			{0.315819041, 0.325846798}, // 6357K
			{0.315802618, 0.325831018}, // 6358K
			{0.315786201, 0.325815243}, // 6359K
			{0.31576979, 0.325799472}, // 6360K
			{0.315753385, 0.325783705}, // 6361K
			{0.315736985, 0.325767943}, // 6362K
			{0.315720592, 0.325752185}, // 6363K
			{0.315704205, 0.32573643}, // 6364K
			{0.315687823, 0.32572068}, // 6365K
			{0.315671448, 0.325704935}, // 6366K
			{0.315655079, 0.325689193}, // 6367K
			{0.315638715, 0.325673456}, // 6368K
			{0.315622358, 0.325657723}, // 6369K
			{0.315606006, 0.325641994}, // 6370K
			{0.315589661, 0.325626269}, // 6371K
			{0.315573321, 0.325610548}, // 6372K
			{0.315556987, 0.325594832}, // 6373K
			{0.31554066, 0.325579119}, // 6374K
			{0.315524338, 0.325563411}, // 6375K
			{0.315508022, 0.325547707}, // 6376K
			{0.315491712, 0.325532008}, // 6377K
			{0.315475408, 0.325516312}, // 6378K
			{0.31545911, 0.325500621}, // 6379K
			{0.315442817, 0.325484934}, // 6380K
			{0.315426531, 0.325469251}, // 6381K
			{0.315410251, 0.325453572}, // 6382K
			{0.315393976, 0.325437897}, // 6383K
			{0.315377708, 0.325422227}, // 6384K
			{0.315361445, 0.32540656}, // 6385K
			{0.315345189, 0.325390898}, // 6386K
			{0.315328938, 0.32537524}, // 6387K
			{0.315312693, 0.325359586}, // 6388K
			{0.315296454, 0.325343937}, // 6389K
			{0.315280221, 0.325328291}, // 6390K
			{0.315263993, 0.32531265}, // 6391K
			{0.315247772, 0.325297013}, // 6392K
			{0.315231557, 0.32528138}, // 6393K
			{0.315215347, 0.325265751}, // 6394K
			{0.315199143, 0.325250126}, // 6395K
			{0.315182945, 0.325234506}, // 6396K
			{0.315166754, 0.32521889}, // 6397K
			{0.315150567, 0.325203277}, // 6398K
			{0.315134387, 0.325187669}, // 6399K
			{0.315118213, 0.325172065}, // 6400K
			{0.315102044, 0.325156466}, // 6401K
			{0.315085882, 0.32514087}, // 6402K
			{0.315069725, 0.325125279}, // 6403K
			{0.315053574, 0.325109691}, // 6404K
			{0.315037429, 0.325094108}, // 6405K
			{0.31502129, 0.325078529}, // 6406K
			{0.315005156, 0.325062954}, // 6407K
			{0.314989029, 0.325047384}, // 6408K
			{0.314972907, 0.325031817}, // 6409K
			{0.314956791, 0.325016255}, // 6410K
			{0.314940681, 0.325000696}, // 6411K
			{0.314924577, 0.324985142}, // 6412K
			{0.314908479, 0.324969592}, // 6413K
			{0.314892386, 0.324954046}, // 6414K
			{0.3148763, 0.324938505}, // 6415K
			{0.314860219, 0.324922967}, // 6416K
			{0.314844144, 0.324907434}, // 6417K
			{0.314828074, 0.324891904}, // 6418K
			{0.314812011, 0.324876379}, // 6419K
			{0.314795953, 0.324860858}, // 6420K
			{0.314779902, 0.324845341}, // 6421K
			{0.314763856, 0.324829828}, // 6422K
			{0.314747815, 0.32481432}, // 6423K
			{0.314731781, 0.324798815}, // 6424K
			{0.314715752, 0.324783315}, // 6425K
			{0.31469973, 0.324767818}, // 6426K
			{0.314683712, 0.324752326}, // 6427K
			{0.314667701, 0.324736838}, // 6428K
			{0.314651696, 0.324721354}, // 6429K
			{0.314635696, 0.324705874}, // 6430K
			{0.314619702, 0.324690399}, // 6431K
			{0.314603714, 0.324674927}, // 6432K
			{0.314587732, 0.324659459}, // 6433K
			{0.314571755, 0.324643996}, // 6434K
			{0.314555784, 0.324628537}, // 6435K
			{0.314539819, 0.324613082}, // 6436K
			{0.31452386, 0.324597631}, // 6437K
			{0.314507906, 0.324582184}, // 6438K
			{0.314491959, 0.324566741}, // 6439K
			{0.314476017, 0.324551302}, // 6440K
			{0.31446008, 0.324535868}, // 6441K
			{0.31444415, 0.324520437}, // 6442K
			{0.314428225, 0.324505011}, // 6443K
			{0.314412306, 0.324489588}, // 6444K
			{0.314396393, 0.32447417}, // 6445K
			{0.314380485, 0.324458756}, // 6446K
			{0.314364583, 0.324443346}, // 6447K
			{0.314348687, 0.32442794}, // 6448K
			{0.314332797, 0.324412538}, // 6449K
			{0.314316912, 0.32439714}, // 6450K
			{0.314301033, 0.324381747}, // 6451K
			{0.31428516, 0.324366357}, // 6452K
			{0.314269293, 0.324350972}, // 6453K
			{0.314253431, 0.32433559}, // 6454K
			{0.314237575, 0.324320213}, // 6455K
			{0.314221725, 0.32430484}, // 6456K
			{0.31420588, 0.324289471}, // 6457K
			{0.314190041, 0.324274106}, // 6458K
			{0.314174208, 0.324258745}, // 6459K
			{0.31415838, 0.324243388}, // 6460K
			{0.314142559, 0.324228035}, // 6461K
			{0.314126742, 0.324212687}, // 6462K
			{0.314110932, 0.324197342}, // 6463K
			{0.314095127, 0.324182002}, // 6464K
			{0.314079328, 0.324166665}, // 6465K
			{0.314063535, 0.324151333}, // 6466K
			{0.314047747, 0.324136004}, // 6467K
			{0.314031965, 0.32412068}, // 6468K
			{0.314016189, 0.32410536}, // 6469K
			{0.314000418, 0.324090044}, // 6470K
			{0.313984653, 0.324074732}, // 6471K
			{0.313968894, 0.324059424}, // 6472K
			{0.31395314, 0.32404412}, // 6473K
			{0.313937392, 0.32402882}, // 6474K
			{0.31392165, 0.324013524}, // 6475K
			{0.313905913, 0.323998233}, // 6476K
			{0.313890182, 0.323982945}, // 6477K
			{0.313874457, 0.323967662}, // 6478K
			{0.313858737, 0.323952382}, // 6479K
			{0.313843023, 0.323937107}, // 6480K
			{0.313827314, 0.323921835}, // 6481K
			{0.313811611, 0.323906568}, // 6482K
			{0.313795914, 0.323891305}, // 6483K
			{0.313780223, 0.323876045}, // 6484K
			{0.313764537, 0.32386079}, // 6485K
			{0.313748857, 0.323845539}, // 6486K
			{0.313733182, 0.323830292}, // 6487K
			{0.313717513, 0.323815049}, // 6488K
			{0.313701849, 0.32379981}, // 6489K
			{0.313686192, 0.323784575}, // 6490K
			{0.313670539, 0.323769344}, // 6491K
			{0.313654893, 0.323754117}, // 6492K
			{0.313639252, 0.323738895}, // 6493K
			{0.313623617, 0.323723676}, // 6494K
			{0.313607987, 0.323708461}, // 6495K
			{0.313592363, 0.32369325}, // 6496K
			{0.313576744, 0.323678044}, // 6497K
			{0.313561131, 0.323662841}, // 6498K
			{0.313545524, 0.323647643}, // 6499K
			{0.313529922, 0.323632448}, // 6500K
			{0.313514326, 0.323617258}, // 6501K
			{0.313498735, 0.323602071}, // 6502K
			{0.31348315, 0.323586889}, // 6503K
			{0.313467571, 0.32357171}, // 6504K
			{0.313451997, 0.323556536}, // 6505K
			{0.313436429, 0.323541366}, // 6506K
			{0.313420866, 0.323526199}, // 6507K
			{0.313405309, 0.323511037}, // 6508K
			{0.313389757, 0.323495879}, // 6509K
			{0.313374211, 0.323480725}, // 6510K
			{0.313358671, 0.323465575}, // 6511K
			{0.313343136, 0.323450428}, // 6512K
			{0.313327607, 0.323435286}, // 6513K
			{0.313312083, 0.323420148}, // 6514K
			{0.313296565, 0.323405014}, // 6515K
			{0.313281052, 0.323389884}, // 6516K
			{0.313265545, 0.323374758}, // 6517K
			{0.313250043, 0.323359636}, // 6518K
			{0.313234547, 0.323344518}, // 6519K
			{0.313219057, 0.323329403}, // 6520K
			{0.313203572, 0.323314293}, // 6521K
			{0.313188093, 0.323299187}, // 6522K
			{0.313172619, 0.323284085}, // 6523K
			{0.31315715, 0.323268987}, // 6524K
			{0.313141687, 0.323253893}, // 6525K
			{0.31312623, 0.323238803}, // 6526K
			{0.313110778, 0.323223717}, // 6527K
			{0.313095332, 0.323208635}, // 6528K
			{0.313079891, 0.323193557}, // 6529K
			{0.313064456, 0.323178483}, // 6530K
			{0.313049026, 0.323163413}, // 6531K
			{0.313033602, 0.323148347}, // 6532K
			{0.313018183, 0.323133285}, // 6533K
			{0.31300277, 0.323118227}, // 6534K
			{0.312987362, 0.323103173}, // 6535K
			{0.31297196, 0.323088123}, // 6536K
			{0.312956563, 0.323073077}, // 6537K
			{0.312941172, 0.323058035}, // 6538K
			{0.312925786, 0.323042997}, // 6539K
			{0.312910406, 0.323027963}, // 6540K
			{0.312895031, 0.323012933}, // 6541K
			{0.312879662, 0.322997907}, // 6542K
			{0.312864298, 0.322982885}, // 6543K
			{0.31284894, 0.322967867}, // 6544K
			{0.312833587, 0.322952853}, // 6545K
			{0.31281824, 0.322937842}, // 6546K
			{0.312802898, 0.322922836}, // 6547K
			{0.312787561, 0.322907834}, // 6548K
			{0.31277223, 0.322892836}, // 6549K
			{0.312756905, 0.322877842}, // 6550K
			{0.312741585, 0.322862851}, // 6551K
			{0.31272627, 0.322847865}, // 6552K
			{0.312710961, 0.322832883}, // 6553K
			{0.312695657, 0.322817904}, // 6554K
			{0.312680359, 0.32280293}, // 6555K
			{0.312665066, 0.32278796}, // 6556K
			{0.312649778, 0.322772993}, // 6557K
			{0.312634496, 0.322758031}, // 6558K
			{0.31261922, 0.322743072}, // 6559K
			{0.312603949, 0.322728118}, // 6560K
			{0.312588683, 0.322713167}, // 6561K
			{0.312573423, 0.322698221}, // 6562K
			{0.312558168, 0.322683278}, // 6563K
			{0.312542919, 0.322668339}, // 6564K
			{0.312527675, 0.322653404}, // 6565K
			{0.312512436, 0.322638474}, // 6566K
			{0.312497203, 0.322623547}, // 6567K
			{0.312481975, 0.322608624}, // 6568K
			{0.312466753, 0.322593705}, // 6569K
			{0.312451536, 0.32257879}, // 6570K
			{0.312436325, 0.322563879}, // 6571K
			{0.312421119, 0.322548972}, // 6572K
			{0.312405918, 0.322534069}, // 6573K
			{0.312390723, 0.32251917}, // 6574K
			{0.312375533, 0.322504275}, // 6575K
			{0.312360348, 0.322489384}, // 6576K
			{0.312345169, 0.322474496}, // 6577K
			{0.312329996, 0.322459613}, // 6578K
			{0.312314827, 0.322444733}, // 6579K
			{0.312299664, 0.322429858}, // 6580K
			{0.312284507, 0.322414986}, // 6581K
			{0.312269355, 0.322400119}, // 6582K
			{0.312254208, 0.322385255}, // 6583K
			{0.312239066, 0.322370396}, // 6584K
			{0.31222393, 0.32235554}, // 6585K
			{0.3122088, 0.322340688}, // 6586K
			{0.312193674, 0.32232584}, // 6587K
			{0.312178554, 0.322310996}, // 6588K
			{0.31216344, 0.322296156}, // 6589K
			{0.31214833, 0.32228132}, // 6590K
			{0.312133226, 0.322266488}, // 6591K
			{0.312118128, 0.322251659}, // 6592K
			{0.312103035, 0.322236835}, // 6593K
			{0.312087947, 0.322222015}, // 6594K
			{0.312072864, 0.322207198}, // 6595K
			{0.312057787, 0.322192386}, // 6596K
			{0.312042715, 0.322177577}, // 6597K
			{0.312027649, 0.322162772}, // 6598K
			{0.312012588, 0.322147972}, // 6599K
			{0.311997532, 0.322133175}, // 6600K
			{0.311982481, 0.322118382}, // 6601K
			{0.311967436, 0.322103593}, // 6602K
			{0.311952397, 0.322088808}, // 6603K
			{0.311937362, 0.322074026}, // 6604K
			{0.311922333, 0.322059249}, // 6605K
			{0.311907309, 0.322044476}, // 6606K
			{0.31189229, 0.322029706}, // 6607K
			{0.311877277, 0.322014941}, // 6608K
			{0.311862269, 0.322000179}, // 6609K
			{0.311847267, 0.321985421}, // 6610K
			{0.311832269, 0.321970667}, // 6611K
			{0.311817277, 0.321955918}, // 6612K
			{0.311802291, 0.321941171}, // 6613K
			{0.311787309, 0.321926429}, // 6614K
			{0.311772333, 0.321911691}, // 6615K
			{0.311757362, 0.321896957}, // 6616K
			{0.311742397, 0.321882226}, // 6617K
			{0.311727436, 0.3218675}, // 6618K
			{0.311712481, 0.321852777}, // 6619K
			{0.311697532, 0.321838059}, // 6620K
			{0.311682587, 0.321823344}, // 6621K
			{0.311667648, 0.321808633}, // 6622K
			{0.311652714, 0.321793926}, // 6623K
			{0.311637786, 0.321779223}, // 6624K
			{0.311622862, 0.321764523}, // 6625K
			{0.311607944, 0.321749828}, // 6626K
			{0.311593032, 0.321735136}, // 6627K
			{0.311578124, 0.321720449}, // 6628K
			{0.311563222, 0.321705765}, // 6629K
			{0.311548325, 0.321691085}, // 6630K
			{0.311533433, 0.321676409}, // 6631K
			{0.311518547, 0.321661737}, // 6632K
			{0.311503665, 0.321647069}, // 6633K
			{0.311488789, 0.321632405}, // 6634K
			{0.311473919, 0.321617744}, // 6635K
			{0.311459053, 0.321603088}, // 6636K
			{0.311444193, 0.321588435}, // 6637K
			{0.311429338, 0.321573786}, // 6638K
			{0.311414488, 0.321559141}, // 6639K
			{0.311399644, 0.3215445}, // 6640K
			{0.311384804, 0.321529863}, // 6641K
			{0.31136997, 0.32151523}, // 6642K
			{0.311355141, 0.3215006}, // 6643K
			{0.311340318, 0.321485975}, // 6644K
			{0.311325499, 0.321471353}, // 6645K
			{0.311310686, 0.321456735}, // 6646K
			{0.311295878, 0.321442121}, // 6647K
			{0.311281075, 0.321427511}, // 6648K
			{0.311266278, 0.321412905}, // 6649K
			{0.311251485, 0.321398302}, // 6650K
			{0.311236698, 0.321383704}, // 6651K
			{0.311221916, 0.321369109}, // 6652K
			{0.31120714, 0.321354518}, // 6653K
			{0.311192368, 0.321339931}, // 6654K
			{0.311177602, 0.321325348}, // 6655K
			{0.31116284, 0.321310769}, // 6656K
			{0.311148085, 0.321296194}, // 6657K
			{0.311133334, 0.321281622}, // 6658K
			{0.311118588, 0.321267055}, // 6659K
			{0.311103848, 0.321252491}, // 6660K
			{0.311089113, 0.321237931}, // 6661K
			{0.311074382, 0.321223375}, // 6662K
			{0.311059658, 0.321208822}, // 6663K
			{0.311044938, 0.321194274}, // 6664K
			{0.311030223, 0.321179729}, // 6665K
			{0.311015514, 0.321165188}, // 6666K
			{0.31100081, 0.321150652}, // 6667K
			{0.310986111, 0.321136118}, // 6668K
			{0.310971417, 0.321121589}, // 6669K
			{0.310956728, 0.321107064}, // 6670K
			{0.310942045, 0.321092542}, // 6671K
			{0.310927366, 0.321078025}, // 6672K
			{0.310912693, 0.321063511}, // 6673K
			{0.310898025, 0.321049001}, // 6674K
			{0.310883362, 0.321034494}, // 6675K
			{0.310868704, 0.321019992}, // 6676K
			{0.310854052, 0.321005493}, // 6677K
			{0.310839404, 0.320990999}, // 6678K
			{0.310824762, 0.320976508}, // 6679K
			{0.310810125, 0.320962021}, // 6680K
			{0.310795493, 0.320947537}, // 6681K
			{0.310780866, 0.320933058}, // 6682K
			{0.310766244, 0.320918582}, // 6683K
			{0.310751627, 0.320904111}, // 6684K
			{0.310737015, 0.320889643}, // 6685K
			{0.310722409, 0.320875179}, // 6686K
			{0.310707808, 0.320860718}, // 6687K
			{0.310693211, 0.320846262}, // 6688K
			{0.31067862, 0.320831809}, // 6689K
			{0.310664034, 0.32081736}, // 6690K
			{0.310649453, 0.320802915}, // 6691K
			{0.310634878, 0.320788474}, // 6692K
			{0.310620307, 0.320774036}, // 6693K
			{0.310605741, 0.320759603}, // 6694K
			{0.310591181, 0.320745173}, // 6695K
			{0.310576626, 0.320730747}, // 6696K
			{0.310562075, 0.320716325}, // 6697K
			{0.31054753, 0.320701906}, // 6698K
			{0.31053299, 0.320687492}, // 6699K
			{0.310518455, 0.320673081}, // 6700K
			{0.310503925, 0.320658674}, // 6701K
			{0.3104894, 0.320644271}, // 6702K
			{0.31047488, 0.320629872}, // 6703K
			{0.310460366, 0.320615476}, // 6704K
			{0.310445856, 0.320601084}, // 6705K
			{0.310431352, 0.320586696}, // 6706K
			{0.310416852, 0.320572312}, // 6707K
			{0.310402358, 0.320557932}, // 6708K
			{0.310387868, 0.320543555}, // 6709K
			{0.310373384, 0.320529182}, // 6710K
			{0.310358905, 0.320514813}, // 6711K
			{0.310344431, 0.320500448}, // 6712K
			{0.310329962, 0.320486087}, // 6713K
			{0.310315498, 0.320471729}, // 6714K
			{0.310301039, 0.320457375}, // 6715K
			{0.310286585, 0.320443025}, // 6716K
			{0.310272136, 0.320428679}, // 6717K
			{0.310257692, 0.320414336}, // 6718K
			{0.310243253, 0.320399998}, // 6719K
			{0.31022882, 0.320385663}, // 6720K
			{0.310214391, 0.320371332}, // 6721K
			{0.310199967, 0.320357004}, // 6722K
			{0.310185549, 0.320342681}, // 6723K
			{0.310171135, 0.320328361}, // 6724K
			{0.310156726, 0.320314045}, // 6725K
			{0.310142323, 0.320299733}, // 6726K
			{0.310127924, 0.320285424}, // 6727K
			{0.310113531, 0.320271119}, // 6728K
			{0.310099142, 0.320256818}, // 6729K
			{0.310084759, 0.320242521}, // 6730K
			{0.31007038, 0.320228228}, // 6731K
			{0.310056007, 0.320213938}, // 6732K
			{0.310041638, 0.320199652}, // 6733K
			{0.310027275, 0.32018537}, // 6734K
			{0.310012917, 0.320171092}, // 6735K
			{0.309998563, 0.320156817}, // 6736K
			{0.309984215, 0.320142547}, // 6737K
			{0.309969871, 0.32012828}, // 6738K
			{0.309955533, 0.320114016}, // 6739K
			{0.3099412, 0.320099757}, // 6740K
			{0.309926871, 0.320085501}, // 6741K
			{0.309912548, 0.320071249}, // 6742K
			{0.309898229, 0.320057001}, // 6743K
			{0.309883916, 0.320042756}, // 6744K
			{0.309869607, 0.320028515}, // 6745K
			{0.309855304, 0.320014278}, // 6746K
			{0.309841005, 0.320000045}, // 6747K
			{0.309826712, 0.319985816}, // 6748K
			{0.309812423, 0.31997159}, // 6749K
			{0.30979814, 0.319957368}, // 6750K
			{0.309783861, 0.31994315}, // 6751K
			{0.309769587, 0.319928935}, // 6752K
			{0.309755318, 0.319914724}, // 6753K
			{0.309741055, 0.319900517}, // 6754K
			{0.309726796, 0.319886314}, // 6755K
			{0.309712542, 0.319872115}, // 6756K
			{0.309698293, 0.319857919}, // 6757K
			{0.309684049, 0.319843727}, // 6758K
			{0.30966981, 0.319829539}, // 6759K
			{0.309655576, 0.319815354}, // 6760K
			{0.309641347, 0.319801173}, // 6761K
			{0.309627123, 0.319786996}, // 6762K
			{0.309612904, 0.319772823}, // 6763K
			{0.30959869, 0.319758653}, // 6764K
			{0.30958448, 0.319744487}, // 6765K
			{0.309570276, 0.319730325}, // 6766K
			{0.309556076, 0.319716166}, // 6767K
			{0.309541882, 0.319702012}, // 6768K
			{0.309527692, 0.319687861}, // 6769K
			{0.309513508, 0.319673713}, // 6770K
			{0.309499328, 0.31965957}, // 6771K
			{0.309485153, 0.31964543}, // 6772K
			{0.309470983, 0.319631294}, // 6773K
			{0.309456818, 0.319617162}, // 6774K
			{0.309442658, 0.319603033}, // 6775K
			{0.309428503, 0.319588908}, // 6776K
			{0.309414353, 0.319574787}, // 6777K
			{0.309400207, 0.319560669}, // 6778K
			{0.309386067, 0.319546555}, // 6779K
			{0.309371931, 0.319532445}, // 6780K
			{0.309357801, 0.319518339}, // 6781K
			{0.309343675, 0.319504236}, // 6782K
			{0.309329554, 0.319490137}, // 6783K
			{0.309315438, 0.319476042}, // 6784K
			{0.309301327, 0.319461951}, // 6785K
			{0.309287221, 0.319447863}, // 6786K
			{0.309273119, 0.319433779}, // 6787K
			{0.309259023, 0.319419698}, // 6788K
			{0.309244932, 0.319405622}, // 6789K
			{0.309230845, 0.319391549}, // 6790K
			{0.309216763, 0.319377479}, // 6791K
			{0.309202686, 0.319363414}, // 6792K
			{0.309188614, 0.319349352}, // 6793K
			{0.309174547, 0.319335294}, // 6794K
			{0.309160485, 0.319321239}, // 6795K
			{0.309146427, 0.319307188}, // 6796K
			{0.309132375, 0.319293141}, // 6797K
			{0.309118327, 0.319279098}, // 6798K
			{0.309104284, 0.319265058}, // 6799K
			{0.309090246, 0.319251022}, // 6800K
			{0.309076213, 0.31923699}, // 6801K
			{0.309062185, 0.319222961}, // 6802K
			{0.309048161, 0.319208936}, // 6803K
			{0.309034143, 0.319194915}, // 6804K
			{0.309020129, 0.319180897}, // 6805K
			{0.30900612, 0.319166883}, // 6806K
			{0.308992116, 0.319152873}, // 6807K
			{0.308978117, 0.319138866}, // 6808K
			{0.308964123, 0.319124864}, // 6809K
			{0.308950133, 0.319110864}, // 6810K
			{0.308936148, 0.319096869}, // 6811K
			{0.308922168, 0.319082877}, // 6812K
			{0.308908193, 0.319068889}, // 6813K
			{0.308894223, 0.319054905}, // 6814K
			{0.308880258, 0.319040924}, // 6815K
			{0.308866297, 0.319026947}, // 6816K
			{0.308852341, 0.319012973}, // 6817K
			{0.30883839, 0.318999003}, // 6818K
			{0.308824444, 0.318985037}, // 6819K
			{0.308810503, 0.318971075}, // 6820K
			{0.308796566, 0.318957116}, // 6821K
			{0.308782635, 0.318943161}, // 6822K
			{0.308768708, 0.31892921}, // 6823K
			{0.308754786, 0.318915262}, // 6824K
			{0.308740869, 0.318901318}, // 6825K
			{0.308726956, 0.318887377}, // 6826K
			{0.308713048, 0.318873441}, // 6827K
			{0.308699145, 0.318859507}, // 6828K
			{0.308685247, 0.318845578}, // 6829K
			{0.308671354, 0.318831652}, // 6830K
			{0.308657465, 0.31881773}, // 6831K
			{0.308643582, 0.318803812}, // 6832K
			{0.308629703, 0.318789897}, // 6833K
			{0.308615829, 0.318775986}, // 6834K
			{0.308601959, 0.318762078}, // 6835K
			{0.308588095, 0.318748174}, // 6836K
			{0.308574235, 0.318734274}, // 6837K
			{0.30856038, 0.318720377}, // 6838K
			{0.308546529, 0.318706485}, // 6839K
			{0.308532684, 0.318692595}, // 6840K
			{0.308518843, 0.31867871}, // 6841K
			{0.308505007, 0.318664828}, // 6842K
			{0.308491176, 0.318650949}, // 6843K
			{0.308477349, 0.318637075}, // 6844K
			{0.308463528, 0.318623204}, // 6845K
			{0.308449711, 0.318609336}, // 6846K
			{0.308435898, 0.318595472}, // 6847K
			{0.308422091, 0.318581612}, // 6848K
			{0.308408288, 0.318567756}, // 6849K
			{0.30839449, 0.318553903}, // 6850K
			{0.308380697, 0.318540054}, // 6851K
			{0.308366909, 0.318526208}, // 6852K
			{0.308353125, 0.318512366}, // 6853K
			{0.308339346, 0.318498528}, // 6854K
			{0.308325571, 0.318484693}, // 6855K
			{0.308311802, 0.318470862}, // 6856K
			{0.308298037, 0.318457035}, // 6857K
			{0.308284277, 0.318443211}, // 6858K
			{0.308270522, 0.318429391}, // 6859K
			{0.308256771, 0.318415574}, // 6860K
			{0.308243025, 0.318401761}, // 6861K
			{0.308229284, 0.318387952}, // 6862K
			{0.308215547, 0.318374146}, // 6863K
			{0.308201816, 0.318360344}, // 6864K
			{0.308188089, 0.318346546}, // 6865K
			{0.308174366, 0.318332751}, // 6866K
			{0.308160649, 0.31831896}, // 6867K
			{0.308146936, 0.318305172}, // 6868K
			{0.308133228, 0.318291388}, // 6869K
			{0.308119524, 0.318277608}, // 6870K
			{0.308105825, 0.318263831}, // 6871K
			{0.308092131, 0.318250058}, // 6872K
			{0.308078442, 0.318236289}, // 6873K
			{0.308064757, 0.318222523}, // 6874K
			{0.308051077, 0.31820876}, // 6875K
			{0.308037402, 0.318195002}, // 6876K
			{0.308023731, 0.318181247}, // 6877K
			{0.308010065, 0.318167495}, // 6878K
			{0.307996404, 0.318153747}, // 6879K
			{0.307982747, 0.318140003}, // 6880K
			{0.307969095, 0.318126262}, // 6881K
			{0.307955448, 0.318112525}, // 6882K
			{0.307941805, 0.318098792}, // 6883K
			{0.307928167, 0.318085062}, // 6884K
			{0.307914534, 0.318071336}, // 6885K
			{0.307900906, 0.318057613}, // 6886K
			{0.307887282, 0.318043894}, // 6887K
			{0.307873663, 0.318030178}, // 6888K
			{0.307860048, 0.318016467}, // 6889K
			{0.307846438, 0.318002758}, // 6890K
			{0.307832833, 0.317989054}, // 6891K
			{0.307819232, 0.317975353}, // 6892K
			{0.307805636, 0.317961655}, // 6893K
			{0.307792045, 0.317947961}, // 6894K
			{0.307778458, 0.317934271}, // 6895K
			{0.307764876, 0.317920584}, // 6896K
			{0.307751299, 0.317906901}, // 6897K
			{0.307737726, 0.317893221}, // 6898K
			{0.307724158, 0.317879545}, // 6899K
			{0.307710595, 0.317865873}, // 6900K
			{0.307697036, 0.317852204}, // 6901K
			{0.307683482, 0.317838539}, // 6902K
			{0.307669932, 0.317824877}, // 6903K
			{0.307656387, 0.317811219}, // 6904K
			{0.307642847, 0.317797564}, // 6905K
			{0.307629311, 0.317783913}, // 6906K
			{0.30761578, 0.317770266}, // 6907K
			{0.307602254, 0.317756622}, // 6908K
			{0.307588732, 0.317742982}, // 6909K
			{0.307575215, 0.317729345}, // 6910K
			{0.307561703, 0.317715712}, // 6911K
			{0.307548195, 0.317702083}, // 6912K
			{0.307534691, 0.317688457}, // 6913K
			{0.307521193, 0.317674834}, // 6914K
			{0.307507698, 0.317661215}, // 6915K
			{0.307494209, 0.3176476}, // 6916K
			{0.307480724, 0.317633989}, // 6917K
			{0.307467244, 0.31762038}, // 6918K
			{0.307453768, 0.317606776}, // 6919K
			{0.307440297, 0.317593175}, // 6920K
			{0.30742683, 0.317579577}, // 6921K
			{0.307413369, 0.317565983}, // 6922K
			{0.307399911, 0.317552393}, // 6923K
			{0.307386458, 0.317538806}, // 6924K
			{0.30737301, 0.317525223}, // 6925K
			{0.307359567, 0.317511643}, // 6926K
			{0.307346128, 0.317498067}, // 6927K
			{0.307332693, 0.317484495}, // 6928K
			{0.307319263, 0.317470926}, // 6929K
			{0.307305838, 0.31745736}, // 6930K
			{0.307292418, 0.317443798}, // 6931K
			{0.307279001, 0.31743024}, // 6932K
			{0.30726559, 0.317416685}, // 6933K
			{0.307252183, 0.317403134}, // 6934K
			{0.30723878, 0.317389586}, // 6935K
			{0.307225383, 0.317376042}, // 6936K
			{0.307211989, 0.317362501}, // 6937K
			{0.307198601, 0.317348964}, // 6938K
			{0.307185216, 0.31733543}, // 6939K
			{0.307171837, 0.3173219}, // 6940K
			{0.307158462, 0.317308374}, // 6941K
			{0.307145091, 0.317294851}, // 6942K
			{0.307131725, 0.317281331}, // 6943K
			{0.307118364, 0.317267816}, // 6944K
			{0.307105007, 0.317254303}, // 6945K
			{0.307091655, 0.317240794}, // 6946K
			{0.307078307, 0.317227289}, // 6947K
			{0.307064963, 0.317213787}, // 6948K
			{0.307051625, 0.317200289}, // 6949K
			{0.307038291, 0.317186794}, // 6950K
			{0.307024961, 0.317173303}, // 6951K
			{0.307011636, 0.317159815}, // 6952K
			{0.306998315, 0.317146331}, // 6953K
			{0.306984999, 0.317132851}, // 6954K
			{0.306971687, 0.317119374}, // 6955K
			{0.30695838, 0.3171059}, // 6956K
			{0.306945078, 0.31709243}, // 6957K
			{0.30693178, 0.317078963}, // 6958K
			{0.306918486, 0.3170655}, // 6959K
			{0.306905197, 0.317052041}, // 6960K
			{0.306891913, 0.317038585}, // 6961K
			{0.306878633, 0.317025132}, // 6962K
			{0.306865358, 0.317011683}, // 6963K
			{0.306852087, 0.316998238}, // 6964K
			{0.30683882, 0.316984796}, // 6965K
			{0.306825558, 0.316971358}, // 6966K
			{0.306812301, 0.316957923}, // 6967K
			{0.306799048, 0.316944491}, // 6968K
			{0.306785799, 0.316931063}, // 6969K
			{0.306772555, 0.316917639}, // 6970K
			{0.306759316, 0.316904218}, // 6971K
			{0.306746081, 0.316890801}, // 6972K
			{0.306732851, 0.316877387}, // 6973K
			{0.306719624, 0.316863976}, // 6974K
			{0.306706403, 0.31685057}, // 6975K
			{0.306693186, 0.316837166}, // 6976K
			{0.306679973, 0.316823766}, // 6977K
			{0.306666765, 0.31681037}, // 6978K
			{0.306653562, 0.316796977}, // 6979K
			{0.306640362, 0.316783588}, // 6980K
			{0.306627168, 0.316770202}, // 6981K
			{0.306613978, 0.316756819}, // 6982K
			{0.306600792, 0.31674344}, // 6983K
			{0.306587611, 0.316730065}, // 6984K
			{0.306574434, 0.316716693}, // 6985K
			{0.306561261, 0.316703325}, // 6986K
			{0.306548094, 0.31668996}, // 6987K
			{0.30653493, 0.316676598}, // 6988K
			{0.306521771, 0.31666324}, // 6989K
			{0.306508617, 0.316649886}, // 6990K
			{0.306495466, 0.316636535}, // 6991K
			{0.306482321, 0.316623187}, // 6992K
			{0.30646918, 0.316609843}, // 6993K
			{0.306456043, 0.316596502}, // 6994K
			{0.306442911, 0.316583165}, // 6995K
			{0.306429783, 0.316569832}, // 6996K
			{0.306416659, 0.316556502}, // 6997K
			{0.30640354, 0.316543175}, // 6998K
			{0.306390426, 0.316529852}, // 6999K
			{0.306377316, 0.316516532}, // 7000K
			{0.30636421, 0.316503216}, // 7001K
			{0.306351109, 0.316489903}, // 7002K
			{0.306338012, 0.316476594}, // 7003K
			{0.306324919, 0.316463288}, // 7004K
			{0.306311831, 0.316449986}, // 7005K
			{0.306298748, 0.316436687}, // 7006K
			{0.306285669, 0.316423391}, // 7007K
			{0.306272594, 0.316410099}, // 7008K
			{0.306259523, 0.316396811}, // 7009K
			{0.306246458, 0.316383526}, // 7010K
			{0.306233396, 0.316370244}, // 7011K
			{0.306220339, 0.316356966}, // 7012K
			{0.306207286, 0.316343691}, // 7013K
			{0.306194238, 0.31633042}, // 7014K
			{0.306181194, 0.316317153}, // 7015K
			{0.306168155, 0.316303888}, // 7016K
			{0.306155119, 0.316290627}, // 7017K
			{0.306142089, 0.31627737}, // 7018K
			{0.306129062, 0.316264116}, // 7019K
			{0.30611604, 0.316250866}, // 7020K
			{0.306103023, 0.316237619}, // 7021K
			{0.30609001, 0.316224375}, // 7022K
			{0.306077001, 0.316211135}, // 7023K
			{0.306063997, 0.316197898}, // 7024K
			{0.306050997, 0.316184665}, // 7025K
			{0.306038001, 0.316171435}, // 7026K
			{0.30602501, 0.316158209}, // 7027K
			{0.306012023, 0.316144986}, // 7028K
			{0.305999041, 0.316131767}, // 7029K
			{0.305986062, 0.316118551}, // 7030K
			{0.305973089, 0.316105338}, // 7031K
			{0.305960119, 0.316092129}, // 7032K
			{0.305947154, 0.316078923}, // 7033K
			{0.305934194, 0.316065721}, // 7034K
			{0.305921237, 0.316052522}, // 7035K
			{0.305908285, 0.316039327}, // 7036K
			{0.305895338, 0.316026135}, // 7037K
			{0.305882395, 0.316012947}, // 7038K
			{0.305869456, 0.315999762}, // 7039K
			{0.305856521, 0.31598658}, // 7040K
			{0.305843591, 0.315973402}, // 7041K
			{0.305830665, 0.315960227}, // 7042K
			{0.305817744, 0.315947056}, // 7043K
			{0.305804827, 0.315933888}, // 7044K
			{0.305791914, 0.315920723}, // 7045K
			{0.305779006, 0.315907562}, // 7046K
			{0.305766101, 0.315894405}, // 7047K
			{0.305753202, 0.31588125}, // 7048K
			{0.305740306, 0.3158681}, // 7049K
			{0.305727415, 0.315854952}, // 7050K
			{0.305714528, 0.315841808}, // 7051K
			{0.305701646, 0.315828668}, // 7052K
			{0.305688768, 0.315815531}, // 7053K
			{0.305675894, 0.315802397}, // 7054K
			{0.305663025, 0.315789267}, // 7055K
			{0.305650159, 0.31577614}, // 7056K
			{0.305637299, 0.315763016}, // 7057K
			{0.305624442, 0.315749896}, // 7058K
			{0.30561159, 0.31573678}, // 7059K
			{0.305598742, 0.315723667}, // 7060K
			{0.305585899, 0.315710557}, // 7061K
			{0.305573059, 0.31569745}, // 7062K
			{0.305560224, 0.315684347}, // 7063K
			{0.305547394, 0.315671248}, // 7064K
			{0.305534567, 0.315658152}, // 7065K
			{0.305521745, 0.315645059}, // 7066K
			{0.305508928, 0.31563197}, // 7067K
			{0.305496114, 0.315618884}, // 7068K
			{0.305483305, 0.315605801}, // 7069K
			{0.3054705, 0.315592722}, // 7070K
			{0.3054577, 0.315579646}, // 7071K
			{0.305444903, 0.315566574}, // 7072K
			{0.305432111, 0.315553505}, // 7073K
			{0.305419324, 0.315540439}, // 7074K
			{0.30540654, 0.315527377}, // 7075K
			{0.305393761, 0.315514318}, // 7076K
			{0.305380986, 0.315501263}, // 7077K
			{0.305368216, 0.315488211}, // 7078K
			{0.305355449, 0.315475162}, // 7079K
			{0.305342687, 0.315462117}, // 7080K
			{0.30532993, 0.315449075}, // 7081K
			{0.305317176, 0.315436037}, // 7082K
			{0.305304427, 0.315423002}, // 7083K
			{0.305291682, 0.31540997}, // 7084K
			{0.305278941, 0.315396942}, // 7085K
			{0.305266205, 0.315383917}, // 7086K
			{0.305253473, 0.315370895}, // 7087K
			{0.305240745, 0.315357877}, // 7088K
			{0.305228021, 0.315344862}, // 7089K
			{0.305215302, 0.315331851}, // 7090K
			{0.305202587, 0.315318843}, // 7091K
			{0.305189876, 0.315305838}, // 7092K
			{0.305177169, 0.315292837}, // 7093K
			{0.305164467, 0.315279839}, // 7094K
			{0.305151769, 0.315266845}, // 7095K
			{0.305139075, 0.315253854}, // 7096K
			{0.305126385, 0.315240866}, // 7097K
			{0.3051137, 0.315227881}, // 7098K
			{0.305101018, 0.3152149}, // 7099K
			{0.305088341, 0.315201923}, // 7100K
			{0.305075669, 0.315188949}, // 7101K
			{0.305063, 0.315175978}, // 7102K
			{0.305050336, 0.31516301}, // 7103K
			{0.305037676, 0.315150046}, // 7104K
			{0.30502502, 0.315137085}, // 7105K
			{0.305012369, 0.315124128}, // 7106K
			{0.304999721, 0.315111174}, // 7107K
			{0.304987078, 0.315098223}, // 7108K
			{0.304974439, 0.315085275}, // 7109K
			{0.304961805, 0.315072331}, // 7110K
			{0.304949174, 0.315059391}, // 7111K
			{0.304936548, 0.315046453}, // 7112K
			{0.304923926, 0.315033519}, // 7113K
			{0.304911308, 0.315020589}, // 7114K
			{0.304898694, 0.315007662}, // 7115K
			{0.304886085, 0.314994738}, // 7116K
			{0.30487348, 0.314981817}, // 7117K
			{0.304860879, 0.3149689}, // 7118K
			{0.304848282, 0.314955986}, // 7119K
			{0.304835689, 0.314943076}, // 7120K
			{0.304823101, 0.314930169}, // 7121K
			{0.304810517, 0.314917265}, // 7122K
			{0.304797936, 0.314904364}, // 7123K
			{0.304785361, 0.314891467}, // 7124K
			{0.304772789, 0.314878573}, // 7125K
			{0.304760221, 0.314865683}, // 7126K
			{0.304747658, 0.314852796}, // 7127K
			{0.304735099, 0.314839912}, // 7128K
			{0.304722544, 0.314827032}, // 7129K
			{0.304709993, 0.314814155}, // 7130K
			{0.304697447, 0.314801281}, // 7131K
			{0.304684904, 0.314788411}, // 7132K
			{0.304672366, 0.314775544}, // 7133K
			{0.304659832, 0.31476268}, // 7134K
			{0.304647302, 0.31474982}, // 7135K
			{0.304634777, 0.314736962}, // 7136K
			{0.304622255, 0.314724109}, // 7137K
			{0.304609738, 0.314711258}, // 7138K
			{0.304597224, 0.314698411}, // 7139K
			{0.304584715, 0.314685568}, // 7140K
			{0.304572211, 0.314672727}, // 7141K
			{0.30455971, 0.31465989}, // 7142K
			{0.304547213, 0.314647056}, // 7143K
			{0.304534721, 0.314634226}, // 7144K
			{0.304522232, 0.314621399}, // 7145K
			{0.304509748, 0.314608575}, // 7146K
			{0.304497268, 0.314595754}, // 7147K
			{0.304484793, 0.314582937}, // 7148K
			{0.304472321, 0.314570123}, // 7149K
			{0.304459853, 0.314557313}, // 7150K
			{0.30444739, 0.314544506}, // 7151K
			{0.304434931, 0.314531702}, // 7152K
			{0.304422475, 0.314518901}, // 7153K
			{0.304410024, 0.314506104}, // 7154K
			{0.304397578, 0.31449331}, // 7155K
			{0.304385135, 0.314480519}, // 7156K
			{0.304372696, 0.314467732}, // 7157K
			{0.304360262, 0.314454948}, // 7158K
			{0.304347831, 0.314442167}, // 7159K
			{0.304335405, 0.31442939}, // 7160K
			{0.304322983, 0.314416616}, // 7161K
			{0.304310565, 0.314403845}, // 7162K
			{0.304298151, 0.314391078}, // 7163K
			{0.304285741, 0.314378313}, // 7164K
			{0.304273336, 0.314365552}, // 7165K
			{0.304260934, 0.314352795}, // 7166K
			{0.304248537, 0.314340041}, // 7167K
			{0.304236144, 0.31432729}, // 7168K
			{0.304223754, 0.314314542}, // 7169K
			{0.304211369, 0.314301798}, // 7170K
			{0.304198988, 0.314289056}, // 7171K
			{0.304186611, 0.314276319}, // 7172K
			{0.304174239, 0.314263584}, // 7173K
			{0.30416187, 0.314250853}, // 7174K
			{0.304149505, 0.314238125}, // 7175K
			{0.304137145, 0.3142254}, // 7176K
			{0.304124788, 0.314212679}, // 7177K
			{0.304112436, 0.314199961}, // 7178K
			{0.304100088, 0.314187246}, // 7179K
			{0.304087744, 0.314174535}, // 7180K
			{0.304075404, 0.314161826}, // 7181K
			{0.304063068, 0.314149122}, // 7182K
			{0.304050736, 0.31413642}, // 7183K
			{0.304038408, 0.314123722}, // 7184K
			{0.304026084, 0.314111027}, // 7185K
			{0.304013764, 0.314098335}, // 7186K
			{0.304001449, 0.314085646}, // 7187K
			{0.303989137, 0.314072961}, // 7188K
			{0.30397683, 0.314060279}, // 7189K
			{0.303964526, 0.3140476}, // 7190K
			{0.303952227, 0.314034925}, // 7191K
			{0.303939932, 0.314022253}, // 7192K
			{0.303927641, 0.314009584}, // 7193K
			{0.303915354, 0.313996918}, // 7194K
			{0.303903071, 0.313984256}, // 7195K
			{0.303890792, 0.313971597}, // 7196K
			{0.303878517, 0.313958941}, // 7197K
			{0.303866246, 0.313946289}, // 7198K
			{0.303853979, 0.31393364}, // 7199K
			{0.303841716, 0.313920994}, // 7200K
			{0.303829457, 0.313908351}, // 7201K
			{0.303817203, 0.313895712}, // 7202K
			{0.303804952, 0.313883075}, // 7203K
			{0.303792705, 0.313870443}, // 7204K
			{0.303780463, 0.313857813}, // 7205K
			{0.303768224, 0.313845186}, // 7206K
			{0.30375599, 0.313832563}, // 7207K
			{0.303743759, 0.313819944}, // 7208K
			{0.303731533, 0.313807327}, // 7209K
			{0.303719311, 0.313794714}, // 7210K
			{0.303707092, 0.313782103}, // 7211K
			{0.303694878, 0.313769497}, // 7212K
			{0.303682668, 0.313756893}, // 7213K
			{0.303670461, 0.313744293}, // 7214K
			{0.303658259, 0.313731696}, // 7215K
			{0.303646061, 0.313719102}, // 7216K
			{0.303633867, 0.313706511}, // 7217K
			{0.303621676, 0.313693924}, // 7218K
			{0.30360949, 0.31368134}, // 7219K
			{0.303597308, 0.313668759}, // 7220K
			{0.30358513, 0.313656181}, // 7221K
			{0.303572956, 0.313643607}, // 7222K
			{0.303560786, 0.313631036}, // 7223K
			{0.30354862, 0.313618468}, // 7224K
			{0.303536457, 0.313605903}, // 7225K
			{0.303524299, 0.313593342}, // 7226K
			{0.303512145, 0.313580784}, // 7227K
			{0.303499995, 0.313568229}, // 7228K
			{0.303487849, 0.313555677}, // 7229K
			{0.303475707, 0.313543129}, // 7230K
			{0.303463569, 0.313530584}, // 7231K
			{0.303451435, 0.313518042}, // 7232K
			{0.303439305, 0.313505503}, // 7233K
			{0.303427178, 0.313492967}, // 7234K
			{0.303415056, 0.313480435}, // 7235K
			{0.303402938, 0.313467906}, // 7236K
			{0.303390824, 0.31345538}, // 7237K
			{0.303378714, 0.313442858}, // 7238K
			{0.303366608, 0.313430338}, // 7239K
			{0.303354505, 0.313417822}, // 7240K
			{0.303342407, 0.313405309}, // 7241K
			{0.303330313, 0.3133928}, // 7242K
			{0.303318222, 0.313380293}, // 7243K
			{0.303306136, 0.31336779}, // 7244K
			{0.303294054, 0.31335529}, // 7245K
			{0.303281975, 0.313342793}, // 7246K
			{0.303269901, 0.313330299}, // 7247K
			{0.30325783, 0.313317809}, // 7248K
			{0.303245764, 0.313305322}, // 7249K
			{0.303233701, 0.313292838}, // 7250K
			{0.303221643, 0.313280357}, // 7251K
			{0.303209588, 0.31326788}, // 7252K
			{0.303197538, 0.313255405}, // 7253K
			{0.303185491, 0.313242934}, // 7254K
			{0.303173448, 0.313230467}, // 7255K
			{0.303161409, 0.313218002}, // 7256K
			{0.303149374, 0.31320554}, // 7257K
			{0.303137344, 0.313193082}, // 7258K
			{0.303125317, 0.313180627}, // 7259K
			{0.303113294, 0.313168175}, // 7260K
			{0.303101274, 0.313155727}, // 7261K
			{0.303089259, 0.313143281}, // 7262K
			{0.303077248, 0.313130839}, // 7263K
			{0.303065241, 0.3131184}, // 7264K
			{0.303053238, 0.313105964}, // 7265K
			{0.303041238, 0.313093532}, // 7266K
			{0.303029243, 0.313081102}, // 7267K
			{0.303017251, 0.313068676}, // 7268K
			{0.303005264, 0.313056253}, // 7269K
			{0.30299328, 0.313043833}, // 7270K
			{0.3029813, 0.313031417}, // 7271K
			{0.302969324, 0.313019003}, // 7272K
			{0.302957352, 0.313006593}, // 7273K
			{0.302945384, 0.312994186}, // 7274K
			{0.30293342, 0.312981782}, // 7275K
			{0.30292146, 0.312969381}, // 7276K
			{0.302909504, 0.312956984}, // 7277K
			{0.302897552, 0.31294459}, // 7278K
			{0.302885603, 0.312932199}, // 7279K
			{0.302873659, 0.312919811}, // 7280K
			{0.302861718, 0.312907426}, // 7281K
			{0.302849782, 0.312895044}, // 7282K
			{0.302837849, 0.312882666}, // 7283K
			{0.30282592, 0.312870291}, // 7284K
			{0.302813995, 0.312857919}, // 7285K
			{0.302802074, 0.31284555}, // 7286K
			{0.302790157, 0.312833185}, // 7287K
			{0.302778243, 0.312820822}, // 7288K
			{0.302766334, 0.312808463}, // 7289K
			{0.302754428, 0.312796107}, // 7290K
			{0.302742527, 0.312783754}, // 7291K
			{0.302730629, 0.312771404}, // 7292K
			{0.302718735, 0.312759057}, // 7293K
			{0.302706845, 0.312746714}, // 7294K
			{0.302694959, 0.312734374}, // 7295K
			{0.302683077, 0.312722037}, // 7296K
			{0.302671199, 0.312709703}, // 7297K
			{0.302659324, 0.312697372}, // 7298K
			{0.302647454, 0.312685045}, // 7299K
			{0.302635587, 0.31267272}, // 7300K
			{0.302623724, 0.312660399}, // 7301K
			{0.302611865, 0.312648081}, // 7302K
			{0.30260001, 0.312635766}, // 7303K
			{0.302588159, 0.312623454}, // 7304K
			{0.302576312, 0.312611146}, // 7305K
			{0.302564468, 0.31259884}, // 7306K
			{0.302552629, 0.312586538}, // 7307K
			{0.302540793, 0.312574239}, // 7308K
			{0.302528961, 0.312561943}, // 7309K
			{0.302517133, 0.31254965}, // 7310K
			{0.302505309, 0.312537361}, // 7311K
			{0.302493489, 0.312525074}, // 7312K
			{0.302481672, 0.312512791}, // 7313K
			{0.30246986, 0.312500511}, // 7314K
			{0.302458051, 0.312488234}, // 7315K
			{0.302446246, 0.31247596}, // 7316K
			{0.302434445, 0.312463689}, // 7317K
			{0.302422648, 0.312451422}, // 7318K
			{0.302410855, 0.312439157}, // 7319K
			{0.302399065, 0.312426896}, // 7320K
			{0.302387279, 0.312414638}, // 7321K
			{0.302375497, 0.312402383}, // 7322K
			{0.302363719, 0.312390131}, // 7323K
			{0.302351945, 0.312377882}, // 7324K
			{0.302340175, 0.312365637}, // 7325K
			{0.302328408, 0.312353394}, // 7326K
			{0.302316646, 0.312341155}, // 7327K
			{0.302304887, 0.312328919}, // 7328K
			{0.302293132, 0.312316686}, // 7329K
			{0.302281381, 0.312304456}, // 7330K
			{0.302269633, 0.312292229}, // 7331K
			{0.30225789, 0.312280006}, // 7332K
			{0.30224615, 0.312267785}, // 7333K
			{0.302234414, 0.312255568}, // 7334K
			{0.302222682, 0.312243354}, // 7335K
			{0.302210954, 0.312231143}, // 7336K
			{0.302199229, 0.312218935}, // 7337K
			{0.302187508, 0.31220673}, // 7338K
			{0.302175792, 0.312194528}, // 7339K
			{0.302164079, 0.31218233}, // 7340K
			{0.302152369, 0.312170135}, // 7341K
			{0.302140664, 0.312157942}, // 7342K
			{0.302128962, 0.312145753}, // 7343K
			{0.302117264, 0.312133567}, // 7344K
			{0.30210557, 0.312121384}, // 7345K
			{0.30209388, 0.312109204}, // 7346K
			{0.302082194, 0.312097028}, // 7347K
			{0.302070511, 0.312084854}, // 7348K
			{0.302058832, 0.312072684}, // 7349K
			{0.302047157, 0.312060516}, // 7350K
			{0.302035486, 0.312048352}, // 7351K
			{0.302023818, 0.312036191}, // 7352K
			{0.302012155, 0.312024033}, // 7353K
			{0.302000495, 0.312011878}, // 7354K
			{0.301988839, 0.311999727}, // 7355K
			{0.301977186, 0.311987578}, // 7356K
			{0.301965538, 0.311975432}, // 7357K
			{0.301953893, 0.31196329}, // 7358K
			{0.301942252, 0.311951151}, // 7359K
			{0.301930615, 0.311939015}, // 7360K
			{0.301918981, 0.311926882}, // 7361K
			{0.301907351, 0.311914752}, // 7362K
			{0.301895725, 0.311902625}, // 7363K
			{0.301884103, 0.311890501}, // 7364K
			{0.301872485, 0.31187838}, // 7365K
			{0.30186087, 0.311866263}, // 7366K
			{0.301849259, 0.311854148}, // 7367K
			{0.301837652, 0.311842037}, // 7368K
			{0.301826049, 0.311829929}, // 7369K
			{0.301814449, 0.311817823}, // 7370K
			{0.301802853, 0.311805721}, // 7371K
			{0.301791261, 0.311793622}, // 7372K
			{0.301779673, 0.311781527}, // 7373K
			{0.301768088, 0.311769434}, // 7374K
			{0.301756508, 0.311757344}, // 7375K
			{0.30174493, 0.311745258}, // 7376K
			{0.301733357, 0.311733174}, // 7377K
			{0.301721787, 0.311721094}, // 7378K
			{0.301710222, 0.311709016}, // 7379K
			{0.30169866, 0.311696942}, // 7380K
			{0.301687101, 0.311684871}, // 7381K
			{0.301675547, 0.311672803}, // 7382K
			{0.301663996, 0.311660738}, // 7383K
			{0.301652448, 0.311648676}, // 7384K
			{0.301640905, 0.311636617}, // 7385K
			{0.301629365, 0.311624562}, // 7386K
			{0.301617829, 0.311612509}, // 7387K
			{0.301606297, 0.311600459}, // 7388K
			{0.301594769, 0.311588413}, // 7389K
			{0.301583244, 0.311576369}, // 7390K
			{0.301571723, 0.311564329}, // 7391K
			{0.301560205, 0.311552292}, // 7392K
			{0.301548692, 0.311540258}, // 7393K
			{0.301537182, 0.311528227}, // 7394K
			{0.301525676, 0.311516199}, // 7395K
			{0.301514173, 0.311504174}, // 7396K
			{0.301502674, 0.311492152}, // 7397K
			{0.301491179, 0.311480133}, // 7398K
			{0.301479688, 0.311468117}, // 7399K
			{0.3014682, 0.311456105}, // 7400K
			{0.301456717, 0.311444095}, // 7401K
			{0.301445236, 0.311432089}, // 7402K
			{0.30143376, 0.311420085}, // 7403K
			{0.301422287, 0.311408085}, // 7404K
			{0.301410818, 0.311396087}, // 7405K
			{0.301399353, 0.311384093}, // 7406K
			{0.301387891, 0.311372102}, // 7407K
			{0.301376433, 0.311360114}, // 7408K
			{0.301364978, 0.311348129}, // 7409K
			{0.301353528, 0.311336147}, // 7410K
			{0.301342081, 0.311324168}, // 7411K
			{0.301330638, 0.311312192}, // 7412K
			{0.301319198, 0.311300219}, // 7413K
			{0.301307762, 0.311288249}, // 7414K
			{0.30129633, 0.311276282}, // 7415K
			{0.301284902, 0.311264319}, // 7416K
			{0.301273477, 0.311252358}, // 7417K
			{0.301262056, 0.311240401}, // 7418K
			{0.301250638, 0.311228446}, // 7419K
			{0.301239224, 0.311216495}, // 7420K
			{0.301227814, 0.311204546}, // 7421K
			{0.301216408, 0.311192601}, // 7422K
			{0.301205005, 0.311180659}, // 7423K
			{0.301193606, 0.311168719}, // 7424K
			{0.30118221, 0.311156783}, // 7425K
			{0.301170819, 0.31114485}, // 7426K
			{0.301159431, 0.31113292}, // 7427K
			{0.301148046, 0.311120993}, // 7428K
			{0.301136665, 0.311109069}, // 7429K
			{0.301125288, 0.311097148}, // 7430K
			{0.301113915, 0.31108523}, // 7431K
			{0.301102545, 0.311073315}, // 7432K
			{0.301091179, 0.311061403}, // 7433K
			{0.301079816, 0.311049494}, // 7434K
			{0.301068458, 0.311037588}, // 7435K
			{0.301057102, 0.311025685}, // 7436K
			{0.301045751, 0.311013786}, // 7437K
			{0.301034403, 0.311001889}, // 7438K
			{0.301023059, 0.310989995}, // 7439K
			{0.301011718, 0.310978104}, // 7440K
			{0.301000381, 0.310966217}, // 7441K
			{0.300989048, 0.310954332}, // 7442K
			{0.300977718, 0.310942451}, // 7443K
			{0.300966392, 0.310930572}, // 7444K
			{0.30095507, 0.310918697}, // 7445K
			{0.300943751, 0.310906824}, // 7446K
			{0.300932436, 0.310894955}, // 7447K
			{0.300921125, 0.310883088}, // 7448K
			{0.300909817, 0.310871225}, // 7449K
			{0.300898512, 0.310859364}, // 7450K
			{0.300887212, 0.310847507}, // 7451K
			{0.300875915, 0.310835653}, // 7452K
			{0.300864621, 0.310823801}, // 7453K
			{0.300853332, 0.310811953}, // 7454K
			{0.300842046, 0.310800108}, // 7455K
			{0.300830763, 0.310788265}, // 7456K
			{0.300819484, 0.310776426}, // 7457K
			{0.300808209, 0.31076459}, // 7458K
			{0.300796937, 0.310752757}, // 7459K
			{0.300785669, 0.310740926}, // 7460K
			{0.300774405, 0.310729099}, // 7461K
			{0.300763144, 0.310717275}, // 7462K
			{0.300751887, 0.310705454}, // 7463K
			{0.300740633, 0.310693636}, // 7464K
			{0.300729383, 0.310681821}, // 7465K
			{0.300718137, 0.310670008}, // 7466K
			{0.300706894, 0.310658199}, // 7467K
			{0.300695655, 0.310646393}, // 7468K
			{0.300684419, 0.31063459}, // 7469K
			{0.300673188, 0.31062279}, // 7470K
			{0.300661959, 0.310610993}, // 7471K
			{0.300650734, 0.310599198}, // 7472K
			{0.300639513, 0.310587407}, // 7473K
			{0.300628296, 0.310575619}, // 7474K
			{0.300617082, 0.310563834}, // 7475K
			{0.300605871, 0.310552052}, // 7476K
			{0.300594664, 0.310540273}, // 7477K
			{0.300583461, 0.310528497}, // 7478K
			{0.300572261, 0.310516723}, // 7479K
			{0.300561065, 0.310504953}, // 7480K
			{0.300549873, 0.310493186}, // 7481K
			{0.300538684, 0.310481422}, // 7482K
			{0.300527498, 0.310469661}, // 7483K
			{0.300516317, 0.310457902}, // 7484K
			{0.300505138, 0.310446147}, // 7485K
			{0.300493964, 0.310434395}, // 7486K
			{0.300482793, 0.310422646}, // 7487K
			{0.300471625, 0.3104109}, // 7488K
			{0.300460461, 0.310399156}, // 7489K
			{0.300449301, 0.310387416}, // 7490K
			{0.300438144, 0.310375679}, // 7491K
			{0.300426991, 0.310363944}, // 7492K
			{0.300415841, 0.310352213}, // 7493K
			{0.300404695, 0.310340485}, // 7494K
			{0.300393553, 0.310328759}, // 7495K
			{0.300382414, 0.310317037}, // 7496K
			{0.300371278, 0.310305318}, // 7497K
			{0.300360146, 0.310293601}, // 7498K
			{0.300349018, 0.310281888}, // 7499K
			{0.300337893, 0.310270177}, // 7500K
			{0.300326772, 0.31025847}, // 7501K
			{0.300315654, 0.310246765}, // 7502K
			{0.30030454, 0.310235063}, // 7503K
			{0.30029343, 0.310223365}, // 7504K
			{0.300282323, 0.310211669}, // 7505K
			{0.300271219, 0.310199977}, // 7506K
			{0.300260119, 0.310188287}, // 7507K
			{0.300249023, 0.3101766}, // 7508K
			{0.30023793, 0.310164916}, // 7509K
			{0.300226841, 0.310153236}, // 7510K
			{0.300215755, 0.310141558}, // 7511K
			{0.300204672, 0.310129883}, // 7512K
			{0.300193594, 0.310118211}, // 7513K
			{0.300182519, 0.310106542}, // 7514K
			{0.300171447, 0.310094876}, // 7515K
			{0.300160379, 0.310083213}, // 7516K
			{0.300149314, 0.310071553}, // 7517K
			{0.300138253, 0.310059896}, // 7518K
			{0.300127195, 0.310048242}, // 7519K
			{0.300116141, 0.310036591}, // 7520K
			{0.300105091, 0.310024943}, // 7521K
			{0.300094044, 0.310013297}, // 7522K
			{0.300083, 0.310001655}, // 7523K
			{0.30007196, 0.309990016}, // 7524K
			{0.300060924, 0.309978379}, // 7525K
			{0.300049891, 0.309966746}, // 7526K
			{0.300038861, 0.309955115}, // 7527K
			{0.300027835, 0.309943488}, // 7528K
			{0.300016813, 0.309931863}, // 7529K
			{0.300005794, 0.309920241}, // 7530K
			{0.299994778, 0.309908623}, // 7531K
			{0.299983767, 0.309897007}, // 7532K
			{0.299972758, 0.309885394}, // 7533K
			{0.299961753, 0.309873784}, // 7534K
			{0.299950752, 0.309862177}, // 7535K
			{0.299939754, 0.309850573}, // 7536K
			{0.299928759, 0.309838972}, // 7537K
			{0.299917768, 0.309827374}, // 7538K
			{0.299906781, 0.309815779}, // 7539K
			{0.299895797, 0.309804187}, // 7540K
			{0.299884816, 0.309792597}, // 7541K
			{0.299873839, 0.309781011}, // 7542K
			{0.299862866, 0.309769428}, // 7543K
			{0.299851896, 0.309757847}, // 7544K
			{0.299840929, 0.30974627}, // 7545K
			{0.299829966, 0.309734695}, // 7546K
			{0.299819007, 0.309723123}, // 7547K
			{0.299808051, 0.309711555}, // 7548K
			{0.299797098, 0.309699989}, // 7549K
			{0.299786149, 0.309688426}, // 7550K
			{0.299775203, 0.309676866}, // 7551K
			{0.299764261, 0.309665309}, // 7552K
			{0.299753322, 0.309653755}, // 7553K
			{0.299742387, 0.309642203}, // 7554K
			{0.299731455, 0.309630655}, // 7555K
			{0.299720527, 0.30961911}, // 7556K
			{0.299709602, 0.309607567}, // 7557K
			{0.299698681, 0.309596028}, // 7558K
			{0.299687763, 0.309584491}, // 7559K
			{0.299676848, 0.309572958}, // 7560K
			{0.299665937, 0.309561427}, // 7561K
			{0.29965503, 0.309549899}, // 7562K
			{0.299644125, 0.309538374}, // 7563K
			{0.299633225, 0.309526852}, // 7564K
			{0.299622328, 0.309515333}, // 7565K
			{0.299611434, 0.309503817}, // 7566K
			{0.299600544, 0.309492304}, // 7567K
			{0.299589657, 0.309480793}, // 7568K
			{0.299578773, 0.309469286}, // 7569K
			{0.299567893, 0.309457781}, // 7570K
			{0.299557017, 0.30944628}, // 7571K
			{0.299546144, 0.309434781}, // 7572K
			{0.299535274, 0.309423285}, // 7573K
			{0.299524408, 0.309411793}, // 7574K
			{0.299513545, 0.309400303}, // 7575K
			{0.299502686, 0.309388815}, // 7576K
			{0.29949183, 0.309377331}, // 7577K
			{0.299480978, 0.30936585}, // 7578K
			{0.299470129, 0.309354372}, // 7579K
			{0.299459283, 0.309342896}, // 7580K
			{0.299448441, 0.309331424}, // 7581K
			{0.299437602, 0.309319954}, // 7582K
			{0.299426767, 0.309308487}, // 7583K
			{0.299415935, 0.309297023}, // 7584K
			{0.299405107, 0.309285563}, // 7585K
			{0.299394282, 0.309274104}, // 7586K
			{0.29938346, 0.309262649}, // 7587K
			{0.299372642, 0.309251197}, // 7588K
			{0.299361827, 0.309239748}, // 7589K
			{0.299351016, 0.309228301}, // 7590K
			{0.299340208, 0.309216858}, // 7591K
			{0.299329403, 0.309205417}, // 7592K
			{0.299318602, 0.309193979}, // 7593K
			{0.299307804, 0.309182544}, // 7594K
			{0.29929701, 0.309171112}, // 7595K
			{0.299286219, 0.309159683}, // 7596K
			{0.299275432, 0.309148257}, // 7597K
			{0.299264648, 0.309136833}, // 7598K
			{0.299253867, 0.309125413}, // 7599K
			{0.29924309, 0.309113995}, // 7600K
			{0.299232316, 0.309102581}, // 7601K
			{0.299221545, 0.309091169}, // 7602K
			{0.299210778, 0.30907976}, // 7603K
			{0.299200015, 0.309068354}, // 7604K
			{0.299189254, 0.30905695}, // 7605K
			{0.299178497, 0.30904555}, // 7606K
			{0.299167744, 0.309034153}, // 7607K
			{0.299156994, 0.309022758}, // 7608K
			{0.299146247, 0.309011366}, // 7609K
			{0.299135504, 0.308999978}, // 7610K
			{0.299124764, 0.308988592}, // 7611K
			{0.299114027, 0.308977209}, // 7612K
			{0.299103294, 0.308965828}, // 7613K
			{0.299092564, 0.308954451}, // 7614K
			{0.299081838, 0.308943077}, // 7615K
			{0.299071115, 0.308931705}, // 7616K
			{0.299060395, 0.308920336}, // 7617K
			{0.299049679, 0.30890897}, // 7618K
			{0.299038966, 0.308897607}, // 7619K
			{0.299028256, 0.308886247}, // 7620K
			{0.29901755, 0.30887489}, // 7621K
			{0.299006847, 0.308863536}, // 7622K
			{0.298996148, 0.308852184}, // 7623K
			{0.298985452, 0.308840836}, // 7624K
			{0.298974759, 0.30882949}, // 7625K
			{0.29896407, 0.308818147}, // 7626K
			{0.298953384, 0.308806807}, // 7627K
			{0.298942701, 0.308795469}, // 7628K
			{0.298932022, 0.308784135}, // 7629K
			{0.298921346, 0.308772804}, // 7630K
			{0.298910674, 0.308761475}, // 7631K
			{0.298900005, 0.308750149}, // 7632K
			{0.298889339, 0.308738826}, // 7633K
			{0.298878676, 0.308727506}, // 7634K
			{0.298868017, 0.308716189}, // 7635K
			{0.298857361, 0.308704875}, // 7636K
			{0.298846709, 0.308693563}, // 7637K
			{0.29883606, 0.308682254}, // 7638K
			{0.298825414, 0.308670948}, // 7639K
			{0.298814772, 0.308659645}, // 7640K
			{0.298804133, 0.308648345}, // 7641K
			{0.298793497, 0.308637048}, // 7642K
			{0.298782865, 0.308625754}, // 7643K
			{0.298772236, 0.308614462}, // 7644K
			{0.29876161, 0.308603173}, // 7645K
			{0.298750988, 0.308591887}, // 7646K
			{0.298740369, 0.308580604}, // 7647K
			{0.298729753, 0.308569324}, // 7648K
			{0.298719141, 0.308558047}, // 7649K
			{0.298708532, 0.308546772}, // 7650K
			{0.298697926, 0.3085355}, // 7651K
			{0.298687323, 0.308524231}, // 7652K
			{0.298676724, 0.308512965}, // 7653K
			{0.298666129, 0.308501702}, // 7654K
			{0.298655536, 0.308490442}, // 7655K
			{0.298644947, 0.308479184}, // 7656K
			{0.298634361, 0.30846793}, // 7657K
			{0.298623779, 0.308456678}, // 7658K
			{0.2986132, 0.308445429}, // 7659K
			{0.298602624, 0.308434182}, // 7660K
			{0.298592052, 0.308422939}, // 7661K
			{0.298581482, 0.308411698}, // 7662K
			{0.298570917, 0.308400461}, // 7663K
			{0.298560354, 0.308389226}, // 7664K
			{0.298549795, 0.308377994}, // 7665K
			{0.298539239, 0.308366764}, // 7666K
			{0.298528686, 0.308355538}, // 7667K
			{0.298518137, 0.308344314}, // 7668K
			{0.298507591, 0.308333094}, // 7669K
			{0.298497048, 0.308321876}, // 7670K
			{0.298486509, 0.308310661}, // 7671K
			{0.298475973, 0.308299448}, // 7672K
			{0.29846544, 0.308288239}, // 7673K
			{0.29845491, 0.308277032}, // 7674K
			{0.298444384, 0.308265828}, // 7675K
			{0.298433861, 0.308254627}, // 7676K
			{0.298423341, 0.308243429}, // 7677K
			{0.298412825, 0.308232233}, // 7678K
			{0.298402312, 0.308221041}, // 7679K
			{0.298391802, 0.308209851}, // 7680K
			{0.298381296, 0.308198664}, // 7681K
			{0.298370792, 0.30818748}, // 7682K
			{0.298360293, 0.308176298}, // 7683K
			{0.298349796, 0.30816512}, // 7684K
			{0.298339303, 0.308153944}, // 7685K
			{0.298328812, 0.308142771}, // 7686K
			{0.298318326, 0.308131601}, // 7687K
			{0.298307842, 0.308120434}, // 7688K
			{0.298297362, 0.308109269}, // 7689K
			{0.298286885, 0.308098108}, // 7690K
			{0.298276411, 0.308086949}, // 7691K
			{0.298265941, 0.308075792}, // 7692K
			{0.298255474, 0.308064639}, // 7693K
			{0.29824501, 0.308053489}, // 7694K
			{0.298234549, 0.308042341}, // 7695K
			{0.298224092, 0.308031196}, // 7696K
			{0.298213637, 0.308020054}, // 7697K
			{0.298203187, 0.308008915}, // 7698K
			{0.298192739, 0.307997778}, // 7699K
			{0.298182295, 0.307986644}, // 7700K
			{0.298171854, 0.307975513}, // 7701K
			{0.298161416, 0.307964385}, // 7702K
			{0.298150981, 0.30795326}, // 7703K
			{0.29814055, 0.307942137}, // 7704K
			{0.298130122, 0.307931018}, // 7705K
			{0.298119697, 0.307919901}, // 7706K
			{0.298109276, 0.307908786}, // 7707K
			{0.298098857, 0.307897675}, // 7708K
			{0.298088442, 0.307886566}, // 7709K
			{0.29807803, 0.307875461}, // 7710K
			{0.298067622, 0.307864357}, // 7711K
			{0.298057217, 0.307853257}, // 7712K
			{0.298046815, 0.30784216}, // 7713K
			{0.298036416, 0.307831065}, // 7714K
			{0.29802602, 0.307819973}, // 7715K
			{0.298015628, 0.307808884}, // 7716K
			{0.298005239, 0.307797798}, // 7717K
			{0.297994853, 0.307786714}, // 7718K
			{0.29798447, 0.307775633}, // 7719K
			{0.297974091, 0.307764555}, // 7720K
			{0.297963715, 0.30775348}, // 7721K
			{0.297953342, 0.307742408}, // 7722K
			{0.297942972, 0.307731338}, // 7723K
			{0.297932605, 0.307720271}, // 7724K
			{0.297922242, 0.307709207}, // 7725K
			{0.297911882, 0.307698145}, // 7726K
			{0.297901525, 0.307687087}, // 7727K
			{0.297891172, 0.307676031}, // 7728K
			{0.297880821, 0.307664978}, // 7729K
			{0.297870474, 0.307653928}, // 7730K
			{0.29786013, 0.30764288}, // 7731K
			{0.297849789, 0.307631835}, // 7732K
			{0.297839452, 0.307620793}, // 7733K
			{0.297829117, 0.307609754}, // 7734K
			{0.297818786, 0.307598718}, // 7735K
			{0.297808458, 0.307587684}, // 7736K
			{0.297798134, 0.307576653}, // 7737K
			{0.297787812, 0.307565625}, // 7738K
			{0.297777494, 0.3075546}, // 7739K
			{0.297767179, 0.307543577}, // 7740K
			{0.297756867, 0.307532557}, // 7741K
			{0.297746559, 0.30752154}, // 7742K
			{0.297736253, 0.307510526}, // 7743K
			{0.297725951, 0.307499514}, // 7744K
			{0.297715652, 0.307488505}, // 7745K
			{0.297705356, 0.307477499}, // 7746K
			{0.297695063, 0.307466496}, // 7747K
			{0.297684774, 0.307455495}, // 7748K
			{0.297674488, 0.307444497}, // 7749K
			{0.297664204, 0.307433502}, // 7750K
			{0.297653925, 0.30742251}, // 7751K
			{0.297643648, 0.30741152}, // 7752K
			{0.297633374, 0.307400533}, // 7753K
			{0.297623104, 0.307389549}, // 7754K
			{0.297612837, 0.307378568}, // 7755K
			{0.297602573, 0.307367589}, // 7756K
			{0.297592312, 0.307356613}, // 7757K
			{0.297582055, 0.30734564}, // 7758K
			{0.2975718, 0.30733467}, // 7759K
			{0.297561549, 0.307323702}, // 7760K
			{0.297551301, 0.307312737}, // 7761K
			{0.297541056, 0.307301775}, // 7762K
			{0.297530814, 0.307290816}, // 7763K
			{0.297520576, 0.307279859}, // 7764K
			{0.29751034, 0.307268905}, // 7765K
			{0.297500108, 0.307257954}, // 7766K
			{0.297489879, 0.307247006}, // 7767K
			{0.297479653, 0.30723606}, // 7768K
			{0.297469431, 0.307225117}, // 7769K
			{0.297459211, 0.307214177}, // 7770K
			{0.297448995, 0.307203239}, // 7771K
			{0.297438781, 0.307192305}, // 7772K
			{0.297428571, 0.307181373}, // 7773K
			{0.297418365, 0.307170443}, // 7774K
			{0.297408161, 0.307159517}, // 7775K
			{0.29739796, 0.307148593}, // 7776K
			{0.297387763, 0.307137672}, // 7777K
			{0.297377569, 0.307126753}, // 7778K
			{0.297367377, 0.307115838}, // 7779K
			{0.297357189, 0.307104925}, // 7780K
			{0.297347005, 0.307094014}, // 7781K
			{0.297336823, 0.307083107}, // 7782K
			{0.297326645, 0.307072202}, // 7783K
			{0.297316469, 0.3070613}, // 7784K
			{0.297306297, 0.307050401}, // 7785K
			{0.297296128, 0.307039504}, // 7786K
			{0.297285962, 0.30702861}, // 7787K
			{0.297275799, 0.307017719}, // 7788K
			{0.297265639, 0.307006831}, // 7789K
			{0.297255483, 0.306995945}, // 7790K
			{0.29724533, 0.306985062}, // 7791K
			{0.297235179, 0.306974182}, // 7792K
			{0.297225032, 0.306963304}, // 7793K
			{0.297214888, 0.306952429}, // 7794K
			{0.297204747, 0.306941557}, // 7795K
			{0.29719461, 0.306930688}, // 7796K
			{0.297184475, 0.306919821}, // 7797K
			{0.297174344, 0.306908957}, // 7798K
			{0.297164215, 0.306898096}, // 7799K
			{0.29715409, 0.306887237}, // 7800K
			{0.297143968, 0.306876381}, // 7801K
			{0.297133849, 0.306865528}, // 7802K
			{0.297123733, 0.306854678}, // 7803K
			{0.297113621, 0.30684383}, // 7804K
			{0.297103511, 0.306832985}, // 7805K
			{0.297093405, 0.306822142}, // 7806K
			{0.297083301, 0.306811303}, // 7807K
			{0.297073201, 0.306800466}, // 7808K
			{0.297063104, 0.306789631}, // 7809K
			{0.29705301, 0.3067788}, // 7810K
			{0.297042919, 0.306767971}, // 7811K
			{0.297032831, 0.306757145}, // 7812K
			{0.297022746, 0.306746321}, // 7813K
			{0.297012665, 0.306735501}, // 7814K
			{0.297002586, 0.306724683}, // 7815K
			{0.296992511, 0.306713867}, // 7816K
			{0.296982439, 0.306703055}, // 7817K
			{0.296972369, 0.306692245}, // 7818K
			{0.296962303, 0.306681437}, // 7819K
			{0.29695224, 0.306670633}, // 7820K
			{0.296942181, 0.306659831}, // 7821K
			{0.296932124, 0.306649032}, // 7822K
			{0.29692207, 0.306638235}, // 7823K
			{0.296912019, 0.306627441}, // 7824K
			{0.296901972, 0.30661665}, // 7825K
			{0.296891928, 0.306605862}, // 7826K
			{0.296881886, 0.306595076}, // 7827K
			{0.296871848, 0.306584293}, // 7828K
			{0.296861813, 0.306573512}, // 7829K
			{0.296851781, 0.306562735}, // 7830K
			{0.296841752, 0.30655196}, // 7831K
			{0.296831726, 0.306541187}, // 7832K
			{0.296821703, 0.306530418}, // 7833K
			{0.296811683, 0.306519651}, // 7834K
			{0.296801667, 0.306508886}, // 7835K
			{0.296791653, 0.306498125}, // 7836K
			{0.296781643, 0.306487366}, // 7837K
			{0.296771635, 0.306476609}, // 7838K
			{0.296761631, 0.306465856}, // 7839K
			{0.29675163, 0.306455105}, // 7840K
			{0.296741632, 0.306444357}, // 7841K
			{0.296731636, 0.306433611}, // 7842K
			{0.296721644, 0.306422868}, // 7843K
			{0.296711655, 0.306412128}, // 7844K
			{0.296701669, 0.30640139}, // 7845K
			{0.296691687, 0.306390655}, // 7846K
			{0.296681707, 0.306379923}, // 7847K
			{0.29667173, 0.306369194}, // 7848K
			{0.296661756, 0.306358467}, // 7849K
			{0.296651786, 0.306347743}, // 7850K
			{0.296641818, 0.306337021}, // 7851K
			{0.296631854, 0.306326302}, // 7852K
			{0.296621892, 0.306315586}, // 7853K
			{0.296611934, 0.306304872}, // 7854K
			{0.296601979, 0.306294161}, // 7855K
			{0.296592026, 0.306283453}, // 7856K
			{0.296582077, 0.306272748}, // 7857K
			{0.296572131, 0.306262045}, // 7858K
			{0.296562188, 0.306251344}, // 7859K
			{0.296552248, 0.306240647}, // 7860K
			{0.296542311, 0.306229952}, // 7861K
			{0.296532377, 0.30621926}, // 7862K
			{0.296522446, 0.30620857}, // 7863K
			{0.296512518, 0.306197883}, // 7864K
			{0.296502593, 0.306187199}, // 7865K
			{0.296492671, 0.306176517}, // 7866K
			{0.296482753, 0.306165838}, // 7867K
			{0.296472837, 0.306155162}, // 7868K
			{0.296462924, 0.306144488}, // 7869K
			{0.296453015, 0.306133817}, // 7870K
			{0.296443108, 0.306123149}, // 7871K
			{0.296433204, 0.306112483}, // 7872K
			{0.296423304, 0.30610182}, // 7873K
			{0.296413406, 0.306091159}, // 7874K
			{0.296403512, 0.306080501}, // 7875K
			{0.29639362, 0.306069846}, // 7876K
			{0.296383732, 0.306059194}, // 7877K
			{0.296373846, 0.306048544}, // 7878K
			{0.296363964, 0.306037897}, // 7879K
			{0.296354085, 0.306027252}, // 7880K
			{0.296344208, 0.30601661}, // 7881K
			{0.296334335, 0.306005971}, // 7882K
			{0.296324465, 0.305995334}, // 7883K
			{0.296314597, 0.3059847}, // 7884K
			{0.296304733, 0.305974069}, // 7885K
			{0.296294872, 0.30596344}, // 7886K
			{0.296285013, 0.305952814}, // 7887K
			{0.296275158, 0.30594219}, // 7888K
			{0.296265306, 0.305931569}, // 7889K
			{0.296255457, 0.305920951}, // 7890K
			{0.29624561, 0.305910336}, // 7891K
			{0.296235767, 0.305899723}, // 7892K
			{0.296225927, 0.305889112}, // 7893K
			{0.29621609, 0.305878505}, // 7894K
			{0.296206256, 0.305867899}, // 7895K
			{0.296196424, 0.305857297}, // 7896K
			{0.296186596, 0.305846697}, // 7897K
			{0.296176771, 0.3058361}, // 7898K
			{0.296166949, 0.305825505}, // 7899K
			{0.29615713, 0.305814914}, // 7900K
			{0.296147313, 0.305804324}, // 7901K
			{0.2961375, 0.305793738}, // 7902K
			{0.29612769, 0.305783154}, // 7903K
			{0.296117883, 0.305772572}, // 7904K
			{0.296108079, 0.305761993}, // 7905K
			{0.296098277, 0.305751417}, // 7906K
			{0.296088479, 0.305740844}, // 7907K
			{0.296078684, 0.305730273}, // 7908K
			{0.296068892, 0.305719704}, // 7909K
			{0.296059102, 0.305709139}, // 7910K
			{0.296049316, 0.305698575}, // 7911K
			{0.296039533, 0.305688015}, // 7912K
			{0.296029752, 0.305677457}, // 7913K
			{0.296019975, 0.305666902}, // 7914K
			{0.2960102, 0.305656349}, // 7915K
			{0.296000429, 0.305645799}, // 7916K
			{0.295990661, 0.305635252}, // 7917K
			{0.295980895, 0.305624707}, // 7918K
			{0.295971133, 0.305614165}, // 7919K
			{0.295961373, 0.305603625}, // 7920K
			{0.295951617, 0.305593088}, // 7921K
			{0.295941863, 0.305582554}, // 7922K
			{0.295932112, 0.305572022}, // 7923K
			{0.295922365, 0.305561493}, // 7924K
			{0.29591262, 0.305550966}, // 7925K
			{0.295902878, 0.305540442}, // 7926K
			{0.29589314, 0.305529921}, // 7927K
			{0.295883404, 0.305519402}, // 7928K
			{0.295873671, 0.305508886}, // 7929K
			{0.295863941, 0.305498373}, // 7930K
			{0.295854214, 0.305487862}, // 7931K
			{0.29584449, 0.305477353}, // 7932K
			{0.295834769, 0.305466848}, // 7933K
			{0.295825051, 0.305456344}, // 7934K
			{0.295815336, 0.305445844}, // 7935K
			{0.295805624, 0.305435346}, // 7936K
			{0.295795915, 0.305424851}, // 7937K
			{0.295786209, 0.305414358}, // 7938K
			{0.295776506, 0.305403868}, // 7939K
			{0.295766805, 0.30539338}, // 7940K
			{0.295757108, 0.305382895}, // 7941K
			{0.295747413, 0.305372413}, // 7942K
			{0.295737722, 0.305361933}, // 7943K
			{0.295728033, 0.305351456}, // 7944K
			{0.295718348, 0.305340981}, // 7945K
			{0.295708665, 0.305330509}, // 7946K
			{0.295698985, 0.30532004}, // 7947K
			{0.295689309, 0.305309573}, // 7948K
			{0.295679635, 0.305299108}, // 7949K
			{0.295669964, 0.305288647}, // 7950K
			{0.295660296, 0.305278188}, // 7951K
			{0.295650631, 0.305267731}, // 7952K
			{0.295640969, 0.305257277}, // 7953K
			{0.29563131, 0.305246826}, // 7954K
			{0.295621653, 0.305236377}, // 7955K
			{0.295612, 0.305225931}, // 7956K
			{0.29560235, 0.305215487}, // 7957K
			{0.295592702, 0.305205046}, // 7958K
			{0.295583058, 0.305194608}, // 7959K
			{0.295573416, 0.305184172}, // 7960K
			{0.295563777, 0.305173739}, // 7961K
			{0.295554141, 0.305163308}, // 7962K
			{0.295544509, 0.30515288}, // 7963K
			{0.295534879, 0.305142454}, // 7964K
			{0.295525252, 0.305132031}, // 7965K
			{0.295515628, 0.305121611}, // 7966K
			{0.295506006, 0.305111193}, // 7967K
			{0.295496388, 0.305100778}, // 7968K
			{0.295486773, 0.305090365}, // 7969K
			{0.29547716, 0.305079955}, // 7970K
			{0.295467551, 0.305069547}, // 7971K
			{0.295457944, 0.305059142}, // 7972K
			{0.29544834, 0.30504874}, // 7973K
			{0.29543874, 0.30503834}, // 7974K
			{0.295429142, 0.305027942}, // 7975K
			{0.295419547, 0.305017548}, // 7976K
			{0.295409954, 0.305007155}, // 7977K
			{0.295400365, 0.304996766}, // 7978K
			{0.295390779, 0.304986379}, // 7979K
			{0.295381196, 0.304975994}, // 7980K
			{0.295371615, 0.304965612}, // 7981K
			{0.295362037, 0.304955233}, // 7982K
			{0.295352463, 0.304944856}, // 7983K
			{0.295342891, 0.304934482}, // 7984K
			{0.295333322, 0.30492411}, // 7985K
			{0.295323756, 0.304913741}, // 7986K
			{0.295314193, 0.304903374}, // 7987K
			{0.295304633, 0.30489301}, // 7988K
			{0.295295075, 0.304882649}, // 7989K
			{0.295285521, 0.30487229}, // 7990K
			{0.295275969, 0.304861933}, // 7991K
			{0.29526642, 0.30485158}, // 7992K
			{0.295256875, 0.304841228}, // 7993K
			{0.295247332, 0.30483088}, // 7994K
			{0.295237792, 0.304820533}, // 7995K
			{0.295228255, 0.30481019}, // 7996K
			{0.29521872, 0.304799849}, // 7997K
			{0.295209189, 0.30478951}, // 7998K
			{0.29519966, 0.304779174}, // 7999K
			{0.295190135, 0.304768841}, // 8000K
			{0.295180612, 0.30475851}, // 8001K
			{0.295171092, 0.304748181}, // 8002K
			{0.295161575, 0.304737855}, // 8003K
			{0.295152061, 0.304727532}, // 8004K
			{0.295142549, 0.304717211}, // 8005K
			{0.295133041, 0.304706893}, // 8006K
			{0.295123535, 0.304696578}, // 8007K
			{0.295114033, 0.304686264}, // 8008K
			{0.295104533, 0.304675954}, // 8009K
			{0.295095036, 0.304665646}, // 8010K
			{0.295085542, 0.30465534}, // 8011K
			{0.295076051, 0.304645037}, // 8012K
			{0.295066562, 0.304634737}, // 8013K
			{0.295057077, 0.304624439}, // 8014K
			{0.295047594, 0.304614144}, // 8015K
			{0.295038114, 0.304603851}, // 8016K
			{0.295028637, 0.30459356}, // 8017K
			{0.295019163, 0.304583273}, // 8018K
			{0.295009692, 0.304572987}, // 8019K
			{0.295000223, 0.304562705}, // 8020K
			{0.294990758, 0.304552424}, // 8021K
			{0.294981295, 0.304542147}, // 8022K
			{0.294971835, 0.304531872}, // 8023K
			{0.294962378, 0.304521599}, // 8024K
			{0.294952924, 0.304511329}, // 8025K
			{0.294943473, 0.304501061}, // 8026K
			{0.294934025, 0.304490796}, // 8027K
			{0.294924579, 0.304480534}, // 8028K
			{0.294915136, 0.304470274}, // 8029K
			{0.294905696, 0.304460016}, // 8030K
			{0.294896259, 0.304449761}, // 8031K
			{0.294886825, 0.304439509}, // 8032K
			{0.294877393, 0.304429259}, // 8033K
			{0.294867965, 0.304419012}, // 8034K
			{0.294858539, 0.304408767}, // 8035K
			{0.294849116, 0.304398524}, // 8036K
			{0.294839696, 0.304388284}, // 8037K
			{0.294830279, 0.304378047}, // 8038K
			{0.294820864, 0.304367812}, // 8039K
			{0.294811453, 0.30435758}, // 8040K
			{0.294802044, 0.30434735}, // 8041K
			{0.294792638, 0.304337123}, // 8042K
			{0.294783235, 0.304326898}, // 8043K
			{0.294773835, 0.304316676}, // 8044K
			{0.294764437, 0.304306456}, // 8045K
			{0.294755043, 0.304296239}, // 8046K
			{0.294745651, 0.304286024}, // 8047K
			{0.294736262, 0.304275812}, // 8048K
			{0.294726876, 0.304265602}, // 8049K
			{0.294717492, 0.304255395}, // 8050K
			{0.294708112, 0.30424519}, // 8051K
			{0.294698734, 0.304234988}, // 8052K
			{0.294689359, 0.304224788}, // 8053K
			{0.294679987, 0.304214591}, // 8054K
			{0.294670618, 0.304204396}, // 8055K
			{0.294661251, 0.304194204}, // 8056K
			{0.294651887, 0.304184014}, // 8057K
			{0.294642527, 0.304173827}, // 8058K
			{0.294633168, 0.304163643}, // 8059K
			{0.294623813, 0.30415346}, // 8060K
			{0.294614461, 0.304143281}, // 8061K
			{0.294605111, 0.304133103}, // 8062K
			{0.294595764, 0.304122929}, // 8063K
			{0.29458642, 0.304112756}, // 8064K
			{0.294577079, 0.304102587}, // 8065K
			{0.29456774, 0.304092419}, // 8066K
			{0.294558405, 0.304082255}, // 8067K
			{0.294549072, 0.304072092}, // 8068K
			{0.294539742, 0.304061933}, // 8069K
			{0.294530415, 0.304051775}, // 8070K
			{0.29452109, 0.304041621}, // 8071K
			{0.294511768, 0.304031468}, // 8072K
			{0.29450245, 0.304021319}, // 8073K
			{0.294493133, 0.304011171}, // 8074K
			{0.29448382, 0.304001026}, // 8075K
			{0.29447451, 0.303990884}, // 8076K
			{0.294465202, 0.303980744}, // 8077K
			{0.294455897, 0.303970607}, // 8078K
			{0.294446595, 0.303960472}, // 8079K
			{0.294437295, 0.30395034}, // 8080K
			{0.294427999, 0.30394021}, // 8081K
			{0.294418705, 0.303930082}, // 8082K
			{0.294409414, 0.303919957}, // 8083K
			{0.294400126, 0.303909835}, // 8084K
			{0.29439084, 0.303899715}, // 8085K
			{0.294381557, 0.303889597}, // 8086K
			{0.294372278, 0.303879482}, // 8087K
			{0.294363, 0.303869369}, // 8088K
			{0.294353726, 0.303859259}, // 8089K
			{0.294344454, 0.303849152}, // 8090K
			{0.294335186, 0.303839047}, // 8091K
			{0.294325919, 0.303828944}, // 8092K
			{0.294316656, 0.303818844}, // 8093K
			{0.294307396, 0.303808746}, // 8094K
			{0.294298138, 0.303798651}, // 8095K
			{0.294288883, 0.303788558}, // 8096K
			{0.294279631, 0.303778468}, // 8097K
			{0.294270381, 0.30376838}, // 8098K
			{0.294261134, 0.303758294}, // 8099K
			{0.29425189, 0.303748211}, // 8100K
			{0.294242649, 0.303738131}, // 8101K
			{0.294233411, 0.303728053}, // 8102K
			{0.294224175, 0.303717977}, // 8103K
			{0.294214942, 0.303707904}, // 8104K
			{0.294205712, 0.303697834}, // 8105K
			{0.294196484, 0.303687766}, // 8106K
			{0.29418726, 0.3036777}, // 8107K
			{0.294178038, 0.303667637}, // 8108K
			{0.294168819, 0.303657576}, // 8109K
			{0.294159602, 0.303647518}, // 8110K
			{0.294150389, 0.303637462}, // 8111K
			{0.294141178, 0.303627408}, // 8112K
			{0.29413197, 0.303617357}, // 8113K
			{0.294122764, 0.303607309}, // 8114K
			{0.294113561, 0.303597263}, // 8115K
			{0.294104361, 0.303587219}, // 8116K
			{0.294095164, 0.303577178}, // 8117K
			{0.29408597, 0.30356714}, // 8118K
			{0.294076778, 0.303557103}, // 8119K
			{0.294067589, 0.30354707}, // 8120K
			{0.294058403, 0.303537038}, // 8121K
			{0.294049219, 0.303527009}, // 8122K
			{0.294040038, 0.303516983}, // 8123K
			{0.29403086, 0.303506959}, // 8124K
			{0.294021685, 0.303496938}, // 8125K
			{0.294012512, 0.303486918}, // 8126K
			{0.294003343, 0.303476902}, // 8127K
			{0.293994175, 0.303466888}, // 8128K
			{0.293985011, 0.303456876}, // 8129K
			{0.293975849, 0.303446867}, // 8130K
			{0.29396669, 0.30343686}, // 8131K
			{0.293957534, 0.303426855}, // 8132K
			{0.293948381, 0.303416853}, // 8133K
			{0.29393923, 0.303406854}, // 8134K
			{0.293930082, 0.303396857}, // 8135K
			{0.293920937, 0.303386862}, // 8136K
			{0.293911794, 0.30337687}, // 8137K
			{0.293902654, 0.30336688}, // 8138K
			{0.293893517, 0.303356893}, // 8139K
			{0.293884382, 0.303346908}, // 8140K
			{0.293875251, 0.303336926}, // 8141K
			{0.293866122, 0.303326946}, // 8142K
			{0.293856995, 0.303316968}, // 8143K
			{0.293847872, 0.303306993}, // 8144K
			{0.293838751, 0.30329702}, // 8145K
			{0.293829632, 0.30328705}, // 8146K
			{0.293820517, 0.303277082}, // 8147K
			{0.293811404, 0.303267117}, // 8148K
			{0.293802294, 0.303257154}, // 8149K
			{0.293793187, 0.303247193}, // 8150K
			{0.293784082, 0.303237235}, // 8151K
			{0.29377498, 0.303227279}, // 8152K
			{0.293765881, 0.303217326}, // 8153K
			{0.293756784, 0.303207375}, // 8154K
			{0.29374769, 0.303197427}, // 8155K
			{0.293738599, 0.303187481}, // 8156K
			{0.293729511, 0.303177537}, // 8157K
			{0.293720425, 0.303167596}, // 8158K
			{0.293711342, 0.303157657}, // 8159K
			{0.293702262, 0.303147721}, // 8160K
			{0.293693184, 0.303137787}, // 8161K
			{0.293684109, 0.303127856}, // 8162K
			{0.293675037, 0.303117926}, // 8163K
			{0.293665967, 0.303108}, // 8164K
			{0.2936569, 0.303098076}, // 8165K
			{0.293647836, 0.303088154}, // 8166K
			{0.293638774, 0.303078234}, // 8167K
			{0.293629715, 0.303068317}, // 8168K
			{0.293620659, 0.303058403}, // 8169K
			{0.293611606, 0.303048491}, // 8170K
			{0.293602555, 0.303038581}, // 8171K
			{0.293593507, 0.303028674}, // 8172K
			{0.293584461, 0.303018769}, // 8173K
			{0.293575418, 0.303008866}, // 8174K
			{0.293566378, 0.302998966}, // 8175K
			{0.293557341, 0.302989069}, // 8176K
			{0.293548306, 0.302979173}, // 8177K
			{0.293539274, 0.30296928}, // 8178K
			{0.293530245, 0.30295939}, // 8179K
			{0.293521218, 0.302949502}, // 8180K
			{0.293512194, 0.302939616}, // 8181K
			{0.293503172, 0.302929733}, // 8182K
			{0.293494154, 0.302919852}, // 8183K
			{0.293485138, 0.302909974}, // 8184K
			{0.293476124, 0.302900098}, // 8185K
			{0.293467113, 0.302890224}, // 8186K
			{0.293458105, 0.302880353}, // 8187K
			{0.2934491, 0.302870484}, // 8188K
			{0.293440097, 0.302860618}, // 8189K
			{0.293431097, 0.302850754}, // 8190K
			{0.2934221, 0.302840892}, // 8191K
			{0.293413105, 0.302831033}, // 8192K
			{0.293404113, 0.302821176}, // 8193K
			{0.293395123, 0.302811321}, // 8194K
			{0.293386137, 0.302801469}, // 8195K
			{0.293377152, 0.30279162}, // 8196K
			{0.293368171, 0.302781772}, // 8197K
			{0.293359192, 0.302771928}, // 8198K
			{0.293350216, 0.302762085}, // 8199K
			{0.293341242, 0.302752245}, // 8200K
			{0.293332272, 0.302742407}, // 8201K
			{0.293323303, 0.302732572}, // 8202K
			{0.293314338, 0.302722739}, // 8203K
			{0.293305375, 0.302712909}, // 8204K
			{0.293296414, 0.30270308}, // 8205K
			{0.293287457, 0.302693255}, // 8206K
			{0.293278502, 0.302683431}, // 8207K
			{0.293269549, 0.30267361}, // 8208K
			{0.2932606, 0.302663792}, // 8209K
			{0.293251653, 0.302653976}, // 8210K
			{0.293242708, 0.302644162}, // 8211K
			{0.293233766, 0.30263435}, // 8212K
			{0.293224827, 0.302624541}, // 8213K
			{0.293215891, 0.302614735}, // 8214K
			{0.293206957, 0.30260493}, // 8215K
			{0.293198026, 0.302595128}, // 8216K
			{0.293189097, 0.302585329}, // 8217K
			{0.293180171, 0.302575532}, // 8218K
			{0.293171248, 0.302565737}, // 8219K
			{0.293162327, 0.302555944}, // 8220K
			{0.293153409, 0.302546154}, // 8221K
			{0.293144493, 0.302536367}, // 8222K
			{0.29313558, 0.302526581}, // 8223K
			{0.29312667, 0.302516798}, // 8224K
			{0.293117762, 0.302507018}, // 8225K
			{0.293108857, 0.30249724}, // 8226K
			{0.293099955, 0.302487464}, // 8227K
			{0.293091055, 0.302477691}, // 8228K
			{0.293082158, 0.302467919}, // 8229K
			{0.293073264, 0.302458151}, // 8230K
			{0.293064372, 0.302448384}, // 8231K
			{0.293055483, 0.30243862}, // 8232K
			{0.293046596, 0.302428859}, // 8233K
			{0.293037712, 0.3024191}, // 8234K
			{0.29302883, 0.302409343}, // 8235K
			{0.293019952, 0.302399588}, // 8236K
			{0.293011075, 0.302389836}, // 8237K
			{0.293002202, 0.302380086}, // 8238K
			{0.292993331, 0.302370339}, // 8239K
			{0.292984462, 0.302360594}, // 8240K
			{0.292975597, 0.302350851}, // 8241K
			{0.292966733, 0.302341111}, // 8242K
			{0.292957873, 0.302331373}, // 8243K
			{0.292949015, 0.302321637}, // 8244K
			{0.29294016, 0.302311904}, // 8245K
			{0.292931307, 0.302302173}, // 8246K
			{0.292922457, 0.302292445}, // 8247K
			{0.292913609, 0.302282719}, // 8248K
			{0.292904764, 0.302272995}, // 8249K
			{0.292895922, 0.302263273}, // 8250K
			{0.292887082, 0.302253554}, // 8251K
			{0.292878245, 0.302243837}, // 8252K
			{0.29286941, 0.302234123}, // 8253K
			{0.292860578, 0.302224411}, // 8254K
			{0.292851749, 0.302214701}, // 8255K
			{0.292842922, 0.302204994}, // 8256K
			{0.292834098, 0.302195289}, // 8257K
			{0.292825276, 0.302185586}, // 8258K
			{0.292816457, 0.302175886}, // 8259K
			{0.292807641, 0.302166188}, // 8260K
			{0.292798827, 0.302156492}, // 8261K
			{0.292790016, 0.302146799}, // 8262K
			{0.292781207, 0.302137108}, // 8263K
			{0.292772401, 0.30212742}, // 8264K
			{0.292763597, 0.302117733}, // 8265K
			{0.292754796, 0.30210805}, // 8266K
			{0.292745998, 0.302098368}, // 8267K
			{0.292737202, 0.302088689}, // 8268K
			{0.292728409, 0.302079012}, // 8269K
			{0.292719619, 0.302069337}, // 8270K
			{0.29271083, 0.302059665}, // 8271K
			{0.292702045, 0.302049995}, // 8272K
			{0.292693262, 0.302040328}, // 8273K
			{0.292684482, 0.302030663}, // 8274K
			{0.292675704, 0.302021}, // 8275K
			{0.292666929, 0.302011339}, // 8276K
			{0.292658156, 0.302001681}, // 8277K
			{0.292649386, 0.301992025}, // 8278K
			{0.292640619, 0.301982372}, // 8279K
			{0.292631854, 0.301972721}, // 8280K
			{0.292623091, 0.301963072}, // 8281K
			{0.292614332, 0.301953425}, // 8282K
			{0.292605574, 0.301943781}, // 8283K
			{0.29259682, 0.301934139}, // 8284K
			{0.292588068, 0.3019245}, // 8285K
			{0.292579318, 0.301914863}, // 8286K
			{0.292570571, 0.301905228}, // 8287K
			{0.292561827, 0.301895595}, // 8288K
			{0.292553085, 0.301885965}, // 8289K
			{0.292544346, 0.301876337}, // 8290K
			{0.292535609, 0.301866712}, // 8291K
			{0.292526875, 0.301857088}, // 8292K
			{0.292518143, 0.301847467}, // 8293K
			{0.292509414, 0.301837849}, // 8294K
			{0.292500687, 0.301828233}, // 8295K
			{0.292491963, 0.301818619}, // 8296K
			{0.292483242, 0.301809007}, // 8297K
			{0.292474523, 0.301799398}, // 8298K
			{0.292465807, 0.301789791}, // 8299K
			{0.292457093, 0.301780186}, // 8300K
			{0.292448382, 0.301770584}, // 8301K
			{0.292439673, 0.301760984}, // 8302K
			{0.292430967, 0.301751386}, // 8303K
			{0.292422263, 0.301741791}, // 8304K
			{0.292413562, 0.301732197}, // 8305K
			{0.292404863, 0.301722607}, // 8306K
			{0.292396167, 0.301713018}, // 8307K
			{0.292387474, 0.301703432}, // 8308K
			{0.292378783, 0.301693848}, // 8309K
			{0.292370095, 0.301684267}, // 8310K
			{0.292361409, 0.301674688}, // 8311K
			{0.292352726, 0.301665111}, // 8312K
			{0.292344045, 0.301655536}, // 8313K
			{0.292335366, 0.301645964}, // 8314K
			{0.292326691, 0.301636394}, // 8315K
			{0.292318018, 0.301626826}, // 8316K
			{0.292309347, 0.301617261}, // 8317K
			{0.292300679, 0.301607698}, // 8318K
			{0.292292013, 0.301598137}, // 8319K
			{0.29228335, 0.301588578}, // 8320K
			{0.292274689, 0.301579022}, // 8321K
			{0.292266031, 0.301569468}, // 8322K
			{0.292257376, 0.301559917}, // 8323K
			{0.292248723, 0.301550368}, // 8324K
			{0.292240072, 0.301540821}, // 8325K
			{0.292231424, 0.301531276}, // 8326K
			{0.292222779, 0.301521734}, // 8327K
			{0.292214136, 0.301512194}, // 8328K
			{0.292205496, 0.301502656}, // 8329K
			{0.292196858, 0.30149312}, // 8330K
			{0.292188222, 0.301483587}, // 8331K
			{0.29217959, 0.301474056}, // 8332K
			{0.292170959, 0.301464528}, // 8333K
			{0.292162331, 0.301455002}, // 8334K
			{0.292153706, 0.301445478}, // 8335K
			{0.292145083, 0.301435956}, // 8336K
			{0.292136463, 0.301426437}, // 8337K
			{0.292127845, 0.301416919}, // 8338K
			{0.29211923, 0.301407405}, // 8339K
			{0.292110617, 0.301397892}, // 8340K
			{0.292102007, 0.301388382}, // 8341K
			{0.292093399, 0.301378874}, // 8342K
			{0.292084794, 0.301369368}, // 8343K
			{0.292076191, 0.301359865}, // 8344K
			{0.292067591, 0.301350364}, // 8345K
			{0.292058993, 0.301340865}, // 8346K
			{0.292050398, 0.301331368}, // 8347K
			{0.292041805, 0.301321874}, // 8348K
			{0.292033214, 0.301312382}, // 8349K
			{0.292024627, 0.301302893}, // 8350K
			{0.292016041, 0.301293405}, // 8351K
			{0.292007459, 0.30128392}, // 8352K
			{0.291998878, 0.301274437}, // 8353K
			{0.2919903, 0.301264957}, // 8354K
			{0.291981725, 0.301255478}, // 8355K
			{0.291973152, 0.301246002}, // 8356K
			{0.291964582, 0.301236529}, // 8357K
			{0.291956014, 0.301227057}, // 8358K
			{0.291947449, 0.301217588}, // 8359K
			{0.291938886, 0.301208121}, // 8360K
			{0.291930325, 0.301198657}, // 8361K
			{0.291921768, 0.301189194}, // 8362K
			{0.291913212, 0.301179734}, // 8363K
			{0.291904659, 0.301170276}, // 8364K
			{0.291896109, 0.301160821}, // 8365K
			{0.291887561, 0.301151368}, // 8366K
			{0.291879015, 0.301141917}, // 8367K
			{0.291870472, 0.301132468}, // 8368K
			{0.291861932, 0.301123022}, // 8369K
			{0.291853394, 0.301113577}, // 8370K
			{0.291844858, 0.301104136}, // 8371K
			{0.291836325, 0.301094696}, // 8372K
			{0.291827794, 0.301085259}, // 8373K
			{0.291819266, 0.301075823}, // 8374K
			{0.29181074, 0.301066391}, // 8375K
			{0.291802217, 0.30105696}, // 8376K
			{0.291793696, 0.301047532}, // 8377K
			{0.291785178, 0.301038106}, // 8378K
			{0.291776662, 0.301028682}, // 8379K
			{0.291768149, 0.30101926}, // 8380K
			{0.291759638, 0.301009841}, // 8381K
			{0.291751129, 0.301000424}, // 8382K
			{0.291742623, 0.300991009}, // 8383K
			{0.29173412, 0.300981597}, // 8384K
			{0.291725619, 0.300972187}, // 8385K
			{0.29171712, 0.300962779}, // 8386K
			{0.291708624, 0.300953373}, // 8387K
			{0.29170013, 0.30094397}, // 8388K
			{0.291691639, 0.300934568}, // 8389K
			{0.29168315, 0.300925169}, // 8390K
			{0.291674664, 0.300915773}, // 8391K
			{0.29166618, 0.300906378}, // 8392K
			{0.291657699, 0.300896986}, // 8393K
			{0.29164922, 0.300887596}, // 8394K
			{0.291640743, 0.300878208}, // 8395K
			{0.291632269, 0.300868823}, // 8396K
			{0.291623798, 0.30085944}, // 8397K
			{0.291615329, 0.300850059}, // 8398K
			{0.291606862, 0.30084068}, // 8399K
			{0.291598398, 0.300831304}, // 8400K
			{0.291589936, 0.30082193}, // 8401K
			{0.291581476, 0.300812558}, // 8402K
			{0.291573019, 0.300803188}, // 8403K
			{0.291564565, 0.30079382}, // 8404K
			{0.291556113, 0.300784455}, // 8405K
			{0.291547663, 0.300775092}, // 8406K
			{0.291539216, 0.300765732}, // 8407K
			{0.291530771, 0.300756373}, // 8408K
			{0.291522329, 0.300747017}, // 8409K
			{0.291513889, 0.300737663}, // 8410K
			{0.291505452, 0.300728311}, // 8411K
			{0.291497017, 0.300718962}, // 8412K
			{0.291488584, 0.300709614}, // 8413K
			{0.291480154, 0.300700269}, // 8414K
			{0.291471727, 0.300690926}, // 8415K
			{0.291463301, 0.300681586}, // 8416K
			{0.291454879, 0.300672248}, // 8417K
			{0.291446458, 0.300662911}, // 8418K
			{0.29143804, 0.300653578}, // 8419K
			{0.291429625, 0.300644246}, // 8420K
			{0.291421212, 0.300634917}, // 8421K
			{0.291412801, 0.300625589}, // 8422K
			{0.291404393, 0.300616264}, // 8423K
			{0.291395987, 0.300606942}, // 8424K
			{0.291387583, 0.300597621}, // 8425K
			{0.291379182, 0.300588303}, // 8426K
			{0.291370784, 0.300578987}, // 8427K
			{0.291362388, 0.300569673}, // 8428K
			{0.291353994, 0.300560362}, // 8429K
			{0.291345603, 0.300551052}, // 8430K
			{0.291337214, 0.300541745}, // 8431K
			{0.291328827, 0.30053244}, // 8432K
			{0.291320443, 0.300523138}, // 8433K
			{0.291312062, 0.300513837}, // 8434K
			{0.291303682, 0.300504539}, // 8435K
			{0.291295306, 0.300495243}, // 8436K
			{0.291286931, 0.300485949}, // 8437K
			{0.291278559, 0.300476658}, // 8438K
			{0.29127019, 0.300467368}, // 8439K
			{0.291261822, 0.300458081}, // 8440K
			{0.291253458, 0.300448796}, // 8441K
			{0.291245095, 0.300439514}, // 8442K
			{0.291236735, 0.300430233}, // 8443K
			{0.291228378, 0.300420955}, // 8444K
			{0.291220022, 0.300411679}, // 8445K
			{0.29121167, 0.300402405}, // 8446K
			{0.291203319, 0.300393134}, // 8447K
			{0.291194971, 0.300383864}, // 8448K
			{0.291186626, 0.300374597}, // 8449K
			{0.291178283, 0.300365332}, // 8450K
			{0.291169942, 0.300356069}, // 8451K
			{0.291161604, 0.300346809}, // 8452K
			{0.291153268, 0.300337551}, // 8453K
			{0.291144934, 0.300328294}, // 8454K
			{0.291136603, 0.300319041}, // 8455K
			{0.291128274, 0.300309789}, // 8456K
			{0.291119948, 0.300300539}, // 8457K
			{0.291111624, 0.300291292}, // 8458K
			{0.291103302, 0.300282047}, // 8459K
			{0.291094983, 0.300272804}, // 8460K
			{0.291086666, 0.300263564}, // 8461K
			{0.291078352, 0.300254325}, // 8462K
			{0.29107004, 0.300245089}, // 8463K
			{0.29106173, 0.300235855}, // 8464K
			{0.291053423, 0.300226623}, // 8465K
			{0.291045118, 0.300217393}, // 8466K
			{0.291036815, 0.300208166}, // 8467K
			{0.291028515, 0.300198941}, // 8468K
			{0.291020217, 0.300189718}, // 8469K
			{0.291011922, 0.300180497}, // 8470K
			{0.291003629, 0.300171278}, // 8471K
			{0.290995338, 0.300162062}, // 8472K
			{0.29098705, 0.300152848}, // 8473K
			{0.290978764, 0.300143636}, // 8474K
			{0.290970481, 0.300134426}, // 8475K
			{0.2909622, 0.300125218}, // 8476K
			{0.290953921, 0.300116013}, // 8477K
			{0.290945644, 0.300106809}, // 8478K
			{0.29093737, 0.300097608}, // 8479K
			{0.290929099, 0.300088409}, // 8480K
			{0.29092083, 0.300079213}, // 8481K
			{0.290912563, 0.300070018}, // 8482K
			{0.290904298, 0.300060826}, // 8483K
			{0.290896036, 0.300051636}, // 8484K
			{0.290887776, 0.300042448}, // 8485K
			{0.290879519, 0.300033262}, // 8486K
			{0.290871264, 0.300024079}, // 8487K
			{0.290863011, 0.300014897}, // 8488K
			{0.290854761, 0.300005718}, // 8489K
			{0.290846513, 0.299996541}, // 8490K
			{0.290838267, 0.299987366}, // 8491K
			{0.290830024, 0.299978194}, // 8492K
			{0.290821783, 0.299969023}, // 8493K
			{0.290813544, 0.299959855}, // 8494K
			{0.290805308, 0.299950689}, // 8495K
			{0.290797074, 0.299941525}, // 8496K
			{0.290788843, 0.299932364}, // 8497K
			{0.290780614, 0.299923204}, // 8498K
			{0.290772387, 0.299914047}, // 8499K
			{0.290764163, 0.299904892}, // 8500K
			{0.290755941, 0.299895739}, // 8501K
			{0.290747721, 0.299886588}, // 8502K
			{0.290739503, 0.299877439}, // 8503K
			{0.290731288, 0.299868293}, // 8504K
			{0.290723076, 0.299859148}, // 8505K
			{0.290714865, 0.299850006}, // 8506K
			{0.290706657, 0.299840866}, // 8507K
			{0.290698452, 0.299831729}, // 8508K
			{0.290690249, 0.299822593}, // 8509K
			{0.290682048, 0.29981346}, // 8510K
			{0.290673849, 0.299804328}, // 8511K
			{0.290665653, 0.299795199}, // 8512K
			{0.290657459, 0.299786072}, // 8513K
			{0.290649267, 0.299776948}, // 8514K
			{0.290641078, 0.299767825}, // 8515K
			{0.290632891, 0.299758705}, // 8516K
			{0.290624706, 0.299749587}, // 8517K
			{0.290616524, 0.299740471}, // 8518K
			{0.290608344, 0.299731357}, // 8519K
			{0.290600167, 0.299722245}, // 8520K
			{0.290591992, 0.299713135}, // 8521K
			{0.290583819, 0.299704028}, // 8522K
			{0.290575648, 0.299694923}, // 8523K
			{0.29056748, 0.29968582}, // 8524K
			{0.290559314, 0.299676719}, // 8525K
			{0.29055115, 0.29966762}, // 8526K
			{0.290542989, 0.299658524}, // 8527K
			{0.29053483, 0.299649429}, // 8528K
			{0.290526673, 0.299640337}, // 8529K
			{0.290518519, 0.299631247}, // 8530K
			{0.290510367, 0.299622159}, // 8531K
			{0.290502218, 0.299613073}, // 8532K
			{0.29049407, 0.299603989}, // 8533K
			{0.290485925, 0.299594908}, // 8534K
			{0.290477783, 0.299585829}, // 8535K
			{0.290469642, 0.299576752}, // 8536K
			{0.290461504, 0.299567677}, // 8537K
			{0.290453368, 0.299558604}, // 8538K
			{0.290445235, 0.299549533}, // 8539K
			{0.290437104, 0.299540464}, // 8540K
			{0.290428975, 0.299531398}, // 8541K
			{0.290420849, 0.299522334}, // 8542K
			{0.290412725, 0.299513272}, // 8543K
			{0.290404603, 0.299504212}, // 8544K
			{0.290396483, 0.299495154}, // 8545K
			{0.290388366, 0.299486098}, // 8546K
			{0.290380251, 0.299477045}, // 8547K
			{0.290372139, 0.299467994}, // 8548K
			{0.290364028, 0.299458944}, // 8549K
			{0.29035592, 0.299449897}, // 8550K
			{0.290347815, 0.299440852}, // 8551K
			{0.290339711, 0.29943181}, // 8552K
			{0.29033161, 0.299422769}, // 8553K
			{0.290323511, 0.299413731}, // 8554K
			{0.290315415, 0.299404694}, // 8555K
			{0.290307321, 0.29939566}, // 8556K
			{0.290299229, 0.299386628}, // 8557K
			{0.290291139, 0.299377598}, // 8558K
			{0.290283052, 0.29936857}, // 8559K
			{0.290274967, 0.299359545}, // 8560K
			{0.290266884, 0.299350521}, // 8561K
			{0.290258804, 0.2993415}, // 8562K
			{0.290250726, 0.299332481}, // 8563K
			{0.29024265, 0.299323464}, // 8564K
			{0.290234577, 0.299314449}, // 8565K
			{0.290226505, 0.299305436}, // 8566K
			{0.290218437, 0.299296425}, // 8567K
			{0.29021037, 0.299287417}, // 8568K
			{0.290202306, 0.29927841}, // 8569K
			{0.290194243, 0.299269406}, // 8570K
			{0.290186184, 0.299260404}, // 8571K
			{0.290178126, 0.299251404}, // 8572K
			{0.290170071, 0.299242406}, // 8573K
			{0.290162018, 0.29923341}, // 8574K
			{0.290153968, 0.299224417}, // 8575K
			{0.290145919, 0.299215425}, // 8576K
			{0.290137873, 0.299206436}, // 8577K
			{0.290129829, 0.299197448}, // 8578K
			{0.290121788, 0.299188463}, // 8579K
			{0.290113749, 0.29917948}, // 8580K
			{0.290105712, 0.299170499}, // 8581K
			{0.290097677, 0.299161521}, // 8582K
			{0.290089645, 0.299152544}, // 8583K
			{0.290081615, 0.29914357}, // 8584K
			{0.290073587, 0.299134597}, // 8585K
			{0.290065561, 0.299125627}, // 8586K
			{0.290057538, 0.299116659}, // 8587K
			{0.290049517, 0.299107693}, // 8588K
			{0.290041498, 0.299098729}, // 8589K
			{0.290033482, 0.299089767}, // 8590K
			{0.290025468, 0.299080808}, // 8591K
			{0.290017456, 0.29907185}, // 8592K
			{0.290009446, 0.299062895}, // 8593K
			{0.290001439, 0.299053941}, // 8594K
			{0.289993433, 0.29904499}, // 8595K
			{0.289985431, 0.299036041}, // 8596K
			{0.28997743, 0.299027094}, // 8597K
			{0.289969432, 0.29901815}, // 8598K
			{0.289961436, 0.299009207}, // 8599K
			{0.289953442, 0.299000266}, // 8600K
			{0.28994545, 0.298991328}, // 8601K
			{0.289937461, 0.298982391}, // 8602K
			{0.289929474, 0.298973457}, // 8603K
			{0.289921489, 0.298964525}, // 8604K
			{0.289913507, 0.298955595}, // 8605K
			{0.289905526, 0.298946667}, // 8606K
			{0.289897548, 0.298937741}, // 8607K
			{0.289889573, 0.298928817}, // 8608K
			{0.289881599, 0.298919896}, // 8609K
			{0.289873628, 0.298910976}, // 8610K
			{0.289865659, 0.298902059}, // 8611K
			{0.289857692, 0.298893144}, // 8612K
			{0.289849728, 0.29888423}, // 8613K
			{0.289841765, 0.298875319}, // 8614K
			{0.289833806, 0.29886641}, // 8615K
			{0.289825848, 0.298857504}, // 8616K
			{0.289817892, 0.298848599}, // 8617K
			{0.289809939, 0.298839696}, // 8618K
			{0.289801988, 0.298830796}, // 8619K
			{0.289794039, 0.298821897}, // 8620K
			{0.289786093, 0.298813001}, // 8621K
			{0.289778149, 0.298804106}, // 8622K
			{0.289770206, 0.298795214}, // 8623K
			{0.289762267, 0.298786324}, // 8624K
			{0.289754329, 0.298777436}, // 8625K
			{0.289746394, 0.29876855}, // 8626K
			{0.289738461, 0.298759667}, // 8627K
			{0.28973053, 0.298750785}, // 8628K
			{0.289722601, 0.298741905}, // 8629K
			{0.289714675, 0.298733028}, // 8630K
			{0.289706751, 0.298724152}, // 8631K
			{0.289698829, 0.298715279}, // 8632K
			{0.289690909, 0.298706408}, // 8633K
			{0.289682992, 0.298697539}, // 8634K
			{0.289675077, 0.298688672}, // 8635K
			{0.289667164, 0.298679807}, // 8636K
			{0.289659253, 0.298670944}, // 8637K
			{0.289651344, 0.298662083}, // 8638K
			{0.289643438, 0.298653224}, // 8639K
			{0.289635534, 0.298644368}, // 8640K
			{0.289627632, 0.298635513}, // 8641K
			{0.289619733, 0.298626661}, // 8642K
			{0.289611835, 0.29861781}, // 8643K
			{0.28960394, 0.298608962}, // 8644K
			{0.289596047, 0.298600116}, // 8645K
			{0.289588157, 0.298591272}, // 8646K
			{0.289580268, 0.29858243}, // 8647K
			{0.289572382, 0.29857359}, // 8648K
			{0.289564498, 0.298564752}, // 8649K
			{0.289556616, 0.298555916}, // 8650K
			{0.289548736, 0.298547083}, // 8651K
			{0.289540859, 0.298538251}, // 8652K
			{0.289532984, 0.298529422}, // 8653K
			{0.289525111, 0.298520594}, // 8654K
			{0.28951724, 0.298511769}, // 8655K
			{0.289509372, 0.298502946}, // 8656K
			{0.289501505, 0.298494124}, // 8657K
			{0.289493641, 0.298485305}, // 8658K
			{0.289485779, 0.298476488}, // 8659K
			{0.289477919, 0.298467673}, // 8660K
			{0.289470062, 0.29845886}, // 8661K
			{0.289462207, 0.298450049}, // 8662K
			{0.289454354, 0.298441241}, // 8663K
			{0.289446503, 0.298432434}, // 8664K
			{0.289438654, 0.298423629}, // 8665K
			{0.289430808, 0.298414827}, // 8666K
			{0.289422963, 0.298406026}, // 8667K
			{0.289415121, 0.298397228}, // 8668K
			{0.289407282, 0.298388432}, // 8669K
			{0.289399444, 0.298379637}, // 8670K
			{0.289391608, 0.298370845}, // 8671K
			{0.289383775, 0.298362055}, // 8672K
			{0.289375944, 0.298353267}, // 8673K
			{0.289368115, 0.298344481}, // 8674K
			{0.289360289, 0.298335697}, // 8675K
			{0.289352464, 0.298326915}, // 8676K
			{0.289344642, 0.298318135}, // 8677K
			{0.289336822, 0.298309357}, // 8678K
			{0.289329004, 0.298300582}, // 8679K
			{0.289321188, 0.298291808}, // 8680K
			{0.289313375, 0.298283037}, // 8681K
			{0.289305564, 0.298274267}, // 8682K
			{0.289297755, 0.2982655}, // 8683K
			{0.289289948, 0.298256734}, // 8684K
			{0.289282143, 0.298247971}, // 8685K
			{0.28927434, 0.29823921}, // 8686K
			{0.28926654, 0.29823045}, // 8687K
			{0.289258742, 0.298221693}, // 8688K
			{0.289250946, 0.298212938}, // 8689K
			{0.289243152, 0.298204185}, // 8690K
			{0.28923536, 0.298195434}, // 8691K
			{0.289227571, 0.298186685}, // 8692K
			{0.289219784, 0.298177938}, // 8693K
			{0.289211999, 0.298169193}, // 8694K
			{0.289204216, 0.298160451}, // 8695K
			{0.289196435, 0.29815171}, // 8696K
			{0.289188657, 0.298142971}, // 8697K
			{0.28918088, 0.298134235}, // 8698K
			{0.289173106, 0.2981255}, // 8699K
			{0.289165334, 0.298116768}, // 8700K
			{0.289157564, 0.298108037}, // 8701K
			{0.289149797, 0.298099309}, // 8702K
			{0.289142031, 0.298090582}, // 8703K
			{0.289134268, 0.298081858}, // 8704K
			{0.289126507, 0.298073136}, // 8705K
			{0.289118748, 0.298064415}, // 8706K
			{0.289110991, 0.298055697}, // 8707K
			{0.289103236, 0.298046981}, // 8708K
			{0.289095484, 0.298038267}, // 8709K
			{0.289087734, 0.298029555}, // 8710K
			{0.289079985, 0.298020845}, // 8711K
			{0.28907224, 0.298012137}, // 8712K
			{0.289064496, 0.298003431}, // 8713K
			{0.289056754, 0.297994727}, // 8714K
			{0.289049015, 0.297986025}, // 8715K
			{0.289041277, 0.297977325}, // 8716K
			{0.289033542, 0.297968628}, // 8717K
			{0.289025809, 0.297959932}, // 8718K
			{0.289018078, 0.297951238}, // 8719K
			{0.28901035, 0.297942547}, // 8720K
			{0.289002623, 0.297933857}, // 8721K
			{0.288994899, 0.297925169}, // 8722K
			{0.288987177, 0.297916484}, // 8723K
			{0.288979457, 0.2979078}, // 8724K
			{0.288971739, 0.297899119}, // 8725K
			{0.288964023, 0.297890439}, // 8726K
			{0.28895631, 0.297881762}, // 8727K
			{0.288948598, 0.297873086}, // 8728K
			{0.288940889, 0.297864413}, // 8729K
			{0.288933182, 0.297855742}, // 8730K
			{0.288925477, 0.297847072}, // 8731K
			{0.288917774, 0.297838405}, // 8732K
			{0.288910073, 0.29782974}, // 8733K
			{0.288902375, 0.297821077}, // 8734K
			{0.288894679, 0.297812416}, // 8735K
			{0.288886984, 0.297803756}, // 8736K
			{0.288879292, 0.297795099}, // 8737K
			{0.288871602, 0.297786444}, // 8738K
			{0.288863915, 0.297777791}, // 8739K
			{0.288856229, 0.29776914}, // 8740K
			{0.288848545, 0.297760491}, // 8741K
			{0.288840864, 0.297751844}, // 8742K
			{0.288833185, 0.297743199}, // 8743K
			{0.288825508, 0.297734556}, // 8744K
			{0.288817833, 0.297725915}, // 8745K
			{0.28881016, 0.297717276}, // 8746K
			{0.288802489, 0.297708639}, // 8747K
			{0.288794821, 0.297700004}, // 8748K
			{0.288787154, 0.297691371}, // 8749K
			{0.28877949, 0.297682741}, // 8750K
			{0.288771828, 0.297674112}, // 8751K
			{0.288764168, 0.297665485}, // 8752K
			{0.28875651, 0.29765686}, // 8753K
			{0.288748854, 0.297648237}, // 8754K
			{0.288741201, 0.297639617}, // 8755K
			{0.288733549, 0.297630998}, // 8756K
			{0.2887259, 0.297622381}, // 8757K
			{0.288718253, 0.297613766}, // 8758K
			{0.288710608, 0.297605154}, // 8759K
			{0.288702965, 0.297596543}, // 8760K
			{0.288695324, 0.297587934}, // 8761K
			{0.288687685, 0.297579328}, // 8762K
			{0.288680049, 0.297570723}, // 8763K
			{0.288672414, 0.29756212}, // 8764K
			{0.288664782, 0.29755352}, // 8765K
			{0.288657152, 0.297544921}, // 8766K
			{0.288649524, 0.297536324}, // 8767K
			{0.288641898, 0.29752773}, // 8768K
			{0.288634274, 0.297519137}, // 8769K
			{0.288626652, 0.297510546}, // 8770K
			{0.288619032, 0.297501958}, // 8771K
			{0.288611415, 0.297493371}, // 8772K
			{0.288603799, 0.297484787}, // 8773K
			{0.288596186, 0.297476204}, // 8774K
			{0.288588575, 0.297467623}, // 8775K
			{0.288580966, 0.297459045}, // 8776K
			{0.288573359, 0.297450468}, // 8777K
			{0.288565754, 0.297441894}, // 8778K
			{0.288558151, 0.297433321}, // 8779K
			{0.288550551, 0.29742475}, // 8780K
			{0.288542952, 0.297416182}, // 8781K
			{0.288535356, 0.297407615}, // 8782K
			{0.288527762, 0.297399051}, // 8783K
			{0.28852017, 0.297390488}, // 8784K
			{0.288512579, 0.297381927}, // 8785K
			{0.288504992, 0.297373369}, // 8786K
			{0.288497406, 0.297364812}, // 8787K
			{0.288489822, 0.297356258}, // 8788K
			{0.28848224, 0.297347705}, // 8789K
			{0.288474661, 0.297339154}, // 8790K
			{0.288467083, 0.297330606}, // 8791K
			{0.288459508, 0.297322059}, // 8792K
			{0.288451935, 0.297313514}, // 8793K
			{0.288444364, 0.297304972}, // 8794K
			{0.288436795, 0.297296431}, // 8795K
			{0.288429228, 0.297287892}, // 8796K
			{0.288421663, 0.297279356}, // 8797K
			{0.2884141, 0.297270821}, // 8798K
			{0.288406539, 0.297262288}, // 8799K
			{0.288398981, 0.297253758}, // 8800K
			{0.288391424, 0.297245229}, // 8801K
			{0.28838387, 0.297236702}, // 8802K
			{0.288376318, 0.297228177}, // 8803K
			{0.288368767, 0.297219655}, // 8804K
			{0.288361219, 0.297211134}, // 8805K
			{0.288353673, 0.297202615}, // 8806K
			{0.288346129, 0.297194098}, // 8807K
			{0.288338587, 0.297185583}, // 8808K
			{0.288331048, 0.29717707}, // 8809K
			{0.28832351, 0.29716856}, // 8810K
			{0.288315974, 0.297160051}, // 8811K
			{0.288308441, 0.297151544}, // 8812K
			{0.28830091, 0.297143039}, // 8813K
			{0.28829338, 0.297134536}, // 8814K
			{0.288285853, 0.297126035}, // 8815K
			{0.288278328, 0.297117536}, // 8816K
			{0.288270805, 0.297109039}, // 8817K
			{0.288263284, 0.297100544}, // 8818K
			{0.288255765, 0.297092051}, // 8819K
			{0.288248248, 0.29708356}, // 8820K
			{0.288240733, 0.29707507}, // 8821K
			{0.28823322, 0.297066583}, // 8822K
			{0.28822571, 0.297058098}, // 8823K
			{0.288218201, 0.297049615}, // 8824K
			{0.288210695, 0.297041134}, // 8825K
			{0.28820319, 0.297032654}, // 8826K
			{0.288195688, 0.297024177}, // 8827K
			{0.288188188, 0.297015702}, // 8828K
			{0.28818069, 0.297007229}, // 8829K
			{0.288173193, 0.296998757}, // 8830K
			{0.288165699, 0.296990288}, // 8831K
			{0.288158207, 0.29698182}, // 8832K
			{0.288150718, 0.296973355}, // 8833K
			{0.28814323, 0.296964891}, // 8834K
			{0.288135744, 0.29695643}, // 8835K
			{0.28812826, 0.29694797}, // 8836K
			{0.288120779, 0.296939513}, // 8837K
			{0.288113299, 0.296931057}, // 8838K
			{0.288105821, 0.296922603}, // 8839K
			{0.288098346, 0.296914152}, // 8840K
			{0.288090873, 0.296905702}, // 8841K
			{0.288083401, 0.296897254}, // 8842K
			{0.288075932, 0.296888808}, // 8843K
			{0.288068465, 0.296880364}, // 8844K
			{0.288061, 0.296871922}, // 8845K
			{0.288053536, 0.296863483}, // 8846K
			{0.288046075, 0.296855045}, // 8847K
			{0.288038616, 0.296846608}, // 8848K
			{0.28803116, 0.296838174}, // 8849K
			{0.288023705, 0.296829742}, // 8850K
			{0.288016252, 0.296821312}, // 8851K
			{0.288008801, 0.296812884}, // 8852K
			{0.288001352, 0.296804458}, // 8853K
			{0.287993906, 0.296796033}, // 8854K
			{0.287986461, 0.296787611}, // 8855K
			{0.287979018, 0.296779191}, // 8856K
			{0.287971578, 0.296770772}, // 8857K
			{0.28796414, 0.296762356}, // 8858K
			{0.287956703, 0.296753941}, // 8859K
			{0.287949269, 0.296745529}, // 8860K
			{0.287941836, 0.296737118}, // 8861K
			{0.287934406, 0.296728709}, // 8862K
			{0.287926978, 0.296720303}, // 8863K
			{0.287919552, 0.296711898}, // 8864K
			{0.287912128, 0.296703495}, // 8865K
			{0.287904705, 0.296695094}, // 8866K
			{0.287897285, 0.296686695}, // 8867K
			{0.287889867, 0.296678298}, // 8868K
			{0.287882451, 0.296669903}, // 8869K
			{0.287875037, 0.29666151}, // 8870K
			{0.287867625, 0.296653119}, // 8871K
			{0.287860216, 0.29664473}, // 8872K
			{0.287852808, 0.296636343}, // 8873K
			{0.287845402, 0.296627957}, // 8874K
			{0.287837998, 0.296619574}, // 8875K
			{0.287830596, 0.296611193}, // 8876K
			{0.287823197, 0.296602813}, // 8877K
			{0.287815799, 0.296594436}, // 8878K
			{0.287808403, 0.29658606}, // 8879K
			{0.28780101, 0.296577686}, // 8880K
			{0.287793618, 0.296569315}, // 8881K
			{0.287786229, 0.296560945}, // 8882K
			{0.287778841, 0.296552577}, // 8883K
			{0.287771456, 0.296544211}, // 8884K
			{0.287764072, 0.296535847}, // 8885K
			{0.287756691, 0.296527485}, // 8886K
			{0.287749311, 0.296519125}, // 8887K
			{0.287741934, 0.296510767}, // 8888K
			{0.287734559, 0.296502411}, // 8889K
			{0.287727185, 0.296494056}, // 8890K
			{0.287719814, 0.296485704}, // 8891K
			{0.287712445, 0.296477354}, // 8892K
			{0.287705078, 0.296469005}, // 8893K
			{0.287697712, 0.296460659}, // 8894K
			{0.287690349, 0.296452314}, // 8895K
			{0.287682988, 0.296443971}, // 8896K
			{0.287675629, 0.29643563}, // 8897K
			{0.287668272, 0.296427292}, // 8898K
			{0.287660916, 0.296418955}, // 8899K
			{0.287653563, 0.29641062}, // 8900K
			{0.287646212, 0.296402287}, // 8901K
			{0.287638863, 0.296393955}, // 8902K
			{0.287631516, 0.296385626}, // 8903K
			{0.287624171, 0.296377299}, // 8904K
			{0.287616828, 0.296368974}, // 8905K
			{0.287609487, 0.29636065}, // 8906K
			{0.287602148, 0.296352329}, // 8907K
			{0.287594811, 0.296344009}, // 8908K
			{0.287587476, 0.296335691}, // 8909K
			{0.287580143, 0.296327376}, // 8910K
			{0.287572812, 0.296319062}, // 8911K
			{0.287565483, 0.29631075}, // 8912K
			{0.287558156, 0.29630244}, // 8913K
			{0.287550831, 0.296294132}, // 8914K
			{0.287543508, 0.296285826}, // 8915K
			{0.287536187, 0.296277522}, // 8916K
			{0.287528868, 0.296269219}, // 8917K
			{0.287521551, 0.296260919}, // 8918K
			{0.287514236, 0.296252621}, // 8919K
			{0.287506923, 0.296244324}, // 8920K
			{0.287499612, 0.296236029}, // 8921K
			{0.287492303, 0.296227737}, // 8922K
			{0.287484996, 0.296219446}, // 8923K
			{0.287477691, 0.296211157}, // 8924K
			{0.287470388, 0.29620287}, // 8925K
			{0.287463087, 0.296194585}, // 8926K
			{0.287455788, 0.296186302}, // 8927K
			{0.287448491, 0.29617802}, // 8928K
			{0.287441196, 0.296169741}, // 8929K
			{0.287433903, 0.296161464}, // 8930K
			{0.287426612, 0.296153188}, // 8931K
			{0.287419323, 0.296144915}, // 8932K
			{0.287412036, 0.296136643}, // 8933K
			{0.287404751, 0.296128373}, // 8934K
			{0.287397468, 0.296120105}, // 8935K
			{0.287390187, 0.296111839}, // 8936K
			{0.287382908, 0.296103575}, // 8937K
			{0.28737563, 0.296095313}, // 8938K
			{0.287368355, 0.296087053}, // 8939K
			{0.287361082, 0.296078795}, // 8940K
			{0.287353811, 0.296070538}, // 8941K
			{0.287346542, 0.296062284}, // 8942K
			{0.287339275, 0.296054031}, // 8943K
			{0.28733201, 0.29604578}, // 8944K
			{0.287324746, 0.296037531}, // 8945K
			{0.287317485, 0.296029284}, // 8946K
			{0.287310226, 0.296021039}, // 8947K
			{0.287302969, 0.296012796}, // 8948K
			{0.287295713, 0.296004555}, // 8949K
			{0.28728846, 0.295996316}, // 8950K
			{0.287281209, 0.295988078}, // 8951K
			{0.287273959, 0.295979843}, // 8952K
			{0.287266712, 0.295971609}, // 8953K
			{0.287259467, 0.295963377}, // 8954K
			{0.287252223, 0.295955148}, // 8955K
			{0.287244982, 0.29594692}, // 8956K
			{0.287237742, 0.295938694}, // 8957K
			{0.287230505, 0.295930469}, // 8958K
			{0.287223269, 0.295922247}, // 8959K
			{0.287216036, 0.295914027}, // 8960K
			{0.287208804, 0.295905808}, // 8961K
			{0.287201575, 0.295897592}, // 8962K
			{0.287194347, 0.295889377}, // 8963K
			{0.287187121, 0.295881164}, // 8964K
			{0.287179898, 0.295872953}, // 8965K
			{0.287172676, 0.295864744}, // 8966K
			{0.287165456, 0.295856537}, // 8967K
			{0.287158238, 0.295848332}, // 8968K
			{0.287151022, 0.295840129}, // 8969K
			{0.287143808, 0.295831927}, // 8970K
			{0.287136597, 0.295823728}, // 8971K
			{0.287129387, 0.29581553}, // 8972K
			{0.287122179, 0.295807334}, // 8973K
			{0.287114973, 0.29579914}, // 8974K
			{0.287107768, 0.295790948}, // 8975K
			{0.287100566, 0.295782758}, // 8976K
			{0.287093366, 0.29577457}, // 8977K
			{0.287086168, 0.295766383}, // 8978K
			{0.287078972, 0.295758199}, // 8979K
			{0.287071777, 0.295750016}, // 8980K
			{0.287064585, 0.295741836}, // 8981K
			{0.287057395, 0.295733657}, // 8982K
			{0.287050206, 0.29572548}, // 8983K
			{0.28704302, 0.295717305}, // 8984K
			{0.287035835, 0.295709131}, // 8985K
			{0.287028653, 0.29570096}, // 8986K
			{0.287021472, 0.295692791}, // 8987K
			{0.287014293, 0.295684623}, // 8988K
			{0.287007117, 0.295676457}, // 8989K
			{0.286999942, 0.295668293}, // 8990K
			{0.286992769, 0.295660131}, // 8991K
			{0.286985598, 0.295651971}, // 8992K
			{0.286978429, 0.295643813}, // 8993K
			{0.286971262, 0.295635657}, // 8994K
			{0.286964097, 0.295627502}, // 8995K
			{0.286956934, 0.29561935}, // 8996K
			{0.286949773, 0.295611199}, // 8997K
			{0.286942614, 0.29560305}, // 8998K
			{0.286935457, 0.295594903}, // 8999K
			{0.286928301, 0.295586758}, // 9000K
			{0.286921148, 0.295578615}, // 9001K
			{0.286913996, 0.295570474}, // 9002K
			{0.286906847, 0.295562334}, // 9003K
			{0.286899699, 0.295554196}, // 9004K
			{0.286892554, 0.295546061}, // 9005K
			{0.28688541, 0.295537927}, // 9006K
			{0.286878268, 0.295529795}, // 9007K
			{0.286871128, 0.295521665}, // 9008K
			{0.286863991, 0.295513536}, // 9009K
			{0.286856855, 0.29550541}, // 9010K
			{0.286849721, 0.295497285}, // 9011K
			{0.286842588, 0.295489163}, // 9012K
			{0.286835458, 0.295481042}, // 9013K
			{0.28682833, 0.295472923}, // 9014K
			{0.286821204, 0.295464806}, // 9015K
			{0.286814079, 0.29545669}, // 9016K
			{0.286806957, 0.295448577}, // 9017K
			{0.286799837, 0.295440466}, // 9018K
			{0.286792718, 0.295432356}, // 9019K
			{0.286785601, 0.295424248}, // 9020K
			{0.286778487, 0.295416142}, // 9021K
			{0.286771374, 0.295408038}, // 9022K
			{0.286764263, 0.295399936}, // 9023K
			{0.286757154, 0.295391835}, // 9024K
			{0.286750047, 0.295383737}, // 9025K
			{0.286742942, 0.29537564}, // 9026K
			{0.286735839, 0.295367545}, // 9027K
			{0.286728737, 0.295359452}, // 9028K
			{0.286721638, 0.295351361}, // 9029K
			{0.286714541, 0.295343272}, // 9030K
			{0.286707445, 0.295335185}, // 9031K
			{0.286700352, 0.295327099}, // 9032K
			{0.28669326, 0.295319015}, // 9033K
			{0.28668617, 0.295310934}, // 9034K
			{0.286679082, 0.295302854}, // 9035K
			{0.286671996, 0.295294775}, // 9036K
			{0.286664912, 0.295286699}, // 9037K
			{0.28665783, 0.295278625}, // 9038K
			{0.28665075, 0.295270552}, // 9039K
			{0.286643672, 0.295262481}, // 9040K
			{0.286636596, 0.295254412}, // 9041K
			{0.286629521, 0.295246345}, // 9042K
			{0.286622449, 0.29523828}, // 9043K
			{0.286615378, 0.295230217}, // 9044K
			{0.286608309, 0.295222155}, // 9045K
			{0.286601243, 0.295214096}, // 9046K
			{0.286594178, 0.295206038}, // 9047K
			{0.286587115, 0.295197982}, // 9048K
			{0.286580054, 0.295189928}, // 9049K
			{0.286572994, 0.295181875}, // 9050K
			{0.286565937, 0.295173825}, // 9051K
			{0.286558882, 0.295165776}, // 9052K
			{0.286551828, 0.29515773}, // 9053K
			{0.286544777, 0.295149685}, // 9054K
			{0.286537727, 0.295141642}, // 9055K
			{0.286530679, 0.2951336}, // 9056K
			{0.286523634, 0.295125561}, // 9057K
			{0.28651659, 0.295117523}, // 9058K
			{0.286509548, 0.295109488}, // 9059K
			{0.286502507, 0.295101454}, // 9060K
			{0.286495469, 0.295093422}, // 9061K
			{0.286488433, 0.295085391}, // 9062K
			{0.286481398, 0.295077363}, // 9063K
			{0.286474366, 0.295069336}, // 9064K
			{0.286467335, 0.295061312}, // 9065K
			{0.286460306, 0.295053289}, // 9066K
			{0.286453279, 0.295045268}, // 9067K
			{0.286446254, 0.295037249}, // 9068K
			{0.286439231, 0.295029231}, // 9069K
			{0.28643221, 0.295021216}, // 9070K
			{0.286425191, 0.295013202}, // 9071K
			{0.286418173, 0.29500519}, // 9072K
			{0.286411158, 0.29499718}, // 9073K
			{0.286404144, 0.294989172}, // 9074K
			{0.286397132, 0.294981165}, // 9075K
			{0.286390123, 0.294973161}, // 9076K
			{0.286383115, 0.294965158}, // 9077K
			{0.286376108, 0.294957157}, // 9078K
			{0.286369104, 0.294949158}, // 9079K
			{0.286362102, 0.294941161}, // 9080K
			{0.286355101, 0.294933165}, // 9081K
			{0.286348103, 0.294925172}, // 9082K
			{0.286341106, 0.29491718}, // 9083K
			{0.286334111, 0.29490919}, // 9084K
			{0.286327119, 0.294901202}, // 9085K
			{0.286320127, 0.294893215}, // 9086K
			{0.286313138, 0.294885231}, // 9087K
			{0.286306151, 0.294877248}, // 9088K
			{0.286299166, 0.294869267}, // 9089K
			{0.286292182, 0.294861288}, // 9090K
			{0.2862852, 0.294853311}, // 9091K
			{0.286278221, 0.294845335}, // 9092K
			{0.286271243, 0.294837362}, // 9093K
			{0.286264267, 0.29482939}, // 9094K
			{0.286257293, 0.29482142}, // 9095K
			{0.28625032, 0.294813452}, // 9096K
			{0.28624335, 0.294805486}, // 9097K
			{0.286236381, 0.294797521}, // 9098K
			{0.286229415, 0.294789558}, // 9099K
			{0.28622245, 0.294781598}, // 9100K
			{0.286215487, 0.294773639}, // 9101K
			{0.286208526, 0.294765681}, // 9102K
			{0.286201567, 0.294757726}, // 9103K
			{0.286194609, 0.294749772}, // 9104K
			{0.286187654, 0.29474182}, // 9105K
			{0.2861807, 0.29473387}, // 9106K
			{0.286173749, 0.294725922}, // 9107K
			{0.286166799, 0.294717976}, // 9108K
			{0.286159851, 0.294710031}, // 9109K
			{0.286152905, 0.294702089}, // 9110K
			{0.286145961, 0.294694148}, // 9111K
			{0.286139018, 0.294686208}, // 9112K
			{0.286132078, 0.294678271}, // 9113K
			{0.286125139, 0.294670336}, // 9114K
			{0.286118202, 0.294662402}, // 9115K
			{0.286111267, 0.29465447}, // 9116K
			{0.286104334, 0.29464654}, // 9117K
			{0.286097403, 0.294638612}, // 9118K
			{0.286090473, 0.294630685}, // 9119K
			{0.286083546, 0.29462276}, // 9120K
			{0.28607662, 0.294614837}, // 9121K
			{0.286069696, 0.294606916}, // 9122K
			{0.286062774, 0.294598997}, // 9123K
			{0.286055854, 0.29459108}, // 9124K
			{0.286048936, 0.294583164}, // 9125K
			{0.28604202, 0.29457525}, // 9126K
			{0.286035105, 0.294567338}, // 9127K
			{0.286028192, 0.294559428}, // 9128K
			{0.286021282, 0.294551519}, // 9129K
			{0.286014373, 0.294543612}, // 9130K
			{0.286007465, 0.294535708}, // 9131K
			{0.28600056, 0.294527805}, // 9132K
			{0.285993657, 0.294519903}, // 9133K
			{0.285986755, 0.294512004}, // 9134K
			{0.285979855, 0.294504106}, // 9135K
			{0.285972957, 0.29449621}, // 9136K
			{0.285966061, 0.294488316}, // 9137K
			{0.285959167, 0.294480424}, // 9138K
			{0.285952275, 0.294472533}, // 9139K
			{0.285945384, 0.294464644}, // 9140K
			{0.285938496, 0.294456758}, // 9141K
			{0.285931609, 0.294448872}, // 9142K
			{0.285924724, 0.294440989}, // 9143K
			{0.28591784, 0.294433107}, // 9144K
			{0.285910959, 0.294425228}, // 9145K
			{0.28590408, 0.29441735}, // 9146K
			{0.285897202, 0.294409474}, // 9147K
			{0.285890326, 0.294401599}, // 9148K
			{0.285883452, 0.294393726}, // 9149K
			{0.28587658, 0.294385856}, // 9150K
			{0.28586971, 0.294377987}, // 9151K
			{0.285862841, 0.294370119}, // 9152K
			{0.285855975, 0.294362254}, // 9153K
			{0.28584911, 0.29435439}, // 9154K
			{0.285842247, 0.294346528}, // 9155K
			{0.285835386, 0.294338668}, // 9156K
			{0.285828526, 0.29433081}, // 9157K
			{0.285821669, 0.294322953}, // 9158K
			{0.285814813, 0.294315099}, // 9159K
			{0.285807959, 0.294307246}, // 9160K
			{0.285801107, 0.294299394}, // 9161K
			{0.285794257, 0.294291545}, // 9162K
			{0.285787409, 0.294283697}, // 9163K
			{0.285780562, 0.294275852}, // 9164K
			{0.285773718, 0.294268007}, // 9165K
			{0.285766875, 0.294260165}, // 9166K
			{0.285760034, 0.294252325}, // 9167K
			{0.285753195, 0.294244486}, // 9168K
			{0.285746357, 0.294236649}, // 9169K
			{0.285739522, 0.294228814}, // 9170K
			{0.285732688, 0.29422098}, // 9171K
			{0.285725856, 0.294213149}, // 9172K
			{0.285719026, 0.294205319}, // 9173K
			{0.285712198, 0.294197491}, // 9174K
			{0.285705371, 0.294189664}, // 9175K
			{0.285698547, 0.29418184}, // 9176K
			{0.285691724, 0.294174017}, // 9177K
			{0.285684903, 0.294166196}, // 9178K
			{0.285678083, 0.294158377}, // 9179K
			{0.285671266, 0.29415056}, // 9180K
			{0.285664451, 0.294142744}, // 9181K
			{0.285657637, 0.29413493}, // 9182K
			{0.285650825, 0.294127118}, // 9183K
			{0.285644015, 0.294119308}, // 9184K
			{0.285637206, 0.294111499}, // 9185K
			{0.2856304, 0.294103692}, // 9186K
			{0.285623595, 0.294095887}, // 9187K
			{0.285616792, 0.294088084}, // 9188K
			{0.285609991, 0.294080282}, // 9189K
			{0.285603192, 0.294072482}, // 9190K
			{0.285596395, 0.294064684}, // 9191K
			{0.285589599, 0.294056888}, // 9192K
			{0.285582805, 0.294049094}, // 9193K
			{0.285576013, 0.294041301}, // 9194K
			{0.285569223, 0.29403351}, // 9195K
			{0.285562435, 0.294025721}, // 9196K
			{0.285555648, 0.294017934}, // 9197K
			{0.285548863, 0.294010148}, // 9198K
			{0.28554208, 0.294002364}, // 9199K
			{0.285535299, 0.293994582}, // 9200K
			{0.28552852, 0.293986802}, // 9201K
			{0.285521742, 0.293979023}, // 9202K
			{0.285514966, 0.293971246}, // 9203K
			{0.285508192, 0.293963471}, // 9204K
			{0.28550142, 0.293955698}, // 9205K
			{0.28549465, 0.293947926}, // 9206K
			{0.285487881, 0.293940156}, // 9207K
			{0.285481114, 0.293932388}, // 9208K
			{0.285474349, 0.293924622}, // 9209K
			{0.285467586, 0.293916858}, // 9210K
			{0.285460825, 0.293909095}, // 9211K
			{0.285454065, 0.293901334}, // 9212K
			{0.285447307, 0.293893575}, // 9213K
			{0.285440551, 0.293885817}, // 9214K
			{0.285433797, 0.293878061}, // 9215K
			{0.285427044, 0.293870307}, // 9216K
			{0.285420294, 0.293862555}, // 9217K
			{0.285413545, 0.293854804}, // 9218K
			{0.285406798, 0.293847056}, // 9219K
			{0.285400052, 0.293839309}, // 9220K
			{0.285393309, 0.293831563}, // 9221K
			{0.285386567, 0.29382382}, // 9222K
			{0.285379827, 0.293816078}, // 9223K
			{0.285373089, 0.293808338}, // 9224K
			{0.285366353, 0.2938006}, // 9225K
			{0.285359618, 0.293792863}, // 9226K
			{0.285352886, 0.293785129}, // 9227K
			{0.285346155, 0.293777396}, // 9228K
			{0.285339425, 0.293769664}, // 9229K
			{0.285332698, 0.293761935}, // 9230K
			{0.285325972, 0.293754207}, // 9231K
			{0.285319248, 0.293746481}, // 9232K
			{0.285312526, 0.293738757}, // 9233K
			{0.285305806, 0.293731034}, // 9234K
			{0.285299087, 0.293723313}, // 9235K
			{0.285292371, 0.293715594}, // 9236K
			{0.285285656, 0.293707877}, // 9237K
			{0.285278943, 0.293700161}, // 9238K
			{0.285272231, 0.293692448}, // 9239K
			{0.285265522, 0.293684735}, // 9240K
			{0.285258814, 0.293677025}, // 9241K
			{0.285252108, 0.293669316}, // 9242K
			{0.285245403, 0.29366161}, // 9243K
			{0.285238701, 0.293653904}, // 9244K
			{0.285232, 0.293646201}, // 9245K
			{0.285225301, 0.293638499}, // 9246K
			{0.285218604, 0.293630799}, // 9247K
			{0.285211908, 0.293623101}, // 9248K
			{0.285205215, 0.293615405}, // 9249K
			{0.285198523, 0.29360771}, // 9250K
			{0.285191833, 0.293600017}, // 9251K
			{0.285185144, 0.293592326}, // 9252K
			{0.285178458, 0.293584636}, // 9253K
			{0.285171773, 0.293576948}, // 9254K
			{0.28516509, 0.293569262}, // 9255K
			{0.285158408, 0.293561578}, // 9256K
			{0.285151729, 0.293553895}, // 9257K
			{0.285145051, 0.293546215}, // 9258K
			{0.285138375, 0.293538535}, // 9259K
			{0.285131701, 0.293530858}, // 9260K
			{0.285125028, 0.293523182}, // 9261K
			{0.285118358, 0.293515508}, // 9262K
			{0.285111689, 0.293507836}, // 9263K
			{0.285105022, 0.293500166}, // 9264K
			{0.285098356, 0.293492497}, // 9265K
			{0.285091692, 0.29348483}, // 9266K
			{0.28508503, 0.293477165}, // 9267K
			{0.28507837, 0.293469501}, // 9268K
			{0.285071712, 0.293461839}, // 9269K
			{0.285065055, 0.293454179}, // 9270K
			{0.2850584, 0.293446521}, // 9271K
			{0.285051747, 0.293438864}, // 9272K
			{0.285045096, 0.293431209}, // 9273K
			{0.285038446, 0.293423556}, // 9274K
			{0.285031798, 0.293415904}, // 9275K
			{0.285025152, 0.293408254}, // 9276K
			{0.285018508, 0.293400606}, // 9277K
			{0.285011865, 0.29339296}, // 9278K
			{0.285005224, 0.293385315}, // 9279K
			{0.284998585, 0.293377672}, // 9280K
			{0.284991948, 0.293370031}, // 9281K
			{0.284985312, 0.293362392}, // 9282K
			{0.284978678, 0.293354754}, // 9283K
			{0.284972046, 0.293347118}, // 9284K
			{0.284965416, 0.293339484}, // 9285K
			{0.284958787, 0.293331851}, // 9286K
			{0.28495216, 0.29332422}, // 9287K
			{0.284945535, 0.293316591}, // 9288K
			{0.284938912, 0.293308963}, // 9289K
			{0.28493229, 0.293301338}, // 9290K
			{0.28492567, 0.293293714}, // 9291K
			{0.284919052, 0.293286091}, // 9292K
			{0.284912436, 0.293278471}, // 9293K
			{0.284905821, 0.293270852}, // 9294K
			{0.284899208, 0.293263235}, // 9295K
			{0.284892597, 0.293255619}, // 9296K
			{0.284885988, 0.293248005}, // 9297K
			{0.28487938, 0.293240393}, // 9298K
			{0.284872774, 0.293232783}, // 9299K
			{0.28486617, 0.293225174}, // 9300K
			{0.284859567, 0.293217567}, // 9301K
			{0.284852966, 0.293209962}, // 9302K
			{0.284846367, 0.293202359}, // 9303K
			{0.28483977, 0.293194757}, // 9304K
			{0.284833175, 0.293187157}, // 9305K
			{0.284826581, 0.293179558}, // 9306K
			{0.284819989, 0.293171962}, // 9307K
			{0.284813398, 0.293164367}, // 9308K
			{0.28480681, 0.293156774}, // 9309K
			{0.284800223, 0.293149182}, // 9310K
			{0.284793638, 0.293141592}, // 9311K
			{0.284787054, 0.293134004}, // 9312K
			{0.284780472, 0.293126417}, // 9313K
			{0.284773892, 0.293118833}, // 9314K
			{0.284767314, 0.29311125}, // 9315K
			{0.284760738, 0.293103668}, // 9316K
			{0.284754163, 0.293096089}, // 9317K
			{0.28474759, 0.293088511}, // 9318K
			{0.284741019, 0.293080934}, // 9319K
			{0.284734449, 0.29307336}, // 9320K
			{0.284727881, 0.293065787}, // 9321K
			{0.284721315, 0.293058216}, // 9322K
			{0.28471475, 0.293050646}, // 9323K
			{0.284708188, 0.293043079}, // 9324K
			{0.284701627, 0.293035513}, // 9325K
			{0.284695067, 0.293027948}, // 9326K
			{0.28468851, 0.293020385}, // 9327K
			{0.284681954, 0.293012825}, // 9328K
			{0.2846754, 0.293005265}, // 9329K
			{0.284668848, 0.292997708}, // 9330K
			{0.284662297, 0.292990152}, // 9331K
			{0.284655748, 0.292982598}, // 9332K
			{0.284649201, 0.292975045}, // 9333K
			{0.284642655, 0.292967494}, // 9334K
			{0.284636111, 0.292959945}, // 9335K
			{0.284629569, 0.292952398}, // 9336K
			{0.284623029, 0.292944852}, // 9337K
			{0.28461649, 0.292937308}, // 9338K
			{0.284609953, 0.292929765}, // 9339K
			{0.284603418, 0.292922225}, // 9340K
			{0.284596884, 0.292914686}, // 9341K
			{0.284590353, 0.292907148}, // 9342K
			{0.284583823, 0.292899613}, // 9343K
			{0.284577294, 0.292892079}, // 9344K
			{0.284570767, 0.292884547}, // 9345K
			{0.284564242, 0.292877016}, // 9346K
			{0.284557719, 0.292869487}, // 9347K
			{0.284551198, 0.29286196}, // 9348K
			{0.284544678, 0.292854435}, // 9349K
			{0.28453816, 0.292846911}, // 9350K
			{0.284531643, 0.292839389}, // 9351K
			{0.284525128, 0.292831868}, // 9352K
			{0.284518615, 0.292824349}, // 9353K
			{0.284512104, 0.292816832}, // 9354K
			{0.284505594, 0.292809317}, // 9355K
			{0.284499087, 0.292801803}, // 9356K
			{0.28449258, 0.292794291}, // 9357K
			{0.284486076, 0.292786781}, // 9358K
			{0.284479573, 0.292779272}, // 9359K
			{0.284473072, 0.292771765}, // 9360K
			{0.284466572, 0.29276426}, // 9361K
			{0.284460075, 0.292756756}, // 9362K
			{0.284453579, 0.292749254}, // 9363K
			{0.284447084, 0.292741754}, // 9364K
			{0.284440592, 0.292734255}, // 9365K
			{0.284434101, 0.292726758}, // 9366K
			{0.284427612, 0.292719263}, // 9367K
			{0.284421124, 0.292711769}, // 9368K
			{0.284414638, 0.292704278}, // 9369K
			{0.284408154, 0.292696787}, // 9370K
			{0.284401672, 0.292689299}, // 9371K
			{0.284395191, 0.292681812}, // 9372K
			{0.284388712, 0.292674327}, // 9373K
			{0.284382234, 0.292666843}, // 9374K
			{0.284375759, 0.292659361}, // 9375K
			{0.284369285, 0.292651881}, // 9376K
			{0.284362812, 0.292644402}, // 9377K
			{0.284356342, 0.292636926}, // 9378K
			{0.284349873, 0.29262945}, // 9379K
			{0.284343406, 0.292621977}, // 9380K
			{0.28433694, 0.292614505}, // 9381K
			{0.284330476, 0.292607035}, // 9382K
			{0.284324014, 0.292599566}, // 9383K
			{0.284317554, 0.292592099}, // 9384K
			{0.284311095, 0.292584634}, // 9385K
			{0.284304638, 0.292577171}, // 9386K
			{0.284298182, 0.292569709}, // 9387K
			{0.284291728, 0.292562249}, // 9388K
			{0.284285276, 0.29255479}, // 9389K
			{0.284278826, 0.292547333}, // 9390K
			{0.284272377, 0.292539878}, // 9391K
			{0.28426593, 0.292532424}, // 9392K
			{0.284259485, 0.292524973}, // 9393K
			{0.284253041, 0.292517522}, // 9394K
			{0.284246599, 0.292510074}, // 9395K
			{0.284240159, 0.292502627}, // 9396K
			{0.28423372, 0.292495182}, // 9397K
			{0.284227283, 0.292487738}, // 9398K
			{0.284220848, 0.292480296}, // 9399K
			{0.284214414, 0.292472856}, // 9400K
			{0.284207982, 0.292465417}, // 9401K
			{0.284201552, 0.29245798}, // 9402K
			{0.284195124, 0.292450545}, // 9403K
			{0.284188697, 0.292443112}, // 9404K
			{0.284182271, 0.29243568}, // 9405K
			{0.284175848, 0.292428249}, // 9406K
			{0.284169426, 0.292420821}, // 9407K
			{0.284163006, 0.292413394}, // 9408K
			{0.284156587, 0.292405968}, // 9409K
			{0.28415017, 0.292398545}, // 9410K
			{0.284143755, 0.292391123}, // 9411K
			{0.284137342, 0.292383702}, // 9412K
			{0.28413093, 0.292376283}, // 9413K
			{0.284124519, 0.292368866}, // 9414K
			{0.284118111, 0.292361451}, // 9415K
			{0.284111704, 0.292354037}, // 9416K
			{0.284105299, 0.292346625}, // 9417K
			{0.284098895, 0.292339215}, // 9418K
			{0.284092493, 0.292331806}, // 9419K
			{0.284086093, 0.292324399}, // 9420K
			{0.284079695, 0.292316993}, // 9421K
			{0.284073298, 0.292309589}, // 9422K
			{0.284066902, 0.292302187}, // 9423K
			{0.284060509, 0.292294786}, // 9424K
			{0.284054117, 0.292287387}, // 9425K
			{0.284047727, 0.29227999}, // 9426K
			{0.284041338, 0.292272595}, // 9427K
			{0.284034951, 0.292265201}, // 9428K
			{0.284028566, 0.292257808}, // 9429K
			{0.284022182, 0.292250417}, // 9430K
			{0.2840158, 0.292243028}, // 9431K
			{0.28400942, 0.292235641}, // 9432K
			{0.284003041, 0.292228255}, // 9433K
			{0.283996664, 0.292220871}, // 9434K
			{0.283990289, 0.292213489}, // 9435K
			{0.283983915, 0.292206108}, // 9436K
			{0.283977543, 0.292198729}, // 9437K
			{0.283971173, 0.292191351}, // 9438K
			{0.283964804, 0.292183975}, // 9439K
			{0.283958437, 0.292176601}, // 9440K
			{0.283952072, 0.292169228}, // 9441K
			{0.283945708, 0.292161857}, // 9442K
			{0.283939346, 0.292154488}, // 9443K
			{0.283932986, 0.29214712}, // 9444K
			{0.283926627, 0.292139754}, // 9445K
			{0.28392027, 0.292132389}, // 9446K
			{0.283913914, 0.292125027}, // 9447K
			{0.28390756, 0.292117665}, // 9448K
			{0.283901208, 0.292110306}, // 9449K
			{0.283894857, 0.292102948}, // 9450K
			{0.283888508, 0.292095592}, // 9451K
			{0.283882161, 0.292088237}, // 9452K
			{0.283875815, 0.292080884}, // 9453K
			{0.283869471, 0.292073533}, // 9454K
			{0.283863129, 0.292066183}, // 9455K
			{0.283856788, 0.292058835}, // 9456K
			{0.283850449, 0.292051488}, // 9457K
			{0.283844112, 0.292044143}, // 9458K
			{0.283837776, 0.2920368}, // 9459K
			{0.283831442, 0.292029459}, // 9460K
			{0.283825109, 0.292022119}, // 9461K
			{0.283818779, 0.29201478}, // 9462K
			{0.283812449, 0.292007444}, // 9463K
			{0.283806122, 0.292000108}, // 9464K
			{0.283799796, 0.291992775}, // 9465K
			{0.283793471, 0.291985443}, // 9466K
			{0.283787149, 0.291978113}, // 9467K
			{0.283780828, 0.291970784}, // 9468K
			{0.283774508, 0.291963457}, // 9469K
			{0.28376819, 0.291956132}, // 9470K
			{0.283761874, 0.291948808}, // 9471K
			{0.28375556, 0.291941486}, // 9472K
			{0.283749247, 0.291934166}, // 9473K
			{0.283742936, 0.291926847}, // 9474K
			{0.283736626, 0.29191953}, // 9475K
			{0.283730318, 0.291912214}, // 9476K
			{0.283724012, 0.2919049}, // 9477K
			{0.283717707, 0.291897588}, // 9478K
			{0.283711404, 0.291890277}, // 9479K
			{0.283705102, 0.291882968}, // 9480K
			{0.283698802, 0.291875661}, // 9481K
			{0.283692504, 0.291868355}, // 9482K
			{0.283686208, 0.291861051}, // 9483K
			{0.283679913, 0.291853748}, // 9484K
			{0.283673619, 0.291846447}, // 9485K
			{0.283667328, 0.291839148}, // 9486K
			{0.283661037, 0.29183185}, // 9487K
			{0.283654749, 0.291824554}, // 9488K
			{0.283648462, 0.291817259}, // 9489K
			{0.283642177, 0.291809966}, // 9490K
			{0.283635893, 0.291802675}, // 9491K
			{0.283629611, 0.291795385}, // 9492K
			{0.283623331, 0.291788097}, // 9493K
			{0.283617052, 0.291780811}, // 9494K
			{0.283610775, 0.291773526}, // 9495K
			{0.2836045, 0.291766243}, // 9496K
			{0.283598226, 0.291758961}, // 9497K
			{0.283591953, 0.291751681}, // 9498K
			{0.283585683, 0.291744402}, // 9499K
			{0.283579414, 0.291737126}, // 9500K
			{0.283573146, 0.29172985}, // 9501K
			{0.283566881, 0.291722577}, // 9502K
			{0.283560616, 0.291715305}, // 9503K
			{0.283554354, 0.291708035}, // 9504K
			{0.283548093, 0.291700766}, // 9505K
			{0.283541834, 0.291693499}, // 9506K
			{0.283535576, 0.291686233}, // 9507K
			{0.28352932, 0.291678969}, // 9508K
			{0.283523065, 0.291671707}, // 9509K
			{0.283516812, 0.291664446}, // 9510K
			{0.283510561, 0.291657187}, // 9511K
			{0.283504311, 0.29164993}, // 9512K
			{0.283498063, 0.291642674}, // 9513K
			{0.283491817, 0.291635419}, // 9514K
			{0.283485572, 0.291628167}, // 9515K
			{0.283479329, 0.291620916}, // 9516K
			{0.283473087, 0.291613666}, // 9517K
			{0.283466847, 0.291606418}, // 9518K
			{0.283460609, 0.291599172}, // 9519K
			{0.283454372, 0.291591927}, // 9520K
			{0.283448137, 0.291584684}, // 9521K
			{0.283441903, 0.291577443}, // 9522K
			{0.283435671, 0.291570203}, // 9523K
			{0.28342944, 0.291562965}, // 9524K
			{0.283423212, 0.291555728}, // 9525K
			{0.283416984, 0.291548493}, // 9526K
			{0.283410759, 0.291541259}, // 9527K
			{0.283404535, 0.291534027}, // 9528K
			{0.283398312, 0.291526797}, // 9529K
			{0.283392092, 0.291519568}, // 9530K
			{0.283385872, 0.291512341}, // 9531K
			{0.283379655, 0.291505116}, // 9532K
			{0.283373439, 0.291497892}, // 9533K
			{0.283367224, 0.29149067}, // 9534K
			{0.283361012, 0.291483449}, // 9535K
			{0.2833548, 0.29147623}, // 9536K
			{0.283348591, 0.291469012}, // 9537K
			{0.283342383, 0.291461796}, // 9538K
			{0.283336176, 0.291454582}, // 9539K
			{0.283329971, 0.291447369}, // 9540K
			{0.283323768, 0.291440158}, // 9541K
			{0.283317567, 0.291432948}, // 9542K
			{0.283311367, 0.29142574}, // 9543K
			{0.283305168, 0.291418534}, // 9544K
			{0.283298971, 0.291411329}, // 9545K
			{0.283292776, 0.291404126}, // 9546K
			{0.283286582, 0.291396924}, // 9547K
			{0.28328039, 0.291389724}, // 9548K
			{0.2832742, 0.291382526}, // 9549K
			{0.283268011, 0.291375329}, // 9550K
			{0.283261823, 0.291368134}, // 9551K
			{0.283255638, 0.29136094}, // 9552K
			{0.283249453, 0.291353748}, // 9553K
			{0.283243271, 0.291346558}, // 9554K
			{0.28323709, 0.291339369}, // 9555K
			{0.28323091, 0.291332181}, // 9556K
			{0.283224733, 0.291324995}, // 9557K
			{0.283218556, 0.291317811}, // 9558K
			{0.283212382, 0.291310629}, // 9559K
			{0.283206209, 0.291303448}, // 9560K
			{0.283200037, 0.291296268}, // 9561K
			{0.283193867, 0.29128909}, // 9562K
			{0.283187699, 0.291281914}, // 9563K
			{0.283181532, 0.291274739}, // 9564K
			{0.283175367, 0.291267566}, // 9565K
			{0.283169203, 0.291260395}, // 9566K
			{0.283163041, 0.291253225}, // 9567K
			{0.283156881, 0.291246056}, // 9568K
			{0.283150722, 0.29123889}, // 9569K
			{0.283144565, 0.291231724}, // 9570K
			{0.283138409, 0.291224561}, // 9571K
			{0.283132255, 0.291217399}, // 9572K
			{0.283126102, 0.291210238}, // 9573K
			{0.283119951, 0.291203079}, // 9574K
			{0.283113802, 0.291195922}, // 9575K
			{0.283107654, 0.291188766}, // 9576K
			{0.283101508, 0.291181612}, // 9577K
			{0.283095363, 0.291174459}, // 9578K
			{0.28308922, 0.291167308}, // 9579K
			{0.283083078, 0.291160159}, // 9580K
			{0.283076938, 0.291153011}, // 9581K
			{0.2830708, 0.291145865}, // 9582K
			{0.283064663, 0.29113872}, // 9583K
			{0.283058528, 0.291131577}, // 9584K
			{0.283052394, 0.291124435}, // 9585K
			{0.283046262, 0.291117295}, // 9586K
			{0.283040131, 0.291110157}, // 9587K
			{0.283034002, 0.29110302}, // 9588K
			{0.283027875, 0.291095885}, // 9589K
			{0.283021749, 0.291088751}, // 9590K
			{0.283015625, 0.291081619}, // 9591K
			{0.283009502, 0.291074488}, // 9592K
			{0.283003381, 0.291067359}, // 9593K
			{0.282997261, 0.291060231}, // 9594K
			{0.282991143, 0.291053105}, // 9595K
			{0.282985027, 0.291045981}, // 9596K
			{0.282978912, 0.291038858}, // 9597K
			{0.282972798, 0.291031737}, // 9598K
			{0.282966687, 0.291024617}, // 9599K
			{0.282960576, 0.291017499}, // 9600K
			{0.282954468, 0.291010383}, // 9601K
			{0.282948361, 0.291003268}, // 9602K
			{0.282942255, 0.290996154}, // 9603K
			{0.282936151, 0.290989043}, // 9604K
			{0.282930048, 0.290981932}, // 9605K
			{0.282923948, 0.290974824}, // 9606K
			{0.282917848, 0.290967716}, // 9607K
			{0.28291175, 0.290960611}, // 9608K
			{0.282905654, 0.290953507}, // 9609K
			{0.28289956, 0.290946404}, // 9610K
			{0.282893466, 0.290939303}, // 9611K
			{0.282887375, 0.290932204}, // 9612K
			{0.282881285, 0.290925106}, // 9613K
			{0.282875196, 0.29091801}, // 9614K
			{0.282869109, 0.290910915}, // 9615K
			{0.282863024, 0.290903822}, // 9616K
			{0.28285694, 0.290896731}, // 9617K
			{0.282850858, 0.290889641}, // 9618K
			{0.282844777, 0.290882552}, // 9619K
			{0.282838698, 0.290875465}, // 9620K
			{0.282832621, 0.29086838}, // 9621K
			{0.282826545, 0.290861296}, // 9622K
			{0.28282047, 0.290854214}, // 9623K
			{0.282814397, 0.290847133}, // 9624K
			{0.282808326, 0.290840054}, // 9625K
			{0.282802256, 0.290832976}, // 9626K
			{0.282796187, 0.2908259}, // 9627K
			{0.282790121, 0.290818826}, // 9628K
			{0.282784055, 0.290811753}, // 9629K
			{0.282777992, 0.290804681}, // 9630K
			{0.28277193, 0.290797612}, // 9631K
			{0.282765869, 0.290790543}, // 9632K
			{0.28275981, 0.290783477}, // 9633K
			{0.282753752, 0.290776411}, // 9634K
			{0.282747696, 0.290769348}, // 9635K
			{0.282741642, 0.290762286}, // 9636K
			{0.282735589, 0.290755225}, // 9637K
			{0.282729538, 0.290748166}, // 9638K
			{0.282723488, 0.290741109}, // 9639K
			{0.282717439, 0.290734053}, // 9640K
			{0.282711393, 0.290726998}, // 9641K
			{0.282705347, 0.290719945}, // 9642K
			{0.282699304, 0.290712894}, // 9643K
			{0.282693262, 0.290705844}, // 9644K
			{0.282687221, 0.290698796}, // 9645K
			{0.282681182, 0.29069175}, // 9646K
			{0.282675144, 0.290684705}, // 9647K
			{0.282669108, 0.290677661}, // 9648K
			{0.282663074, 0.290670619}, // 9649K
			{0.282657041, 0.290663578}, // 9650K
			{0.28265101, 0.290656539}, // 9651K
			{0.28264498, 0.290649502}, // 9652K
			{0.282638951, 0.290642466}, // 9653K
			{0.282632925, 0.290635432}, // 9654K
			{0.282626899, 0.290628399}, // 9655K
			{0.282620875, 0.290621368}, // 9656K
			{0.282614853, 0.290614338}, // 9657K
			{0.282608833, 0.29060731}, // 9658K
			{0.282602813, 0.290600283}, // 9659K
			{0.282596796, 0.290593258}, // 9660K
			{0.28259078, 0.290586235}, // 9661K
			{0.282584765, 0.290579213}, // 9662K
			{0.282578752, 0.290572192}, // 9663K
			{0.28257274, 0.290565173}, // 9664K
			{0.28256673, 0.290558156}, // 9665K
			{0.282560722, 0.29055114}, // 9666K
			{0.282554715, 0.290544126}, // 9667K
			{0.28254871, 0.290537113}, // 9668K
			{0.282542706, 0.290530102}, // 9669K
			{0.282536703, 0.290523092}, // 9670K
			{0.282530702, 0.290516084}, // 9671K
			{0.282524703, 0.290509077}, // 9672K
			{0.282518705, 0.290502072}, // 9673K
			{0.282512709, 0.290495068}, // 9674K
			{0.282506714, 0.290488066}, // 9675K
			{0.282500721, 0.290481065}, // 9676K
			{0.282494729, 0.290474066}, // 9677K
			{0.282488739, 0.290467069}, // 9678K
			{0.28248275, 0.290460073}, // 9679K
			{0.282476763, 0.290453078}, // 9680K
			{0.282470777, 0.290446085}, // 9681K
			{0.282464793, 0.290439094}, // 9682K
			{0.28245881, 0.290432104}, // 9683K
			{0.282452829, 0.290425116}, // 9684K
			{0.282446849, 0.290418129}, // 9685K
			{0.282440871, 0.290411144}, // 9686K
			{0.282434895, 0.29040416}, // 9687K
			{0.28242892, 0.290397178}, // 9688K
			{0.282422946, 0.290390197}, // 9689K
			{0.282416974, 0.290383218}, // 9690K
			{0.282411003, 0.29037624}, // 9691K
			{0.282405034, 0.290369264}, // 9692K
			{0.282399067, 0.290362289}, // 9693K
			{0.282393101, 0.290355316}, // 9694K
			{0.282387136, 0.290348345}, // 9695K
			{0.282381173, 0.290341375}, // 9696K
			{0.282375212, 0.290334406}, // 9697K
			{0.282369252, 0.290327439}, // 9698K
			{0.282363293, 0.290320473}, // 9699K
			{0.282357336, 0.290313509}, // 9700K
			{0.282351381, 0.290306547}, // 9701K
			{0.282345427, 0.290299586}, // 9702K
			{0.282339474, 0.290292627}, // 9703K
			{0.282333523, 0.290285669}, // 9704K
			{0.282327574, 0.290278712}, // 9705K
			{0.282321626, 0.290271757}, // 9706K
			{0.282315679, 0.290264804}, // 9707K
			{0.282309734, 0.290257852}, // 9708K
			{0.282303791, 0.290250902}, // 9709K
			{0.282297849, 0.290243953}, // 9710K
			{0.282291909, 0.290237006}, // 9711K
			{0.28228597, 0.29023006}, // 9712K
			{0.282280032, 0.290223116}, // 9713K
			{0.282274096, 0.290216173}, // 9714K
			{0.282268162, 0.290209231}, // 9715K
			{0.282262229, 0.290202292}, // 9716K
			{0.282256297, 0.290195353}, // 9717K
			{0.282250367, 0.290188417}, // 9718K
			{0.282244439, 0.290181482}, // 9719K
			{0.282238512, 0.290174548}, // 9720K
			{0.282232586, 0.290167616}, // 9721K
			{0.282226662, 0.290160685}, // 9722K
			{0.28222074, 0.290153756}, // 9723K
			{0.282214819, 0.290146828}, // 9724K
			{0.282208899, 0.290139902}, // 9725K
			{0.282202981, 0.290132977}, // 9726K
			{0.282197065, 0.290126054}, // 9727K
			{0.28219115, 0.290119132}, // 9728K
			{0.282185236, 0.290112212}, // 9729K
			{0.282179324, 0.290105294}, // 9730K
			{0.282173414, 0.290098376}, // 9731K
			{0.282167504, 0.290091461}, // 9732K
			{0.282161597, 0.290084547}, // 9733K
			{0.282155691, 0.290077634}, // 9734K
			{0.282149786, 0.290070723}, // 9735K
			{0.282143883, 0.290063813}, // 9736K
			{0.282137981, 0.290056905}, // 9737K
			{0.282132081, 0.290049999}, // 9738K
			{0.282126183, 0.290043094}, // 9739K
			{0.282120285, 0.29003619}, // 9740K
			{0.28211439, 0.290029288}, // 9741K
			{0.282108495, 0.290022387}, // 9742K
			{0.282102603, 0.290015488}, // 9743K
			{0.282096712, 0.290008591}, // 9744K
			{0.282090822, 0.290001694}, // 9745K
			{0.282084933, 0.2899948}, // 9746K
			{0.282079047, 0.289987907}, // 9747K
			{0.282073161, 0.289981015}, // 9748K
			{0.282067277, 0.289974125}, // 9749K
			{0.282061395, 0.289967236}, // 9750K
			{0.282055514, 0.289960349}, // 9751K
			{0.282049635, 0.289953464}, // 9752K
			{0.282043757, 0.289946579}, // 9753K
			{0.28203788, 0.289939697}, // 9754K
			{0.282032005, 0.289932816}, // 9755K
			{0.282026132, 0.289925936}, // 9756K
			{0.28202026, 0.289919058}, // 9757K
			{0.282014389, 0.289912181}, // 9758K
			{0.28200852, 0.289905306}, // 9759K
			{0.282002653, 0.289898432}, // 9760K
			{0.281996787, 0.28989156}, // 9761K
			{0.281990922, 0.28988469}, // 9762K
			{0.281985059, 0.28987782}, // 9763K
			{0.281979197, 0.289870953}, // 9764K
			{0.281973337, 0.289864086}, // 9765K
			{0.281967478, 0.289857222}, // 9766K
			{0.281961621, 0.289850358}, // 9767K
			{0.281955765, 0.289843497}, // 9768K
			{0.281949911, 0.289836636}, // 9769K
			{0.281944058, 0.289829778}, // 9770K
			{0.281938206, 0.28982292}, // 9771K
			{0.281932356, 0.289816065}, // 9772K
			{0.281926508, 0.28980921}, // 9773K
			{0.281920661, 0.289802357}, // 9774K
			{0.281914815, 0.289795506}, // 9775K
			{0.281908971, 0.289788656}, // 9776K
			{0.281903129, 0.289781808}, // 9777K
			{0.281897288, 0.289774961}, // 9778K
			{0.281891448, 0.289768116}, // 9779K
			{0.28188561, 0.289761272}, // 9780K
			{0.281879773, 0.289754429}, // 9781K
			{0.281873938, 0.289747588}, // 9782K
			{0.281868104, 0.289740749}, // 9783K
			{0.281862272, 0.289733911}, // 9784K
			{0.281856441, 0.289727074}, // 9785K
			{0.281850611, 0.289720239}, // 9786K
			{0.281844783, 0.289713406}, // 9787K
			{0.281838957, 0.289706574}, // 9788K
			{0.281833132, 0.289699743}, // 9789K
			{0.281827308, 0.289692914}, // 9790K
			{0.281821486, 0.289686086}, // 9791K
			{0.281815665, 0.28967926}, // 9792K
			{0.281809846, 0.289672435}, // 9793K
			{0.281804028, 0.289665612}, // 9794K
			{0.281798212, 0.289658791}, // 9795K
			{0.281792397, 0.28965197}, // 9796K
			{0.281786584, 0.289645152}, // 9797K
			{0.281780772, 0.289638334}, // 9798K
			{0.281774961, 0.289631518}, // 9799K
			{0.281769152, 0.289624704}, // 9800K
			{0.281763345, 0.289617891}, // 9801K
			{0.281757539, 0.28961108}, // 9802K
			{0.281751734, 0.28960427}, // 9803K
			{0.281745931, 0.289597462}, // 9804K
			{0.281740129, 0.289590655}, // 9805K
			{0.281734329, 0.289583849}, // 9806K
			{0.28172853, 0.289577045}, // 9807K
			{0.281722732, 0.289570243}, // 9808K
			{0.281716936, 0.289563441}, // 9809K
			{0.281711142, 0.289556642}, // 9810K
			{0.281705349, 0.289549844}, // 9811K
			{0.281699557, 0.289543047}, // 9812K
			{0.281693767, 0.289536252}, // 9813K
			{0.281687978, 0.289529458}, // 9814K
			{0.281682191, 0.289522666}, // 9815K
			{0.281676405, 0.289515875}, // 9816K
			{0.281670621, 0.289509086}, // 9817K
			{0.281664838, 0.289502298}, // 9818K
			{0.281659056, 0.289495512}, // 9819K
			{0.281653276, 0.289488727}, // 9820K
			{0.281647498, 0.289481943}, // 9821K
			{0.28164172, 0.289475161}, // 9822K
			{0.281635945, 0.289468381}, // 9823K
			{0.28163017, 0.289461602}, // 9824K
			{0.281624398, 0.289454824}, // 9825K
			{0.281618626, 0.289448048}, // 9826K
			{0.281612856, 0.289441273}, // 9827K
			{0.281607088, 0.2894345}, // 9828K
			{0.281601321, 0.289427728}, // 9829K
			{0.281595555, 0.289420958}, // 9830K
			{0.281589791, 0.289414189}, // 9831K
			{0.281584028, 0.289407422}, // 9832K
			{0.281578267, 0.289400656}, // 9833K
			{0.281572507, 0.289393891}, // 9834K
			{0.281566748, 0.289387128}, // 9835K
			{0.281560991, 0.289380367}, // 9836K
			{0.281555236, 0.289373607}, // 9837K
			{0.281549482, 0.289366848}, // 9838K
			{0.281543729, 0.289360091}, // 9839K
			{0.281537978, 0.289353335}, // 9840K
			{0.281532228, 0.289346581}, // 9841K
			{0.281526479, 0.289339828}, // 9842K
			{0.281520732, 0.289333077}, // 9843K
			{0.281514987, 0.289326327}, // 9844K
			{0.281509243, 0.289319579}, // 9845K
			{0.2815035, 0.289312832}, // 9846K
			{0.281497759, 0.289306087}, // 9847K
			{0.281492019, 0.289299342}, // 9848K
			{0.281486281, 0.2892926}, // 9849K
			{0.281480544, 0.289285859}, // 9850K
			{0.281474808, 0.289279119}, // 9851K
			{0.281469074, 0.289272381}, // 9852K
			{0.281463341, 0.289265644}, // 9853K
			{0.28145761, 0.289258909}, // 9854K
			{0.28145188, 0.289252175}, // 9855K
			{0.281446152, 0.289245443}, // 9856K
			{0.281440425, 0.289238712}, // 9857K
			{0.281434699, 0.289231982}, // 9858K
			{0.281428975, 0.289225254}, // 9859K
			{0.281423253, 0.289218527}, // 9860K
			{0.281417531, 0.289211802}, // 9861K
			{0.281411811, 0.289205079}, // 9862K
			{0.281406093, 0.289198356}, // 9863K
			{0.281400376, 0.289191635}, // 9864K
			{0.28139466, 0.289184916}, // 9865K
			{0.281388946, 0.289178198}, // 9866K
			{0.281383233, 0.289171482}, // 9867K
			{0.281377522, 0.289164767}, // 9868K
			{0.281371812, 0.289158053}, // 9869K
			{0.281366104, 0.289151341}, // 9870K
			{0.281360397, 0.28914463}, // 9871K
			{0.281354691, 0.289137921}, // 9872K
			{0.281348987, 0.289131213}, // 9873K
			{0.281343284, 0.289124507}, // 9874K
			{0.281337583, 0.289117802}, // 9875K
			{0.281331883, 0.289111099}, // 9876K
			{0.281326184, 0.289104397}, // 9877K
			{0.281320487, 0.289097696}, // 9878K
			{0.281314791, 0.289090997}, // 9879K
			{0.281309097, 0.289084299}, // 9880K
			{0.281303404, 0.289077603}, // 9881K
			{0.281297712, 0.289070908}, // 9882K
			{0.281292022, 0.289064215}, // 9883K
			{0.281286334, 0.289057523}, // 9884K
			{0.281280646, 0.289050832}, // 9885K
			{0.281274961, 0.289044143}, // 9886K
			{0.281269276, 0.289037455}, // 9887K
			{0.281263593, 0.289030769}, // 9888K
			{0.281257912, 0.289024085}, // 9889K
			{0.281252231, 0.289017401}, // 9890K
			{0.281246553, 0.289010719}, // 9891K
			{0.281240875, 0.289004039}, // 9892K
			{0.281235199, 0.28899736}, // 9893K
			{0.281229525, 0.288990682}, // 9894K
			{0.281223851, 0.288984006}, // 9895K
			{0.28121818, 0.288977332}, // 9896K
			{0.281212509, 0.288970658}, // 9897K
			{0.28120684, 0.288963986}, // 9898K
			{0.281201173, 0.288957316}, // 9899K
			{0.281195507, 0.288950647}, // 9900K
			{0.281189842, 0.28894398}, // 9901K
			{0.281184179, 0.288937313}, // 9902K
			{0.281178517, 0.288930649}, // 9903K
			{0.281172856, 0.288923986}, // 9904K
			{0.281167197, 0.288917324}, // 9905K
			{0.281161539, 0.288910663}, // 9906K
			{0.281155883, 0.288904004}, // 9907K
			{0.281150228, 0.288897347}, // 9908K
			{0.281144575, 0.288890691}, // 9909K
			{0.281138922, 0.288884036}, // 9910K
			{0.281133272, 0.288877383}, // 9911K
			{0.281127622, 0.288870731}, // 9912K
			{0.281121974, 0.288864081}, // 9913K
			{0.281116328, 0.288857432}, // 9914K
			{0.281110683, 0.288850784}, // 9915K
			{0.281105039, 0.288844138}, // 9916K
			{0.281099397, 0.288837494}, // 9917K
			{0.281093756, 0.28883085}, // 9918K
			{0.281088116, 0.288824208}, // 9919K
			{0.281082478, 0.288817568}, // 9920K
			{0.281076841, 0.288810929}, // 9921K
			{0.281071206, 0.288804292}, // 9922K
			{0.281065572, 0.288797655}, // 9923K
			{0.28105994, 0.288791021}, // 9924K
			{0.281054308, 0.288784387}, // 9925K
			{0.281048679, 0.288777756}, // 9926K
			{0.28104305, 0.288771125}, // 9927K
			{0.281037423, 0.288764496}, // 9928K
			{0.281031798, 0.288757869}, // 9929K
			{0.281026173, 0.288751242}, // 9930K
			{0.28102055, 0.288744618}, // 9931K
			{0.281014929, 0.288737994}, // 9932K
			{0.281009309, 0.288731372}, // 9933K
			{0.28100369, 0.288724752}, // 9934K
			{0.280998073, 0.288718133}, // 9935K
			{0.280992457, 0.288711515}, // 9936K
			{0.280986843, 0.288704899}, // 9937K
			{0.28098123, 0.288698284}, // 9938K
			{0.280975618, 0.288691671}, // 9939K
			{0.280970007, 0.288685059}, // 9940K
			{0.280964398, 0.288678448}, // 9941K
			{0.280958791, 0.288671839}, // 9942K
			{0.280953185, 0.288665231}, // 9943K
			{0.28094758, 0.288658625}, // 9944K
			{0.280941976, 0.28865202}, // 9945K
			{0.280936374, 0.288645417}, // 9946K
			{0.280930774, 0.288638815}, // 9947K
			{0.280925174, 0.288632214}, // 9948K
			{0.280919577, 0.288625615}, // 9949K
			{0.28091398, 0.288619017}, // 9950K
			{0.280908385, 0.28861242}, // 9951K
			{0.280902791, 0.288605825}, // 9952K
			{0.280897199, 0.288599232}, // 9953K
			{0.280891608, 0.288592639}, // 9954K
			{0.280886018, 0.288586049}, // 9955K
			{0.28088043, 0.288579459}, // 9956K
			{0.280874843, 0.288572871}, // 9957K
			{0.280869258, 0.288566285}, // 9958K
			{0.280863673, 0.2885597}, // 9959K
			{0.280858091, 0.288553116}, // 9960K
			{0.280852509, 0.288546534}, // 9961K
			{0.280846929, 0.288539953}, // 9962K
			{0.280841351, 0.288533373}, // 9963K
			{0.280835773, 0.288526795}, // 9964K
			{0.280830198, 0.288520218}, // 9965K
			{0.280824623, 0.288513643}, // 9966K
			{0.28081905, 0.288507069}, // 9967K
			{0.280813478, 0.288500497}, // 9968K
			{0.280807908, 0.288493926}, // 9969K
			{0.280802339, 0.288487356}, // 9970K
			{0.280796771, 0.288480788}, // 9971K
			{0.280791205, 0.288474221}, // 9972K
			{0.28078564, 0.288467655}, // 9973K
			{0.280780076, 0.288461091}, // 9974K
			{0.280774514, 0.288454529}, // 9975K
			{0.280768954, 0.288447967}, // 9976K
			{0.280763394, 0.288441407}, // 9977K
			{0.280757836, 0.288434849}, // 9978K
			{0.280752279, 0.288428292}, // 9979K
			{0.280746724, 0.288421736}, // 9980K
			{0.28074117, 0.288415182}, // 9981K
			{0.280735617, 0.288408629}, // 9982K
			{0.280730066, 0.288402078}, // 9983K
			{0.280724516, 0.288395528}, // 9984K
			{0.280718968, 0.288388979}, // 9985K
			{0.280713421, 0.288382432}, // 9986K
			{0.280707875, 0.288375886}, // 9987K
			{0.280702331, 0.288369341}, // 9988K
			{0.280696788, 0.288362798}, // 9989K
			{0.280691246, 0.288356257}, // 9990K
			{0.280685706, 0.288349716}, // 9991K
			{0.280680167, 0.288343177}, // 9992K
			{0.280674629, 0.28833664}, // 9993K
			{0.280669093, 0.288330104}, // 9994K
			{0.280663558, 0.288323569}, // 9995K
			{0.280658024, 0.288317036}, // 9996K
			{0.280652492, 0.288310504}, // 9997K
			{0.280646961, 0.288303973}, // 9998K
			{0.280641432, 0.288297444}, // 9999K
			{0.280635904, 0.288290916}, // 10000K
			{0.280630377, 0.28828439}, // 10001K
			{0.280624852, 0.288277865}, // 10002K
			{0.280619328, 0.288271342}, // 10003K
			{0.280613805, 0.288264819}, // 10004K
			{0.280608284, 0.288258299}, // 10005K
			{0.280602764, 0.288251779}, // 10006K
			{0.280597245, 0.288245261}, // 10007K
			{0.280591728, 0.288238745}, // 10008K
			{0.280586212, 0.288232229}, // 10009K
			{0.280580697, 0.288225716}, // 10010K
			{0.280575184, 0.288219203}, // 10011K
			{0.280569672, 0.288212692}, // 10012K
			{0.280564162, 0.288206182}, // 10013K
			{0.280558653, 0.288199674}, // 10014K
			{0.280553145, 0.288193167}, // 10015K
			{0.280547638, 0.288186662}, // 10016K
			{0.280542133, 0.288180158}, // 10017K
			{0.28053663, 0.288173655}, // 10018K
			{0.280531127, 0.288167153}, // 10019K
			{0.280525626, 0.288160653}, // 10020K
			{0.280520127, 0.288154155}, // 10021K
			{0.280514628, 0.288147658}, // 10022K
			{0.280509131, 0.288141162}, // 10023K
			{0.280503635, 0.288134667}, // 10024K
			{0.280498141, 0.288128174}, // 10025K
			{0.280492648, 0.288121683}, // 10026K
			{0.280487157, 0.288115192}, // 10027K
			{0.280481666, 0.288108703}, // 10028K
			{0.280476177, 0.288102216}, // 10029K
			{0.28047069, 0.28809573}, // 10030K
			{0.280465204, 0.288089245}, // 10031K
			{0.280459719, 0.288082762}, // 10032K
			{0.280454235, 0.288076279}, // 10033K
			{0.280448753, 0.288069799}, // 10034K
			{0.280443272, 0.28806332}, // 10035K
			{0.280437792, 0.288056842}, // 10036K
			{0.280432314, 0.288050365}, // 10037K
			{0.280426837, 0.28804389}, // 10038K
			{0.280421362, 0.288037416}, // 10039K
			{0.280415888, 0.288030944}, // 10040K
			{0.280410415, 0.288024473}, // 10041K
			{0.280404943, 0.288018003}, // 10042K
			{0.280399473, 0.288011535}, // 10043K
			{0.280394004, 0.288005068}, // 10044K
			{0.280388537, 0.287998603}, // 10045K
			{0.280383071, 0.287992139}, // 10046K
			{0.280377606, 0.287985676}, // 10047K
			{0.280372142, 0.287979214}, // 10048K
			{0.28036668, 0.287972754}, // 10049K
			{0.280361219, 0.287966296}, // 10050K
			{0.28035576, 0.287959838}, // 10051K
			{0.280350302, 0.287953383}, // 10052K
			{0.280344845, 0.287946928}, // 10053K
			{0.280339389, 0.287940475}, // 10054K
			{0.280333935, 0.287934023}, // 10055K
			{0.280328482, 0.287927573}, // 10056K
			{0.280323031, 0.287921124}, // 10057K
			{0.280317581, 0.287914676}, // 10058K
			{0.280312132, 0.28790823}, // 10059K
			{0.280306684, 0.287901785}, // 10060K
			{0.280301238, 0.287895341}, // 10061K
			{0.280295793, 0.287888899}, // 10062K
			{0.28029035, 0.287882458}, // 10063K
			{0.280284908, 0.287876019}, // 10064K
			{0.280279467, 0.287869581}, // 10065K
			{0.280274027, 0.287863144}, // 10066K
			{0.280268589, 0.287856709}, // 10067K
			{0.280263152, 0.287850275}, // 10068K
			{0.280257716, 0.287843842}, // 10069K
			{0.280252282, 0.287837411}, // 10070K
			{0.280246849, 0.287830981}, // 10071K
			{0.280241418, 0.287824552}, // 10072K
			{0.280235987, 0.287818125}, // 10073K
			{0.280230558, 0.287811699}, // 10074K
			{0.280225131, 0.287805275}, // 10075K
			{0.280219705, 0.287798852}, // 10076K
			{0.28021428, 0.28779243}, // 10077K
			{0.280208856, 0.287786009}, // 10078K
			{0.280203434, 0.28777959}, // 10079K
			{0.280198013, 0.287773173}, // 10080K
			{0.280192593, 0.287766757}, // 10081K
			{0.280187175, 0.287760342}, // 10082K
			{0.280181757, 0.287753928}, // 10083K
			{0.280176342, 0.287747516}, // 10084K
			{0.280170927, 0.287741105}, // 10085K
			{0.280165514, 0.287734695}, // 10086K
			{0.280160102, 0.287728287}, // 10087K
			{0.280154692, 0.287721881}, // 10088K
			{0.280149283, 0.287715475}, // 10089K
			{0.280143875, 0.287709071}, // 10090K
			{0.280138469, 0.287702668}, // 10091K
			{0.280133063, 0.287696267}, // 10092K
			{0.280127659, 0.287689867}, // 10093K
			{0.280122257, 0.287683468}, // 10094K
			{0.280116856, 0.287677071}, // 10095K
			{0.280111456, 0.287670675}, // 10096K
			{0.280106057, 0.287664281}, // 10097K
			{0.28010066, 0.287657887}, // 10098K
			{0.280095264, 0.287651495}, // 10099K
			{0.280089869, 0.287645105}, // 10100K
			{0.280084476, 0.287638716}, // 10101K
			{0.280079084, 0.287632328}, // 10102K
			{0.280073693, 0.287625942}, // 10103K
			{0.280068303, 0.287619556}, // 10104K
			{0.280062915, 0.287613173}, // 10105K
			{0.280057528, 0.28760679}, // 10106K
			{0.280052143, 0.287600409}, // 10107K
			{0.280046759, 0.287594029}, // 10108K
			{0.280041376, 0.287587651}, // 10109K
			{0.280035994, 0.287581274}, // 10110K
			{0.280030614, 0.287574898}, // 10111K
			{0.280025235, 0.287568524}, // 10112K
			{0.280019857, 0.287562151}, // 10113K
			{0.280014481, 0.28755578}, // 10114K
			{0.280009106, 0.287549409}, // 10115K
			{0.280003732, 0.28754304}, // 10116K
			{0.279998359, 0.287536673}, // 10117K
			{0.279992988, 0.287530306}, // 10118K
			{0.279987618, 0.287523942}, // 10119K
			{0.27998225, 0.287517578}, // 10120K
			{0.279976883, 0.287511216}, // 10121K
			{0.279971517, 0.287504855}, // 10122K
			{0.279966152, 0.287498495}, // 10123K
			{0.279960789, 0.287492137}, // 10124K
			{0.279955427, 0.287485781}, // 10125K
			{0.279950066, 0.287479425}, // 10126K
			{0.279944706, 0.287473071}, // 10127K
			{0.279939348, 0.287466718}, // 10128K
			{0.279933991, 0.287460367}, // 10129K
			{0.279928636, 0.287454017}, // 10130K
			{0.279923282, 0.287447668}, // 10131K
			{0.279917929, 0.28744132}, // 10132K
			{0.279912577, 0.287434974}, // 10133K
			{0.279907227, 0.287428629}, // 10134K
			{0.279901878, 0.287422286}, // 10135K
			{0.27989653, 0.287415944}, // 10136K
			{0.279891183, 0.287409603}, // 10137K
			{0.279885838, 0.287403264}, // 10138K
			{0.279880494, 0.287396926}, // 10139K
			{0.279875152, 0.287390589}, // 10140K
			{0.27986981, 0.287384254}, // 10141K
			{0.27986447, 0.28737792}, // 10142K
			{0.279859132, 0.287371587}, // 10143K
			{0.279853794, 0.287365256}, // 10144K
			{0.279848458, 0.287358925}, // 10145K
			{0.279843123, 0.287352597}, // 10146K
			{0.27983779, 0.287346269}, // 10147K
			{0.279832457, 0.287339943}, // 10148K
			{0.279827127, 0.287333619}, // 10149K
			{0.279821797, 0.287327295}, // 10150K
			{0.279816468, 0.287320973}, // 10151K
			{0.279811141, 0.287314653}, // 10152K
			{0.279805816, 0.287308333}, // 10153K
			{0.279800491, 0.287302015}, // 10154K
			{0.279795168, 0.287295698}, // 10155K
			{0.279789846, 0.287289383}, // 10156K
			{0.279784525, 0.287283069}, // 10157K
			{0.279779206, 0.287276756}, // 10158K
			{0.279773888, 0.287270445}, // 10159K
			{0.279768571, 0.287264135}, // 10160K
			{0.279763255, 0.287257826}, // 10161K
			{0.279757941, 0.287251519}, // 10162K
			{0.279752628, 0.287245213}, // 10163K
			{0.279747317, 0.287238908}, // 10164K
			{0.279742006, 0.287232605}, // 10165K
			{0.279736697, 0.287226302}, // 10166K
			{0.279731389, 0.287220002}, // 10167K
			{0.279726083, 0.287213702}, // 10168K
			{0.279720777, 0.287207404}, // 10169K
			{0.279715473, 0.287201107}, // 10170K
			{0.279710171, 0.287194812}, // 10171K
			{0.279704869, 0.287188518}, // 10172K
			{0.279699569, 0.287182225}, // 10173K
			{0.27969427, 0.287175934}, // 10174K
			{0.279688973, 0.287169643}, // 10175K
			{0.279683676, 0.287163355}, // 10176K
			{0.279678381, 0.287157067}, // 10177K
			{0.279673088, 0.287150781}, // 10178K
			{0.279667795, 0.287144496}, // 10179K
			{0.279662504, 0.287138212}, // 10180K
			{0.279657214, 0.28713193}, // 10181K
			{0.279651926, 0.287125649}, // 10182K
			{0.279646638, 0.28711937}, // 10183K
			{0.279641352, 0.287113092}, // 10184K
			{0.279636067, 0.287106815}, // 10185K
			{0.279630784, 0.287100539}, // 10186K
			{0.279625501, 0.287094265}, // 10187K
			{0.27962022, 0.287087992}, // 10188K
			{0.279614941, 0.28708172}, // 10189K
			{0.279609662, 0.28707545}, // 10190K
			{0.279604385, 0.287069181}, // 10191K
			{0.279599109, 0.287062913}, // 10192K
			{0.279593835, 0.287056647}, // 10193K
			{0.279588561, 0.287050382}, // 10194K
			{0.279583289, 0.287044118}, // 10195K
			{0.279578018, 0.287037855}, // 10196K
			{0.279572749, 0.287031594}, // 10197K
			{0.27956748, 0.287025334}, // 10198K
			{0.279562213, 0.287019076}, // 10199K
			{0.279556948, 0.287012819}, // 10200K
			{0.279551683, 0.287006563}, // 10201K
			{0.27954642, 0.287000308}, // 10202K
			{0.279541158, 0.286994055}, // 10203K
			{0.279535897, 0.286987803}, // 10204K
			{0.279530638, 0.286981553}, // 10205K
			{0.27952538, 0.286975303}, // 10206K
			{0.279520123, 0.286969055}, // 10207K
			{0.279514867, 0.286962809}, // 10208K
			{0.279509613, 0.286956563}, // 10209K
			{0.27950436, 0.286950319}, // 10210K
			{0.279499108, 0.286944077}, // 10211K
			{0.279493858, 0.286937835}, // 10212K
			{0.279488608, 0.286931595}, // 10213K
			{0.27948336, 0.286925356}, // 10214K
			{0.279478113, 0.286919119}, // 10215K
			{0.279472868, 0.286912883}, // 10216K
			{0.279467624, 0.286906648}, // 10217K
			{0.279462381, 0.286900414}, // 10218K
			{0.279457139, 0.286894182}, // 10219K
			{0.279451898, 0.286887951}, // 10220K
			{0.279446659, 0.286881721}, // 10221K
			{0.279441421, 0.286875493}, // 10222K
			{0.279436185, 0.286869266}, // 10223K
			{0.279430949, 0.28686304}, // 10224K
			{0.279425715, 0.286856816}, // 10225K
			{0.279420482, 0.286850593}, // 10226K
			{0.27941525, 0.286844371}, // 10227K
			{0.27941002, 0.28683815}, // 10228K
			{0.279404791, 0.286831931}, // 10229K
			{0.279399563, 0.286825713}, // 10230K
			{0.279394336, 0.286819497}, // 10231K
			{0.279389111, 0.286813281}, // 10232K
			{0.279383887, 0.286807067}, // 10233K
			{0.279378664, 0.286800855}, // 10234K
			{0.279373442, 0.286794643}, // 10235K
			{0.279368222, 0.286788433}, // 10236K
			{0.279363003, 0.286782224}, // 10237K
			{0.279357785, 0.286776017}, // 10238K
			{0.279352568, 0.286769811}, // 10239K
			{0.279347353, 0.286763606}, // 10240K
			{0.279342139, 0.286757402}, // 10241K
			{0.279336926, 0.2867512}, // 10242K
			{0.279331714, 0.286744999}, // 10243K
			{0.279326504, 0.286738799}, // 10244K
			{0.279321295, 0.286732601}, // 10245K
			{0.279316087, 0.286726404}, // 10246K
			{0.27931088, 0.286720208}, // 10247K
			{0.279305675, 0.286714013}, // 10248K
			{0.279300471, 0.28670782}, // 10249K
			{0.279295268, 0.286701628}, // 10250K
			{0.279290066, 0.286695438}, // 10251K
			{0.279284866, 0.286689248}, // 10252K
			{0.279279667, 0.28668306}, // 10253K
			{0.279274469, 0.286676874}, // 10254K
			{0.279269272, 0.286670688}, // 10255K
			{0.279264077, 0.286664504}, // 10256K
			{0.279258882, 0.286658321}, // 10257K
			{0.27925369, 0.28665214}, // 10258K
			{0.279248498, 0.286645959}, // 10259K
			{0.279243307, 0.28663978}, // 10260K
			{0.279238118, 0.286633603}, // 10261K
			{0.27923293, 0.286627426}, // 10262K
			{0.279227744, 0.286621251}, // 10263K
			{0.279222558, 0.286615077}, // 10264K
			{0.279217374, 0.286608905}, // 10265K
			{0.279212191, 0.286602734}, // 10266K
			{0.279207009, 0.286596564}, // 10267K
			{0.279201829, 0.286590395}, // 10268K
			{0.279196649, 0.286584228}, // 10269K
			{0.279191471, 0.286578062}, // 10270K
			{0.279186295, 0.286571897}, // 10271K
			{0.279181119, 0.286565734}, // 10272K
			{0.279175945, 0.286559571}, // 10273K
			{0.279170772, 0.28655341}, // 10274K
			{0.2791656, 0.286547251}, // 10275K
			{0.279160429, 0.286541092}, // 10276K
			{0.27915526, 0.286534935}, // 10277K
			{0.279150092, 0.28652878}, // 10278K
			{0.279144925, 0.286522625}, // 10279K
			{0.279139759, 0.286516472}, // 10280K
			{0.279134595, 0.28651032}, // 10281K
			{0.279129431, 0.286504169}, // 10282K
			{0.279124269, 0.28649802}, // 10283K
			{0.279119109, 0.286491872}, // 10284K
			{0.279113949, 0.286485725}, // 10285K
			{0.279108791, 0.28647958}, // 10286K
			{0.279103634, 0.286473436}, // 10287K
			{0.279098478, 0.286467293}, // 10288K
			{0.279093324, 0.286461151}, // 10289K
			{0.27908817, 0.286455011}, // 10290K
			{0.279083018, 0.286448872}, // 10291K
			{0.279077867, 0.286442734}, // 10292K
			{0.279072718, 0.286436597}, // 10293K
			{0.279067569, 0.286430462}, // 10294K
			{0.279062422, 0.286424328}, // 10295K
			{0.279057276, 0.286418195}, // 10296K
			{0.279052131, 0.286412064}, // 10297K
			{0.279046988, 0.286405934}, // 10298K
			{0.279041845, 0.286399805}, // 10299K
			{0.279036704, 0.286393677}, // 10300K
			{0.279031564, 0.286387551}, // 10301K
			{0.279026426, 0.286381426}, // 10302K
			{0.279021288, 0.286375302}, // 10303K
			{0.279016152, 0.28636918}, // 10304K
			{0.279011017, 0.286363059}, // 10305K
			{0.279005884, 0.286356939}, // 10306K
			{0.279000751, 0.28635082}, // 10307K
			{0.27899562, 0.286344703}, // 10308K
			{0.27899049, 0.286338587}, // 10309K
			{0.278985361, 0.286332472}, // 10310K
			{0.278980233, 0.286326359}, // 10311K
			{0.278975107, 0.286320246}, // 10312K
			{0.278969982, 0.286314135}, // 10313K
			{0.278964858, 0.286308026}, // 10314K
			{0.278959735, 0.286301917}, // 10315K
			{0.278954614, 0.28629581}, // 10316K
			{0.278949493, 0.286289704}, // 10317K
			{0.278944374, 0.286283599}, // 10318K
			{0.278939257, 0.286277496}, // 10319K
			{0.27893414, 0.286271394}, // 10320K
			{0.278929025, 0.286265293}, // 10321K
			{0.27892391, 0.286259194}, // 10322K
			{0.278918797, 0.286253095}, // 10323K
			{0.278913686, 0.286246998}, // 10324K
			{0.278908575, 0.286240903}, // 10325K
			{0.278903466, 0.286234808}, // 10326K
			{0.278898358, 0.286228715}, // 10327K
			{0.278893251, 0.286222623}, // 10328K
			{0.278888145, 0.286216532}, // 10329K
			{0.278883041, 0.286210443}, // 10330K
			{0.278877937, 0.286204355}, // 10331K
			{0.278872835, 0.286198268}, // 10332K
			{0.278867734, 0.286192182}, // 10333K
			{0.278862635, 0.286186098}, // 10334K
			{0.278857536, 0.286180015}, // 10335K
			{0.278852439, 0.286173933}, // 10336K
			{0.278847343, 0.286167853}, // 10337K
			{0.278842249, 0.286161773}, // 10338K
			{0.278837155, 0.286155695}, // 10339K
			{0.278832063, 0.286149619}, // 10340K
			{0.278826972, 0.286143543}, // 10341K
			{0.278821882, 0.286137469}, // 10342K
			{0.278816793, 0.286131396}, // 10343K
			{0.278811705, 0.286125324}, // 10344K
			{0.278806619, 0.286119254}, // 10345K
			{0.278801534, 0.286113185}, // 10346K
			{0.27879645, 0.286107117}, // 10347K
			{0.278791367, 0.28610105}, // 10348K
			{0.278786286, 0.286094985}, // 10349K
			{0.278781206, 0.286088921}, // 10350K
			{0.278776127, 0.286082858}, // 10351K
			{0.278771049, 0.286076796}, // 10352K
			{0.278765972, 0.286070736}, // 10353K
			{0.278760897, 0.286064677}, // 10354K
			{0.278755822, 0.286058619}, // 10355K
			{0.278750749, 0.286052562}, // 10356K
			{0.278745678, 0.286046507}, // 10357K
			{0.278740607, 0.286040453}, // 10358K
			{0.278735537, 0.2860344}, // 10359K
			{0.278730469, 0.286028349}, // 10360K
			{0.278725402, 0.286022298}, // 10361K
			{0.278720336, 0.286016249}, // 10362K
			{0.278715272, 0.286010202}, // 10363K
			{0.278710208, 0.286004155}, // 10364K
			{0.278705146, 0.28599811}, // 10365K
			{0.278700085, 0.285992066}, // 10366K
			{0.278695025, 0.285986023}, // 10367K
			{0.278689967, 0.285979982}, // 10368K
			{0.278684909, 0.285973941}, // 10369K
			{0.278679853, 0.285967902}, // 10370K
			{0.278674798, 0.285961865}, // 10371K
			{0.278669744, 0.285955828}, // 10372K
			{0.278664691, 0.285949793}, // 10373K
			{0.27865964, 0.285943759}, // 10374K
			{0.27865459, 0.285937726}, // 10375K
			{0.278649541, 0.285931695}, // 10376K
			{0.278644493, 0.285925664}, // 10377K
			{0.278639446, 0.285919635}, // 10378K
			{0.278634401, 0.285913608}, // 10379K
			{0.278629356, 0.285907581}, // 10380K
			{0.278624313, 0.285901556}, // 10381K
			{0.278619272, 0.285895532}, // 10382K
			{0.278614231, 0.285889509}, // 10383K
			{0.278609191, 0.285883488}, // 10384K
			{0.278604153, 0.285877467}, // 10385K
			{0.278599116, 0.285871448}, // 10386K
			{0.27859408, 0.285865431}, // 10387K
			{0.278589045, 0.285859414}, // 10388K
			{0.278584012, 0.285853399}, // 10389K
			{0.278578979, 0.285847385}, // 10390K
			{0.278573948, 0.285841372}, // 10391K
			{0.278568918, 0.285835361}, // 10392K
			{0.278563889, 0.28582935}, // 10393K
			{0.278558862, 0.285823341}, // 10394K
			{0.278553835, 0.285817334}, // 10395K
			{0.27854881, 0.285811327}, // 10396K
			{0.278543786, 0.285805322}, // 10397K
			{0.278538763, 0.285799318}, // 10398K
			{0.278533742, 0.285793315}, // 10399K
			{0.278528721, 0.285787313}, // 10400K
			{0.278523702, 0.285781313}, // 10401K
			{0.278518684, 0.285775314}, // 10402K
			{0.278513667, 0.285769316}, // 10403K
			{0.278508651, 0.285763319}, // 10404K
			{0.278503637, 0.285757324}, // 10405K
			{0.278498623, 0.28575133}, // 10406K
			{0.278493611, 0.285745337}, // 10407K
			{0.2784886, 0.285739345}, // 10408K
			{0.27848359, 0.285733355}, // 10409K
			{0.278478582, 0.285727366}, // 10410K
			{0.278473574, 0.285721378}, // 10411K
			{0.278468568, 0.285715391}, // 10412K
			{0.278463563, 0.285709406}, // 10413K
			{0.278458559, 0.285703421}, // 10414K
			{0.278453556, 0.285697439}, // 10415K
			{0.278448555, 0.285691457}, // 10416K
			{0.278443554, 0.285685476}, // 10417K
			{0.278438555, 0.285679497}, // 10418K
			{0.278433557, 0.285673519}, // 10419K
			{0.27842856, 0.285667542}, // 10420K
			{0.278423565, 0.285661567}, // 10421K
			{0.27841857, 0.285655592}, // 10422K
			{0.278413577, 0.285649619}, // 10423K
			{0.278408585, 0.285643647}, // 10424K
			{0.278403594, 0.285637677}, // 10425K
			{0.278398604, 0.285631707}, // 10426K
			{0.278393616, 0.285625739}, // 10427K
			{0.278388628, 0.285619772}, // 10428K
			{0.278383642, 0.285613807}, // 10429K
			{0.278378657, 0.285607842}, // 10430K
			{0.278373673, 0.285601879}, // 10431K
			{0.27836869, 0.285595917}, // 10432K
			{0.278363709, 0.285589956}, // 10433K
			{0.278358728, 0.285583997}, // 10434K
			{0.278353749, 0.285578038}, // 10435K
			{0.278348771, 0.285572081}, // 10436K
			{0.278343794, 0.285566125}, // 10437K
			{0.278338819, 0.285560171}, // 10438K
			{0.278333844, 0.285554217}, // 10439K
			{0.278328871, 0.285548265}, // 10440K
			{0.278323899, 0.285542314}, // 10441K
			{0.278318928, 0.285536364}, // 10442K
			{0.278313958, 0.285530416}, // 10443K
			{0.278308989, 0.285524469}, // 10444K
			{0.278304022, 0.285518523}, // 10445K
			{0.278299055, 0.285512578}, // 10446K
			{0.27829409, 0.285506634}, // 10447K
			{0.278289126, 0.285500692}, // 10448K
			{0.278284163, 0.285494751}, // 10449K
			{0.278279202, 0.285488811}, // 10450K
			{0.278274241, 0.285482872}, // 10451K
			{0.278269282, 0.285476935}, // 10452K
			{0.278264324, 0.285470999}, // 10453K
			{0.278259367, 0.285465064}, // 10454K
			{0.278254411, 0.28545913}, // 10455K
			{0.278249456, 0.285453197}, // 10456K
			{0.278244503, 0.285447266}, // 10457K
			{0.27823955, 0.285441336}, // 10458K
			{0.278234599, 0.285435407}, // 10459K
			{0.278229649, 0.285429479}, // 10460K
			{0.2782247, 0.285423553}, // 10461K
			{0.278219753, 0.285417628}, // 10462K
			{0.278214806, 0.285411704}, // 10463K
			{0.278209861, 0.285405781}, // 10464K
			{0.278204917, 0.285399859}, // 10465K
			{0.278199973, 0.285393939}, // 10466K
			{0.278195032, 0.28538802}, // 10467K
			{0.278190091, 0.285382102}, // 10468K
			{0.278185151, 0.285376185}, // 10469K
			{0.278180213, 0.28537027}, // 10470K
			{0.278175276, 0.285364356}, // 10471K
			{0.27817034, 0.285358443}, // 10472K
			{0.278165405, 0.285352531}, // 10473K
			{0.278160471, 0.28534662}, // 10474K
			{0.278155538, 0.285340711}, // 10475K
			{0.278150607, 0.285334803}, // 10476K
			{0.278145677, 0.285328896}, // 10477K
			{0.278140747, 0.28532299}, // 10478K
			{0.278135819, 0.285317085}, // 10479K
			{0.278130893, 0.285311182}, // 10480K
			{0.278125967, 0.28530528}, // 10481K
			{0.278121042, 0.285299379}, // 10482K
			{0.278116119, 0.285293479}, // 10483K
			{0.278111197, 0.285287581}, // 10484K
			{0.278106276, 0.285281684}, // 10485K
			{0.278101356, 0.285275788}, // 10486K
			{0.278096437, 0.285269893}, // 10487K
			{0.27809152, 0.285263999}, // 10488K
			{0.278086603, 0.285258107}, // 10489K
			{0.278081688, 0.285252216}, // 10490K
			{0.278076774, 0.285246326}, // 10491K
			{0.278071861, 0.285240437}, // 10492K
			{0.278066949, 0.28523455}, // 10493K
			{0.278062038, 0.285228663}, // 10494K
			{0.278057129, 0.285222778}, // 10495K
			{0.27805222, 0.285216894}, // 10496K
			{0.278047313, 0.285211012}, // 10497K
			{0.278042407, 0.28520513}, // 10498K
			{0.278037502, 0.28519925}, // 10499K
			{0.278032598, 0.285193371}, // 10500K
			{0.278027696, 0.285187493}, // 10501K
			{0.278022794, 0.285181616}, // 10502K
			{0.278017894, 0.285175741}, // 10503K
			{0.278012994, 0.285169866}, // 10504K
			{0.278008096, 0.285163993}, // 10505K
			{0.278003199, 0.285158122}, // 10506K
			{0.277998304, 0.285152251}, // 10507K
			{0.277993409, 0.285146381}, // 10508K
			{0.277988516, 0.285140513}, // 10509K
			{0.277983623, 0.285134646}, // 10510K
			{0.277978732, 0.28512878}, // 10511K
			{0.277973842, 0.285122916}, // 10512K
			{0.277968953, 0.285117052}, // 10513K
			{0.277964065, 0.28511119}, // 10514K
			{0.277959179, 0.285105329}, // 10515K
			{0.277954293, 0.285099469}, // 10516K
			{0.277949409, 0.285093611}, // 10517K
			{0.277944526, 0.285087753}, // 10518K
			{0.277939644, 0.285081897}, // 10519K
			{0.277934763, 0.285076042}, // 10520K
			{0.277929883, 0.285070189}, // 10521K
			{0.277925004, 0.285064336}, // 10522K
			{0.277920127, 0.285058485}, // 10523K
			{0.27791525, 0.285052634}, // 10524K
			{0.277910375, 0.285046785}, // 10525K
			{0.277905501, 0.285040938}, // 10526K
			{0.277900628, 0.285035091}, // 10527K
			{0.277895756, 0.285029246}, // 10528K
			{0.277890886, 0.285023401}, // 10529K
			{0.277886016, 0.285017558}, // 10530K
			{0.277881148, 0.285011717}, // 10531K
			{0.27787628, 0.285005876}, // 10532K
			{0.277871414, 0.285000037}, // 10533K
			{0.277866549, 0.284994198}, // 10534K
			{0.277861685, 0.284988361}, // 10535K
			{0.277856823, 0.284982526}, // 10536K
			{0.277851961, 0.284976691}, // 10537K
			{0.277847101, 0.284970858}, // 10538K
			{0.277842241, 0.284965025}, // 10539K
			{0.277837383, 0.284959194}, // 10540K
			{0.277832526, 0.284953364}, // 10541K
			{0.27782767, 0.284947536}, // 10542K
			{0.277822815, 0.284941708}, // 10543K
			{0.277817962, 0.284935882}, // 10544K
			{0.277813109, 0.284930057}, // 10545K
			{0.277808258, 0.284924233}, // 10546K
			{0.277803408, 0.284918411}, // 10547K
			{0.277798558, 0.284912589}, // 10548K
			{0.27779371, 0.284906769}, // 10549K
			{0.277788863, 0.28490095}, // 10550K
			{0.277784018, 0.284895132}, // 10551K
			{0.277779173, 0.284889315}, // 10552K
			{0.27777433, 0.284883499}, // 10553K
			{0.277769487, 0.284877685}, // 10554K
			{0.277764646, 0.284871872}, // 10555K
			{0.277759806, 0.28486606}, // 10556K
			{0.277754967, 0.284860249}, // 10557K
			{0.277750129, 0.28485444}, // 10558K
			{0.277745292, 0.284848631}, // 10559K
			{0.277740457, 0.284842824}, // 10560K
			{0.277735622, 0.284837018}, // 10561K
			{0.277730789, 0.284831213}, // 10562K
			{0.277725957, 0.28482541}, // 10563K
			{0.277721125, 0.284819607}, // 10564K
			{0.277716296, 0.284813806}, // 10565K
			{0.277711467, 0.284808006}, // 10566K
			{0.277706639, 0.284802207}, // 10567K
			{0.277701812, 0.284796409}, // 10568K
			{0.277696987, 0.284790613}, // 10569K
			{0.277692162, 0.284784817}, // 10570K
			{0.277687339, 0.284779023}, // 10571K
			{0.277682517, 0.28477323}, // 10572K
			{0.277677696, 0.284767438}, // 10573K
			{0.277672876, 0.284761648}, // 10574K
			{0.277668057, 0.284755858}, // 10575K
			{0.27766324, 0.28475007}, // 10576K
			{0.277658423, 0.284744283}, // 10577K
			{0.277653608, 0.284738497}, // 10578K
			{0.277648793, 0.284732712}, // 10579K
			{0.27764398, 0.284726929}, // 10580K
			{0.277639168, 0.284721147}, // 10581K
			{0.277634357, 0.284715365}, // 10582K
			{0.277629547, 0.284709585}, // 10583K
			{0.277624739, 0.284703807}, // 10584K
			{0.277619931, 0.284698029}, // 10585K
			{0.277615125, 0.284692253}, // 10586K
			{0.277610319, 0.284686477}, // 10587K
			{0.277605515, 0.284680703}, // 10588K
			{0.277600712, 0.28467493}, // 10589K
			{0.27759591, 0.284669159}, // 10590K
			{0.277591109, 0.284663388}, // 10591K
			{0.277586309, 0.284657619}, // 10592K
			{0.277581511, 0.28465185}, // 10593K
			{0.277576713, 0.284646083}, // 10594K
			{0.277571917, 0.284640318}, // 10595K
			{0.277567121, 0.284634553}, // 10596K
			{0.277562327, 0.284628789}, // 10597K
			{0.277557534, 0.284623027}, // 10598K
			{0.277552742, 0.284617266}, // 10599K
			{0.277547951, 0.284611506}, // 10600K
			{0.277543161, 0.284605747}, // 10601K
			{0.277538373, 0.28459999}, // 10602K
			{0.277533585, 0.284594233}, // 10603K
			{0.277528799, 0.284588478}, // 10604K
			{0.277524013, 0.284582724}, // 10605K
			{0.277519229, 0.284576971}, // 10606K
			{0.277514446, 0.284571219}, // 10607K
			{0.277509664, 0.284565469}, // 10608K
			{0.277504883, 0.284559719}, // 10609K
			{0.277500103, 0.284553971}, // 10610K
			{0.277495324, 0.284548224}, // 10611K
			{0.277490547, 0.284542478}, // 10612K
			{0.27748577, 0.284536733}, // 10613K
			{0.277480995, 0.28453099}, // 10614K
			{0.277476221, 0.284525247}, // 10615K
			{0.277471448, 0.284519506}, // 10616K
			{0.277466676, 0.284513766}, // 10617K
			{0.277461905, 0.284508027}, // 10618K
			{0.277457135, 0.28450229}, // 10619K
			{0.277452366, 0.284496553}, // 10620K
			{0.277447598, 0.284490818}, // 10621K
			{0.277442832, 0.284485084}, // 10622K
			{0.277438066, 0.284479351}, // 10623K
			{0.277433302, 0.284473619}, // 10624K
			{0.277428539, 0.284467888}, // 10625K
			{0.277423777, 0.284462158}, // 10626K
			{0.277419016, 0.28445643}, // 10627K
			{0.277414256, 0.284450703}, // 10628K
			{0.277409497, 0.284444977}, // 10629K
			{0.277404739, 0.284439252}, // 10630K
			{0.277399983, 0.284433528}, // 10631K
			{0.277395227, 0.284427806}, // 10632K
			{0.277390473, 0.284422084}, // 10633K
			{0.277385719, 0.284416364}, // 10634K
			{0.277380967, 0.284410645}, // 10635K
			{0.277376216, 0.284404927}, // 10636K
			{0.277371466, 0.28439921}, // 10637K
			{0.277366717, 0.284393495}, // 10638K
			{0.277361969, 0.284387781}, // 10639K
			{0.277357222, 0.284382067}, // 10640K
			{0.277352477, 0.284376355}, // 10641K
			{0.277347732, 0.284370644}, // 10642K
			{0.277342989, 0.284364935}, // 10643K
			{0.277338246, 0.284359226}, // 10644K
			{0.277333505, 0.284353519}, // 10645K
			{0.277328765, 0.284347812}, // 10646K
			{0.277324026, 0.284342107}, // 10647K
			{0.277319288, 0.284336403}, // 10648K
			{0.277314551, 0.2843307}, // 10649K
			{0.277309815, 0.284324999}, // 10650K
			{0.277305081, 0.284319298}, // 10651K
			{0.277300347, 0.284313599}, // 10652K
			{0.277295614, 0.284307901}, // 10653K
			{0.277290883, 0.284302204}, // 10654K
			{0.277286153, 0.284296508}, // 10655K
			{0.277281423, 0.284290813}, // 10656K
			{0.277276695, 0.28428512}, // 10657K
			{0.277271968, 0.284279427}, // 10658K
			{0.277267242, 0.284273736}, // 10659K
			{0.277262517, 0.284268046}, // 10660K
			{0.277257793, 0.284262357}, // 10661K
			{0.277253071, 0.284256669}, // 10662K
			{0.277248349, 0.284250983}, // 10663K
			{0.277243629, 0.284245297}, // 10664K
			{0.277238909, 0.284239613}, // 10665K
			{0.277234191, 0.28423393}, // 10666K
			{0.277229474, 0.284228248}, // 10667K
			{0.277224757, 0.284222567}, // 10668K
			{0.277220042, 0.284216887}, // 10669K
			{0.277215328, 0.284211209}, // 10670K
			{0.277210615, 0.284205532}, // 10671K
			{0.277205904, 0.284199855}, // 10672K
			{0.277201193, 0.28419418}, // 10673K
			{0.277196483, 0.284188506}, // 10674K
			{0.277191775, 0.284182834}, // 10675K
			{0.277187067, 0.284177162}, // 10676K
			{0.277182361, 0.284171491}, // 10677K
			{0.277177655, 0.284165822}, // 10678K
			{0.277172951, 0.284160154}, // 10679K
			{0.277168248, 0.284154487}, // 10680K
			{0.277163546, 0.284148821}, // 10681K
			{0.277158845, 0.284143156}, // 10682K
			{0.277154145, 0.284137493}, // 10683K
			{0.277149446, 0.28413183}, // 10684K
			{0.277144748, 0.284126169}, // 10685K
			{0.277140052, 0.284120509}, // 10686K
			{0.277135356, 0.28411485}, // 10687K
			{0.277130661, 0.284109192}, // 10688K
			{0.277125968, 0.284103535}, // 10689K
			{0.277121276, 0.28409788}, // 10690K
			{0.277116584, 0.284092225}, // 10691K
			{0.277111894, 0.284086572}, // 10692K
			{0.277107205, 0.28408092}, // 10693K
			{0.277102517, 0.284075269}, // 10694K
			{0.27709783, 0.284069619}, // 10695K
			{0.277093144, 0.284063971}, // 10696K
			{0.277088459, 0.284058323}, // 10697K
			{0.277083776, 0.284052677}, // 10698K
			{0.277079093, 0.284047031}, // 10699K
			{0.277074411, 0.284041387}, // 10700K
			{0.277069731, 0.284035744}, // 10701K
			{0.277065051, 0.284030103}, // 10702K
			{0.277060373, 0.284024462}, // 10703K
			{0.277055696, 0.284018822}, // 10704K
			{0.27705102, 0.284013184}, // 10705K
			{0.277046344, 0.284007547}, // 10706K
			{0.27704167, 0.284001911}, // 10707K
			{0.277036997, 0.283996276}, // 10708K
			{0.277032325, 0.283990642}, // 10709K
			{0.277027655, 0.283985009}, // 10710K
			{0.277022985, 0.283979377}, // 10711K
			{0.277018316, 0.283973747}, // 10712K
			{0.277013648, 0.283968118}, // 10713K
			{0.277008982, 0.28396249}, // 10714K
			{0.277004316, 0.283956863}, // 10715K
			{0.276999652, 0.283951237}, // 10716K
			{0.276994989, 0.283945612}, // 10717K
			{0.276990326, 0.283939988}, // 10718K
			{0.276985665, 0.283934366}, // 10719K
			{0.276981005, 0.283928745}, // 10720K
			{0.276976346, 0.283923124}, // 10721K
			{0.276971688, 0.283917505}, // 10722K
			{0.276967031, 0.283911887}, // 10723K
			{0.276962375, 0.283906271}, // 10724K
			{0.27695772, 0.283900655}, // 10725K
			{0.276953066, 0.283895041}, // 10726K
			{0.276948414, 0.283889427}, // 10727K
			{0.276943762, 0.283883815}, // 10728K
			{0.276939112, 0.283878204}, // 10729K
			{0.276934462, 0.283872594}, // 10730K
			{0.276929814, 0.283866985}, // 10731K
			{0.276925166, 0.283861377}, // 10732K
			{0.27692052, 0.283855771}, // 10733K
			{0.276915875, 0.283850165}, // 10734K
			{0.276911231, 0.283844561}, // 10735K
			{0.276906588, 0.283838958}, // 10736K
			{0.276901946, 0.283833356}, // 10737K
			{0.276897305, 0.283827755}, // 10738K
			{0.276892665, 0.283822155}, // 10739K
			{0.276888026, 0.283816556}, // 10740K
			{0.276883388, 0.283810959}, // 10741K
			{0.276878751, 0.283805362}, // 10742K
			{0.276874116, 0.283799767}, // 10743K
			{0.276869481, 0.283794173}, // 10744K
			{0.276864848, 0.28378858}, // 10745K
			{0.276860215, 0.283782988}, // 10746K
			{0.276855584, 0.283777397}, // 10747K
			{0.276850953, 0.283771808}, // 10748K
			{0.276846324, 0.283766219}, // 10749K
			{0.276841696, 0.283760632}, // 10750K
			{0.276837069, 0.283755046}, // 10751K
			{0.276832442, 0.28374946}, // 10752K
			{0.276827817, 0.283743876}, // 10753K
			{0.276823193, 0.283738294}, // 10754K
			{0.27681857, 0.283732712}, // 10755K
			{0.276813949, 0.283727131}, // 10756K
			{0.276809328, 0.283721552}, // 10757K
			{0.276804708, 0.283715973}, // 10758K
			{0.276800089, 0.283710396}, // 10759K
			{0.276795471, 0.28370482}, // 10760K
			{0.276790855, 0.283699245}, // 10761K
			{0.276786239, 0.283693671}, // 10762K
			{0.276781625, 0.283688098}, // 10763K
			{0.276777011, 0.283682527}, // 10764K
			{0.276772399, 0.283676956}, // 10765K
			{0.276767788, 0.283671387}, // 10766K
			{0.276763177, 0.283665819}, // 10767K
			{0.276758568, 0.283660251}, // 10768K
			{0.27675396, 0.283654685}, // 10769K
			{0.276749353, 0.28364912}, // 10770K
			{0.276744747, 0.283643557}, // 10771K
			{0.276740141, 0.283637994}, // 10772K
			{0.276735537, 0.283632432}, // 10773K
			{0.276730935, 0.283626872}, // 10774K
			{0.276726333, 0.283621313}, // 10775K
			{0.276721732, 0.283615755}, // 10776K
			{0.276717132, 0.283610198}, // 10777K
			{0.276712533, 0.283604642}, // 10778K
			{0.276707936, 0.283599087}, // 10779K
			{0.276703339, 0.283593533}, // 10780K
			{0.276698743, 0.28358798}, // 10781K
			{0.276694149, 0.283582429}, // 10782K
			{0.276689555, 0.283576879}, // 10783K
			{0.276684963, 0.283571329}, // 10784K
			{0.276680371, 0.283565781}, // 10785K
			{0.276675781, 0.283560234}, // 10786K
			{0.276671192, 0.283554688}, // 10787K
			{0.276666603, 0.283549144}, // 10788K
			{0.276662016, 0.2835436}, // 10789K
			{0.27665743, 0.283538057}, // 10790K
			{0.276652845, 0.283532516}, // 10791K
			{0.276648261, 0.283526976}, // 10792K
			{0.276643678, 0.283521436}, // 10793K
			{0.276639096, 0.283515898}, // 10794K
			{0.276634515, 0.283510361}, // 10795K
			{0.276629935, 0.283504825}, // 10796K
			{0.276625356, 0.283499291}, // 10797K
			{0.276620778, 0.283493757}, // 10798K
			{0.276616201, 0.283488225}, // 10799K
			{0.276611626, 0.283482693}, // 10800K
			{0.276607051, 0.283477163}, // 10801K
			{0.276602477, 0.283471634}, // 10802K
			{0.276597905, 0.283466105}, // 10803K
			{0.276593333, 0.283460579}, // 10804K
			{0.276588762, 0.283455053}, // 10805K
			{0.276584193, 0.283449528}, // 10806K
			{0.276579624, 0.283444004}, // 10807K
			{0.276575057, 0.283438482}, // 10808K
			{0.276570491, 0.28343296}, // 10809K
			{0.276565925, 0.28342744}, // 10810K
			{0.276561361, 0.283421921}, // 10811K
			{0.276556798, 0.283416403}, // 10812K
			{0.276552235, 0.283410886}, // 10813K
			{0.276547674, 0.28340537}, // 10814K
			{0.276543114, 0.283399855}, // 10815K
			{0.276538555, 0.283394341}, // 10816K
			{0.276533997, 0.283388829}, // 10817K
			{0.27652944, 0.283383317}, // 10818K
			{0.276524884, 0.283377807}, // 10819K
			{0.276520329, 0.283372298}, // 10820K
			{0.276515775, 0.28336679}, // 10821K
			{0.276511222, 0.283361282}, // 10822K
			{0.27650667, 0.283355777}, // 10823K
			{0.276502119, 0.283350272}, // 10824K
			{0.276497569, 0.283344768}, // 10825K
			{0.27649302, 0.283339265}, // 10826K
			{0.276488473, 0.283333764}, // 10827K
			{0.276483926, 0.283328263}, // 10828K
			{0.27647938, 0.283322764}, // 10829K
			{0.276474836, 0.283317266}, // 10830K
			{0.276470292, 0.283311769}, // 10831K
			{0.276465749, 0.283306273}, // 10832K
			{0.276461208, 0.283300778}, // 10833K
			{0.276456667, 0.283295284}, // 10834K
			{0.276452128, 0.283289791}, // 10835K
			{0.276447589, 0.2832843}, // 10836K
			{0.276443052, 0.283278809}, // 10837K
			{0.276438516, 0.28327332}, // 10838K
			{0.27643398, 0.283267832}, // 10839K
			{0.276429446, 0.283262344}, // 10840K
			{0.276424912, 0.283256858}, // 10841K
			{0.27642038, 0.283251373}, // 10842K
			{0.276415849, 0.283245889}, // 10843K
			{0.276411319, 0.283240407}, // 10844K
			{0.276406789, 0.283234925}, // 10845K
			{0.276402261, 0.283229444}, // 10846K
			{0.276397734, 0.283223965}, // 10847K
			{0.276393208, 0.283218486}, // 10848K
			{0.276388683, 0.283213009}, // 10849K
			{0.276384159, 0.283207533}, // 10850K
			{0.276379636, 0.283202058}, // 10851K
			{0.276375114, 0.283196584}, // 10852K
			{0.276370593, 0.283191111}, // 10853K
			{0.276366073, 0.283185639}, // 10854K
			{0.276361554, 0.283180168}, // 10855K
			{0.276357036, 0.283174698}, // 10856K
			{0.276352519, 0.28316923}, // 10857K
			{0.276348003, 0.283163762}, // 10858K
			{0.276343488, 0.283158296}, // 10859K
			{0.276338974, 0.283152831}, // 10860K
			{0.276334461, 0.283147367}, // 10861K
			{0.276329949, 0.283141903}, // 10862K
			{0.276325439, 0.283136441}, // 10863K
			{0.276320929, 0.283130981}, // 10864K
			{0.27631642, 0.283125521}, // 10865K
			{0.276311912, 0.283120062}, // 10866K
			{0.276307406, 0.283114604}, // 10867K
			{0.2763029, 0.283109148}, // 10868K
			{0.276298395, 0.283103692}, // 10869K
			{0.276293892, 0.283098238}, // 10870K
			{0.276289389, 0.283092785}, // 10871K
			{0.276284887, 0.283087333}, // 10872K
			{0.276280387, 0.283081881}, // 10873K
			{0.276275887, 0.283076431}, // 10874K
			{0.276271389, 0.283070983}, // 10875K
			{0.276266891, 0.283065535}, // 10876K
			{0.276262395, 0.283060088}, // 10877K
			{0.276257899, 0.283054642}, // 10878K
			{0.276253404, 0.283049198}, // 10879K
			{0.276248911, 0.283043754}, // 10880K
			{0.276244419, 0.283038312}, // 10881K
			{0.276239927, 0.283032871}, // 10882K
			{0.276235437, 0.28302743}, // 10883K
			{0.276230947, 0.283021991}, // 10884K
			{0.276226459, 0.283016553}, // 10885K
			{0.276221971, 0.283011116}, // 10886K
			{0.276217485, 0.28300568}, // 10887K
			{0.276213, 0.283000246}, // 10888K
			{0.276208515, 0.282994812}, // 10889K
			{0.276204032, 0.282989379}, // 10890K
			{0.27619955, 0.282983948}, // 10891K
			{0.276195068, 0.282978517}, // 10892K
			{0.276190588, 0.282973088}, // 10893K
			{0.276186109, 0.28296766}, // 10894K
			{0.27618163, 0.282962233}, // 10895K
			{0.276177153, 0.282956806}, // 10896K
			{0.276172677, 0.282951381}, // 10897K
			{0.276168201, 0.282945957}, // 10898K
			{0.276163727, 0.282940535}, // 10899K
			{0.276159254, 0.282935113}, // 10900K
			{0.276154782, 0.282929692}, // 10901K
			{0.276150311, 0.282924272}, // 10902K
			{0.27614584, 0.282918854}, // 10903K
			{0.276141371, 0.282913436}, // 10904K
			{0.276136903, 0.28290802}, // 10905K
			{0.276132436, 0.282902605}, // 10906K
			{0.276127969, 0.282897191}, // 10907K
			{0.276123504, 0.282891777}, // 10908K
			{0.27611904, 0.282886365}, // 10909K
			{0.276114577, 0.282880954}, // 10910K
			{0.276110115, 0.282875544}, // 10911K
			{0.276105654, 0.282870136}, // 10912K
			{0.276101193, 0.282864728}, // 10913K
			{0.276096734, 0.282859321}, // 10914K
			{0.276092276, 0.282853916}, // 10915K
			{0.276087819, 0.282848511}, // 10916K
			{0.276083363, 0.282843108}, // 10917K
			{0.276078908, 0.282837705}, // 10918K
			{0.276074454, 0.282832304}, // 10919K
			{0.27607, 0.282826904}, // 10920K
			{0.276065548, 0.282821505}, // 10921K
			{0.276061097, 0.282816107}, // 10922K
			{0.276056647, 0.28281071}, // 10923K
			{0.276052198, 0.282805314}, // 10924K
			{0.27604775, 0.282799919}, // 10925K
			{0.276043303, 0.282794525}, // 10926K
			{0.276038857, 0.282789132}, // 10927K
			{0.276034411, 0.282783741}, // 10928K
			{0.276029967, 0.28277835}, // 10929K
			{0.276025524, 0.282772961}, // 10930K
			{0.276021082, 0.282767572}, // 10931K
			{0.276016641, 0.282762185}, // 10932K
			{0.276012201, 0.282756799}, // 10933K
			{0.276007762, 0.282751414}, // 10934K
			{0.276003324, 0.282746029}, // 10935K
			{0.275998886, 0.282740646}, // 10936K
			{0.27599445, 0.282735264}, // 10937K
			{0.275990015, 0.282729884}, // 10938K
			{0.275985581, 0.282724504}, // 10939K
			{0.275981148, 0.282719125}, // 10940K
			{0.275976716, 0.282713747}, // 10941K
			{0.275972285, 0.282708371}, // 10942K
			{0.275967854, 0.282702995}, // 10943K
			{0.275963425, 0.282697621}, // 10944K
			{0.275958997, 0.282692247}, // 10945K
			{0.27595457, 0.282686875}, // 10946K
			{0.275950144, 0.282681504}, // 10947K
			{0.275945719, 0.282676133}, // 10948K
			{0.275941294, 0.282670764}, // 10949K
			{0.275936871, 0.282665396}, // 10950K
			{0.275932449, 0.282660029}, // 10951K
			{0.275928028, 0.282654663}, // 10952K
			{0.275923608, 0.282649298}, // 10953K
			{0.275919188, 0.282643934}, // 10954K
			{0.27591477, 0.282638572}, // 10955K
			{0.275910353, 0.28263321}, // 10956K
			{0.275905937, 0.282627849}, // 10957K
			{0.275901521, 0.28262249}, // 10958K
			{0.275897107, 0.282617131}, // 10959K
			{0.275892694, 0.282611774}, // 10960K
			{0.275888281, 0.282606418}, // 10961K
			{0.27588387, 0.282601062}, // 10962K
			{0.27587946, 0.282595708}, // 10963K
			{0.27587505, 0.282590355}, // 10964K
			{0.275870642, 0.282585003}, // 10965K
			{0.275866235, 0.282579652}, // 10966K
			{0.275861828, 0.282574302}, // 10967K
			{0.275857423, 0.282568953}, // 10968K
			{0.275853019, 0.282563605}, // 10969K
			{0.275848615, 0.282558258}, // 10970K
			{0.275844213, 0.282552912}, // 10971K
			{0.275839811, 0.282547568}, // 10972K
			{0.275835411, 0.282542224}, // 10973K
			{0.275831011, 0.282536881}, // 10974K
			{0.275826613, 0.28253154}, // 10975K
			{0.275822216, 0.2825262}, // 10976K
			{0.275817819, 0.28252086}, // 10977K
			{0.275813424, 0.282515522}, // 10978K
			{0.275809029, 0.282510185}, // 10979K
			{0.275804635, 0.282504848}, // 10980K
			{0.275800243, 0.282499513}, // 10981K
			{0.275795851, 0.282494179}, // 10982K
			{0.275791461, 0.282488846}, // 10983K
			{0.275787071, 0.282483514}, // 10984K
			{0.275782682, 0.282478183}, // 10985K
			{0.275778295, 0.282472853}, // 10986K
			{0.275773908, 0.282467524}, // 10987K
			{0.275769522, 0.282462197}, // 10988K
			{0.275765138, 0.28245687}, // 10989K
			{0.275760754, 0.282451544}, // 10990K
			{0.275756371, 0.28244622}, // 10991K
			{0.275751989, 0.282440896}, // 10992K
			{0.275747609, 0.282435574}, // 10993K
			{0.275743229, 0.282430252}, // 10994K
			{0.27573885, 0.282424932}, // 10995K
			{0.275734472, 0.282419613}, // 10996K
			{0.275730095, 0.282414294}, // 10997K
			{0.275725719, 0.282408977}, // 10998K
			{0.275721345, 0.282403661}, // 10999K
			{0.275716971, 0.282398346}, // 11000K
			{0.275712598, 0.282393032}, // 11001K
			{0.275708226, 0.282387719}, // 11002K
			{0.275703855, 0.282382407}, // 11003K
			{0.275699485, 0.282377096}, // 11004K
			{0.275695116, 0.282371786}, // 11005K
			{0.275690747, 0.282366477}, // 11006K
			{0.27568638, 0.28236117}, // 11007K
			{0.275682014, 0.282355863}, // 11008K
			{0.275677649, 0.282350557}, // 11009K
			{0.275673285, 0.282345253}, // 11010K
			{0.275668922, 0.282339949}, // 11011K
			{0.27566456, 0.282334647}, // 11012K
			{0.275660198, 0.282329345}, // 11013K
			{0.275655838, 0.282324045}, // 11014K
			{0.275651479, 0.282318745}, // 11015K
			{0.27564712, 0.282313447}, // 11016K
			{0.275642763, 0.28230815}, // 11017K
			{0.275638407, 0.282302854}, // 11018K
			{0.275634051, 0.282297559}, // 11019K
			{0.275629697, 0.282292264}, // 11020K
			{0.275625343, 0.282286971}, // 11021K
			{0.275620991, 0.282281679}, // 11022K
			{0.275616639, 0.282276388}, // 11023K
			{0.275612289, 0.282271098}, // 11024K
			{0.275607939, 0.28226581}, // 11025K
			{0.27560359, 0.282260522}, // 11026K
			{0.275599243, 0.282255235}, // 11027K
			{0.275594896, 0.282249949}, // 11028K
			{0.27559055, 0.282244664}, // 11029K
			{0.275586206, 0.282239381}, // 11030K
			{0.275581862, 0.282234098}, // 11031K
			{0.275577519, 0.282228817}, // 11032K
			{0.275573177, 0.282223536}, // 11033K
			{0.275568836, 0.282218257}, // 11034K
			{0.275564496, 0.282212978}, // 11035K
			{0.275560157, 0.282207701}, // 11036K
			{0.275555819, 0.282202424}, // 11037K
			{0.275551482, 0.282197149}, // 11038K
			{0.275547146, 0.282191875}, // 11039K
			{0.275542811, 0.282186602}, // 11040K
			{0.275538477, 0.282181329}, // 11041K
			{0.275534144, 0.282176058}, // 11042K
			{0.275529812, 0.282170788}, // 11043K
			{0.275525481, 0.282165519}, // 11044K
			{0.27552115, 0.282160251}, // 11045K
			{0.275516821, 0.282154984}, // 11046K
			{0.275512493, 0.282149718}, // 11047K
			{0.275508165, 0.282144453}, // 11048K
			{0.275503839, 0.282139189}, // 11049K
			{0.275499514, 0.282133926}, // 11050K
			{0.275495189, 0.282128665}, // 11051K
			{0.275490866, 0.282123404}, // 11052K
			{0.275486543, 0.282118144}, // 11053K
			{0.275482221, 0.282112885}, // 11054K
			{0.275477901, 0.282107628}, // 11055K
			{0.275473581, 0.282102371}, // 11056K
			{0.275469262, 0.282097116}, // 11057K
			{0.275464945, 0.282091861}, // 11058K
			{0.275460628, 0.282086607}, // 11059K
			{0.275456312, 0.282081355}, // 11060K
			{0.275451997, 0.282076104}, // 11061K
			{0.275447683, 0.282070853}, // 11062K
			{0.27544337, 0.282065604}, // 11063K
			{0.275439058, 0.282060355}, // 11064K
			{0.275434747, 0.282055108}, // 11065K
			{0.275430437, 0.282049862}, // 11066K
			{0.275426128, 0.282044617}, // 11067K
			{0.27542182, 0.282039372}, // 11068K
			{0.275417513, 0.282034129}, // 11069K
			{0.275413206, 0.282028887}, // 11070K
			{0.275408901, 0.282023646}, // 11071K
			{0.275404597, 0.282018406}, // 11072K
			{0.275400293, 0.282013167}, // 11073K
			{0.275395991, 0.282007929}, // 11074K
			{0.275391689, 0.282002692}, // 11075K
			{0.275387389, 0.281997456}, // 11076K
			{0.275383089, 0.281992221}, // 11077K
			{0.275378791, 0.281986987}, // 11078K
			{0.275374493, 0.281981754}, // 11079K
			{0.275370196, 0.281976523}, // 11080K
			{0.275365901, 0.281971292}, // 11081K
			{0.275361606, 0.281966062}, // 11082K
			{0.275357312, 0.281960833}, // 11083K
			{0.275353019, 0.281955606}, // 11084K
			{0.275348727, 0.281950379}, // 11085K
			{0.275344436, 0.281945153}, // 11086K
			{0.275340146, 0.281939929}, // 11087K
			{0.275335857, 0.281934705}, // 11088K
			{0.275331569, 0.281929482}, // 11089K
			{0.275327282, 0.281924261}, // 11090K
			{0.275322995, 0.28191904}, // 11091K
			{0.27531871, 0.281913821}, // 11092K
			{0.275314426, 0.281908602}, // 11093K
			{0.275310142, 0.281903385}, // 11094K
			{0.27530586, 0.281898169}, // 11095K
			{0.275301579, 0.281892953}, // 11096K
			{0.275297298, 0.281887739}, // 11097K
			{0.275293018, 0.281882526}, // 11098K
			{0.27528874, 0.281877313}, // 11099K
			{0.275284462, 0.281872102}, // 11100K
			{0.275280185, 0.281866892}, // 11101K
			{0.27527591, 0.281861682}, // 11102K
			{0.275271635, 0.281856474}, // 11103K
			{0.275267361, 0.281851267}, // 11104K
			{0.275263088, 0.281846061}, // 11105K
			{0.275258816, 0.281840856}, // 11106K
			{0.275254545, 0.281835652}, // 11107K
			{0.275250275, 0.281830449}, // 11108K
			{0.275246005, 0.281825246}, // 11109K
			{0.275241737, 0.281820045}, // 11110K
			{0.27523747, 0.281814845}, // 11111K
			{0.275233203, 0.281809646}, // 11112K
			{0.275228938, 0.281804448}, // 11113K
			{0.275224674, 0.281799251}, // 11114K
			{0.27522041, 0.281794055}, // 11115K
			{0.275216148, 0.281788861}, // 11116K
			{0.275211886, 0.281783667}, // 11117K
			{0.275207625, 0.281778474}, // 11118K
			{0.275203365, 0.281773282}, // 11119K
			{0.275199107, 0.281768091}, // 11120K
			{0.275194849, 0.281762901}, // 11121K
			{0.275190592, 0.281757712}, // 11122K
			{0.275186336, 0.281752525}, // 11123K
			{0.275182081, 0.281747338}, // 11124K
			{0.275177827, 0.281742152}, // 11125K
			{0.275173574, 0.281736967}, // 11126K
			{0.275169321, 0.281731784}, // 11127K
			{0.27516507, 0.281726601}, // 11128K
			{0.27516082, 0.281721419}, // 11129K
			{0.27515657, 0.281716238}, // 11130K
			{0.275152322, 0.281711059}, // 11131K
			{0.275148074, 0.28170588}, // 11132K
			{0.275143828, 0.281700702}, // 11133K
			{0.275139582, 0.281695526}, // 11134K
			{0.275135337, 0.28169035}, // 11135K
			{0.275131094, 0.281685176}, // 11136K
			{0.275126851, 0.281680002}, // 11137K
			{0.275122609, 0.28167483}, // 11138K
			{0.275118368, 0.281669658}, // 11139K
			{0.275114128, 0.281664487}, // 11140K
			{0.275109889, 0.281659318}, // 11141K
			{0.27510565, 0.281654149}, // 11142K
			{0.275101413, 0.281648982}, // 11143K
			{0.275097177, 0.281643815}, // 11144K
			{0.275092942, 0.28163865}, // 11145K
			{0.275088707, 0.281633486}, // 11146K
			{0.275084474, 0.281628322}, // 11147K
			{0.275080241, 0.28162316}, // 11148K
			{0.27507601, 0.281617998}, // 11149K
			{0.275071779, 0.281612838}, // 11150K
			{0.275067549, 0.281607678}, // 11151K
			{0.27506332, 0.28160252}, // 11152K
			{0.275059092, 0.281597363}, // 11153K
			{0.275054865, 0.281592206}, // 11154K
			{0.275050639, 0.281587051}, // 11155K
			{0.275046414, 0.281581897}, // 11156K
			{0.27504219, 0.281576743}, // 11157K
			{0.275037967, 0.281571591}, // 11158K
			{0.275033745, 0.281566439}, // 11159K
			{0.275029523, 0.281561289}, // 11160K
			{0.275025303, 0.28155614}, // 11161K
			{0.275021083, 0.281550992}, // 11162K
			{0.275016865, 0.281545844}, // 11163K
			{0.275012647, 0.281540698}, // 11164K
			{0.27500843, 0.281535553}, // 11165K
			{0.275004214, 0.281530408}, // 11166K
			{0.274999999, 0.281525265}, // 11167K
			{0.274995786, 0.281520123}, // 11168K
			{0.274991573, 0.281514982}, // 11169K
			{0.27498736, 0.281509841}, // 11170K
			{0.274983149, 0.281504702}, // 11171K
			{0.274978939, 0.281499564}, // 11172K
			{0.27497473, 0.281494427}, // 11173K
			{0.274970521, 0.28148929}, // 11174K
			{0.274966314, 0.281484155}, // 11175K
			{0.274962107, 0.281479021}, // 11176K
			{0.274957902, 0.281473888}, // 11177K
			{0.274953697, 0.281468755}, // 11178K
			{0.274949493, 0.281463624}, // 11179K
			{0.27494529, 0.281458494}, // 11180K
			{0.274941088, 0.281453365}, // 11181K
			{0.274936887, 0.281448237}, // 11182K
			{0.274932687, 0.281443109}, // 11183K
			{0.274928488, 0.281437983}, // 11184K
			{0.27492429, 0.281432858}, // 11185K
			{0.274920093, 0.281427734}, // 11186K
			{0.274915896, 0.28142261}, // 11187K
			{0.274911701, 0.281417488}, // 11188K
			{0.274907506, 0.281412367}, // 11189K
			{0.274903313, 0.281407247}, // 11190K
			{0.27489912, 0.281402128}, // 11191K
			{0.274894928, 0.281397009}, // 11192K
			{0.274890737, 0.281391892}, // 11193K
			{0.274886548, 0.281386776}, // 11194K
			{0.274882359, 0.281381661}, // 11195K
			{0.27487817, 0.281376547}, // 11196K
			{0.274873983, 0.281371433}, // 11197K
			{0.274869797, 0.281366321}, // 11198K
			{0.274865612, 0.28136121}, // 11199K
			{0.274861427, 0.2813561}, // 11200K
			{0.274857244, 0.28135099}, // 11201K
			{0.274853061, 0.281345882}, // 11202K
			{0.27484888, 0.281340775}, // 11203K
			{0.274844699, 0.281335669}, // 11204K
			{0.274840519, 0.281330563}, // 11205K
			{0.27483634, 0.281325459}, // 11206K
			{0.274832162, 0.281320356}, // 11207K
			{0.274827985, 0.281315254}, // 11208K
			{0.274823809, 0.281310152}, // 11209K
			{0.274819634, 0.281305052}, // 11210K
			{0.274815459, 0.281299953}, // 11211K
			{0.274811286, 0.281294855}, // 11212K
			{0.274807113, 0.281289757}, // 11213K
			{0.274802942, 0.281284661}, // 11214K
			{0.274798771, 0.281279566}, // 11215K
			{0.274794601, 0.281274471}, // 11216K
			{0.274790433, 0.281269378}, // 11217K
			{0.274786265, 0.281264286}, // 11218K
			{0.274782098, 0.281259194}, // 11219K
			{0.274777932, 0.281254104}, // 11220K
			{0.274773766, 0.281249015}, // 11221K
			{0.274769602, 0.281243926}, // 11222K
			{0.274765439, 0.281238839}, // 11223K
			{0.274761276, 0.281233753}, // 11224K
			{0.274757115, 0.281228667}, // 11225K
			{0.274752954, 0.281223583}, // 11226K
			{0.274748794, 0.281218499}, // 11227K
			{0.274744636, 0.281213417}, // 11228K
			{0.274740478, 0.281208336}, // 11229K
			{0.274736321, 0.281203255}, // 11230K
			{0.274732165, 0.281198176}, // 11231K
			{0.274728009, 0.281193097}, // 11232K
			{0.274723855, 0.28118802}, // 11233K
			{0.274719702, 0.281182943}, // 11234K
			{0.274715549, 0.281177868}, // 11235K
			{0.274711398, 0.281172793}, // 11236K
			{0.274707247, 0.28116772}, // 11237K
			{0.274703098, 0.281162647}, // 11238K
			{0.274698949, 0.281157576}, // 11239K
			{0.274694801, 0.281152505}, // 11240K
			{0.274690654, 0.281147436}, // 11241K
			{0.274686508, 0.281142367}, // 11242K
			{0.274682363, 0.281137299}, // 11243K
			{0.274678218, 0.281132233}, // 11244K
			{0.274674075, 0.281127167}, // 11245K
			{0.274669932, 0.281122103}, // 11246K
			{0.274665791, 0.281117039}, // 11247K
			{0.27466165, 0.281111976}, // 11248K
			{0.274657511, 0.281106914}, // 11249K
			{0.274653372, 0.281101854}, // 11250K
			{0.274649234, 0.281096794}, // 11251K
			{0.274645097, 0.281091735}, // 11252K
			{0.274640961, 0.281086678}, // 11253K
			{0.274636825, 0.281081621}, // 11254K
			{0.274632691, 0.281076565}, // 11255K
			{0.274628558, 0.28107151}, // 11256K
			{0.274624425, 0.281066456}, // 11257K
			{0.274620293, 0.281061403}, // 11258K
			{0.274616163, 0.281056352}, // 11259K
			{0.274612033, 0.281051301}, // 11260K
			{0.274607904, 0.281046251}, // 11261K
			{0.274603776, 0.281041202}, // 11262K
			{0.274599649, 0.281036154}, // 11263K
			{0.274595523, 0.281031107}, // 11264K
			{0.274591397, 0.281026061}, // 11265K
			{0.274587273, 0.281021016}, // 11266K
			{0.27458315, 0.281015972}, // 11267K
			{0.274579027, 0.281010929}, // 11268K
			{0.274574905, 0.281005887}, // 11269K
			{0.274570784, 0.281000846}, // 11270K
			{0.274566664, 0.280995806}, // 11271K
			{0.274562545, 0.280990767}, // 11272K
			{0.274558427, 0.280985728}, // 11273K
			{0.27455431, 0.280980691}, // 11274K
			{0.274550194, 0.280975655}, // 11275K
			{0.274546078, 0.28097062}, // 11276K
			{0.274541964, 0.280965586}, // 11277K
			{0.27453785, 0.280960552}, // 11278K
			{0.274533738, 0.28095552}, // 11279K
			{0.274529626, 0.280950489}, // 11280K
			{0.274525515, 0.280945458}, // 11281K
			{0.274521405, 0.280940429}, // 11282K
			{0.274517296, 0.280935401}, // 11283K
			{0.274513187, 0.280930373}, // 11284K
			{0.27450908, 0.280925347}, // 11285K
			{0.274504974, 0.280920321}, // 11286K
			{0.274500868, 0.280915297}, // 11287K
			{0.274496763, 0.280910273}, // 11288K
			{0.274492659, 0.280905251}, // 11289K
			{0.274488557, 0.280900229}, // 11290K
			{0.274484455, 0.280895209}, // 11291K
			{0.274480354, 0.280890189}, // 11292K
			{0.274476253, 0.28088517}, // 11293K
			{0.274472154, 0.280880153}, // 11294K
			{0.274468056, 0.280875136}, // 11295K
			{0.274463958, 0.28087012}, // 11296K
			{0.274459861, 0.280865105}, // 11297K
			{0.274455766, 0.280860092}, // 11298K
			{0.274451671, 0.280855079}, // 11299K
			{0.274447577, 0.280850067}, // 11300K
			{0.274443484, 0.280845056}, // 11301K
			{0.274439392, 0.280840046}, // 11302K
			{0.2744353, 0.280835037}, // 11303K
			{0.27443121, 0.280830029}, // 11304K
			{0.27442712, 0.280825022}, // 11305K
			{0.274423032, 0.280820016}, // 11306K
			{0.274418944, 0.280815011}, // 11307K
			{0.274414857, 0.280810007}, // 11308K
			{0.274410771, 0.280805004}, // 11309K
			{0.274406686, 0.280800002}, // 11310K
			{0.274402602, 0.280795001}, // 11311K
			{0.274398519, 0.28079}, // 11312K
			{0.274394436, 0.280785001}, // 11313K
			{0.274390355, 0.280780003}, // 11314K
			{0.274386274, 0.280775006}, // 11315K
			{0.274382194, 0.280770009}, // 11316K
			{0.274378115, 0.280765014}, // 11317K
			{0.274374037, 0.280760019}, // 11318K
			{0.27436996, 0.280755026}, // 11319K
			{0.274365884, 0.280750034}, // 11320K
			{0.274361809, 0.280745042}, // 11321K
			{0.274357734, 0.280740051}, // 11322K
			{0.274353661, 0.280735062}, // 11323K
			{0.274349588, 0.280730073}, // 11324K
			{0.274345516, 0.280725086}, // 11325K
			{0.274341446, 0.280720099}, // 11326K
			{0.274337376, 0.280715113}, // 11327K
			{0.274333306, 0.280710128}, // 11328K
			{0.274329238, 0.280705145}, // 11329K
			{0.274325171, 0.280700162}, // 11330K
			{0.274321104, 0.28069518}, // 11331K
			{0.274317039, 0.280690199}, // 11332K
			{0.274312974, 0.280685219}, // 11333K
			{0.27430891, 0.28068024}, // 11334K
			{0.274304847, 0.280675262}, // 11335K
			{0.274300785, 0.280670285}, // 11336K
			{0.274296724, 0.280665309}, // 11337K
			{0.274292664, 0.280660334}, // 11338K
			{0.274288604, 0.280655359}, // 11339K
			{0.274284546, 0.280650386}, // 11340K
			{0.274280488, 0.280645414}, // 11341K
			{0.274276431, 0.280640443}, // 11342K
			{0.274272375, 0.280635472}, // 11343K
			{0.27426832, 0.280630503}, // 11344K
			{0.274264266, 0.280625534}, // 11345K
			{0.274260213, 0.280620567}, // 11346K
			{0.27425616, 0.2806156}, // 11347K
			{0.274252109, 0.280610635}, // 11348K
			{0.274248058, 0.28060567}, // 11349K
			{0.274244008, 0.280600707}, // 11350K
			{0.274239959, 0.280595744}, // 11351K
			{0.274235911, 0.280590782}, // 11352K
			{0.274231864, 0.280585822}, // 11353K
			{0.274227818, 0.280580862}, // 11354K
			{0.274223773, 0.280575903}, // 11355K
			{0.274219728, 0.280570945}, // 11356K
			{0.274215684, 0.280565988}, // 11357K
			{0.274211642, 0.280561032}, // 11358K
			{0.2742076, 0.280556077}, // 11359K
			{0.274203559, 0.280551123}, // 11360K
			{0.274199519, 0.28054617}, // 11361K
			{0.274195479, 0.280541218}, // 11362K
			{0.274191441, 0.280536267}, // 11363K
			{0.274187403, 0.280531316}, // 11364K
			{0.274183367, 0.280526367}, // 11365K
			{0.274179331, 0.280521419}, // 11366K
			{0.274175296, 0.280516471}, // 11367K
			{0.274171262, 0.280511525}, // 11368K
			{0.274167229, 0.280506579}, // 11369K
			{0.274163197, 0.280501635}, // 11370K
			{0.274159165, 0.280496691}, // 11371K
			{0.274155135, 0.280491749}, // 11372K
			{0.274151105, 0.280486807}, // 11373K
			{0.274147076, 0.280481866}, // 11374K
			{0.274143048, 0.280476926}, // 11375K
			{0.274139021, 0.280471988}, // 11376K
			{0.274134995, 0.28046705}, // 11377K
			{0.27413097, 0.280462113}, // 11378K
			{0.274126945, 0.280457177}, // 11379K
			{0.274122922, 0.280452242}, // 11380K
			{0.274118899, 0.280447308}, // 11381K
			{0.274114877, 0.280442375}, // 11382K
			{0.274110856, 0.280437443}, // 11383K
			{0.274106836, 0.280432511}, // 11384K
			{0.274102817, 0.280427581}, // 11385K
			{0.274098799, 0.280422652}, // 11386K
			{0.274094781, 0.280417723}, // 11387K
			{0.274090764, 0.280412796}, // 11388K
			{0.274086749, 0.280407869}, // 11389K
			{0.274082734, 0.280402944}, // 11390K
			{0.27407872, 0.280398019}, // 11391K
			{0.274074707, 0.280393096}, // 11392K
			{0.274070694, 0.280388173}, // 11393K
			{0.274066683, 0.280383251}, // 11394K
			{0.274062672, 0.280378331}, // 11395K
			{0.274058663, 0.280373411}, // 11396K
			{0.274054654, 0.280368492}, // 11397K
			{0.274050646, 0.280363574}, // 11398K
			{0.274046639, 0.280358657}, // 11399K
			{0.274042632, 0.280353741}, // 11400K
			{0.274038627, 0.280348826}, // 11401K
			{0.274034622, 0.280343912}, // 11402K
			{0.274030619, 0.280338998}, // 11403K
			{0.274026616, 0.280334086}, // 11404K
			{0.274022614, 0.280329175}, // 11405K
			{0.274018613, 0.280324264}, // 11406K
			{0.274014613, 0.280319355}, // 11407K
			{0.274010613, 0.280314446}, // 11408K
			{0.274006615, 0.280309539}, // 11409K
			{0.274002617, 0.280304632}, // 11410K
			{0.273998621, 0.280299726}, // 11411K
			{0.273994625, 0.280294822}, // 11412K
			{0.27399063, 0.280289918}, // 11413K
			{0.273986635, 0.280285015}, // 11414K
			{0.273982642, 0.280280113}, // 11415K
			{0.27397865, 0.280275212}, // 11416K
			{0.273974658, 0.280270312}, // 11417K
			{0.273970667, 0.280265413}, // 11418K
			{0.273966677, 0.280260515}, // 11419K
			{0.273962688, 0.280255618}, // 11420K
			{0.2739587, 0.280250721}, // 11421K
			{0.273954713, 0.280245826}, // 11422K
			{0.273950727, 0.280240932}, // 11423K
			{0.273946741, 0.280236038}, // 11424K
			{0.273942756, 0.280231146}, // 11425K
			{0.273938772, 0.280226254}, // 11426K
			{0.273934789, 0.280221364}, // 11427K
			{0.273930807, 0.280216474}, // 11428K
			{0.273926826, 0.280211585}, // 11429K
			{0.273922845, 0.280206697}, // 11430K
			{0.273918866, 0.280201811}, // 11431K
			{0.273914887, 0.280196925}, // 11432K
			{0.273910909, 0.28019204}, // 11433K
			{0.273906932, 0.280187155}, // 11434K
			{0.273902956, 0.280182272}, // 11435K
			{0.273898981, 0.28017739}, // 11436K
			{0.273895006, 0.280172509}, // 11437K
			{0.273891033, 0.280167629}, // 11438K
			{0.27388706, 0.280162749}, // 11439K
			{0.273883088, 0.280157871}, // 11440K
			{0.273879117, 0.280152993}, // 11441K
			{0.273875147, 0.280148117}, // 11442K
			{0.273871177, 0.280143241}, // 11443K
			{0.273867209, 0.280138366}, // 11444K
			{0.273863241, 0.280133493}, // 11445K
			{0.273859274, 0.28012862}, // 11446K
			{0.273855309, 0.280123748}, // 11447K
			{0.273851343, 0.280118877}, // 11448K
			{0.273847379, 0.280114007}, // 11449K
			{0.273843416, 0.280109138}, // 11450K
			{0.273839453, 0.280104269}, // 11451K
			{0.273835492, 0.280099402}, // 11452K
			{0.273831531, 0.280094536}, // 11453K
			{0.273827571, 0.280089671}, // 11454K
			{0.273823612, 0.280084806}, // 11455K
			{0.273819653, 0.280079943}, // 11456K
			{0.273815696, 0.28007508}, // 11457K
			{0.273811739, 0.280070218}, // 11458K
			{0.273807784, 0.280065358}, // 11459K
			{0.273803829, 0.280060498}, // 11460K
			{0.273799875, 0.280055639}, // 11461K
			{0.273795922, 0.280050781}, // 11462K
			{0.273791969, 0.280045924}, // 11463K
			{0.273788018, 0.280041068}, // 11464K
			{0.273784067, 0.280036213}, // 11465K
			{0.273780117, 0.280031359}, // 11466K
			{0.273776168, 0.280026505}, // 11467K
			{0.27377222, 0.280021653}, // 11468K
			{0.273768273, 0.280016802}, // 11469K
			{0.273764327, 0.280011951}, // 11470K
			{0.273760381, 0.280007101}, // 11471K
			{0.273756436, 0.280002253}, // 11472K
			{0.273752492, 0.279997405}, // 11473K
			{0.273748549, 0.279992558}, // 11474K
			{0.273744607, 0.279987712}, // 11475K
			{0.273740666, 0.279982867}, // 11476K
			{0.273736725, 0.279978023}, // 11477K
			{0.273732786, 0.27997318}, // 11478K
			{0.273728847, 0.279968338}, // 11479K
			{0.273724909, 0.279963497}, // 11480K
			{0.273720972, 0.279958657}, // 11481K
			{0.273717035, 0.279953817}, // 11482K
			{0.2737131, 0.279948979}, // 11483K
			{0.273709165, 0.279944141}, // 11484K
			{0.273705232, 0.279939305}, // 11485K
			{0.273701299, 0.279934469}, // 11486K
			{0.273697367, 0.279929634}, // 11487K
			{0.273693435, 0.2799248}, // 11488K
			{0.273689505, 0.279919967}, // 11489K
			{0.273685576, 0.279915135}, // 11490K
			{0.273681647, 0.279910304}, // 11491K
			{0.273677719, 0.279905474}, // 11492K
			{0.273673792, 0.279900645}, // 11493K
			{0.273669866, 0.279895817}, // 11494K
			{0.27366594, 0.279890989}, // 11495K
			{0.273662016, 0.279886163}, // 11496K
			{0.273658092, 0.279881337}, // 11497K
			{0.273654169, 0.279876513}, // 11498K
			{0.273650247, 0.279871689}, // 11499K
			{0.273646326, 0.279866866}, // 11500K
			{0.273642406, 0.279862044}, // 11501K
			{0.273638486, 0.279857223}, // 11502K
			{0.273634568, 0.279852403}, // 11503K
			{0.27363065, 0.279847584}, // 11504K
			{0.273626733, 0.279842766}, // 11505K
			{0.273622817, 0.279837949}, // 11506K
			{0.273618902, 0.279833133}, // 11507K
			{0.273614987, 0.279828317}, // 11508K
			{0.273611073, 0.279823503}, // 11509K
			{0.273607161, 0.279818689}, // 11510K
			{0.273603249, 0.279813876}, // 11511K
			{0.273599338, 0.279809065}, // 11512K
			{0.273595427, 0.279804254}, // 11513K
			{0.273591518, 0.279799444}, // 11514K
			{0.273587609, 0.279794635}, // 11515K
			{0.273583701, 0.279789827}, // 11516K
			{0.273579795, 0.27978502}, // 11517K
			{0.273575888, 0.279780213}, // 11518K
			{0.273571983, 0.279775408}, // 11519K
			{0.273568079, 0.279770604}, // 11520K
			{0.273564175, 0.2797658}, // 11521K
			{0.273560272, 0.279760998}, // 11522K
			{0.27355637, 0.279756196}, // 11523K
			{0.273552469, 0.279751395}, // 11524K
			{0.273548569, 0.279746595}, // 11525K
			{0.27354467, 0.279741796}, // 11526K
			{0.273540771, 0.279736998}, // 11527K
			{0.273536873, 0.279732201}, // 11528K
			{0.273532976, 0.279727405}, // 11529K
			{0.27352908, 0.27972261}, // 11530K
			{0.273525185, 0.279717815}, // 11531K
			{0.27352129, 0.279713022}, // 11532K
			{0.273517397, 0.27970823}, // 11533K
			{0.273513504, 0.279703438}, // 11534K
			{0.273509612, 0.279698647}, // 11535K
			{0.273505721, 0.279693857}, // 11536K
			{0.27350183, 0.279689069}, // 11537K
			{0.273497941, 0.279684281}, // 11538K
			{0.273494052, 0.279679494}, // 11539K
			{0.273490164, 0.279674707}, // 11540K
			{0.273486277, 0.279669922}, // 11541K
			{0.273482391, 0.279665138}, // 11542K
			{0.273478506, 0.279660354}, // 11543K
			{0.273474621, 0.279655572}, // 11544K
			{0.273470738, 0.27965079}, // 11545K
			{0.273466855, 0.27964601}, // 11546K
			{0.273462973, 0.27964123}, // 11547K
			{0.273459092, 0.279636451}, // 11548K
			{0.273455211, 0.279631673}, // 11549K
			{0.273451332, 0.279626896}, // 11550K
			{0.273447453, 0.27962212}, // 11551K
			{0.273443575, 0.279617345}, // 11552K
			{0.273439698, 0.27961257}, // 11553K
			{0.273435822, 0.279607797}, // 11554K
			{0.273431946, 0.279603024}, // 11555K
			{0.273428071, 0.279598253}, // 11556K
			{0.273424198, 0.279593482}, // 11557K
			{0.273420325, 0.279588712}, // 11558K
			{0.273416453, 0.279583943}, // 11559K
			{0.273412581, 0.279579175}, // 11560K
			{0.273408711, 0.279574408}, // 11561K
			{0.273404841, 0.279569642}, // 11562K
			{0.273400972, 0.279564877}, // 11563K
			{0.273397104, 0.279560113}, // 11564K
			{0.273393237, 0.279555349}, // 11565K
			{0.273389371, 0.279550587}, // 11566K
			{0.273385505, 0.279545825}, // 11567K
			{0.27338164, 0.279541064}, // 11568K
			{0.273377776, 0.279536304}, // 11569K
			{0.273373913, 0.279531545}, // 11570K
			{0.273370051, 0.279526787}, // 11571K
			{0.27336619, 0.27952203}, // 11572K
			{0.273362329, 0.279517274}, // 11573K
			{0.273358469, 0.279512519}, // 11574K
			{0.27335461, 0.279507764}, // 11575K
			{0.273350752, 0.279503011}, // 11576K
			{0.273346895, 0.279498258}, // 11577K
			{0.273343038, 0.279493506}, // 11578K
			{0.273339182, 0.279488756}, // 11579K
			{0.273335327, 0.279484006}, // 11580K
			{0.273331473, 0.279479257}, // 11581K
			{0.27332762, 0.279474509}, // 11582K
			{0.273323768, 0.279469761}, // 11583K
			{0.273319916, 0.279465015}, // 11584K
			{0.273316065, 0.27946027}, // 11585K
			{0.273312215, 0.279455525}, // 11586K
			{0.273308366, 0.279450782}, // 11587K
			{0.273304518, 0.279446039}, // 11588K
			{0.27330067, 0.279441297}, // 11589K
			{0.273296823, 0.279436556}, // 11590K
			{0.273292977, 0.279431816}, // 11591K
			{0.273289132, 0.279427077}, // 11592K
			{0.273285288, 0.279422339}, // 11593K
			{0.273281444, 0.279417602}, // 11594K
			{0.273277602, 0.279412865}, // 11595K
			{0.27327376, 0.27940813}, // 11596K
			{0.273269919, 0.279403395}, // 11597K
			{0.273266079, 0.279398661}, // 11598K
			{0.273262239, 0.279393929}, // 11599K
			{0.273258401, 0.279389197}, // 11600K
			{0.273254563, 0.279384466}, // 11601K
			{0.273250726, 0.279379736}, // 11602K
			{0.27324689, 0.279375006}, // 11603K
			{0.273243054, 0.279370278}, // 11604K
			{0.27323922, 0.279365551}, // 11605K
			{0.273235386, 0.279360824}, // 11606K
			{0.273231553, 0.279356098}, // 11607K
			{0.273227721, 0.279351374}, // 11608K
			{0.27322389, 0.27934665}, // 11609K
			{0.273220059, 0.279341927}, // 11610K
			{0.27321623, 0.279337205}, // 11611K
			{0.273212401, 0.279332484}, // 11612K
			{0.273208573, 0.279327763}, // 11613K
			{0.273204746, 0.279323044}, // 11614K
			{0.273200919, 0.279318325}, // 11615K
			{0.273197094, 0.279313608}, // 11616K
			{0.273193269, 0.279308891}, // 11617K
			{0.273189445, 0.279304175}, // 11618K
			{0.273185622, 0.27929946}, // 11619K
			{0.273181799, 0.279294746}, // 11620K
			{0.273177978, 0.279290033}, // 11621K
			{0.273174157, 0.279285321}, // 11622K
			{0.273170337, 0.27928061}, // 11623K
			{0.273166518, 0.279275899}, // 11624K
			{0.273162699, 0.279271189}, // 11625K
			{0.273158882, 0.279266481}, // 11626K
			{0.273155065, 0.279261773}, // 11627K
			{0.273151249, 0.279257066}, // 11628K
			{0.273147434, 0.27925236}, // 11629K
			{0.27314362, 0.279247655}, // 11630K
			{0.273139806, 0.279242951}, // 11631K
			{0.273135994, 0.279238247}, // 11632K
			{0.273132182, 0.279233545}, // 11633K
			{0.273128371, 0.279228843}, // 11634K
			{0.27312456, 0.279224143}, // 11635K
			{0.273120751, 0.279219443}, // 11636K
			{0.273116942, 0.279214744}, // 11637K
			{0.273113134, 0.279210046}, // 11638K
			{0.273109327, 0.279205349}, // 11639K
			{0.273105521, 0.279200653}, // 11640K
			{0.273101716, 0.279195957}, // 11641K
			{0.273097911, 0.279191263}, // 11642K
			{0.273094107, 0.279186569}, // 11643K
			{0.273090304, 0.279181876}, // 11644K
			{0.273086502, 0.279177185}, // 11645K
			{0.273082701, 0.279172494}, // 11646K
			{0.2730789, 0.279167804}, // 11647K
			{0.2730751, 0.279163115}, // 11648K
			{0.273071301, 0.279158426}, // 11649K
			{0.273067503, 0.279153739}, // 11650K
			{0.273063705, 0.279149052}, // 11651K
			{0.273059909, 0.279144367}, // 11652K
			{0.273056113, 0.279139682}, // 11653K
			{0.273052318, 0.279134998}, // 11654K
			{0.273048524, 0.279130315}, // 11655K
			{0.27304473, 0.279125633}, // 11656K
			{0.273040938, 0.279120952}, // 11657K
			{0.273037146, 0.279116272}, // 11658K
			{0.273033355, 0.279111592}, // 11659K
			{0.273029565, 0.279106914}, // 11660K
			{0.273025775, 0.279102236}, // 11661K
			{0.273021986, 0.279097559}, // 11662K
			{0.273018199, 0.279092883}, // 11663K
			{0.273014412, 0.279088208}, // 11664K
			{0.273010625, 0.279083534}, // 11665K
			{0.27300684, 0.279078861}, // 11666K
			{0.273003055, 0.279074189}, // 11667K
			{0.272999271, 0.279069517}, // 11668K
			{0.272995488, 0.279064847}, // 11669K
			{0.272991706, 0.279060177}, // 11670K
			{0.272987925, 0.279055508}, // 11671K
			{0.272984144, 0.27905084}, // 11672K
			{0.272980364, 0.279046173}, // 11673K
			{0.272976585, 0.279041507}, // 11674K
			{0.272972807, 0.279036841}, // 11675K
			{0.272969029, 0.279032177}, // 11676K
			{0.272965253, 0.279027513}, // 11677K
			{0.272961477, 0.279022851}, // 11678K
			{0.272957702, 0.279018189}, // 11679K
			{0.272953927, 0.279013528}, // 11680K
			{0.272950154, 0.279008868}, // 11681K
			{0.272946381, 0.279004209}, // 11682K
			{0.272942609, 0.27899955}, // 11683K
			{0.272938838, 0.278994893}, // 11684K
			{0.272935068, 0.278990237}, // 11685K
			{0.272931298, 0.278985581}, // 11686K
			{0.27292753, 0.278980926}, // 11687K
			{0.272923762, 0.278976272}, // 11688K
			{0.272919994, 0.278971619}, // 11689K
			{0.272916228, 0.278966967}, // 11690K
			{0.272912462, 0.278962316}, // 11691K
			{0.272908698, 0.278957665}, // 11692K
			{0.272904934, 0.278953016}, // 11693K
			{0.27290117, 0.278948367}, // 11694K
			{0.272897408, 0.278943719}, // 11695K
			{0.272893646, 0.278939072}, // 11696K
			{0.272889886, 0.278934426}, // 11697K
			{0.272886126, 0.278929781}, // 11698K
			{0.272882366, 0.278925137}, // 11699K
			{0.272878608, 0.278920493}, // 11700K
			{0.27287485, 0.278915851}, // 11701K
			{0.272871093, 0.278911209}, // 11702K
			{0.272867337, 0.278906568}, // 11703K
			{0.272863582, 0.278901929}, // 11704K
			{0.272859827, 0.278897289}, // 11705K
			{0.272856074, 0.278892651}, // 11706K
			{0.272852321, 0.278888014}, // 11707K
			{0.272848569, 0.278883378}, // 11708K
			{0.272844817, 0.278878742}, // 11709K
			{0.272841067, 0.278874107}, // 11710K
			{0.272837317, 0.278869474}, // 11711K
			{0.272833568, 0.278864841}, // 11712K
			{0.27282982, 0.278860208}, // 11713K
			{0.272826072, 0.278855577}, // 11714K
			{0.272822326, 0.278850947}, // 11715K
			{0.27281858, 0.278846317}, // 11716K
			{0.272814835, 0.278841689}, // 11717K
			{0.27281109, 0.278837061}, // 11718K
			{0.272807347, 0.278832434}, // 11719K
			{0.272803604, 0.278827808}, // 11720K
			{0.272799862, 0.278823183}, // 11721K
			{0.272796121, 0.278818559}, // 11722K
			{0.272792381, 0.278813936}, // 11723K
			{0.272788641, 0.278809313}, // 11724K
			{0.272784902, 0.278804691}, // 11725K
			{0.272781164, 0.278800071}, // 11726K
			{0.272777427, 0.278795451}, // 11727K
			{0.272773691, 0.278790832}, // 11728K
			{0.272769955, 0.278786213}, // 11729K
			{0.27276622, 0.278781596}, // 11730K
			{0.272762486, 0.27877698}, // 11731K
			{0.272758753, 0.278772364}, // 11732K
			{0.27275502, 0.278767749}, // 11733K
			{0.272751288, 0.278763136}, // 11734K
			{0.272747557, 0.278758523}, // 11735K
			{0.272743827, 0.278753911}, // 11736K
			{0.272740098, 0.278749299}, // 11737K
			{0.272736369, 0.278744689}, // 11738K
			{0.272732641, 0.278740079}, // 11739K
			{0.272728914, 0.278735471}, // 11740K
			{0.272725188, 0.278730863}, // 11741K
			{0.272721462, 0.278726256}, // 11742K
			{0.272717738, 0.27872165}, // 11743K
			{0.272714014, 0.278717045}, // 11744K
			{0.27271029, 0.27871244}, // 11745K
			{0.272706568, 0.278707837}, // 11746K
			{0.272702846, 0.278703234}, // 11747K
			{0.272699126, 0.278698633}, // 11748K
			{0.272695406, 0.278694032}, // 11749K
			{0.272691686, 0.278689432}, // 11750K
			{0.272687968, 0.278684833}, // 11751K
			{0.27268425, 0.278680234}, // 11752K
			{0.272680533, 0.278675637}, // 11753K
			{0.272676817, 0.27867104}, // 11754K
			{0.272673102, 0.278666445}, // 11755K
			{0.272669387, 0.27866185}, // 11756K
			{0.272665673, 0.278657256}, // 11757K
			{0.27266196, 0.278652663}, // 11758K
			{0.272658248, 0.27864807}, // 11759K
			{0.272654536, 0.278643479}, // 11760K
			{0.272650825, 0.278638888}, // 11761K
			{0.272647116, 0.278634299}, // 11762K
			{0.272643406, 0.27862971}, // 11763K
			{0.272639698, 0.278625122}, // 11764K
			{0.27263599, 0.278620535}, // 11765K
			{0.272632283, 0.278615948}, // 11766K
			{0.272628577, 0.278611363}, // 11767K
			{0.272624872, 0.278606779}, // 11768K
			{0.272621167, 0.278602195}, // 11769K
			{0.272617464, 0.278597612}, // 11770K
			{0.272613761, 0.27859303}, // 11771K
			{0.272610058, 0.278588449}, // 11772K
			{0.272606357, 0.278583869}, // 11773K
			{0.272602656, 0.278579289}, // 11774K
			{0.272598956, 0.278574711}, // 11775K
			{0.272595257, 0.278570133}, // 11776K
			{0.272591559, 0.278565556}, // 11777K
			{0.272587861, 0.27856098}, // 11778K
			{0.272584165, 0.278556405}, // 11779K
			{0.272580469, 0.278551831}, // 11780K
			{0.272576773, 0.278547258}, // 11781K
			{0.272573079, 0.278542685}, // 11782K
			{0.272569385, 0.278538113}, // 11783K
			{0.272565692, 0.278533543}, // 11784K
			{0.272562, 0.278528973}, // 11785K
			{0.272558308, 0.278524403}, // 11786K
			{0.272554618, 0.278519835}, // 11787K
			{0.272550928, 0.278515268}, // 11788K
			{0.272547239, 0.278510701}, // 11789K
			{0.27254355, 0.278506136}, // 11790K
			{0.272539863, 0.278501571}, // 11791K
			{0.272536176, 0.278497007}, // 11792K
			{0.27253249, 0.278492444}, // 11793K
			{0.272528805, 0.278487881}, // 11794K
			{0.27252512, 0.27848332}, // 11795K
			{0.272521436, 0.278478759}, // 11796K
			{0.272517753, 0.278474199}, // 11797K
			{0.272514071, 0.278469641}, // 11798K
			{0.27251039, 0.278465083}, // 11799K
			{0.272506709, 0.278460525}, // 11800K
			{0.272503029, 0.278455969}, // 11801K
			{0.27249935, 0.278451414}, // 11802K
			{0.272495672, 0.278446859}, // 11803K
			{0.272491994, 0.278442305}, // 11804K
			{0.272488317, 0.278437752}, // 11805K
			{0.272484641, 0.2784332}, // 11806K
			{0.272480966, 0.278428649}, // 11807K
			{0.272477291, 0.278424099}, // 11808K
			{0.272473618, 0.278419549}, // 11809K
			{0.272469944, 0.278415}, // 11810K
			{0.272466272, 0.278410452}, // 11811K
			{0.272462601, 0.278405905}, // 11812K
			{0.27245893, 0.278401359}, // 11813K
			{0.27245526, 0.278396814}, // 11814K
			{0.272451591, 0.27839227}, // 11815K
			{0.272447922, 0.278387726}, // 11816K
			{0.272444255, 0.278383183}, // 11817K
			{0.272440588, 0.278378641}, // 11818K
			{0.272436922, 0.2783741}, // 11819K
			{0.272433256, 0.27836956}, // 11820K
			{0.272429592, 0.278365021}, // 11821K
			{0.272425928, 0.278360482}, // 11822K
			{0.272422265, 0.278355945}, // 11823K
			{0.272418602, 0.278351408}, // 11824K
			{0.272414941, 0.278346872}, // 11825K
			{0.27241128, 0.278342337}, // 11826K
			{0.27240762, 0.278337802}, // 11827K
			{0.272403961, 0.278333269}, // 11828K
			{0.272400302, 0.278328736}, // 11829K
			{0.272396644, 0.278324205}, // 11830K
			{0.272392987, 0.278319674}, // 11831K
			{0.272389331, 0.278315144}, // 11832K
			{0.272385675, 0.278310614}, // 11833K
			{0.272382021, 0.278306086}, // 11834K
			{0.272378367, 0.278301559}, // 11835K
			{0.272374714, 0.278297032}, // 11836K
			{0.272371061, 0.278292506}, // 11837K
			{0.272367409, 0.278287981}, // 11838K
			{0.272363758, 0.278283457}, // 11839K
			{0.272360108, 0.278278934}, // 11840K
			{0.272356459, 0.278274411}, // 11841K
			{0.27235281, 0.278269889}, // 11842K
			{0.272349162, 0.278265369}, // 11843K
			{0.272345515, 0.278260849}, // 11844K
			{0.272341869, 0.27825633}, // 11845K
			{0.272338223, 0.278251811}, // 11846K
			{0.272334578, 0.278247294}, // 11847K
			{0.272330934, 0.278242777}, // 11848K
			{0.27232729, 0.278238262}, // 11849K
			{0.272323648, 0.278233747}, // 11850K
			{0.272320006, 0.278229233}, // 11851K
			{0.272316365, 0.278224719}, // 11852K
			{0.272312724, 0.278220207}, // 11853K
			{0.272309085, 0.278215696}, // 11854K
			{0.272305446, 0.278211185}, // 11855K
			{0.272301808, 0.278206675}, // 11856K
			{0.272298171, 0.278202166}, // 11857K
			{0.272294534, 0.278197658}, // 11858K
			{0.272290898, 0.27819315}, // 11859K
			{0.272287263, 0.278188644}, // 11860K
			{0.272283629, 0.278184138}, // 11861K
			{0.272279995, 0.278179633}, // 11862K
			{0.272276362, 0.278175129}, // 11863K
			{0.27227273, 0.278170626}, // 11864K
			{0.272269099, 0.278166124}, // 11865K
			{0.272265468, 0.278161622}, // 11866K
			{0.272261838, 0.278157122}, // 11867K
			{0.272258209, 0.278152622}, // 11868K
			{0.272254581, 0.278148123}, // 11869K
			{0.272250954, 0.278143625}, // 11870K
			{0.272247327, 0.278139128}, // 11871K
			{0.272243701, 0.278134631}, // 11872K
			{0.272240075, 0.278130136}, // 11873K
			{0.272236451, 0.278125641}, // 11874K
			{0.272232827, 0.278121147}, // 11875K
			{0.272229204, 0.278116654}, // 11876K
			{0.272225582, 0.278112161}, // 11877K
			{0.27222196, 0.27810767}, // 11878K
			{0.272218339, 0.278103179}, // 11879K
			{0.272214719, 0.278098689}, // 11880K
			{0.2722111, 0.278094201}, // 11881K
			{0.272207481, 0.278089712}, // 11882K
			{0.272203863, 0.278085225}, // 11883K
			{0.272200246, 0.278080739}, // 11884K
			{0.27219663, 0.278076253}, // 11885K
			{0.272193014, 0.278071768}, // 11886K
			{0.2721894, 0.278067284}, // 11887K
			{0.272185785, 0.278062801}, // 11888K
			{0.272182172, 0.278058319}, // 11889K
			{0.272178559, 0.278053837}, // 11890K
			{0.272174948, 0.278049357}, // 11891K
			{0.272171337, 0.278044877}, // 11892K
			{0.272167726, 0.278040398}, // 11893K
			{0.272164117, 0.27803592}, // 11894K
			{0.272160508, 0.278031443}, // 11895K
			{0.2721569, 0.278026966}, // 11896K
			{0.272153292, 0.27802249}, // 11897K
			{0.272149686, 0.278018016}, // 11898K
			{0.27214608, 0.278013542}, // 11899K
			{0.272142475, 0.278009069}, // 11900K
			{0.27213887, 0.278004596}, // 11901K
			{0.272135267, 0.278000125}, // 11902K
			{0.272131664, 0.277995654}, // 11903K
			{0.272128061, 0.277991184}, // 11904K
			{0.27212446, 0.277986715}, // 11905K
			{0.272120859, 0.277982247}, // 11906K
			{0.272117259, 0.27797778}, // 11907K
			{0.27211366, 0.277973313}, // 11908K
			{0.272110062, 0.277968847}, // 11909K
			{0.272106464, 0.277964383}, // 11910K
			{0.272102867, 0.277959919}, // 11911K
			{0.272099271, 0.277955455}, // 11912K
			{0.272095675, 0.277950993}, // 11913K
			{0.272092081, 0.277946531}, // 11914K
			{0.272088487, 0.277942071}, // 11915K
			{0.272084893, 0.277937611}, // 11916K
			{0.272081301, 0.277933152}, // 11917K
			{0.272077709, 0.277928693}, // 11918K
			{0.272074118, 0.277924236}, // 11919K
			{0.272070528, 0.277919779}, // 11920K
			{0.272066938, 0.277915324}, // 11921K
			{0.272063349, 0.277910869}, // 11922K
			{0.272059761, 0.277906414}, // 11923K
			{0.272056174, 0.277901961}, // 11924K
			{0.272052587, 0.277897509}, // 11925K
			{0.272049001, 0.277893057}, // 11926K
			{0.272045416, 0.277888606}, // 11927K
			{0.272041832, 0.277884156}, // 11928K
			{0.272038248, 0.277879707}, // 11929K
			{0.272034665, 0.277875259}, // 11930K
			{0.272031083, 0.277870811}, // 11931K
			{0.272027502, 0.277866364}, // 11932K
			{0.272023921, 0.277861918}, // 11933K
			{0.272020341, 0.277857473}, // 11934K
			{0.272016762, 0.277853029}, // 11935K
			{0.272013183, 0.277848586}, // 11936K
			{0.272009606, 0.277844143}, // 11937K
			{0.272006029, 0.277839701}, // 11938K
			{0.272002452, 0.27783526}, // 11939K
			{0.271998877, 0.27783082}, // 11940K
			{0.271995302, 0.277826381}, // 11941K
			{0.271991728, 0.277821942}, // 11942K
			{0.271988155, 0.277817505}, // 11943K
			{0.271984582, 0.277813068}, // 11944K
			{0.27198101, 0.277808632}, // 11945K
			{0.271977439, 0.277804196}, // 11946K
			{0.271973869, 0.277799762}, // 11947K
			{0.271970299, 0.277795329}, // 11948K
			{0.27196673, 0.277790896}, // 11949K
			{0.271963162, 0.277786464}, // 11950K
			{0.271959594, 0.277782033}, // 11951K
			{0.271956028, 0.277777602}, // 11952K
			{0.271952462, 0.277773173}, // 11953K
			{0.271948896, 0.277768744}, // 11954K
			{0.271945332, 0.277764316}, // 11955K
			{0.271941768, 0.277759889}, // 11956K
			{0.271938205, 0.277755463}, // 11957K
			{0.271934643, 0.277751038}, // 11958K
			{0.271931081, 0.277746613}, // 11959K
			{0.27192752, 0.277742189}, // 11960K
			{0.27192396, 0.277737766}, // 11961K
			{0.271920401, 0.277733344}, // 11962K
			{0.271916842, 0.277728923}, // 11963K
			{0.271913284, 0.277724502}, // 11964K
			{0.271909727, 0.277720083}, // 11965K
			{0.27190617, 0.277715664}, // 11966K
			{0.271902615, 0.277711246}, // 11967K
			{0.27189906, 0.277706829}, // 11968K
			{0.271895505, 0.277702412}, // 11969K
			{0.271891952, 0.277697997}, // 11970K
			{0.271888399, 0.277693582}, // 11971K
			{0.271884847, 0.277689168}, // 11972K
			{0.271881295, 0.277684755}, // 11973K
			{0.271877745, 0.277680342}, // 11974K
			{0.271874195, 0.277675931}, // 11975K
			{0.271870646, 0.27767152}, // 11976K
			{0.271867097, 0.27766711}, // 11977K
			{0.271863549, 0.277662701}, // 11978K
			{0.271860002, 0.277658293}, // 11979K
			{0.271856456, 0.277653885}, // 11980K
			{0.27185291, 0.277649479}, // 11981K
			{0.271849366, 0.277645073}, // 11982K
			{0.271845822, 0.277640668}, // 11983K
			{0.271842278, 0.277636263}, // 11984K
			{0.271838736, 0.27763186}, // 11985K
			{0.271835194, 0.277627457}, // 11986K
			{0.271831652, 0.277623056}, // 11987K
			{0.271828112, 0.277618655}, // 11988K
			{0.271824572, 0.277614255}, // 11989K
			{0.271821033, 0.277609855}, // 11990K
			{0.271817495, 0.277605457}, // 11991K
			{0.271813957, 0.277601059}, // 11992K
			{0.27181042, 0.277596662}, // 11993K
			{0.271806884, 0.277592266}, // 11994K
			{0.271803349, 0.277587871}, // 11995K
			{0.271799814, 0.277583476}, // 11996K
			{0.27179628, 0.277579082}, // 11997K
			{0.271792747, 0.277574689}, // 11998K
			{0.271789215, 0.277570297}, // 11999K
			{0.271785683, 0.277565906}, // 12000K
			{0.271782152, 0.277561516}, // 12001K
			{0.271778621, 0.277557126}, // 12002K
			{0.271775092, 0.277552737}, // 12003K
			{0.271771563, 0.277548349}, // 12004K
			{0.271768035, 0.277543962}, // 12005K
			{0.271764507, 0.277539576}, // 12006K
			{0.27176098, 0.27753519}, // 12007K
			{0.271757454, 0.277530805}, // 12008K
			{0.271753929, 0.277526421}, // 12009K
			{0.271750405, 0.277522038}, // 12010K
			{0.271746881, 0.277517656}, // 12011K
			{0.271743358, 0.277513274}, // 12012K
			{0.271739835, 0.277508893}, // 12013K
			{0.271736314, 0.277504513}, // 12014K
			{0.271732793, 0.277500134}, // 12015K
			{0.271729272, 0.277495756}, // 12016K
			{0.271725753, 0.277491378}, // 12017K
			{0.271722234, 0.277487001}, // 12018K
			{0.271718716, 0.277482626}, // 12019K
			{0.271715199, 0.27747825}, // 12020K
			{0.271711682, 0.277473876}, // 12021K
			{0.271708166, 0.277469503}, // 12022K
			{0.271704651, 0.27746513}, // 12023K
			{0.271701136, 0.277460758}, // 12024K
			{0.271697623, 0.277456387}, // 12025K
			{0.271694109, 0.277452016}, // 12026K
			{0.271690597, 0.277447647}, // 12027K
			{0.271687086, 0.277443278}, // 12028K
			{0.271683575, 0.27743891}, // 12029K
			{0.271680064, 0.277434543}, // 12030K
			{0.271676555, 0.277430177}, // 12031K
			{0.271673046, 0.277425811}, // 12032K
			{0.271669538, 0.277421447}, // 12033K
			{0.271666031, 0.277417083}, // 12034K
			{0.271662524, 0.27741272}, // 12035K
			{0.271659018, 0.277408357}, // 12036K
			{0.271655513, 0.277403996}, // 12037K
			{0.271652009, 0.277399635}, // 12038K
			{0.271648505, 0.277395275}, // 12039K
			{0.271645002, 0.277390916}, // 12040K
			{0.2716415, 0.277386558}, // 12041K
			{0.271637998, 0.277382201}, // 12042K
			{0.271634497, 0.277377844}, // 12043K
			{0.271630997, 0.277373488}, // 12044K
			{0.271627498, 0.277369133}, // 12045K
			{0.271623999, 0.277364779}, // 12046K
			{0.271620501, 0.277360425}, // 12047K
			{0.271617003, 0.277356072}, // 12048K
			{0.271613507, 0.277351721}, // 12049K
			{0.271610011, 0.277347369}, // 12050K
			{0.271606516, 0.277343019}, // 12051K
			{0.271603021, 0.27733867}, // 12052K
			{0.271599527, 0.277334321}, // 12053K
			{0.271596034, 0.277329973}, // 12054K
			{0.271592542, 0.277325626}, // 12055K
			{0.27158905, 0.27732128}, // 12056K
			{0.27158556, 0.277316934}, // 12057K
			{0.271582069, 0.277312589}, // 12058K
			{0.27157858, 0.277308245}, // 12059K
			{0.271575091, 0.277303902}, // 12060K
			{0.271571603, 0.27729956}, // 12061K
			{0.271568116, 0.277295219}, // 12062K
			{0.271564629, 0.277290878}, // 12063K
			{0.271561143, 0.277286538}, // 12064K
			{0.271557658, 0.277282199}, // 12065K
			{0.271554173, 0.27727786}, // 12066K
			{0.27155069, 0.277273523}, // 12067K
			{0.271547206, 0.277269186}, // 12068K
			{0.271543724, 0.27726485}, // 12069K
			{0.271540242, 0.277260515}, // 12070K
			{0.271536761, 0.277256181}, // 12071K
			{0.271533281, 0.277251847}, // 12072K
			{0.271529802, 0.277247514}, // 12073K
			{0.271526323, 0.277243182}, // 12074K
			{0.271522845, 0.277238851}, // 12075K
			{0.271519367, 0.277234521}, // 12076K
			{0.27151589, 0.277230191}, // 12077K
			{0.271512414, 0.277225862}, // 12078K
			{0.271508939, 0.277221534}, // 12079K
			{0.271505464, 0.277217207}, // 12080K
			{0.271501991, 0.27721288}, // 12081K
			{0.271498517, 0.277208555}, // 12082K
			{0.271495045, 0.27720423}, // 12083K
			{0.271491573, 0.277199906}, // 12084K
			{0.271488102, 0.277195583}, // 12085K
			{0.271484632, 0.27719126}, // 12086K
			{0.271481162, 0.277186938}, // 12087K
			{0.271477693, 0.277182617}, // 12088K
			{0.271474225, 0.277178297}, // 12089K
			{0.271470757, 0.277173978}, // 12090K
			{0.27146729, 0.277169659}, // 12091K
			{0.271463824, 0.277165342}, // 12092K
			{0.271460359, 0.277161025}, // 12093K
			{0.271456894, 0.277156709}, // 12094K
			{0.27145343, 0.277152393}, // 12095K
			{0.271449967, 0.277148079}, // 12096K
			{0.271446504, 0.277143765}, // 12097K
			{0.271443042, 0.277139452}, // 12098K
			{0.271439581, 0.27713514}, // 12099K
			{0.27143612, 0.277130828}, // 12100K
			{0.271432661, 0.277126517}, // 12101K
			{0.271429201, 0.277122208}, // 12102K
			{0.271425743, 0.277117899}, // 12103K
			{0.271422285, 0.27711359}, // 12104K
			{0.271418828, 0.277109283}, // 12105K
			{0.271415372, 0.277104976}, // 12106K
			{0.271411916, 0.27710067}, // 12107K
			{0.271408461, 0.277096365}, // 12108K
			{0.271405007, 0.277092061}, // 12109K
			{0.271401554, 0.277087757}, // 12110K
			{0.271398101, 0.277083454}, // 12111K
			{0.271394649, 0.277079152}, // 12112K
			{0.271391197, 0.277074851}, // 12113K
			{0.271387747, 0.277070551}, // 12114K
			{0.271384297, 0.277066251}, // 12115K
			{0.271380847, 0.277061952}, // 12116K
			{0.271377399, 0.277057654}, // 12117K
			{0.271373951, 0.277053357}, // 12118K
			{0.271370504, 0.27704906}, // 12119K
			{0.271367057, 0.277044765}, // 12120K
			{0.271363611, 0.27704047}, // 12121K
			{0.271360166, 0.277036176}, // 12122K
			{0.271356722, 0.277031882}, // 12123K
			{0.271353278, 0.27702759}, // 12124K
			{0.271349835, 0.277023298}, // 12125K
			{0.271346393, 0.277019007}, // 12126K
			{0.271342951, 0.277014717}, // 12127K
			{0.27133951, 0.277010427}, // 12128K
			{0.27133607, 0.277006139}, // 12129K
			{0.27133263, 0.277001851}, // 12130K
			{0.271329192, 0.276997564}, // 12131K
			{0.271325753, 0.276993277}, // 12132K
			{0.271322316, 0.276988992}, // 12133K
			{0.271318879, 0.276984707}, // 12134K
			{0.271315443, 0.276980423}, // 12135K
			{0.271312008, 0.27697614}, // 12136K
			{0.271308573, 0.276971857}, // 12137K
			{0.271305139, 0.276967576}, // 12138K
			{0.271301706, 0.276963295}, // 12139K
			{0.271298273, 0.276959015}, // 12140K
			{0.271294841, 0.276954736}, // 12141K
			{0.27129141, 0.276950457}, // 12142K
			{0.27128798, 0.276946179}, // 12143K
			{0.27128455, 0.276941902}, // 12144K
			{0.271281121, 0.276937626}, // 12145K
			{0.271277692, 0.276933351}, // 12146K
			{0.271274265, 0.276929076}, // 12147K
			{0.271270838, 0.276924802}, // 12148K
			{0.271267411, 0.276920529}, // 12149K
			{0.271263986, 0.276916257}, // 12150K
			{0.271260561, 0.276911985}, // 12151K
			{0.271257136, 0.276907715}, // 12152K
			{0.271253713, 0.276903445}, // 12153K
			{0.27125029, 0.276899176}, // 12154K
			{0.271246868, 0.276894907}, // 12155K
			{0.271243446, 0.27689064}, // 12156K
			{0.271240025, 0.276886373}, // 12157K
			{0.271236605, 0.276882107}, // 12158K
			{0.271233186, 0.276877841}, // 12159K
			{0.271229767, 0.276873577}, // 12160K
			{0.271226349, 0.276869313}, // 12161K
			{0.271222932, 0.27686505}, // 12162K
			{0.271219515, 0.276860788}, // 12163K
			{0.271216099, 0.276856527}, // 12164K
			{0.271212684, 0.276852266}, // 12165K
			{0.271209269, 0.276848006}, // 12166K
			{0.271205855, 0.276843747}, // 12167K
			{0.271202442, 0.276839489}, // 12168K
			{0.27119903, 0.276835231}, // 12169K
			{0.271195618, 0.276830975}, // 12170K
			{0.271192207, 0.276826719}, // 12171K
			{0.271188796, 0.276822463}, // 12172K
			{0.271185386, 0.276818209}, // 12173K
			{0.271181977, 0.276813955}, // 12174K
			{0.271178569, 0.276809702}, // 12175K
			{0.271175161, 0.27680545}, // 12176K
			{0.271171754, 0.276801199}, // 12177K
			{0.271168348, 0.276796948}, // 12178K
			{0.271164942, 0.276792699}, // 12179K
			{0.271161537, 0.27678845}, // 12180K
			{0.271158133, 0.276784201}, // 12181K
			{0.271154729, 0.276779954}, // 12182K
			{0.271151326, 0.276775707}, // 12183K
			{0.271147924, 0.276771461}, // 12184K
			{0.271144523, 0.276767216}, // 12185K
			{0.271141122, 0.276762972}, // 12186K
			{0.271137722, 0.276758728}, // 12187K
			{0.271134322, 0.276754485}, // 12188K
			{0.271130923, 0.276750243}, // 12189K
			{0.271127525, 0.276746002}, // 12190K
			{0.271124128, 0.276741761}, // 12191K
			{0.271120731, 0.276737522}, // 12192K
			{0.271117335, 0.276733283}, // 12193K
			{0.27111394, 0.276729044}, // 12194K
			{0.271110545, 0.276724807}, // 12195K
			{0.271107151, 0.27672057}, // 12196K
			{0.271103758, 0.276716334}, // 12197K
			{0.271100365, 0.276712099}, // 12198K
			{0.271096973, 0.276707865}, // 12199K
			{0.271093582, 0.276703631}, // 12200K
			{0.271090191, 0.276699398}, // 12201K
			{0.271086801, 0.276695166}, // 12202K
			{0.271083412, 0.276690935}, // 12203K
			{0.271080023, 0.276686704}, // 12204K
			{0.271076636, 0.276682475}, // 12205K
			{0.271073248, 0.276678246}, // 12206K
			{0.271069862, 0.276674017}, // 12207K
			{0.271066476, 0.27666979}, // 12208K
			{0.271063091, 0.276665563}, // 12209K
			{0.271059706, 0.276661337}, // 12210K
			{0.271056323, 0.276657112}, // 12211K
			{0.27105294, 0.276652888}, // 12212K
			{0.271049557, 0.276648664}, // 12213K
			{0.271046175, 0.276644441}, // 12214K
			{0.271042794, 0.276640219}, // 12215K
			{0.271039414, 0.276635998}, // 12216K
			{0.271036034, 0.276631777}, // 12217K
			{0.271032655, 0.276627557}, // 12218K
			{0.271029277, 0.276623338}, // 12219K
			{0.271025899, 0.27661912}, // 12220K
			{0.271022522, 0.276614902}, // 12221K
			{0.271019146, 0.276610686}, // 12222K
			{0.27101577, 0.27660647}, // 12223K
			{0.271012395, 0.276602254}, // 12224K
			{0.271009021, 0.27659804}, // 12225K
			{0.271005648, 0.276593826}, // 12226K
			{0.271002275, 0.276589613}, // 12227K
			{0.270998902, 0.276585401}, // 12228K
			{0.270995531, 0.27658119}, // 12229K
			{0.27099216, 0.276576979}, // 12230K
			{0.27098879, 0.276572769}, // 12231K
			{0.27098542, 0.27656856}, // 12232K
			{0.270982051, 0.276564352}, // 12233K
			{0.270978683, 0.276560144}, // 12234K
			{0.270975316, 0.276555937}, // 12235K
			{0.270971949, 0.276551731}, // 12236K
			{0.270968583, 0.276547526}, // 12237K
			{0.270965217, 0.276543321}, // 12238K
			{0.270961852, 0.276539118}, // 12239K
			{0.270958488, 0.276534915}, // 12240K
			{0.270955125, 0.276530712}, // 12241K
			{0.270951762, 0.276526511}, // 12242K
			{0.2709484, 0.27652231}, // 12243K
			{0.270945039, 0.27651811}, // 12244K
			{0.270941678, 0.276513911}, // 12245K
			{0.270938318, 0.276509712}, // 12246K
			{0.270934958, 0.276505515}, // 12247K
			{0.2709316, 0.276501318}, // 12248K
			{0.270928241, 0.276497122}, // 12249K
			{0.270924884, 0.276492926}, // 12250K
			{0.270921527, 0.276488731}, // 12251K
			{0.270918171, 0.276484537}, // 12252K
			{0.270914816, 0.276480344}, // 12253K
			{0.270911461, 0.276476152}, // 12254K
			{0.270908107, 0.27647196}, // 12255K
			{0.270904754, 0.276467769}, // 12256K
			{0.270901401, 0.276463579}, // 12257K
			{0.270898049, 0.27645939}, // 12258K
			{0.270894698, 0.276455201}, // 12259K
			{0.270891347, 0.276451013}, // 12260K
			{0.270887997, 0.276446826}, // 12261K
			{0.270884648, 0.27644264}, // 12262K
			{0.270881299, 0.276438454}, // 12263K
			{0.270877951, 0.27643427}, // 12264K
			{0.270874604, 0.276430086}, // 12265K
			{0.270871257, 0.276425902}, // 12266K
			{0.270867911, 0.27642172}, // 12267K
			{0.270864566, 0.276417538}, // 12268K
			{0.270861221, 0.276413357}, // 12269K
			{0.270857877, 0.276409177}, // 12270K
			{0.270854534, 0.276404997}, // 12271K
			{0.270851191, 0.276400818}, // 12272K
			{0.27084785, 0.27639664}, // 12273K
			{0.270844508, 0.276392463}, // 12274K
			{0.270841168, 0.276388286}, // 12275K
			{0.270837828, 0.276384111}, // 12276K
			{0.270834488, 0.276379936}, // 12277K
			{0.27083115, 0.276375761}, // 12278K
			{0.270827812, 0.276371588}, // 12279K
			{0.270824475, 0.276367415}, // 12280K
			{0.270821138, 0.276363243}, // 12281K
			{0.270817802, 0.276359072}, // 12282K
			{0.270814467, 0.276354901}, // 12283K
			{0.270811132, 0.276350732}, // 12284K
			{0.270807798, 0.276346563}, // 12285K
			{0.270804465, 0.276342394}, // 12286K
			{0.270801132, 0.276338227}, // 12287K
			{0.2707978, 0.27633406}, // 12288K
			{0.270794469, 0.276329894}, // 12289K
			{0.270791138, 0.276325729}, // 12290K
			{0.270787808, 0.276321564}, // 12291K
			{0.270784479, 0.276317401}, // 12292K
			{0.27078115, 0.276313238}, // 12293K
			{0.270777822, 0.276309075}, // 12294K
			{0.270774495, 0.276304914}, // 12295K
			{0.270771169, 0.276300753}, // 12296K
			{0.270767843, 0.276296593}, // 12297K
			{0.270764517, 0.276292434}, // 12298K
			{0.270761193, 0.276288276}, // 12299K
			{0.270757869, 0.276284118}, // 12300K
			{0.270754545, 0.276279961}, // 12301K
			{0.270751223, 0.276275805}, // 12302K
			{0.270747901, 0.276271649}, // 12303K
			{0.270744579, 0.276267494}, // 12304K
			{0.270741259, 0.27626334}, // 12305K
			{0.270737939, 0.276259187}, // 12306K
			{0.270734619, 0.276255035}, // 12307K
			{0.270731301, 0.276250883}, // 12308K
			{0.270727983, 0.276246732}, // 12309K
			{0.270724665, 0.276242582}, // 12310K
			{0.270721349, 0.276238432}, // 12311K
			{0.270718033, 0.276234283}, // 12312K
			{0.270714717, 0.276230135}, // 12313K
			{0.270711403, 0.276225988}, // 12314K
			{0.270708088, 0.276221842}, // 12315K
			{0.270704775, 0.276217696}, // 12316K
			{0.270701462, 0.276213551}, // 12317K
			{0.27069815, 0.276209407}, // 12318K
			{0.270694839, 0.276205263}, // 12319K
			{0.270691528, 0.27620112}, // 12320K
			{0.270688218, 0.276196978}, // 12321K
			{0.270684909, 0.276192837}, // 12322K
			{0.2706816, 0.276188696}, // 12323K
			{0.270678292, 0.276184557}, // 12324K
			{0.270674984, 0.276180418}, // 12325K
			{0.270671678, 0.276176279}, // 12326K
			{0.270668371, 0.276172142}, // 12327K
			{0.270665066, 0.276168005}, // 12328K
			{0.270661761, 0.276163869}, // 12329K
			{0.270658457, 0.276159733}, // 12330K
			{0.270655153, 0.276155599}, // 12331K
			{0.270651851, 0.276151465}, // 12332K
			{0.270648548, 0.276147332}, // 12333K
			{0.270645247, 0.2761432}, // 12334K
			{0.270641946, 0.276139068}, // 12335K
			{0.270638646, 0.276134937}, // 12336K
			{0.270635346, 0.276130807}, // 12337K
			{0.270632047, 0.276126678}, // 12338K
			{0.270628749, 0.276122549}, // 12339K
			{0.270625452, 0.276118421}, // 12340K
			{0.270622155, 0.276114294}, // 12341K
			{0.270618858, 0.276110167}, // 12342K
			{0.270615563, 0.276106042}, // 12343K
			{0.270612268, 0.276101917}, // 12344K
			{0.270608973, 0.276097793}, // 12345K
			{0.27060568, 0.276093669}, // 12346K
			{0.270602387, 0.276089546}, // 12347K
			{0.270599094, 0.276085424}, // 12348K
			{0.270595803, 0.276081303}, // 12349K
			{0.270592512, 0.276077183}, // 12350K
			{0.270589221, 0.276073063}, // 12351K
			{0.270585932, 0.276068944}, // 12352K
			{0.270582642, 0.276064826}, // 12353K
			{0.270579354, 0.276060708}, // 12354K
			{0.270576066, 0.276056591}, // 12355K
			{0.270572779, 0.276052475}, // 12356K
			{0.270569493, 0.27604836}, // 12357K
			{0.270566207, 0.276044245}, // 12358K
			{0.270562922, 0.276040131}, // 12359K
			{0.270559637, 0.276036018}, // 12360K
			{0.270556353, 0.276031906}, // 12361K
			{0.27055307, 0.276027794}, // 12362K
			{0.270549788, 0.276023683}, // 12363K
			{0.270546506, 0.276019573}, // 12364K
			{0.270543224, 0.276015464}, // 12365K
			{0.270539944, 0.276011355}, // 12366K
			{0.270536664, 0.276007247}, // 12367K
			{0.270533385, 0.27600314}, // 12368K
			{0.270530106, 0.275999034}, // 12369K
			{0.270526828, 0.275994928}, // 12370K
			{0.270523551, 0.275990823}, // 12371K
			{0.270520274, 0.275986719}, // 12372K
			{0.270516998, 0.275982615}, // 12373K
			{0.270513723, 0.275978512}, // 12374K
			{0.270510448, 0.27597441}, // 12375K
			{0.270507174, 0.275970309}, // 12376K
			{0.2705039, 0.275966208}, // 12377K
			{0.270500628, 0.275962108}, // 12378K
			{0.270497355, 0.275958009}, // 12379K
			{0.270494084, 0.275953911}, // 12380K
			{0.270490813, 0.275949813}, // 12381K
			{0.270487543, 0.275945716}, // 12382K
			{0.270484273, 0.27594162}, // 12383K
			{0.270481004, 0.275937525}, // 12384K
			{0.270477736, 0.27593343}, // 12385K
			{0.270474469, 0.275929336}, // 12386K
			{0.270471202, 0.275925243}, // 12387K
			{0.270467935, 0.27592115}, // 12388K
			{0.27046467, 0.275917058}, // 12389K
			{0.270461405, 0.275912967}, // 12390K
			{0.27045814, 0.275908877}, // 12391K
			{0.270454876, 0.275904788}, // 12392K
			{0.270451613, 0.275900699}, // 12393K
			{0.270448351, 0.275896611}, // 12394K
			{0.270445089, 0.275892523}, // 12395K
			{0.270441828, 0.275888437}, // 12396K
			{0.270438568, 0.275884351}, // 12397K
			{0.270435308, 0.275880265}, // 12398K
			{0.270432048, 0.275876181}, // 12399K
			{0.27042879, 0.275872097}, // 12400K
			{0.270425532, 0.275868014}, // 12401K
			{0.270422275, 0.275863932}, // 12402K
			{0.270419018, 0.27585985}, // 12403K
			{0.270415762, 0.27585577}, // 12404K
			{0.270412507, 0.27585169}, // 12405K
			{0.270409252, 0.27584761}, // 12406K
			{0.270405998, 0.275843532}, // 12407K
			{0.270402745, 0.275839454}, // 12408K
			{0.270399492, 0.275835377}, // 12409K
			{0.27039624, 0.2758313}, // 12410K
			{0.270392988, 0.275827224}, // 12411K
			{0.270389737, 0.275823149}, // 12412K
			{0.270386487, 0.275819075}, // 12413K
			{0.270383238, 0.275815002}, // 12414K
			{0.270379989, 0.275810929}, // 12415K
			{0.270376741, 0.275806857}, // 12416K
			{0.270373493, 0.275802785}, // 12417K
			{0.270370246, 0.275798715}, // 12418K
			{0.270367, 0.275794645}, // 12419K
			{0.270363754, 0.275790576}, // 12420K
			{0.270360509, 0.275786507}, // 12421K
			{0.270357264, 0.27578244}, // 12422K
			{0.270354021, 0.275778373}, // 12423K
			{0.270350778, 0.275774307}, // 12424K
			{0.270347535, 0.275770241}, // 12425K
			{0.270344293, 0.275766176}, // 12426K
			{0.270341052, 0.275762112}, // 12427K
			{0.270337811, 0.275758049}, // 12428K
			{0.270334572, 0.275753986}, // 12429K
			{0.270331332, 0.275749924}, // 12430K
			{0.270328094, 0.275745863}, // 12431K
			{0.270324856, 0.275741803}, // 12432K
			{0.270321618, 0.275737743}, // 12433K
			{0.270318382, 0.275733684}, // 12434K
			{0.270315145, 0.275729626}, // 12435K
			{0.27031191, 0.275725568}, // 12436K
			{0.270308675, 0.275721511}, // 12437K
			{0.270305441, 0.275717455}, // 12438K
			{0.270302207, 0.2757134}, // 12439K
			{0.270298975, 0.275709345}, // 12440K
			{0.270295742, 0.275705291}, // 12441K
			{0.270292511, 0.275701238}, // 12442K
			{0.27028928, 0.275697186}, // 12443K
			{0.270286049, 0.275693134}, // 12444K
			{0.27028282, 0.275689083}, // 12445K
			{0.270279591, 0.275685033}, // 12446K
			{0.270276362, 0.275680983}, // 12447K
			{0.270273134, 0.275676934}, // 12448K
			{0.270269907, 0.275672886}, // 12449K
			{0.270266681, 0.275668839}, // 12450K
			{0.270263455, 0.275664792}, // 12451K
			{0.270260229, 0.275660746}, // 12452K
			{0.270257005, 0.275656701}, // 12453K
			{0.270253781, 0.275652656}, // 12454K
			{0.270250557, 0.275648612}, // 12455K
			{0.270247335, 0.275644569}, // 12456K
			{0.270244113, 0.275640527}, // 12457K
			{0.270240891, 0.275636485}, // 12458K
			{0.27023767, 0.275632444}, // 12459K
			{0.27023445, 0.275628404}, // 12460K
			{0.270231231, 0.275624365}, // 12461K
			{0.270228012, 0.275620326}, // 12462K
			{0.270224793, 0.275616288}, // 12463K
			{0.270221576, 0.27561225}, // 12464K
			{0.270218359, 0.275608214}, // 12465K
			{0.270215142, 0.275604178}, // 12466K
			{0.270211927, 0.275600143}, // 12467K
			{0.270208712, 0.275596108}, // 12468K
			{0.270205497, 0.275592075}, // 12469K
			{0.270202283, 0.275588042}, // 12470K
			{0.27019907, 0.275584009}, // 12471K
			{0.270195857, 0.275579978}, // 12472K
			{0.270192646, 0.275575947}, // 12473K
			{0.270189434, 0.275571917}, // 12474K
			{0.270186224, 0.275567887}, // 12475K
			{0.270183013, 0.275563859}, // 12476K
			{0.270179804, 0.275559831}, // 12477K
			{0.270176595, 0.275555803}, // 12478K
			{0.270173387, 0.275551777}, // 12479K
			{0.27017018, 0.275547751}, // 12480K
			{0.270166973, 0.275543726}, // 12481K
			{0.270163766, 0.275539701}, // 12482K
			{0.270160561, 0.275535678}, // 12483K
			{0.270157356, 0.275531655}, // 12484K
			{0.270154151, 0.275527632}, // 12485K
			{0.270150948, 0.275523611}, // 12486K
			{0.270147744, 0.27551959}, // 12487K
			{0.270144542, 0.27551557}, // 12488K
			{0.27014134, 0.27551155}, // 12489K
			{0.270138139, 0.275507532}, // 12490K
			{0.270134938, 0.275503514}, // 12491K
			{0.270131738, 0.275499497}, // 12492K
			{0.270128539, 0.27549548}, // 12493K
			{0.27012534, 0.275491464}, // 12494K
			{0.270122142, 0.275487449}, // 12495K
			{0.270118945, 0.275483435}, // 12496K
			{0.270115748, 0.275479421}, // 12497K
			{0.270112552, 0.275475408}, // 12498K
			{0.270109356, 0.275471396}, // 12499K
			{0.270106161, 0.275467384}, // 12500K
			{0.270102967, 0.275463373}, // 12501K
			{0.270099773, 0.275459363}, // 12502K
			{0.27009658, 0.275455354}, // 12503K
			{0.270093388, 0.275451345}, // 12504K
			{0.270090196, 0.275447337}, // 12505K
			{0.270087005, 0.27544333}, // 12506K
			{0.270083814, 0.275439323}, // 12507K
			{0.270080624, 0.275435317}, // 12508K
			{0.270077435, 0.275431312}, // 12509K
			{0.270074246, 0.275427308}, // 12510K
			{0.270071058, 0.275423304}, // 12511K
			{0.270067871, 0.275419301}, // 12512K
			{0.270064684, 0.275415299}, // 12513K
			{0.270061498, 0.275411297}, // 12514K
			{0.270058312, 0.275407296}, // 12515K
			{0.270055127, 0.275403296}, // 12516K
			{0.270051943, 0.275399297}, // 12517K
			{0.270048759, 0.275395298}, // 12518K
			{0.270045576, 0.2753913}, // 12519K
			{0.270042394, 0.275387302}, // 12520K
			{0.270039212, 0.275383306}, // 12521K
			{0.270036031, 0.27537931}, // 12522K
			{0.27003285, 0.275375315}, // 12523K
			{0.27002967, 0.27537132}, // 12524K
			{0.270026491, 0.275367326}, // 12525K
			{0.270023312, 0.275363333}, // 12526K
			{0.270020134, 0.275359341}, // 12527K
			{0.270016957, 0.275355349}, // 12528K
			{0.27001378, 0.275351358}, // 12529K
			{0.270010604, 0.275347368}, // 12530K
			{0.270007428, 0.275343379}, // 12531K
			{0.270004253, 0.27533939}, // 12532K
			{0.270001079, 0.275335402}, // 12533K
			{0.269997905, 0.275331414}, // 12534K
			{0.269994732, 0.275327428}, // 12535K
			{0.269991559, 0.275323442}, // 12536K
			{0.269988387, 0.275319456}, // 12537K
			{0.269985216, 0.275315472}, // 12538K
			{0.269982046, 0.275311488}, // 12539K
			{0.269978876, 0.275307505}, // 12540K
			{0.269975706, 0.275303522}, // 12541K
			{0.269972537, 0.27529954}, // 12542K
			{0.269969369, 0.275295559}, // 12543K
			{0.269966202, 0.275291579}, // 12544K
			{0.269963035, 0.275287599}, // 12545K
			{0.269959869, 0.27528362}, // 12546K
			{0.269956703, 0.275279642}, // 12547K
			{0.269953538, 0.275275664}, // 12548K
			{0.269950373, 0.275271688}, // 12549K
			{0.26994721, 0.275267712}, // 12550K
			{0.269944046, 0.275263736}, // 12551K
			{0.269940884, 0.275259761}, // 12552K
			{0.269937722, 0.275255787}, // 12553K
			{0.269934561, 0.275251814}, // 12554K
			{0.2699314, 0.275247841}, // 12555K
			{0.26992824, 0.27524387}, // 12556K
			{0.26992508, 0.275239898}, // 12557K
			{0.269921921, 0.275235928}, // 12558K
			{0.269918763, 0.275231958}, // 12559K
			{0.269915606, 0.275227989}, // 12560K
			{0.269912449, 0.27522402}, // 12561K
			{0.269909292, 0.275220053}, // 12562K
			{0.269906136, 0.275216086}, // 12563K
			{0.269902981, 0.27521212}, // 12564K
			{0.269899827, 0.275208154}, // 12565K
			{0.269896673, 0.275204189}, // 12566K
			{0.269893519, 0.275200225}, // 12567K
			{0.269890367, 0.275196261}, // 12568K
			{0.269887215, 0.275192299}, // 12569K
			{0.269884063, 0.275188336}, // 12570K
			{0.269880912, 0.275184375}, // 12571K
			{0.269877762, 0.275180414}, // 12572K
			{0.269874613, 0.275176454}, // 12573K
			{0.269871463, 0.275172495}, // 12574K
			{0.269868315, 0.275168537}, // 12575K
			{0.269865167, 0.275164579}, // 12576K
			{0.26986202, 0.275160621}, // 12577K
			{0.269858874, 0.275156665}, // 12578K
			{0.269855728, 0.275152709}, // 12579K
			{0.269852582, 0.275148754}, // 12580K
			{0.269849438, 0.2751448}, // 12581K
			{0.269846294, 0.275140846}, // 12582K
			{0.26984315, 0.275136893}, // 12583K
			{0.269840007, 0.275132941}, // 12584K
			{0.269836865, 0.275128989}, // 12585K
			{0.269833723, 0.275125038}, // 12586K
			{0.269830582, 0.275121088}, // 12587K
			{0.269827442, 0.275117139}, // 12588K
			{0.269824302, 0.27511319}, // 12589K
			{0.269821163, 0.275109242}, // 12590K
			{0.269818024, 0.275105294}, // 12591K
			{0.269814886, 0.275101348}, // 12592K
			{0.269811749, 0.275097402}, // 12593K
			{0.269808612, 0.275093456}, // 12594K
			{0.269805476, 0.275089512}, // 12595K
			{0.26980234, 0.275085568}, // 12596K
			{0.269799206, 0.275081624}, // 12597K
			{0.269796071, 0.275077682}, // 12598K
			{0.269792938, 0.27507374}, // 12599K
			{0.269789804, 0.275069799}, // 12600K
			{0.269786672, 0.275065858}, // 12601K
			{0.26978354, 0.275061919}, // 12602K
			{0.269780409, 0.27505798}, // 12603K
			{0.269777278, 0.275054041}, // 12604K
			{0.269774148, 0.275050104}, // 12605K
			{0.269771019, 0.275046167}, // 12606K
			{0.26976789, 0.27504223}, // 12607K
			{0.269764762, 0.275038295}, // 12608K
			{0.269761634, 0.27503436}, // 12609K
			{0.269758507, 0.275030426}, // 12610K
			{0.269755381, 0.275026492}, // 12611K
			{0.269752255, 0.275022559}, // 12612K
			{0.26974913, 0.275018627}, // 12613K
			{0.269746005, 0.275014696}, // 12614K
			{0.269742881, 0.275010765}, // 12615K
			{0.269739758, 0.275006835}, // 12616K
			{0.269736635, 0.275002906}, // 12617K
			{0.269733513, 0.274998977}, // 12618K
			{0.269730391, 0.274995049}, // 12619K
			{0.269727271, 0.274991122}, // 12620K
			{0.26972415, 0.274987195}, // 12621K
			{0.26972103, 0.274983269}, // 12622K
			{0.269717911, 0.274979344}, // 12623K
			{0.269714793, 0.27497542}, // 12624K
			{0.269711675, 0.274971496}, // 12625K
			{0.269708558, 0.274967573}, // 12626K
			{0.269705441, 0.27496365}, // 12627K
			{0.269702325, 0.274959729}, // 12628K
			{0.269699209, 0.274955807}, // 12629K
			{0.269696095, 0.274951887}, // 12630K
			{0.26969298, 0.274947967}, // 12631K
			{0.269689867, 0.274944048}, // 12632K
			{0.269686754, 0.27494013}, // 12633K
			{0.269683641, 0.274936213}, // 12634K
			{0.269680529, 0.274932296}, // 12635K
			{0.269677418, 0.274928379}, // 12636K
			{0.269674308, 0.274924464}, // 12637K
			{0.269671197, 0.274920549}, // 12638K
			{0.269668088, 0.274916635}, // 12639K
			{0.269664979, 0.274912721}, // 12640K
			{0.269661871, 0.274908809}, // 12641K
			{0.269658763, 0.274904897}, // 12642K
			{0.269655656, 0.274900985}, // 12643K
			{0.26965255, 0.274897074}, // 12644K
			{0.269649444, 0.274893164}, // 12645K
			{0.269646339, 0.274889255}, // 12646K
			{0.269643234, 0.274885346}, // 12647K
			{0.26964013, 0.274881439}, // 12648K
			{0.269637027, 0.274877531}, // 12649K
			{0.269633924, 0.274873625}, // 12650K
			{0.269630822, 0.274869719}, // 12651K
			{0.26962772, 0.274865814}, // 12652K
			{0.269624619, 0.274861909}, // 12653K
			{0.269621519, 0.274858005}, // 12654K
			{0.269618419, 0.274854102}, // 12655K
			{0.26961532, 0.2748502}, // 12656K
			{0.269612221, 0.274846298}, // 12657K
			{0.269609123, 0.274842397}, // 12658K
			{0.269606026, 0.274838496}, // 12659K
			{0.269602929, 0.274834597}, // 12660K
			{0.269599833, 0.274830697}, // 12661K
			{0.269596738, 0.274826799}, // 12662K
			{0.269593643, 0.274822901}, // 12663K
			{0.269590548, 0.274819004}, // 12664K
			{0.269587454, 0.274815108}, // 12665K
			{0.269584361, 0.274811213}, // 12666K
			{0.269581269, 0.274807318}, // 12667K
			{0.269578177, 0.274803423}, // 12668K
			{0.269575085, 0.27479953}, // 12669K
			{0.269571994, 0.274795637}, // 12670K
			{0.269568904, 0.274791745}, // 12671K
			{0.269565815, 0.274787853}, // 12672K
			{0.269562726, 0.274783962}, // 12673K
			{0.269559637, 0.274780072}, // 12674K
			{0.269556549, 0.274776183}, // 12675K
			{0.269553462, 0.274772294}, // 12676K
			{0.269550376, 0.274768406}, // 12677K
			{0.26954729, 0.274764518}, // 12678K
			{0.269544204, 0.274760632}, // 12679K
			{0.269541119, 0.274756746}, // 12680K
			{0.269538035, 0.27475286}, // 12681K
			{0.269534951, 0.274748976}, // 12682K
			{0.269531868, 0.274745092}, // 12683K
			{0.269528786, 0.274741208}, // 12684K
			{0.269525704, 0.274737326}, // 12685K
			{0.269522623, 0.274733444}, // 12686K
			{0.269519542, 0.274729562}, // 12687K
			{0.269516462, 0.274725682}, // 12688K
			{0.269513383, 0.274721802}, // 12689K
			{0.269510304, 0.274717923}, // 12690K
			{0.269507226, 0.274714044}, // 12691K
			{0.269504148, 0.274710166}, // 12692K
			{0.269501071, 0.274706289}, // 12693K
			{0.269497994, 0.274702412}, // 12694K
			{0.269494919, 0.274698537}, // 12695K
			{0.269491843, 0.274694661}, // 12696K
			{0.269488769, 0.274690787}, // 12697K
			{0.269485694, 0.274686913}, // 12698K
			{0.269482621, 0.27468304}, // 12699K
			{0.269479548, 0.274679168}, // 12700K
			{0.269476476, 0.274675296}, // 12701K
			{0.269473404, 0.274671425}, // 12702K
			{0.269470333, 0.274667554}, // 12703K
			{0.269467262, 0.274663684}, // 12704K
			{0.269464192, 0.274659815}, // 12705K
			{0.269461123, 0.274655947}, // 12706K
			{0.269458054, 0.274652079}, // 12707K
			{0.269454986, 0.274648212}, // 12708K
			{0.269451918, 0.274644346}, // 12709K
			{0.269448851, 0.27464048}, // 12710K
			{0.269445785, 0.274636615}, // 12711K
			{0.269442719, 0.274632751}, // 12712K
			{0.269439654, 0.274628887}, // 12713K
			{0.269436589, 0.274625024}, // 12714K
			{0.269433525, 0.274621162}, // 12715K
			{0.269430462, 0.2746173}, // 12716K
			{0.269427399, 0.27461344}, // 12717K
			{0.269424337, 0.274609579}, // 12718K
			{0.269421275, 0.27460572}, // 12719K
			{0.269418214, 0.274601861}, // 12720K
			{0.269415154, 0.274598002}, // 12721K
			{0.269412094, 0.274594145}, // 12722K
			{0.269409034, 0.274590288}, // 12723K
			{0.269405976, 0.274586432}, // 12724K
			{0.269402918, 0.274582576}, // 12725K
			{0.26939986, 0.274578721}, // 12726K
			{0.269396803, 0.274574867}, // 12727K
			{0.269393747, 0.274571014}, // 12728K
			{0.269390691, 0.274567161}, // 12729K
			{0.269387636, 0.274563309}, // 12730K
			{0.269384581, 0.274559457}, // 12731K
			{0.269381527, 0.274555606}, // 12732K
			{0.269378474, 0.274551756}, // 12733K
			{0.269375421, 0.274547907}, // 12734K
			{0.269372369, 0.274544058}, // 12735K
			{0.269369317, 0.27454021}, // 12736K
			{0.269366266, 0.274536362}, // 12737K
			{0.269363215, 0.274532516}, // 12738K
			{0.269360166, 0.274528669}, // 12739K
			{0.269357116, 0.274524824}, // 12740K
			{0.269354068, 0.274520979}, // 12741K
			{0.269351019, 0.274517135}, // 12742K
			{0.269347972, 0.274513292}, // 12743K
			{0.269344925, 0.274509449}, // 12744K
			{0.269341878, 0.274505607}, // 12745K
			{0.269338833, 0.274501765}, // 12746K
			{0.269335788, 0.274497925}, // 12747K
			{0.269332743, 0.274494085}, // 12748K
			{0.269329699, 0.274490245}, // 12749K
			{0.269326655, 0.274486407}, // 12750K
			{0.269323613, 0.274482568}, // 12751K
			{0.26932057, 0.274478731}, // 12752K
			{0.269317529, 0.274474894}, // 12753K
			{0.269314487, 0.274471058}, // 12754K
			{0.269311447, 0.274467223}, // 12755K
			{0.269308407, 0.274463388}, // 12756K
			{0.269305368, 0.274459554}, // 12757K
			{0.269302329, 0.274455721}, // 12758K
			{0.269299291, 0.274451888}, // 12759K
			{0.269296253, 0.274448056}, // 12760K
			{0.269293216, 0.274444225}, // 12761K
			{0.26929018, 0.274440394}, // 12762K
			{0.269287144, 0.274436564}, // 12763K
			{0.269284109, 0.274432735}, // 12764K
			{0.269281074, 0.274428906}, // 12765K
			{0.26927804, 0.274425078}, // 12766K
			{0.269275006, 0.274421251}, // 12767K
			{0.269271973, 0.274417424}, // 12768K
			{0.269268941, 0.274413598}, // 12769K
			{0.269265909, 0.274409772}, // 12770K
			{0.269262878, 0.274405948}, // 12771K
			{0.269259847, 0.274402124}, // 12772K
			{0.269256817, 0.2743983}, // 12773K
			{0.269253788, 0.274394478}, // 12774K
			{0.269250759, 0.274390656}, // 12775K
			{0.269247731, 0.274386834}, // 12776K
			{0.269244703, 0.274383014}, // 12777K
			{0.269241676, 0.274379194}, // 12778K
			{0.26923865, 0.274375374}, // 12779K
			{0.269235624, 0.274371556}, // 12780K
			{0.269232598, 0.274367737}, // 12781K
			{0.269229573, 0.27436392}, // 12782K
			{0.269226549, 0.274360103}, // 12783K
			{0.269223526, 0.274356287}, // 12784K
			{0.269220502, 0.274352472}, // 12785K
			{0.26921748, 0.274348657}, // 12786K
			{0.269214458, 0.274344843}, // 12787K
			{0.269211437, 0.27434103}, // 12788K
			{0.269208416, 0.274337217}, // 12789K
			{0.269205396, 0.274333405}, // 12790K
			{0.269202376, 0.274329594}, // 12791K
			{0.269199357, 0.274325783}, // 12792K
			{0.269196339, 0.274321973}, // 12793K
			{0.269193321, 0.274318164}, // 12794K
			{0.269190304, 0.274314355}, // 12795K
			{0.269187287, 0.274310547}, // 12796K
			{0.269184271, 0.274306739}, // 12797K
			{0.269181256, 0.274302933}, // 12798K
			{0.269178241, 0.274299127}, // 12799K
			{0.269175226, 0.274295321}, // 12800K
			{0.269172212, 0.274291516}, // 12801K
			{0.269169199, 0.274287712}, // 12802K
			{0.269166187, 0.274283909}, // 12803K
			{0.269163174, 0.274280106}, // 12804K
			{0.269160163, 0.274276304}, // 12805K
			{0.269157152, 0.274272502}, // 12806K
			{0.269154142, 0.274268702}, // 12807K
			{0.269151132, 0.274264902}, // 12808K
			{0.269148123, 0.274261102}, // 12809K
			{0.269145114, 0.274257303}, // 12810K
			{0.269142106, 0.274253505}, // 12811K
			{0.269139099, 0.274249708}, // 12812K
			{0.269136092, 0.274245911}, // 12813K
			{0.269133086, 0.274242115}, // 12814K
			{0.26913008, 0.274238319}, // 12815K
			{0.269127075, 0.274234524}, // 12816K
			{0.26912407, 0.27423073}, // 12817K
			{0.269121066, 0.274226937}, // 12818K
			{0.269118063, 0.274223144}, // 12819K
			{0.26911506, 0.274219352}, // 12820K
			{0.269112058, 0.27421556}, // 12821K
			{0.269109056, 0.274211769}, // 12822K
			{0.269106055, 0.274207979}, // 12823K
			{0.269103054, 0.274204189}, // 12824K
			{0.269100054, 0.2742004}, // 12825K
			{0.269097055, 0.274196612}, // 12826K
			{0.269094056, 0.274192825}, // 12827K
			{0.269091058, 0.274189038}, // 12828K
			{0.26908806, 0.274185251}, // 12829K
			{0.269085063, 0.274181466}, // 12830K
			{0.269082066, 0.274177681}, // 12831K
			{0.26907907, 0.274173896}, // 12832K
			{0.269076075, 0.274170113}, // 12833K
			{0.26907308, 0.27416633}, // 12834K
			{0.269070086, 0.274162547}, // 12835K
			{0.269067092, 0.274158766}, // 12836K
			{0.269064099, 0.274154985}, // 12837K
			{0.269061106, 0.274151204}, // 12838K
			{0.269058114, 0.274147425}, // 12839K
			{0.269055123, 0.274143646}, // 12840K
			{0.269052132, 0.274139867}, // 12841K
			{0.269049142, 0.274136089}, // 12842K
			{0.269046152, 0.274132312}, // 12843K
			{0.269043163, 0.274128536}, // 12844K
			{0.269040175, 0.27412476}, // 12845K
			{0.269037187, 0.274120985}, // 12846K
			{0.269034199, 0.27411721}, // 12847K
			{0.269031212, 0.274113437}, // 12848K
			{0.269028226, 0.274109663}, // 12849K
			{0.26902524, 0.274105891}, // 12850K
			{0.269022255, 0.274102119}, // 12851K
			{0.269019271, 0.274098348}, // 12852K
			{0.269016287, 0.274094577}, // 12853K
			{0.269013303, 0.274090807}, // 12854K
			{0.269010321, 0.274087038}, // 12855K
			{0.269007338, 0.27408327}, // 12856K
			{0.269004357, 0.274079502}, // 12857K
			{0.269001375, 0.274075734}, // 12858K
			{0.268998395, 0.274071968}, // 12859K
			{0.268995415, 0.274068202}, // 12860K
			{0.268992435, 0.274064436}, // 12861K
			{0.268989457, 0.274060672}, // 12862K
			{0.268986478, 0.274056908}, // 12863K
			{0.268983501, 0.274053144}, // 12864K
			{0.268980523, 0.274049382}, // 12865K
			{0.268977547, 0.27404562}, // 12866K
			{0.268974571, 0.274041858}, // 12867K
			{0.268971595, 0.274038097}, // 12868K
			{0.26896862, 0.274034337}, // 12869K
			{0.268965646, 0.274030578}, // 12870K
			{0.268962672, 0.274026819}, // 12871K
			{0.268959699, 0.274023061}, // 12872K
			{0.268956726, 0.274019303}, // 12873K
			{0.268953754, 0.274015546}, // 12874K
			{0.268950783, 0.27401179}, // 12875K
			{0.268947812, 0.274008035}, // 12876K
			{0.268944842, 0.27400428}, // 12877K
			{0.268941872, 0.274000526}, // 12878K
			{0.268938903, 0.273996772}, // 12879K
			{0.268935934, 0.273993019}, // 12880K
			{0.268932966, 0.273989267}, // 12881K
			{0.268929998, 0.273985515}, // 12882K
			{0.268927031, 0.273981764}, // 12883K
			{0.268924065, 0.273978014}, // 12884K
			{0.268921099, 0.273974264}, // 12885K
			{0.268918134, 0.273970515}, // 12886K
			{0.268915169, 0.273966766}, // 12887K
			{0.268912205, 0.273963019}, // 12888K
			{0.268909241, 0.273959272}, // 12889K
			{0.268906278, 0.273955525}, // 12890K
			{0.268903316, 0.273951779}, // 12891K
			{0.268900354, 0.273948034}, // 12892K
			{0.268897392, 0.27394429}, // 12893K
			{0.268894432, 0.273940546}, // 12894K
			{0.268891471, 0.273936802}, // 12895K
			{0.268888512, 0.27393306}, // 12896K
			{0.268885553, 0.273929318}, // 12897K
			{0.268882594, 0.273925577}, // 12898K
			{0.268879636, 0.273921836}, // 12899K
			{0.268876679, 0.273918096}, // 12900K
			{0.268873722, 0.273914357}, // 12901K
			{0.268870766, 0.273910618}, // 12902K
			{0.26886781, 0.27390688}, // 12903K
			{0.268864855, 0.273903142}, // 12904K
			{0.2688619, 0.273899406}, // 12905K
			{0.268858946, 0.27389567}, // 12906K
			{0.268855993, 0.273891934}, // 12907K
			{0.26885304, 0.273888199}, // 12908K
			{0.268850088, 0.273884465}, // 12909K
			{0.268847136, 0.273880731}, // 12910K
			{0.268844184, 0.273876999}, // 12911K
			{0.268841234, 0.273873266}, // 12912K
			{0.268838284, 0.273869535}, // 12913K
			{0.268835334, 0.273865804}, // 12914K
			{0.268832385, 0.273862073}, // 12915K
			{0.268829437, 0.273858344}, // 12916K
			{0.268826489, 0.273854615}, // 12917K
			{0.268823542, 0.273850886}, // 12918K
			{0.268820595, 0.273847159}, // 12919K
			{0.268817649, 0.273843431}, // 12920K
			{0.268814703, 0.273839705}, // 12921K
			{0.268811758, 0.273835979}, // 12922K
			{0.268808813, 0.273832254}, // 12923K
			{0.268805869, 0.273828529}, // 12924K
			{0.268802926, 0.273824806}, // 12925K
			{0.268799983, 0.273821082}, // 12926K
			{0.268797041, 0.27381736}, // 12927K
			{0.268794099, 0.273813638}, // 12928K
			{0.268791158, 0.273809916}, // 12929K
			{0.268788217, 0.273806196}, // 12930K
			{0.268785277, 0.273802476}, // 12931K
			{0.268782338, 0.273798756}, // 12932K
			{0.268779399, 0.273795038}, // 12933K
			{0.268776461, 0.273791319}, // 12934K
			{0.268773523, 0.273787602}, // 12935K
			{0.268770585, 0.273783885}, // 12936K
			{0.268767649, 0.273780169}, // 12937K
			{0.268764713, 0.273776453}, // 12938K
			{0.268761777, 0.273772738}, // 12939K
			{0.268758842, 0.273769024}, // 12940K
			{0.268755908, 0.273765311}, // 12941K
			{0.268752974, 0.273761598}, // 12942K
			{0.26875004, 0.273757885}, // 12943K
			{0.268747107, 0.273754173}, // 12944K
			{0.268744175, 0.273750462}, // 12945K
			{0.268741243, 0.273746752}, // 12946K
			{0.268738312, 0.273743042}, // 12947K
			{0.268735382, 0.273739333}, // 12948K
			{0.268732452, 0.273735624}, // 12949K
			{0.268729522, 0.273731917}, // 12950K
			{0.268726593, 0.273728209}, // 12951K
			{0.268723665, 0.273724503}, // 12952K
			{0.268720737, 0.273720797}, // 12953K
			{0.26871781, 0.273717091}, // 12954K
			{0.268714883, 0.273713387}, // 12955K
			{0.268711957, 0.273709683}, // 12956K
			{0.268709031, 0.273705979}, // 12957K
			{0.268706106, 0.273702276}, // 12958K
			{0.268703182, 0.273698574}, // 12959K
			{0.268700258, 0.273694873}, // 12960K
			{0.268697334, 0.273691172}, // 12961K
			{0.268694411, 0.273687472}, // 12962K
			{0.268691489, 0.273683772}, // 12963K
			{0.268688567, 0.273680073}, // 12964K
			{0.268685646, 0.273676375}, // 12965K
			{0.268682726, 0.273672677}, // 12966K
			{0.268679806, 0.27366898}, // 12967K
			{0.268676886, 0.273665284}, // 12968K
			{0.268673967, 0.273661588}, // 12969K
			{0.268671049, 0.273657893}, // 12970K
			{0.268668131, 0.273654198}, // 12971K
			{0.268665213, 0.273650504}, // 12972K
			{0.268662297, 0.273646811}, // 12973K
			{0.26865938, 0.273643119}, // 12974K
			{0.268656465, 0.273639427}, // 12975K
			{0.26865355, 0.273635735}, // 12976K
			{0.268650635, 0.273632045}, // 12977K
			{0.268647721, 0.273628355}, // 12978K
			{0.268644808, 0.273624665}, // 12979K
			{0.268641895, 0.273620976}, // 12980K
			{0.268638982, 0.273617288}, // 12981K
			{0.26863607, 0.273613601}, // 12982K
			{0.268633159, 0.273609914}, // 12983K
			{0.268630248, 0.273606227}, // 12984K
			{0.268627338, 0.273602542}, // 12985K
			{0.268624429, 0.273598857}, // 12986K
			{0.26862152, 0.273595172}, // 12987K
			{0.268618611, 0.273591489}, // 12988K
			{0.268615703, 0.273587806}, // 12989K
			{0.268612796, 0.273584123}, // 12990K
			{0.268609889, 0.273580441}, // 12991K
			{0.268606982, 0.27357676}, // 12992K
			{0.268604077, 0.27357308}, // 12993K
			{0.268601171, 0.2735694}, // 12994K
			{0.268598267, 0.27356572}, // 12995K
			{0.268595363, 0.273562042}, // 12996K
			{0.268592459, 0.273558364}, // 12997K
			{0.268589556, 0.273554686}, // 12998K
			{0.268586653, 0.273551009}, // 12999K
			{0.268583751, 0.273547333}, // 13000K
			{0.26858085, 0.273543658}, // 13001K
			{0.268577949, 0.273539983}, // 13002K
			{0.268575049, 0.273536309}, // 13003K
			{0.268572149, 0.273532635}, // 13004K
			{0.26856925, 0.273528962}, // 13005K
			{0.268566351, 0.27352529}, // 13006K
			{0.268563453, 0.273521618}, // 13007K
			{0.268560556, 0.273517947}, // 13008K
			{0.268557659, 0.273514276}, // 13009K
			{0.268554762, 0.273510606}, // 13010K
			{0.268551866, 0.273506937}, // 13011K
			{0.268548971, 0.273503269}, // 13012K
			{0.268546076, 0.273499601}, // 13013K
			{0.268543182, 0.273495933}, // 13014K
			{0.268540288, 0.273492267}, // 13015K
			{0.268537395, 0.273488601}, // 13016K
			{0.268534502, 0.273484935}, // 13017K
			{0.26853161, 0.27348127}, // 13018K
			{0.268528718, 0.273477606}, // 13019K
			{0.268525827, 0.273473943}, // 13020K
			{0.268522937, 0.27347028}, // 13021K
			{0.268520047, 0.273466617}, // 13022K
			{0.268517157, 0.273462956}, // 13023K
			{0.268514268, 0.273459295}, // 13024K
			{0.26851138, 0.273455634}, // 13025K
			{0.268508492, 0.273451974}, // 13026K
			{0.268505605, 0.273448315}, // 13027K
			{0.268502718, 0.273444657}, // 13028K
			{0.268499832, 0.273440999}, // 13029K
			{0.268496947, 0.273437341}, // 13030K
			{0.268494062, 0.273433685}, // 13031K
			{0.268491177, 0.273430029}, // 13032K
			{0.268488293, 0.273426373}, // 13033K
			{0.26848541, 0.273422719}, // 13034K
			{0.268482527, 0.273419064}, // 13035K
			{0.268479644, 0.273415411}, // 13036K
			{0.268476763, 0.273411758}, // 13037K
			{0.268473881, 0.273408106}, // 13038K
			{0.268471001, 0.273404454}, // 13039K
			{0.26846812, 0.273400803}, // 13040K
			{0.268465241, 0.273397153}, // 13041K
			{0.268462362, 0.273393503}, // 13042K
			{0.268459483, 0.273389854}, // 13043K
			{0.268456605, 0.273386205}, // 13044K
			{0.268453728, 0.273382557}, // 13045K
			{0.268450851, 0.27337891}, // 13046K
			{0.268447974, 0.273375263}, // 13047K
			{0.268445098, 0.273371617}, // 13048K
			{0.268442223, 0.273367972}, // 13049K
			{0.268439348, 0.273364327}, // 13050K
			{0.268436474, 0.273360683}, // 13051K
			{0.2684336, 0.273357039}, // 13052K
			{0.268430727, 0.273353396}, // 13053K
			{0.268427855, 0.273349754}, // 13054K
			{0.268424983, 0.273346112}, // 13055K
			{0.268422111, 0.273342471}, // 13056K
			{0.26841924, 0.273338831}, // 13057K
			{0.26841637, 0.273335191}, // 13058K
			{0.2684135, 0.273331552}, // 13059K
			{0.26841063, 0.273327913}, // 13060K
			{0.268407761, 0.273324275}, // 13061K
			{0.268404893, 0.273320638}, // 13062K
			{0.268402025, 0.273317001}, // 13063K
			{0.268399158, 0.273313365}, // 13064K
			{0.268396291, 0.27330973}, // 13065K
			{0.268393425, 0.273306095}, // 13066K
			{0.26839056, 0.273302461}, // 13067K
			{0.268387695, 0.273298827}, // 13068K
			{0.26838483, 0.273295194}, // 13069K
			{0.268381966, 0.273291562}, // 13070K
			{0.268379103, 0.27328793}, // 13071K
			{0.26837624, 0.273284299}, // 13072K
			{0.268373377, 0.273280668}, // 13073K
			{0.268370515, 0.273277039}, // 13074K
			{0.268367654, 0.273273409}, // 13075K
			{0.268364793, 0.273269781}, // 13076K
			{0.268361933, 0.273266153}, // 13077K
			{0.268359073, 0.273262525}, // 13078K
			{0.268356214, 0.273258899}, // 13079K
			{0.268353355, 0.273255272}, // 13080K
			{0.268350497, 0.273251647}, // 13081K
			{0.26834764, 0.273248022}, // 13082K
			{0.268344783, 0.273244398}, // 13083K
			{0.268341926, 0.273240774}, // 13084K
			{0.26833907, 0.273237151}, // 13085K
			{0.268336215, 0.273233528}, // 13086K
			{0.26833336, 0.273229907}, // 13087K
			{0.268330505, 0.273226285}, // 13088K
			{0.268327652, 0.273222665}, // 13089K
			{0.268324798, 0.273219045}, // 13090K
			{0.268321946, 0.273215425}, // 13091K
			{0.268319093, 0.273211807}, // 13092K
			{0.268316242, 0.273208189}, // 13093K
			{0.26831339, 0.273204571}, // 13094K
			{0.26831054, 0.273200954}, // 13095K
			{0.26830769, 0.273197338}, // 13096K
			{0.26830484, 0.273193722}, // 13097K
			{0.268301991, 0.273190107}, // 13098K
			{0.268299143, 0.273186493}, // 13099K
			{0.268296295, 0.273182879}, // 13100K
			{0.268293447, 0.273179266}, // 13101K
			{0.2682906, 0.273175653}, // 13102K
			{0.268287754, 0.273172041}, // 13103K
			{0.268284908, 0.27316843}, // 13104K
			{0.268282063, 0.273164819}, // 13105K
			{0.268279218, 0.273161209}, // 13106K
			{0.268276374, 0.273157599}, // 13107K
			{0.26827353, 0.273153991}, // 13108K
			{0.268270687, 0.273150382}, // 13109K
			{0.268267844, 0.273146775}, // 13110K
			{0.268265002, 0.273143168}, // 13111K
			{0.268262161, 0.273139561}, // 13112K
			{0.26825932, 0.273135955}, // 13113K
			{0.268256479, 0.27313235}, // 13114K
			{0.268253639, 0.273128746}, // 13115K
			{0.2682508, 0.273125142}, // 13116K
			{0.268247961, 0.273121538}, // 13117K
			{0.268245122, 0.273117935}, // 13118K
			{0.268242284, 0.273114333}, // 13119K
			{0.268239447, 0.273110732}, // 13120K
			{0.26823661, 0.273107131}, // 13121K
			{0.268233774, 0.273103531}, // 13122K
			{0.268230938, 0.273099931}, // 13123K
			{0.268228103, 0.273096332}, // 13124K
			{0.268225268, 0.273092733}, // 13125K
			{0.268222434, 0.273089136}, // 13126K
			{0.2682196, 0.273085538}, // 13127K
			{0.268216767, 0.273081942}, // 13128K
			{0.268213935, 0.273078346}, // 13129K
			{0.268211103, 0.27307475}, // 13130K
			{0.268208271, 0.273071155}, // 13131K
			{0.26820544, 0.273067561}, // 13132K
			{0.26820261, 0.273063968}, // 13133K
			{0.26819978, 0.273060375}, // 13134K
			{0.26819695, 0.273056782}, // 13135K
			{0.268194121, 0.273053191}, // 13136K
			{0.268191293, 0.2730496}, // 13137K
			{0.268188465, 0.273046009}, // 13138K
			{0.268185638, 0.273042419}, // 13139K
			{0.268182811, 0.27303883}, // 13140K
			{0.268179985, 0.273035241}, // 13141K
			{0.268177159, 0.273031653}, // 13142K
			{0.268174334, 0.273028066}, // 13143K
			{0.268171509, 0.273024479}, // 13144K
			{0.268168685, 0.273020893}, // 13145K
			{0.268165862, 0.273017307}, // 13146K
			{0.268163039, 0.273013722}, // 13147K
			{0.268160216, 0.273010137}, // 13148K
			{0.268157394, 0.273006554}, // 13149K
			{0.268154572, 0.27300297}, // 13150K
			{0.268151751, 0.272999388}, // 13151K
			{0.268148931, 0.272995806}, // 13152K
			{0.268146111, 0.272992225}, // 13153K
			{0.268143292, 0.272988644}, // 13154K
			{0.268140473, 0.272985064}, // 13155K
			{0.268137654, 0.272981484}, // 13156K
			{0.268134837, 0.272977905}, // 13157K
			{0.268132019, 0.272974327}, // 13158K
			{0.268129203, 0.272970749}, // 13159K
			{0.268126386, 0.272967172}, // 13160K
			{0.268123571, 0.272963595}, // 13161K
			{0.268120755, 0.27296002}, // 13162K
			{0.268117941, 0.272956444}, // 13163K
			{0.268115126, 0.27295287}, // 13164K
			{0.268112313, 0.272949295}, // 13165K
			{0.2681095, 0.272945722}, // 13166K
			{0.268106687, 0.272942149}, // 13167K
			{0.268103875, 0.272938577}, // 13168K
			{0.268101063, 0.272935005}, // 13169K
			{0.268098252, 0.272931434}, // 13170K
			{0.268095442, 0.272927864}, // 13171K
			{0.268092632, 0.272924294}, // 13172K
			{0.268089823, 0.272920725}, // 13173K
			{0.268087014, 0.272917156}, // 13174K
			{0.268084205, 0.272913588}, // 13175K
			{0.268081397, 0.27291002}, // 13176K
			{0.26807859, 0.272906454}, // 13177K
			{0.268075783, 0.272902887}, // 13178K
			{0.268072977, 0.272899322}, // 13179K
			{0.268070171, 0.272895757}, // 13180K
			{0.268067366, 0.272892192}, // 13181K
			{0.268064561, 0.272888629}, // 13182K
			{0.268061757, 0.272885065}, // 13183K
			{0.268058953, 0.272881503}, // 13184K
			{0.26805615, 0.272877941}, // 13185K
			{0.268053347, 0.272874379}, // 13186K
			{0.268050545, 0.272870819}, // 13187K
			{0.268047743, 0.272867259}, // 13188K
			{0.268044942, 0.272863699}, // 13189K
			{0.268042142, 0.27286014}, // 13190K
			{0.268039341, 0.272856582}, // 13191K
			{0.268036542, 0.272853024}, // 13192K
			{0.268033743, 0.272849467}, // 13193K
			{0.268030944, 0.27284591}, // 13194K
			{0.268028146, 0.272842354}, // 13195K
			{0.268025349, 0.272838799}, // 13196K
			{0.268022552, 0.272835244}, // 13197K
			{0.268019756, 0.27283169}, // 13198K
			{0.26801696, 0.272828136}, // 13199K
			{0.268014164, 0.272824583}, // 13200K
			{0.268011369, 0.272821031}, // 13201K
			{0.268008575, 0.272817479}, // 13202K
			{0.268005781, 0.272813928}, // 13203K
			{0.268002988, 0.272810378}, // 13204K
			{0.268000195, 0.272806828}, // 13205K
			{0.267997403, 0.272803278}, // 13206K
			{0.267994611, 0.27279973}, // 13207K
			{0.26799182, 0.272796181}, // 13208K
			{0.267989029, 0.272792634}, // 13209K
			{0.267986239, 0.272789087}, // 13210K
			{0.267983449, 0.272785541}, // 13211K
			{0.26798066, 0.272781995}, // 13212K
			{0.267977871, 0.27277845}, // 13213K
			{0.267975083, 0.272774905}, // 13214K
			{0.267972295, 0.272771361}, // 13215K
			{0.267969508, 0.272767818}, // 13216K
			{0.267966722, 0.272764275}, // 13217K
			{0.267963936, 0.272760733}, // 13218K
			{0.26796115, 0.272757191}, // 13219K
			{0.267958365, 0.27275365}, // 13220K
			{0.26795558, 0.27275011}, // 13221K
			{0.267952796, 0.27274657}, // 13222K
			{0.267950013, 0.272743031}, // 13223K
			{0.26794723, 0.272739493}, // 13224K
			{0.267944447, 0.272735955}, // 13225K
			{0.267941665, 0.272732417}, // 13226K
			{0.267938884, 0.272728881}, // 13227K
			{0.267936103, 0.272725344}, // 13228K
			{0.267933323, 0.272721809}, // 13229K
			{0.267930543, 0.272718274}, // 13230K
			{0.267927763, 0.27271474}, // 13231K
			{0.267924984, 0.272711206}, // 13232K
			{0.267922206, 0.272707673}, // 13233K
			{0.267919428, 0.27270414}, // 13234K
			{0.267916651, 0.272700608}, // 13235K
			{0.267913874, 0.272697077}, // 13236K
			{0.267911098, 0.272693546}, // 13237K
			{0.267908322, 0.272690016}, // 13238K
			{0.267905547, 0.272686486}, // 13239K
			{0.267902772, 0.272682957}, // 13240K
			{0.267899998, 0.272679429}, // 13241K
			{0.267897224, 0.272675901}, // 13242K
			{0.267894451, 0.272672374}, // 13243K
			{0.267891678, 0.272668847}, // 13244K
			{0.267888906, 0.272665321}, // 13245K
			{0.267886134, 0.272661795}, // 13246K
			{0.267883363, 0.272658271}, // 13247K
			{0.267880592, 0.272654746}, // 13248K
			{0.267877822, 0.272651223}, // 13249K
			{0.267875053, 0.2726477}, // 13250K
			{0.267872283, 0.272644177}, // 13251K
			{0.267869515, 0.272640655}, // 13252K
			{0.267866747, 0.272637134}, // 13253K
			{0.267863979, 0.272633613}, // 13254K
			{0.267861212, 0.272630093}, // 13255K
			{0.267858445, 0.272626574}, // 13256K
			{0.267855679, 0.272623055}, // 13257K
			{0.267852914, 0.272619537}, // 13258K
			{0.267850149, 0.272616019}, // 13259K
			{0.267847384, 0.272612502}, // 13260K
			{0.26784462, 0.272608985}, // 13261K
			{0.267841857, 0.272605469}, // 13262K
			{0.267839094, 0.272601954}, // 13263K
			{0.267836331, 0.272598439}, // 13264K
			{0.267833569, 0.272594925}, // 13265K
			{0.267830808, 0.272591411}, // 13266K
			{0.267828047, 0.272587899}, // 13267K
			{0.267825286, 0.272584386}, // 13268K
			{0.267822527, 0.272580874}, // 13269K
			{0.267819767, 0.272577363}, // 13270K
			{0.267817008, 0.272573853}, // 13271K
			{0.26781425, 0.272570343}, // 13272K
			{0.267811492, 0.272566833}, // 13273K
			{0.267808735, 0.272563324}, // 13274K
			{0.267805978, 0.272559816}, // 13275K
			{0.267803221, 0.272556308}, // 13276K
			{0.267800465, 0.272552801}, // 13277K
			{0.26779771, 0.272549295}, // 13278K
			{0.267794955, 0.272545789}, // 13279K
			{0.267792201, 0.272542284}, // 13280K
			{0.267789447, 0.272538779}, // 13281K
			{0.267786694, 0.272535275}, // 13282K
			{0.267783941, 0.272531771}, // 13283K
			{0.267781189, 0.272528268}, // 13284K
			{0.267778437, 0.272524766}, // 13285K
			{0.267775685, 0.272521264}, // 13286K
			{0.267772935, 0.272517763}, // 13287K
			{0.267770184, 0.272514263}, // 13288K
			{0.267767435, 0.272510763}, // 13289K
			{0.267764685, 0.272507263}, // 13290K
			{0.267761937, 0.272503764}, // 13291K
			{0.267759188, 0.272500266}, // 13292K
			{0.267756441, 0.272496769}, // 13293K
			{0.267753693, 0.272493271}, // 13294K
			{0.267750947, 0.272489775}, // 13295K
			{0.2677482, 0.272486279}, // 13296K
			{0.267745455, 0.272482784}, // 13297K
			{0.267742709, 0.272479289}, // 13298K
			{0.267739965, 0.272475795}, // 13299K
			{0.267737221, 0.272472302}, // 13300K
			{0.267734477, 0.272468809}, // 13301K
			{0.267731734, 0.272465316}, // 13302K
			{0.267728991, 0.272461825}, // 13303K
			{0.267726249, 0.272458333}, // 13304K
			{0.267723507, 0.272454843}, // 13305K
			{0.267720766, 0.272451353}, // 13306K
			{0.267718025, 0.272447863}, // 13307K
			{0.267715285, 0.272444375}, // 13308K
			{0.267712545, 0.272440886}, // 13309K
			{0.267709806, 0.272437399}, // 13310K
			{0.267707068, 0.272433912}, // 13311K
			{0.267704329, 0.272430425}, // 13312K
			{0.267701592, 0.272426939}, // 13313K
			{0.267698855, 0.272423454}, // 13314K
			{0.267696118, 0.272419969}, // 13315K
			{0.267693382, 0.272416485}, // 13316K
			{0.267690646, 0.272413002}, // 13317K
			{0.267687911, 0.272409519}, // 13318K
			{0.267685176, 0.272406036}, // 13319K
			{0.267682442, 0.272402554}, // 13320K
			{0.267679709, 0.272399073}, // 13321K
			{0.267676976, 0.272395593}, // 13322K
			{0.267674243, 0.272392112}, // 13323K
			{0.267671511, 0.272388633}, // 13324K
			{0.267668779, 0.272385154}, // 13325K
			{0.267666048, 0.272381676}, // 13326K
			{0.267663317, 0.272378198}, // 13327K
			{0.267660587, 0.272374721}, // 13328K
			{0.267657858, 0.272371244}, // 13329K
			{0.267655129, 0.272367769}, // 13330K
			{0.2676524, 0.272364293}, // 13331K
			{0.267649672, 0.272360818}, // 13332K
			{0.267646944, 0.272357344}, // 13333K
			{0.267644217, 0.272353871}, // 13334K
			{0.267641491, 0.272350397}, // 13335K
			{0.267638764, 0.272346925}, // 13336K
			{0.267636039, 0.272343453}, // 13337K
			{0.267633314, 0.272339982}, // 13338K
			{0.267630589, 0.272336511}, // 13339K
			{0.267627865, 0.272333041}, // 13340K
			{0.267625141, 0.272329571}, // 13341K
			{0.267622418, 0.272326102}, // 13342K
			{0.267619696, 0.272322634}, // 13343K
			{0.267616974, 0.272319166}, // 13344K
			{0.267614252, 0.272315699}, // 13345K
			{0.267611531, 0.272312232}, // 13346K
			{0.26760881, 0.272308766}, // 13347K
			{0.26760609, 0.272305301}, // 13348K
			{0.267603371, 0.272301836}, // 13349K
			{0.267600651, 0.272298372}, // 13350K
			{0.267597933, 0.272294908}, // 13351K
			{0.267595215, 0.272291445}, // 13352K
			{0.267592497, 0.272287982}, // 13353K
			{0.26758978, 0.27228452}, // 13354K
			{0.267587063, 0.272281059}, // 13355K
			{0.267584347, 0.272277598}, // 13356K
			{0.267581632, 0.272274138}, // 13357K
			{0.267578916, 0.272270678}, // 13358K
			{0.267576202, 0.272267219}, // 13359K
			{0.267573488, 0.27226376}, // 13360K
			{0.267570774, 0.272260302}, // 13361K
			{0.267568061, 0.272256845}, // 13362K
			{0.267565348, 0.272253388}, // 13363K
			{0.267562636, 0.272249932}, // 13364K
			{0.267559925, 0.272246476}, // 13365K
			{0.267557213, 0.272243021}, // 13366K
			{0.267554503, 0.272239567}, // 13367K
			{0.267551793, 0.272236113}, // 13368K
			{0.267549083, 0.27223266}, // 13369K
			{0.267546374, 0.272229207}, // 13370K
			{0.267543665, 0.272225755}, // 13371K
			{0.267540957, 0.272222303}, // 13372K
			{0.267538249, 0.272218852}, // 13373K
			{0.267535542, 0.272215402}, // 13374K
			{0.267532835, 0.272211952}, // 13375K
			{0.267530129, 0.272208503}, // 13376K
			{0.267527423, 0.272205054}, // 13377K
			{0.267524718, 0.272201606}, // 13378K
			{0.267522014, 0.272198158}, // 13379K
			{0.267519309, 0.272194711}, // 13380K
			{0.267516606, 0.272191265}, // 13381K
			{0.267513902, 0.272187819}, // 13382K
			{0.2675112, 0.272184374}, // 13383K
			{0.267508497, 0.272180929}, // 13384K
			{0.267505796, 0.272177485}, // 13385K
			{0.267503094, 0.272174041}, // 13386K
			{0.267500394, 0.272170599}, // 13387K
			{0.267497693, 0.272167156}, // 13388K
			{0.267494994, 0.272163714}, // 13389K
			{0.267492294, 0.272160273}, // 13390K
			{0.267489596, 0.272156833}, // 13391K
			{0.267486897, 0.272153392}, // 13392K
			{0.2674842, 0.272149953}, // 13393K
			{0.267481502, 0.272146514}, // 13394K
			{0.267478805, 0.272143076}, // 13395K
			{0.267476109, 0.272139638}, // 13396K
			{0.267473413, 0.272136201}, // 13397K
			{0.267470718, 0.272132764}, // 13398K
			{0.267468023, 0.272129328}, // 13399K
			{0.267465329, 0.272125893}, // 13400K
			{0.267462635, 0.272122458}, // 13401K
			{0.267459942, 0.272119023}, // 13402K
			{0.267457249, 0.27211559}, // 13403K
			{0.267454556, 0.272112156}, // 13404K
			{0.267451865, 0.272108724}, // 13405K
			{0.267449173, 0.272105292}, // 13406K
			{0.267446482, 0.27210186}, // 13407K
			{0.267443792, 0.272098429}, // 13408K
			{0.267441102, 0.272094999}, // 13409K
			{0.267438412, 0.272091569}, // 13410K
			{0.267435724, 0.27208814}, // 13411K
			{0.267433035, 0.272084712}, // 13412K
			{0.267430347, 0.272081284}, // 13413K
			{0.26742766, 0.272077856}, // 13414K
			{0.267424973, 0.272074429}, // 13415K
			{0.267422286, 0.272071003}, // 13416K
			{0.2674196, 0.272067577}, // 13417K
			{0.267416915, 0.272064152}, // 13418K
			{0.26741423, 0.272060727}, // 13419K
			{0.267411545, 0.272057303}, // 13420K
			{0.267408861, 0.27205388}, // 13421K
			{0.267406178, 0.272050457}, // 13422K
			{0.267403495, 0.272047035}, // 13423K
			{0.267400812, 0.272043613}, // 13424K
			{0.26739813, 0.272040192}, // 13425K
			{0.267395448, 0.272036771}, // 13426K
			{0.267392767, 0.272033351}, // 13427K
			{0.267390087, 0.272029932}, // 13428K
			{0.267387407, 0.272026513}, // 13429K
			{0.267384727, 0.272023095}, // 13430K
			{0.267382048, 0.272019677}, // 13431K
			{0.267379369, 0.27201626}, // 13432K
			{0.267376691, 0.272012843}, // 13433K
			{0.267374013, 0.272009427}, // 13434K
			{0.267371336, 0.272006012}, // 13435K
			{0.267368659, 0.272002597}, // 13436K
			{0.267365983, 0.271999182}, // 13437K
			{0.267363307, 0.271995769}, // 13438K
			{0.267360632, 0.271992355}, // 13439K
			{0.267357957, 0.271988943}, // 13440K
			{0.267355283, 0.271985531}, // 13441K
			{0.267352609, 0.271982119}, // 13442K
			{0.267349936, 0.271978708}, // 13443K
			{0.267347263, 0.271975298}, // 13444K
			{0.267344591, 0.271971888}, // 13445K
			{0.267341919, 0.271968479}, // 13446K
			{0.267339248, 0.27196507}, // 13447K
			{0.267336577, 0.271961662}, // 13448K
			{0.267333906, 0.271958255}, // 13449K
			{0.267331237, 0.271954848}, // 13450K
			{0.267328567, 0.271951441}, // 13451K
			{0.267325898, 0.271948035}, // 13452K
			{0.26732323, 0.27194463}, // 13453K
			{0.267320562, 0.271941225}, // 13454K
			{0.267317894, 0.271937821}, // 13455K
			{0.267315227, 0.271934418}, // 13456K
			{0.267312561, 0.271931015}, // 13457K
			{0.267309895, 0.271927612}, // 13458K
			{0.267307229, 0.27192421}, // 13459K
			{0.267304564, 0.271920809}, // 13460K
			{0.2673019, 0.271917408}, // 13461K
			{0.267299236, 0.271914008}, // 13462K
			{0.267296572, 0.271910609}, // 13463K
			{0.267293909, 0.27190721}, // 13464K
			{0.267291246, 0.271903811}, // 13465K
			{0.267288584, 0.271900413}, // 13466K
			{0.267285923, 0.271897016}, // 13467K
			{0.267283261, 0.271893619}, // 13468K
			{0.267280601, 0.271890223}, // 13469K
			{0.267277941, 0.271886827}, // 13470K
			{0.267275281, 0.271883432}, // 13471K
			{0.267272622, 0.271880038}, // 13472K
			{0.267269963, 0.271876644}, // 13473K
			{0.267267305, 0.27187325}, // 13474K
			{0.267264647, 0.271869858}, // 13475K
			{0.26726199, 0.271866465}, // 13476K
			{0.267259333, 0.271863074}, // 13477K
			{0.267256676, 0.271859682}, // 13478K
			{0.267254021, 0.271856292}, // 13479K
			{0.267251365, 0.271852902}, // 13480K
			{0.26724871, 0.271849512}, // 13481K
			{0.267246056, 0.271846124}, // 13482K
			{0.267243402, 0.271842735}, // 13483K
			{0.267240748, 0.271839348}, // 13484K
			{0.267238096, 0.27183596}, // 13485K
			{0.267235443, 0.271832574}, // 13486K
			{0.267232791, 0.271829188}, // 13487K
			{0.26723014, 0.271825802}, // 13488K
			{0.267227488, 0.271822417}, // 13489K
			{0.267224838, 0.271819033}, // 13490K
			{0.267222188, 0.271815649}, // 13491K
			{0.267219538, 0.271812266}, // 13492K
			{0.267216889, 0.271808883}, // 13493K
			{0.267214241, 0.271805501}, // 13494K
			{0.267211592, 0.271802119}, // 13495K
			{0.267208945, 0.271798738}, // 13496K
			{0.267206297, 0.271795358}, // 13497K
			{0.267203651, 0.271791978}, // 13498K
			{0.267201005, 0.271788599}, // 13499K
			{0.267198359, 0.27178522}, // 13500K
			{0.267195713, 0.271781842}, // 13501K
			{0.267193069, 0.271778464}, // 13502K
			{0.267190424, 0.271775087}, // 13503K
			{0.267187781, 0.27177171}, // 13504K
			{0.267185137, 0.271768334}, // 13505K
			{0.267182494, 0.271764959}, // 13506K
			{0.267179852, 0.271761584}, // 13507K
			{0.26717721, 0.27175821}, // 13508K
			{0.267174569, 0.271754836}, // 13509K
			{0.267171928, 0.271751463}, // 13510K
			{0.267169287, 0.27174809}, // 13511K
			{0.267166647, 0.271744718}, // 13512K
			{0.267164008, 0.271741347}, // 13513K
			{0.267161368, 0.271737976}, // 13514K
			{0.26715873, 0.271734605}, // 13515K
			{0.267156092, 0.271731236}, // 13516K
			{0.267153454, 0.271727866}, // 13517K
			{0.267150817, 0.271724498}, // 13518K
			{0.26714818, 0.271721129}, // 13519K
			{0.267145544, 0.271717762}, // 13520K
			{0.267142908, 0.271714395}, // 13521K
			{0.267140273, 0.271711028}, // 13522K
			{0.267137638, 0.271707662}, // 13523K
			{0.267135004, 0.271704297}, // 13524K
			{0.26713237, 0.271700932}, // 13525K
			{0.267129737, 0.271697568}, // 13526K
			{0.267127104, 0.271694204}, // 13527K
			{0.267124472, 0.271690841}, // 13528K
			{0.26712184, 0.271687479}, // 13529K
			{0.267119209, 0.271684117}, // 13530K
			{0.267116578, 0.271680755}, // 13531K
			{0.267113947, 0.271677394}, // 13532K
			{0.267111317, 0.271674034}, // 13533K
			{0.267108688, 0.271670674}, // 13534K
			{0.267106059, 0.271667315}, // 13535K
			{0.26710343, 0.271663956}, // 13536K
			{0.267100802, 0.271660598}, // 13537K
			{0.267098174, 0.27165724}, // 13538K
			{0.267095547, 0.271653883}, // 13539K
			{0.26709292, 0.271650527}, // 13540K
			{0.267090294, 0.271647171}, // 13541K
			{0.267087668, 0.271643816}, // 13542K
			{0.267085043, 0.271640461}, // 13543K
			{0.267082418, 0.271637107}, // 13544K
			{0.267079794, 0.271633753}, // 13545K
			{0.26707717, 0.2716304}, // 13546K
			{0.267074547, 0.271627047}, // 13547K
			{0.267071924, 0.271623695}, // 13548K
			{0.267069302, 0.271620344}, // 13549K
			{0.26706668, 0.271616993}, // 13550K
			{0.267064058, 0.271613642}, // 13551K
			{0.267061437, 0.271610293}, // 13552K
			{0.267058817, 0.271606943}, // 13553K
			{0.267056197, 0.271603595}, // 13554K
			{0.267053577, 0.271600247}, // 13555K
			{0.267050958, 0.271596899}, // 13556K
			{0.267048339, 0.271593552}, // 13557K
			{0.267045721, 0.271590205}, // 13558K
			{0.267043104, 0.271586859}, // 13559K
			{0.267040486, 0.271583514}, // 13560K
			{0.26703787, 0.271580169}, // 13561K
			{0.267035253, 0.271576825}, // 13562K
			{0.267032638, 0.271573481}, // 13563K
			{0.267030022, 0.271570138}, // 13564K
			{0.267027408, 0.271566795}, // 13565K
			{0.267024793, 0.271563453}, // 13566K
			{0.267022179, 0.271560112}, // 13567K
			{0.267019566, 0.271556771}, // 13568K
			{0.267016953, 0.27155343}, // 13569K
			{0.26701434, 0.271550091}, // 13570K
			{0.267011728, 0.271546751}, // 13571K
			{0.267009117, 0.271543413}, // 13572K
			{0.267006506, 0.271540074}, // 13573K
			{0.267003895, 0.271536737}, // 13574K
			{0.267001285, 0.2715334}, // 13575K
			{0.266998675, 0.271530063}, // 13576K
			{0.266996066, 0.271526727}, // 13577K
			{0.266993457, 0.271523391}, // 13578K
			{0.266990849, 0.271520057}, // 13579K
			{0.266988241, 0.271516722}, // 13580K
			{0.266985634, 0.271513388}, // 13581K
			{0.266983027, 0.271510055}, // 13582K
			{0.266980421, 0.271506722}, // 13583K
			{0.266977815, 0.27150339}, // 13584K
			{0.26697521, 0.271500059}, // 13585K
			{0.266972605, 0.271496728}, // 13586K
			{0.26697, 0.271493397}, // 13587K
			{0.266967396, 0.271490067}, // 13588K
			{0.266964792, 0.271486738}, // 13589K
			{0.266962189, 0.271483409}, // 13590K
			{0.266959587, 0.271480081}, // 13591K
			{0.266956985, 0.271476753}, // 13592K
			{0.266954383, 0.271473426}, // 13593K
			{0.266951782, 0.271470099}, // 13594K
			{0.266949181, 0.271466773}, // 13595K
			{0.266946581, 0.271463447}, // 13596K
			{0.266943981, 0.271460122}, // 13597K
			{0.266941381, 0.271456798}, // 13598K
			{0.266938783, 0.271453474}, // 13599K
			{0.266936184, 0.27145015}, // 13600K
			{0.266933586, 0.271446828}, // 13601K
			{0.266930989, 0.271443505}, // 13602K
			{0.266928392, 0.271440184}, // 13603K
			{0.266925795, 0.271436862}, // 13604K
			{0.266923199, 0.271433542}, // 13605K
			{0.266920604, 0.271430222}, // 13606K
			{0.266918008, 0.271426902}, // 13607K
			{0.266915414, 0.271423583}, // 13608K
			{0.26691282, 0.271420265}, // 13609K
			{0.266910226, 0.271416947}, // 13610K
			{0.266907632, 0.271413629}, // 13611K
			{0.26690504, 0.271410312}, // 13612K
			{0.266902447, 0.271406996}, // 13613K
			{0.266899855, 0.27140368}, // 13614K
			{0.266897264, 0.271400365}, // 13615K
			{0.266894673, 0.271397051}, // 13616K
			{0.266892083, 0.271393736}, // 13617K
			{0.266889493, 0.271390423}, // 13618K
			{0.266886903, 0.27138711}, // 13619K
			{0.266884314, 0.271383797}, // 13620K
			{0.266881725, 0.271380486}, // 13621K
			{0.266879137, 0.271377174}, // 13622K
			{0.266876549, 0.271373863}, // 13623K
			{0.266873962, 0.271370553}, // 13624K
			{0.266871375, 0.271367243}, // 13625K
			{0.266868789, 0.271363934}, // 13626K
			{0.266866203, 0.271360626}, // 13627K
			{0.266863618, 0.271357317}, // 13628K
			{0.266861033, 0.27135401}, // 13629K
			{0.266858449, 0.271350703}, // 13630K
			{0.266855865, 0.271347396}, // 13631K
			{0.266853281, 0.27134409}, // 13632K
			{0.266850698, 0.271340785}, // 13633K
			{0.266848115, 0.27133748}, // 13634K
			{0.266845533, 0.271334176}, // 13635K
			{0.266842952, 0.271330872}, // 13636K
			{0.26684037, 0.271327569}, // 13637K
			{0.26683779, 0.271324266}, // 13638K
			{0.266835209, 0.271320964}, // 13639K
			{0.26683263, 0.271317663}, // 13640K
			{0.26683005, 0.271314361}, // 13641K
			{0.266827471, 0.271311061}, // 13642K
			{0.266824893, 0.271307761}, // 13643K
			{0.266822315, 0.271304462}, // 13644K
			{0.266819738, 0.271301163}, // 13645K
			{0.26681716, 0.271297864}, // 13646K
			{0.266814584, 0.271294567}, // 13647K
			{0.266812008, 0.271291269}, // 13648K
			{0.266809432, 0.271287973}, // 13649K
			{0.266806857, 0.271284676}, // 13650K
			{0.266804282, 0.271281381}, // 13651K
			{0.266801708, 0.271278086}, // 13652K
			{0.266799134, 0.271274791}, // 13653K
			{0.266796561, 0.271271497}, // 13654K
			{0.266793988, 0.271268204}, // 13655K
			{0.266791415, 0.271264911}, // 13656K
			{0.266788844, 0.271261618}, // 13657K
			{0.266786272, 0.271258327}, // 13658K
			{0.266783701, 0.271255035}, // 13659K
			{0.26678113, 0.271251745}, // 13660K
			{0.26677856, 0.271248454}, // 13661K
			{0.266775991, 0.271245165}, // 13662K
			{0.266773421, 0.271241875}, // 13663K
			{0.266770853, 0.271238587}, // 13664K
			{0.266768284, 0.271235299}, // 13665K
			{0.266765717, 0.271232011}, // 13666K
			{0.266763149, 0.271228724}, // 13667K
			{0.266760582, 0.271225438}, // 13668K
			{0.266758016, 0.271222152}, // 13669K
			{0.26675545, 0.271218867}, // 13670K
			{0.266752884, 0.271215582}, // 13671K
			{0.266750319, 0.271212297}, // 13672K
			{0.266747755, 0.271209014}, // 13673K
			{0.26674519, 0.271205731}, // 13674K
			{0.266742627, 0.271202448}, // 13675K
			{0.266740064, 0.271199166}, // 13676K
			{0.266737501, 0.271195884}, // 13677K
			{0.266734938, 0.271192603}, // 13678K
			{0.266732377, 0.271189322}, // 13679K
			{0.266729815, 0.271186043}, // 13680K
			{0.266727254, 0.271182763}, // 13681K
			{0.266724694, 0.271179484}, // 13682K
			{0.266722134, 0.271176206}, // 13683K
			{0.266719574, 0.271172928}, // 13684K
			{0.266717015, 0.271169651}, // 13685K
			{0.266714456, 0.271166374}, // 13686K
			{0.266711898, 0.271163098}, // 13687K
			{0.26670934, 0.271159822}, // 13688K
			{0.266706783, 0.271156547}, // 13689K
			{0.266704226, 0.271153272}, // 13690K
			{0.26670167, 0.271149998}, // 13691K
			{0.266699114, 0.271146725}, // 13692K
			{0.266696559, 0.271143451}, // 13693K
			{0.266694004, 0.271140179}, // 13694K
			{0.266691449, 0.271136907}, // 13695K
			{0.266688895, 0.271133636}, // 13696K
			{0.266686341, 0.271130365}, // 13697K
			{0.266683788, 0.271127094}, // 13698K
			{0.266681235, 0.271123825}, // 13699K
			{0.266678683, 0.271120555}, // 13700K
			{0.266676131, 0.271117287}, // 13701K
			{0.26667358, 0.271114018}, // 13702K
			{0.266671029, 0.271110751}, // 13703K
			{0.266668479, 0.271107484}, // 13704K
			{0.266665929, 0.271104217}, // 13705K
			{0.266663379, 0.271100951}, // 13706K
			{0.26666083, 0.271097686}, // 13707K
			{0.266658281, 0.271094421}, // 13708K
			{0.266655733, 0.271091156}, // 13709K
			{0.266653186, 0.271087892}, // 13710K
			{0.266650638, 0.271084629}, // 13711K
			{0.266648091, 0.271081366}, // 13712K
			{0.266645545, 0.271078104}, // 13713K
			{0.266642999, 0.271074842}, // 13714K
			{0.266640454, 0.271071581}, // 13715K
			{0.266637909, 0.27106832}, // 13716K
			{0.266635364, 0.27106506}, // 13717K
			{0.26663282, 0.2710618}, // 13718K
			{0.266630276, 0.271058541}, // 13719K
			{0.266627733, 0.271055282}, // 13720K
			{0.266625191, 0.271052024}, // 13721K
			{0.266622648, 0.271048767}, // 13722K
			{0.266620106, 0.27104551}, // 13723K
			{0.266617565, 0.271042253}, // 13724K
			{0.266615024, 0.271038997}, // 13725K
			{0.266612484, 0.271035742}, // 13726K
			{0.266609944, 0.271032487}, // 13727K
			{0.266607404, 0.271029233}, // 13728K
			{0.266604865, 0.271025979}, // 13729K
			{0.266602326, 0.271022726}, // 13730K
			{0.266599788, 0.271019473}, // 13731K
			{0.26659725, 0.271016221}, // 13732K
			{0.266594713, 0.271012969}, // 13733K
			{0.266592176, 0.271009718}, // 13734K
			{0.26658964, 0.271006467}, // 13735K
			{0.266587104, 0.271003217}, // 13736K
			{0.266584568, 0.270999968}, // 13737K
			{0.266582033, 0.270996719}, // 13738K
			{0.266579499, 0.27099347}, // 13739K
			{0.266576965, 0.270990222}, // 13740K
			{0.266574431, 0.270986975}, // 13741K
			{0.266571898, 0.270983728}, // 13742K
			{0.266569365, 0.270980481}, // 13743K
			{0.266566833, 0.270977236}, // 13744K
			{0.266564301, 0.27097399}, // 13745K
			{0.266561769, 0.270970745}, // 13746K
			{0.266559238, 0.270967501}, // 13747K
			{0.266556708, 0.270964257}, // 13748K
			{0.266554178, 0.270961014}, // 13749K
			{0.266551648, 0.270957772}, // 13750K
			{0.266549119, 0.270954529}, // 13751K
			{0.26654659, 0.270951288}, // 13752K
			{0.266544062, 0.270948047}, // 13753K
			{0.266541534, 0.270944806}, // 13754K
			{0.266539007, 0.270941566}, // 13755K
			{0.26653648, 0.270938327}, // 13756K
			{0.266533953, 0.270935088}, // 13757K
			{0.266531427, 0.270931849}, // 13758K
			{0.266528902, 0.270928611}, // 13759K
			{0.266526377, 0.270925374}, // 13760K
			{0.266523852, 0.270922137}, // 13761K
			{0.266521328, 0.270918901}, // 13762K
			{0.266518804, 0.270915665}, // 13763K
			{0.26651628, 0.27091243}, // 13764K
			{0.266513758, 0.270909195}, // 13765K
			{0.266511235, 0.270905961}, // 13766K
			{0.266508713, 0.270902727}, // 13767K
			{0.266506192, 0.270899494}, // 13768K
			{0.26650367, 0.270896261}, // 13769K
			{0.26650115, 0.270893029}, // 13770K
			{0.26649863, 0.270889797}, // 13771K
			{0.26649611, 0.270886566}, // 13772K
			{0.26649359, 0.270883336}, // 13773K
			{0.266491072, 0.270880106}, // 13774K
			{0.266488553, 0.270876876}, // 13775K
			{0.266486035, 0.270873647}, // 13776K
			{0.266483518, 0.270870419}, // 13777K
			{0.266481001, 0.270867191}, // 13778K
			{0.266478484, 0.270863964}, // 13779K
			{0.266475968, 0.270860737}, // 13780K
			{0.266473452, 0.27085751}, // 13781K
			{0.266470937, 0.270854285}, // 13782K
			{0.266468422, 0.270851059}, // 13783K
			{0.266465907, 0.270847835}, // 13784K
			{0.266463393, 0.27084461}, // 13785K
			{0.26646088, 0.270841387}, // 13786K
			{0.266458367, 0.270838163}, // 13787K
			{0.266455854, 0.270834941}, // 13788K
			{0.266453342, 0.270831719}, // 13789K
			{0.26645083, 0.270828497}, // 13790K
			{0.266448319, 0.270825276}, // 13791K
			{0.266445808, 0.270822055}, // 13792K
			{0.266443298, 0.270818835}, // 13793K
			{0.266440788, 0.270815616}, // 13794K
			{0.266438278, 0.270812397}, // 13795K
			{0.266435769, 0.270809178}, // 13796K
			{0.266433261, 0.27080596}, // 13797K
			{0.266430753, 0.270802743}, // 13798K
			{0.266428245, 0.270799526}, // 13799K
			{0.266425738, 0.27079631}, // 13800K
			{0.266423231, 0.270793094}, // 13801K
			{0.266420724, 0.270789879}, // 13802K
			{0.266418218, 0.270786664}, // 13803K
			{0.266415713, 0.270783449}, // 13804K
			{0.266413208, 0.270780236}, // 13805K
			{0.266410703, 0.270777022}, // 13806K
			{0.266408199, 0.27077381}, // 13807K
			{0.266405695, 0.270770597}, // 13808K
			{0.266403192, 0.270767386}, // 13809K
			{0.266400689, 0.270764175}, // 13810K
			{0.266398187, 0.270760964}, // 13811K
			{0.266395685, 0.270757754}, // 13812K
			{0.266393183, 0.270754544}, // 13813K
			{0.266390682, 0.270751335}, // 13814K
			{0.266388181, 0.270748127}, // 13815K
			{0.266385681, 0.270744919}, // 13816K
			{0.266383182, 0.270741711}, // 13817K
			{0.266380682, 0.270738504}, // 13818K
			{0.266378183, 0.270735298}, // 13819K
			{0.266375685, 0.270732092}, // 13820K
			{0.266373187, 0.270728886}, // 13821K
			{0.266370689, 0.270725681}, // 13822K
			{0.266368192, 0.270722477}, // 13823K
			{0.266365696, 0.270719273}, // 13824K
			{0.266363199, 0.27071607}, // 13825K
			{0.266360704, 0.270712867}, // 13826K
			{0.266358208, 0.270709665}, // 13827K
			{0.266355713, 0.270706463}, // 13828K
			{0.266353219, 0.270703262}, // 13829K
			{0.266350725, 0.270700061}, // 13830K
			{0.266348231, 0.270696861}, // 13831K
			{0.266345738, 0.270693661}, // 13832K
			{0.266343246, 0.270690462}, // 13833K
			{0.266340753, 0.270687263}, // 13834K
			{0.266338262, 0.270684065}, // 13835K
			{0.26633577, 0.270680867}, // 13836K
			{0.266333279, 0.27067767}, // 13837K
			{0.266330789, 0.270674473}, // 13838K
			{0.266328299, 0.270671277}, // 13839K
			{0.266325809, 0.270668082}, // 13840K
			{0.26632332, 0.270664887}, // 13841K
			{0.266320831, 0.270661692}, // 13842K
			{0.266318343, 0.270658498}, // 13843K
			{0.266315855, 0.270655305}, // 13844K
			{0.266313368, 0.270652112}, // 13845K
			{0.266310881, 0.270648919}, // 13846K
			{0.266308394, 0.270645727}, // 13847K
			{0.266305908, 0.270642536}, // 13848K
			{0.266303422, 0.270639345}, // 13849K
			{0.266300937, 0.270636155}, // 13850K
			{0.266298452, 0.270632965}, // 13851K
			{0.266295968, 0.270629775}, // 13852K
			{0.266293484, 0.270626587}, // 13853K
			{0.266291001, 0.270623398}, // 13854K
			{0.266288518, 0.27062021}, // 13855K
			{0.266286035, 0.270617023}, // 13856K
			{0.266283553, 0.270613836}, // 13857K
			{0.266281071, 0.27061065}, // 13858K
			{0.26627859, 0.270607464}, // 13859K
			{0.266276109, 0.270604279}, // 13860K
			{0.266273629, 0.270601094}, // 13861K
			{0.266271149, 0.27059791}, // 13862K
			{0.266268669, 0.270594727}, // 13863K
			{0.26626619, 0.270591543}, // 13864K
			{0.266263711, 0.270588361}, // 13865K
			{0.266261233, 0.270585179}, // 13866K
			{0.266258755, 0.270581997}, // 13867K
			{0.266256278, 0.270578816}, // 13868K
			{0.266253801, 0.270575635}, // 13869K
			{0.266251325, 0.270572455}, // 13870K
			{0.266248849, 0.270569276}, // 13871K
			{0.266246373, 0.270566097}, // 13872K
			{0.266243898, 0.270562918}, // 13873K
			{0.266241423, 0.27055974}, // 13874K
			{0.266238949, 0.270556563}, // 13875K
			{0.266236475, 0.270553386}, // 13876K
			{0.266234002, 0.270550209}, // 13877K
			{0.266231529, 0.270547033}, // 13878K
			{0.266229056, 0.270543858}, // 13879K
			{0.266226584, 0.270540683}, // 13880K
			{0.266224112, 0.270537508}, // 13881K
			{0.266221641, 0.270534334}, // 13882K
			{0.26621917, 0.270531161}, // 13883K
			{0.2662167, 0.270527988}, // 13884K
			{0.26621423, 0.270524816}, // 13885K
			{0.266211761, 0.270521644}, // 13886K
			{0.266209291, 0.270518473}, // 13887K
			{0.266206823, 0.270515302}, // 13888K
			{0.266204355, 0.270512131}, // 13889K
			{0.266201887, 0.270508962}, // 13890K
			{0.26619942, 0.270505792}, // 13891K
			{0.266196953, 0.270502624}, // 13892K
			{0.266194486, 0.270499455}, // 13893K
			{0.26619202, 0.270496287}, // 13894K
			{0.266189555, 0.27049312}, // 13895K
			{0.266187089, 0.270489953}, // 13896K
			{0.266184625, 0.270486787}, // 13897K
			{0.26618216, 0.270483622}, // 13898K
			{0.266179697, 0.270480456}, // 13899K
			{0.266177233, 0.270477292}, // 13900K
			{0.26617477, 0.270474127}, // 13901K
			{0.266172308, 0.270470964}, // 13902K
			{0.266169845, 0.270467801}, // 13903K
			{0.266167384, 0.270464638}, // 13904K
			{0.266164922, 0.270461476}, // 13905K
			{0.266162462, 0.270458314}, // 13906K
			{0.266160001, 0.270455153}, // 13907K
			{0.266157541, 0.270451992}, // 13908K
			{0.266155082, 0.270448832}, // 13909K
			{0.266152623, 0.270445673}, // 13910K
			{0.266150164, 0.270442514}, // 13911K
			{0.266147706, 0.270439355}, // 13912K
			{0.266145248, 0.270436197}, // 13913K
			{0.266142791, 0.27043304}, // 13914K
			{0.266140334, 0.270429882}, // 13915K
			{0.266137877, 0.270426726}, // 13916K
			{0.266135421, 0.27042357}, // 13917K
			{0.266132965, 0.270420414}, // 13918K
			{0.26613051, 0.270417259}, // 13919K
			{0.266128055, 0.270414105}, // 13920K
			{0.266125601, 0.270410951}, // 13921K
			{0.266123147, 0.270407797}, // 13922K
			{0.266120694, 0.270404644}, // 13923K
			{0.266118241, 0.270401492}, // 13924K
			{0.266115788, 0.27039834}, // 13925K
			{0.266113336, 0.270395189}, // 13926K
			{0.266110884, 0.270392038}, // 13927K
			{0.266108433, 0.270388887}, // 13928K
			{0.266105982, 0.270385737}, // 13929K
			{0.266103531, 0.270382588}, // 13930K
			{0.266101081, 0.270379439}, // 13931K
			{0.266098632, 0.270376291}, // 13932K
			{0.266096182, 0.270373143}, // 13933K
			{0.266093734, 0.270369995}, // 13934K
			{0.266091285, 0.270366848}, // 13935K
			{0.266088837, 0.270363702}, // 13936K
			{0.26608639, 0.270360556}, // 13937K
			{0.266083943, 0.270357411}, // 13938K
			{0.266081496, 0.270354266}, // 13939K
			{0.26607905, 0.270351122}, // 13940K
			{0.266076604, 0.270347978}, // 13941K
			{0.266074159, 0.270344834}, // 13942K
			{0.266071714, 0.270341692}, // 13943K
			{0.26606927, 0.270338549}, // 13944K
			{0.266066825, 0.270335407}, // 13945K
			{0.266064382, 0.270332266}, // 13946K
			{0.266061939, 0.270329125}, // 13947K
			{0.266059496, 0.270325985}, // 13948K
			{0.266057054, 0.270322845}, // 13949K
			{0.266054612, 0.270319706}, // 13950K
			{0.26605217, 0.270316567}, // 13951K
			{0.266049729, 0.270313429}, // 13952K
			{0.266047288, 0.270310291}, // 13953K
			{0.266044848, 0.270307154}, // 13954K
			{0.266042409, 0.270304017}, // 13955K
			{0.266039969, 0.270300881}, // 13956K
			{0.26603753, 0.270297745}, // 13957K
			{0.266035092, 0.27029461}, // 13958K
			{0.266032654, 0.270291475}, // 13959K
			{0.266030216, 0.270288341}, // 13960K
			{0.266027779, 0.270285207}, // 13961K
			{0.266025342, 0.270282074}, // 13962K
			{0.266022906, 0.270278941}, // 13963K
			{0.26602047, 0.270275809}, // 13964K
			{0.266018034, 0.270272677}, // 13965K
			{0.266015599, 0.270269546}, // 13966K
			{0.266013165, 0.270266415}, // 13967K
			{0.26601073, 0.270263285}, // 13968K
			{0.266008297, 0.270260155}, // 13969K
			{0.266005863, 0.270257026}, // 13970K
			{0.26600343, 0.270253897}, // 13971K
			{0.266000998, 0.270250769}, // 13972K
			{0.265998566, 0.270247641}, // 13973K
			{0.265996134, 0.270244514}, // 13974K
			{0.265993703, 0.270241388}, // 13975K
			{0.265991272, 0.270238261}, // 13976K
			{0.265988841, 0.270235136}, // 13977K
			{0.265986411, 0.27023201}, // 13978K
			{0.265983982, 0.270228886}, // 13979K
			{0.265981553, 0.270225762}, // 13980K
			{0.265979124, 0.270222638}, // 13981K
			{0.265976696, 0.270219515}, // 13982K
			{0.265974268, 0.270216392}, // 13983K
			{0.265971841, 0.27021327}, // 13984K
			{0.265969414, 0.270210148}, // 13985K
			{0.265966987, 0.270207027}, // 13986K
			{0.265964561, 0.270203906}, // 13987K
			{0.265962135, 0.270200786}, // 13988K
			{0.26595971, 0.270197666}, // 13989K
			{0.265957285, 0.270194547}, // 13990K
			{0.26595486, 0.270191429}, // 13991K
			{0.265952436, 0.27018831}, // 13992K
			{0.265950013, 0.270185193}, // 13993K
			{0.26594759, 0.270182076}, // 13994K
			{0.265945167, 0.270178959}, // 13995K
			{0.265942744, 0.270175843}, // 13996K
			{0.265940323, 0.270172727}, // 13997K
			{0.265937901, 0.270169612}, // 13998K
			{0.26593548, 0.270166497}, // 13999K
			{0.265933059, 0.270163383}, // 14000K
			{0.265930639, 0.270160269}, // 14001K
			{0.265928219, 0.270157156}, // 14002K
			{0.2659258, 0.270154044}, // 14003K
			{0.265923381, 0.270150931}, // 14004K
			{0.265920962, 0.27014782}, // 14005K
			{0.265918544, 0.270144709}, // 14006K
			{0.265916127, 0.270141598}, // 14007K
			{0.265913709, 0.270138488}, // 14008K
			{0.265911292, 0.270135378}, // 14009K
			{0.265908876, 0.270132269}, // 14010K
			{0.26590646, 0.27012916}, // 14011K
			{0.265904044, 0.270126052}, // 14012K
			{0.265901629, 0.270122944}, // 14013K
			{0.265899214, 0.270119837}, // 14014K
			{0.2658968, 0.27011673}, // 14015K
			{0.265894386, 0.270113624}, // 14016K
			{0.265891973, 0.270110518}, // 14017K
			{0.26588956, 0.270107413}, // 14018K
			{0.265887147, 0.270104309}, // 14019K
			{0.265884735, 0.270101204}, // 14020K
			{0.265882323, 0.270098101}, // 14021K
			{0.265879911, 0.270094997}, // 14022K
			{0.265877501, 0.270091895}, // 14023K
			{0.26587509, 0.270088792}, // 14024K
			{0.26587268, 0.270085691}, // 14025K
			{0.26587027, 0.27008259}, // 14026K
			{0.265867861, 0.270079489}, // 14027K
			{0.265865452, 0.270076389}, // 14028K
			{0.265863044, 0.270073289}, // 14029K
			{0.265860635, 0.27007019}, // 14030K
			{0.265858228, 0.270067091}, // 14031K
			{0.265855821, 0.270063993}, // 14032K
			{0.265853414, 0.270060895}, // 14033K
			{0.265851008, 0.270057798}, // 14034K
			{0.265848602, 0.270054701}, // 14035K
			{0.265846196, 0.270051605}, // 14036K
			{0.265843791, 0.270048509}, // 14037K
			{0.265841386, 0.270045414}, // 14038K
			{0.265838982, 0.270042319}, // 14039K
			{0.265836578, 0.270039224}, // 14040K
			{0.265834175, 0.270036131}, // 14041K
			{0.265831772, 0.270033037}, // 14042K
			{0.265829369, 0.270029945}, // 14043K
			{0.265826967, 0.270026852}, // 14044K
			{0.265824565, 0.27002376}, // 14045K
			{0.265822164, 0.270020669}, // 14046K
			{0.265819763, 0.270017578}, // 14047K
			{0.265817362, 0.270014488}, // 14048K
			{0.265814962, 0.270011398}, // 14049K
			{0.265812563, 0.270008309}, // 14050K
			{0.265810163, 0.27000522}, // 14051K
			{0.265807765, 0.270002132}, // 14052K
			{0.265805366, 0.269999044}, // 14053K
			{0.265802968, 0.269995956}, // 14054K
			{0.265800571, 0.26999287}, // 14055K
			{0.265798173, 0.269989783}, // 14056K
			{0.265795777, 0.269986697}, // 14057K
			{0.26579338, 0.269983612}, // 14058K
			{0.265790984, 0.269980527}, // 14059K
			{0.265788589, 0.269977443}, // 14060K
			{0.265786194, 0.269974359}, // 14061K
			{0.265783799, 0.269971275}, // 14062K
			{0.265781405, 0.269968192}, // 14063K
			{0.265779011, 0.26996511}, // 14064K
			{0.265776618, 0.269962028}, // 14065K
			{0.265774225, 0.269958946}, // 14066K
			{0.265771832, 0.269955866}, // 14067K
			{0.26576944, 0.269952785}, // 14068K
			{0.265767048, 0.269949705}, // 14069K
			{0.265764657, 0.269946626}, // 14070K
			{0.265762266, 0.269943547}, // 14071K
			{0.265759875, 0.269940468}, // 14072K
			{0.265757485, 0.26993739}, // 14073K
			{0.265755096, 0.269934313}, // 14074K
			{0.265752706, 0.269931236}, // 14075K
			{0.265750317, 0.269928159}, // 14076K
			{0.265747929, 0.269925083}, // 14077K
			{0.265745541, 0.269922007}, // 14078K
			{0.265743153, 0.269918932}, // 14079K
			{0.265740766, 0.269915858}, // 14080K
			{0.265738379, 0.269912784}, // 14081K
			{0.265735993, 0.26990971}, // 14082K
			{0.265733607, 0.269906637}, // 14083K
			{0.265731221, 0.269903564}, // 14084K
			{0.265728836, 0.269900492}, // 14085K
			{0.265726452, 0.269897421}, // 14086K
			{0.265724067, 0.269894349}, // 14087K
			{0.265721683, 0.269891279}, // 14088K
			{0.2657193, 0.269888209}, // 14089K
			{0.265716917, 0.269885139}, // 14090K
			{0.265714534, 0.26988207}, // 14091K
			{0.265712152, 0.269879001}, // 14092K
			{0.26570977, 0.269875933}, // 14093K
			{0.265707389, 0.269872865}, // 14094K
			{0.265705008, 0.269869798}, // 14095K
			{0.265702627, 0.269866731}, // 14096K
			{0.265700247, 0.269863665}, // 14097K
			{0.265697867, 0.269860599}, // 14098K
			{0.265695488, 0.269857534}, // 14099K
			{0.265693109, 0.269854469}, // 14100K
			{0.26569073, 0.269851405}, // 14101K
			{0.265688352, 0.269848341}, // 14102K
			{0.265685975, 0.269845278}, // 14103K
			{0.265683597, 0.269842215}, // 14104K
			{0.26568122, 0.269839153}, // 14105K
			{0.265678844, 0.269836091}, // 14106K
			{0.265676468, 0.269833029}, // 14107K
			{0.265674092, 0.269829968}, // 14108K
			{0.265671717, 0.269826908}, // 14109K
			{0.265669342, 0.269823848}, // 14110K
			{0.265666968, 0.269820789}, // 14111K
			{0.265664594, 0.26981773}, // 14112K
			{0.26566222, 0.269814671}, // 14113K
			{0.265659847, 0.269811613}, // 14114K
			{0.265657474, 0.269808556}, // 14115K
			{0.265655102, 0.269805499}, // 14116K
			{0.26565273, 0.269802442}, // 14117K
			{0.265650358, 0.269799386}, // 14118K
			{0.265647987, 0.269796331}, // 14119K
			{0.265645616, 0.269793276}, // 14120K
			{0.265643246, 0.269790221}, // 14121K
			{0.265640876, 0.269787167}, // 14122K
			{0.265638507, 0.269784114}, // 14123K
			{0.265636138, 0.269781061}, // 14124K
			{0.265633769, 0.269778008}, // 14125K
			{0.265631401, 0.269774956}, // 14126K
			{0.265629033, 0.269771904}, // 14127K
			{0.265626665, 0.269768853}, // 14128K
			{0.265624298, 0.269765802}, // 14129K
			{0.265621932, 0.269762752}, // 14130K
			{0.265619566, 0.269759702}, // 14131K
			{0.2656172, 0.269756653}, // 14132K
			{0.265614834, 0.269753605}, // 14133K
			{0.265612469, 0.269750556}, // 14134K
			{0.265610105, 0.269747509}, // 14135K
			{0.265607741, 0.269744461}, // 14136K
			{0.265605377, 0.269741414}, // 14137K
			{0.265603014, 0.269738368}, // 14138K
			{0.265600651, 0.269735322}, // 14139K
			{0.265598288, 0.269732277}, // 14140K
			{0.265595926, 0.269729232}, // 14141K
			{0.265593564, 0.269726188}, // 14142K
			{0.265591203, 0.269723144}, // 14143K
			{0.265588842, 0.2697201}, // 14144K
			{0.265586481, 0.269717058}, // 14145K
			{0.265584121, 0.269714015}, // 14146K
			{0.265581762, 0.269710973}, // 14147K
			{0.265579402, 0.269707932}, // 14148K
			{0.265577043, 0.269704891}, // 14149K
			{0.265574685, 0.26970185}, // 14150K
			{0.265572327, 0.26969881}, // 14151K
			{0.265569969, 0.269695771}, // 14152K
			{0.265567612, 0.269692732}, // 14153K
			{0.265565255, 0.269689693}, // 14154K
			{0.265562899, 0.269686655}, // 14155K
			{0.265560543, 0.269683617}, // 14156K
			{0.265558187, 0.26968058}, // 14157K
			{0.265555832, 0.269677544}, // 14158K
			{0.265553477, 0.269674507}, // 14159K
			{0.265551123, 0.269671472}, // 14160K
			{0.265548769, 0.269668437}, // 14161K
			{0.265546415, 0.269665402}, // 14162K
			{0.265544062, 0.269662368}, // 14163K
			{0.265541709, 0.269659334}, // 14164K
			{0.265539357, 0.269656301}, // 14165K
			{0.265537005, 0.269653268}, // 14166K
			{0.265534653, 0.269650235}, // 14167K
			{0.265532302, 0.269647204}, // 14168K
			{0.265529951, 0.269644172}, // 14169K
			{0.265527601, 0.269641141}, // 14170K
			{0.265525251, 0.269638111}, // 14171K
			{0.265522901, 0.269635081}, // 14172K
			{0.265520552, 0.269632052}, // 14173K
			{0.265518204, 0.269629023}, // 14174K
			{0.265515855, 0.269625994}, // 14175K
			{0.265513507, 0.269622966}, // 14176K
			{0.26551116, 0.269619939}, // 14177K
			{0.265508813, 0.269616912}, // 14178K
			{0.265506466, 0.269613885}, // 14179K
			{0.26550412, 0.269610859}, // 14180K
			{0.265501774, 0.269607834}, // 14181K
			{0.265499428, 0.269604808}, // 14182K
			{0.265497083, 0.269601784}, // 14183K
			{0.265494739, 0.26959876}, // 14184K
			{0.265492394, 0.269595736}, // 14185K
			{0.26549005, 0.269592713}, // 14186K
			{0.265487707, 0.26958969}, // 14187K
			{0.265485364, 0.269586668}, // 14188K
			{0.265483021, 0.269583646}, // 14189K
			{0.265480679, 0.269580625}, // 14190K
			{0.265478337, 0.269577604}, // 14191K
			{0.265475996, 0.269574584}, // 14192K
			{0.265473654, 0.269571564}, // 14193K
			{0.265471314, 0.269568545}, // 14194K
			{0.265468974, 0.269565526}, // 14195K
			{0.265466634, 0.269562507}, // 14196K
			{0.265464294, 0.269559489}, // 14197K
			{0.265461955, 0.269556472}, // 14198K
			{0.265459617, 0.269553455}, // 14199K
			{0.265457278, 0.269550438}, // 14200K
			{0.26545494, 0.269547422}, // 14201K
			{0.265452603, 0.269544407}, // 14202K
			{0.265450266, 0.269541392}, // 14203K
			{0.265447929, 0.269538377}, // 14204K
			{0.265445593, 0.269535363}, // 14205K
			{0.265443257, 0.269532349}, // 14206K
			{0.265440922, 0.269529336}, // 14207K
			{0.265438587, 0.269526324}, // 14208K
			{0.265436252, 0.269523311}, // 14209K
			{0.265433918, 0.2695203}, // 14210K
			{0.265431584, 0.269517288}, // 14211K
			{0.265429251, 0.269514278}, // 14212K
			{0.265426918, 0.269511267}, // 14213K
			{0.265424585, 0.269508258}, // 14214K
			{0.265422253, 0.269505248}, // 14215K
			{0.265419921, 0.269502239}, // 14216K
			{0.26541759, 0.269499231}, // 14217K
			{0.265415259, 0.269496223}, // 14218K
			{0.265412928, 0.269493216}, // 14219K
			{0.265410598, 0.269490209}, // 14220K
			{0.265408268, 0.269487202}, // 14221K
			{0.265405938, 0.269484196}, // 14222K
			{0.265403609, 0.269481191}, // 14223K
			{0.265401281, 0.269478185}, // 14224K
			{0.265398953, 0.269475181}, // 14225K
			{0.265396625, 0.269472177}, // 14226K
			{0.265394297, 0.269469173}, // 14227K
			{0.26539197, 0.26946617}, // 14228K
			{0.265389644, 0.269463167}, // 14229K
			{0.265387317, 0.269460165}, // 14230K
			{0.265384992, 0.269457163}, // 14231K
			{0.265382666, 0.269454162}, // 14232K
			{0.265380341, 0.269451161}, // 14233K
			{0.265378016, 0.269448161}, // 14234K
			{0.265375692, 0.269445161}, // 14235K
			{0.265373368, 0.269442162}, // 14236K
			{0.265371045, 0.269439163}, // 14237K
			{0.265368722, 0.269436164}, // 14238K
			{0.265366399, 0.269433166}, // 14239K
			{0.265364077, 0.269430169}, // 14240K
			{0.265361755, 0.269427172}, // 14241K
			{0.265359434, 0.269424175}, // 14242K
			{0.265357113, 0.269421179}, // 14243K
			{0.265354792, 0.269418184}, // 14244K
			{0.265352472, 0.269415189}, // 14245K
			{0.265350152, 0.269412194}, // 14246K
			{0.265347832, 0.2694092}, // 14247K
			{0.265345513, 0.269406206}, // 14248K
			{0.265343195, 0.269403213}, // 14249K
			{0.265340876, 0.26940022}, // 14250K
			{0.265338559, 0.269397228}, // 14251K
			{0.265336241, 0.269394236}, // 14252K
			{0.265333924, 0.269391245}, // 14253K
			{0.265331607, 0.269388254}, // 14254K
			{0.265329291, 0.269385263}, // 14255K
			{0.265326975, 0.269382274}, // 14256K
			{0.26532466, 0.269379284}, // 14257K
			{0.265322345, 0.269376295}, // 14258K
			{0.26532003, 0.269373307}, // 14259K
			{0.265317716, 0.269370319}, // 14260K
			{0.265315402, 0.269367331}, // 14261K
			{0.265313088, 0.269364344}, // 14262K
			{0.265310775, 0.269361357}, // 14263K
			{0.265308462, 0.269358371}, // 14264K
			{0.26530615, 0.269355385}, // 14265K
			{0.265303838, 0.2693524}, // 14266K
			{0.265301526, 0.269349415}, // 14267K
			{0.265299215, 0.269346431}, // 14268K
			{0.265296905, 0.269343447}, // 14269K
			{0.265294594, 0.269340464}, // 14270K
			{0.265292284, 0.269337481}, // 14271K
			{0.265289975, 0.269334499}, // 14272K
			{0.265287666, 0.269331517}, // 14273K
			{0.265285357, 0.269328535}, // 14274K
			{0.265283048, 0.269325554}, // 14275K
			{0.26528074, 0.269322574}, // 14276K
			{0.265278433, 0.269319594}, // 14277K
			{0.265276126, 0.269316614}, // 14278K
			{0.265273819, 0.269313635}, // 14279K
			{0.265271512, 0.269310657}, // 14280K
			{0.265269206, 0.269307678}, // 14281K
			{0.265266901, 0.269304701}, // 14282K
			{0.265264596, 0.269301723}, // 14283K
			{0.265262291, 0.269298747}, // 14284K
			{0.265259986, 0.26929577}, // 14285K
			{0.265257682, 0.269292795}, // 14286K
			{0.265255379, 0.269289819}, // 14287K
			{0.265253075, 0.269286844}, // 14288K
			{0.265250773, 0.26928387}, // 14289K
			{0.26524847, 0.269280896}, // 14290K
			{0.265246168, 0.269277923}, // 14291K
			{0.265243866, 0.26927495}, // 14292K
			{0.265241565, 0.269271977}, // 14293K
			{0.265239264, 0.269269005}, // 14294K
			{0.265236964, 0.269266033}, // 14295K
			{0.265234663, 0.269263062}, // 14296K
			{0.265232364, 0.269260091}, // 14297K
			{0.265230064, 0.269257121}, // 14298K
			{0.265227766, 0.269254152}, // 14299K
			{0.265225467, 0.269251182}, // 14300K
			{0.265223169, 0.269248213}, // 14301K
			{0.265220871, 0.269245245}, // 14302K
			{0.265218574, 0.269242277}, // 14303K
			{0.265216277, 0.26923931}, // 14304K
			{0.26521398, 0.269236343}, // 14305K
			{0.265211684, 0.269233376}, // 14306K
			{0.265209388, 0.26923041}, // 14307K
			{0.265207093, 0.269227445}, // 14308K
			{0.265204798, 0.26922448}, // 14309K
			{0.265202503, 0.269221515}, // 14310K
			{0.265200209, 0.269218551}, // 14311K
			{0.265197915, 0.269215587}, // 14312K
			{0.265195622, 0.269212624}, // 14313K
			{0.265193329, 0.269209661}, // 14314K
			{0.265191036, 0.269206699}, // 14315K
			{0.265188744, 0.269203737}, // 14316K
			{0.265186452, 0.269200776}, // 14317K
			{0.26518416, 0.269197815}, // 14318K
			{0.265181869, 0.269194855}, // 14319K
			{0.265179578, 0.269191895}, // 14320K
			{0.265177288, 0.269188935}, // 14321K
			{0.265174998, 0.269185976}, // 14322K
			{0.265172709, 0.269183018}, // 14323K
			{0.265170419, 0.269180059}, // 14324K
			{0.265168131, 0.269177102}, // 14325K
			{0.265165842, 0.269174145}, // 14326K
			{0.265163554, 0.269171188}, // 14327K
			{0.265161267, 0.269168232}, // 14328K
			{0.26515898, 0.269165276}, // 14329K
			{0.265156693, 0.269162321}, // 14330K
			{0.265154406, 0.269159366}, // 14331K
			{0.26515212, 0.269156411}, // 14332K
			{0.265149835, 0.269153457}, // 14333K
			{0.265147549, 0.269150504}, // 14334K
			{0.265145264, 0.269147551}, // 14335K
			{0.26514298, 0.269144598}, // 14336K
			{0.265140696, 0.269141646}, // 14337K
			{0.265138412, 0.269138695}, // 14338K
			{0.265136129, 0.269135744}, // 14339K
			{0.265133846, 0.269132793}, // 14340K
			{0.265131563, 0.269129843}, // 14341K
			{0.265129281, 0.269126893}, // 14342K
			{0.265126999, 0.269123944}, // 14343K
			{0.265124718, 0.269120995}, // 14344K
			{0.265122437, 0.269118047}, // 14345K
			{0.265120157, 0.269115099}, // 14346K
			{0.265117876, 0.269112151}, // 14347K
			{0.265115596, 0.269109204}, // 14348K
			{0.265113317, 0.269106258}, // 14349K
			{0.265111038, 0.269103312}, // 14350K
			{0.265108759, 0.269100366}, // 14351K
			{0.265106481, 0.269097421}, // 14352K
			{0.265104203, 0.269094476}, // 14353K
			{0.265101926, 0.269091532}, // 14354K
			{0.265099649, 0.269088588}, // 14355K
			{0.265097372, 0.269085645}, // 14356K
			{0.265095096, 0.269082702}, // 14357K
			{0.26509282, 0.26907976}, // 14358K
			{0.265090544, 0.269076818}, // 14359K
			{0.265088269, 0.269073876}, // 14360K
			{0.265085994, 0.269070935}, // 14361K
			{0.26508372, 0.269067995}, // 14362K
			{0.265081446, 0.269065055}, // 14363K
			{0.265079172, 0.269062115}, // 14364K
			{0.265076899, 0.269059176}, // 14365K
			{0.265074626, 0.269056237}, // 14366K
			{0.265072353, 0.269053299}, // 14367K
			{0.265070081, 0.269050361}, // 14368K
			{0.26506781, 0.269047424}, // 14369K
			{0.265065538, 0.269044487}, // 14370K
			{0.265063267, 0.269041551}, // 14371K
			{0.265060997, 0.269038615}, // 14372K
			{0.265058727, 0.26903568}, // 14373K
			{0.265056457, 0.269032745}, // 14374K
			{0.265054187, 0.26902981}, // 14375K
			{0.265051918, 0.269026876}, // 14376K
			{0.26504965, 0.269023942}, // 14377K
			{0.265047382, 0.269021009}, // 14378K
			{0.265045114, 0.269018076}, // 14379K
			{0.265042846, 0.269015144}, // 14380K
			{0.265040579, 0.269012212}, // 14381K
			{0.265038312, 0.269009281}, // 14382K
			{0.265036046, 0.26900635}, // 14383K
			{0.26503378, 0.26900342}, // 14384K
			{0.265031515, 0.26900049}, // 14385K
			{0.26502925, 0.26899756}, // 14386K
			{0.265026985, 0.268994631}, // 14387K
			{0.26502472, 0.268991703}, // 14388K
			{0.265022456, 0.268988775}, // 14389K
			{0.265020193, 0.268985847}, // 14390K
			{0.265017929, 0.26898292}, // 14391K
			{0.265015667, 0.268979993}, // 14392K
			{0.265013404, 0.268977067}, // 14393K
			{0.265011142, 0.268974141}, // 14394K
			{0.26500888, 0.268971215}, // 14395K
			{0.265006619, 0.26896829}, // 14396K
			{0.265004358, 0.268965366}, // 14397K
			{0.265002098, 0.268962442}, // 14398K
			{0.264999837, 0.268959518}, // 14399K
			{0.264997578, 0.268956595}, // 14400K
			{0.264995318, 0.268953673}, // 14401K
			{0.264993059, 0.268950751}, // 14402K
			{0.2649908, 0.268947829}, // 14403K
			{0.264988542, 0.268944908}, // 14404K
			{0.264986284, 0.268941987}, // 14405K
			{0.264984027, 0.268939066}, // 14406K
			{0.26498177, 0.268936146}, // 14407K
			{0.264979513, 0.268933227}, // 14408K
			{0.264977257, 0.268930308}, // 14409K
			{0.264975001, 0.268927389}, // 14410K
			{0.264972745, 0.268924471}, // 14411K
			{0.26497049, 0.268921554}, // 14412K
			{0.264968235, 0.268918637}, // 14413K
			{0.264965981, 0.26891572}, // 14414K
			{0.264963727, 0.268912804}, // 14415K
			{0.264961473, 0.268909888}, // 14416K
			{0.26495922, 0.268906973}, // 14417K
			{0.264956967, 0.268904058}, // 14418K
			{0.264954714, 0.268901143}, // 14419K
			{0.264952462, 0.268898229}, // 14420K
			{0.26495021, 0.268895316}, // 14421K
			{0.264947959, 0.268892403}, // 14422K
			{0.264945708, 0.26888949}, // 14423K
			{0.264943457, 0.268886578}, // 14424K
			{0.264941207, 0.268883666}, // 14425K
			{0.264938957, 0.268880755}, // 14426K
			{0.264936708, 0.268877844}, // 14427K
			{0.264934458, 0.268874934}, // 14428K
			{0.26493221, 0.268872024}, // 14429K
			{0.264929961, 0.268869114}, // 14430K
			{0.264927713, 0.268866205}, // 14431K
			{0.264925466, 0.268863297}, // 14432K
			{0.264923219, 0.268860389}, // 14433K
			{0.264920972, 0.268857481}, // 14434K
			{0.264918725, 0.268854574}, // 14435K
			{0.264916479, 0.268851667}, // 14436K
			{0.264914233, 0.268848761}, // 14437K
			{0.264911988, 0.268845855}, // 14438K
			{0.264909743, 0.26884295}, // 14439K
			{0.264907499, 0.268840045}, // 14440K
			{0.264905255, 0.26883714}, // 14441K
			{0.264903011, 0.268834236}, // 14442K
			{0.264900767, 0.268831333}, // 14443K
			{0.264898524, 0.26882843}, // 14444K
			{0.264896282, 0.268825527}, // 14445K
			{0.264894039, 0.268822625}, // 14446K
			{0.264891797, 0.268819723}, // 14447K
			{0.264889556, 0.268816822}, // 14448K
			{0.264887315, 0.268813921}, // 14449K
			{0.264885074, 0.268811021}, // 14450K
			{0.264882834, 0.268808121}, // 14451K
			{0.264880594, 0.268805221}, // 14452K
			{0.264878354, 0.268802322}, // 14453K
			{0.264876115, 0.268799424}, // 14454K
			{0.264873876, 0.268796526}, // 14455K
			{0.264871637, 0.268793628}, // 14456K
			{0.264869399, 0.268790731}, // 14457K
			{0.264867161, 0.268787834}, // 14458K
			{0.264864924, 0.268784938}, // 14459K
			{0.264862687, 0.268782042}, // 14460K
			{0.26486045, 0.268779146}, // 14461K
			{0.264858214, 0.268776251}, // 14462K
			{0.264855978, 0.268773357}, // 14463K
			{0.264853743, 0.268770463}, // 14464K
			{0.264851508, 0.268767569}, // 14465K
			{0.264849273, 0.268764676}, // 14466K
			{0.264847039, 0.268761783}, // 14467K
			{0.264844805, 0.268758891}, // 14468K
			{0.264842571, 0.268755999}, // 14469K
			{0.264840338, 0.268753108}, // 14470K
			{0.264838105, 0.268750217}, // 14471K
			{0.264835873, 0.268747326}, // 14472K
			{0.26483364, 0.268744436}, // 14473K
			{0.264831409, 0.268741547}, // 14474K
			{0.264829177, 0.268738658}, // 14475K
			{0.264826946, 0.268735769}, // 14476K
			{0.264824716, 0.268732881}, // 14477K
			{0.264822486, 0.268729993}, // 14478K
			{0.264820256, 0.268727106}, // 14479K
			{0.264818026, 0.268724219}, // 14480K
			{0.264815797, 0.268721332}, // 14481K
			{0.264813568, 0.268718446}, // 14482K
			{0.26481134, 0.268715561}, // 14483K
			{0.264809112, 0.268712676}, // 14484K
			{0.264806885, 0.268709791}, // 14485K
			{0.264804657, 0.268706907}, // 14486K
			{0.264802431, 0.268704023}, // 14487K
			{0.264800204, 0.26870114}, // 14488K
			{0.264797978, 0.268698257}, // 14489K
			{0.264795752, 0.268695375}, // 14490K
			{0.264793527, 0.268692493}, // 14491K
			{0.264791302, 0.268689611}, // 14492K
			{0.264789077, 0.26868673}, // 14493K
			{0.264786853, 0.268683849}, // 14494K
			{0.264784629, 0.268680969}, // 14495K
			{0.264782406, 0.26867809}, // 14496K
			{0.264780183, 0.26867521}, // 14497K
			{0.26477796, 0.268672331}, // 14498K
			{0.264775738, 0.268669453}, // 14499K
			{0.264773516, 0.268666575}, // 14500K
			{0.264771294, 0.268663698}, // 14501K
			{0.264769073, 0.268660821}, // 14502K
			{0.264766852, 0.268657944}, // 14503K
			{0.264764632, 0.268655068}, // 14504K
			{0.264762411, 0.268652192}, // 14505K
			{0.264760192, 0.268649317}, // 14506K
			{0.264757972, 0.268646442}, // 14507K
			{0.264755753, 0.268643568}, // 14508K
			{0.264753535, 0.268640694}, // 14509K
			{0.264751316, 0.26863782}, // 14510K
			{0.264749099, 0.268634947}, // 14511K
			{0.264746881, 0.268632075}, // 14512K
			{0.264744664, 0.268629203}, // 14513K
			{0.264742447, 0.268626331}, // 14514K
			{0.264740231, 0.26862346}, // 14515K
			{0.264738015, 0.268620589}, // 14516K
			{0.264735799, 0.268617719}, // 14517K
			{0.264733584, 0.268614849}, // 14518K
			{0.264731369, 0.268611979}, // 14519K
			{0.264729155, 0.26860911}, // 14520K
			{0.26472694, 0.268606242}, // 14521K
			{0.264724727, 0.268603374}, // 14522K
			{0.264722513, 0.268600506}, // 14523K
			{0.2647203, 0.268597639}, // 14524K
			{0.264718088, 0.268594772}, // 14525K
			{0.264715875, 0.268591906}, // 14526K
			{0.264713663, 0.26858904}, // 14527K
			{0.264711452, 0.268586174}, // 14528K
			{0.264709241, 0.268583309}, // 14529K
			{0.26470703, 0.268580445}, // 14530K
			{0.264704819, 0.268577581}, // 14531K
			{0.264702609, 0.268574717}, // 14532K
			{0.2647004, 0.268571854}, // 14533K
			{0.26469819, 0.268568991}, // 14534K
			{0.264695981, 0.268566129}, // 14535K
			{0.264693773, 0.268563267}, // 14536K
			{0.264691565, 0.268560405}, // 14537K
			{0.264689357, 0.268557544}, // 14538K
			{0.264687149, 0.268554684}, // 14539K
			{0.264684942, 0.268551823}, // 14540K
			{0.264682735, 0.268548964}, // 14541K
			{0.264680529, 0.268546104}, // 14542K
			{0.264678323, 0.268543246}, // 14543K
			{0.264676117, 0.268540387}, // 14544K
			{0.264673912, 0.268537529}, // 14545K
			{0.264671707, 0.268534672}, // 14546K
			{0.264669503, 0.268531815}, // 14547K
			{0.264667299, 0.268528958}, // 14548K
			{0.264665095, 0.268526102}, // 14549K
			{0.264662891, 0.268523246}, // 14550K
			{0.264660688, 0.268520391}, // 14551K
			{0.264658486, 0.268517536}, // 14552K
			{0.264656283, 0.268514682}, // 14553K
			{0.264654081, 0.268511828}, // 14554K
			{0.26465188, 0.268508974}, // 14555K
			{0.264649679, 0.268506121}, // 14556K
			{0.264647478, 0.268503269}, // 14557K
			{0.264645277, 0.268500417}, // 14558K
			{0.264643077, 0.268497565}, // 14559K
			{0.264640878, 0.268494714}, // 14560K
			{0.264638678, 0.268491863}, // 14561K
			{0.264636479, 0.268489012}, // 14562K
			{0.264634281, 0.268486162}, // 14563K
			{0.264632082, 0.268483313}, // 14564K
			{0.264629885, 0.268480464}, // 14565K
			{0.264627687, 0.268477615}, // 14566K
			{0.26462549, 0.268474767}, // 14567K
			{0.264623293, 0.268471919}, // 14568K
			{0.264621097, 0.268469072}, // 14569K
			{0.264618901, 0.268466225}, // 14570K
			{0.264616705, 0.268463378}, // 14571K
			{0.26461451, 0.268460532}, // 14572K
			{0.264612315, 0.268457687}, // 14573K
			{0.26461012, 0.268454842}, // 14574K
			{0.264607926, 0.268451997}, // 14575K
			{0.264605732, 0.268449153}, // 14576K
			{0.264603539, 0.268446309}, // 14577K
			{0.264601346, 0.268443466}, // 14578K
			{0.264599153, 0.268440623}, // 14579K
			{0.264596961, 0.26843778}, // 14580K
			{0.264594768, 0.268434938}, // 14581K
			{0.264592577, 0.268432096}, // 14582K
			{0.264590386, 0.268429255}, // 14583K
			{0.264588195, 0.268426414}, // 14584K
			{0.264586004, 0.268423574}, // 14585K
			{0.264583814, 0.268420734}, // 14586K
			{0.264581624, 0.268417895}, // 14587K
			{0.264579435, 0.268415056}, // 14588K
			{0.264577246, 0.268412217}, // 14589K
			{0.264575057, 0.268409379}, // 14590K
			{0.264572869, 0.268406542}, // 14591K
			{0.264570681, 0.268403704}, // 14592K
			{0.264568493, 0.268400867}, // 14593K
			{0.264566306, 0.268398031}, // 14594K
			{0.264564119, 0.268395195}, // 14595K
			{0.264561932, 0.26839236}, // 14596K
			{0.264559746, 0.268389525}, // 14597K
			{0.26455756, 0.26838669}, // 14598K
			{0.264555375, 0.268383856}, // 14599K
			{0.26455319, 0.268381022}, // 14600K
			{0.264551005, 0.268378189}, // 14601K
			{0.264548821, 0.268375356}, // 14602K
			{0.264546637, 0.268372524}, // 14603K
			{0.264544453, 0.268369692}, // 14604K
			{0.26454227, 0.26836686}, // 14605K
			{0.264540087, 0.268364029}, // 14606K
			{0.264537905, 0.268361198}, // 14607K
			{0.264535723, 0.268358368}, // 14608K
			{0.264533541, 0.268355538}, // 14609K
			{0.264531359, 0.268352709}, // 14610K
			{0.264529178, 0.26834988}, // 14611K
			{0.264526998, 0.268347051}, // 14612K
			{0.264524817, 0.268344223}, // 14613K
			{0.264522637, 0.268341396}, // 14614K
			{0.264520458, 0.268338568}, // 14615K
			{0.264518279, 0.268335742}, // 14616K
			{0.2645161, 0.268332915}, // 14617K
			{0.264513921, 0.268330089}, // 14618K
			{0.264511743, 0.268327264}, // 14619K
			{0.264509565, 0.268324439}, // 14620K
			{0.264507388, 0.268321614}, // 14621K
			{0.264505211, 0.26831879}, // 14622K
			{0.264503034, 0.268315967}, // 14623K
			{0.264500858, 0.268313143}, // 14624K
			{0.264498682, 0.26831032}, // 14625K
			{0.264496506, 0.268307498}, // 14626K
			{0.264494331, 0.268304676}, // 14627K
			{0.264492156, 0.268301855}, // 14628K
			{0.264489982, 0.268299033}, // 14629K
			{0.264487807, 0.268296213}, // 14630K
			{0.264485634, 0.268293393}, // 14631K
			{0.26448346, 0.268290573}, // 14632K
			{0.264481287, 0.268287753}, // 14633K
			{0.264479114, 0.268284934}, // 14634K
			{0.264476942, 0.268282116}, // 14635K
			{0.26447477, 0.268279298}, // 14636K
			{0.264472598, 0.26827648}, // 14637K
			{0.264470427, 0.268273663}, // 14638K
			{0.264468256, 0.268270846}, // 14639K
			{0.264466086, 0.26826803}, // 14640K
			{0.264463916, 0.268265214}, // 14641K
			{0.264461746, 0.268262399}, // 14642K
			{0.264459576, 0.268259584}, // 14643K
			{0.264457407, 0.268256769}, // 14644K
			{0.264455239, 0.268253955}, // 14645K
			{0.26445307, 0.268251141}, // 14646K
			{0.264450902, 0.268248328}, // 14647K
			{0.264448735, 0.268245515}, // 14648K
			{0.264446567, 0.268242702}, // 14649K
			{0.2644444, 0.26823989}, // 14650K
			{0.264442234, 0.268237079}, // 14651K
			{0.264440068, 0.268234268}, // 14652K
			{0.264437902, 0.268231457}, // 14653K
			{0.264435736, 0.268228647}, // 14654K
			{0.264433571, 0.268225837}, // 14655K
			{0.264431406, 0.268223027}, // 14656K
			{0.264429242, 0.268220218}, // 14657K
			{0.264427078, 0.26821741}, // 14658K
			{0.264424914, 0.268214602}, // 14659K
			{0.264422751, 0.268211794}, // 14660K
			{0.264420588, 0.268208987}, // 14661K
			{0.264418425, 0.26820618}, // 14662K
			{0.264416263, 0.268203374}, // 14663K
			{0.264414101, 0.268200568}, // 14664K
			{0.26441194, 0.268197762}, // 14665K
			{0.264409778, 0.268194957}, // 14666K
			{0.264407618, 0.268192152}, // 14667K
			{0.264405457, 0.268189348}, // 14668K
			{0.264403297, 0.268186544}, // 14669K
			{0.264401137, 0.268183741}, // 14670K
			{0.264398978, 0.268180938}, // 14671K
			{0.264396819, 0.268178135}, // 14672K
			{0.26439466, 0.268175333}, // 14673K
			{0.264392502, 0.268172532}, // 14674K
			{0.264390344, 0.26816973}, // 14675K
			{0.264388186, 0.26816693}, // 14676K
			{0.264386029, 0.268164129}, // 14677K
			{0.264383872, 0.268161329}, // 14678K
			{0.264381716, 0.26815853}, // 14679K
			{0.26437956, 0.268155731}, // 14680K
			{0.264377404, 0.268152932}, // 14681K
			{0.264375248, 0.268150134}, // 14682K
			{0.264373093, 0.268147336}, // 14683K
			{0.264370939, 0.268144539}, // 14684K
			{0.264368784, 0.268141742}, // 14685K
			{0.26436663, 0.268138945}, // 14686K
			{0.264364477, 0.268136149}, // 14687K
			{0.264362323, 0.268133354}, // 14688K
			{0.26436017, 0.268130558}, // 14689K
			{0.264358018, 0.268127764}, // 14690K
			{0.264355866, 0.268124969}, // 14691K
			{0.264353714, 0.268122175}, // 14692K
			{0.264351562, 0.268119382}, // 14693K
			{0.264349411, 0.268116589}, // 14694K
			{0.26434726, 0.268113796}, // 14695K
			{0.26434511, 0.268111004}, // 14696K
			{0.26434296, 0.268108212}, // 14697K
			{0.26434081, 0.268105421}, // 14698K
			{0.264338661, 0.26810263}, // 14699K
			{0.264336512, 0.268099839}, // 14700K
			{0.264334363, 0.268097049}, // 14701K
			{0.264332215, 0.26809426}, // 14702K
			{0.264330067, 0.26809147}, // 14703K
			{0.264327919, 0.268088682}, // 14704K
			{0.264325772, 0.268085893}, // 14705K
			{0.264323625, 0.268083105}, // 14706K
			{0.264321479, 0.268080318}, // 14707K
			{0.264319332, 0.268077531}, // 14708K
			{0.264317187, 0.268074744}, // 14709K
			{0.264315041, 0.268071958}, // 14710K
			{0.264312896, 0.268069172}, // 14711K
			{0.264310751, 0.268066386}, // 14712K
			{0.264308607, 0.268063602}, // 14713K
			{0.264306463, 0.268060817}, // 14714K
			{0.264304319, 0.268058033}, // 14715K
			{0.264302176, 0.268055249}, // 14716K
			{0.264300033, 0.268052466}, // 14717K
			{0.26429789, 0.268049683}, // 14718K
			{0.264295748, 0.268046901}, // 14719K
			{0.264293606, 0.268044119}, // 14720K
			{0.264291464, 0.268041337}, // 14721K
			{0.264289323, 0.268038556}, // 14722K
			{0.264287182, 0.268035775}, // 14723K
			{0.264285042, 0.268032995}, // 14724K
			{0.264282902, 0.268030215}, // 14725K
			{0.264280762, 0.268027436}, // 14726K
			{0.264278623, 0.268024657}, // 14727K
			{0.264276484, 0.268021878}, // 14728K
			{0.264274345, 0.2680191}, // 14729K
			{0.264272206, 0.268016322}, // 14730K
			{0.264270068, 0.268013545}, // 14731K
			{0.264267931, 0.268010768}, // 14732K
			{0.264265793, 0.268007992}, // 14733K
			{0.264263657, 0.268005216}, // 14734K
			{0.26426152, 0.26800244}, // 14735K
			{0.264259384, 0.267999665}, // 14736K
			{0.264257248, 0.26799689}, // 14737K
			{0.264255112, 0.267994116}, // 14738K
			{0.264252977, 0.267991342}, // 14739K
			{0.264250842, 0.267988569}, // 14740K
			{0.264248708, 0.267985796}, // 14741K
			{0.264246574, 0.267983023}, // 14742K
			{0.26424444, 0.267980251}, // 14743K
			{0.264242306, 0.267977479}, // 14744K
			{0.264240173, 0.267974708}, // 14745K
			{0.264238041, 0.267971937}, // 14746K
			{0.264235908, 0.267969166}, // 14747K
			{0.264233776, 0.267966396}, // 14748K
			{0.264231645, 0.267963626}, // 14749K
			{0.264229513, 0.267960857}, // 14750K
			{0.264227382, 0.267958088}, // 14751K
			{0.264225252, 0.26795532}, // 14752K
			{0.264223121, 0.267952552}, // 14753K
			{0.264220992, 0.267949784}, // 14754K
			{0.264218862, 0.267947017}, // 14755K
			{0.264216733, 0.26794425}, // 14756K
			{0.264214604, 0.267941484}, // 14757K
			{0.264212475, 0.267938718}, // 14758K
			{0.264210347, 0.267935953}, // 14759K
			{0.26420822, 0.267933188}, // 14760K
			{0.264206092, 0.267930423}, // 14761K
			{0.264203965, 0.267927659}, // 14762K
			{0.264201838, 0.267924895}, // 14763K
			{0.264199712, 0.267922132}, // 14764K
			{0.264197586, 0.267919369}, // 14765K
			{0.26419546, 0.267916607}, // 14766K
			{0.264193335, 0.267913845}, // 14767K
			{0.26419121, 0.267911083}, // 14768K
			{0.264189085, 0.267908322}, // 14769K
			{0.264186961, 0.267905561}, // 14770K
			{0.264184837, 0.267902801}, // 14771K
			{0.264182713, 0.267900041}, // 14772K
			{0.26418059, 0.267897281}, // 14773K
			{0.264178467, 0.267894522}, // 14774K
			{0.264176345, 0.267891763}, // 14775K
			{0.264174223, 0.267889005}, // 14776K
			{0.264172101, 0.267886247}, // 14777K
			{0.264169979, 0.26788349}, // 14778K
			{0.264167858, 0.267880733}, // 14779K
			{0.264165737, 0.267877976}, // 14780K
			{0.264163617, 0.26787522}, // 14781K
			{0.264161497, 0.267872464}, // 14782K
			{0.264159377, 0.267869709}, // 14783K
			{0.264157258, 0.267866954}, // 14784K
			{0.264155139, 0.267864199}, // 14785K
			{0.26415302, 0.267861445}, // 14786K
			{0.264150902, 0.267858692}, // 14787K
			{0.264148784, 0.267855938}, // 14788K
			{0.264146666, 0.267853186}, // 14789K
			{0.264144549, 0.267850433}, // 14790K
			{0.264142432, 0.267847681}, // 14791K
			{0.264140315, 0.26784493}, // 14792K
			{0.264138199, 0.267842179}, // 14793K
			{0.264136083, 0.267839428}, // 14794K
			{0.264133967, 0.267836678}, // 14795K
			{0.264131852, 0.267833928}, // 14796K
			{0.264129737, 0.267831178}, // 14797K
			{0.264127623, 0.267828429}, // 14798K
			{0.264125509, 0.26782568}, // 14799K
			{0.264123395, 0.267822932}, // 14800K
			{0.264121281, 0.267820184}, // 14801K
			{0.264119168, 0.267817437}, // 14802K
			{0.264117055, 0.26781469}, // 14803K
			{0.264114943, 0.267811944}, // 14804K
			{0.264112831, 0.267809198}, // 14805K
			{0.264110719, 0.267806452}, // 14806K
			{0.264108608, 0.267803707}, // 14807K
			{0.264106497, 0.267800962}, // 14808K
			{0.264104386, 0.267798217}, // 14809K
			{0.264102276, 0.267795473}, // 14810K
			{0.264100166, 0.26779273}, // 14811K
			{0.264098056, 0.267789986}, // 14812K
			{0.264095947, 0.267787244}, // 14813K
			{0.264093838, 0.267784501}, // 14814K
			{0.264091729, 0.267781759}, // 14815K
			{0.264089621, 0.267779018}, // 14816K
			{0.264087513, 0.267776277}, // 14817K
			{0.264085405, 0.267773536}, // 14818K
			{0.264083298, 0.267770796}, // 14819K
			{0.264081191, 0.267768056}, // 14820K
			{0.264079085, 0.267765316}, // 14821K
			{0.264076979, 0.267762577}, // 14822K
			{0.264074873, 0.267759839}, // 14823K
			{0.264072767, 0.267757101}, // 14824K
			{0.264070662, 0.267754363}, // 14825K
			{0.264068557, 0.267751625}, // 14826K
			{0.264066453, 0.267748889}, // 14827K
			{0.264064349, 0.267746152}, // 14828K
			{0.264062245, 0.267743416}, // 14829K
			{0.264060142, 0.26774068}, // 14830K
			{0.264058039, 0.267737945}, // 14831K
			{0.264055936, 0.26773521}, // 14832K
			{0.264053833, 0.267732476}, // 14833K
			{0.264051731, 0.267729742}, // 14834K
			{0.26404963, 0.267727008}, // 14835K
			{0.264047528, 0.267724275}, // 14836K
			{0.264045427, 0.267721542}, // 14837K
			{0.264043327, 0.26771881}, // 14838K
			{0.264041226, 0.267716078}, // 14839K
			{0.264039126, 0.267713346}, // 14840K
			{0.264037027, 0.267710615}, // 14841K
			{0.264034928, 0.267707884}, // 14842K
			{0.264032829, 0.267705154}, // 14843K
			{0.26403073, 0.267702424}, // 14844K
			{0.264028632, 0.267699695}, // 14845K
			{0.264026534, 0.267696966}, // 14846K
			{0.264024436, 0.267694237}, // 14847K
			{0.264022339, 0.267691509}, // 14848K
			{0.264020242, 0.267688781}, // 14849K
			{0.264018146, 0.267686053}, // 14850K
			{0.26401605, 0.267683327}, // 14851K
			{0.264013954, 0.2676806}, // 14852K
			{0.264011858, 0.267677874}, // 14853K
			{0.264009763, 0.267675148}, // 14854K
			{0.264007668, 0.267672423}, // 14855K
			{0.264005574, 0.267669698}, // 14856K
			{0.26400348, 0.267666973}, // 14857K
			{0.264001386, 0.267664249}, // 14858K
			{0.263999292, 0.267661526}, // 14859K
			{0.263997199, 0.267658802}, // 14860K
			{0.263995107, 0.267656079}, // 14861K
			{0.263993014, 0.267653357}, // 14862K
			{0.263990922, 0.267650635}, // 14863K
			{0.26398883, 0.267647913}, // 14864K
			{0.263986739, 0.267645192}, // 14865K
			{0.263984648, 0.267642471}, // 14866K
			{0.263982557, 0.267639751}, // 14867K
			{0.263980467, 0.267637031}, // 14868K
			{0.263978377, 0.267634311}, // 14869K
			{0.263976287, 0.267631592}, // 14870K
			{0.263974198, 0.267628874}, // 14871K
			{0.263972109, 0.267626155}, // 14872K
			{0.26397002, 0.267623437}, // 14873K
			{0.263967932, 0.26762072}, // 14874K
			{0.263965844, 0.267618003}, // 14875K
			{0.263963756, 0.267615286}, // 14876K
			{0.263961669, 0.26761257}, // 14877K
			{0.263959582, 0.267609854}, // 14878K
			{0.263957496, 0.267607139}, // 14879K
			{0.263955409, 0.267604424}, // 14880K
			{0.263953323, 0.267601709}, // 14881K
			{0.263951238, 0.267598995}, // 14882K
			{0.263949153, 0.267596281}, // 14883K
			{0.263947068, 0.267593568}, // 14884K
			{0.263944983, 0.267590855}, // 14885K
			{0.263942899, 0.267588142}, // 14886K
			{0.263940815, 0.26758543}, // 14887K
			{0.263938732, 0.267582718}, // 14888K
			{0.263936649, 0.267580007}, // 14889K
			{0.263934566, 0.267577296}, // 14890K
			{0.263932483, 0.267574586}, // 14891K
			{0.263930401, 0.267571875}, // 14892K
			{0.263928319, 0.267569166}, // 14893K
			{0.263926238, 0.267566456}, // 14894K
			{0.263924157, 0.267563748}, // 14895K
			{0.263922076, 0.267561039}, // 14896K
			{0.263919995, 0.267558331}, // 14897K
			{0.263917915, 0.267555624}, // 14898K
			{0.263915835, 0.267552916}, // 14899K
			{0.263913756, 0.267550209}, // 14900K
			{0.263911677, 0.267547503}, // 14901K
			{0.263909598, 0.267544797}, // 14902K
			{0.26390752, 0.267542092}, // 14903K
			{0.263905442, 0.267539386}, // 14904K
			{0.263903364, 0.267536682}, // 14905K
			{0.263901286, 0.267533977}, // 14906K
			{0.263899209, 0.267531273}, // 14907K
			{0.263897133, 0.26752857}, // 14908K
			{0.263895056, 0.267525867}, // 14909K
			{0.26389298, 0.267523164}, // 14910K
			{0.263890905, 0.267520462}, // 14911K
			{0.263888829, 0.26751776}, // 14912K
			{0.263886754, 0.267515058}, // 14913K
			{0.263884679, 0.267512357}, // 14914K
			{0.263882605, 0.267509656}, // 14915K
			{0.263880531, 0.267506956}, // 14916K
			{0.263878457, 0.267504256}, // 14917K
			{0.263876384, 0.267501557}, // 14918K
			{0.263874311, 0.267498858}, // 14919K
			{0.263872238, 0.267496159}, // 14920K
			{0.263870166, 0.267493461}, // 14921K
			{0.263868094, 0.267490763}, // 14922K
			{0.263866022, 0.267488066}, // 14923K
			{0.263863951, 0.267485369}, // 14924K
			{0.26386188, 0.267482672}, // 14925K
			{0.26385981, 0.267479976}, // 14926K
			{0.263857739, 0.26747728}, // 14927K
			{0.263855669, 0.267474585}, // 14928K
			{0.2638536, 0.26747189}, // 14929K
			{0.26385153, 0.267469195}, // 14930K
			{0.263849461, 0.267466501}, // 14931K
			{0.263847393, 0.267463807}, // 14932K
			{0.263845325, 0.267461114}, // 14933K
			{0.263843257, 0.267458421}, // 14934K
			{0.263841189, 0.267455728}, // 14935K
			{0.263839122, 0.267453036}, // 14936K
			{0.263837055, 0.267450345}, // 14937K
			{0.263834988, 0.267447653}, // 14938K
			{0.263832922, 0.267444962}, // 14939K
			{0.263830856, 0.267442272}, // 14940K
			{0.263828791, 0.267439582}, // 14941K
			{0.263826725, 0.267436892}, // 14942K
			{0.26382466, 0.267434203}, // 14943K
			{0.263822596, 0.267431514}, // 14944K
			{0.263820532, 0.267428825}, // 14945K
			{0.263818468, 0.267426137}, // 14946K
			{0.263816404, 0.26742345}, // 14947K
			{0.263814341, 0.267420762}, // 14948K
			{0.263812278, 0.267418076}, // 14949K
			{0.263810215, 0.267415389}, // 14950K
			{0.263808153, 0.267412703}, // 14951K
			{0.263806091, 0.267410017}, // 14952K
			{0.26380403, 0.267407332}, // 14953K
			{0.263801969, 0.267404647}, // 14954K
			{0.263799908, 0.267401963}, // 14955K
			{0.263797847, 0.267399279}, // 14956K
			{0.263795787, 0.267396595}, // 14957K
			{0.263793727, 0.267393912}, // 14958K
			{0.263791668, 0.267391229}, // 14959K
			{0.263789608, 0.267388547}, // 14960K
			{0.26378755, 0.267385865}, // 14961K
			{0.263785491, 0.267383183}, // 14962K
			{0.263783433, 0.267380502}, // 14963K
			{0.263781375, 0.267377821}, // 14964K
			{0.263779317, 0.267375141}, // 14965K
			{0.26377726, 0.267372461}, // 14966K
			{0.263775203, 0.267369782}, // 14967K
			{0.263773147, 0.267367102}, // 14968K
			{0.263771091, 0.267364424}, // 14969K
			{0.263769035, 0.267361745}, // 14970K
			{0.263766979, 0.267359067}, // 14971K
			{0.263764924, 0.26735639}, // 14972K
			{0.263762869, 0.267353713}, // 14973K
			{0.263760815, 0.267351036}, // 14974K
			{0.263758761, 0.267348359}, // 14975K
			{0.263756707, 0.267345684}, // 14976K
			{0.263754653, 0.267343008}, // 14977K
			{0.2637526, 0.267340333}, // 14978K
			{0.263750547, 0.267337658}, // 14979K
			{0.263748495, 0.267334984}, // 14980K
			{0.263746443, 0.26733231}, // 14981K
			{0.263744391, 0.267329636}, // 14982K
			{0.263742339, 0.267326963}, // 14983K
			{0.263740288, 0.267324291}, // 14984K
			{0.263738237, 0.267321618}, // 14985K
			{0.263736187, 0.267318946}, // 14986K
			{0.263734136, 0.267316275}, // 14987K
			{0.263732087, 0.267313604}, // 14988K
			{0.263730037, 0.267310933}, // 14989K
			{0.263727988, 0.267308263}, // 14990K
			{0.263725939, 0.267305593}, // 14991K
			{0.263723891, 0.267302923}, // 14992K
			{0.263721842, 0.267300254}, // 14993K
			{0.263719794, 0.267297585}, // 14994K
			{0.263717747, 0.267294917}, // 14995K
			{0.2637157, 0.267292249}, // 14996K
			{0.263713653, 0.267289582}, // 14997K
			{0.263711606, 0.267286915}, // 14998K
			{0.26370956, 0.267284248}, // 14999K
			{0.263707514, 0.267281582}, // 15000K
			{0.263705469, 0.267278916}, // 15001K
			{0.263703424, 0.26727625}, // 15002K
			{0.263701379, 0.267273585}, // 15003K
			{0.263699334, 0.26727092}, // 15004K
			{0.26369729, 0.267268256}, // 15005K
			{0.263695246, 0.267265592}, // 15006K
			{0.263693203, 0.267262929}, // 15007K
			{0.263691159, 0.267260266}, // 15008K
			{0.263689117, 0.267257603}, // 15009K
			{0.263687074, 0.267254941}, // 15010K
			{0.263685032, 0.267252279}, // 15011K
			{0.26368299, 0.267249617}, // 15012K
			{0.263680948, 0.267246956}, // 15013K
			{0.263678907, 0.267244296}, // 15014K
			{0.263676866, 0.267241635}, // 15015K
			{0.263674826, 0.267238975}, // 15016K
			{0.263672785, 0.267236316}, // 15017K
			{0.263670746, 0.267233657}, // 15018K
			{0.263668706, 0.267230998}, // 15019K
			{0.263666667, 0.26722834}, // 15020K
			{0.263664628, 0.267225682}, // 15021K
			{0.263662589, 0.267223024}, // 15022K
			{0.263660551, 0.267220367}, // 15023K
			{0.263658513, 0.267217711}, // 15024K
			{0.263656476, 0.267215054}, // 15025K
			{0.263654438, 0.267212398}, // 15026K
			{0.263652401, 0.267209743}, // 15027K
			{0.263650365, 0.267207088}, // 15028K
			{0.263648328, 0.267204433}, // 15029K
			{0.263646293, 0.267201779}, // 15030K
			{0.263644257, 0.267199125}, // 15031K
			{0.263642222, 0.267196471}, // 15032K
			{0.263640187, 0.267193818}, // 15033K
			{0.263638152, 0.267191166}, // 15034K
			{0.263636118, 0.267188513}, // 15035K
			{0.263634084, 0.267185861}, // 15036K
			{0.26363205, 0.26718321}, // 15037K
			{0.263630017, 0.267180559}, // 15038K
			{0.263627984, 0.267177908}, // 15039K
			{0.263625951, 0.267175258}, // 15040K
			{0.263623919, 0.267172608}, // 15041K
			{0.263621887, 0.267169958}, // 15042K
			{0.263619855, 0.267167309}, // 15043K
			{0.263617824, 0.26716466}, // 15044K
			{0.263615793, 0.267162012}, // 15045K
			{0.263613762, 0.267159364}, // 15046K
			{0.263611732, 0.267156716}, // 15047K
			{0.263609702, 0.267154069}, // 15048K
			{0.263607672, 0.267151422}, // 15049K
			{0.263605643, 0.267148776}, // 15050K
			{0.263603614, 0.26714613}, // 15051K
			{0.263601585, 0.267143485}, // 15052K
			{0.263599557, 0.267140839}, // 15053K
			{0.263597529, 0.267138195}, // 15054K
			{0.263595501, 0.26713555}, // 15055K
			{0.263593474, 0.267132906}, // 15056K
			{0.263591447, 0.267130263}, // 15057K
			{0.26358942, 0.267127619}, // 15058K
			{0.263587393, 0.267124977}, // 15059K
			{0.263585367, 0.267122334}, // 15060K
			{0.263583342, 0.267119692}, // 15061K
			{0.263581316, 0.267117051}, // 15062K
			{0.263579291, 0.267114409}, // 15063K
			{0.263577266, 0.267111769}, // 15064K
			{0.263575242, 0.267109128}, // 15065K
			{0.263573218, 0.267106488}, // 15066K
			{0.263571194, 0.267103849}, // 15067K
			{0.26356917, 0.267101209}, // 15068K
			{0.263567147, 0.267098571}, // 15069K
			{0.263565124, 0.267095932}, // 15070K
			{0.263563102, 0.267093294}, // 15071K
			{0.26356108, 0.267090656}, // 15072K
			{0.263559058, 0.267088019}, // 15073K
			{0.263557036, 0.267085382}, // 15074K
			{0.263555015, 0.267082746}, // 15075K
			{0.263552994, 0.26708011}, // 15076K
			{0.263550974, 0.267077474}, // 15077K
			{0.263548954, 0.267074839}, // 15078K
			{0.263546934, 0.267072204}, // 15079K
			{0.263544914, 0.267069569}, // 15080K
			{0.263542895, 0.267066935}, // 15081K
			{0.263540876, 0.267064301}, // 15082K
			{0.263538857, 0.267061668}, // 15083K
			{0.263536839, 0.267059035}, // 15084K
			{0.263534821, 0.267056403}, // 15085K
			{0.263532804, 0.267053771}, // 15086K
			{0.263530786, 0.267051139}, // 15087K
			{0.263528769, 0.267048507}, // 15088K
			{0.263526753, 0.267045877}, // 15089K
			{0.263524737, 0.267043246}, // 15090K
			{0.263522721, 0.267040616}, // 15091K
			{0.263520705, 0.267037986}, // 15092K
			{0.26351869, 0.267035357}, // 15093K
			{0.263516675, 0.267032728}, // 15094K
			{0.26351466, 0.267030099}, // 15095K
			{0.263512646, 0.267027471}, // 15096K
			{0.263510632, 0.267024843}, // 15097K
			{0.263508618, 0.267022216}, // 15098K
			{0.263506604, 0.267019589}, // 15099K
			{0.263504591, 0.267016962}, // 15100K
			{0.263502579, 0.267014336}, // 15101K
			{0.263500566, 0.26701171}, // 15102K
			{0.263498554, 0.267009084}, // 15103K
			{0.263496542, 0.267006459}, // 15104K
			{0.263494531, 0.267003835}, // 15105K
			{0.26349252, 0.26700121}, // 15106K
			{0.263490509, 0.266998586}, // 15107K
			{0.263488499, 0.266995963}, // 15108K
			{0.263486489, 0.26699334}, // 15109K
			{0.263484479, 0.266990717}, // 15110K
			{0.263482469, 0.266988095}, // 15111K
			{0.26348046, 0.266985473}, // 15112K
			{0.263478451, 0.266982851}, // 15113K
			{0.263476443, 0.26698023}, // 15114K
			{0.263474434, 0.266977609}, // 15115K
			{0.263472427, 0.266974989}, // 15116K
			{0.263470419, 0.266972369}, // 15117K
			{0.263468412, 0.266969749}, // 15118K
			{0.263466405, 0.26696713}, // 15119K
			{0.263464398, 0.266964511}, // 15120K
			{0.263462392, 0.266961893}, // 15121K
			{0.263460386, 0.266959275}, // 15122K
			{0.263458381, 0.266956657}, // 15123K
			{0.263456375, 0.26695404}, // 15124K
			{0.26345437, 0.266951423}, // 15125K
			{0.263452366, 0.266948807}, // 15126K
			{0.263450361, 0.266946191}, // 15127K
			{0.263448357, 0.266943575}, // 15128K
			{0.263446354, 0.26694096}, // 15129K
			{0.26344435, 0.266938345}, // 15130K
			{0.263442347, 0.26693573}, // 15131K
			{0.263440344, 0.266933116}, // 15132K
			{0.263438342, 0.266930503}, // 15133K
			{0.26343634, 0.266927889}, // 15134K
			{0.263434338, 0.266925276}, // 15135K
			{0.263432337, 0.266922664}, // 15136K
			{0.263430336, 0.266920051}, // 15137K
			{0.263428335, 0.26691744}, // 15138K
			{0.263426334, 0.266914828}, // 15139K
			{0.263424334, 0.266912217}, // 15140K
			{0.263422335, 0.266909607}, // 15141K
			{0.263420335, 0.266906996}, // 15142K
			{0.263418336, 0.266904387}, // 15143K
			{0.263416337, 0.266901777}, // 15144K
			{0.263414338, 0.266899168}, // 15145K
			{0.26341234, 0.266896559}, // 15146K
			{0.263410342, 0.266893951}, // 15147K
			{0.263408345, 0.266891343}, // 15148K
			{0.263406347, 0.266888736}, // 15149K
			{0.263404351, 0.266886129}, // 15150K
			{0.263402354, 0.266883522}, // 15151K
			{0.263400358, 0.266880916}, // 15152K
			{0.263398362, 0.26687831}, // 15153K
			{0.263396366, 0.266875704}, // 15154K
			{0.263394371, 0.266873099}, // 15155K
			{0.263392376, 0.266870494}, // 15156K
			{0.263390381, 0.26686789}, // 15157K
			{0.263388387, 0.266865286}, // 15158K
			{0.263386393, 0.266862682}, // 15159K
			{0.263384399, 0.266860079}, // 15160K
			{0.263382405, 0.266857476}, // 15161K
			{0.263380412, 0.266854873}, // 15162K
			{0.26337842, 0.266852271}, // 15163K
			{0.263376427, 0.26684967}, // 15164K
			{0.263374435, 0.266847068}, // 15165K
			{0.263372443, 0.266844467}, // 15166K
			{0.263370452, 0.266841867}, // 15167K
			{0.26336846, 0.266839267}, // 15168K
			{0.26336647, 0.266836667}, // 15169K
			{0.263364479, 0.266834068}, // 15170K
			{0.263362489, 0.266831469}, // 15171K
			{0.263360499, 0.26682887}, // 15172K
			{0.263358509, 0.266826272}, // 15173K
			{0.26335652, 0.266823674}, // 15174K
			{0.263354531, 0.266821077}, // 15175K
			{0.263352543, 0.266818479}, // 15176K
			{0.263350554, 0.266815883}, // 15177K
			{0.263348566, 0.266813287}, // 15178K
			{0.263346579, 0.266810691}, // 15179K
			{0.263344591, 0.266808095}, // 15180K
			{0.263342604, 0.2668055}, // 15181K
			{0.263340618, 0.266802905}, // 15182K
			{0.263338631, 0.266800311}, // 15183K
			{0.263336645, 0.266797717}, // 15184K
			{0.263334659, 0.266795123}, // 15185K
			{0.263332674, 0.26679253}, // 15186K
			{0.263330689, 0.266789937}, // 15187K
			{0.263328704, 0.266787345}, // 15188K
			{0.263326719, 0.266784753}, // 15189K
			{0.263324735, 0.266782161}, // 15190K
			{0.263322751, 0.26677957}, // 15191K
			{0.263320768, 0.266776979}, // 15192K
			{0.263318785, 0.266774389}, // 15193K
			{0.263316802, 0.266771798}, // 15194K
			{0.263314819, 0.266769209}, // 15195K
			{0.263312837, 0.266766619}, // 15196K
			{0.263310855, 0.26676403}, // 15197K
			{0.263308873, 0.266761442}, // 15198K
			{0.263306892, 0.266758854}, // 15199K
			{0.263304911, 0.266756266}, // 15200K
			{0.26330293, 0.266753678}, // 15201K
			{0.26330095, 0.266751091}, // 15202K
			{0.26329897, 0.266748505}, // 15203K
			{0.26329699, 0.266745918}, // 15204K
			{0.263295011, 0.266743333}, // 15205K
			{0.263293032, 0.266740747}, // 15206K
			{0.263291053, 0.266738162}, // 15207K
			{0.263289074, 0.266735577}, // 15208K
			{0.263287096, 0.266732993}, // 15209K
			{0.263285118, 0.266730409}, // 15210K
			{0.263283141, 0.266727825}, // 15211K
			{0.263281164, 0.266725242}, // 15212K
			{0.263279187, 0.266722659}, // 15213K
			{0.26327721, 0.266720077}, // 15214K
			{0.263275234, 0.266717495}, // 15215K
			{0.263273258, 0.266714913}, // 15216K
			{0.263271282, 0.266712332}, // 15217K
			{0.263269307, 0.266709751}, // 15218K
			{0.263267332, 0.26670717}, // 15219K
			{0.263265357, 0.26670459}, // 15220K
			{0.263263383, 0.26670201}, // 15221K
			{0.263261409, 0.266699431}, // 15222K
			{0.263259435, 0.266696852}, // 15223K
			{0.263257462, 0.266694273}, // 15224K
			{0.263255489, 0.266691695}, // 15225K
			{0.263253516, 0.266689117}, // 15226K
			{0.263251544, 0.26668654}, // 15227K
			{0.263249571, 0.266683963}, // 15228K
			{0.2632476, 0.266681386}, // 15229K
			{0.263245628, 0.26667881}, // 15230K
			{0.263243657, 0.266676234}, // 15231K
			{0.263241686, 0.266673658}, // 15232K
			{0.263239715, 0.266671083}, // 15233K
			{0.263237745, 0.266668508}, // 15234K
			{0.263235775, 0.266665934}, // 15235K
			{0.263233805, 0.26666336}, // 15236K
			{0.263231836, 0.266660786}, // 15237K
			{0.263229867, 0.266658213}, // 15238K
			{0.263227898, 0.26665564}, // 15239K
			{0.26322593, 0.266653068}, // 15240K
			{0.263223962, 0.266650495}, // 15241K
			{0.263221994, 0.266647924}, // 15242K
			{0.263220027, 0.266645352}, // 15243K
			{0.26321806, 0.266642781}, // 15244K
			{0.263216093, 0.266640211}, // 15245K
			{0.263214126, 0.26663764}, // 15246K
			{0.26321216, 0.266635071}, // 15247K
			{0.263210194, 0.266632501}, // 15248K
			{0.263208229, 0.266629932}, // 15249K
			{0.263206264, 0.266627363}, // 15250K
			{0.263204299, 0.266624795}, // 15251K
			{0.263202334, 0.266622227}, // 15252K
			{0.26320037, 0.26661966}, // 15253K
			{0.263198406, 0.266617092}, // 15254K
			{0.263196442, 0.266614526}, // 15255K
			{0.263194479, 0.266611959}, // 15256K
			{0.263192516, 0.266609393}, // 15257K
			{0.263190553, 0.266606827}, // 15258K
			{0.26318859, 0.266604262}, // 15259K
			{0.263186628, 0.266601697}, // 15260K
			{0.263184666, 0.266599133}, // 15261K
			{0.263182705, 0.266596569}, // 15262K
			{0.263180744, 0.266594005}, // 15263K
			{0.263178783, 0.266591441}, // 15264K
			{0.263176822, 0.266588878}, // 15265K
			{0.263174862, 0.266586316}, // 15266K
			{0.263172902, 0.266583753}, // 15267K
			{0.263170943, 0.266581192}, // 15268K
			{0.263168983, 0.26657863}, // 15269K
			{0.263167024, 0.266576069}, // 15270K
			{0.263165066, 0.266573508}, // 15271K
			{0.263163107, 0.266570948}, // 15272K
			{0.263161149, 0.266568388}, // 15273K
			{0.263159191, 0.266565828}, // 15274K
			{0.263157234, 0.266563269}, // 15275K
			{0.263155277, 0.26656071}, // 15276K
			{0.26315332, 0.266558152}, // 15277K
			{0.263151364, 0.266555594}, // 15278K
			{0.263149407, 0.266553036}, // 15279K
			{0.263147451, 0.266550479}, // 15280K
			{0.263145496, 0.266547922}, // 15281K
			{0.263143541, 0.266545365}, // 15282K
			{0.263141586, 0.266542809}, // 15283K
			{0.263139631, 0.266540253}, // 15284K
			{0.263137677, 0.266537698}, // 15285K
			{0.263135723, 0.266535143}, // 15286K
			{0.263133769, 0.266532588}, // 15287K
			{0.263131816, 0.266530034}, // 15288K
			{0.263129863, 0.26652748}, // 15289K
			{0.26312791, 0.266524926}, // 15290K
			{0.263125957, 0.266522373}, // 15291K
			{0.263124005, 0.26651982}, // 15292K
			{0.263122053, 0.266517268}, // 15293K
			{0.263120102, 0.266514716}, // 15294K
			{0.263118151, 0.266512164}, // 15295K
			{0.2631162, 0.266509613}, // 15296K
			{0.263114249, 0.266507062}, // 15297K
			{0.263112299, 0.266504511}, // 15298K
			{0.263110349, 0.266501961}, // 15299K
			{0.263108399, 0.266499411}, // 15300K
			{0.26310645, 0.266496862}, // 15301K
			{0.263104501, 0.266494313}, // 15302K
			{0.263102552, 0.266491764}, // 15303K
			{0.263100604, 0.266489216}, // 15304K
			{0.263098655, 0.266486668}, // 15305K
			{0.263096708, 0.26648412}, // 15306K
			{0.26309476, 0.266481573}, // 15307K
			{0.263092813, 0.266479026}, // 15308K
			{0.263090866, 0.26647648}, // 15309K
			{0.263088919, 0.266473934}, // 15310K
			{0.263086973, 0.266471388}, // 15311K
			{0.263085027, 0.266468843}, // 15312K
			{0.263083082, 0.266466298}, // 15313K
			{0.263081136, 0.266463753}, // 15314K
			{0.263079191, 0.266461209}, // 15315K
			{0.263077246, 0.266458665}, // 15316K
			{0.263075302, 0.266456122}, // 15317K
			{0.263073358, 0.266453579}, // 15318K
			{0.263071414, 0.266451036}, // 15319K
			{0.263069471, 0.266448494}, // 15320K
			{0.263067527, 0.266445952}, // 15321K
			{0.263065585, 0.266443411}, // 15322K
			{0.263063642, 0.266440869}, // 15323K
			{0.2630617, 0.266438329}, // 15324K
			{0.263059758, 0.266435788}, // 15325K
			{0.263057816, 0.266433248}, // 15326K
			{0.263055875, 0.266430709}, // 15327K
			{0.263053934, 0.266428169}, // 15328K
			{0.263051993, 0.26642563}, // 15329K
			{0.263050053, 0.266423092}, // 15330K
			{0.263048113, 0.266420554}, // 15331K
			{0.263046173, 0.266418016}, // 15332K
			{0.263044233, 0.266415478}, // 15333K
			{0.263042294, 0.266412941}, // 15334K
			{0.263040355, 0.266410405}, // 15335K
			{0.263038417, 0.266407868}, // 15336K
			{0.263036478, 0.266405332}, // 15337K
			{0.26303454, 0.266402797}, // 15338K
			{0.263032603, 0.266400262}, // 15339K
			{0.263030665, 0.266397727}, // 15340K
			{0.263028728, 0.266395192}, // 15341K
			{0.263026792, 0.266392658}, // 15342K
			{0.263024855, 0.266390125}, // 15343K
			{0.263022919, 0.266387591}, // 15344K
			{0.263020983, 0.266385058}, // 15345K
			{0.263019048, 0.266382526}, // 15346K
			{0.263017113, 0.266379994}, // 15347K
			{0.263015178, 0.266377462}, // 15348K
			{0.263013243, 0.26637493}, // 15349K
			{0.263011309, 0.266372399}, // 15350K
			{0.263009375, 0.266369868}, // 15351K
			{0.263007441, 0.266367338}, // 15352K
			{0.263005508, 0.266364808}, // 15353K
			{0.263003575, 0.266362279}, // 15354K
			{0.263001642, 0.266359749}, // 15355K
			{0.26299971, 0.26635722}, // 15356K
			{0.262997778, 0.266354692}, // 15357K
			{0.262995846, 0.266352164}, // 15358K
			{0.262993914, 0.266349636}, // 15359K
			{0.262991983, 0.266347109}, // 15360K
			{0.262990052, 0.266344582}, // 15361K
			{0.262988121, 0.266342055}, // 15362K
			{0.262986191, 0.266339529}, // 15363K
			{0.262984261, 0.266337003}, // 15364K
			{0.262982331, 0.266334477}, // 15365K
			{0.262980402, 0.266331952}, // 15366K
			{0.262978473, 0.266329428}, // 15367K
			{0.262976544, 0.266326903}, // 15368K
			{0.262974616, 0.266324379}, // 15369K
			{0.262972688, 0.266321855}, // 15370K
			{0.26297076, 0.266319332}, // 15371K
			{0.262968832, 0.266316809}, // 15372K
			{0.262966905, 0.266314287}, // 15373K
			{0.262964978, 0.266311765}, // 15374K
			{0.262963051, 0.266309243}, // 15375K
			{0.262961125, 0.266306721}, // 15376K
			{0.262959199, 0.2663042}, // 15377K
			{0.262957273, 0.26630168}, // 15378K
			{0.262955348, 0.266299159}, // 15379K
			{0.262953423, 0.266296639}, // 15380K
			{0.262951498, 0.26629412}, // 15381K
			{0.262949573, 0.2662916}, // 15382K
			{0.262947649, 0.266289082}, // 15383K
			{0.262945725, 0.266286563}, // 15384K
			{0.262943802, 0.266284045}, // 15385K
			{0.262941878, 0.266281527}, // 15386K
			{0.262939955, 0.26627901}, // 15387K
			{0.262938033, 0.266276493}, // 15388K
			{0.26293611, 0.266273976}, // 15389K
			{0.262934188, 0.26627146}, // 15390K
			{0.262932266, 0.266268944}, // 15391K
			{0.262930345, 0.266266429}, // 15392K
			{0.262928424, 0.266263913}, // 15393K
			{0.262926503, 0.266261399}, // 15394K
			{0.262924582, 0.266258884}, // 15395K
			{0.262922662, 0.26625637}, // 15396K
			{0.262920742, 0.266253857}, // 15397K
			{0.262918822, 0.266251343}, // 15398K
			{0.262916903, 0.26624883}, // 15399K
			{0.262914984, 0.266246318}, // 15400K
			{0.262913065, 0.266243806}, // 15401K
			{0.262911147, 0.266241294}, // 15402K
			{0.262909229, 0.266238782}, // 15403K
			{0.262907311, 0.266236271}, // 15404K
			{0.262905393, 0.26623376}, // 15405K
			{0.262903476, 0.26623125}, // 15406K
			{0.262901559, 0.26622874}, // 15407K
			{0.262899643, 0.26622623}, // 15408K
			{0.262897726, 0.266223721}, // 15409K
			{0.26289581, 0.266221212}, // 15410K
			{0.262893894, 0.266218704}, // 15411K
			{0.262891979, 0.266216196}, // 15412K
			{0.262890064, 0.266213688}, // 15413K
			{0.262888149, 0.26621118}, // 15414K
			{0.262886235, 0.266208673}, // 15415K
			{0.26288432, 0.266206167}, // 15416K
			{0.262882406, 0.26620366}, // 15417K
			{0.262880493, 0.266201154}, // 15418K
			{0.262878579, 0.266198649}, // 15419K
			{0.262876666, 0.266196143}, // 15420K
			{0.262874754, 0.266193639}, // 15421K
			{0.262872841, 0.266191134}, // 15422K
			{0.262870929, 0.26618863}, // 15423K
			{0.262869017, 0.266186126}, // 15424K
			{0.262867106, 0.266183623}, // 15425K
			{0.262865195, 0.26618112}, // 15426K
			{0.262863284, 0.266178617}, // 15427K
			{0.262861373, 0.266176115}, // 15428K
			{0.262859463, 0.266173613}, // 15429K
			{0.262857553, 0.266171111}, // 15430K
			{0.262855643, 0.26616861}, // 15431K
			{0.262853734, 0.266166109}, // 15432K
			{0.262851825, 0.266163609}, // 15433K
			{0.262849916, 0.266161109}, // 15434K
			{0.262848007, 0.266158609}, // 15435K
			{0.262846099, 0.26615611}, // 15436K
			{0.262844191, 0.266153611}, // 15437K
			{0.262842284, 0.266151112}, // 15438K
			{0.262840376, 0.266148614}, // 15439K
			{0.262838469, 0.266146116}, // 15440K
			{0.262836563, 0.266143618}, // 15441K
			{0.262834656, 0.266141121}, // 15442K
			{0.26283275, 0.266138624}, // 15443K
			{0.262830844, 0.266136128}, // 15444K
			{0.262828939, 0.266133632}, // 15445K
			{0.262827034, 0.266131136}, // 15446K
			{0.262825129, 0.266128641}, // 15447K
			{0.262823224, 0.266126146}, // 15448K
			{0.26282132, 0.266123651}, // 15449K
			{0.262819416, 0.266121157}, // 15450K
			{0.262817512, 0.266118663}, // 15451K
			{0.262815609, 0.26611617}, // 15452K
			{0.262813706, 0.266113676}, // 15453K
			{0.262811803, 0.266111184}, // 15454K
			{0.2628099, 0.266108691}, // 15455K
			{0.262807998, 0.266106199}, // 15456K
			{0.262806096, 0.266103707}, // 15457K
			{0.262804195, 0.266101216}, // 15458K
			{0.262802293, 0.266098725}, // 15459K
			{0.262800392, 0.266096235}, // 15460K
			{0.262798492, 0.266093744}, // 15461K
			{0.262796591, 0.266091254}, // 15462K
			{0.262794691, 0.266088765}, // 15463K
			{0.262792791, 0.266086276}, // 15464K
			{0.262790892, 0.266083787}, // 15465K
			{0.262788993, 0.266081299}, // 15466K
			{0.262787094, 0.26607881}, // 15467K
			{0.262785195, 0.266076323}, // 15468K
			{0.262783297, 0.266073835}, // 15469K
			{0.262781399, 0.266071348}, // 15470K
			{0.262779501, 0.266068862}, // 15471K
			{0.262777603, 0.266066376}, // 15472K
			{0.262775706, 0.26606389}, // 15473K
			{0.26277381, 0.266061404}, // 15474K
			{0.262771913, 0.266058919}, // 15475K
			{0.262770017, 0.266056434}, // 15476K
			{0.262768121, 0.26605395}, // 15477K
			{0.262766225, 0.266051466}, // 15478K
			{0.26276433, 0.266048982}, // 15479K
			{0.262762435, 0.266046499}, // 15480K
			{0.26276054, 0.266044016}, // 15481K
			{0.262758646, 0.266041533}, // 15482K
			{0.262756751, 0.266039051}, // 15483K
			{0.262754858, 0.266036569}, // 15484K
			{0.262752964, 0.266034087}, // 15485K
			{0.262751071, 0.266031606}, // 15486K
			{0.262749178, 0.266029125}, // 15487K
			{0.262747285, 0.266026645}, // 15488K
			{0.262745393, 0.266024165}, // 15489K
			{0.262743501, 0.266021685}, // 15490K
			{0.262741609, 0.266019206}, // 15491K
			{0.262739717, 0.266016727}, // 15492K
			{0.262737826, 0.266014248}, // 15493K
			{0.262735935, 0.26601177}, // 15494K
			{0.262734045, 0.266009292}, // 15495K
			{0.262732154, 0.266006814}, // 15496K
			{0.262730264, 0.266004337}, // 15497K
			{0.262728375, 0.26600186}, // 15498K
			{0.262726485, 0.265999384}, // 15499K
			{0.262724596, 0.265996908}, // 15500K
			{0.262722707, 0.265994432}, // 15501K
			{0.262720819, 0.265991956}, // 15502K
			{0.26271893, 0.265989481}, // 15503K
			{0.262717043, 0.265987007}, // 15504K
			{0.262715155, 0.265984532}, // 15505K
			{0.262713268, 0.265982058}, // 15506K
			{0.26271138, 0.265979585}, // 15507K
			{0.262709494, 0.265977112}, // 15508K
			{0.262707607, 0.265974639}, // 15509K
			{0.262705721, 0.265972166}, // 15510K
			{0.262703835, 0.265969694}, // 15511K
			{0.26270195, 0.265967222}, // 15512K
			{0.262700064, 0.265964751}, // 15513K
			{0.262698179, 0.26596228}, // 15514K
			{0.262696295, 0.265959809}, // 15515K
			{0.26269441, 0.265957339}, // 15516K
			{0.262692526, 0.265954869}, // 15517K
			{0.262690642, 0.265952399}, // 15518K
			{0.262688759, 0.26594993}, // 15519K
			{0.262686876, 0.265947461}, // 15520K
			{0.262684993, 0.265944992}, // 15521K
			{0.26268311, 0.265942524}, // 15522K
			{0.262681228, 0.265940056}, // 15523K
			{0.262679346, 0.265937589}, // 15524K
			{0.262677464, 0.265935122}, // 15525K
			{0.262675583, 0.265932655}, // 15526K
			{0.262673701, 0.265930189}, // 15527K
			{0.262671821, 0.265927722}, // 15528K
			{0.26266994, 0.265925257}, // 15529K
			{0.26266806, 0.265922791}, // 15530K
			{0.26266618, 0.265920326}, // 15531K
			{0.2626643, 0.265917862}, // 15532K
			{0.262662421, 0.265915398}, // 15533K
			{0.262660542, 0.265912934}, // 15534K
			{0.262658663, 0.26591047}, // 15535K
			{0.262656784, 0.265908007}, // 15536K
			{0.262654906, 0.265905544}, // 15537K
			{0.262653028, 0.265903082}, // 15538K
			{0.262651151, 0.26590062}, // 15539K
			{0.262649273, 0.265898158}, // 15540K
			{0.262647396, 0.265895696}, // 15541K
			{0.262645519, 0.265893235}, // 15542K
			{0.262643643, 0.265890775}, // 15543K
			{0.262641767, 0.265888314}, // 15544K
			{0.262639891, 0.265885854}, // 15545K
			{0.262638015, 0.265883395}, // 15546K
			{0.26263614, 0.265880936}, // 15547K
			{0.262634265, 0.265878477}, // 15548K
			{0.26263239, 0.265876018}, // 15549K
			{0.262630516, 0.26587356}, // 15550K
			{0.262628642, 0.265871102}, // 15551K
			{0.262626768, 0.265868645}, // 15552K
			{0.262624895, 0.265866188}, // 15553K
			{0.262623021, 0.265863731}, // 15554K
			{0.262621148, 0.265861275}, // 15555K
			{0.262619276, 0.265858818}, // 15556K
			{0.262617403, 0.265856363}, // 15557K
			{0.262615531, 0.265853908}, // 15558K
			{0.262613659, 0.265851453}, // 15559K
			{0.262611788, 0.265848998}, // 15560K
			{0.262609917, 0.265846544}, // 15561K
			{0.262608046, 0.26584409}, // 15562K
			{0.262606175, 0.265841636}, // 15563K
			{0.262604305, 0.265839183}, // 15564K
			{0.262602435, 0.26583673}, // 15565K
			{0.262600565, 0.265834278}, // 15566K
			{0.262598696, 0.265831826}, // 15567K
			{0.262596827, 0.265829374}, // 15568K
			{0.262594958, 0.265826922}, // 15569K
			{0.262593089, 0.265824471}, // 15570K
			{0.262591221, 0.265822021}, // 15571K
			{0.262589353, 0.26581957}, // 15572K
			{0.262587485, 0.26581712}, // 15573K
			{0.262585618, 0.265814671}, // 15574K
			{0.262583751, 0.265812222}, // 15575K
			{0.262581884, 0.265809773}, // 15576K
			{0.262580017, 0.265807324}, // 15577K
			{0.262578151, 0.265804876}, // 15578K
			{0.262576285, 0.265802428}, // 15579K
			{0.26257442, 0.26579998}, // 15580K
			{0.262572554, 0.265797533}, // 15581K
			{0.262570689, 0.265795087}, // 15582K
			{0.262568824, 0.26579264}, // 15583K
			{0.26256696, 0.265790194}, // 15584K
			{0.262565096, 0.265787748}, // 15585K
			{0.262563232, 0.265785303}, // 15586K
			{0.262561368, 0.265782858}, // 15587K
			{0.262559505, 0.265780413}, // 15588K
			{0.262557642, 0.265777969}, // 15589K
			{0.262555779, 0.265775525}, // 15590K
			{0.262553917, 0.265773081}, // 15591K
			{0.262552054, 0.265770638}, // 15592K
			{0.262550193, 0.265768195}, // 15593K
			{0.262548331, 0.265765753}, // 15594K
			{0.26254647, 0.265763311}, // 15595K
			{0.262544609, 0.265760869}, // 15596K
			{0.262542748, 0.265758427}, // 15597K
			{0.262540887, 0.265755986}, // 15598K
			{0.262539027, 0.265753545}, // 15599K
			{0.262537167, 0.265751105}, // 15600K
			{0.262535308, 0.265748665}, // 15601K
			{0.262533449, 0.265746225}, // 15602K
			{0.26253159, 0.265743786}, // 15603K
			{0.262529731, 0.265741347}, // 15604K
			{0.262527873, 0.265738908}, // 15605K
			{0.262526014, 0.26573647}, // 15606K
			{0.262524157, 0.265734032}, // 15607K
			{0.262522299, 0.265731594}, // 15608K
			{0.262520442, 0.265729157}, // 15609K
			{0.262518585, 0.26572672}, // 15610K
			{0.262516728, 0.265724284}, // 15611K
			{0.262514872, 0.265721848}, // 15612K
			{0.262513016, 0.265719412}, // 15613K
			{0.26251116, 0.265716976}, // 15614K
			{0.262509304, 0.265714541}, // 15615K
			{0.262507449, 0.265712106}, // 15616K
			{0.262505594, 0.265709672}, // 15617K
			{0.262503739, 0.265707238}, // 15618K
			{0.262501885, 0.265704804}, // 15619K
			{0.262500031, 0.265702371}, // 15620K
			{0.262498177, 0.265699938}, // 15621K
			{0.262496324, 0.265697505}, // 15622K
			{0.262494471, 0.265695073}, // 15623K
			{0.262492618, 0.265692641}, // 15624K
			{0.262490765, 0.265690209}, // 15625K
			{0.262488913, 0.265687778}, // 15626K
			{0.262487061, 0.265685347}, // 15627K
			{0.262485209, 0.265682917}, // 15628K
			{0.262483357, 0.265680486}, // 15629K
			{0.262481506, 0.265678057}, // 15630K
			{0.262479655, 0.265675627}, // 15631K
			{0.262477805, 0.265673198}, // 15632K
			{0.262475954, 0.265670769}, // 15633K
			{0.262474104, 0.265668341}, // 15634K
			{0.262472254, 0.265665913}, // 15635K
			{0.262470405, 0.265663485}, // 15636K
			{0.262468556, 0.265661057}, // 15637K
			{0.262466707, 0.26565863}, // 15638K
			{0.262464858, 0.265656204}, // 15639K
			{0.26246301, 0.265653777}, // 15640K
			{0.262461162, 0.265651351}, // 15641K
			{0.262459314, 0.265648926}, // 15642K
			{0.262457467, 0.2656465}, // 15643K
			{0.262455619, 0.265644076}, // 15644K
			{0.262453772, 0.265641651}, // 15645K
			{0.262451926, 0.265639227}, // 15646K
			{0.26245008, 0.265636803}, // 15647K
			{0.262448234, 0.265634379}, // 15648K
			{0.262446388, 0.265631956}, // 15649K
			{0.262444542, 0.265629533}, // 15650K
			{0.262442697, 0.265627111}, // 15651K
			{0.262440852, 0.265624689}, // 15652K
			{0.262439008, 0.265622267}, // 15653K
			{0.262437163, 0.265619845}, // 15654K
			{0.262435319, 0.265617424}, // 15655K
			{0.262433476, 0.265615004}, // 15656K
			{0.262431632, 0.265612583}, // 15657K
			{0.262429789, 0.265610163}, // 15658K
			{0.262427946, 0.265607743}, // 15659K
			{0.262426103, 0.265605324}, // 15660K
			{0.262424261, 0.265602905}, // 15661K
			{0.262422419, 0.265600486}, // 15662K
			{0.262420577, 0.265598068}, // 15663K
			{0.262418736, 0.26559565}, // 15664K
			{0.262416895, 0.265593233}, // 15665K
			{0.262415054, 0.265590815}, // 15666K
			{0.262413213, 0.265588398}, // 15667K
			{0.262411373, 0.265585982}, // 15668K
			{0.262409533, 0.265583566}, // 15669K
			{0.262407693, 0.26558115}, // 15670K
			{0.262405854, 0.265578734}, // 15671K
			{0.262404014, 0.265576319}, // 15672K
			{0.262402175, 0.265573904}, // 15673K
			{0.262400337, 0.26557149}, // 15674K
			{0.262398498, 0.265569076}, // 15675K
			{0.26239666, 0.265566662}, // 15676K
			{0.262394823, 0.265564249}, // 15677K
			{0.262392985, 0.265561836}, // 15678K
			{0.262391148, 0.265559423}, // 15679K
			{0.262389311, 0.26555701}, // 15680K
			{0.262387474, 0.265554598}, // 15681K
			{0.262385638, 0.265552187}, // 15682K
			{0.262383802, 0.265549775}, // 15683K
			{0.262381966, 0.265547364}, // 15684K
			{0.262380131, 0.265544954}, // 15685K
			{0.262378296, 0.265542544}, // 15686K
			{0.262376461, 0.265540134}, // 15687K
			{0.262374626, 0.265537724}, // 15688K
			{0.262372792, 0.265535315}, // 15689K
			{0.262370958, 0.265532906}, // 15690K
			{0.262369124, 0.265530497}, // 15691K
			{0.26236729, 0.265528089}, // 15692K
			{0.262365457, 0.265525681}, // 15693K
			{0.262363624, 0.265523274}, // 15694K
			{0.262361792, 0.265520866}, // 15695K
			{0.262359959, 0.26551846}, // 15696K
			{0.262358127, 0.265516053}, // 15697K
			{0.262356295, 0.265513647}, // 15698K
			{0.262354464, 0.265511241}, // 15699K
			{0.262352632, 0.265508836}, // 15700K
			{0.262350802, 0.265506431}, // 15701K
			{0.262348971, 0.265504026}, // 15702K
			{0.26234714, 0.265501622}, // 15703K
			{0.26234531, 0.265499218}, // 15704K
			{0.262343481, 0.265496814}, // 15705K
			{0.262341651, 0.26549441}, // 15706K
			{0.262339822, 0.265492007}, // 15707K
			{0.262337993, 0.265489605}, // 15708K
			{0.262336164, 0.265487202}, // 15709K
			{0.262334336, 0.2654848}, // 15710K
			{0.262332508, 0.265482399}, // 15711K
			{0.26233068, 0.265479998}, // 15712K
			{0.262328852, 0.265477597}, // 15713K
			{0.262327025, 0.265475196}, // 15714K
			{0.262325198, 0.265472796}, // 15715K
			{0.262323371, 0.265470396}, // 15716K
			{0.262321545, 0.265467996}, // 15717K
			{0.262319719, 0.265465597}, // 15718K
			{0.262317893, 0.265463198}, // 15719K
			{0.262316067, 0.2654608}, // 15720K
			{0.262314242, 0.265458401}, // 15721K
			{0.262312417, 0.265456004}, // 15722K
			{0.262310592, 0.265453606}, // 15723K
			{0.262308768, 0.265451209}, // 15724K
			{0.262306943, 0.265448812}, // 15725K
			{0.262305119, 0.265446416}, // 15726K
			{0.262303296, 0.26544402}, // 15727K
			{0.262301472, 0.265441624}, // 15728K
			{0.262299649, 0.265439228}, // 15729K
			{0.262297827, 0.265436833}, // 15730K
			{0.262296004, 0.265434439}, // 15731K
			{0.262294182, 0.265432044}, // 15732K
			{0.26229236, 0.26542965}, // 15733K
			{0.262290538, 0.265427256}, // 15734K
			{0.262288717, 0.265424863}, // 15735K
			{0.262286896, 0.26542247}, // 15736K
			{0.262285075, 0.265420077}, // 15737K
			{0.262283255, 0.265417685}, // 15738K
			{0.262281434, 0.265415293}, // 15739K
			{0.262279614, 0.265412901}, // 15740K
			{0.262277795, 0.26541051}, // 15741K
			{0.262275975, 0.265408119}, // 15742K
			{0.262274156, 0.265405728}, // 15743K
			{0.262272337, 0.265403338}, // 15744K
			{0.262270519, 0.265400948}, // 15745K
			{0.2622687, 0.265398559}, // 15746K
			{0.262266882, 0.265396169}, // 15747K
			{0.262265065, 0.265393781}, // 15748K
			{0.262263247, 0.265391392}, // 15749K
			{0.26226143, 0.265389004}, // 15750K
			{0.262259613, 0.265386616}, // 15751K
			{0.262257797, 0.265384228}, // 15752K
			{0.26225598, 0.265381841}, // 15753K
			{0.262254164, 0.265379454}, // 15754K
			{0.262252348, 0.265377068}, // 15755K
			{0.262250533, 0.265374682}, // 15756K
			{0.262248718, 0.265372296}, // 15757K
			{0.262246903, 0.26536991}, // 15758K
			{0.262245088, 0.265367525}, // 15759K
			{0.262243274, 0.26536514}, // 15760K
			{0.26224146, 0.265362756}, // 15761K
			{0.262239646, 0.265360372}, // 15762K
			{0.262237832, 0.265357988}, // 15763K
			{0.262236019, 0.265355605}, // 15764K
			{0.262234206, 0.265353222}, // 15765K
			{0.262232393, 0.265350839}, // 15766K
			{0.262230581, 0.265348456}, // 15767K
			{0.262228769, 0.265346074}, // 15768K
			{0.262226957, 0.265343693}, // 15769K
			{0.262225145, 0.265341311}, // 15770K
			{0.262223334, 0.26533893}, // 15771K
			{0.262221523, 0.265336549}, // 15772K
			{0.262219712, 0.265334169}, // 15773K
			{0.262217902, 0.265331789}, // 15774K
			{0.262216092, 0.265329409}, // 15775K
			{0.262214282, 0.26532703}, // 15776K
			{0.262212472, 0.265324651}, // 15777K
			{0.262210663, 0.265322272}, // 15778K
			{0.262208854, 0.265319894}, // 15779K
			{0.262207045, 0.265317516}, // 15780K
			{0.262205236, 0.265315139}, // 15781K
			{0.262203428, 0.265312761}, // 15782K
			{0.26220162, 0.265310384}, // 15783K
			{0.262199813, 0.265308008}, // 15784K
			{0.262198005, 0.265305631}, // 15785K
			{0.262196198, 0.265303255}, // 15786K
			{0.262194391, 0.26530088}, // 15787K
			{0.262192585, 0.265298505}, // 15788K
			{0.262190778, 0.26529613}, // 15789K
			{0.262188972, 0.265293755}, // 15790K
			{0.262187167, 0.265291381}, // 15791K
			{0.262185361, 0.265289007}, // 15792K
			{0.262183556, 0.265286634}, // 15793K
			{0.262181751, 0.26528426}, // 15794K
			{0.262179946, 0.265281887}, // 15795K
			{0.262178142, 0.265279515}, // 15796K
			{0.262176338, 0.265277143}, // 15797K
			{0.262174534, 0.265274771}, // 15798K
			{0.262172731, 0.265272399}, // 15799K
			{0.262170927, 0.265270028}, // 15800K
			{0.262169124, 0.265267657}, // 15801K
			{0.262167322, 0.265265287}, // 15802K
			{0.262165519, 0.265262917}, // 15803K
			{0.262163717, 0.265260547}, // 15804K
			{0.262161915, 0.265258177}, // 15805K
			{0.262160114, 0.265255808}, // 15806K
			{0.262158312, 0.265253439}, // 15807K
			{0.262156511, 0.265251071}, // 15808K
			{0.26215471, 0.265248703}, // 15809K
			{0.26215291, 0.265246335}, // 15810K
			{0.26215111, 0.265243968}, // 15811K
			{0.26214931, 0.2652416}, // 15812K
			{0.26214751, 0.265239234}, // 15813K
			{0.262145711, 0.265236867}, // 15814K
			{0.262143912, 0.265234501}, // 15815K
			{0.262142113, 0.265232135}, // 15816K
			{0.262140314, 0.26522977}, // 15817K
			{0.262138516, 0.265227405}, // 15818K
			{0.262136718, 0.26522504}, // 15819K
			{0.26213492, 0.265222676}, // 15820K
			{0.262133123, 0.265220312}, // 15821K
			{0.262131326, 0.265217948}, // 15822K
			{0.262129529, 0.265215585}, // 15823K
			{0.262127732, 0.265213222}, // 15824K
			{0.262125936, 0.265210859}, // 15825K
			{0.26212414, 0.265208496}, // 15826K
			{0.262122344, 0.265206134}, // 15827K
			{0.262120548, 0.265203773}, // 15828K
			{0.262118753, 0.265201411}, // 15829K
			{0.262116958, 0.26519905}, // 15830K
			{0.262115164, 0.26519669}, // 15831K
			{0.262113369, 0.265194329}, // 15832K
			{0.262111575, 0.265191969}, // 15833K
			{0.262109781, 0.26518961}, // 15834K
			{0.262107987, 0.26518725}, // 15835K
			{0.262106194, 0.265184891}, // 15836K
			{0.262104401, 0.265182533}, // 15837K
			{0.262102608, 0.265180174}, // 15838K
			{0.262100816, 0.265177816}, // 15839K
			{0.262099024, 0.265175459}, // 15840K
			{0.262097232, 0.265173101}, // 15841K
			{0.26209544, 0.265170744}, // 15842K
			{0.262093649, 0.265168388}, // 15843K
			{0.262091857, 0.265166031}, // 15844K
			{0.262090067, 0.265163675}, // 15845K
			{0.262088276, 0.26516132}, // 15846K
			{0.262086486, 0.265158964}, // 15847K
			{0.262084696, 0.265156609}, // 15848K
			{0.262082906, 0.265154255}, // 15849K
			{0.262081116, 0.2651519}, // 15850K
			{0.262079327, 0.265149546}, // 15851K
			{0.262077538, 0.265147193}, // 15852K
			{0.26207575, 0.265144839}, // 15853K
			{0.262073961, 0.265142487}, // 15854K
			{0.262072173, 0.265140134}, // 15855K
			{0.262070385, 0.265137782}, // 15856K
			{0.262068598, 0.26513543}, // 15857K
			{0.26206681, 0.265133078}, // 15858K
			{0.262065023, 0.265130727}, // 15859K
			{0.262063237, 0.265128376}, // 15860K
			{0.26206145, 0.265126025}, // 15861K
			{0.262059664, 0.265123675}, // 15862K
			{0.262057878, 0.265121325}, // 15863K
			{0.262056092, 0.265118975}, // 15864K
			{0.262054307, 0.265116626}, // 15865K
			{0.262052522, 0.265114277}, // 15866K
			{0.262050737, 0.265111929}, // 15867K
			{0.262048952, 0.26510958}, // 15868K
			{0.262047168, 0.265107232}, // 15869K
			{0.262045384, 0.265104885}, // 15870K
			{0.2620436, 0.265102537}, // 15871K
			{0.262041817, 0.265100191}, // 15872K
			{0.262040034, 0.265097844}, // 15873K
			{0.262038251, 0.265095498}, // 15874K
			{0.262036468, 0.265093152}, // 15875K
			{0.262034686, 0.265090806}, // 15876K
			{0.262032904, 0.265088461}, // 15877K
			{0.262031122, 0.265086116}, // 15878K
			{0.26202934, 0.265083771}, // 15879K
			{0.262027559, 0.265081427}, // 15880K
			{0.262025778, 0.265079083}, // 15881K
			{0.262023997, 0.26507674}, // 15882K
			{0.262022217, 0.265074396}, // 15883K
			{0.262020436, 0.265072053}, // 15884K
			{0.262018656, 0.265069711}, // 15885K
			{0.262016877, 0.265067369}, // 15886K
			{0.262015097, 0.265065027}, // 15887K
			{0.262013318, 0.265062685}, // 15888K
			{0.262011539, 0.265060344}, // 15889K
			{0.262009761, 0.265058003}, // 15890K
			{0.262007982, 0.265055662}, // 15891K
			{0.262006204, 0.265053322}, // 15892K
			{0.262004427, 0.265050982}, // 15893K
			{0.262002649, 0.265048642}, // 15894K
			{0.262000872, 0.265046303}, // 15895K
			{0.261999095, 0.265043964}, // 15896K
			{0.261997318, 0.265041626}, // 15897K
			{0.261995542, 0.265039287}, // 15898K
			{0.261993766, 0.265036949}, // 15899K
			{0.26199199, 0.265034612}, // 15900K
			{0.261990214, 0.265032275}, // 15901K
			{0.261988439, 0.265029938}, // 15902K
			{0.261986664, 0.265027601}, // 15903K
			{0.261984889, 0.265025265}, // 15904K
			{0.261983114, 0.265022929}, // 15905K
			{0.26198134, 0.265020593}, // 15906K
			{0.261979566, 0.265018258}, // 15907K
			{0.261977793, 0.265015923}, // 15908K
			{0.261976019, 0.265013588}, // 15909K
			{0.261974246, 0.265011254}, // 15910K
			{0.261972473, 0.26500892}, // 15911K
			{0.2619707, 0.265006586}, // 15912K
			{0.261968928, 0.265004253}, // 15913K
			{0.261967156, 0.26500192}, // 15914K
			{0.261965384, 0.264999588}, // 15915K
			{0.261963613, 0.264997255}, // 15916K
			{0.261961841, 0.264994923}, // 15917K
			{0.26196007, 0.264992592}, // 15918K
			{0.2619583, 0.26499026}, // 15919K
			{0.261956529, 0.264987929}, // 15920K
			{0.261954759, 0.264985599}, // 15921K
			{0.261952989, 0.264983268}, // 15922K
			{0.261951219, 0.264980939}, // 15923K
			{0.26194945, 0.264978609}, // 15924K
			{0.261947681, 0.26497628}, // 15925K
			{0.261945912, 0.264973951}, // 15926K
			{0.261944143, 0.264971622}, // 15927K
			{0.261942375, 0.264969294}, // 15928K
			{0.261940607, 0.264966966}, // 15929K
			{0.261938839, 0.264964638}, // 15930K
			{0.261937072, 0.264962311}, // 15931K
			{0.261935304, 0.264959984}, // 15932K
			{0.261933537, 0.264957657}, // 15933K
			{0.261931771, 0.264955331}, // 15934K
			{0.261930004, 0.264953005}, // 15935K
			{0.261928238, 0.264950679}, // 15936K
			{0.261926472, 0.264948354}, // 15937K
			{0.261924707, 0.264946029}, // 15938K
			{0.261922941, 0.264943704}, // 15939K
			{0.261921176, 0.264941379}, // 15940K
			{0.261919411, 0.264939055}, // 15941K
			{0.261917647, 0.264936732}, // 15942K
			{0.261915882, 0.264934408}, // 15943K
			{0.261914118, 0.264932085}, // 15944K
			{0.261912355, 0.264929763}, // 15945K
			{0.261910591, 0.26492744}, // 15946K
			{0.261908828, 0.264925118}, // 15947K
			{0.261907065, 0.264922796}, // 15948K
			{0.261905302, 0.264920475}, // 15949K
			{0.26190354, 0.264918154}, // 15950K
			{0.261901778, 0.264915833}, // 15951K
			{0.261900016, 0.264913513}, // 15952K
			{0.261898254, 0.264911193}, // 15953K
			{0.261896493, 0.264908873}, // 15954K
			{0.261894732, 0.264906554}, // 15955K
			{0.261892971, 0.264904234}, // 15956K
			{0.261891211, 0.264901916}, // 15957K
			{0.26188945, 0.264899597}, // 15958K
			{0.26188769, 0.264897279}, // 15959K
			{0.261885931, 0.264894961}, // 15960K
			{0.261884171, 0.264892644}, // 15961K
			{0.261882412, 0.264890327}, // 15962K
			{0.261880653, 0.26488801}, // 15963K
			{0.261878894, 0.264885693}, // 15964K
			{0.261877136, 0.264883377}, // 15965K
			{0.261875378, 0.264881062}, // 15966K
			{0.26187362, 0.264878746}, // 15967K
			{0.261871862, 0.264876431}, // 15968K
			{0.261870105, 0.264874116}, // 15969K
			{0.261868348, 0.264871802}, // 15970K
			{0.261866591, 0.264869487}, // 15971K
			{0.261864835, 0.264867173}, // 15972K
			{0.261863078, 0.26486486}, // 15973K
			{0.261861322, 0.264862547}, // 15974K
			{0.261859567, 0.264860234}, // 15975K
			{0.261857811, 0.264857921}, // 15976K
			{0.261856056, 0.264855609}, // 15977K
			{0.261854301, 0.264853297}, // 15978K
			{0.261852546, 0.264850986}, // 15979K
			{0.261850792, 0.264848674}, // 15980K
			{0.261849038, 0.264846364}, // 15981K
			{0.261847284, 0.264844053}, // 15982K
			{0.26184553, 0.264841743}, // 15983K
			{0.261843777, 0.264839433}, // 15984K
			{0.261842024, 0.264837123}, // 15985K
			{0.261840271, 0.264834814}, // 15986K
			{0.261838519, 0.264832505}, // 15987K
			{0.261836766, 0.264830196}, // 15988K
			{0.261835014, 0.264827888}, // 15989K
			{0.261833262, 0.26482558}, // 15990K
			{0.261831511, 0.264823272}, // 15991K
			{0.26182976, 0.264820965}, // 15992K
			{0.261828009, 0.264818658}, // 15993K
			{0.261826258, 0.264816352}, // 15994K
			{0.261824508, 0.264814045}, // 15995K
			{0.261822758, 0.264811739}, // 15996K
			{0.261821008, 0.264809434}, // 15997K
			{0.261819258, 0.264807128}, // 15998K
			{0.261817509, 0.264804823}, // 15999K
			{0.26181576, 0.264802518}, // 16000K
			{0.261814011, 0.264800214}, // 16001K
			{0.261812262, 0.26479791}, // 16002K
			{0.261810514, 0.264795606}, // 16003K
			{0.261808766, 0.264793303}, // 16004K
			{0.261807018, 0.264791}, // 16005K
			{0.261805271, 0.264788697}, // 16006K
			{0.261803523, 0.264786395}, // 16007K
			{0.261801776, 0.264784092}, // 16008K
			{0.26180003, 0.264781791}, // 16009K
			{0.261798283, 0.264779489}, // 16010K
			{0.261796537, 0.264777188}, // 16011K
			{0.261794791, 0.264774887}, // 16012K
			{0.261793045, 0.264772587}, // 16013K
			{0.2617913, 0.264770287}, // 16014K
			{0.261789555, 0.264767987}, // 16015K
			{0.26178781, 0.264765687}, // 16016K
			{0.261786065, 0.264763388}, // 16017K
			{0.261784321, 0.264761089}, // 16018K
			{0.261782577, 0.264758791}, // 16019K
			{0.261780833, 0.264756493}, // 16020K
			{0.26177909, 0.264754195}, // 16021K
			{0.261777346, 0.264751897}, // 16022K
			{0.261775603, 0.2647496}, // 16023K
			{0.261773861, 0.264747303}, // 16024K
			{0.261772118, 0.264745006}, // 16025K
			{0.261770376, 0.26474271}, // 16026K
			{0.261768634, 0.264740414}, // 16027K
			{0.261766892, 0.264738119}, // 16028K
			{0.261765151, 0.264735823}, // 16029K
			{0.26176341, 0.264733528}, // 16030K
			{0.261761669, 0.264731234}, // 16031K
			{0.261759928, 0.264728939}, // 16032K
			{0.261758188, 0.264726645}, // 16033K
			{0.261756448, 0.264724352}, // 16034K
			{0.261754708, 0.264722058}, // 16035K
			{0.261752968, 0.264719765}, // 16036K
			{0.261751229, 0.264717473}, // 16037K
			{0.26174949, 0.26471518}, // 16038K
			{0.261747751, 0.264712888}, // 16039K
			{0.261746012, 0.264710597}, // 16040K
			{0.261744274, 0.264708305}, // 16041K
			{0.261742536, 0.264706014}, // 16042K
			{0.261740798, 0.264703723}, // 16043K
			{0.261739061, 0.264701433}, // 16044K
			{0.261737324, 0.264699143}, // 16045K
			{0.261735587, 0.264696853}, // 16046K
			{0.26173385, 0.264694563}, // 16047K
			{0.261732114, 0.264692274}, // 16048K
			{0.261730377, 0.264689985}, // 16049K
			{0.261728641, 0.264687697}, // 16050K
			{0.261726906, 0.264685409}, // 16051K
			{0.26172517, 0.264683121}, // 16052K
			{0.261723435, 0.264680833}, // 16053K
			{0.2617217, 0.264678546}, // 16054K
			{0.261719966, 0.264676259}, // 16055K
			{0.261718231, 0.264673973}, // 16056K
			{0.261716497, 0.264671686}, // 16057K
			{0.261714763, 0.264669401}, // 16058K
			{0.26171303, 0.264667115}, // 16059K
			{0.261711297, 0.26466483}, // 16060K
			{0.261709564, 0.264662545}, // 16061K
			{0.261707831, 0.26466026}, // 16062K
			{0.261706098, 0.264657976}, // 16063K
			{0.261704366, 0.264655692}, // 16064K
			{0.261702634, 0.264653408}, // 16065K
			{0.261700902, 0.264651125}, // 16066K
			{0.261699171, 0.264648842}, // 16067K
			{0.26169744, 0.264646559}, // 16068K
			{0.261695709, 0.264644277}, // 16069K
			{0.261693978, 0.264641994}, // 16070K
			{0.261692247, 0.264639713}, // 16071K
			{0.261690517, 0.264637431}, // 16072K
			{0.261688787, 0.26463515}, // 16073K
			{0.261687058, 0.264632869}, // 16074K
			{0.261685328, 0.264630589}, // 16075K
			{0.261683599, 0.264628309}, // 16076K
			{0.26168187, 0.264626029}, // 16077K
			{0.261680142, 0.264623749}, // 16078K
			{0.261678413, 0.26462147}, // 16079K
			{0.261676685, 0.264619191}, // 16080K
			{0.261674957, 0.264616913}, // 16081K
			{0.26167323, 0.264614635}, // 16082K
			{0.261671503, 0.264612357}, // 16083K
			{0.261669776, 0.264610079}, // 16084K
			{0.261668049, 0.264607802}, // 16085K
			{0.261666322, 0.264605525}, // 16086K
			{0.261664596, 0.264603248}, // 16087K
			{0.26166287, 0.264600972}, // 16088K
			{0.261661144, 0.264598696}, // 16089K
			{0.261659419, 0.26459642}, // 16090K
			{0.261657694, 0.264594145}, // 16091K
			{0.261655969, 0.26459187}, // 16092K
			{0.261654244, 0.264589595}, // 16093K
			{0.261652519, 0.264587321}, // 16094K
			{0.261650795, 0.264585047}, // 16095K
			{0.261649071, 0.264582773}, // 16096K
			{0.261647348, 0.2645805}, // 16097K
			{0.261645624, 0.264578227}, // 16098K
			{0.261643901, 0.264575954}, // 16099K
			{0.261642178, 0.264573681}, // 16100K
			{0.261640456, 0.264571409}, // 16101K
			{0.261638733, 0.264569137}, // 16102K
			{0.261637011, 0.264566866}, // 16103K
			{0.261635289, 0.264564595}, // 16104K
			{0.261633568, 0.264562324}, // 16105K
			{0.261631846, 0.264560053}, // 16106K
			{0.261630125, 0.264557783}, // 16107K
			{0.261628404, 0.264555513}, // 16108K
			{0.261626684, 0.264553244}, // 16109K
			{0.261624963, 0.264550974}, // 16110K
			{0.261623243, 0.264548705}, // 16111K
			{0.261621524, 0.264546437}, // 16112K
			{0.261619804, 0.264544168}, // 16113K
			{0.261618085, 0.2645419}, // 16114K
			{0.261616366, 0.264539633}, // 16115K
			{0.261614647, 0.264537365}, // 16116K
			{0.261612929, 0.264535098}, // 16117K
			{0.26161121, 0.264532832}, // 16118K
			{0.261609492, 0.264530565}, // 16119K
			{0.261607775, 0.264528299}, // 16120K
			{0.261606057, 0.264526033}, // 16121K
			{0.26160434, 0.264523768}, // 16122K
			{0.261602623, 0.264521503}, // 16123K
			{0.261600906, 0.264519238}, // 16124K
			{0.26159919, 0.264516973}, // 16125K
			{0.261597474, 0.264514709}, // 16126K
			{0.261595758, 0.264512445}, // 16127K
			{0.261594042, 0.264510182}, // 16128K
			{0.261592327, 0.264507918}, // 16129K
			{0.261590612, 0.264505656}, // 16130K
			{0.261588897, 0.264503393}, // 16131K
			{0.261587182, 0.264501131}, // 16132K
			{0.261585468, 0.264498869}, // 16133K
			{0.261583754, 0.264496607}, // 16134K
			{0.26158204, 0.264494346}, // 16135K
			{0.261580326, 0.264492085}, // 16136K
			{0.261578613, 0.264489824}, // 16137K
			{0.2615769, 0.264487564}, // 16138K
			{0.261575187, 0.264485304}, // 16139K
			{0.261573474, 0.264483044}, // 16140K
			{0.261571762, 0.264480784}, // 16141K
			{0.26157005, 0.264478525}, // 16142K
			{0.261568338, 0.264476266}, // 16143K
			{0.261566627, 0.264474008}, // 16144K
			{0.261564915, 0.26447175}, // 16145K
			{0.261563204, 0.264469492}, // 16146K
			{0.261561494, 0.264467234}, // 16147K
			{0.261559783, 0.264464977}, // 16148K
			{0.261558073, 0.26446272}, // 16149K
			{0.261556363, 0.264460464}, // 16150K
			{0.261554653, 0.264458207}, // 16151K
			{0.261552944, 0.264455951}, // 16152K
			{0.261551234, 0.264453696}, // 16153K
			{0.261549525, 0.264451441}, // 16154K
			{0.261547817, 0.264449185}, // 16155K
			{0.261546108, 0.264446931}, // 16156K
			{0.2615444, 0.264444676}, // 16157K
			{0.261542692, 0.264442422}, // 16158K
			{0.261540984, 0.264440169}, // 16159K
			{0.261539277, 0.264437915}, // 16160K
			{0.26153757, 0.264435662}, // 16161K
			{0.261535863, 0.264433409}, // 16162K
			{0.261534156, 0.264431157}, // 16163K
			{0.26153245, 0.264428905}, // 16164K
			{0.261530744, 0.264426653}, // 16165K
			{0.261529038, 0.264424401}, // 16166K
			{0.261527332, 0.26442215}, // 16167K
			{0.261525627, 0.264419899}, // 16168K
			{0.261523921, 0.264417648}, // 16169K
			{0.261522217, 0.264415398}, // 16170K
			{0.261520512, 0.264413148}, // 16171K
			{0.261518808, 0.264410899}, // 16172K
			{0.261517103, 0.264408649}, // 16173K
			{0.2615154, 0.2644064}, // 16174K
			{0.261513696, 0.264404152}, // 16175K
			{0.261511993, 0.264401903}, // 16176K
			{0.261510289, 0.264399655}, // 16177K
			{0.261508587, 0.264397407}, // 16178K
			{0.261506884, 0.26439516}, // 16179K
			{0.261505182, 0.264392913}, // 16180K
			{0.26150348, 0.264390666}, // 16181K
			{0.261501778, 0.264388419}, // 16182K
			{0.261500076, 0.264386173}, // 16183K
			{0.261498375, 0.264383927}, // 16184K
			{0.261496674, 0.264381682}, // 16185K
			{0.261494973, 0.264379436}, // 16186K
			{0.261493272, 0.264377192}, // 16187K
			{0.261491572, 0.264374947}, // 16188K
			{0.261489872, 0.264372703}, // 16189K
			{0.261488172, 0.264370459}, // 16190K
			{0.261486473, 0.264368215}, // 16191K
			{0.261484774, 0.264365972}, // 16192K
			{0.261483075, 0.264363728}, // 16193K
			{0.261481376, 0.264361486}, // 16194K
			{0.261479677, 0.264359243}, // 16195K
			{0.261477979, 0.264357001}, // 16196K
			{0.261476281, 0.264354759}, // 16197K
			{0.261474583, 0.264352518}, // 16198K
			{0.261472886, 0.264350277}, // 16199K
			{0.261471188, 0.264348036}, // 16200K
			{0.261469491, 0.264345795}, // 16201K
			{0.261467795, 0.264343555}, // 16202K
			{0.261466098, 0.264341315}, // 16203K
			{0.261464402, 0.264339076}, // 16204K
			{0.261462706, 0.264336836}, // 16205K
			{0.26146101, 0.264334597}, // 16206K
			{0.261459315, 0.264332359}, // 16207K
			{0.26145762, 0.26433012}, // 16208K
			{0.261455925, 0.264327882}, // 16209K
			{0.26145423, 0.264325644}, // 16210K
			{0.261452535, 0.264323407}, // 16211K
			{0.261450841, 0.26432117}, // 16212K
			{0.261449147, 0.264318933}, // 16213K
			{0.261447453, 0.264316697}, // 16214K
			{0.26144576, 0.26431446}, // 16215K
			{0.261444067, 0.264312224}, // 16216K
			{0.261442374, 0.264309989}, // 16217K
			{0.261440681, 0.264307754}, // 16218K
			{0.261438989, 0.264305519}, // 16219K
			{0.261437297, 0.264303284}, // 16220K
			{0.261435605, 0.26430105}, // 16221K
			{0.261433913, 0.264298816}, // 16222K
			{0.261432222, 0.264296582}, // 16223K
			{0.26143053, 0.264294349}, // 16224K
			{0.261428839, 0.264292116}, // 16225K
			{0.261427149, 0.264289883}, // 16226K
			{0.261425458, 0.26428765}, // 16227K
			{0.261423768, 0.264285418}, // 16228K
			{0.261422078, 0.264283187}, // 16229K
			{0.261420389, 0.264280955}, // 16230K
			{0.261418699, 0.264278724}, // 16231K
			{0.26141701, 0.264276493}, // 16232K
			{0.261415321, 0.264274262}, // 16233K
			{0.261413632, 0.264272032}, // 16234K
			{0.261411944, 0.264269802}, // 16235K
			{0.261410256, 0.264267572}, // 16236K
			{0.261408568, 0.264265343}, // 16237K
			{0.26140688, 0.264263114}, // 16238K
			{0.261405193, 0.264260885}, // 16239K
			{0.261403506, 0.264258657}, // 16240K
			{0.261401819, 0.264256429}, // 16241K
			{0.261400132, 0.264254201}, // 16242K
			{0.261398446, 0.264251974}, // 16243K
			{0.26139676, 0.264249747}, // 16244K
			{0.261395074, 0.26424752}, // 16245K
			{0.261393388, 0.264245293}, // 16246K
			{0.261391703, 0.264243067}, // 16247K
			{0.261390018, 0.264240841}, // 16248K
			{0.261388333, 0.264238615}, // 16249K
			{0.261386648, 0.26423639}, // 16250K
			{0.261384964, 0.264234165}, // 16251K
			{0.26138328, 0.26423194}, // 16252K
			{0.261381596, 0.264229716}, // 16253K
			{0.261379912, 0.264227492}, // 16254K
			{0.261378229, 0.264225268}, // 16255K
			{0.261376545, 0.264223045}, // 16256K
			{0.261374863, 0.264220822}, // 16257K
			{0.26137318, 0.264218599}, // 16258K
			{0.261371498, 0.264216376}, // 16259K
			{0.261369815, 0.264214154}, // 16260K
			{0.261368134, 0.264211932}, // 16261K
			{0.261366452, 0.264209711}, // 16262K
			{0.261364771, 0.264207489}, // 16263K
			{0.261363089, 0.264205268}, // 16264K
			{0.261361409, 0.264203048}, // 16265K
			{0.261359728, 0.264200827}, // 16266K
			{0.261358048, 0.264198607}, // 16267K
			{0.261356367, 0.264196388}, // 16268K
			{0.261354688, 0.264194168}, // 16269K
			{0.261353008, 0.264191949}, // 16270K
			{0.261351329, 0.26418973}, // 16271K
			{0.261349649, 0.264187512}, // 16272K
			{0.261347971, 0.264185293}, // 16273K
			{0.261346292, 0.264183076}, // 16274K
			{0.261344614, 0.264180858}, // 16275K
			{0.261342935, 0.264178641}, // 16276K
			{0.261341257, 0.264176424}, // 16277K
			{0.26133958, 0.264174207}, // 16278K
			{0.261337902, 0.264171991}, // 16279K
			{0.261336225, 0.264169775}, // 16280K
			{0.261334548, 0.264167559}, // 16281K
			{0.261332872, 0.264165344}, // 16282K
			{0.261331195, 0.264163128}, // 16283K
			{0.261329519, 0.264160914}, // 16284K
			{0.261327843, 0.264158699}, // 16285K
			{0.261326168, 0.264156485}, // 16286K
			{0.261324492, 0.264154271}, // 16287K
			{0.261322817, 0.264152057}, // 16288K
			{0.261321142, 0.264149844}, // 16289K
			{0.261319468, 0.264147631}, // 16290K
			{0.261317793, 0.264145419}, // 16291K
			{0.261316119, 0.264143206}, // 16292K
			{0.261314445, 0.264140994}, // 16293K
			{0.261312772, 0.264138782}, // 16294K
			{0.261311098, 0.264136571}, // 16295K
			{0.261309425, 0.26413436}, // 16296K
			{0.261307752, 0.264132149}, // 16297K
			{0.261306079, 0.264129939}, // 16298K
			{0.261304407, 0.264127728}, // 16299K
			{0.261302735, 0.264125519}, // 16300K
			{0.261301063, 0.264123309}, // 16301K
			{0.261299391, 0.2641211}, // 16302K
			{0.26129772, 0.264118891}, // 16303K
			{0.261296049, 0.264116682}, // 16304K
			{0.261294378, 0.264114474}, // 16305K
			{0.261292707, 0.264112266}, // 16306K
			{0.261291037, 0.264110058}, // 16307K
			{0.261289367, 0.26410785}, // 16308K
			{0.261287697, 0.264105643}, // 16309K
			{0.261286027, 0.264103436}, // 16310K
			{0.261284358, 0.26410123}, // 16311K
			{0.261282688, 0.264099024}, // 16312K
			{0.261281019, 0.264096818}, // 16313K
			{0.261279351, 0.264094612}, // 16314K
			{0.261277682, 0.264092407}, // 16315K
			{0.261276014, 0.264090202}, // 16316K
			{0.261274346, 0.264087997}, // 16317K
			{0.261272678, 0.264085793}, // 16318K
			{0.261271011, 0.264083589}, // 16319K
			{0.261269344, 0.264081385}, // 16320K
			{0.261267677, 0.264079181}, // 16321K
			{0.26126601, 0.264076978}, // 16322K
			{0.261264344, 0.264074775}, // 16323K
			{0.261262677, 0.264072573}, // 16324K
			{0.261261011, 0.264070371}, // 16325K
			{0.261259346, 0.264068169}, // 16326K
			{0.26125768, 0.264065967}, // 16327K
			{0.261256015, 0.264063766}, // 16328K
			{0.26125435, 0.264061565}, // 16329K
			{0.261252685, 0.264059364}, // 16330K
			{0.261251021, 0.264057164}, // 16331K
			{0.261249357, 0.264054964}, // 16332K
			{0.261247693, 0.264052764}, // 16333K
			{0.261246029, 0.264050564}, // 16334K
			{0.261244365, 0.264048365}, // 16335K
			{0.261242702, 0.264046166}, // 16336K
			{0.261241039, 0.264043968}, // 16337K
			{0.261239376, 0.264041769}, // 16338K
			{0.261237714, 0.264039571}, // 16339K
			{0.261236052, 0.264037374}, // 16340K
			{0.26123439, 0.264035176}, // 16341K
			{0.261232728, 0.264032979}, // 16342K
			{0.261231066, 0.264030782}, // 16343K
			{0.261229405, 0.264028586}, // 16344K
			{0.261227744, 0.26402639}, // 16345K
			{0.261226083, 0.264024194}, // 16346K
			{0.261224423, 0.264021998}, // 16347K
			{0.261222762, 0.264019803}, // 16348K
			{0.261221102, 0.264017608}, // 16349K
			{0.261219442, 0.264015414}, // 16350K
			{0.261217783, 0.264013219}, // 16351K
			{0.261216123, 0.264011025}, // 16352K
			{0.261214464, 0.264008831}, // 16353K
			{0.261212806, 0.264006638}, // 16354K
			{0.261211147, 0.264004445}, // 16355K
			{0.261209489, 0.264002252}, // 16356K
			{0.261207831, 0.26400006}, // 16357K
			{0.261206173, 0.263997867}, // 16358K
			{0.261204515, 0.263995676}, // 16359K
			{0.261202858, 0.263993484}, // 16360K
			{0.261201201, 0.263991293}, // 16361K
			{0.261199544, 0.263989102}, // 16362K
			{0.261197887, 0.263986911}, // 16363K
			{0.261196231, 0.263984721}, // 16364K
			{0.261194575, 0.26398253}, // 16365K
			{0.261192919, 0.263980341}, // 16366K
			{0.261191263, 0.263978151}, // 16367K
			{0.261189608, 0.263975962}, // 16368K
			{0.261187953, 0.263973773}, // 16369K
			{0.261186298, 0.263971585}, // 16370K
			{0.261184643, 0.263969396}, // 16371K
			{0.261182989, 0.263967208}, // 16372K
			{0.261181334, 0.263965021}, // 16373K
			{0.26117968, 0.263962833}, // 16374K
			{0.261178027, 0.263960646}, // 16375K
			{0.261176373, 0.263958459}, // 16376K
			{0.26117472, 0.263956273}, // 16377K
			{0.261173067, 0.263954087}, // 16378K
			{0.261171414, 0.263951901}, // 16379K
			{0.261169762, 0.263949715}, // 16380K
			{0.26116811, 0.26394753}, // 16381K
			{0.261166458, 0.263945345}, // 16382K
			{0.261164806, 0.263943161}, // 16383K
			{0.261163155, 0.263940976}, // 16384K
			{0.261161503, 0.263938792}, // 16385K
			{0.261159852, 0.263936608}, // 16386K
			{0.261158202, 0.263934425}, // 16387K
			{0.261156551, 0.263932242}, // 16388K
			{0.261154901, 0.263930059}, // 16389K
			{0.261153251, 0.263927876}, // 16390K
			{0.261151601, 0.263925694}, // 16391K
			{0.261149951, 0.263923512}, // 16392K
			{0.261148302, 0.263921331}, // 16393K
			{0.261146653, 0.263919149}, // 16394K
			{0.261145004, 0.263916968}, // 16395K
			{0.261143356, 0.263914788}, // 16396K
			{0.261141707, 0.263912607}, // 16397K
			{0.261140059, 0.263910427}, // 16398K
			{0.261138411, 0.263908247}, // 16399K
			{0.261136764, 0.263906068}, // 16400K
			{0.261135116, 0.263903888}, // 16401K
			{0.261133469, 0.26390171}, // 16402K
			{0.261131822, 0.263899531}, // 16403K
			{0.261130176, 0.263897353}, // 16404K
			{0.261128529, 0.263895175}, // 16405K
			{0.261126883, 0.263892997}, // 16406K
			{0.261125237, 0.263890819}, // 16407K
			{0.261123592, 0.263888642}, // 16408K
			{0.261121946, 0.263886465}, // 16409K
			{0.261120301, 0.263884289}, // 16410K
			{0.261118656, 0.263882113}, // 16411K
			{0.261117012, 0.263879937}, // 16412K
			{0.261115367, 0.263877761}, // 16413K
			{0.261113723, 0.263875586}, // 16414K
			{0.261112079, 0.263873411}, // 16415K
			{0.261110435, 0.263871236}, // 16416K
			{0.261108792, 0.263869062}, // 16417K
			{0.261107149, 0.263866888}, // 16418K
			{0.261105506, 0.263864714}, // 16419K
			{0.261103863, 0.26386254}, // 16420K
			{0.26110222, 0.263860367}, // 16421K
			{0.261100578, 0.263858194}, // 16422K
			{0.261098936, 0.263856021}, // 16423K
			{0.261097294, 0.263853849}, // 16424K
			{0.261095653, 0.263851677}, // 16425K
			{0.261094011, 0.263849505}, // 16426K
			{0.26109237, 0.263847334}, // 16427K
			{0.26109073, 0.263845163}, // 16428K
			{0.261089089, 0.263842992}, // 16429K
			{0.261087449, 0.263840821}, // 16430K
			{0.261085809, 0.263838651}, // 16431K
			{0.261084169, 0.263836481}, // 16432K
			{0.261082529, 0.263834312}, // 16433K
			{0.26108089, 0.263832142}, // 16434K
			{0.261079251, 0.263829973}, // 16435K
			{0.261077612, 0.263827804}, // 16436K
			{0.261075973, 0.263825636}, // 16437K
			{0.261074335, 0.263823468}, // 16438K
			{0.261072696, 0.2638213}, // 16439K
			{0.261071059, 0.263819132}, // 16440K
			{0.261069421, 0.263816965}, // 16441K
			{0.261067783, 0.263814798}, // 16442K
			{0.261066146, 0.263812632}, // 16443K
			{0.261064509, 0.263810465}, // 16444K
			{0.261062873, 0.263808299}, // 16445K
			{0.261061236, 0.263806133}, // 16446K
			{0.2610596, 0.263803968}, // 16447K
			{0.261057964, 0.263801803}, // 16448K
			{0.261056328, 0.263799638}, // 16449K
			{0.261054693, 0.263797473}, // 16450K
			{0.261053057, 0.263795309}, // 16451K
			{0.261051422, 0.263793145}, // 16452K
			{0.261049788, 0.263790981}, // 16453K
			{0.261048153, 0.263788818}, // 16454K
			{0.261046519, 0.263786655}, // 16455K
			{0.261044885, 0.263784492}, // 16456K
			{0.261043251, 0.26378233}, // 16457K
			{0.261041617, 0.263780168}, // 16458K
			{0.261039984, 0.263778006}, // 16459K
			{0.261038351, 0.263775844}, // 16460K
			{0.261036718, 0.263773683}, // 16461K
			{0.261035085, 0.263771522}, // 16462K
			{0.261033453, 0.263769361}, // 16463K
			{0.261031821, 0.263767201}, // 16464K
			{0.261030189, 0.263765041}, // 16465K
			{0.261028557, 0.263762881}, // 16466K
			{0.261026926, 0.263760721}, // 16467K
			{0.261025294, 0.263758562}, // 16468K
			{0.261023664, 0.263756403}, // 16469K
			{0.261022033, 0.263754244}, // 16470K
			{0.261020402, 0.263752086}, // 16471K
			{0.261018772, 0.263749928}, // 16472K
			{0.261017142, 0.26374777}, // 16473K
			{0.261015512, 0.263745613}, // 16474K
			{0.261013883, 0.263743456}, // 16475K
			{0.261012254, 0.263741299}, // 16476K
			{0.261010625, 0.263739142}, // 16477K
			{0.261008996, 0.263736986}, // 16478K
			{0.261007367, 0.26373483}, // 16479K
			{0.261005739, 0.263732674}, // 16480K
			{0.261004111, 0.263730519}, // 16481K
			{0.261002483, 0.263728364}, // 16482K
			{0.261000855, 0.263726209}, // 16483K
			{0.260999228, 0.263724055}, // 16484K
			{0.260997601, 0.263721901}, // 16485K
			{0.260995974, 0.263719747}, // 16486K
			{0.260994347, 0.263717593}, // 16487K
			{0.260992721, 0.26371544}, // 16488K
			{0.260991095, 0.263713287}, // 16489K
			{0.260989469, 0.263711134}, // 16490K
			{0.260987843, 0.263708982}, // 16491K
			{0.260986218, 0.26370683}, // 16492K
			{0.260984592, 0.263704678}, // 16493K
			{0.260982967, 0.263702526}, // 16494K
			{0.260981343, 0.263700375}, // 16495K
			{0.260979718, 0.263698224}, // 16496K
			{0.260978094, 0.263696073}, // 16497K
			{0.26097647, 0.263693923}, // 16498K
			{0.260974846, 0.263691773}, // 16499K
			{0.260973223, 0.263689623}, // 16500K
			{0.260971599, 0.263687474}, // 16501K
			{0.260969976, 0.263685325}, // 16502K
			{0.260968353, 0.263683176}, // 16503K
			{0.260966731, 0.263681027}, // 16504K
			{0.260965108, 0.263678879}, // 16505K
			{0.260963486, 0.263676731}, // 16506K
			{0.260961864, 0.263674583}, // 16507K
			{0.260960243, 0.263672436}, // 16508K
			{0.260958621, 0.263670289}, // 16509K
			{0.260957, 0.263668142}, // 16510K
			{0.260955379, 0.263665995}, // 16511K
			{0.260953758, 0.263663849}, // 16512K
			{0.260952138, 0.263661703}, // 16513K
			{0.260950518, 0.263659558}, // 16514K
			{0.260948898, 0.263657412}, // 16515K
			{0.260947278, 0.263655267}, // 16516K
			{0.260945658, 0.263653122}, // 16517K
			{0.260944039, 0.263650978}, // 16518K
			{0.26094242, 0.263648834}, // 16519K
			{0.260940801, 0.26364669}, // 16520K
			{0.260939183, 0.263644546}, // 16521K
			{0.260937564, 0.263642403}, // 16522K
			{0.260935946, 0.26364026}, // 16523K
			{0.260934328, 0.263638117}, // 16524K
			{0.260932711, 0.263635975}, // 16525K
			{0.260931093, 0.263633833}, // 16526K
			{0.260929476, 0.263631691}, // 16527K
			{0.260927859, 0.26362955}, // 16528K
			{0.260926243, 0.263627408}, // 16529K
			{0.260924626, 0.263625267}, // 16530K
			{0.26092301, 0.263623127}, // 16531K
			{0.260921394, 0.263620986}, // 16532K
			{0.260919778, 0.263618846}, // 16533K
			{0.260918163, 0.263616707}, // 16534K
			{0.260916548, 0.263614567}, // 16535K
			{0.260914933, 0.263612428}, // 16536K
			{0.260913318, 0.263610289}, // 16537K
			{0.260911703, 0.26360815}, // 16538K
			{0.260910089, 0.263606012}, // 16539K
			{0.260908475, 0.263603874}, // 16540K
			{0.260906861, 0.263601736}, // 16541K
			{0.260905247, 0.263599599}, // 16542K
			{0.260903634, 0.263597462}, // 16543K
			{0.260902021, 0.263595325}, // 16544K
			{0.260900408, 0.263593188}, // 16545K
			{0.260898795, 0.263591052}, // 16546K
			{0.260897183, 0.263588916}, // 16547K
			{0.260895571, 0.263586781}, // 16548K
			{0.260893959, 0.263584645}, // 16549K
			{0.260892347, 0.26358251}, // 16550K
			{0.260890736, 0.263580375}, // 16551K
			{0.260889124, 0.263578241}, // 16552K
			{0.260887513, 0.263576107}, // 16553K
			{0.260885903, 0.263573973}, // 16554K
			{0.260884292, 0.263571839}, // 16555K
			{0.260882682, 0.263569706}, // 16556K
			{0.260881072, 0.263567573}, // 16557K
			{0.260879462, 0.26356544}, // 16558K
			{0.260877852, 0.263563307}, // 16559K
			{0.260876243, 0.263561175}, // 16560K
			{0.260874634, 0.263559043}, // 16561K
			{0.260873025, 0.263556912}, // 16562K
			{0.260871416, 0.26355478}, // 16563K
			{0.260869808, 0.263552649}, // 16564K
			{0.260868199, 0.263550519}, // 16565K
			{0.260866592, 0.263548388}, // 16566K
			{0.260864984, 0.263546258}, // 16567K
			{0.260863376, 0.263544128}, // 16568K
			{0.260861769, 0.263541999}, // 16569K
			{0.260860162, 0.26353987}, // 16570K
			{0.260858555, 0.263537741}, // 16571K
			{0.260856949, 0.263535612}, // 16572K
			{0.260855342, 0.263533483}, // 16573K
			{0.260853736, 0.263531355}, // 16574K
			{0.26085213, 0.263529228}, // 16575K
			{0.260850525, 0.2635271}, // 16576K
			{0.260848919, 0.263524973}, // 16577K
			{0.260847314, 0.263522846}, // 16578K
			{0.260845709, 0.263520719}, // 16579K
			{0.260844105, 0.263518593}, // 16580K
			{0.2608425, 0.263516467}, // 16581K
			{0.260840896, 0.263514341}, // 16582K
			{0.260839292, 0.263512216}, // 16583K
			{0.260837688, 0.26351009}, // 16584K
			{0.260836085, 0.263507965}, // 16585K
			{0.260834482, 0.263505841}, // 16586K
			{0.260832878, 0.263503717}, // 16587K
			{0.260831276, 0.263501592}, // 16588K
			{0.260829673, 0.263499469}, // 16589K
			{0.260828071, 0.263497345}, // 16590K
			{0.260826469, 0.263495222}, // 16591K
			{0.260824867, 0.263493099}, // 16592K
			{0.260823265, 0.263490977}, // 16593K
			{0.260821664, 0.263488854}, // 16594K
			{0.260820063, 0.263486732}, // 16595K
			{0.260818462, 0.263484611}, // 16596K
			{0.260816861, 0.263482489}, // 16597K
			{0.26081526, 0.263480368}, // 16598K
			{0.26081366, 0.263478247}, // 16599K
			{0.26081206, 0.263476127}, // 16600K
			{0.26081046, 0.263474006}, // 16601K
			{0.260808861, 0.263471886}, // 16602K
			{0.260807261, 0.263469767}, // 16603K
			{0.260805662, 0.263467647}, // 16604K
			{0.260804064, 0.263465528}, // 16605K
			{0.260802465, 0.263463409}, // 16606K
			{0.260800867, 0.263461291}, // 16607K
			{0.260799268, 0.263459172}, // 16608K
			{0.26079767, 0.263457055}, // 16609K
			{0.260796073, 0.263454937}, // 16610K
			{0.260794475, 0.263452819}, // 16611K
			{0.260792878, 0.263450702}, // 16612K
			{0.260791281, 0.263448586}, // 16613K
			{0.260789684, 0.263446469}, // 16614K
			{0.260788088, 0.263444353}, // 16615K
			{0.260786492, 0.263442237}, // 16616K
			{0.260784896, 0.263440121}, // 16617K
			{0.2607833, 0.263438006}, // 16618K
			{0.260781704, 0.263435891}, // 16619K
			{0.260780109, 0.263433776}, // 16620K
			{0.260778514, 0.263431661}, // 16621K
			{0.260776919, 0.263429547}, // 16622K
			{0.260775324, 0.263427433}, // 16623K
			{0.26077373, 0.26342532}, // 16624K
			{0.260772135, 0.263423206}, // 16625K
			{0.260770541, 0.263421093}, // 16626K
			{0.260768948, 0.26341898}, // 16627K
			{0.260767354, 0.263416868}, // 16628K
			{0.260765761, 0.263414756}, // 16629K
			{0.260764168, 0.263412644}, // 16630K
			{0.260762575, 0.263410532}, // 16631K
			{0.260760982, 0.263408421}, // 16632K
			{0.26075939, 0.26340631}, // 16633K
			{0.260757798, 0.263404199}, // 16634K
			{0.260756206, 0.263402089}, // 16635K
			{0.260754614, 0.263399978}, // 16636K
			{0.260753023, 0.263397868}, // 16637K
			{0.260751432, 0.263395759}, // 16638K
			{0.260749841, 0.26339365}, // 16639K
			{0.26074825, 0.26339154}, // 16640K
			{0.26074666, 0.263389432}, // 16641K
			{0.260745069, 0.263387323}, // 16642K
			{0.260743479, 0.263385215}, // 16643K
			{0.260741889, 0.263383107}, // 16644K
			{0.2607403, 0.263381}, // 16645K
			{0.260738711, 0.263378892}, // 16646K
			{0.260737121, 0.263376785}, // 16647K
			{0.260735533, 0.263374678}, // 16648K
			{0.260733944, 0.263372572}, // 16649K
			{0.260732355, 0.263370466}, // 16650K
			{0.260730767, 0.26336836}, // 16651K
			{0.260729179, 0.263366254}, // 16652K
			{0.260727592, 0.263364149}, // 16653K
			{0.260726004, 0.263362044}, // 16654K
			{0.260724417, 0.263359939}, // 16655K
			{0.26072283, 0.263357835}, // 16656K
			{0.260721243, 0.263355731}, // 16657K
			{0.260719656, 0.263353627}, // 16658K
			{0.26071807, 0.263351523}, // 16659K
			{0.260716484, 0.26334942}, // 16660K
			{0.260714898, 0.263347317}, // 16661K
			{0.260713312, 0.263345214}, // 16662K
			{0.260711727, 0.263343111}, // 16663K
			{0.260710142, 0.263341009}, // 16664K
			{0.260708557, 0.263338907}, // 16665K
			{0.260706972, 0.263336806}, // 16666K
			{0.260705387, 0.263334704}, // 16667K
			{0.260703803, 0.263332603}, // 16668K
			{0.260702219, 0.263330503}, // 16669K
			{0.260700635, 0.263328402}, // 16670K
			{0.260699052, 0.263326302}, // 16671K
			{0.260697468, 0.263324202}, // 16672K
			{0.260695885, 0.263322103}, // 16673K
			{0.260694302, 0.263320003}, // 16674K
			{0.26069272, 0.263317904}, // 16675K
			{0.260691137, 0.263315805}, // 16676K
			{0.260689555, 0.263313707}, // 16677K
			{0.260687973, 0.263311609}, // 16678K
			{0.260686391, 0.263309511}, // 16679K
			{0.26068481, 0.263307413}, // 16680K
			{0.260683228, 0.263305316}, // 16681K
			{0.260681647, 0.263303219}, // 16682K
			{0.260680066, 0.263301122}, // 16683K
			{0.260678486, 0.263299026}, // 16684K
			{0.260676905, 0.263296929}, // 16685K
			{0.260675325, 0.263294833}, // 16686K
			{0.260673745, 0.263292738}, // 16687K
			{0.260672166, 0.263290643}, // 16688K
			{0.260670586, 0.263288547}, // 16689K
			{0.260669007, 0.263286453}, // 16690K
			{0.260667428, 0.263284358}, // 16691K
			{0.260665849, 0.263282264}, // 16692K
			{0.26066427, 0.26328017}, // 16693K
			{0.260662692, 0.263278076}, // 16694K
			{0.260661114, 0.263275983}, // 16695K
			{0.260659536, 0.26327389}, // 16696K
			{0.260657959, 0.263271797}, // 16697K
			{0.260656381, 0.263269705}, // 16698K
			{0.260654804, 0.263267612}, // 16699K
			{0.260653227, 0.263265521}, // 16700K
			{0.26065165, 0.263263429}, // 16701K
			{0.260650074, 0.263261338}, // 16702K
			{0.260648497, 0.263259246}, // 16703K
			{0.260646921, 0.263257156}, // 16704K
			{0.260645346, 0.263255065}, // 16705K
			{0.26064377, 0.263252975}, // 16706K
			{0.260642195, 0.263250885}, // 16707K
			{0.260640619, 0.263248795}, // 16708K
			{0.260639045, 0.263246706}, // 16709K
			{0.26063747, 0.263244617}, // 16710K
			{0.260635895, 0.263242528}, // 16711K
			{0.260634321, 0.263240439}, // 16712K
			{0.260632747, 0.263238351}, // 16713K
			{0.260631173, 0.263236263}, // 16714K
			{0.2606296, 0.263234175}, // 16715K
			{0.260628027, 0.263232088}, // 16716K
			{0.260626453, 0.263230001}, // 16717K
			{0.260624881, 0.263227914}, // 16718K
			{0.260623308, 0.263225828}, // 16719K
			{0.260621736, 0.263223741}, // 16720K
			{0.260620163, 0.263221655}, // 16721K
			{0.260618591, 0.26321957}, // 16722K
			{0.26061702, 0.263217484}, // 16723K
			{0.260615448, 0.263215399}, // 16724K
			{0.260613877, 0.263213314}, // 16725K
			{0.260612306, 0.26321123}, // 16726K
			{0.260610735, 0.263209145}, // 16727K
			{0.260609164, 0.263207061}, // 16728K
			{0.260607594, 0.263204977}, // 16729K
			{0.260606024, 0.263202894}, // 16730K
			{0.260604454, 0.263200811}, // 16731K
			{0.260602884, 0.263198728}, // 16732K
			{0.260601315, 0.263196645}, // 16733K
			{0.260599746, 0.263194563}, // 16734K
			{0.260598177, 0.263192481}, // 16735K
			{0.260596608, 0.263190399}, // 16736K
			{0.260595039, 0.263188318}, // 16737K
			{0.260593471, 0.263186237}, // 16738K
			{0.260591903, 0.263184156}, // 16739K
			{0.260590335, 0.263182075}, // 16740K
			{0.260588767, 0.263179995}, // 16741K
			{0.2605872, 0.263177915}, // 16742K
			{0.260585633, 0.263175835}, // 16743K
			{0.260584066, 0.263173755}, // 16744K
			{0.260582499, 0.263171676}, // 16745K
			{0.260580932, 0.263169597}, // 16746K
			{0.260579366, 0.263167518}, // 16747K
			{0.2605778, 0.26316544}, // 16748K
			{0.260576234, 0.263163362}, // 16749K
			{0.260574669, 0.263161284}, // 16750K
			{0.260573103, 0.263159206}, // 16751K
			{0.260571538, 0.263157129}, // 16752K
			{0.260569973, 0.263155052}, // 16753K
			{0.260568408, 0.263152976}, // 16754K
			{0.260566844, 0.263150899}, // 16755K
			{0.26056528, 0.263148823}, // 16756K
			{0.260563716, 0.263146747}, // 16757K
			{0.260562152, 0.263144671}, // 16758K
			{0.260560588, 0.263142596}, // 16759K
			{0.260559025, 0.263140521}, // 16760K
			{0.260557462, 0.263138446}, // 16761K
			{0.260555899, 0.263136372}, // 16762K
			{0.260554336, 0.263134298}, // 16763K
			{0.260552774, 0.263132224}, // 16764K
			{0.260551211, 0.26313015}, // 16765K
			{0.260549649, 0.263128077}, // 16766K
			{0.260548088, 0.263126004}, // 16767K
			{0.260546526, 0.263123931}, // 16768K
			{0.260544965, 0.263121859}, // 16769K
			{0.260543404, 0.263119786}, // 16770K
			{0.260541843, 0.263117714}, // 16771K
			{0.260540282, 0.263115643}, // 16772K
			{0.260538722, 0.263113571}, // 16773K
			{0.260537161, 0.2631115}, // 16774K
			{0.260535602, 0.263109429}, // 16775K
			{0.260534042, 0.263107359}, // 16776K
			{0.260532482, 0.263105289}, // 16777K
			{0.260530923, 0.263103219}, // 16778K
			{0.260529364, 0.263101149}, // 16779K
			{0.260527805, 0.263099079}, // 16780K
			{0.260526246, 0.26309701}, // 16781K
			{0.260524688, 0.263094941}, // 16782K
			{0.26052313, 0.263092873}, // 16783K
			{0.260521572, 0.263090804}, // 16784K
			{0.260520014, 0.263088736}, // 16785K
			{0.260518456, 0.263086669}, // 16786K
			{0.260516899, 0.263084601}, // 16787K
			{0.260515342, 0.263082534}, // 16788K
			{0.260513785, 0.263080467}, // 16789K
			{0.260512229, 0.2630784}, // 16790K
			{0.260510672, 0.263076334}, // 16791K
			{0.260509116, 0.263074268}, // 16792K
			{0.26050756, 0.263072202}, // 16793K
			{0.260506004, 0.263070137}, // 16794K
			{0.260504449, 0.263068071}, // 16795K
			{0.260502894, 0.263066006}, // 16796K
			{0.260501339, 0.263063942}, // 16797K
			{0.260499784, 0.263061877}, // 16798K
			{0.260498229, 0.263059813}, // 16799K
			{0.260496675, 0.263057749}, // 16800K
			{0.260495121, 0.263055686}, // 16801K
			{0.260493567, 0.263053622}, // 16802K
			{0.260492013, 0.263051559}, // 16803K
			{0.260490459, 0.263049497}, // 16804K
			{0.260488906, 0.263047434}, // 16805K
			{0.260487353, 0.263045372}, // 16806K
			{0.2604858, 0.26304331}, // 16807K
			{0.260484248, 0.263041248}, // 16808K
			{0.260482695, 0.263039187}, // 16809K
			{0.260481143, 0.263037126}, // 16810K
			{0.260479591, 0.263035065}, // 16811K
			{0.260478039, 0.263033005}, // 16812K
			{0.260476488, 0.263030944}, // 16813K
			{0.260474937, 0.263028884}, // 16814K
			{0.260473386, 0.263026825}, // 16815K
			{0.260471835, 0.263024765}, // 16816K
			{0.260470284, 0.263022706}, // 16817K
			{0.260468734, 0.263020647}, // 16818K
			{0.260467184, 0.263018589}, // 16819K
			{0.260465634, 0.26301653}, // 16820K
			{0.260464084, 0.263014472}, // 16821K
			{0.260462535, 0.263012415}, // 16822K
			{0.260460985, 0.263010357}, // 16823K
			{0.260459436, 0.2630083}, // 16824K
			{0.260457887, 0.263006243}, // 16825K
			{0.260456339, 0.263004186}, // 16826K
			{0.260454791, 0.26300213}, // 16827K
			{0.260453242, 0.263000074}, // 16828K
			{0.260451694, 0.262998018}, // 16829K
			{0.260450147, 0.262995963}, // 16830K
			{0.260448599, 0.262993907}, // 16831K
			{0.260447052, 0.262991852}, // 16832K
			{0.260445505, 0.262989798}, // 16833K
			{0.260443958, 0.262987743}, // 16834K
			{0.260442412, 0.262985689}, // 16835K
			{0.260440865, 0.262983635}, // 16836K
			{0.260439319, 0.262981582}, // 16837K
			{0.260437773, 0.262979528}, // 16838K
			{0.260436227, 0.262977475}, // 16839K
			{0.260434682, 0.262975422}, // 16840K
			{0.260433137, 0.26297337}, // 16841K
			{0.260431592, 0.262971318}, // 16842K
			{0.260430047, 0.262969266}, // 16843K
			{0.260428502, 0.262967214}, // 16844K
			{0.260426958, 0.262965163}, // 16845K
			{0.260425414, 0.262963112}, // 16846K
			{0.26042387, 0.262961061}, // 16847K
			{0.260422326, 0.26295901}, // 16848K
			{0.260420782, 0.26295696}, // 16849K
			{0.260419239, 0.26295491}, // 16850K
			{0.260417696, 0.26295286}, // 16851K
			{0.260416153, 0.262950811}, // 16852K
			{0.260414611, 0.262948761}, // 16853K
			{0.260413068, 0.262946712}, // 16854K
			{0.260411526, 0.262944664}, // 16855K
			{0.260409984, 0.262942615}, // 16856K
			{0.260408442, 0.262940567}, // 16857K
			{0.260406901, 0.262938519}, // 16858K
			{0.26040536, 0.262936472}, // 16859K
			{0.260403819, 0.262934425}, // 16860K
			{0.260402278, 0.262932378}, // 16861K
			{0.260400737, 0.262930331}, // 16862K
			{0.260399197, 0.262928284}, // 16863K
			{0.260397656, 0.262926238}, // 16864K
			{0.260396117, 0.262924192}, // 16865K
			{0.260394577, 0.262922147}, // 16866K
			{0.260393037, 0.262920101}, // 16867K
			{0.260391498, 0.262918056}, // 16868K
			{0.260389959, 0.262916012}, // 16869K
			{0.26038842, 0.262913967}, // 16870K
			{0.260386881, 0.262911923}, // 16871K
			{0.260385343, 0.262909879}, // 16872K
			{0.260383805, 0.262907835}, // 16873K
			{0.260382267, 0.262905792}, // 16874K
			{0.260380729, 0.262903749}, // 16875K
			{0.260379191, 0.262901706}, // 16876K
			{0.260377654, 0.262899663}, // 16877K
			{0.260376117, 0.262897621}, // 16878K
			{0.26037458, 0.262895579}, // 16879K
			{0.260373043, 0.262893537}, // 16880K
			{0.260371507, 0.262891495}, // 16881K
			{0.260369971, 0.262889454}, // 16882K
			{0.260368435, 0.262887413}, // 16883K
			{0.260366899, 0.262885372}, // 16884K
			{0.260365363, 0.262883332}, // 16885K
			{0.260363828, 0.262881292}, // 16886K
			{0.260362293, 0.262879252}, // 16887K
			{0.260360758, 0.262877212}, // 16888K
			{0.260359223, 0.262875173}, // 16889K
			{0.260357689, 0.262873134}, // 16890K
			{0.260356155, 0.262871095}, // 16891K
			{0.260354621, 0.262869057}, // 16892K
			{0.260353087, 0.262867019}, // 16893K
			{0.260351553, 0.262864981}, // 16894K
			{0.26035002, 0.262862943}, // 16895K
			{0.260348487, 0.262860906}, // 16896K
			{0.260346954, 0.262858868}, // 16897K
			{0.260345421, 0.262856832}, // 16898K
			{0.260343889, 0.262854795}, // 16899K
			{0.260342356, 0.262852759}, // 16900K
			{0.260340824, 0.262850723}, // 16901K
			{0.260339292, 0.262848687}, // 16902K
			{0.260337761, 0.262846651}, // 16903K
			{0.260336229, 0.262844616}, // 16904K
			{0.260334698, 0.262842581}, // 16905K
			{0.260333167, 0.262840546}, // 16906K
			{0.260331636, 0.262838512}, // 16907K
			{0.260330106, 0.262836478}, // 16908K
			{0.260328576, 0.262834444}, // 16909K
			{0.260327046, 0.26283241}, // 16910K
			{0.260325516, 0.262830377}, // 16911K
			{0.260323986, 0.262828344}, // 16912K
			{0.260322457, 0.262826311}, // 16913K
			{0.260320927, 0.262824279}, // 16914K
			{0.260319398, 0.262822246}, // 16915K
			{0.26031787, 0.262820215}, // 16916K
			{0.260316341, 0.262818183}, // 16917K
			{0.260314813, 0.262816151}, // 16918K
			{0.260313285, 0.26281412}, // 16919K
			{0.260311757, 0.262812089}, // 16920K
			{0.260310229, 0.262810059}, // 16921K
			{0.260308701, 0.262808028}, // 16922K
			{0.260307174, 0.262805998}, // 16923K
			{0.260305647, 0.262803969}, // 16924K
			{0.26030412, 0.262801939}, // 16925K
			{0.260302594, 0.26279991}, // 16926K
			{0.260301067, 0.262797881}, // 16927K
			{0.260299541, 0.262795852}, // 16928K
			{0.260298015, 0.262793824}, // 16929K
			{0.26029649, 0.262791796}, // 16930K
			{0.260294964, 0.262789768}, // 16931K
			{0.260293439, 0.26278774}, // 16932K
			{0.260291914, 0.262785713}, // 16933K
			{0.260290389, 0.262783686}, // 16934K
			{0.260288864, 0.262781659}, // 16935K
			{0.26028734, 0.262779632}, // 16936K
			{0.260285815, 0.262777606}, // 16937K
			{0.260284291, 0.26277558}, // 16938K
			{0.260282768, 0.262773554}, // 16939K
			{0.260281244, 0.262771529}, // 16940K
			{0.260279721, 0.262769504}, // 16941K
			{0.260278198, 0.262767479}, // 16942K
			{0.260276675, 0.262765454}, // 16943K
			{0.260275152, 0.26276343}, // 16944K
			{0.26027363, 0.262761406}, // 16945K
			{0.260272107, 0.262759382}, // 16946K
			{0.260270585, 0.262757358}, // 16947K
			{0.260269063, 0.262755335}, // 16948K
			{0.260267542, 0.262753312}, // 16949K
			{0.26026602, 0.262751289}, // 16950K
			{0.260264499, 0.262749267}, // 16951K
			{0.260262978, 0.262747245}, // 16952K
			{0.260261458, 0.262745223}, // 16953K
			{0.260259937, 0.262743201}, // 16954K
			{0.260258417, 0.26274118}, // 16955K
			{0.260256897, 0.262739158}, // 16956K
			{0.260255377, 0.262737138}, // 16957K
			{0.260253857, 0.262735117}, // 16958K
			{0.260252338, 0.262733097}, // 16959K
			{0.260250818, 0.262731077}, // 16960K
			{0.260249299, 0.262729057}, // 16961K
			{0.260247781, 0.262727037}, // 16962K
			{0.260246262, 0.262725018}, // 16963K
			{0.260244744, 0.262722999}, // 16964K
			{0.260243226, 0.26272098}, // 16965K
			{0.260241708, 0.262718962}, // 16966K
			{0.26024019, 0.262716944}, // 16967K
			{0.260238672, 0.262714926}, // 16968K
			{0.260237155, 0.262712908}, // 16969K
			{0.260235638, 0.262710891}, // 16970K
			{0.260234121, 0.262708874}, // 16971K
			{0.260232605, 0.262706857}, // 16972K
			{0.260231088, 0.262704841}, // 16973K
			{0.260229572, 0.262702824}, // 16974K
			{0.260228056, 0.262700808}, // 16975K
			{0.26022654, 0.262698792}, // 16976K
			{0.260225025, 0.262696777}, // 16977K
			{0.260223509, 0.262694762}, // 16978K
			{0.260221994, 0.262692747}, // 16979K
			{0.260220479, 0.262690732}, // 16980K
			{0.260218964, 0.262688718}, // 16981K
			{0.26021745, 0.262686704}, // 16982K
			{0.260215936, 0.26268469}, // 16983K
			{0.260214422, 0.262682676}, // 16984K
			{0.260212908, 0.262680663}, // 16985K
			{0.260211394, 0.26267865}, // 16986K
			{0.260209881, 0.262676637}, // 16987K
			{0.260208368, 0.262674625}, // 16988K
			{0.260206855, 0.262672612}, // 16989K
			{0.260205342, 0.2626706}, // 16990K
			{0.260203829, 0.262668589}, // 16991K
			{0.260202317, 0.262666577}, // 16992K
			{0.260200805, 0.262664566}, // 16993K
			{0.260199293, 0.262662555}, // 16994K
			{0.260197781, 0.262660544}, // 16995K
			{0.26019627, 0.262658534}, // 16996K
			{0.260194758, 0.262656524}, // 16997K
			{0.260193247, 0.262654514}, // 16998K
			{0.260191737, 0.262652505}, // 16999K
			{0.260190226, 0.262650495}, // 17000K
			{0.260188716, 0.262648486}, // 17001K
			{0.260187205, 0.262646477}, // 17002K
			{0.260185695, 0.262644469}, // 17003K
			{0.260184186, 0.262642461}, // 17004K
			{0.260182676, 0.262640453}, // 17005K
			{0.260181167, 0.262638445}, // 17006K
			{0.260179658, 0.262636438}, // 17007K
			{0.260178149, 0.26263443}, // 17008K
			{0.26017664, 0.262632424}, // 17009K
			{0.260175132, 0.262630417}, // 17010K
			{0.260173623, 0.262628411}, // 17011K
			{0.260172115, 0.262626404}, // 17012K
			{0.260170607, 0.262624399}, // 17013K
			{0.2601691, 0.262622393}, // 17014K
			{0.260167592, 0.262620388}, // 17015K
			{0.260166085, 0.262618383}, // 17016K
			{0.260164578, 0.262616378}, // 17017K
			{0.260163071, 0.262614373}, // 17018K
			{0.260161565, 0.262612369}, // 17019K
			{0.260160059, 0.262610365}, // 17020K
			{0.260158552, 0.262608362}, // 17021K
			{0.260157047, 0.262606358}, // 17022K
			{0.260155541, 0.262604355}, // 17023K
			{0.260154035, 0.262602352}, // 17024K
			{0.26015253, 0.262600349}, // 17025K
			{0.260151025, 0.262598347}, // 17026K
			{0.26014952, 0.262596345}, // 17027K
			{0.260148016, 0.262594343}, // 17028K
			{0.260146511, 0.262592342}, // 17029K
			{0.260145007, 0.26259034}, // 17030K
			{0.260143503, 0.262588339}, // 17031K
			{0.260141999, 0.262586338}, // 17032K
			{0.260140496, 0.262584338}, // 17033K
			{0.260138992, 0.262582338}, // 17034K
			{0.260137489, 0.262580338}, // 17035K
			{0.260135986, 0.262578338}, // 17036K
			{0.260134483, 0.262576339}, // 17037K
			{0.260132981, 0.262574339}, // 17038K
			{0.260131479, 0.262572341}, // 17039K
			{0.260129977, 0.262570342}, // 17040K
			{0.260128475, 0.262568344}, // 17041K
			{0.260126973, 0.262566345}, // 17042K
			{0.260125472, 0.262564348}, // 17043K
			{0.26012397, 0.26256235}, // 17044K
			{0.260122469, 0.262560353}, // 17045K
			{0.260120968, 0.262558356}, // 17046K
			{0.260119468, 0.262556359}, // 17047K
			{0.260117968, 0.262554362}, // 17048K
			{0.260116467, 0.262552366}, // 17049K
			{0.260114967, 0.26255037}, // 17050K
			{0.260113468, 0.262548374}, // 17051K
			{0.260111968, 0.262546379}, // 17052K
			{0.260110469, 0.262544384}, // 17053K
			{0.26010897, 0.262542389}, // 17054K
			{0.260107471, 0.262540394}, // 17055K
			{0.260105972, 0.2625384}, // 17056K
			{0.260104474, 0.262536406}, // 17057K
			{0.260102975, 0.262534412}, // 17058K
			{0.260101477, 0.262532418}, // 17059K
			{0.26009998, 0.262530425}, // 17060K
			{0.260098482, 0.262528432}, // 17061K
			{0.260096984, 0.262526439}, // 17062K
			{0.260095487, 0.262524446}, // 17063K
			{0.26009399, 0.262522454}, // 17064K
			{0.260092493, 0.262520462}, // 17065K
			{0.260090997, 0.26251847}, // 17066K
			{0.260089501, 0.262516479}, // 17067K
			{0.260088004, 0.262514488}, // 17068K
			{0.260086509, 0.262512497}, // 17069K
			{0.260085013, 0.262510506}, // 17070K
			{0.260083517, 0.262508515}, // 17071K
			{0.260082022, 0.262506525}, // 17072K
			{0.260080527, 0.262504535}, // 17073K
			{0.260079032, 0.262502546}, // 17074K
			{0.260077537, 0.262500556}, // 17075K
			{0.260076043, 0.262498567}, // 17076K
			{0.260074549, 0.262496578}, // 17077K
			{0.260073055, 0.26249459}, // 17078K
			{0.260071561, 0.262492601}, // 17079K
			{0.260070067, 0.262490613}, // 17080K
			{0.260068574, 0.262488626}, // 17081K
			{0.260067081, 0.262486638}, // 17082K
			{0.260065588, 0.262484651}, // 17083K
			{0.260064095, 0.262482664}, // 17084K
			{0.260062602, 0.262480677}, // 17085K
			{0.26006111, 0.262478691}, // 17086K
			{0.260059618, 0.262476704}, // 17087K
			{0.260058126, 0.262474718}, // 17088K
			{0.260056634, 0.262472733}, // 17089K
			{0.260055143, 0.262470747}, // 17090K
			{0.260053651, 0.262468762}, // 17091K
			{0.26005216, 0.262466777}, // 17092K
			{0.260050669, 0.262464793}, // 17093K
			{0.260049179, 0.262462808}, // 17094K
			{0.260047688, 0.262460824}, // 17095K
			{0.260046198, 0.26245884}, // 17096K
			{0.260044708, 0.262456857}, // 17097K
			{0.260043218, 0.262454873}, // 17098K
			{0.260041729, 0.26245289}, // 17099K
			{0.260040239, 0.262450907}, // 17100K
			{0.26003875, 0.262448925}, // 17101K
			{0.260037261, 0.262446943}, // 17102K
			{0.260035772, 0.262444961}, // 17103K
			{0.260034284, 0.262442979}, // 17104K
			{0.260032795, 0.262440997}, // 17105K
			{0.260031307, 0.262439016}, // 17106K
			{0.260029819, 0.262437035}, // 17107K
			{0.260028332, 0.262435055}, // 17108K
			{0.260026844, 0.262433074}, // 17109K
			{0.260025357, 0.262431094}, // 17110K
			{0.26002387, 0.262429114}, // 17111K
			{0.260022383, 0.262427134}, // 17112K
			{0.260020896, 0.262425155}, // 17113K
			{0.26001941, 0.262423176}, // 17114K
			{0.260017923, 0.262421197}, // 17115K
			{0.260016437, 0.262419218}, // 17116K
			{0.260014951, 0.26241724}, // 17117K
			{0.260013466, 0.262415262}, // 17118K
			{0.26001198, 0.262413284}, // 17119K
			{0.260010495, 0.262411307}, // 17120K
			{0.26000901, 0.262409329}, // 17121K
			{0.260007525, 0.262407352}, // 17122K
			{0.260006041, 0.262405375}, // 17123K
			{0.260004556, 0.262403399}, // 17124K
			{0.260003072, 0.262401423}, // 17125K
			{0.260001588, 0.262399447}, // 17126K
			{0.260000105, 0.262397471}, // 17127K
			{0.259998621, 0.262395495}, // 17128K
			{0.259997138, 0.26239352}, // 17129K
			{0.259995655, 0.262391545}, // 17130K
			{0.259994172, 0.262389571}, // 17131K
			{0.259992689, 0.262387596}, // 17132K
			{0.259991207, 0.262385622}, // 17133K
			{0.259989724, 0.262383648}, // 17134K
			{0.259988242, 0.262381675}, // 17135K
			{0.25998676, 0.262379701}, // 17136K
			{0.259985279, 0.262377728}, // 17137K
			{0.259983797, 0.262375755}, // 17138K
			{0.259982316, 0.262373783}, // 17139K
			{0.259980835, 0.26237181}, // 17140K
			{0.259979354, 0.262369838}, // 17141K
			{0.259977873, 0.262367866}, // 17142K
			{0.259976393, 0.262365895}, // 17143K
			{0.259974913, 0.262363923}, // 17144K
			{0.259973433, 0.262361952}, // 17145K
			{0.259971953, 0.262359982}, // 17146K
			{0.259970474, 0.262358011}, // 17147K
			{0.259968994, 0.262356041}, // 17148K
			{0.259967515, 0.262354071}, // 17149K
			{0.259966036, 0.262352101}, // 17150K
			{0.259964557, 0.262350132}, // 17151K
			{0.259963079, 0.262348162}, // 17152K
			{0.2599616, 0.262346193}, // 17153K
			{0.259960122, 0.262344225}, // 17154K
			{0.259958644, 0.262342256}, // 17155K
			{0.259957167, 0.262340288}, // 17156K
			{0.259955689, 0.26233832}, // 17157K
			{0.259954212, 0.262336353}, // 17158K
			{0.259952735, 0.262334385}, // 17159K
			{0.259951258, 0.262332418}, // 17160K
			{0.259949781, 0.262330451}, // 17161K
			{0.259948305, 0.262328485}, // 17162K
			{0.259946829, 0.262326518}, // 17163K
			{0.259945352, 0.262324552}, // 17164K
			{0.259943877, 0.262322586}, // 17165K
			{0.259942401, 0.262320621}, // 17166K
			{0.259940926, 0.262318655}, // 17167K
			{0.25993945, 0.26231669}, // 17168K
			{0.259937975, 0.262314726}, // 17169K
			{0.259936501, 0.262312761}, // 17170K
			{0.259935026, 0.262310797}, // 17171K
			{0.259933552, 0.262308833}, // 17172K
			{0.259932077, 0.262306869}, // 17173K
			{0.259930603, 0.262304905}, // 17174K
			{0.25992913, 0.262302942}, // 17175K
			{0.259927656, 0.262300979}, // 17176K
			{0.259926183, 0.262299016}, // 17177K
			{0.25992471, 0.262297054}, // 17178K
			{0.259923237, 0.262295092}, // 17179K
			{0.259921764, 0.26229313}, // 17180K
			{0.259920291, 0.262291168}, // 17181K
			{0.259918819, 0.262289207}, // 17182K
			{0.259917347, 0.262287245}, // 17183K
			{0.259915875, 0.262285285}, // 17184K
			{0.259914403, 0.262283324}, // 17185K
			{0.259912932, 0.262281363}, // 17186K
			{0.259911461, 0.262279403}, // 17187K
			{0.259909989, 0.262277443}, // 17188K
			{0.259908519, 0.262275484}, // 17189K
			{0.259907048, 0.262273524}, // 17190K
			{0.259905577, 0.262271565}, // 17191K
			{0.259904107, 0.262269606}, // 17192K
			{0.259902637, 0.262267648}, // 17193K
			{0.259901167, 0.262265689}, // 17194K
			{0.259899698, 0.262263731}, // 17195K
			{0.259898228, 0.262261774}, // 17196K
			{0.259896759, 0.262259816}, // 17197K
			{0.25989529, 0.262257859}, // 17198K
			{0.259893821, 0.262255902}, // 17199K
			{0.259892353, 0.262253945}, // 17200K
			{0.259890884, 0.262251988}, // 17201K
			{0.259889416, 0.262250032}, // 17202K
			{0.259887948, 0.262248076}, // 17203K
			{0.25988648, 0.26224612}, // 17204K
			{0.259885013, 0.262244165}, // 17205K
			{0.259883545, 0.262242209}, // 17206K
			{0.259882078, 0.262240254}, // 17207K
			{0.259880611, 0.2622383}, // 17208K
			{0.259879144, 0.262236345}, // 17209K
			{0.259877678, 0.262234391}, // 17210K
			{0.259876211, 0.262232437}, // 17211K
			{0.259874745, 0.262230483}, // 17212K
			{0.259873279, 0.26222853}, // 17213K
			{0.259871814, 0.262226577}, // 17214K
			{0.259870348, 0.262224624}, // 17215K
			{0.259868883, 0.262222671}, // 17216K
			{0.259867418, 0.262220719}, // 17217K
			{0.259865953, 0.262218767}, // 17218K
			{0.259864488, 0.262216815}, // 17219K
			{0.259863023, 0.262214863}, // 17220K
			{0.259861559, 0.262212912}, // 17221K
			{0.259860095, 0.26221096}, // 17222K
			{0.259858631, 0.26220901}, // 17223K
			{0.259857168, 0.262207059}, // 17224K
			{0.259855704, 0.262205109}, // 17225K
			{0.259854241, 0.262203158}, // 17226K
			{0.259852778, 0.262201209}, // 17227K
			{0.259851315, 0.262199259}, // 17228K
			{0.259849852, 0.26219731}, // 17229K
			{0.25984839, 0.262195361}, // 17230K
			{0.259846927, 0.262193412}, // 17231K
			{0.259845465, 0.262191463}, // 17232K
			{0.259844004, 0.262189515}, // 17233K
			{0.259842542, 0.262187567}, // 17234K
			{0.25984108, 0.262185619}, // 17235K
			{0.259839619, 0.262183671}, // 17236K
			{0.259838158, 0.262181724}, // 17237K
			{0.259836697, 0.262179777}, // 17238K
			{0.259835237, 0.26217783}, // 17239K
			{0.259833776, 0.262175884}, // 17240K
			{0.259832316, 0.262173937}, // 17241K
			{0.259830856, 0.262171991}, // 17242K
			{0.259829396, 0.262170046}, // 17243K
			{0.259827937, 0.2621681}, // 17244K
			{0.259826477, 0.262166155}, // 17245K
			{0.259825018, 0.26216421}, // 17246K
			{0.259823559, 0.262162265}, // 17247K
			{0.2598221, 0.262160321}, // 17248K
			{0.259820642, 0.262158376}, // 17249K
			{0.259819183, 0.262156432}, // 17250K
			{0.259817725, 0.262154489}, // 17251K
			{0.259816267, 0.262152545}, // 17252K
			{0.25981481, 0.262150602}, // 17253K
			{0.259813352, 0.262148659}, // 17254K
			{0.259811895, 0.262146716}, // 17255K
			{0.259810438, 0.262144774}, // 17256K
			{0.259808981, 0.262142832}, // 17257K
			{0.259807524, 0.26214089}, // 17258K
			{0.259806067, 0.262138948}, // 17259K
			{0.259804611, 0.262137007}, // 17260K
			{0.259803155, 0.262135066}, // 17261K
			{0.259801699, 0.262133125}, // 17262K
			{0.259800243, 0.262131184}, // 17263K
			{0.259798788, 0.262129244}, // 17264K
			{0.259797332, 0.262127303}, // 17265K
			{0.259795877, 0.262125364}, // 17266K
			{0.259794422, 0.262123424}, // 17267K
			{0.259792968, 0.262121485}, // 17268K
			{0.259791513, 0.262119545}, // 17269K
			{0.259790059, 0.262117606}, // 17270K
			{0.259788605, 0.262115668}, // 17271K
			{0.259787151, 0.262113729}, // 17272K
			{0.259785697, 0.262111791}, // 17273K
			{0.259784244, 0.262109854}, // 17274K
			{0.25978279, 0.262107916}, // 17275K
			{0.259781337, 0.262105979}, // 17276K
			{0.259779884, 0.262104041}, // 17277K
			{0.259778432, 0.262102105}, // 17278K
			{0.259776979, 0.262100168}, // 17279K
			{0.259775527, 0.262098232}, // 17280K
			{0.259774075, 0.262096296}, // 17281K
			{0.259772623, 0.26209436}, // 17282K
			{0.259771171, 0.262092424}, // 17283K
			{0.25976972, 0.262090489}, // 17284K
			{0.259768268, 0.262088554}, // 17285K
			{0.259766817, 0.262086619}, // 17286K
			{0.259765367, 0.262084684}, // 17287K
			{0.259763916, 0.26208275}, // 17288K
			{0.259762465, 0.262080816}, // 17289K
			{0.259761015, 0.262078882}, // 17290K
			{0.259759565, 0.262076949}, // 17291K
			{0.259758115, 0.262075015}, // 17292K
			{0.259756666, 0.262073082}, // 17293K
			{0.259755216, 0.262071149}, // 17294K
			{0.259753767, 0.262069217}, // 17295K
			{0.259752318, 0.262067285}, // 17296K
			{0.259750869, 0.262065353}, // 17297K
			{0.25974942, 0.262063421}, // 17298K
			{0.259747972, 0.262061489}, // 17299K
			{0.259746524, 0.262059558}, // 17300K
			{0.259745076, 0.262057627}, // 17301K
			{0.259743628, 0.262055696}, // 17302K
			{0.25974218, 0.262053766}, // 17303K
			{0.259740733, 0.262051835}, // 17304K
			{0.259739286, 0.262049905}, // 17305K
			{0.259737838, 0.262047976}, // 17306K
			{0.259736392, 0.262046046}, // 17307K
			{0.259734945, 0.262044117}, // 17308K
			{0.259733499, 0.262042188}, // 17309K
			{0.259732052, 0.262040259}, // 17310K
			{0.259730606, 0.262038331}, // 17311K
			{0.259729161, 0.262036402}, // 17312K
			{0.259727715, 0.262034474}, // 17313K
			{0.25972627, 0.262032547}, // 17314K
			{0.259724824, 0.262030619}, // 17315K
			{0.259723379, 0.262028692}, // 17316K
			{0.259721934, 0.262026765}, // 17317K
			{0.25972049, 0.262024838}, // 17318K
			{0.259719045, 0.262022912}, // 17319K
			{0.259717601, 0.262020985}, // 17320K
			{0.259716157, 0.26201906}, // 17321K
			{0.259714713, 0.262017134}, // 17322K
			{0.25971327, 0.262015208}, // 17323K
			{0.259711826, 0.262013283}, // 17324K
			{0.259710383, 0.262011358}, // 17325K
			{0.25970894, 0.262009433}, // 17326K
			{0.259707497, 0.262007509}, // 17327K
			{0.259706055, 0.262005585}, // 17328K
			{0.259704612, 0.262003661}, // 17329K
			{0.25970317, 0.262001737}, // 17330K
			{0.259701728, 0.261999814}, // 17331K
			{0.259700286, 0.26199789}, // 17332K
			{0.259698845, 0.261995967}, // 17333K
			{0.259697403, 0.261994045}, // 17334K
			{0.259695962, 0.261992122}, // 17335K
			{0.259694521, 0.2619902}, // 17336K
			{0.25969308, 0.261988278}, // 17337K
			{0.25969164, 0.261986356}, // 17338K
			{0.259690199, 0.261984435}, // 17339K
			{0.259688759, 0.261982514}, // 17340K
			{0.259687319, 0.261980593}, // 17341K
			{0.259685879, 0.261978672}, // 17342K
			{0.25968444, 0.261976752}, // 17343K
			{0.259683, 0.261974831}, // 17344K
			{0.259681561, 0.261972911}, // 17345K
			{0.259680122, 0.261970992}, // 17346K
			{0.259678683, 0.261969072}, // 17347K
			{0.259677245, 0.261967153}, // 17348K
			{0.259675806, 0.261965234}, // 17349K
			{0.259674368, 0.261963315}, // 17350K
			{0.25967293, 0.261961397}, // 17351K
			{0.259671492, 0.261959479}, // 17352K
			{0.259670055, 0.261957561}, // 17353K
			{0.259668617, 0.261955643}, // 17354K
			{0.25966718, 0.261953726}, // 17355K
			{0.259665743, 0.261951809}, // 17356K
			{0.259664306, 0.261949892}, // 17357K
			{0.25966287, 0.261947975}, // 17358K
			{0.259661433, 0.261946058}, // 17359K
			{0.259659997, 0.261944142}, // 17360K
			{0.259658561, 0.261942226}, // 17361K
			{0.259657125, 0.261940311}, // 17362K
			{0.25965569, 0.261938395}, // 17363K
			{0.259654254, 0.26193648}, // 17364K
			{0.259652819, 0.261934565}, // 17365K
			{0.259651384, 0.26193265}, // 17366K
			{0.259649949, 0.261930736}, // 17367K
			{0.259648514, 0.261928822}, // 17368K
			{0.25964708, 0.261926908}, // 17369K
			{0.259645646, 0.261924994}, // 17370K
			{0.259644212, 0.261923081}, // 17371K
			{0.259642778, 0.261921167}, // 17372K
			{0.259641344, 0.261919254}, // 17373K
			{0.259639911, 0.261917342}, // 17374K
			{0.259638478, 0.261915429}, // 17375K
			{0.259637045, 0.261913517}, // 17376K
			{0.259635612, 0.261911605}, // 17377K
			{0.259634179, 0.261909693}, // 17378K
			{0.259632747, 0.261907782}, // 17379K
			{0.259631315, 0.261905871}, // 17380K
			{0.259629883, 0.26190396}, // 17381K
			{0.259628451, 0.261902049}, // 17382K
			{0.259627019, 0.261900139}, // 17383K
			{0.259625588, 0.261898228}, // 17384K
			{0.259624156, 0.261896318}, // 17385K
			{0.259622725, 0.261894409}, // 17386K
			{0.259621294, 0.261892499}, // 17387K
			{0.259619864, 0.26189059}, // 17388K
			{0.259618433, 0.261888681}, // 17389K
			{0.259617003, 0.261886772}, // 17390K
			{0.259615573, 0.261884864}, // 17391K
			{0.259614143, 0.261882956}, // 17392K
			{0.259612714, 0.261881048}, // 17393K
			{0.259611284, 0.26187914}, // 17394K
			{0.259609855, 0.261877233}, // 17395K
			{0.259608426, 0.261875325}, // 17396K
			{0.259606997, 0.261873418}, // 17397K
			{0.259605568, 0.261871512}, // 17398K
			{0.25960414, 0.261869605}, // 17399K
			{0.259602711, 0.261867699}, // 17400K
			{0.259601283, 0.261865793}, // 17401K
			{0.259599856, 0.261863887}, // 17402K
			{0.259598428, 0.261861982}, // 17403K
			{0.259597, 0.261860076}, // 17404K
			{0.259595573, 0.261858171}, // 17405K
			{0.259594146, 0.261856267}, // 17406K
			{0.259592719, 0.261854362}, // 17407K
			{0.259591292, 0.261852458}, // 17408K
			{0.259589866, 0.261850554}, // 17409K
			{0.25958844, 0.26184865}, // 17410K
			{0.259587014, 0.261846747}, // 17411K
			{0.259585588, 0.261844843}, // 17412K
			{0.259584162, 0.26184294}, // 17413K
			{0.259582736, 0.261841038}, // 17414K
			{0.259581311, 0.261839135}, // 17415K
			{0.259579886, 0.261837233}, // 17416K
			{0.259578461, 0.261835331}, // 17417K
			{0.259577036, 0.261833429}, // 17418K
			{0.259575612, 0.261831527}, // 17419K
			{0.259574188, 0.261829626}, // 17420K
			{0.259572763, 0.261827725}, // 17421K
			{0.259571339, 0.261825824}, // 17422K
			{0.259569916, 0.261823924}, // 17423K
			{0.259568492, 0.261822024}, // 17424K
			{0.259567069, 0.261820124}, // 17425K
			{0.259565646, 0.261818224}, // 17426K
			{0.259564223, 0.261816324}, // 17427K
			{0.2595628, 0.261814425}, // 17428K
			{0.259561377, 0.261812526}, // 17429K
			{0.259559955, 0.261810627}, // 17430K
			{0.259558533, 0.261808728}, // 17431K
			{0.259557111, 0.26180683}, // 17432K
			{0.259555689, 0.261804932}, // 17433K
			{0.259554268, 0.261803034}, // 17434K
			{0.259552846, 0.261801137}, // 17435K
			{0.259551425, 0.261799239}, // 17436K
			{0.259550004, 0.261797342}, // 17437K
			{0.259548583, 0.261795445}, // 17438K
			{0.259547163, 0.261793549}, // 17439K
			{0.259545742, 0.261791652}, // 17440K
			{0.259544322, 0.261789756}, // 17441K
			{0.259542902, 0.26178786}, // 17442K
			{0.259541482, 0.261785965}, // 17443K
			{0.259540063, 0.261784069}, // 17444K
			{0.259538643, 0.261782174}, // 17445K
			{0.259537224, 0.261780279}, // 17446K
			{0.259535805, 0.261778385}, // 17447K
			{0.259534386, 0.26177649}, // 17448K
			{0.259532968, 0.261774596}, // 17449K
			{0.259531549, 0.261772702}, // 17450K
			{0.259530131, 0.261770809}, // 17451K
			{0.259528713, 0.261768915}, // 17452K
			{0.259527295, 0.261767022}, // 17453K
			{0.259525877, 0.261765129}, // 17454K
			{0.25952446, 0.261763237}, // 17455K
			{0.259523043, 0.261761344}, // 17456K
			{0.259521625, 0.261759452}, // 17457K
			{0.259520209, 0.26175756}, // 17458K
			{0.259518792, 0.261755669}, // 17459K
			{0.259517375, 0.261753777}, // 17460K
			{0.259515959, 0.261751886}, // 17461K
			{0.259514543, 0.261749995}, // 17462K
			{0.259513127, 0.261748104}, // 17463K
			{0.259511711, 0.261746214}, // 17464K
			{0.259510296, 0.261744324}, // 17465K
			{0.259508881, 0.261742434}, // 17466K
			{0.259507466, 0.261740544}, // 17467K
			{0.259506051, 0.261738654}, // 17468K
			{0.259504636, 0.261736765}, // 17469K
			{0.259503221, 0.261734876}, // 17470K
			{0.259501807, 0.261732988}, // 17471K
			{0.259500393, 0.261731099}, // 17472K
			{0.259498979, 0.261729211}, // 17473K
			{0.259497565, 0.261727323}, // 17474K
			{0.259496152, 0.261725435}, // 17475K
			{0.259494738, 0.261723547}, // 17476K
			{0.259493325, 0.26172166}, // 17477K
			{0.259491912, 0.261719773}, // 17478K
			{0.259490499, 0.261717886}, // 17479K
			{0.259489087, 0.261716}, // 17480K
			{0.259487674, 0.261714114}, // 17481K
			{0.259486262, 0.261712228}, // 17482K
			{0.25948485, 0.261710342}, // 17483K
			{0.259483438, 0.261708456}, // 17484K
			{0.259482027, 0.261706571}, // 17485K
			{0.259480615, 0.261704686}, // 17486K
			{0.259479204, 0.261702801}, // 17487K
			{0.259477793, 0.261700916}, // 17488K
			{0.259476382, 0.261699032}, // 17489K
			{0.259474972, 0.261697148}, // 17490K
			{0.259473561, 0.261695264}, // 17491K
			{0.259472151, 0.261693381}, // 17492K
			{0.259470741, 0.261691497}, // 17493K
			{0.259469331, 0.261689614}, // 17494K
			{0.259467921, 0.261687731}, // 17495K
			{0.259466512, 0.261685849}, // 17496K
			{0.259465103, 0.261683966}, // 17497K
			{0.259463693, 0.261682084}, // 17498K
			{0.259462285, 0.261680202}, // 17499K
			{0.259460876, 0.26167832}, // 17500K
			{0.259459467, 0.261676439}, // 17501K
			{0.259458059, 0.261674558}, // 17502K
			{0.259456651, 0.261672677}, // 17503K
			{0.259455243, 0.261670796}, // 17504K
			{0.259453835, 0.261668916}, // 17505K
			{0.259452428, 0.261667036}, // 17506K
			{0.25945102, 0.261665156}, // 17507K
			{0.259449613, 0.261663276}, // 17508K
			{0.259448206, 0.261661396}, // 17509K
			{0.259446799, 0.261659517}, // 17510K
			{0.259445393, 0.261657638}, // 17511K
			{0.259443987, 0.26165576}, // 17512K
			{0.25944258, 0.261653881}, // 17513K
			{0.259441174, 0.261652003}, // 17514K
			{0.259439769, 0.261650125}, // 17515K
			{0.259438363, 0.261648247}, // 17516K
			{0.259436958, 0.261646369}, // 17517K
			{0.259435552, 0.261644492}, // 17518K
			{0.259434147, 0.261642615}, // 17519K
			{0.259432742, 0.261640738}, // 17520K
			{0.259431338, 0.261638862}, // 17521K
			{0.259429933, 0.261636986}, // 17522K
			{0.259428529, 0.261635109}, // 17523K
			{0.259427125, 0.261633234}, // 17524K
			{0.259425721, 0.261631358}, // 17525K
			{0.259424317, 0.261629483}, // 17526K
			{0.259422914, 0.261627608}, // 17527K
			{0.259421511, 0.261625733}, // 17528K
			{0.259420108, 0.261623858}, // 17529K
			{0.259418705, 0.261621984}, // 17530K
			{0.259417302, 0.26162011}, // 17531K
			{0.259415899, 0.261618236}, // 17532K
			{0.259414497, 0.261616362}, // 17533K
			{0.259413095, 0.261614489}, // 17534K
			{0.259411693, 0.261612616}, // 17535K
			{0.259410291, 0.261610743}, // 17536K
			{0.25940889, 0.26160887}, // 17537K
			{0.259407488, 0.261606998}, // 17538K
			{0.259406087, 0.261605125}, // 17539K
			{0.259404686, 0.261603253}, // 17540K
			{0.259403285, 0.261601382}, // 17541K
			{0.259401885, 0.26159951}, // 17542K
			{0.259400484, 0.261597639}, // 17543K
			{0.259399084, 0.261595768}, // 17544K
			{0.259397684, 0.261593897}, // 17545K
			{0.259396284, 0.261592027}, // 17546K
			{0.259394885, 0.261590156}, // 17547K
			{0.259393485, 0.261588286}, // 17548K
			{0.259392086, 0.261586417}, // 17549K
			{0.259390687, 0.261584547}, // 17550K
			{0.259389288, 0.261582678}, // 17551K
			{0.259387889, 0.261580809}, // 17552K
			{0.259386491, 0.26157894}, // 17553K
			{0.259385093, 0.261577071}, // 17554K
			{0.259383695, 0.261575203}, // 17555K
			{0.259382297, 0.261573335}, // 17556K
			{0.259380899, 0.261571467}, // 17557K
			{0.259379501, 0.261569599}, // 17558K
			{0.259378104, 0.261567732}, // 17559K
			{0.259376707, 0.261565865}, // 17560K
			{0.25937531, 0.261563998}, // 17561K
			{0.259373913, 0.261562131}, // 17562K
			{0.259372517, 0.261560265}, // 17563K
			{0.25937112, 0.261558399}, // 17564K
			{0.259369724, 0.261556533}, // 17565K
			{0.259368328, 0.261554667}, // 17566K
			{0.259366932, 0.261552802}, // 17567K
			{0.259365537, 0.261550937}, // 17568K
			{0.259364141, 0.261549072}, // 17569K
			{0.259362746, 0.261547207}, // 17570K
			{0.259361351, 0.261545342}, // 17571K
			{0.259359956, 0.261543478}, // 17572K
			{0.259358561, 0.261541614}, // 17573K
			{0.259357167, 0.26153975}, // 17574K
			{0.259355773, 0.261537887}, // 17575K
			{0.259354379, 0.261536024}, // 17576K
			{0.259352985, 0.261534161}, // 17577K
			{0.259351591, 0.261532298}, // 17578K
			{0.259350197, 0.261530435}, // 17579K
			{0.259348804, 0.261528573}, // 17580K
			{0.259347411, 0.261526711}, // 17581K
			{0.259346018, 0.261524849}, // 17582K
			{0.259344625, 0.261522987}, // 17583K
			{0.259343233, 0.261521126}, // 17584K
			{0.25934184, 0.261519265}, // 17585K
			{0.259340448, 0.261517404}, // 17586K
			{0.259339056, 0.261515543}, // 17587K
			{0.259337664, 0.261513683}, // 17588K
			{0.259336273, 0.261511823}, // 17589K
			{0.259334881, 0.261509963}, // 17590K
			{0.25933349, 0.261508103}, // 17591K
			{0.259332099, 0.261506244}, // 17592K
			{0.259330708, 0.261504385}, // 17593K
			{0.259329318, 0.261502526}, // 17594K
			{0.259327927, 0.261500667}, // 17595K
			{0.259326537, 0.261498808}, // 17596K
			{0.259325147, 0.26149695}, // 17597K
			{0.259323757, 0.261495092}, // 17598K
			{0.259322367, 0.261493234}, // 17599K
			{0.259320978, 0.261491377}, // 17600K
			{0.259319588, 0.26148952}, // 17601K
			{0.259318199, 0.261487663}, // 17602K
			{0.25931681, 0.261485806}, // 17603K
			{0.259315421, 0.261483949}, // 17604K
			{0.259314033, 0.261482093}, // 17605K
			{0.259312644, 0.261480237}, // 17606K
			{0.259311256, 0.261478381}, // 17607K
			{0.259309868, 0.261476525}, // 17608K
			{0.25930848, 0.26147467}, // 17609K
			{0.259307093, 0.261472815}, // 17610K
			{0.259305705, 0.26147096}, // 17611K
			{0.259304318, 0.261469105}, // 17612K
			{0.259302931, 0.261467251}, // 17613K
			{0.259301544, 0.261465396}, // 17614K
			{0.259300158, 0.261463543}, // 17615K
			{0.259298771, 0.261461689}, // 17616K
			{0.259297385, 0.261459835}, // 17617K
			{0.259295999, 0.261457982}, // 17618K
			{0.259294613, 0.261456129}, // 17619K
			{0.259293227, 0.261454276}, // 17620K
			{0.259291842, 0.261452424}, // 17621K
			{0.259290456, 0.261450572}, // 17622K
			{0.259289071, 0.26144872}, // 17623K
			{0.259287686, 0.261446868}, // 17624K
			{0.259286301, 0.261445016}, // 17625K
			{0.259284917, 0.261443165}, // 17626K
			{0.259283532, 0.261441314}, // 17627K
			{0.259282148, 0.261439463}, // 17628K
			{0.259280764, 0.261437612}, // 17629K
			{0.25927938, 0.261435762}, // 17630K
			{0.259277997, 0.261433912}, // 17631K
			{0.259276613, 0.261432062}, // 17632K
			{0.25927523, 0.261430212}, // 17633K
			{0.259273847, 0.261428363}, // 17634K
			{0.259272464, 0.261426514}, // 17635K
			{0.259271081, 0.261424665}, // 17636K
			{0.259269699, 0.261422816}, // 17637K
			{0.259268316, 0.261420967}, // 17638K
			{0.259266934, 0.261419119}, // 17639K
			{0.259265552, 0.261417271}, // 17640K
			{0.25926417, 0.261415423}, // 17641K
			{0.259262789, 0.261413576}, // 17642K
			{0.259261408, 0.261411729}, // 17643K
			{0.259260026, 0.261409881}, // 17644K
			{0.259258645, 0.261408035}, // 17645K
			{0.259257264, 0.261406188}, // 17646K
			{0.259255884, 0.261404342}, // 17647K
			{0.259254503, 0.261402496}, // 17648K
			{0.259253123, 0.26140065}, // 17649K
			{0.259251743, 0.261398804}, // 17650K
			{0.259250363, 0.261396959}, // 17651K
			{0.259248984, 0.261395114}, // 17652K
			{0.259247604, 0.261393269}, // 17653K
			{0.259246225, 0.261391424}, // 17654K
			{0.259244846, 0.261389579}, // 17655K
			{0.259243467, 0.261387735}, // 17656K
			{0.259242088, 0.261385891}, // 17657K
			{0.259240709, 0.261384048}, // 17658K
			{0.259239331, 0.261382204}, // 17659K
			{0.259237953, 0.261380361}, // 17660K
			{0.259236575, 0.261378518}, // 17661K
			{0.259235197, 0.261376675}, // 17662K
			{0.259233819, 0.261374832}, // 17663K
			{0.259232442, 0.26137299}, // 17664K
			{0.259231065, 0.261371148}, // 17665K
			{0.259229688, 0.261369306}, // 17666K
			{0.259228311, 0.261367465}, // 17667K
			{0.259226934, 0.261365623}, // 17668K
			{0.259225557, 0.261363782}, // 17669K
			{0.259224181, 0.261361941}, // 17670K
			{0.259222805, 0.2613601}, // 17671K
			{0.259221429, 0.26135826}, // 17672K
			{0.259220053, 0.26135642}, // 17673K
			{0.259218678, 0.26135458}, // 17674K
			{0.259217302, 0.26135274}, // 17675K
			{0.259215927, 0.261350901}, // 17676K
			{0.259214552, 0.261349061}, // 17677K
			{0.259213177, 0.261347222}, // 17678K
			{0.259211803, 0.261345384}, // 17679K
			{0.259210428, 0.261343545}, // 17680K
			{0.259209054, 0.261341707}, // 17681K
			{0.25920768, 0.261339869}, // 17682K
			{0.259206306, 0.261338031}, // 17683K
			{0.259204932, 0.261336193}, // 17684K
			{0.259203559, 0.261334356}, // 17685K
			{0.259202186, 0.261332519}, // 17686K
			{0.259200812, 0.261330682}, // 17687K
			{0.25919944, 0.261328845}, // 17688K
			{0.259198067, 0.261327009}, // 17689K
			{0.259196694, 0.261325172}, // 17690K
			{0.259195322, 0.261323336}, // 17691K
			{0.25919395, 0.261321501}, // 17692K
			{0.259192578, 0.261319665}, // 17693K
			{0.259191206, 0.26131783}, // 17694K
			{0.259189834, 0.261315995}, // 17695K
			{0.259188463, 0.26131416}, // 17696K
			{0.259187091, 0.261312326}, // 17697K
			{0.25918572, 0.261310491}, // 17698K
			{0.259184349, 0.261308657}, // 17699K
			{0.259182979, 0.261306823}, // 17700K
			{0.259181608, 0.26130499}, // 17701K
			{0.259180238, 0.261303156}, // 17702K
			{0.259178868, 0.261301323}, // 17703K
			{0.259177498, 0.26129949}, // 17704K
			{0.259176128, 0.261297658}, // 17705K
			{0.259174758, 0.261295825}, // 17706K
			{0.259173389, 0.261293993}, // 17707K
			{0.25917202, 0.261292161}, // 17708K
			{0.259170651, 0.261290329}, // 17709K
			{0.259169282, 0.261288498}, // 17710K
			{0.259167913, 0.261286667}, // 17711K
			{0.259166545, 0.261284835}, // 17712K
			{0.259165176, 0.261283005}, // 17713K
			{0.259163808, 0.261281174}, // 17714K
			{0.25916244, 0.261279344}, // 17715K
			{0.259161073, 0.261277514}, // 17716K
			{0.259159705, 0.261275684}, // 17717K
			{0.259158338, 0.261273854}, // 17718K
			{0.259156971, 0.261272025}, // 17719K
			{0.259155604, 0.261270196}, // 17720K
			{0.259154237, 0.261268367}, // 17721K
			{0.25915287, 0.261266538}, // 17722K
			{0.259151504, 0.26126471}, // 17723K
			{0.259150137, 0.261262881}, // 17724K
			{0.259148771, 0.261261053}, // 17725K
			{0.259147406, 0.261259226}, // 17726K
			{0.25914604, 0.261257398}, // 17727K
			{0.259144674, 0.261255571}, // 17728K
			{0.259143309, 0.261253744}, // 17729K
			{0.259141944, 0.261251917}, // 17730K
			{0.259140579, 0.26125009}, // 17731K
			{0.259139214, 0.261248264}, // 17732K
			{0.25913785, 0.261246438}, // 17733K
			{0.259136485, 0.261244612}, // 17734K
			{0.259135121, 0.261242786}, // 17735K
			{0.259133757, 0.261240961}, // 17736K
			{0.259132393, 0.261239136}, // 17737K
			{0.259131029, 0.261237311}, // 17738K
			{0.259129666, 0.261235486}, // 17739K
			{0.259128303, 0.261233661}, // 17740K
			{0.25912694, 0.261231837}, // 17741K
			{0.259125577, 0.261230013}, // 17742K
			{0.259124214, 0.261228189}, // 17743K
			{0.259122851, 0.261226366}, // 17744K
			{0.259121489, 0.261224542}, // 17745K
			{0.259120127, 0.261222719}, // 17746K
			{0.259118765, 0.261220896}, // 17747K
			{0.259117403, 0.261219074}, // 17748K
			{0.259116041, 0.261217251}, // 17749K
			{0.25911468, 0.261215429}, // 17750K
			{0.259113319, 0.261213607}, // 17751K
			{0.259111958, 0.261211786}, // 17752K
			{0.259110597, 0.261209964}, // 17753K
			{0.259109236, 0.261208143}, // 17754K
			{0.259107875, 0.261206322}, // 17755K
			{0.259106515, 0.261204501}, // 17756K
			{0.259105155, 0.261202681}, // 17757K
			{0.259103795, 0.26120086}, // 17758K
			{0.259102435, 0.26119904}, // 17759K
			{0.259101076, 0.26119722}, // 17760K
			{0.259099716, 0.261195401}, // 17761K
			{0.259098357, 0.261193581}, // 17762K
			{0.259096998, 0.261191762}, // 17763K
			{0.259095639, 0.261189943}, // 17764K
			{0.25909428, 0.261188125}, // 17765K
			{0.259092922, 0.261186306}, // 17766K
			{0.259091564, 0.261184488}, // 17767K
			{0.259090205, 0.26118267}, // 17768K
			{0.259088847, 0.261180852}, // 17769K
			{0.25908749, 0.261179035}, // 17770K
			{0.259086132, 0.261177217}, // 17771K
			{0.259084775, 0.2611754}, // 17772K
			{0.259083417, 0.261173583}, // 17773K
			{0.25908206, 0.261171767}, // 17774K
			{0.259080704, 0.26116995}, // 17775K
			{0.259079347, 0.261168134}, // 17776K
			{0.25907799, 0.261166318}, // 17777K
			{0.259076634, 0.261164503}, // 17778K
			{0.259075278, 0.261162687}, // 17779K
			{0.259073922, 0.261160872}, // 17780K
			{0.259072566, 0.261159057}, // 17781K
			{0.259071211, 0.261157242}, // 17782K
			{0.259069855, 0.261155428}, // 17783K
			{0.2590685, 0.261153613}, // 17784K
			{0.259067145, 0.261151799}, // 17785K
			{0.25906579, 0.261149986}, // 17786K
			{0.259064436, 0.261148172}, // 17787K
			{0.259063081, 0.261146359}, // 17788K
			{0.259061727, 0.261144545}, // 17789K
			{0.259060373, 0.261142733}, // 17790K
			{0.259059019, 0.26114092}, // 17791K
			{0.259057665, 0.261139107}, // 17792K
			{0.259056312, 0.261137295}, // 17793K
			{0.259054958, 0.261135483}, // 17794K
			{0.259053605, 0.261133672}, // 17795K
			{0.259052252, 0.26113186}, // 17796K
			{0.259050899, 0.261130049}, // 17797K
			{0.259049547, 0.261128238}, // 17798K
			{0.259048194, 0.261126427}, // 17799K
			{0.259046842, 0.261124616}, // 17800K
			{0.25904549, 0.261122806}, // 17801K
			{0.259044138, 0.261120996}, // 17802K
			{0.259042786, 0.261119186}, // 17803K
			{0.259041435, 0.261117376}, // 17804K
			{0.259040083, 0.261115567}, // 17805K
			{0.259038732, 0.261113757}, // 17806K
			{0.259037381, 0.261111948}, // 17807K
			{0.25903603, 0.26111014}, // 17808K
			{0.25903468, 0.261108331}, // 17809K
			{0.259033329, 0.261106523}, // 17810K
			{0.259031979, 0.261104715}, // 17811K
			{0.259030629, 0.261102907}, // 17812K
			{0.259029279, 0.261101099}, // 17813K
			{0.259027929, 0.261099292}, // 17814K
			{0.25902658, 0.261097485}, // 17815K
			{0.259025231, 0.261095678}, // 17816K
			{0.259023881, 0.261093871}, // 17817K
			{0.259022532, 0.261092065}, // 17818K
			{0.259021184, 0.261090259}, // 17819K
			{0.259019835, 0.261088453}, // 17820K
			{0.259018487, 0.261086647}, // 17821K
			{0.259017138, 0.261084841}, // 17822K
			{0.25901579, 0.261083036}, // 17823K
			{0.259014442, 0.261081231}, // 17824K
			{0.259013095, 0.261079426}, // 17825K
			{0.259011747, 0.261077621}, // 17826K
			{0.2590104, 0.261075817}, // 17827K
			{0.259009053, 0.261074013}, // 17828K
			{0.259007706, 0.261072209}, // 17829K
			{0.259006359, 0.261070405}, // 17830K
			{0.259005012, 0.261068602}, // 17831K
			{0.259003666, 0.261066798}, // 17832K
			{0.259002319, 0.261064995}, // 17833K
			{0.259000973, 0.261063193}, // 17834K
			{0.258999627, 0.26106139}, // 17835K
			{0.258998282, 0.261059588}, // 17836K
			{0.258996936, 0.261057786}, // 17837K
			{0.258995591, 0.261055984}, // 17838K
			{0.258994246, 0.261054182}, // 17839K
			{0.258992901, 0.261052381}, // 17840K
			{0.258991556, 0.26105058}, // 17841K
			{0.258990211, 0.261048779}, // 17842K
			{0.258988867, 0.261046978}, // 17843K
			{0.258987522, 0.261045177}, // 17844K
			{0.258986178, 0.261043377}, // 17845K
			{0.258984834, 0.261041577}, // 17846K
			{0.258983491, 0.261039777}, // 17847K
			{0.258982147, 0.261037978}, // 17848K
			{0.258980804, 0.261036178}, // 17849K
			{0.258979461, 0.261034379}, // 17850K
			{0.258978118, 0.26103258}, // 17851K
			{0.258976775, 0.261030782}, // 17852K
			{0.258975432, 0.261028983}, // 17853K
			{0.25897409, 0.261027185}, // 17854K
			{0.258972747, 0.261025387}, // 17855K
			{0.258971405, 0.261023589}, // 17856K
			{0.258970063, 0.261021792}, // 17857K
			{0.258968722, 0.261019994}, // 17858K
			{0.25896738, 0.261018197}, // 17859K
			{0.258966039, 0.2610164}, // 17860K
			{0.258964698, 0.261014604}, // 17861K
			{0.258963357, 0.261012807}, // 17862K
			{0.258962016, 0.261011011}, // 17863K
			{0.258960675, 0.261009215}, // 17864K
			{0.258959335, 0.26100742}, // 17865K
			{0.258957994, 0.261005624}, // 17866K
			{0.258956654, 0.261003829}, // 17867K
			{0.258955314, 0.261002034}, // 17868K
			{0.258953975, 0.261000239}, // 17869K
			{0.258952635, 0.260998444}, // 17870K
			{0.258951296, 0.26099665}, // 17871K
			{0.258949956, 0.260994856}, // 17872K
			{0.258948617, 0.260993062}, // 17873K
			{0.258947278, 0.260991268}, // 17874K
			{0.25894594, 0.260989475}, // 17875K
			{0.258944601, 0.260987682}, // 17876K
			{0.258943263, 0.260985889}, // 17877K
			{0.258941925, 0.260984096}, // 17878K
			{0.258940587, 0.260982303}, // 17879K
			{0.258939249, 0.260980511}, // 17880K
			{0.258937912, 0.260978719}, // 17881K
			{0.258936574, 0.260976927}, // 17882K
			{0.258935237, 0.260975136}, // 17883K
			{0.2589339, 0.260973344}, // 17884K
			{0.258932563, 0.260971553}, // 17885K
			{0.258931226, 0.260969762}, // 17886K
			{0.25892989, 0.260967971}, // 17887K
			{0.258928553, 0.260966181}, // 17888K
			{0.258927217, 0.260964391}, // 17889K
			{0.258925881, 0.260962601}, // 17890K
			{0.258924545, 0.260960811}, // 17891K
			{0.25892321, 0.260959021}, // 17892K
			{0.258921874, 0.260957232}, // 17893K
			{0.258920539, 0.260955443}, // 17894K
			{0.258919204, 0.260953654}, // 17895K
			{0.258917869, 0.260951865}, // 17896K
			{0.258916534, 0.260950077}, // 17897K
			{0.2589152, 0.260948289}, // 17898K
			{0.258913866, 0.260946501}, // 17899K
			{0.258912531, 0.260944713}, // 17900K
			{0.258911197, 0.260942925}, // 17901K
			{0.258909864, 0.260941138}, // 17902K
			{0.25890853, 0.260939351}, // 17903K
			{0.258907196, 0.260937564}, // 17904K
			{0.258905863, 0.260935777}, // 17905K
			{0.25890453, 0.260933991}, // 17906K
			{0.258903197, 0.260932205}, // 17907K
			{0.258901864, 0.260930419}, // 17908K
			{0.258900532, 0.260928633}, // 17909K
			{0.258899199, 0.260926848}, // 17910K
			{0.258897867, 0.260925062}, // 17911K
			{0.258896535, 0.260923277}, // 17912K
			{0.258895203, 0.260921492}, // 17913K
			{0.258893872, 0.260919708}, // 17914K
			{0.25889254, 0.260917923}, // 17915K
			{0.258891209, 0.260916139}, // 17916K
			{0.258889878, 0.260914355}, // 17917K
			{0.258888547, 0.260912572}, // 17918K
			{0.258887216, 0.260910788}, // 17919K
			{0.258885885, 0.260909005}, // 17920K
			{0.258884555, 0.260907222}, // 17921K
			{0.258883225, 0.260905439}, // 17922K
			{0.258881894, 0.260903656}, // 17923K
			{0.258880565, 0.260901874}, // 17924K
			{0.258879235, 0.260900092}, // 17925K
			{0.258877905, 0.26089831}, // 17926K
			{0.258876576, 0.260896528}, // 17927K
			{0.258875247, 0.260894747}, // 17928K
			{0.258873918, 0.260892966}, // 17929K
			{0.258872589, 0.260891185}, // 17930K
			{0.25887126, 0.260889404}, // 17931K
			{0.258869932, 0.260887623}, // 17932K
			{0.258868604, 0.260885843}, // 17933K
			{0.258867275, 0.260884063}, // 17934K
			{0.258865947, 0.260882283}, // 17935K
			{0.25886462, 0.260880503}, // 17936K
			{0.258863292, 0.260878724}, // 17937K
			{0.258861965, 0.260876945}, // 17938K
			{0.258860637, 0.260875166}, // 17939K
			{0.25885931, 0.260873387}, // 17940K
			{0.258857984, 0.260871608}, // 17941K
			{0.258856657, 0.26086983}, // 17942K
			{0.25885533, 0.260868052}, // 17943K
			{0.258854004, 0.260866274}, // 17944K
			{0.258852678, 0.260864497}, // 17945K
			{0.258851352, 0.260862719}, // 17946K
			{0.258850026, 0.260860942}, // 17947K
			{0.2588487, 0.260859165}, // 17948K
			{0.258847375, 0.260857388}, // 17949K
			{0.25884605, 0.260855612}, // 17950K
			{0.258844725, 0.260853836}, // 17951K
			{0.2588434, 0.260852059}, // 17952K
			{0.258842075, 0.260850284}, // 17953K
			{0.25884075, 0.260848508}, // 17954K
			{0.258839426, 0.260846733}, // 17955K
			{0.258838102, 0.260844957}, // 17956K
			{0.258836778, 0.260843183}, // 17957K
			{0.258835454, 0.260841408}, // 17958K
			{0.25883413, 0.260839633}, // 17959K
			{0.258832807, 0.260837859}, // 17960K
			{0.258831483, 0.260836085}, // 17961K
			{0.25883016, 0.260834311}, // 17962K
			{0.258828837, 0.260832538}, // 17963K
			{0.258827514, 0.260830764}, // 17964K
			{0.258826192, 0.260828991}, // 17965K
			{0.258824869, 0.260827218}, // 17966K
			{0.258823547, 0.260825445}, // 17967K
			{0.258822225, 0.260823673}, // 17968K
			{0.258820903, 0.260821901}, // 17969K
			{0.258819581, 0.260820129}, // 17970K
			{0.25881826, 0.260818357}, // 17971K
			{0.258816938, 0.260816585}, // 17972K
			{0.258815617, 0.260814814}, // 17973K
			{0.258814296, 0.260813043}, // 17974K
			{0.258812975, 0.260811272}, // 17975K
			{0.258811655, 0.260809501}, // 17976K
			{0.258810334, 0.260807731}, // 17977K
			{0.258809014, 0.26080596}, // 17978K
			{0.258807694, 0.26080419}, // 17979K
			{0.258806374, 0.260802421}, // 17980K
			{0.258805054, 0.260800651}, // 17981K
			{0.258803734, 0.260798882}, // 17982K
			{0.258802415, 0.260797112}, // 17983K
			{0.258801096, 0.260795344}, // 17984K
			{0.258799777, 0.260793575}, // 17985K
			{0.258798458, 0.260791806}, // 17986K
			{0.258797139, 0.260790038}, // 17987K
			{0.25879582, 0.26078827}, // 17988K
			{0.258794502, 0.260786502}, // 17989K
			{0.258793184, 0.260784735}, // 17990K
			{0.258791866, 0.260782967}, // 17991K
			{0.258790548, 0.2607812}, // 17992K
			{0.25878923, 0.260779433}, // 17993K
			{0.258787913, 0.260777667}, // 17994K
			{0.258786595, 0.2607759}, // 17995K
			{0.258785278, 0.260774134}, // 17996K
			{0.258783961, 0.260772368}, // 17997K
			{0.258782644, 0.260770602}, // 17998K
			{0.258781328, 0.260768837}, // 17999K
			{0.258780011, 0.260767071}, // 18000K
			{0.258778695, 0.260765306}, // 18001K
			{0.258777379, 0.260763541}, // 18002K
			{0.258776063, 0.260761777}, // 18003K
			{0.258774747, 0.260760012}, // 18004K
			{0.258773432, 0.260758248}, // 18005K
			{0.258772116, 0.260756484}, // 18006K
			{0.258770801, 0.26075472}, // 18007K
			{0.258769486, 0.260752956}, // 18008K
			{0.258768171, 0.260751193}, // 18009K
			{0.258766857, 0.26074943}, // 18010K
			{0.258765542, 0.260747667}, // 18011K
			{0.258764228, 0.260745904}, // 18012K
			{0.258762914, 0.260744142}, // 18013K
			{0.2587616, 0.26074238}, // 18014K
			{0.258760286, 0.260740618}, // 18015K
			{0.258758972, 0.260738856}, // 18016K
			{0.258757659, 0.260737094}, // 18017K
			{0.258756345, 0.260735333}, // 18018K
			{0.258755032, 0.260733572}, // 18019K
			{0.258753719, 0.260731811}, // 18020K
			{0.258752406, 0.26073005}, // 18021K
			{0.258751094, 0.26072829}, // 18022K
			{0.258749781, 0.260726529}, // 18023K
			{0.258748469, 0.260724769}, // 18024K
			{0.258747157, 0.26072301}, // 18025K
			{0.258745845, 0.26072125}, // 18026K
			{0.258744534, 0.260719491}, // 18027K
			{0.258743222, 0.260717731}, // 18028K
			{0.258741911, 0.260715972}, // 18029K
			{0.258740599, 0.260714214}, // 18030K
			{0.258739288, 0.260712455}, // 18031K
			{0.258737978, 0.260710697}, // 18032K
			{0.258736667, 0.260708939}, // 18033K
			{0.258735356, 0.260707181}, // 18034K
			{0.258734046, 0.260705424}, // 18035K
			{0.258732736, 0.260703666}, // 18036K
			{0.258731426, 0.260701909}, // 18037K
			{0.258730116, 0.260700152}, // 18038K
			{0.258728807, 0.260698395}, // 18039K
			{0.258727497, 0.260696639}, // 18040K
			{0.258726188, 0.260694883}, // 18041K
			{0.258724879, 0.260693126}, // 18042K
			{0.25872357, 0.260691371}, // 18043K
			{0.258722261, 0.260689615}, // 18044K
			{0.258720952, 0.26068786}, // 18045K
			{0.258719644, 0.260686104}, // 18046K
			{0.258718336, 0.26068435}, // 18047K
			{0.258717028, 0.260682595}, // 18048K
			{0.25871572, 0.26068084}, // 18049K
			{0.258714412, 0.260679086}, // 18050K
			{0.258713105, 0.260677332}, // 18051K
			{0.258711797, 0.260675578}, // 18052K
			{0.25871049, 0.260673824}, // 18053K
			{0.258709183, 0.260672071}, // 18054K
			{0.258707876, 0.260670318}, // 18055K
			{0.25870657, 0.260668565}, // 18056K
			{0.258705263, 0.260666812}, // 18057K
			{0.258703957, 0.26066506}, // 18058K
			{0.258702651, 0.260663307}, // 18059K
			{0.258701345, 0.260661555}, // 18060K
			{0.258700039, 0.260659803}, // 18061K
			{0.258698733, 0.260658052}, // 18062K
			{0.258697428, 0.2606563}, // 18063K
			{0.258696122, 0.260654549}, // 18064K
			{0.258694817, 0.260652798}, // 18065K
			{0.258693512, 0.260651047}, // 18066K
			{0.258692208, 0.260649297}, // 18067K
			{0.258690903, 0.260647546}, // 18068K
			{0.258689599, 0.260645796}, // 18069K
			{0.258688294, 0.260644046}, // 18070K
			{0.25868699, 0.260642297}, // 18071K
			{0.258685686, 0.260640547}, // 18072K
			{0.258684383, 0.260638798}, // 18073K
			{0.258683079, 0.260637049}, // 18074K
			{0.258681776, 0.2606353}, // 18075K
			{0.258680473, 0.260633551}, // 18076K
			{0.25867917, 0.260631803}, // 18077K
			{0.258677867, 0.260630055}, // 18078K
			{0.258676564, 0.260628307}, // 18079K
			{0.258675262, 0.260626559}, // 18080K
			{0.258673959, 0.260624812}, // 18081K
			{0.258672657, 0.260623064}, // 18082K
			{0.258671355, 0.260621317}, // 18083K
			{0.258670053, 0.260619571}, // 18084K
			{0.258668752, 0.260617824}, // 18085K
			{0.25866745, 0.260616078}, // 18086K
			{0.258666149, 0.260614331}, // 18087K
			{0.258664848, 0.260612585}, // 18088K
			{0.258663547, 0.26061084}, // 18089K
			{0.258662246, 0.260609094}, // 18090K
			{0.258660945, 0.260607349}, // 18091K
			{0.258659645, 0.260605604}, // 18092K
			{0.258658345, 0.260603859}, // 18093K
			{0.258657045, 0.260602114}, // 18094K
			{0.258655745, 0.26060037}, // 18095K
			{0.258654445, 0.260598626}, // 18096K
			{0.258653145, 0.260596882}, // 18097K
			{0.258651846, 0.260595138}, // 18098K
			{0.258650547, 0.260593394}, // 18099K
			{0.258649248, 0.260591651}, // 18100K
			{0.258647949, 0.260589908}, // 18101K
			{0.25864665, 0.260588165}, // 18102K
			{0.258645352, 0.260586422}, // 18103K
			{0.258644053, 0.26058468}, // 18104K
			{0.258642755, 0.260582938}, // 18105K
			{0.258641457, 0.260581195}, // 18106K
			{0.258640159, 0.260579454}, // 18107K
			{0.258638861, 0.260577712}, // 18108K
			{0.258637564, 0.260575971}, // 18109K
			{0.258636267, 0.26057423}, // 18110K
			{0.258634969, 0.260572489}, // 18111K
			{0.258633673, 0.260570748}, // 18112K
			{0.258632376, 0.260569007}, // 18113K
			{0.258631079, 0.260567267}, // 18114K
			{0.258629783, 0.260565527}, // 18115K
			{0.258628486, 0.260563787}, // 18116K
			{0.25862719, 0.260562048}, // 18117K
			{0.258625894, 0.260560308}, // 18118K
			{0.258624598, 0.260558569}, // 18119K
			{0.258623303, 0.26055683}, // 18120K
			{0.258622007, 0.260555091}, // 18121K
			{0.258620712, 0.260553353}, // 18122K
			{0.258619417, 0.260551614}, // 18123K
			{0.258618122, 0.260549876}, // 18124K
			{0.258616827, 0.260548138}, // 18125K
			{0.258615533, 0.260546401}, // 18126K
			{0.258614238, 0.260544663}, // 18127K
			{0.258612944, 0.260542926}, // 18128K
			{0.25861165, 0.260541189}, // 18129K
			{0.258610356, 0.260539452}, // 18130K
			{0.258609062, 0.260537715}, // 18131K
			{0.258607769, 0.260535979}, // 18132K
			{0.258606475, 0.260534243}, // 18133K
			{0.258605182, 0.260532507}, // 18134K
			{0.258603889, 0.260530771}, // 18135K
			{0.258602596, 0.260529036}, // 18136K
			{0.258601304, 0.2605273}, // 18137K
			{0.258600011, 0.260525565}, // 18138K
			{0.258598719, 0.26052383}, // 18139K
			{0.258597426, 0.260522096}, // 18140K
			{0.258596134, 0.260520361}, // 18141K
			{0.258594843, 0.260518627}, // 18142K
			{0.258593551, 0.260516893}, // 18143K
			{0.258592259, 0.260515159}, // 18144K
			{0.258590968, 0.260513426}, // 18145K
			{0.258589677, 0.260511693}, // 18146K
			{0.258588386, 0.260509959}, // 18147K
			{0.258587095, 0.260508226}, // 18148K
			{0.258585804, 0.260506494}, // 18149K
			{0.258584514, 0.260504761}, // 18150K
			{0.258583224, 0.260503029}, // 18151K
			{0.258581934, 0.260501297}, // 18152K
			{0.258580644, 0.260499565}, // 18153K
			{0.258579354, 0.260497834}, // 18154K
			{0.258578064, 0.260496102}, // 18155K
			{0.258576775, 0.260494371}, // 18156K
			{0.258575485, 0.26049264}, // 18157K
			{0.258574196, 0.260490909}, // 18158K
			{0.258572907, 0.260489179}, // 18159K
			{0.258571619, 0.260487448}, // 18160K
			{0.25857033, 0.260485718}, // 18161K
			{0.258569042, 0.260483988}, // 18162K
			{0.258567753, 0.260482259}, // 18163K
			{0.258566465, 0.260480529}, // 18164K
			{0.258565177, 0.2604788}, // 18165K
			{0.258563889, 0.260477071}, // 18166K
			{0.258562602, 0.260475342}, // 18167K
			{0.258561314, 0.260473614}, // 18168K
			{0.258560027, 0.260471885}, // 18169K
			{0.25855874, 0.260470157}, // 18170K
			{0.258557453, 0.260468429}, // 18171K
			{0.258556167, 0.260466701}, // 18172K
			{0.25855488, 0.260464974}, // 18173K
			{0.258553594, 0.260463247}, // 18174K
			{0.258552307, 0.260461519}, // 18175K
			{0.258551021, 0.260459793}, // 18176K
			{0.258549735, 0.260458066}, // 18177K
			{0.25854845, 0.260456339}, // 18178K
			{0.258547164, 0.260454613}, // 18179K
			{0.258545879, 0.260452887}, // 18180K
			{0.258544594, 0.260451161}, // 18181K
			{0.258543309, 0.260449436}, // 18182K
			{0.258542024, 0.26044771}, // 18183K
			{0.258540739, 0.260445985}, // 18184K
			{0.258539454, 0.26044426}, // 18185K
			{0.25853817, 0.260442536}, // 18186K
			{0.258536886, 0.260440811}, // 18187K
			{0.258535602, 0.260439087}, // 18188K
			{0.258534318, 0.260437363}, // 18189K
			{0.258533034, 0.260435639}, // 18190K
			{0.258531751, 0.260433915}, // 18191K
			{0.258530467, 0.260432192}, // 18192K
			{0.258529184, 0.260430469}, // 18193K
			{0.258527901, 0.260428746}, // 18194K
			{0.258526618, 0.260427023}, // 18195K
			{0.258525336, 0.2604253}, // 18196K
			{0.258524053, 0.260423578}, // 18197K
			{0.258522771, 0.260421856}, // 18198K
			{0.258521489, 0.260420134}, // 18199K
			{0.258520207, 0.260418412}, // 18200K
			{0.258518925, 0.260416691}, // 18201K
			{0.258517643, 0.260414969}, // 18202K
			{0.258516362, 0.260413248}, // 18203K
			{0.258515081, 0.260411527}, // 18204K
			{0.258513799, 0.260409807}, // 18205K
			{0.258512518, 0.260408086}, // 18206K
			{0.258511238, 0.260406366}, // 18207K
			{0.258509957, 0.260404646}, // 18208K
			{0.258508677, 0.260402926}, // 18209K
			{0.258507396, 0.260401207}, // 18210K
			{0.258506116, 0.260399487}, // 18211K
			{0.258504836, 0.260397768}, // 18212K
			{0.258503556, 0.260396049}, // 18213K
			{0.258502277, 0.26039433}, // 18214K
			{0.258500997, 0.260392612}, // 18215K
			{0.258499718, 0.260390894}, // 18216K
			{0.258498439, 0.260389176}, // 18217K
			{0.25849716, 0.260387458}, // 18218K
			{0.258495881, 0.26038574}, // 18219K
			{0.258494602, 0.260384023}, // 18220K
			{0.258493324, 0.260382305}, // 18221K
			{0.258492046, 0.260380588}, // 18222K
			{0.258490768, 0.260378872}, // 18223K
			{0.25848949, 0.260377155}, // 18224K
			{0.258488212, 0.260375439}, // 18225K
			{0.258486934, 0.260373722}, // 18226K
			{0.258485657, 0.260372007}, // 18227K
			{0.25848438, 0.260370291}, // 18228K
			{0.258483102, 0.260368575}, // 18229K
			{0.258481826, 0.26036686}, // 18230K
			{0.258480549, 0.260365145}, // 18231K
			{0.258479272, 0.26036343}, // 18232K
			{0.258477996, 0.260361715}, // 18233K
			{0.25847672, 0.260360001}, // 18234K
			{0.258475443, 0.260358287}, // 18235K
			{0.258474167, 0.260356573}, // 18236K
			{0.258472892, 0.260354859}, // 18237K
			{0.258471616, 0.260353145}, // 18238K
			{0.258470341, 0.260351432}, // 18239K
			{0.258469065, 0.260349719}, // 18240K
			{0.25846779, 0.260348006}, // 18241K
			{0.258466515, 0.260346293}, // 18242K
			{0.258465241, 0.26034458}, // 18243K
			{0.258463966, 0.260342868}, // 18244K
			{0.258462692, 0.260341156}, // 18245K
			{0.258461417, 0.260339444}, // 18246K
			{0.258460143, 0.260337732}, // 18247K
			{0.258458869, 0.260336021}, // 18248K
			{0.258457596, 0.26033431}, // 18249K
			{0.258456322, 0.260332598}, // 18250K
			{0.258455049, 0.260330888}, // 18251K
			{0.258453775, 0.260329177}, // 18252K
			{0.258452502, 0.260327467}, // 18253K
			{0.258451229, 0.260325756}, // 18254K
			{0.258449957, 0.260324046}, // 18255K
			{0.258448684, 0.260322337}, // 18256K
			{0.258447412, 0.260320627}, // 18257K
			{0.25844614, 0.260318918}, // 18258K
			{0.258444867, 0.260317209}, // 18259K
			{0.258443596, 0.2603155}, // 18260K
			{0.258442324, 0.260313791}, // 18261K
			{0.258441052, 0.260312082}, // 18262K
			{0.258439781, 0.260310374}, // 18263K
			{0.25843851, 0.260308666}, // 18264K
			{0.258437239, 0.260306958}, // 18265K
			{0.258435968, 0.26030525}, // 18266K
			{0.258434697, 0.260303543}, // 18267K
			{0.258433426, 0.260301836}, // 18268K
			{0.258432156, 0.260300129}, // 18269K
			{0.258430886, 0.260298422}, // 18270K
			{0.258429616, 0.260296715}, // 18271K
			{0.258428346, 0.260295009}, // 18272K
			{0.258427076, 0.260293303}, // 18273K
			{0.258425806, 0.260291597}, // 18274K
			{0.258424537, 0.260289891}, // 18275K
			{0.258423268, 0.260288186}, // 18276K
			{0.258421999, 0.26028648}, // 18277K
			{0.25842073, 0.260284775}, // 18278K
			{0.258419461, 0.26028307}, // 18279K
			{0.258418192, 0.260281365}, // 18280K
			{0.258416924, 0.260279661}, // 18281K
			{0.258415656, 0.260277957}, // 18282K
			{0.258414388, 0.260276253}, // 18283K
			{0.25841312, 0.260274549}, // 18284K
			{0.258411852, 0.260272845}, // 18285K
			{0.258410584, 0.260271142}, // 18286K
			{0.258409317, 0.260269438}, // 18287K
			{0.25840805, 0.260267735}, // 18288K
			{0.258406783, 0.260266033}, // 18289K
			{0.258405516, 0.26026433}, // 18290K
			{0.258404249, 0.260262628}, // 18291K
			{0.258402983, 0.260260925}, // 18292K
			{0.258401716, 0.260259224}, // 18293K
			{0.25840045, 0.260257522}, // 18294K
			{0.258399184, 0.26025582}, // 18295K
			{0.258397918, 0.260254119}, // 18296K
			{0.258396652, 0.260252418}, // 18297K
			{0.258395387, 0.260250717}, // 18298K
			{0.258394121, 0.260249016}, // 18299K
			{0.258392856, 0.260247316}, // 18300K
			{0.258391591, 0.260245615}, // 18301K
			{0.258390326, 0.260243915}, // 18302K
			{0.258389061, 0.260242216}, // 18303K
			{0.258387797, 0.260240516}, // 18304K
			{0.258386532, 0.260238816}, // 18305K
			{0.258385268, 0.260237117}, // 18306K
			{0.258384004, 0.260235418}, // 18307K
			{0.25838274, 0.260233719}, // 18308K
			{0.258381476, 0.260232021}, // 18309K
			{0.258380213, 0.260230322}, // 18310K
			{0.258378949, 0.260228624}, // 18311K
			{0.258377686, 0.260226926}, // 18312K
			{0.258376423, 0.260225229}, // 18313K
			{0.25837516, 0.260223531}, // 18314K
			{0.258373897, 0.260221834}, // 18315K
			{0.258372634, 0.260220137}, // 18316K
			{0.258371372, 0.26021844}, // 18317K
			{0.25837011, 0.260216743}, // 18318K
			{0.258368848, 0.260215046}, // 18319K
			{0.258367586, 0.26021335}, // 18320K
			{0.258366324, 0.260211654}, // 18321K
			{0.258365062, 0.260209958}, // 18322K
			{0.258363801, 0.260208263}, // 18323K
			{0.25836254, 0.260206567}, // 18324K
			{0.258361278, 0.260204872}, // 18325K
			{0.258360018, 0.260203177}, // 18326K
			{0.258358757, 0.260201482}, // 18327K
			{0.258357496, 0.260199788}, // 18328K
			{0.258356236, 0.260198093}, // 18329K
			{0.258354975, 0.260196399}, // 18330K
			{0.258353715, 0.260194705}, // 18331K
			{0.258352455, 0.260193011}, // 18332K
			{0.258351196, 0.260191318}, // 18333K
			{0.258349936, 0.260189624}, // 18334K
			{0.258348676, 0.260187931}, // 18335K
			{0.258347417, 0.260186238}, // 18336K
			{0.258346158, 0.260184545}, // 18337K
			{0.258344899, 0.260182853}, // 18338K
			{0.25834364, 0.260181161}, // 18339K
			{0.258342382, 0.260179469}, // 18340K
			{0.258341123, 0.260177777}, // 18341K
			{0.258339865, 0.260176085}, // 18342K
			{0.258338607, 0.260174394}, // 18343K
			{0.258337349, 0.260172702}, // 18344K
			{0.258336091, 0.260171011}, // 18345K
			{0.258334833, 0.26016932}, // 18346K
			{0.258333576, 0.26016763}, // 18347K
			{0.258332318, 0.260165939}, // 18348K
			{0.258331061, 0.260164249}, // 18349K
			{0.258329804, 0.260162559}, // 18350K
			{0.258328547, 0.260160869}, // 18351K
			{0.258327291, 0.26015918}, // 18352K
			{0.258326034, 0.26015749}, // 18353K
			{0.258324778, 0.260155801}, // 18354K
			{0.258323522, 0.260154112}, // 18355K
			{0.258322266, 0.260152423}, // 18356K
			{0.25832101, 0.260150735}, // 18357K
			{0.258319754, 0.260149047}, // 18358K
			{0.258318499, 0.260147358}, // 18359K
			{0.258317243, 0.26014567}, // 18360K
			{0.258315988, 0.260143983}, // 18361K
			{0.258314733, 0.260142295}, // 18362K
			{0.258313478, 0.260140608}, // 18363K
			{0.258312223, 0.260138921}, // 18364K
			{0.258310969, 0.260137234}, // 18365K
			{0.258309715, 0.260135547}, // 18366K
			{0.25830846, 0.260133861}, // 18367K
			{0.258307206, 0.260132175}, // 18368K
			{0.258305952, 0.260130489}, // 18369K
			{0.258304699, 0.260128803}, // 18370K
			{0.258303445, 0.260127117}, // 18371K
			{0.258302192, 0.260125432}, // 18372K
			{0.258300939, 0.260123746}, // 18373K
			{0.258299685, 0.260122061}, // 18374K
			{0.258298433, 0.260120377}, // 18375K
			{0.25829718, 0.260118692}, // 18376K
			{0.258295927, 0.260117008}, // 18377K
			{0.258294675, 0.260115323}, // 18378K
			{0.258293423, 0.260113639}, // 18379K
			{0.258292171, 0.260111956}, // 18380K
			{0.258290919, 0.260110272}, // 18381K
			{0.258289667, 0.260108589}, // 18382K
			{0.258288415, 0.260106906}, // 18383K
			{0.258287164, 0.260105223}, // 18384K
			{0.258285913, 0.26010354}, // 18385K
			{0.258284661, 0.260101857}, // 18386K
			{0.258283411, 0.260100175}, // 18387K
			{0.25828216, 0.260098493}, // 18388K
			{0.258280909, 0.260096811}, // 18389K
			{0.258279659, 0.260095129}, // 18390K
			{0.258278408, 0.260093448}, // 18391K
			{0.258277158, 0.260091767}, // 18392K
			{0.258275908, 0.260090086}, // 18393K
			{0.258274658, 0.260088405}, // 18394K
			{0.258273409, 0.260086724}, // 18395K
			{0.258272159, 0.260085044}, // 18396K
			{0.25827091, 0.260083363}, // 18397K
			{0.258269661, 0.260081683}, // 18398K
			{0.258268412, 0.260080004}, // 18399K
			{0.258267163, 0.260078324}, // 18400K
			{0.258265914, 0.260076645}, // 18401K
			{0.258264666, 0.260074965}, // 18402K
			{0.258263418, 0.260073286}, // 18403K
			{0.258262169, 0.260071607}, // 18404K
			{0.258260921, 0.260069929}, // 18405K
			{0.258259674, 0.260068251}, // 18406K
			{0.258258426, 0.260066572}, // 18407K
			{0.258257178, 0.260064894}, // 18408K
			{0.258255931, 0.260063217}, // 18409K
			{0.258254684, 0.260061539}, // 18410K
			{0.258253437, 0.260059862}, // 18411K
			{0.25825219, 0.260058185}, // 18412K
			{0.258250943, 0.260056508}, // 18413K
			{0.258249697, 0.260054831}, // 18414K
			{0.25824845, 0.260053154}, // 18415K
			{0.258247204, 0.260051478}, // 18416K
			{0.258245958, 0.260049802}, // 18417K
			{0.258244712, 0.260048126}, // 18418K
			{0.258243466, 0.26004645}, // 18419K
			{0.258242221, 0.260044775}, // 18420K
			{0.258240975, 0.2600431}, // 18421K
			{0.25823973, 0.260041424}, // 18422K
			{0.258238485, 0.26003975}, // 18423K
			{0.25823724, 0.260038075}, // 18424K
			{0.258235995, 0.2600364}, // 18425K
			{0.258234751, 0.260034726}, // 18426K
			{0.258233506, 0.260033052}, // 18427K
			{0.258232262, 0.260031378}, // 18428K
			{0.258231018, 0.260029705}, // 18429K
			{0.258229774, 0.260028031}, // 18430K
			{0.25822853, 0.260026358}, // 18431K
			{0.258227286, 0.260024685}, // 18432K
			{0.258226043, 0.260023012}, // 18433K
			{0.2582248, 0.260021339}, // 18434K
			{0.258223557, 0.260019667}, // 18435K
			{0.258222314, 0.260017995}, // 18436K
			{0.258221071, 0.260016323}, // 18437K
			{0.258219828, 0.260014651}, // 18438K
			{0.258218586, 0.260012979}, // 18439K
			{0.258217343, 0.260011308}, // 18440K
			{0.258216101, 0.260009637}, // 18441K
			{0.258214859, 0.260007966}, // 18442K
			{0.258213617, 0.260006295}, // 18443K
			{0.258212375, 0.260004625}, // 18444K
			{0.258211134, 0.260002954}, // 18445K
			{0.258209893, 0.260001284}, // 18446K
			{0.258208651, 0.259999614}, // 18447K
			{0.25820741, 0.259997944}, // 18448K
			{0.258206169, 0.259996275}, // 18449K
			{0.258204929, 0.259994606}, // 18450K
			{0.258203688, 0.259992936}, // 18451K
			{0.258202448, 0.259991268}, // 18452K
			{0.258201207, 0.259989599}, // 18453K
			{0.258199967, 0.25998793}, // 18454K
			{0.258198727, 0.259986262}, // 18455K
			{0.258197488, 0.259984594}, // 18456K
			{0.258196248, 0.259982926}, // 18457K
			{0.258195009, 0.259981258}, // 18458K
			{0.258193769, 0.259979591}, // 18459K
			{0.25819253, 0.259977924}, // 18460K
			{0.258191291, 0.259976256}, // 18461K
			{0.258190053, 0.25997459}, // 18462K
			{0.258188814, 0.259972923}, // 18463K
			{0.258187575, 0.259971256}, // 18464K
			{0.258186337, 0.25996959}, // 18465K
			{0.258185099, 0.259967924}, // 18466K
			{0.258183861, 0.259966258}, // 18467K
			{0.258182623, 0.259964593}, // 18468K
			{0.258181385, 0.259962927}, // 18469K
			{0.258180148, 0.259961262}, // 18470K
			{0.258178911, 0.259959597}, // 18471K
			{0.258177673, 0.259957932}, // 18472K
			{0.258176436, 0.259956267}, // 18473K
			{0.2581752, 0.259954603}, // 18474K
			{0.258173963, 0.259952939}, // 18475K
			{0.258172726, 0.259951275}, // 18476K
			{0.25817149, 0.259949611}, // 18477K
			{0.258170254, 0.259947947}, // 18478K
			{0.258169018, 0.259946284}, // 18479K
			{0.258167782, 0.259944621}, // 18480K
			{0.258166546, 0.259942958}, // 18481K
			{0.25816531, 0.259941295}, // 18482K
			{0.258164075, 0.259939632}, // 18483K
			{0.25816284, 0.25993797}, // 18484K
			{0.258161605, 0.259936308}, // 18485K
			{0.25816037, 0.259934646}, // 18486K
			{0.258159135, 0.259932984}, // 18487K
			{0.2581579, 0.259931322}, // 18488K
			{0.258156666, 0.259929661}, // 18489K
			{0.258155431, 0.259928}, // 18490K
			{0.258154197, 0.259926339}, // 18491K
			{0.258152963, 0.259924678}, // 18492K
			{0.25815173, 0.259923018}, // 18493K
			{0.258150496, 0.259921357}, // 18494K
			{0.258149262, 0.259919697}, // 18495K
			{0.258148029, 0.259918037}, // 18496K
			{0.258146796, 0.259916378}, // 18497K
			{0.258145563, 0.259914718}, // 18498K
			{0.25814433, 0.259913059}, // 18499K
			{0.258143097, 0.259911399}, // 18500K
			{0.258141865, 0.259909741}, // 18501K
			{0.258140632, 0.259908082}, // 18502K
			{0.2581394, 0.259906423}, // 18503K
			{0.258138168, 0.259904765}, // 18504K
			{0.258136936, 0.259903107}, // 18505K
			{0.258135704, 0.259901449}, // 18506K
			{0.258134473, 0.259899791}, // 18507K
			{0.258133241, 0.259898134}, // 18508K
			{0.25813201, 0.259896476}, // 18509K
			{0.258130779, 0.259894819}, // 18510K
			{0.258129548, 0.259893162}, // 18511K
			{0.258128317, 0.259891506}, // 18512K
			{0.258127087, 0.259889849}, // 18513K
			{0.258125856, 0.259888193}, // 18514K
			{0.258124626, 0.259886537}, // 18515K
			{0.258123396, 0.259884881}, // 18516K
			{0.258122166, 0.259883225}, // 18517K
			{0.258120936, 0.25988157}, // 18518K
			{0.258119706, 0.259879915}, // 18519K
			{0.258118477, 0.259878259}, // 18520K
			{0.258117247, 0.259876605}, // 18521K
			{0.258116018, 0.25987495}, // 18522K
			{0.258114789, 0.259873295}, // 18523K
			{0.25811356, 0.259871641}, // 18524K
			{0.258112331, 0.259869987}, // 18525K
			{0.258111103, 0.259868333}, // 18526K
			{0.258109874, 0.25986668}, // 18527K
			{0.258108646, 0.259865026}, // 18528K
			{0.258107418, 0.259863373}, // 18529K
			{0.25810619, 0.25986172}, // 18530K
			{0.258104962, 0.259860067}, // 18531K
			{0.258103735, 0.259858414}, // 18532K
			{0.258102507, 0.259856762}, // 18533K
			{0.25810128, 0.25985511}, // 18534K
			{0.258100053, 0.259853458}, // 18535K
			{0.258098826, 0.259851806}, // 18536K
			{0.258097599, 0.259850154}, // 18537K
			{0.258096372, 0.259848503}, // 18538K
			{0.258095146, 0.259846851}, // 18539K
			{0.25809392, 0.2598452}, // 18540K
			{0.258092693, 0.25984355}, // 18541K
			{0.258091467, 0.259841899}, // 18542K
			{0.258090241, 0.259840249}, // 18543K
			{0.258089016, 0.259838598}, // 18544K
			{0.25808779, 0.259836948}, // 18545K
			{0.258086565, 0.259835298}, // 18546K
			{0.25808534, 0.259833649}, // 18547K
			{0.258084115, 0.259831999}, // 18548K
			{0.25808289, 0.25983035}, // 18549K
			{0.258081665, 0.259828701}, // 18550K
			{0.25808044, 0.259827052}, // 18551K
			{0.258079216, 0.259825404}, // 18552K
			{0.258077992, 0.259823755}, // 18553K
			{0.258076767, 0.259822107}, // 18554K
			{0.258075543, 0.259820459}, // 18555K
			{0.25807432, 0.259818811}, // 18556K
			{0.258073096, 0.259817164}, // 18557K
			{0.258071872, 0.259815516}, // 18558K
			{0.258070649, 0.259813869}, // 18559K
			{0.258069426, 0.259812222}, // 18560K
			{0.258068203, 0.259810575}, // 18561K
			{0.25806698, 0.259808929}, // 18562K
			{0.258065757, 0.259807282}, // 18563K
			{0.258064535, 0.259805636}, // 18564K
			{0.258063312, 0.25980399}, // 18565K
			{0.25806209, 0.259802344}, // 18566K
			{0.258060868, 0.259800699}, // 18567K
			{0.258059646, 0.259799053}, // 18568K
			{0.258058424, 0.259797408}, // 18569K
			{0.258057203, 0.259795763}, // 18570K
			{0.258055981, 0.259794118}, // 18571K
			{0.25805476, 0.259792474}, // 18572K
			{0.258053539, 0.259790829}, // 18573K
			{0.258052318, 0.259789185}, // 18574K
			{0.258051097, 0.259787541}, // 18575K
			{0.258049877, 0.259785897}, // 18576K
			{0.258048656, 0.259784254}, // 18577K
			{0.258047436, 0.25978261}, // 18578K
			{0.258046215, 0.259780967}, // 18579K
			{0.258044995, 0.259779324}, // 18580K
			{0.258043776, 0.259777681}, // 18581K
			{0.258042556, 0.259776039}, // 18582K
			{0.258041336, 0.259774396}, // 18583K
			{0.258040117, 0.259772754}, // 18584K
			{0.258038898, 0.259771112}, // 18585K
			{0.258037679, 0.25976947}, // 18586K
			{0.25803646, 0.259767829}, // 18587K
			{0.258035241, 0.259766187}, // 18588K
			{0.258034022, 0.259764546}, // 18589K
			{0.258032804, 0.259762905}, // 18590K
			{0.258031586, 0.259761264}, // 18591K
			{0.258030367, 0.259759624}, // 18592K
			{0.258029149, 0.259757983}, // 18593K
			{0.258027932, 0.259756343}, // 18594K
			{0.258026714, 0.259754703}, // 18595K
			{0.258025496, 0.259753063}, // 18596K
			{0.258024279, 0.259751424}, // 18597K
			{0.258023062, 0.259749784}, // 18598K
			{0.258021845, 0.259748145}, // 18599K
			{0.258020628, 0.259746506}, // 18600K
			{0.258019411, 0.259744867}, // 18601K
			{0.258018195, 0.259743229}, // 18602K
			{0.258016978, 0.25974159}, // 18603K
			{0.258015762, 0.259739952}, // 18604K
			{0.258014546, 0.259738314}, // 18605K
			{0.25801333, 0.259736676}, // 18606K
			{0.258012114, 0.259735039}, // 18607K
			{0.258010898, 0.259733401}, // 18608K
			{0.258009683, 0.259731764}, // 18609K
			{0.258008468, 0.259730127}, // 18610K
			{0.258007252, 0.25972849}, // 18611K
			{0.258006037, 0.259726854}, // 18612K
			{0.258004823, 0.259725217}, // 18613K
			{0.258003608, 0.259723581}, // 18614K
			{0.258002393, 0.259721945}, // 18615K
			{0.258001179, 0.259720309}, // 18616K
			{0.257999965, 0.259718674}, // 18617K
			{0.257998751, 0.259717038}, // 18618K
			{0.257997537, 0.259715403}, // 18619K
			{0.257996323, 0.259713768}, // 18620K
			{0.257995109, 0.259712133}, // 18621K
			{0.257993896, 0.259710499}, // 18622K
			{0.257992683, 0.259708864}, // 18623K
			{0.257991469, 0.25970723}, // 18624K
			{0.257990256, 0.259705596}, // 18625K
			{0.257989044, 0.259703962}, // 18626K
			{0.257987831, 0.259702329}, // 18627K
			{0.257986618, 0.259700695}, // 18628K
			{0.257985406, 0.259699062}, // 18629K
			{0.257984194, 0.259697429}, // 18630K
			{0.257982982, 0.259695796}, // 18631K
			{0.25798177, 0.259694163}, // 18632K
			{0.257980558, 0.259692531}, // 18633K
			{0.257979347, 0.259690899}, // 18634K
			{0.257978135, 0.259689267}, // 18635K
			{0.257976924, 0.259687635}, // 18636K
			{0.257975713, 0.259686003}, // 18637K
			{0.257974502, 0.259684372}, // 18638K
			{0.257973291, 0.259682741}, // 18639K
			{0.25797208, 0.25968111}, // 18640K
			{0.25797087, 0.259679479}, // 18641K
			{0.25796966, 0.259677848}, // 18642K
			{0.257968449, 0.259676218}, // 18643K
			{0.257967239, 0.259674587}, // 18644K
			{0.25796603, 0.259672957}, // 18645K
			{0.25796482, 0.259671327}, // 18646K
			{0.25796361, 0.259669698}, // 18647K
			{0.257962401, 0.259668068}, // 18648K
			{0.257961192, 0.259666439}, // 18649K
			{0.257959983, 0.25966481}, // 18650K
			{0.257958774, 0.259663181}, // 18651K
			{0.257957565, 0.259661553}, // 18652K
			{0.257956356, 0.259659924}, // 18653K
			{0.257955148, 0.259658296}, // 18654K
			{0.257953939, 0.259656668}, // 18655K
			{0.257952731, 0.25965504}, // 18656K
			{0.257951523, 0.259653412}, // 18657K
			{0.257950315, 0.259651785}, // 18658K
			{0.257949108, 0.259650157}, // 18659K
			{0.2579479, 0.25964853}, // 18660K
			{0.257946693, 0.259646903}, // 18661K
			{0.257945486, 0.259645277}, // 18662K
			{0.257944279, 0.25964365}, // 18663K
			{0.257943072, 0.259642024}, // 18664K
			{0.257941865, 0.259640398}, // 18665K
			{0.257940658, 0.259638772}, // 18666K
			{0.257939452, 0.259637146}, // 18667K
			{0.257938245, 0.259635521}, // 18668K
			{0.257937039, 0.259633895}, // 18669K
			{0.257935833, 0.25963227}, // 18670K
			{0.257934628, 0.259630645}, // 18671K
			{0.257933422, 0.259629021}, // 18672K
			{0.257932216, 0.259627396}, // 18673K
			{0.257931011, 0.259625772}, // 18674K
			{0.257929806, 0.259624148}, // 18675K
			{0.257928601, 0.259622524}, // 18676K
			{0.257927396, 0.2596209}, // 18677K
			{0.257926191, 0.259619277}, // 18678K
			{0.257924986, 0.259617653}, // 18679K
			{0.257923782, 0.25961603}, // 18680K
			{0.257922578, 0.259614407}, // 18681K
			{0.257921374, 0.259612784}, // 18682K
			{0.25792017, 0.259611162}, // 18683K
			{0.257918966, 0.259609539}, // 18684K
			{0.257917762, 0.259607917}, // 18685K
			{0.257916558, 0.259606295}, // 18686K
			{0.257915355, 0.259604674}, // 18687K
			{0.257914152, 0.259603052}, // 18688K
			{0.257912949, 0.259601431}, // 18689K
			{0.257911746, 0.259599809}, // 18690K
			{0.257910543, 0.259598188}, // 18691K
			{0.257909341, 0.259596568}, // 18692K
			{0.257908138, 0.259594947}, // 18693K
			{0.257906936, 0.259593327}, // 18694K
			{0.257905734, 0.259591707}, // 18695K
			{0.257904532, 0.259590087}, // 18696K
			{0.25790333, 0.259588467}, // 18697K
			{0.257902128, 0.259586847}, // 18698K
			{0.257900927, 0.259585228}, // 18699K
			{0.257899725, 0.259583608}, // 18700K
			{0.257898524, 0.259581989}, // 18701K
			{0.257897323, 0.259580371}, // 18702K
			{0.257896122, 0.259578752}, // 18703K
			{0.257894921, 0.259577134}, // 18704K
			{0.257893721, 0.259575515}, // 18705K
			{0.25789252, 0.259573897}, // 18706K
			{0.25789132, 0.259572279}, // 18707K
			{0.25789012, 0.259570662}, // 18708K
			{0.25788892, 0.259569044}, // 18709K
			{0.25788772, 0.259567427}, // 18710K
			{0.257886521, 0.25956581}, // 18711K
			{0.257885321, 0.259564193}, // 18712K
			{0.257884122, 0.259562577}, // 18713K
			{0.257882922, 0.25956096}, // 18714K
			{0.257881723, 0.259559344}, // 18715K
			{0.257880524, 0.259557728}, // 18716K
			{0.257879326, 0.259556112}, // 18717K
			{0.257878127, 0.259554496}, // 18718K
			{0.257876929, 0.259552881}, // 18719K
			{0.25787573, 0.259551265}, // 18720K
			{0.257874532, 0.25954965}, // 18721K
			{0.257873334, 0.259548035}, // 18722K
			{0.257872136, 0.259546421}, // 18723K
			{0.257870939, 0.259544806}, // 18724K
			{0.257869741, 0.259543192}, // 18725K
			{0.257868544, 0.259541578}, // 18726K
			{0.257867347, 0.259539964}, // 18727K
			{0.25786615, 0.25953835}, // 18728K
			{0.257864953, 0.259536736}, // 18729K
			{0.257863756, 0.259535123}, // 18730K
			{0.257862559, 0.25953351}, // 18731K
			{0.257861363, 0.259531897}, // 18732K
			{0.257860166, 0.259530284}, // 18733K
			{0.25785897, 0.259528672}, // 18734K
			{0.257857774, 0.259527059}, // 18735K
			{0.257856578, 0.259525447}, // 18736K
			{0.257855383, 0.259523835}, // 18737K
			{0.257854187, 0.259522223}, // 18738K
			{0.257852992, 0.259520612}, // 18739K
			{0.257851797, 0.259519}, // 18740K
			{0.257850602, 0.259517389}, // 18741K
			{0.257849407, 0.259515778}, // 18742K
			{0.257848212, 0.259514167}, // 18743K
			{0.257847017, 0.259512557}, // 18744K
			{0.257845823, 0.259510946}, // 18745K
			{0.257844628, 0.259509336}, // 18746K
			{0.257843434, 0.259507726}, // 18747K
			{0.25784224, 0.259506116}, // 18748K
			{0.257841046, 0.259504507}, // 18749K
			{0.257839853, 0.259502897}, // 18750K
			{0.257838659, 0.259501288}, // 18751K
			{0.257837466, 0.259499679}, // 18752K
			{0.257836272, 0.25949807}, // 18753K
			{0.257835079, 0.259496461}, // 18754K
			{0.257833886, 0.259494853}, // 18755K
			{0.257832694, 0.259493245}, // 18756K
			{0.257831501, 0.259491636}, // 18757K
			{0.257830308, 0.259490029}, // 18758K
			{0.257829116, 0.259488421}, // 18759K
			{0.257827924, 0.259486813}, // 18760K
			{0.257826732, 0.259485206}, // 18761K
			{0.25782554, 0.259483599}, // 18762K
			{0.257824348, 0.259481992}, // 18763K
			{0.257823157, 0.259480385}, // 18764K
			{0.257821965, 0.259478779}, // 18765K
			{0.257820774, 0.259477172}, // 18766K
			{0.257819583, 0.259475566}, // 18767K
			{0.257818392, 0.25947396}, // 18768K
			{0.257817201, 0.259472354}, // 18769K
			{0.25781601, 0.259470749}, // 18770K
			{0.25781482, 0.259469144}, // 18771K
			{0.25781363, 0.259467538}, // 18772K
			{0.257812439, 0.259465933}, // 18773K
			{0.257811249, 0.259464329}, // 18774K
			{0.257810059, 0.259462724}, // 18775K
			{0.25780887, 0.25946112}, // 18776K
			{0.25780768, 0.259459515}, // 18777K
			{0.257806491, 0.259457911}, // 18778K
			{0.257805301, 0.259456307}, // 18779K
			{0.257804112, 0.259454704}, // 18780K
			{0.257802923, 0.2594531}, // 18781K
			{0.257801734, 0.259451497}, // 18782K
			{0.257800546, 0.259449894}, // 18783K
			{0.257799357, 0.259448291}, // 18784K
			{0.257798169, 0.259446689}, // 18785K
			{0.25779698, 0.259445086}, // 18786K
			{0.257795792, 0.259443484}, // 18787K
			{0.257794604, 0.259441882}, // 18788K
			{0.257793417, 0.25944028}, // 18789K
			{0.257792229, 0.259438678}, // 18790K
			{0.257791041, 0.259437077}, // 18791K
			{0.257789854, 0.259435475}, // 18792K
			{0.257788667, 0.259433874}, // 18793K
			{0.25778748, 0.259432273}, // 18794K
			{0.257786293, 0.259430673}, // 18795K
			{0.257785106, 0.259429072}, // 18796K
			{0.25778392, 0.259427472}, // 18797K
			{0.257782733, 0.259425871}, // 18798K
			{0.257781547, 0.259424271}, // 18799K
			{0.257780361, 0.259422672}, // 18800K
			{0.257779175, 0.259421072}, // 18801K
			{0.257777989, 0.259419473}, // 18802K
			{0.257776803, 0.259417874}, // 18803K
			{0.257775618, 0.259416275}, // 18804K
			{0.257774432, 0.259414676}, // 18805K
			{0.257773247, 0.259413077}, // 18806K
			{0.257772062, 0.259411479}, // 18807K
			{0.257770877, 0.25940988}, // 18808K
			{0.257769692, 0.259408282}, // 18809K
			{0.257768508, 0.259406685}, // 18810K
			{0.257767323, 0.259405087}, // 18811K
			{0.257766139, 0.259403489}, // 18812K
			{0.257764955, 0.259401892}, // 18813K
			{0.257763771, 0.259400295}, // 18814K
			{0.257762587, 0.259398698}, // 18815K
			{0.257761403, 0.259397102}, // 18816K
			{0.25776022, 0.259395505}, // 18817K
			{0.257759036, 0.259393909}, // 18818K
			{0.257757853, 0.259392313}, // 18819K
			{0.25775667, 0.259390717}, // 18820K
			{0.257755487, 0.259389121}, // 18821K
			{0.257754304, 0.259387525}, // 18822K
			{0.257753122, 0.25938593}, // 18823K
			{0.257751939, 0.259384335}, // 18824K
			{0.257750757, 0.25938274}, // 18825K
			{0.257749574, 0.259381145}, // 18826K
			{0.257748392, 0.259379551}, // 18827K
			{0.25774721, 0.259377956}, // 18828K
			{0.257746029, 0.259376362}, // 18829K
			{0.257744847, 0.259374768}, // 18830K
			{0.257743666, 0.259373174}, // 18831K
			{0.257742484, 0.259371581}, // 18832K
			{0.257741303, 0.259369987}, // 18833K
			{0.257740122, 0.259368394}, // 18834K
			{0.257738941, 0.259366801}, // 18835K
			{0.257737761, 0.259365208}, // 18836K
			{0.25773658, 0.259363615}, // 18837K
			{0.2577354, 0.259362023}, // 18838K
			{0.257734219, 0.259360431}, // 18839K
			{0.257733039, 0.259358838}, // 18840K
			{0.257731859, 0.259357247}, // 18841K
			{0.25773068, 0.259355655}, // 18842K
			{0.2577295, 0.259354063}, // 18843K
			{0.25772832, 0.259352472}, // 18844K
			{0.257727141, 0.259350881}, // 18845K
			{0.257725962, 0.25934929}, // 18846K
			{0.257724783, 0.259347699}, // 18847K
			{0.257723604, 0.259346109}, // 18848K
			{0.257722425, 0.259344518}, // 18849K
			{0.257721246, 0.259342928}, // 18850K
			{0.257720068, 0.259341338}, // 18851K
			{0.25771889, 0.259339748}, // 18852K
			{0.257717711, 0.259338159}, // 18853K
			{0.257716533, 0.259336569}, // 18854K
			{0.257715356, 0.25933498}, // 18855K
			{0.257714178, 0.259333391}, // 18856K
			{0.257713, 0.259331802}, // 18857K
			{0.257711823, 0.259330214}, // 18858K
			{0.257710646, 0.259328625}, // 18859K
			{0.257709469, 0.259327037}, // 18860K
			{0.257708292, 0.259325449}, // 18861K
			{0.257707115, 0.259323861}, // 18862K
			{0.257705938, 0.259322273}, // 18863K
			{0.257704762, 0.259320686}, // 18864K
			{0.257703585, 0.259319098}, // 18865K
			{0.257702409, 0.259317511}, // 18866K
			{0.257701233, 0.259315924}, // 18867K
			{0.257700057, 0.259314337}, // 18868K
			{0.257698881, 0.259312751}, // 18869K
			{0.257697706, 0.259311165}, // 18870K
			{0.25769653, 0.259309578}, // 18871K
			{0.257695355, 0.259307992}, // 18872K
			{0.25769418, 0.259306407}, // 18873K
			{0.257693005, 0.259304821}, // 18874K
			{0.25769183, 0.259303236}, // 18875K
			{0.257690655, 0.25930165}, // 18876K
			{0.25768948, 0.259300065}, // 18877K
			{0.257688306, 0.25929848}, // 18878K
			{0.257687132, 0.259296896}, // 18879K
			{0.257685957, 0.259295311}, // 18880K
			{0.257684783, 0.259293727}, // 18881K
			{0.25768361, 0.259292143}, // 18882K
			{0.257682436, 0.259290559}, // 18883K
			{0.257681262, 0.259288975}, // 18884K
			{0.257680089, 0.259287392}, // 18885K
			{0.257678916, 0.259285809}, // 18886K
			{0.257677743, 0.259284225}, // 18887K
			{0.25767657, 0.259282643}, // 18888K
			{0.257675397, 0.25928106}, // 18889K
			{0.257674224, 0.259279477}, // 18890K
			{0.257673052, 0.259277895}, // 18891K
			{0.257671879, 0.259276313}, // 18892K
			{0.257670707, 0.259274731}, // 18893K
			{0.257669535, 0.259273149}, // 18894K
			{0.257668363, 0.259271567}, // 18895K
			{0.257667191, 0.259269986}, // 18896K
			{0.25766602, 0.259268405}, // 18897K
			{0.257664848, 0.259266824}, // 18898K
			{0.257663677, 0.259265243}, // 18899K
			{0.257662506, 0.259263662}, // 18900K
			{0.257661335, 0.259262082}, // 18901K
			{0.257660164, 0.259260501}, // 18902K
			{0.257658993, 0.259258921}, // 18903K
			{0.257657823, 0.259257341}, // 18904K
			{0.257656652, 0.259255761}, // 18905K
			{0.257655482, 0.259254182}, // 18906K
			{0.257654312, 0.259252603}, // 18907K
			{0.257653142, 0.259251023}, // 18908K
			{0.257651972, 0.259249444}, // 18909K
			{0.257650802, 0.259247866}, // 18910K
			{0.257649633, 0.259246287}, // 18911K
			{0.257648463, 0.259244709}, // 18912K
			{0.257647294, 0.259243131}, // 18913K
			{0.257646125, 0.259241553}, // 18914K
			{0.257644956, 0.259239975}, // 18915K
			{0.257643787, 0.259238397}, // 18916K
			{0.257642619, 0.25923682}, // 18917K
			{0.25764145, 0.259235242}, // 18918K
			{0.257640282, 0.259233665}, // 18919K
			{0.257639114, 0.259232088}, // 18920K
			{0.257637946, 0.259230512}, // 18921K
			{0.257636778, 0.259228935}, // 18922K
			{0.25763561, 0.259227359}, // 18923K
			{0.257634442, 0.259225783}, // 18924K
			{0.257633275, 0.259224207}, // 18925K
			{0.257632108, 0.259222631}, // 18926K
			{0.25763094, 0.259221055}, // 18927K
			{0.257629773, 0.25921948}, // 18928K
			{0.257628606, 0.259217905}, // 18929K
			{0.25762744, 0.25921633}, // 18930K
			{0.257626273, 0.259214755}, // 18931K
			{0.257625107, 0.25921318}, // 18932K
			{0.25762394, 0.259211606}, // 18933K
			{0.257622774, 0.259210032}, // 18934K
			{0.257621608, 0.259208458}, // 18935K
			{0.257620442, 0.259206884}, // 18936K
			{0.257619277, 0.25920531}, // 18937K
			{0.257618111, 0.259203737}, // 18938K
			{0.257616946, 0.259202163}, // 18939K
			{0.25761578, 0.25920059}, // 18940K
			{0.257614615, 0.259199017}, // 18941K
			{0.25761345, 0.259197445}, // 18942K
			{0.257612286, 0.259195872}, // 18943K
			{0.257611121, 0.2591943}, // 18944K
			{0.257609956, 0.259192727}, // 18945K
			{0.257608792, 0.259191155}, // 18946K
			{0.257607628, 0.259189584}, // 18947K
			{0.257606464, 0.259188012}, // 18948K
			{0.2576053, 0.259186441}, // 18949K
			{0.257604136, 0.259184869}, // 18950K
			{0.257602972, 0.259183298}, // 18951K
			{0.257601809, 0.259181727}, // 18952K
			{0.257600645, 0.259180157}, // 18953K
			{0.257599482, 0.259178586}, // 18954K
			{0.257598319, 0.259177016}, // 18955K
			{0.257597156, 0.259175446}, // 18956K
			{0.257595994, 0.259173876}, // 18957K
			{0.257594831, 0.259172306}, // 18958K
			{0.257593668, 0.259170737}, // 18959K
			{0.257592506, 0.259169167}, // 18960K
			{0.257591344, 0.259167598}, // 18961K
			{0.257590182, 0.259166029}, // 18962K
			{0.25758902, 0.25916446}, // 18963K
			{0.257587858, 0.259162892}, // 18964K
			{0.257586697, 0.259161323}, // 18965K
			{0.257585535, 0.259159755}, // 18966K
			{0.257584374, 0.259158187}, // 18967K
			{0.257583213, 0.259156619}, // 18968K
			{0.257582052, 0.259155051}, // 18969K
			{0.257580891, 0.259153484}, // 18970K
			{0.25757973, 0.259151917}, // 18971K
			{0.25757857, 0.25915035}, // 18972K
			{0.257577409, 0.259148783}, // 18973K
			{0.257576249, 0.259147216}, // 18974K
			{0.257575089, 0.259145649}, // 18975K
			{0.257573929, 0.259144083}, // 18976K
			{0.257572769, 0.259142517}, // 18977K
			{0.257571609, 0.259140951}, // 18978K
			{0.25757045, 0.259139385}, // 18979K
			{0.25756929, 0.259137819}, // 18980K
			{0.257568131, 0.259136254}, // 18981K
			{0.257566972, 0.259134689}, // 18982K
			{0.257565813, 0.259133124}, // 18983K
			{0.257564654, 0.259131559}, // 18984K
			{0.257563496, 0.259129994}, // 18985K
			{0.257562337, 0.25912843}, // 18986K
			{0.257561179, 0.259126865}, // 18987K
			{0.25756002, 0.259125301}, // 18988K
			{0.257558862, 0.259123737}, // 18989K
			{0.257557704, 0.259122173}, // 18990K
			{0.257556547, 0.25912061}, // 18991K
			{0.257555389, 0.259119046}, // 18992K
			{0.257554232, 0.259117483}, // 18993K
			{0.257553074, 0.25911592}, // 18994K
			{0.257551917, 0.259114357}, // 18995K
			{0.25755076, 0.259112795}, // 18996K
			{0.257549603, 0.259111232}, // 18997K
			{0.257548446, 0.25910967}, // 18998K
			{0.25754729, 0.259108108}, // 18999K
			{0.257546133, 0.259106546}, // 19000K
			{0.257544977, 0.259104984}, // 19001K
			{0.257543821, 0.259103423}, // 19002K
			{0.257542665, 0.259101862}, // 19003K
			{0.257541509, 0.2591003}, // 19004K
			{0.257540353, 0.259098739}, // 19005K
			{0.257539197, 0.259097179}, // 19006K
			{0.257538042, 0.259095618}, // 19007K
			{0.257536886, 0.259094058}, // 19008K
			{0.257535731, 0.259092497}, // 19009K
			{0.257534576, 0.259090937}, // 19010K
			{0.257533421, 0.259089378}, // 19011K
			{0.257532267, 0.259087818}, // 19012K
			{0.257531112, 0.259086258}, // 19013K
			{0.257529958, 0.259084699}, // 19014K
			{0.257528803, 0.25908314}, // 19015K
			{0.257527649, 0.259081581}, // 19016K
			{0.257526495, 0.259080022}, // 19017K
			{0.257525341, 0.259078464}, // 19018K
			{0.257524188, 0.259076906}, // 19019K
			{0.257523034, 0.259075347}, // 19020K
			{0.257521881, 0.259073789}, // 19021K
			{0.257520727, 0.259072232}, // 19022K
			{0.257519574, 0.259070674}, // 19023K
			{0.257518421, 0.259069116}, // 19024K
			{0.257517268, 0.259067559}, // 19025K
			{0.257516116, 0.259066002}, // 19026K
			{0.257514963, 0.259064445}, // 19027K
			{0.257513811, 0.259062889}, // 19028K
			{0.257512658, 0.259061332}, // 19029K
			{0.257511506, 0.259059776}, // 19030K
			{0.257510354, 0.25905822}, // 19031K
			{0.257509202, 0.259056664}, // 19032K
			{0.257508051, 0.259055108}, // 19033K
			{0.257506899, 0.259053552}, // 19034K
			{0.257505748, 0.259051997}, // 19035K
			{0.257504596, 0.259050442}, // 19036K
			{0.257503445, 0.259048887}, // 19037K
			{0.257502294, 0.259047332}, // 19038K
			{0.257501144, 0.259045777}, // 19039K
			{0.257499993, 0.259044223}, // 19040K
			{0.257498842, 0.259042668}, // 19041K
			{0.257497692, 0.259041114}, // 19042K
			{0.257496542, 0.25903956}, // 19043K
			{0.257495392, 0.259038007}, // 19044K
			{0.257494242, 0.259036453}, // 19045K
			{0.257493092, 0.2590349}, // 19046K
			{0.257491942, 0.259033347}, // 19047K
			{0.257490793, 0.259031794}, // 19048K
			{0.257489643, 0.259030241}, // 19049K
			{0.257488494, 0.259028688}, // 19050K
			{0.257487345, 0.259027136}, // 19051K
			{0.257486196, 0.259025584}, // 19052K
			{0.257485047, 0.259024031}, // 19053K
			{0.257483899, 0.25902248}, // 19054K
			{0.25748275, 0.259020928}, // 19055K
			{0.257481602, 0.259019376}, // 19056K
			{0.257480453, 0.259017825}, // 19057K
			{0.257479305, 0.259016274}, // 19058K
			{0.257478157, 0.259014723}, // 19059K
			{0.25747701, 0.259013172}, // 19060K
			{0.257475862, 0.259011622}, // 19061K
			{0.257474714, 0.259010071}, // 19062K
			{0.257473567, 0.259008521}, // 19063K
			{0.25747242, 0.259006971}, // 19064K
			{0.257471273, 0.259005421}, // 19065K
			{0.257470126, 0.259003871}, // 19066K
			{0.257468979, 0.259002322}, // 19067K
			{0.257467832, 0.259000773}, // 19068K
			{0.257466686, 0.258999223}, // 19069K
			{0.25746554, 0.258997674}, // 19070K
			{0.257464393, 0.258996126}, // 19071K
			{0.257463247, 0.258994577}, // 19072K
			{0.257462101, 0.258993029}, // 19073K
			{0.257460956, 0.258991481}, // 19074K
			{0.25745981, 0.258989933}, // 19075K
			{0.257458664, 0.258988385}, // 19076K
			{0.257457519, 0.258986837}, // 19077K
			{0.257456374, 0.25898529}, // 19078K
			{0.257455229, 0.258983742}, // 19079K
			{0.257454084, 0.258982195}, // 19080K
			{0.257452939, 0.258980648}, // 19081K
			{0.257451794, 0.258979102}, // 19082K
			{0.25745065, 0.258977555}, // 19083K
			{0.257449506, 0.258976009}, // 19084K
			{0.257448361, 0.258974462}, // 19085K
			{0.257447217, 0.258972916}, // 19086K
			{0.257446073, 0.258971371}, // 19087K
			{0.25744493, 0.258969825}, // 19088K
			{0.257443786, 0.25896828}, // 19089K
			{0.257442642, 0.258966734}, // 19090K
			{0.257441499, 0.258965189}, // 19091K
			{0.257440356, 0.258963644}, // 19092K
			{0.257439213, 0.2589621}, // 19093K
			{0.25743807, 0.258960555}, // 19094K
			{0.257436927, 0.258959011}, // 19095K
			{0.257435785, 0.258957467}, // 19096K
			{0.257434642, 0.258955923}, // 19097K
			{0.2574335, 0.258954379}, // 19098K
			{0.257432357, 0.258952835}, // 19099K
			{0.257431215, 0.258951292}, // 19100K
			{0.257430073, 0.258949748}, // 19101K
			{0.257428932, 0.258948205}, // 19102K
			{0.25742779, 0.258946662}, // 19103K
			{0.257426649, 0.25894512}, // 19104K
			{0.257425507, 0.258943577}, // 19105K
			{0.257424366, 0.258942035}, // 19106K
			{0.257423225, 0.258940493}, // 19107K
			{0.257422084, 0.258938951}, // 19108K
			{0.257420943, 0.258937409}, // 19109K
			{0.257419803, 0.258935867}, // 19110K
			{0.257418662, 0.258934326}, // 19111K
			{0.257417522, 0.258932785}, // 19112K
			{0.257416382, 0.258931244}, // 19113K
			{0.257415242, 0.258929703}, // 19114K
			{0.257414102, 0.258928162}, // 19115K
			{0.257412962, 0.258926622}, // 19116K
			{0.257411822, 0.258925081}, // 19117K
			{0.257410683, 0.258923541}, // 19118K
			{0.257409543, 0.258922001}, // 19119K
			{0.257408404, 0.258920461}, // 19120K
			{0.257407265, 0.258918922}, // 19121K
			{0.257406126, 0.258917382}, // 19122K
			{0.257404987, 0.258915843}, // 19123K
			{0.257403849, 0.258914304}, // 19124K
			{0.25740271, 0.258912765}, // 19125K
			{0.257401572, 0.258911227}, // 19126K
			{0.257400434, 0.258909688}, // 19127K
			{0.257399296, 0.25890815}, // 19128K
			{0.257398158, 0.258906612}, // 19129K
			{0.25739702, 0.258905074}, // 19130K
			{0.257395882, 0.258903536}, // 19131K
			{0.257394745, 0.258901998}, // 19132K
			{0.257393607, 0.258900461}, // 19133K
			{0.25739247, 0.258898924}, // 19134K
			{0.257391333, 0.258897387}, // 19135K
			{0.257390196, 0.25889585}, // 19136K
			{0.257389059, 0.258894313}, // 19137K
			{0.257387923, 0.258892776}, // 19138K
			{0.257386786, 0.25889124}, // 19139K
			{0.25738565, 0.258889704}, // 19140K
			{0.257384514, 0.258888168}, // 19141K
			{0.257383378, 0.258886632}, // 19142K
			{0.257382242, 0.258885097}, // 19143K
			{0.257381106, 0.258883561}, // 19144K
			{0.25737997, 0.258882026}, // 19145K
			{0.257378835, 0.258880491}, // 19146K
			{0.257377699, 0.258878956}, // 19147K
			{0.257376564, 0.258877421}, // 19148K
			{0.257375429, 0.258875887}, // 19149K
			{0.257374294, 0.258874353}, // 19150K
			{0.257373159, 0.258872818}, // 19151K
			{0.257372025, 0.258871284}, // 19152K
			{0.25737089, 0.258869751}, // 19153K
			{0.257369756, 0.258868217}, // 19154K
			{0.257368621, 0.258866684}, // 19155K
			{0.257367487, 0.25886515}, // 19156K
			{0.257366353, 0.258863617}, // 19157K
			{0.25736522, 0.258862085}, // 19158K
			{0.257364086, 0.258860552}, // 19159K
			{0.257362952, 0.258859019}, // 19160K
			{0.257361819, 0.258857487}, // 19161K
			{0.257360686, 0.258855955}, // 19162K
			{0.257359553, 0.258854423}, // 19163K
			{0.25735842, 0.258852891}, // 19164K
			{0.257357287, 0.258851359}, // 19165K
			{0.257356154, 0.258849828}, // 19166K
			{0.257355022, 0.258848297}, // 19167K
			{0.257353889, 0.258846766}, // 19168K
			{0.257352757, 0.258845235}, // 19169K
			{0.257351625, 0.258843704}, // 19170K
			{0.257350493, 0.258842174}, // 19171K
			{0.257349361, 0.258840643}, // 19172K
			{0.257348229, 0.258839113}, // 19173K
			{0.257347098, 0.258837583}, // 19174K
			{0.257345966, 0.258836053}, // 19175K
			{0.257344835, 0.258834524}, // 19176K
			{0.257343704, 0.258832994}, // 19177K
			{0.257342573, 0.258831465}, // 19178K
			{0.257341442, 0.258829936}, // 19179K
			{0.257340311, 0.258828407}, // 19180K
			{0.257339181, 0.258826878}, // 19181K
			{0.25733805, 0.25882535}, // 19182K
			{0.25733692, 0.258823821}, // 19183K
			{0.25733579, 0.258822293}, // 19184K
			{0.25733466, 0.258820765}, // 19185K
			{0.25733353, 0.258819237}, // 19186K
			{0.2573324, 0.25881771}, // 19187K
			{0.257331271, 0.258816182}, // 19188K
			{0.257330141, 0.258814655}, // 19189K
			{0.257329012, 0.258813128}, // 19190K
			{0.257327883, 0.258811601}, // 19191K
			{0.257326754, 0.258810074}, // 19192K
			{0.257325625, 0.258808548}, // 19193K
			{0.257324496, 0.258807021}, // 19194K
			{0.257323367, 0.258805495}, // 19195K
			{0.257322239, 0.258803969}, // 19196K
			{0.257321111, 0.258802443}, // 19197K
			{0.257319982, 0.258800918}, // 19198K
			{0.257318854, 0.258799392}, // 19199K
			{0.257317727, 0.258797867}, // 19200K
			{0.257316599, 0.258796342}, // 19201K
			{0.257315471, 0.258794817}, // 19202K
			{0.257314344, 0.258793292}, // 19203K
			{0.257313216, 0.258791768}, // 19204K
			{0.257312089, 0.258790243}, // 19205K
			{0.257310962, 0.258788719}, // 19206K
			{0.257309835, 0.258787195}, // 19207K
			{0.257308708, 0.258785671}, // 19208K
			{0.257307582, 0.258784147}, // 19209K
			{0.257306455, 0.258782624}, // 19210K
			{0.257305329, 0.258781101}, // 19211K
			{0.257304203, 0.258779577}, // 19212K
			{0.257303077, 0.258778055}, // 19213K
			{0.257301951, 0.258776532}, // 19214K
			{0.257300825, 0.258775009}, // 19215K
			{0.257299699, 0.258773487}, // 19216K
			{0.257298574, 0.258771965}, // 19217K
			{0.257297448, 0.258770442}, // 19218K
			{0.257296323, 0.258768921}, // 19219K
			{0.257295198, 0.258767399}, // 19220K
			{0.257294073, 0.258765877}, // 19221K
			{0.257292948, 0.258764356}, // 19222K
			{0.257291824, 0.258762835}, // 19223K
			{0.257290699, 0.258761314}, // 19224K
			{0.257289575, 0.258759793}, // 19225K
			{0.25728845, 0.258758272}, // 19226K
			{0.257287326, 0.258756752}, // 19227K
			{0.257286202, 0.258755232}, // 19228K
			{0.257285078, 0.258753712}, // 19229K
			{0.257283955, 0.258752192}, // 19230K
			{0.257282831, 0.258750672}, // 19231K
			{0.257281708, 0.258749152}, // 19232K
			{0.257280584, 0.258747633}, // 19233K
			{0.257279461, 0.258746114}, // 19234K
			{0.257278338, 0.258744595}, // 19235K
			{0.257277215, 0.258743076}, // 19236K
			{0.257276093, 0.258741557}, // 19237K
			{0.25727497, 0.258740039}, // 19238K
			{0.257273848, 0.258738521}, // 19239K
			{0.257272725, 0.258737002}, // 19240K
			{0.257271603, 0.258735485}, // 19241K
			{0.257270481, 0.258733967}, // 19242K
			{0.257269359, 0.258732449}, // 19243K
			{0.257268237, 0.258730932}, // 19244K
			{0.257267116, 0.258729415}, // 19245K
			{0.257265994, 0.258727897}, // 19246K
			{0.257264873, 0.258726381}, // 19247K
			{0.257263752, 0.258724864}, // 19248K
			{0.257262631, 0.258723347}, // 19249K
			{0.25726151, 0.258721831}, // 19250K
			{0.257260389, 0.258720315}, // 19251K
			{0.257259268, 0.258718799}, // 19252K
			{0.257258148, 0.258717283}, // 19253K
			{0.257257028, 0.258715767}, // 19254K
			{0.257255907, 0.258714252}, // 19255K
			{0.257254787, 0.258712737}, // 19256K
			{0.257253667, 0.258711222}, // 19257K
			{0.257252548, 0.258709707}, // 19258K
			{0.257251428, 0.258708192}, // 19259K
			{0.257250308, 0.258706677}, // 19260K
			{0.257249189, 0.258705163}, // 19261K
			{0.25724807, 0.258703649}, // 19262K
			{0.257246951, 0.258702135}, // 19263K
			{0.257245832, 0.258700621}, // 19264K
			{0.257244713, 0.258699107}, // 19265K
			{0.257243594, 0.258697594}, // 19266K
			{0.257242476, 0.258696081}, // 19267K
			{0.257241357, 0.258694567}, // 19268K
			{0.257240239, 0.258693055}, // 19269K
			{0.257239121, 0.258691542}, // 19270K
			{0.257238003, 0.258690029}, // 19271K
			{0.257236885, 0.258688517}, // 19272K
			{0.257235767, 0.258687004}, // 19273K
			{0.25723465, 0.258685492}, // 19274K
			{0.257233532, 0.258683981}, // 19275K
			{0.257232415, 0.258682469}, // 19276K
			{0.257231298, 0.258680957}, // 19277K
			{0.257230181, 0.258679446}, // 19278K
			{0.257229064, 0.258677935}, // 19279K
			{0.257227947, 0.258676424}, // 19280K
			{0.25722683, 0.258674913}, // 19281K
			{0.257225714, 0.258673402}, // 19282K
			{0.257224597, 0.258671892}, // 19283K
			{0.257223481, 0.258670382}, // 19284K
			{0.257222365, 0.258668871}, // 19285K
			{0.257221249, 0.258667361}, // 19286K
			{0.257220134, 0.258665852}, // 19287K
			{0.257219018, 0.258664342}, // 19288K
			{0.257217902, 0.258662833}, // 19289K
			{0.257216787, 0.258661324}, // 19290K
			{0.257215672, 0.258659814}, // 19291K
			{0.257214557, 0.258658306}, // 19292K
			{0.257213442, 0.258656797}, // 19293K
			{0.257212327, 0.258655288}, // 19294K
			{0.257211212, 0.25865378}, // 19295K
			{0.257210098, 0.258652272}, // 19296K
			{0.257208983, 0.258650764}, // 19297K
			{0.257207869, 0.258649256}, // 19298K
			{0.257206755, 0.258647748}, // 19299K
			{0.257205641, 0.258646241}, // 19300K
			{0.257204527, 0.258644734}, // 19301K
			{0.257203413, 0.258643227}, // 19302K
			{0.2572023, 0.25864172}, // 19303K
			{0.257201186, 0.258640213}, // 19304K
			{0.257200073, 0.258638706}, // 19305K
			{0.25719896, 0.2586372}, // 19306K
			{0.257197847, 0.258635694}, // 19307K
			{0.257196734, 0.258634188}, // 19308K
			{0.257195621, 0.258632682}, // 19309K
			{0.257194508, 0.258631176}, // 19310K
			{0.257193396, 0.258629671}, // 19311K
			{0.257192284, 0.258628165}, // 19312K
			{0.257191171, 0.25862666}, // 19313K
			{0.257190059, 0.258625155}, // 19314K
			{0.257188947, 0.25862365}, // 19315K
			{0.257187836, 0.258622146}, // 19316K
			{0.257186724, 0.258620641}, // 19317K
			{0.257185612, 0.258619137}, // 19318K
			{0.257184501, 0.258617633}, // 19319K
			{0.25718339, 0.258616129}, // 19320K
			{0.257182279, 0.258614625}, // 19321K
			{0.257181168, 0.258613122}, // 19322K
			{0.257180057, 0.258611618}, // 19323K
			{0.257178946, 0.258610115}, // 19324K
			{0.257177836, 0.258608612}, // 19325K
			{0.257176725, 0.258607109}, // 19326K
			{0.257175615, 0.258605606}, // 19327K
			{0.257174505, 0.258604104}, // 19328K
			{0.257173395, 0.258602602}, // 19329K
			{0.257172285, 0.258601099}, // 19330K
			{0.257171175, 0.258599597}, // 19331K
			{0.257170066, 0.258598096}, // 19332K
			{0.257168956, 0.258596594}, // 19333K
			{0.257167847, 0.258595092}, // 19334K
			{0.257166738, 0.258593591}, // 19335K
			{0.257165629, 0.25859209}, // 19336K
			{0.25716452, 0.258590589}, // 19337K
			{0.257163411, 0.258589088}, // 19338K
			{0.257162302, 0.258587588}, // 19339K
			{0.257161194, 0.258586087}, // 19340K
			{0.257160085, 0.258584587}, // 19341K
			{0.257158977, 0.258583087}, // 19342K
			{0.257157869, 0.258581587}, // 19343K
			{0.257156761, 0.258580088}, // 19344K
			{0.257155653, 0.258578588}, // 19345K
			{0.257154546, 0.258577089}, // 19346K
			{0.257153438, 0.258575589}, // 19347K
			{0.257152331, 0.25857409}, // 19348K
			{0.257151223, 0.258572592}, // 19349K
			{0.257150116, 0.258571093}, // 19350K
			{0.257149009, 0.258569595}, // 19351K
			{0.257147902, 0.258568096}, // 19352K
			{0.257146796, 0.258566598}, // 19353K
			{0.257145689, 0.2585651}, // 19354K
			{0.257144583, 0.258563602}, // 19355K
			{0.257143476, 0.258562105}, // 19356K
			{0.25714237, 0.258560607}, // 19357K
			{0.257141264, 0.25855911}, // 19358K
			{0.257140158, 0.258557613}, // 19359K
			{0.257139052, 0.258556116}, // 19360K
			{0.257137947, 0.258554619}, // 19361K
			{0.257136841, 0.258553123}, // 19362K
			{0.257135736, 0.258551626}, // 19363K
			{0.257134631, 0.25855013}, // 19364K
			{0.257133526, 0.258548634}, // 19365K
			{0.257132421, 0.258547138}, // 19366K
			{0.257131316, 0.258545643}, // 19367K
			{0.257130211, 0.258544147}, // 19368K
			{0.257129107, 0.258542652}, // 19369K
			{0.257128002, 0.258541157}, // 19370K
			{0.257126898, 0.258539662}, // 19371K
			{0.257125794, 0.258538167}, // 19372K
			{0.25712469, 0.258536672}, // 19373K
			{0.257123586, 0.258535178}, // 19374K
			{0.257122482, 0.258533684}, // 19375K
			{0.257121379, 0.25853219}, // 19376K
			{0.257120275, 0.258530696}, // 19377K
			{0.257119172, 0.258529202}, // 19378K
			{0.257118069, 0.258527708}, // 19379K
			{0.257116966, 0.258526215}, // 19380K
			{0.257115863, 0.258524722}, // 19381K
			{0.25711476, 0.258523229}, // 19382K
			{0.257113657, 0.258521736}, // 19383K
			{0.257112555, 0.258520243}, // 19384K
			{0.257111452, 0.25851875}, // 19385K
			{0.25711035, 0.258517258}, // 19386K
			{0.257109248, 0.258515766}, // 19387K
			{0.257108146, 0.258514274}, // 19388K
			{0.257107044, 0.258512782}, // 19389K
			{0.257105943, 0.25851129}, // 19390K
			{0.257104841, 0.258509799}, // 19391K
			{0.25710374, 0.258508308}, // 19392K
			{0.257102638, 0.258506816}, // 19393K
			{0.257101537, 0.258505325}, // 19394K
			{0.257100436, 0.258503835}, // 19395K
			{0.257099335, 0.258502344}, // 19396K
			{0.257098235, 0.258500854}, // 19397K
			{0.257097134, 0.258499363}, // 19398K
			{0.257096033, 0.258497873}, // 19399K
			{0.257094933, 0.258496383}, // 19400K
			{0.257093833, 0.258494894}, // 19401K
			{0.257092733, 0.258493404}, // 19402K
			{0.257091633, 0.258491915}, // 19403K
			{0.257090533, 0.258490425}, // 19404K
			{0.257089433, 0.258488936}, // 19405K
			{0.257088334, 0.258487447}, // 19406K
			{0.257087235, 0.258485959}, // 19407K
			{0.257086135, 0.25848447}, // 19408K
			{0.257085036, 0.258482982}, // 19409K
			{0.257083937, 0.258481494}, // 19410K
			{0.257082838, 0.258480006}, // 19411K
			{0.25708174, 0.258478518}, // 19412K
			{0.257080641, 0.25847703}, // 19413K
			{0.257079543, 0.258475543}, // 19414K
			{0.257078444, 0.258474055}, // 19415K
			{0.257077346, 0.258472568}, // 19416K
			{0.257076248, 0.258471081}, // 19417K
			{0.25707515, 0.258469594}, // 19418K
			{0.257074052, 0.258468108}, // 19419K
			{0.257072955, 0.258466621}, // 19420K
			{0.257071857, 0.258465135}, // 19421K
			{0.25707076, 0.258463649}, // 19422K
			{0.257069663, 0.258462163}, // 19423K
			{0.257068566, 0.258460677}, // 19424K
			{0.257067469, 0.258459192}, // 19425K
			{0.257066372, 0.258457706}, // 19426K
			{0.257065275, 0.258456221}, // 19427K
			{0.257064179, 0.258454736}, // 19428K
			{0.257063082, 0.258453251}, // 19429K
			{0.257061986, 0.258451766}, // 19430K
			{0.25706089, 0.258450282}, // 19431K
			{0.257059794, 0.258448798}, // 19432K
			{0.257058698, 0.258447313}, // 19433K
			{0.257057602, 0.258445829}, // 19434K
			{0.257056506, 0.258444345}, // 19435K
			{0.257055411, 0.258442862}, // 19436K
			{0.257054316, 0.258441378}, // 19437K
			{0.25705322, 0.258439895}, // 19438K
			{0.257052125, 0.258438412}, // 19439K
			{0.25705103, 0.258436929}, // 19440K
			{0.257049936, 0.258435446}, // 19441K
			{0.257048841, 0.258433963}, // 19442K
			{0.257047746, 0.258432481}, // 19443K
			{0.257046652, 0.258430999}, // 19444K
			{0.257045558, 0.258429516}, // 19445K
			{0.257044464, 0.258428034}, // 19446K
			{0.25704337, 0.258426553}, // 19447K
			{0.257042276, 0.258425071}, // 19448K
			{0.257041182, 0.25842359}, // 19449K
			{0.257040088, 0.258422108}, // 19450K
			{0.257038995, 0.258420627}, // 19451K
			{0.257037902, 0.258419146}, // 19452K
			{0.257036808, 0.258417666}, // 19453K
			{0.257035715, 0.258416185}, // 19454K
			{0.257034622, 0.258414705}, // 19455K
			{0.25703353, 0.258413224}, // 19456K
			{0.257032437, 0.258411744}, // 19457K
			{0.257031344, 0.258410264}, // 19458K
			{0.257030252, 0.258408785}, // 19459K
			{0.25702916, 0.258407305}, // 19460K
			{0.257028068, 0.258405826}, // 19461K
			{0.257026976, 0.258404347}, // 19462K
			{0.257025884, 0.258402868}, // 19463K
			{0.257024792, 0.258401389}, // 19464K
			{0.2570237, 0.25839991}, // 19465K
			{0.257022609, 0.258398432}, // 19466K
			{0.257021518, 0.258396953}, // 19467K
			{0.257020426, 0.258395475}, // 19468K
			{0.257019335, 0.258393997}, // 19469K
			{0.257018245, 0.258392519}, // 19470K
			{0.257017154, 0.258391042}, // 19471K
			{0.257016063, 0.258389564}, // 19472K
			{0.257014973, 0.258388087}, // 19473K
			{0.257013882, 0.25838661}, // 19474K
			{0.257012792, 0.258385133}, // 19475K
			{0.257011702, 0.258383656}, // 19476K
			{0.257010612, 0.258382179}, // 19477K
			{0.257009522, 0.258380703}, // 19478K
			{0.257008432, 0.258379227}, // 19479K
			{0.257007343, 0.25837775}, // 19480K
			{0.257006253, 0.258376275}, // 19481K
			{0.257005164, 0.258374799}, // 19482K
			{0.257004075, 0.258373323}, // 19483K
			{0.257002986, 0.258371848}, // 19484K
			{0.257001897, 0.258370373}, // 19485K
			{0.257000808, 0.258368897}, // 19486K
			{0.256999719, 0.258367423}, // 19487K
			{0.256998631, 0.258365948}, // 19488K
			{0.256997542, 0.258364473}, // 19489K
			{0.256996454, 0.258362999}, // 19490K
			{0.256995366, 0.258361525}, // 19491K
			{0.256994278, 0.258360051}, // 19492K
			{0.25699319, 0.258358577}, // 19493K
			{0.256992102, 0.258357103}, // 19494K
			{0.256991015, 0.25835563}, // 19495K
			{0.256989927, 0.258354156}, // 19496K
			{0.25698884, 0.258352683}, // 19497K
			{0.256987753, 0.25835121}, // 19498K
			{0.256986666, 0.258349737}, // 19499K
			{0.256985579, 0.258348264}, // 19500K
			{0.256984492, 0.258346792}, // 19501K
			{0.256983406, 0.25834532}, // 19502K
			{0.256982319, 0.258343847}, // 19503K
			{0.256981233, 0.258342375}, // 19504K
			{0.256980146, 0.258340904}, // 19505K
			{0.25697906, 0.258339432}, // 19506K
			{0.256977974, 0.25833796}, // 19507K
			{0.256976888, 0.258336489}, // 19508K
			{0.256975803, 0.258335018}, // 19509K
			{0.256974717, 0.258333547}, // 19510K
			{0.256973632, 0.258332076}, // 19511K
			{0.256972546, 0.258330606}, // 19512K
			{0.256971461, 0.258329135}, // 19513K
			{0.256970376, 0.258327665}, // 19514K
			{0.256969291, 0.258326195}, // 19515K
			{0.256968206, 0.258324725}, // 19516K
			{0.256967122, 0.258323255}, // 19517K
			{0.256966037, 0.258321785}, // 19518K
			{0.256964953, 0.258320316}, // 19519K
			{0.256963868, 0.258318847}, // 19520K
			{0.256962784, 0.258317378}, // 19521K
			{0.2569617, 0.258315909}, // 19522K
			{0.256960616, 0.25831444}, // 19523K
			{0.256959533, 0.258312971}, // 19524K
			{0.256958449, 0.258311503}, // 19525K
			{0.256957366, 0.258310035}, // 19526K
			{0.256956282, 0.258308567}, // 19527K
			{0.256955199, 0.258307099}, // 19528K
			{0.256954116, 0.258305631}, // 19529K
			{0.256953033, 0.258304163}, // 19530K
			{0.25695195, 0.258302696}, // 19531K
			{0.256950868, 0.258301229}, // 19532K
			{0.256949785, 0.258299762}, // 19533K
			{0.256948703, 0.258298295}, // 19534K
			{0.25694762, 0.258296828}, // 19535K
			{0.256946538, 0.258295362}, // 19536K
			{0.256945456, 0.258293895}, // 19537K
			{0.256944374, 0.258292429}, // 19538K
			{0.256943293, 0.258290963}, // 19539K
			{0.256942211, 0.258289497}, // 19540K
			{0.256941129, 0.258288031}, // 19541K
			{0.256940048, 0.258286566}, // 19542K
			{0.256938967, 0.258285101}, // 19543K
			{0.256937886, 0.258283635}, // 19544K
			{0.256936805, 0.25828217}, // 19545K
			{0.256935724, 0.258280706}, // 19546K
			{0.256934643, 0.258279241}, // 19547K
			{0.256933563, 0.258277776}, // 19548K
			{0.256932482, 0.258276312}, // 19549K
			{0.256931402, 0.258274848}, // 19550K
			{0.256930322, 0.258273384}, // 19551K
			{0.256929242, 0.25827192}, // 19552K
			{0.256928162, 0.258270456}, // 19553K
			{0.256927082, 0.258268993}, // 19554K
			{0.256926002, 0.25826753}, // 19555K
			{0.256924923, 0.258266066}, // 19556K
			{0.256923844, 0.258264603}, // 19557K
			{0.256922764, 0.258263141}, // 19558K
			{0.256921685, 0.258261678}, // 19559K
			{0.256920606, 0.258260215}, // 19560K
			{0.256919527, 0.258258753}, // 19561K
			{0.256918449, 0.258257291}, // 19562K
			{0.25691737, 0.258255829}, // 19563K
			{0.256916292, 0.258254367}, // 19564K
			{0.256915213, 0.258252906}, // 19565K
			{0.256914135, 0.258251444}, // 19566K
			{0.256913057, 0.258249983}, // 19567K
			{0.256911979, 0.258248522}, // 19568K
			{0.256910901, 0.258247061}, // 19569K
			{0.256909824, 0.2582456}, // 19570K
			{0.256908746, 0.258244139}, // 19571K
			{0.256907669, 0.258242679}, // 19572K
			{0.256906591, 0.258241219}, // 19573K
			{0.256905514, 0.258239759}, // 19574K
			{0.256904437, 0.258238299}, // 19575K
			{0.25690336, 0.258236839}, // 19576K
			{0.256902284, 0.258235379}, // 19577K
			{0.256901207, 0.25823392}, // 19578K
			{0.25690013, 0.258232461}, // 19579K
			{0.256899054, 0.258231002}, // 19580K
			{0.256897978, 0.258229543}, // 19581K
			{0.256896902, 0.258228084}, // 19582K
			{0.256895826, 0.258226625}, // 19583K
			{0.25689475, 0.258225167}, // 19584K
			{0.256893674, 0.258223709}, // 19585K
			{0.256892599, 0.258222251}, // 19586K
			{0.256891523, 0.258220793}, // 19587K
			{0.256890448, 0.258219335}, // 19588K
			{0.256889373, 0.258217877}, // 19589K
			{0.256888298, 0.25821642}, // 19590K
			{0.256887223, 0.258214963}, // 19591K
			{0.256886148, 0.258213506}, // 19592K
			{0.256885073, 0.258212049}, // 19593K
			{0.256883999, 0.258210592}, // 19594K
			{0.256882924, 0.258209135}, // 19595K
			{0.25688185, 0.258207679}, // 19596K
			{0.256880776, 0.258206223}, // 19597K
			{0.256879702, 0.258204767}, // 19598K
			{0.256878628, 0.258203311}, // 19599K
			{0.256877554, 0.258201855}, // 19600K
			{0.256876481, 0.2582004}, // 19601K
			{0.256875407, 0.258198944}, // 19602K
			{0.256874334, 0.258197489}, // 19603K
			{0.256873261, 0.258196034}, // 19604K
			{0.256872188, 0.258194579}, // 19605K
			{0.256871115, 0.258193124}, // 19606K
			{0.256870042, 0.25819167}, // 19607K
			{0.256868969, 0.258190215}, // 19608K
			{0.256867897, 0.258188761}, // 19609K
			{0.256866824, 0.258187307}, // 19610K
			{0.256865752, 0.258185853}, // 19611K
			{0.25686468, 0.258184399}, // 19612K
			{0.256863608, 0.258182946}, // 19613K
			{0.256862536, 0.258181493}, // 19614K
			{0.256861464, 0.258180039}, // 19615K
			{0.256860392, 0.258178586}, // 19616K
			{0.256859321, 0.258177133}, // 19617K
			{0.256858249, 0.258175681}, // 19618K
			{0.256857178, 0.258174228}, // 19619K
			{0.256856107, 0.258172776}, // 19620K
			{0.256855036, 0.258171324}, // 19621K
			{0.256853965, 0.258169872}, // 19622K
			{0.256852894, 0.25816842}, // 19623K
			{0.256851824, 0.258166968}, // 19624K
			{0.256850753, 0.258165517}, // 19625K
			{0.256849683, 0.258164065}, // 19626K
			{0.256848613, 0.258162614}, // 19627K
			{0.256847543, 0.258161163}, // 19628K
			{0.256846473, 0.258159712}, // 19629K
			{0.256845403, 0.258158261}, // 19630K
			{0.256844333, 0.258156811}, // 19631K
			{0.256843263, 0.258155361}, // 19632K
			{0.256842194, 0.25815391}, // 19633K
			{0.256841125, 0.25815246}, // 19634K
			{0.256840056, 0.25815101}, // 19635K
			{0.256838986, 0.258149561}, // 19636K
			{0.256837918, 0.258148111}, // 19637K
			{0.256836849, 0.258146662}, // 19638K
			{0.25683578, 0.258145213}, // 19639K
			{0.256834712, 0.258143764}, // 19640K
			{0.256833643, 0.258142315}, // 19641K
			{0.256832575, 0.258140866}, // 19642K
			{0.256831507, 0.258139418}, // 19643K
			{0.256830439, 0.258137969}, // 19644K
			{0.256829371, 0.258136521}, // 19645K
			{0.256828303, 0.258135073}, // 19646K
			{0.256827235, 0.258133625}, // 19647K
			{0.256826168, 0.258132177}, // 19648K
			{0.256825101, 0.25813073}, // 19649K
			{0.256824033, 0.258129283}, // 19650K
			{0.256822966, 0.258127835}, // 19651K
			{0.256821899, 0.258126388}, // 19652K
			{0.256820832, 0.258124942}, // 19653K
			{0.256819766, 0.258123495}, // 19654K
			{0.256818699, 0.258122048}, // 19655K
			{0.256817633, 0.258120602}, // 19656K
			{0.256816566, 0.258119156}, // 19657K
			{0.2568155, 0.25811771}, // 19658K
			{0.256814434, 0.258116264}, // 19659K
			{0.256813368, 0.258114818}, // 19660K
			{0.256812302, 0.258113373}, // 19661K
			{0.256811237, 0.258111927}, // 19662K
			{0.256810171, 0.258110482}, // 19663K
			{0.256809106, 0.258109037}, // 19664K
			{0.25680804, 0.258107592}, // 19665K
			{0.256806975, 0.258106148}, // 19666K
			{0.25680591, 0.258104703}, // 19667K
			{0.256804845, 0.258103259}, // 19668K
			{0.25680378, 0.258101815}, // 19669K
			{0.256802716, 0.258100371}, // 19670K
			{0.256801651, 0.258098927}, // 19671K
			{0.256800587, 0.258097483}, // 19672K
			{0.256799523, 0.258096039}, // 19673K
			{0.256798458, 0.258094596}, // 19674K
			{0.256797394, 0.258093153}, // 19675K
			{0.25679633, 0.25809171}, // 19676K
			{0.256795267, 0.258090267}, // 19677K
			{0.256794203, 0.258088824}, // 19678K
			{0.25679314, 0.258087382}, // 19679K
			{0.256792076, 0.258085939}, // 19680K
			{0.256791013, 0.258084497}, // 19681K
			{0.25678995, 0.258083055}, // 19682K
			{0.256788887, 0.258081613}, // 19683K
			{0.256787824, 0.258080172}, // 19684K
			{0.256786761, 0.25807873}, // 19685K
			{0.256785699, 0.258077289}, // 19686K
			{0.256784636, 0.258075848}, // 19687K
			{0.256783574, 0.258074406}, // 19688K
			{0.256782512, 0.258072966}, // 19689K
			{0.25678145, 0.258071525}, // 19690K
			{0.256780388, 0.258070084}, // 19691K
			{0.256779326, 0.258068644}, // 19692K
			{0.256778264, 0.258067204}, // 19693K
			{0.256777203, 0.258065764}, // 19694K
			{0.256776141, 0.258064324}, // 19695K
			{0.25677508, 0.258062884}, // 19696K
			{0.256774019, 0.258061445}, // 19697K
			{0.256772958, 0.258060005}, // 19698K
			{0.256771897, 0.258058566}, // 19699K
			{0.256770836, 0.258057127}, // 19700K
			{0.256769775, 0.258055688}, // 19701K
			{0.256768715, 0.258054249}, // 19702K
			{0.256767654, 0.258052811}, // 19703K
			{0.256766594, 0.258051372}, // 19704K
			{0.256765534, 0.258049934}, // 19705K
			{0.256764474, 0.258048496}, // 19706K
			{0.256763414, 0.258047058}, // 19707K
			{0.256762354, 0.258045621}, // 19708K
			{0.256761295, 0.258044183}, // 19709K
			{0.256760235, 0.258042746}, // 19710K
			{0.256759176, 0.258041308}, // 19711K
			{0.256758116, 0.258039871}, // 19712K
			{0.256757057, 0.258038434}, // 19713K
			{0.256755998, 0.258036998}, // 19714K
			{0.256754939, 0.258035561}, // 19715K
			{0.256753881, 0.258034125}, // 19716K
			{0.256752822, 0.258032688}, // 19717K
			{0.256751764, 0.258031252}, // 19718K
			{0.256750705, 0.258029816}, // 19719K
			{0.256749647, 0.258028381}, // 19720K
			{0.256748589, 0.258026945}, // 19721K
			{0.256747531, 0.25802551}, // 19722K
			{0.256746473, 0.258024074}, // 19723K
			{0.256745415, 0.258022639}, // 19724K
			{0.256744358, 0.258021204}, // 19725K
			{0.2567433, 0.25801977}, // 19726K
			{0.256742243, 0.258018335}, // 19727K
			{0.256741186, 0.258016901}, // 19728K
			{0.256740129, 0.258015466}, // 19729K
			{0.256739072, 0.258014032}, // 19730K
			{0.256738015, 0.258012598}, // 19731K
			{0.256736958, 0.258011164}, // 19732K
			{0.256735902, 0.258009731}, // 19733K
			{0.256734845, 0.258008297}, // 19734K
			{0.256733789, 0.258006864}, // 19735K
			{0.256732733, 0.258005431}, // 19736K
			{0.256731677, 0.258003998}, // 19737K
			{0.256730621, 0.258002565}, // 19738K
			{0.256729565, 0.258001133}, // 19739K
			{0.256728509, 0.2579997}, // 19740K
			{0.256727454, 0.257998268}, // 19741K
			{0.256726398, 0.257996836}, // 19742K
			{0.256725343, 0.257995404}, // 19743K
			{0.256724288, 0.257993972}, // 19744K
			{0.256723233, 0.25799254}, // 19745K
			{0.256722178, 0.257991109}, // 19746K
			{0.256721123, 0.257989678}, // 19747K
			{0.256720068, 0.257988246}, // 19748K
			{0.256719014, 0.257986815}, // 19749K
			{0.256717959, 0.257985385}, // 19750K
			{0.256716905, 0.257983954}, // 19751K
			{0.256715851, 0.257982523}, // 19752K
			{0.256714797, 0.257981093}, // 19753K
			{0.256713743, 0.257979663}, // 19754K
			{0.256712689, 0.257978233}, // 19755K
			{0.256711636, 0.257976803}, // 19756K
			{0.256710582, 0.257975374}, // 19757K
			{0.256709529, 0.257973944}, // 19758K
			{0.256708475, 0.257972515}, // 19759K
			{0.256707422, 0.257971085}, // 19760K
			{0.256706369, 0.257969656}, // 19761K
			{0.256705316, 0.257968228}, // 19762K
			{0.256704264, 0.257966799}, // 19763K
			{0.256703211, 0.25796537}, // 19764K
			{0.256702159, 0.257963942}, // 19765K
			{0.256701106, 0.257962514}, // 19766K
			{0.256700054, 0.257961086}, // 19767K
			{0.256699002, 0.257959658}, // 19768K
			{0.25669795, 0.25795823}, // 19769K
			{0.256696898, 0.257956803}, // 19770K
			{0.256695846, 0.257955375}, // 19771K
			{0.256694795, 0.257953948}, // 19772K
			{0.256693743, 0.257952521}, // 19773K
			{0.256692692, 0.257951094}, // 19774K
			{0.256691641, 0.257949667}, // 19775K
			{0.256690589, 0.257948241}, // 19776K
			{0.256689538, 0.257946814}, // 19777K
			{0.256688488, 0.257945388}, // 19778K
			{0.256687437, 0.257943962}, // 19779K
			{0.256686386, 0.257942536}, // 19780K
			{0.256685336, 0.25794111}, // 19781K
			{0.256684285, 0.257939685}, // 19782K
			{0.256683235, 0.257938259}, // 19783K
			{0.256682185, 0.257936834}, // 19784K
			{0.256681135, 0.257935409}, // 19785K
			{0.256680085, 0.257933984}, // 19786K
			{0.256679036, 0.257932559}, // 19787K
			{0.256677986, 0.257931135}, // 19788K
			{0.256676937, 0.25792971}, // 19789K
			{0.256675887, 0.257928286}, // 19790K
			{0.256674838, 0.257926862}, // 19791K
			{0.256673789, 0.257925438}, // 19792K
			{0.25667274, 0.257924014}, // 19793K
			{0.256671691, 0.257922591}, // 19794K
			{0.256670642, 0.257921167}, // 19795K
			{0.256669594, 0.257919744}, // 19796K
			{0.256668545, 0.257918321}, // 19797K
			{0.256667497, 0.257916898}, // 19798K
			{0.256666449, 0.257915475}, // 19799K
			{0.256665401, 0.257914052}, // 19800K
			{0.256664353, 0.25791263}, // 19801K
			{0.256663305, 0.257911207}, // 19802K
			{0.256662257, 0.257909785}, // 19803K
			{0.25666121, 0.257908363}, // 19804K
			{0.256660162, 0.257906941}, // 19805K
			{0.256659115, 0.25790552}, // 19806K
			{0.256658068, 0.257904098}, // 19807K
			{0.256657021, 0.257902677}, // 19808K
			{0.256655974, 0.257901256}, // 19809K
			{0.256654927, 0.257899835}, // 19810K
			{0.25665388, 0.257898414}, // 19811K
			{0.256652834, 0.257896993}, // 19812K
			{0.256651787, 0.257895573}, // 19813K
			{0.256650741, 0.257894152}, // 19814K
			{0.256649695, 0.257892732}, // 19815K
			{0.256648649, 0.257891312}, // 19816K
			{0.256647603, 0.257889892}, // 19817K
			{0.256646557, 0.257888472}, // 19818K
			{0.256645511, 0.257887053}, // 19819K
			{0.256644466, 0.257885633}, // 19820K
			{0.25664342, 0.257884214}, // 19821K
			{0.256642375, 0.257882795}, // 19822K
			{0.25664133, 0.257881376}, // 19823K
			{0.256640285, 0.257879957}, // 19824K
			{0.25663924, 0.257878539}, // 19825K
			{0.256638195, 0.25787712}, // 19826K
			{0.25663715, 0.257875702}, // 19827K
			{0.256636106, 0.257874284}, // 19828K
			{0.256635061, 0.257872866}, // 19829K
			{0.256634017, 0.257871448}, // 19830K
			{0.256632973, 0.257870031}, // 19831K
			{0.256631929, 0.257868613}, // 19832K
			{0.256630885, 0.257867196}, // 19833K
			{0.256629841, 0.257865779}, // 19834K
			{0.256628798, 0.257864362}, // 19835K
			{0.256627754, 0.257862945}, // 19836K
			{0.256626711, 0.257861528}, // 19837K
			{0.256625667, 0.257860112}, // 19838K
			{0.256624624, 0.257858695}, // 19839K
			{0.256623581, 0.257857279}, // 19840K
			{0.256622538, 0.257855863}, // 19841K
			{0.256621495, 0.257854447}, // 19842K
			{0.256620453, 0.257853032}, // 19843K
			{0.25661941, 0.257851616}, // 19844K
			{0.256618368, 0.257850201}, // 19845K
			{0.256617325, 0.257848786}, // 19846K
			{0.256616283, 0.257847371}, // 19847K
			{0.256615241, 0.257845956}, // 19848K
			{0.256614199, 0.257844541}, // 19849K
			{0.256613158, 0.257843126}, // 19850K
			{0.256612116, 0.257841712}, // 19851K
			{0.256611074, 0.257840298}, // 19852K
			{0.256610033, 0.257838884}, // 19853K
			{0.256608992, 0.25783747}, // 19854K
			{0.25660795, 0.257836056}, // 19855K
			{0.256606909, 0.257834642}, // 19856K
			{0.256605868, 0.257833229}, // 19857K
			{0.256604828, 0.257831816}, // 19858K
			{0.256603787, 0.257830403}, // 19859K
			{0.256602746, 0.25782899}, // 19860K
			{0.256601706, 0.257827577}, // 19861K
			{0.256600666, 0.257826164}, // 19862K
			{0.256599626, 0.257824752}, // 19863K
			{0.256598586, 0.25782334}, // 19864K
			{0.256597546, 0.257821927}, // 19865K
			{0.256596506, 0.257820515}, // 19866K
			{0.256595466, 0.257819104}, // 19867K
			{0.256594427, 0.257817692}, // 19868K
			{0.256593387, 0.25781628}, // 19869K
			{0.256592348, 0.257814869}, // 19870K
			{0.256591309, 0.257813458}, // 19871K
			{0.25659027, 0.257812047}, // 19872K
			{0.256589231, 0.257810636}, // 19873K
			{0.256588192, 0.257809225}, // 19874K
			{0.256587153, 0.257807815}, // 19875K
			{0.256586115, 0.257806404}, // 19876K
			{0.256585076, 0.257804994}, // 19877K
			{0.256584038, 0.257803584}, // 19878K
			{0.256583, 0.257802174}, // 19879K
			{0.256581962, 0.257800765}, // 19880K
			{0.256580924, 0.257799355}, // 19881K
			{0.256579886, 0.257797946}, // 19882K
			{0.256578848, 0.257796536}, // 19883K
			{0.256577811, 0.257795127}, // 19884K
			{0.256576773, 0.257793718}, // 19885K
			{0.256575736, 0.25779231}, // 19886K
			{0.256574699, 0.257790901}, // 19887K
			{0.256573662, 0.257789493}, // 19888K
			{0.256572625, 0.257788084}, // 19889K
			{0.256571588, 0.257786676}, // 19890K
			{0.256570551, 0.257785268}, // 19891K
			{0.256569515, 0.25778386}, // 19892K
			{0.256568478, 0.257782453}, // 19893K
			{0.256567442, 0.257781045}, // 19894K
			{0.256566406, 0.257779638}, // 19895K
			{0.25656537, 0.257778231}, // 19896K
			{0.256564334, 0.257776824}, // 19897K
			{0.256563298, 0.257775417}, // 19898K
			{0.256562262, 0.25777401}, // 19899K
			{0.256561227, 0.257772604}, // 19900K
			{0.256560191, 0.257771197}, // 19901K
			{0.256559156, 0.257769791}, // 19902K
			{0.256558121, 0.257768385}, // 19903K
			{0.256557086, 0.257766979}, // 19904K
			{0.256556051, 0.257765573}, // 19905K
			{0.256555016, 0.257764168}, // 19906K
			{0.256553981, 0.257762763}, // 19907K
			{0.256552947, 0.257761357}, // 19908K
			{0.256551912, 0.257759952}, // 19909K
			{0.256550878, 0.257758547}, // 19910K
			{0.256549844, 0.257757142}, // 19911K
			{0.256548809, 0.257755738}, // 19912K
			{0.256547776, 0.257754333}, // 19913K
			{0.256546742, 0.257752929}, // 19914K
			{0.256545708, 0.257751525}, // 19915K
			{0.256544674, 0.257750121}, // 19916K
			{0.256543641, 0.257748717}, // 19917K
			{0.256542608, 0.257747314}, // 19918K
			{0.256541574, 0.25774591}, // 19919K
			{0.256540541, 0.257744507}, // 19920K
			{0.256539508, 0.257743104}, // 19921K
			{0.256538475, 0.257741701}, // 19922K
			{0.256537443, 0.257740298}, // 19923K
			{0.25653641, 0.257738895}, // 19924K
			{0.256535378, 0.257737493}, // 19925K
			{0.256534345, 0.25773609}, // 19926K
			{0.256533313, 0.257734688}, // 19927K
			{0.256532281, 0.257733286}, // 19928K
			{0.256531249, 0.257731884}, // 19929K
			{0.256530217, 0.257730482}, // 19930K
			{0.256529185, 0.257729081}, // 19931K
			{0.256528154, 0.257727679}, // 19932K
			{0.256527122, 0.257726278}, // 19933K
			{0.256526091, 0.257724877}, // 19934K
			{0.25652506, 0.257723476}, // 19935K
			{0.256524028, 0.257722075}, // 19936K
			{0.256522997, 0.257720675}, // 19937K
			{0.256521967, 0.257719274}, // 19938K
			{0.256520936, 0.257717874}, // 19939K
			{0.256519905, 0.257716474}, // 19940K
			{0.256518875, 0.257715074}, // 19941K
			{0.256517844, 0.257713674}, // 19942K
			{0.256516814, 0.257712274}, // 19943K
			{0.256515784, 0.257710875}, // 19944K
			{0.256514754, 0.257709475}, // 19945K
			{0.256513724, 0.257708076}, // 19946K
			{0.256512694, 0.257706677}, // 19947K
			{0.256511665, 0.257705278}, // 19948K
			{0.256510635, 0.257703879}, // 19949K
			{0.256509606, 0.257702481}, // 19950K
			{0.256508576, 0.257701082}, // 19951K
			{0.256507547, 0.257699684}, // 19952K
			{0.256506518, 0.257698286}, // 19953K
			{0.256505489, 0.257696888}, // 19954K
			{0.25650446, 0.25769549}, // 19955K
			{0.256503432, 0.257694093}, // 19956K
			{0.256502403, 0.257692695}, // 19957K
			{0.256501375, 0.257691298}, // 19958K
			{0.256500347, 0.257689901}, // 19959K
			{0.256499318, 0.257688504}, // 19960K
			{0.25649829, 0.257687107}, // 19961K
			{0.256497262, 0.257685711}, // 19962K
			{0.256496235, 0.257684314}, // 19963K
			{0.256495207, 0.257682918}, // 19964K
			{0.256494179, 0.257681522}, // 19965K
			{0.256493152, 0.257680126}, // 19966K
			{0.256492125, 0.25767873}, // 19967K
			{0.256491097, 0.257677334}, // 19968K
			{0.25649007, 0.257675938}, // 19969K
			{0.256489043, 0.257674543}, // 19970K
			{0.256488016, 0.257673148}, // 19971K
			{0.25648699, 0.257671753}, // 19972K
			{0.256485963, 0.257670358}, // 19973K
			{0.256484937, 0.257668963}, // 19974K
			{0.25648391, 0.257667568}, // 19975K
			{0.256482884, 0.257666174}, // 19976K
			{0.256481858, 0.25766478}, // 19977K
			{0.256480832, 0.257663386}, // 19978K
			{0.256479806, 0.257661992}, // 19979K
			{0.256478781, 0.257660598}, // 19980K
			{0.256477755, 0.257659204}, // 19981K
			{0.256476729, 0.257657811}, // 19982K
			{0.256475704, 0.257656417}, // 19983K
			{0.256474679, 0.257655024}, // 19984K
			{0.256473654, 0.257653631}, // 19985K
			{0.256472629, 0.257652238}, // 19986K
			{0.256471604, 0.257650846}, // 19987K
			{0.256470579, 0.257649453}, // 19988K
			{0.256469554, 0.257648061}, // 19989K
			{0.25646853, 0.257646668}, // 19990K
			{0.256467506, 0.257645276}, // 19991K
			{0.256466481, 0.257643884}, // 19992K
			{0.256465457, 0.257642493}, // 19993K
			{0.256464433, 0.257641101}, // 19994K
			{0.256463409, 0.25763971}, // 19995K
			{0.256462386, 0.257638318}, // 19996K
			{0.256461362, 0.257636927}, // 19997K
			{0.256460338, 0.257635536}, // 19998K
			{0.256459315, 0.257634145}, // 19999K
			{0.256458292, 0.257632755}, // 20000K
			{0.256457268, 0.257631364}, // 20001K
			{0.256456245, 0.257629974}, // 20002K
			{0.256455223, 0.257628584}, // 20003K
			{0.2564542, 0.257627194}, // 20004K
			{0.256453177, 0.257625804}, // 20005K
			{0.256452154, 0.257624414}, // 20006K
			{0.256451132, 0.257623024}, // 20007K
			{0.25645011, 0.257621635}, // 20008K
			{0.256449088, 0.257620246}, // 20009K
			{0.256448065, 0.257618857}, // 20010K
			{0.256447044, 0.257617468}, // 20011K
			{0.256446022, 0.257616079}, // 20012K
			{0.256445, 0.25761469}, // 20013K
			{0.256443978, 0.257613302}, // 20014K
			{0.256442957, 0.257611914}, // 20015K
			{0.256441936, 0.257610526}, // 20016K
			{0.256440914, 0.257609138}, // 20017K
			{0.256439893, 0.25760775}, // 20018K
			{0.256438872, 0.257606362}, // 20019K
			{0.256437851, 0.257604975}, // 20020K
			{0.256436831, 0.257603587}, // 20021K
			{0.25643581, 0.2576022}, // 20022K
			{0.25643479, 0.257600813}, // 20023K
			{0.256433769, 0.257599426}, // 20024K
			{0.256432749, 0.257598039}, // 20025K
			{0.256431729, 0.257596653}, // 20026K
			{0.256430709, 0.257595266}, // 20027K
			{0.256429689, 0.25759388}, // 20028K
			{0.256428669, 0.257592494}, // 20029K
			{0.25642765, 0.257591108}, // 20030K
			{0.25642663, 0.257589722}, // 20031K
			{0.256425611, 0.257588337}, // 20032K
			{0.256424591, 0.257586951}, // 20033K
			{0.256423572, 0.257585566}, // 20034K
			{0.256422553, 0.257584181}, // 20035K
			{0.256421534, 0.257582796}, // 20036K
			{0.256420515, 0.257581411}, // 20037K
			{0.256419497, 0.257580026}, // 20038K
			{0.256418478, 0.257578641}, // 20039K
			{0.25641746, 0.257577257}, // 20040K
			{0.256416441, 0.257575873}, // 20041K
			{0.256415423, 0.257574489}, // 20042K
			{0.256414405, 0.257573105}, // 20043K
			{0.256413387, 0.257571721}, // 20044K
			{0.256412369, 0.257570338}, // 20045K
			{0.256411352, 0.257568954}, // 20046K
			{0.256410334, 0.257567571}, // 20047K
			{0.256409317, 0.257566188}, // 20048K
			{0.256408299, 0.257564805}, // 20049K
			{0.256407282, 0.257563422}, // 20050K
			{0.256406265, 0.257562039}, // 20051K
			{0.256405248, 0.257560657}, // 20052K
			{0.256404231, 0.257559274}, // 20053K
			{0.256403214, 0.257557892}, // 20054K
			{0.256402198, 0.25755651}, // 20055K
			{0.256401181, 0.257555128}, // 20056K
			{0.256400165, 0.257553746}, // 20057K
			{0.256399149, 0.257552365}, // 20058K
			{0.256398132, 0.257550983}, // 20059K
			{0.256397116, 0.257549602}, // 20060K
			{0.256396101, 0.257548221}, // 20061K
			{0.256395085, 0.25754684}, // 20062K
			{0.256394069, 0.257545459}, // 20063K
			{0.256393054, 0.257544079}, // 20064K
			{0.256392038, 0.257542698}, // 20065K
			{0.256391023, 0.257541318}, // 20066K
			{0.256390008, 0.257539938}, // 20067K
			{0.256388993, 0.257538558}, // 20068K
			{0.256387978, 0.257537178}, // 20069K
			{0.256386963, 0.257535798}, // 20070K
			{0.256385948, 0.257534419}, // 20071K
			{0.256384934, 0.257533039}, // 20072K
			{0.256383919, 0.25753166}, // 20073K
			{0.256382905, 0.257530281}, // 20074K
			{0.256381891, 0.257528902}, // 20075K
			{0.256380877, 0.257527523}, // 20076K
			{0.256379863, 0.257526145}, // 20077K
			{0.256378849, 0.257524766}, // 20078K
			{0.256377835, 0.257523388}, // 20079K
			{0.256376821, 0.25752201}, // 20080K
			{0.256375808, 0.257520632}, // 20081K
			{0.256374795, 0.257519254}, // 20082K
			{0.256373781, 0.257517876}, // 20083K
			{0.256372768, 0.257516499}, // 20084K
			{0.256371755, 0.257515121}, // 20085K
			{0.256370742, 0.257513744}, // 20086K
			{0.256369729, 0.257512367}, // 20087K
			{0.256368717, 0.25751099}, // 20088K
			{0.256367704, 0.257509613}, // 20089K
			{0.256366692, 0.257508237}, // 20090K
			{0.25636568, 0.25750686}, // 20091K
			{0.256364667, 0.257505484}, // 20092K
			{0.256363655, 0.257504108}, // 20093K
			{0.256362643, 0.257502732}, // 20094K
			{0.256361632, 0.257501356}, // 20095K
			{0.25636062, 0.25749998}, // 20096K
			{0.256359608, 0.257498605}, // 20097K
			{0.256358597, 0.257497229}, // 20098K
			{0.256357586, 0.257495854}, // 20099K
			{0.256356574, 0.257494479}, // 20100K
			{0.256355563, 0.257493104}, // 20101K
			{0.256354552, 0.257491729}, // 20102K
			{0.256353541, 0.257490355}, // 20103K
			{0.256352531, 0.25748898}, // 20104K
			{0.25635152, 0.257487606}, // 20105K
			{0.25635051, 0.257486232}, // 20106K
			{0.256349499, 0.257484858}, // 20107K
			{0.256348489, 0.257483484}, // 20108K
			{0.256347479, 0.257482111}, // 20109K
			{0.256346469, 0.257480737}, // 20110K
			{0.256345459, 0.257479364}, // 20111K
			{0.256344449, 0.257477991}, // 20112K
			{0.256343439, 0.257476618}, // 20113K
			{0.25634243, 0.257475245}, // 20114K
			{0.25634142, 0.257473872}, // 20115K
			{0.256340411, 0.257472499}, // 20116K
			{0.256339402, 0.257471127}, // 20117K
			{0.256338393, 0.257469755}, // 20118K
			{0.256337384, 0.257468383}, // 20119K
			{0.256336375, 0.257467011}, // 20120K
			{0.256335366, 0.257465639}, // 20121K
			{0.256334358, 0.257464267}, // 20122K
			{0.256333349, 0.257462896}, // 20123K
			{0.256332341, 0.257461524}, // 20124K
			{0.256331333, 0.257460153}, // 20125K
			{0.256330325, 0.257458782}, // 20126K
			{0.256329317, 0.257457411}, // 20127K
			{0.256328309, 0.25745604}, // 20128K
			{0.256327301, 0.25745467}, // 20129K
			{0.256326293, 0.257453299}, // 20130K
			{0.256325286, 0.257451929}, // 20131K
			{0.256324279, 0.257450559}, // 20132K
			{0.256323271, 0.257449189}, // 20133K
			{0.256322264, 0.257447819}, // 20134K
			{0.256321257, 0.25744645}, // 20135K
			{0.25632025, 0.25744508}, // 20136K
			{0.256319243, 0.257443711}, // 20137K
			{0.256318237, 0.257442342}, // 20138K
			{0.25631723, 0.257440973}, // 20139K
			{0.256316224, 0.257439604}, // 20140K
			{0.256315217, 0.257438235}, // 20141K
			{0.256314211, 0.257436866}, // 20142K
			{0.256313205, 0.257435498}, // 20143K
			{0.256312199, 0.25743413}, // 20144K
			{0.256311193, 0.257432762}, // 20145K
			{0.256310188, 0.257431394}, // 20146K
			{0.256309182, 0.257430026}, // 20147K
			{0.256308176, 0.257428658}, // 20148K
			{0.256307171, 0.257427291}, // 20149K
			{0.256306166, 0.257425923}, // 20150K
			{0.256305161, 0.257424556}, // 20151K
			{0.256304156, 0.257423189}, // 20152K
			{0.256303151, 0.257421822}, // 20153K
			{0.256302146, 0.257420456}, // 20154K
			{0.256301141, 0.257419089}, // 20155K
			{0.256300137, 0.257417723}, // 20156K
			{0.256299132, 0.257416356}, // 20157K
			{0.256298128, 0.25741499}, // 20158K
			{0.256297124, 0.257413624}, // 20159K
			{0.25629612, 0.257412258}, // 20160K
			{0.256295116, 0.257410893}, // 20161K
			{0.256294112, 0.257409527}, // 20162K
			{0.256293108, 0.257408162}, // 20163K
			{0.256292105, 0.257406797}, // 20164K
			{0.256291101, 0.257405432}, // 20165K
			{0.256290098, 0.257404067}, // 20166K
			{0.256289095, 0.257402702}, // 20167K
			{0.256288091, 0.257401337}, // 20168K
			{0.256287088, 0.257399973}, // 20169K
			{0.256286086, 0.257398609}, // 20170K
			{0.256285083, 0.257397245}, // 20171K
			{0.25628408, 0.257395881}, // 20172K
			{0.256283078, 0.257394517}, // 20173K
			{0.256282075, 0.257393153}, // 20174K
			{0.256281073, 0.25739179}, // 20175K
			{0.256280071, 0.257390426}, // 20176K
			{0.256279069, 0.257389063}, // 20177K
			{0.256278067, 0.2573877}, // 20178K
			{0.256277065, 0.257386337}, // 20179K
			{0.256276063, 0.257384974}, // 20180K
			{0.256275062, 0.257383612}, // 20181K
			{0.25627406, 0.257382249}, // 20182K
			{0.256273059, 0.257380887}, // 20183K
			{0.256272058, 0.257379525}, // 20184K
			{0.256271056, 0.257378163}, // 20185K
			{0.256270055, 0.257376801}, // 20186K
			{0.256269055, 0.257375439}, // 20187K
			{0.256268054, 0.257374078}, // 20188K
			{0.256267053, 0.257372717}, // 20189K
			{0.256266053, 0.257371355}, // 20190K
			{0.256265052, 0.257369994}, // 20191K
			{0.256264052, 0.257368633}, // 20192K
			{0.256263052, 0.257367273}, // 20193K
			{0.256262052, 0.257365912}, // 20194K
			{0.256261052, 0.257364551}, // 20195K
			{0.256260052, 0.257363191}, // 20196K
			{0.256259052, 0.257361831}, // 20197K
			{0.256258053, 0.257360471}, // 20198K
			{0.256257053, 0.257359111}, // 20199K
			{0.256256054, 0.257357751}, // 20200K
			{0.256255055, 0.257356392}, // 20201K
			{0.256254056, 0.257355033}, // 20202K
			{0.256253057, 0.257353673}, // 20203K
			{0.256252058, 0.257352314}, // 20204K
			{0.256251059, 0.257350955}, // 20205K
			{0.25625006, 0.257349596}, // 20206K
			{0.256249062, 0.257348238}, // 20207K
			{0.256248063, 0.257346879}, // 20208K
			{0.256247065, 0.257345521}, // 20209K
			{0.256246067, 0.257344163}, // 20210K
			{0.256245069, 0.257342805}, // 20211K
			{0.256244071, 0.257341447}, // 20212K
			{0.256243073, 0.257340089}, // 20213K
			{0.256242075, 0.257338732}, // 20214K
			{0.256241078, 0.257337374}, // 20215K
			{0.25624008, 0.257336017}, // 20216K
			{0.256239083, 0.25733466}, // 20217K
			{0.256238086, 0.257333303}, // 20218K
			{0.256237089, 0.257331946}, // 20219K
			{0.256236092, 0.257330589}, // 20220K
			{0.256235095, 0.257329233}, // 20221K
			{0.256234098, 0.257327877}, // 20222K
			{0.256233101, 0.25732652}, // 20223K
			{0.256232105, 0.257325164}, // 20224K
			{0.256231108, 0.257323808}, // 20225K
			{0.256230112, 0.257322453}, // 20226K
			{0.256229116, 0.257321097}, // 20227K
			{0.25622812, 0.257319742}, // 20228K
			{0.256227124, 0.257318386}, // 20229K
			{0.256226128, 0.257317031}, // 20230K
			{0.256225132, 0.257315676}, // 20231K
			{0.256224137, 0.257314321}, // 20232K
			{0.256223141, 0.257312967}, // 20233K
			{0.256222146, 0.257311612}, // 20234K
			{0.256221151, 0.257310258}, // 20235K
			{0.256220156, 0.257308904}, // 20236K
			{0.256219161, 0.25730755}, // 20237K
			{0.256218166, 0.257306196}, // 20238K
			{0.256217171, 0.257304842}, // 20239K
			{0.256216176, 0.257303488}, // 20240K
			{0.256215182, 0.257302135}, // 20241K
			{0.256214187, 0.257300781}, // 20242K
			{0.256213193, 0.257299428}, // 20243K
			{0.256212199, 0.257298075}, // 20244K
			{0.256211205, 0.257296722}, // 20245K
			{0.256210211, 0.25729537}, // 20246K
			{0.256209217, 0.257294017}, // 20247K
			{0.256208223, 0.257292665}, // 20248K
			{0.25620723, 0.257291312}, // 20249K
			{0.256206236, 0.25728996}, // 20250K
			{0.256205243, 0.257288608}, // 20251K
			{0.25620425, 0.257287256}, // 20252K
			{0.256203256, 0.257285905}, // 20253K
			{0.256202263, 0.257284553}, // 20254K
			{0.25620127, 0.257283202}, // 20255K
			{0.256200278, 0.257281851}, // 20256K
			{0.256199285, 0.2572805}, // 20257K
			{0.256198292, 0.257279149}, // 20258K
			{0.2561973, 0.257277798}, // 20259K
			{0.256196308, 0.257276447}, // 20260K
			{0.256195315, 0.257275097}, // 20261K
			{0.256194323, 0.257273747}, // 20262K
			{0.256193331, 0.257272397}, // 20263K
			{0.25619234, 0.257271047}, // 20264K
			{0.256191348, 0.257269697}, // 20265K
			{0.256190356, 0.257268347}, // 20266K
			{0.256189365, 0.257266997}, // 20267K
			{0.256188373, 0.257265648}, // 20268K
			{0.256187382, 0.257264299}, // 20269K
			{0.256186391, 0.25726295}, // 20270K
			{0.2561854, 0.257261601}, // 20271K
			{0.256184409, 0.257260252}, // 20272K
			{0.256183418, 0.257258903}, // 20273K
			{0.256182427, 0.257257555}, // 20274K
			{0.256181437, 0.257256206}, // 20275K
			{0.256180446, 0.257254858}, // 20276K
			{0.256179456, 0.25725351}, // 20277K
			{0.256178466, 0.257252162}, // 20278K
			{0.256177476, 0.257250815}, // 20279K
			{0.256176486, 0.257249467}, // 20280K
			{0.256175496, 0.25724812}, // 20281K
			{0.256174506, 0.257246772}, // 20282K
			{0.256173516, 0.257245425}, // 20283K
			{0.256172527, 0.257244078}, // 20284K
			{0.256171537, 0.257242731}, // 20285K
			{0.256170548, 0.257241385}, // 20286K
			{0.256169559, 0.257240038}, // 20287K
			{0.25616857, 0.257238692}, // 20288K
			{0.256167581, 0.257237345}, // 20289K
			{0.256166592, 0.257235999}, // 20290K
			{0.256165603, 0.257234653}, // 20291K
			{0.256164615, 0.257233308}, // 20292K
			{0.256163626, 0.257231962}, // 20293K
			{0.256162638, 0.257230617}, // 20294K
			{0.25616165, 0.257229271}, // 20295K
			{0.256160661, 0.257227926}, // 20296K
			{0.256159673, 0.257226581}, // 20297K
			{0.256158685, 0.257225236}, // 20298K
			{0.256157698, 0.257223891}, // 20299K
			{0.25615671, 0.257222547}, // 20300K
			{0.256155722, 0.257221202}, // 20301K
			{0.256154735, 0.257219858}, // 20302K
			{0.256153748, 0.257218514}, // 20303K
			{0.25615276, 0.25721717}, // 20304K
			{0.256151773, 0.257215826}, // 20305K
			{0.256150786, 0.257214482}, // 20306K
			{0.256149799, 0.257213139}, // 20307K
			{0.256148813, 0.257211795}, // 20308K
			{0.256147826, 0.257210452}, // 20309K
			{0.256146839, 0.257209109}, // 20310K
			{0.256145853, 0.257207766}, // 20311K
			{0.256144867, 0.257206423}, // 20312K
			{0.256143881, 0.257205081}, // 20313K
			{0.256142895, 0.257203738}, // 20314K
			{0.256141909, 0.257202396}, // 20315K
			{0.256140923, 0.257201054}, // 20316K
			{0.256139937, 0.257199712}, // 20317K
			{0.256138951, 0.25719837}, // 20318K
			{0.256137966, 0.257197028}, // 20319K
			{0.256136981, 0.257195686}, // 20320K
			{0.256135995, 0.257194345}, // 20321K
			{0.25613501, 0.257193004}, // 20322K
			{0.256134025, 0.257191662}, // 20323K
			{0.25613304, 0.257190321}, // 20324K
			{0.256132055, 0.257188981}, // 20325K
			{0.256131071, 0.25718764}, // 20326K
			{0.256130086, 0.257186299}, // 20327K
			{0.256129102, 0.257184959}, // 20328K
			{0.256128117, 0.257183619}, // 20329K
			{0.256127133, 0.257182279}, // 20330K
			{0.256126149, 0.257180939}, // 20331K
			{0.256125165, 0.257179599}, // 20332K
			{0.256124181, 0.257178259}, // 20333K
			{0.256123197, 0.25717692}, // 20334K
			{0.256122214, 0.25717558}, // 20335K
			{0.25612123, 0.257174241}, // 20336K
			{0.256120247, 0.257172902}, // 20337K
			{0.256119264, 0.257171563}, // 20338K
			{0.25611828, 0.257170224}, // 20339K
			{0.256117297, 0.257168886}, // 20340K
			{0.256116314, 0.257167547}, // 20341K
			{0.256115331, 0.257166209}, // 20342K
			{0.256114349, 0.257164871}, // 20343K
			{0.256113366, 0.257163533}, // 20344K
			{0.256112384, 0.257162195}, // 20345K
			{0.256111401, 0.257160857}, // 20346K
			{0.256110419, 0.25715952}, // 20347K
			{0.256109437, 0.257158182}, // 20348K
			{0.256108455, 0.257156845}, // 20349K
			{0.256107473, 0.257155508}, // 20350K
			{0.256106491, 0.257154171}, // 20351K
			{0.256105509, 0.257152834}, // 20352K
			{0.256104528, 0.257151497}, // 20353K
			{0.256103546, 0.257150161}, // 20354K
			{0.256102565, 0.257148824}, // 20355K
			{0.256101584, 0.257147488}, // 20356K
			{0.256100603, 0.257146152}, // 20357K
			{0.256099622, 0.257144816}, // 20358K
			{0.256098641, 0.25714348}, // 20359K
			{0.25609766, 0.257142145}, // 20360K
			{0.256096679, 0.257140809}, // 20361K
			{0.256095699, 0.257139474}, // 20362K
			{0.256094718, 0.257138139}, // 20363K
			{0.256093738, 0.257136804}, // 20364K
			{0.256092758, 0.257135469}, // 20365K
			{0.256091778, 0.257134134}, // 20366K
			{0.256090798, 0.257132799}, // 20367K
			{0.256089818, 0.257131465}, // 20368K
			{0.256088838, 0.257130131}, // 20369K
			{0.256087858, 0.257128796}, // 20370K
			{0.256086879, 0.257127462}, // 20371K
			{0.2560859, 0.257126129}, // 20372K
			{0.25608492, 0.257124795}, // 20373K
			{0.256083941, 0.257123461}, // 20374K
			{0.256082962, 0.257122128}, // 20375K
			{0.256081983, 0.257120795}, // 20376K
			{0.256081004, 0.257119461}, // 20377K
			{0.256080025, 0.257118128}, // 20378K
			{0.256079047, 0.257116796}, // 20379K
			{0.256078068, 0.257115463}, // 20380K
			{0.25607709, 0.25711413}, // 20381K
			{0.256076112, 0.257112798}, // 20382K
			{0.256075134, 0.257111466}, // 20383K
			{0.256074156, 0.257110134}, // 20384K
			{0.256073178, 0.257108802}, // 20385K
			{0.2560722, 0.25710747}, // 20386K
			{0.256071222, 0.257106138}, // 20387K
			{0.256070245, 0.257104807}, // 20388K
			{0.256069267, 0.257103475}, // 20389K
			{0.25606829, 0.257102144}, // 20390K
			{0.256067312, 0.257100813}, // 20391K
			{0.256066335, 0.257099482}, // 20392K
			{0.256065358, 0.257098152}, // 20393K
			{0.256064381, 0.257096821}, // 20394K
			{0.256063405, 0.25709549}, // 20395K
			{0.256062428, 0.25709416}, // 20396K
			{0.256061451, 0.25709283}, // 20397K
			{0.256060475, 0.2570915}, // 20398K
			{0.256059499, 0.25709017}, // 20399K
			{0.256058522, 0.25708884}, // 20400K
			{0.256057546, 0.257087511}, // 20401K
			{0.25605657, 0.257086181}, // 20402K
			{0.256055595, 0.257084852}, // 20403K
			{0.256054619, 0.257083523}, // 20404K
			{0.256053643, 0.257082194}, // 20405K
			{0.256052668, 0.257080865}, // 20406K
			{0.256051692, 0.257079536}, // 20407K
			{0.256050717, 0.257078208}, // 20408K
			{0.256049742, 0.257076879}, // 20409K
			{0.256048767, 0.257075551}, // 20410K
			{0.256047792, 0.257074223}, // 20411K
			{0.256046817, 0.257072895}, // 20412K
			{0.256045842, 0.257071567}, // 20413K
			{0.256044867, 0.25707024}, // 20414K
			{0.256043893, 0.257068912}, // 20415K
			{0.256042918, 0.257067585}, // 20416K
			{0.256041944, 0.257066258}, // 20417K
			{0.25604097, 0.257064931}, // 20418K
			{0.256039996, 0.257063604}, // 20419K
			{0.256039022, 0.257062277}, // 20420K
			{0.256038048, 0.25706095}, // 20421K
			{0.256037074, 0.257059624}, // 20422K
			{0.256036101, 0.257058297}, // 20423K
			{0.256035127, 0.257056971}, // 20424K
			{0.256034154, 0.257055645}, // 20425K
			{0.256033181, 0.257054319}, // 20426K
			{0.256032208, 0.257052993}, // 20427K
			{0.256031235, 0.257051668}, // 20428K
			{0.256030262, 0.257050342}, // 20429K
			{0.256029289, 0.257049017}, // 20430K
			{0.256028316, 0.257047692}, // 20431K
			{0.256027344, 0.257046367}, // 20432K
			{0.256026371, 0.257045042}, // 20433K
			{0.256025399, 0.257043717}, // 20434K
			{0.256024426, 0.257042393}, // 20435K
			{0.256023454, 0.257041068}, // 20436K
			{0.256022482, 0.257039744}, // 20437K
			{0.25602151, 0.25703842}, // 20438K
			{0.256020539, 0.257037096}, // 20439K
			{0.256019567, 0.257035772}, // 20440K
			{0.256018595, 0.257034448}, // 20441K
			{0.256017624, 0.257033125}, // 20442K
			{0.256016653, 0.257031801}, // 20443K
			{0.256015681, 0.257030478}, // 20444K
			{0.25601471, 0.257029155}, // 20445K
			{0.256013739, 0.257027832}, // 20446K
			{0.256012768, 0.257026509}, // 20447K
			{0.256011798, 0.257025187}, // 20448K
			{0.256010827, 0.257023864}, // 20449K
			{0.256009856, 0.257022542}, // 20450K
			{0.256008886, 0.257021219}, // 20451K
			{0.256007916, 0.257019897}, // 20452K
			{0.256006945, 0.257018575}, // 20453K
			{0.256005975, 0.257017254}, // 20454K
			{0.256005005, 0.257015932}, // 20455K
			{0.256004035, 0.25701461}, // 20456K
			{0.256003066, 0.257013289}, // 20457K
			{0.256002096, 0.257011968}, // 20458K
			{0.256001126, 0.257010647}, // 20459K
			{0.256000157, 0.257009326}, // 20460K
			{0.255999188, 0.257008005}, // 20461K
			{0.255998218, 0.257006684}, // 20462K
			{0.255997249, 0.257005364}, // 20463K
			{0.25599628, 0.257004044}, // 20464K
			{0.255995312, 0.257002723}, // 20465K
			{0.255994343, 0.257001403}, // 20466K
			{0.255993374, 0.257000083}, // 20467K
			{0.255992406, 0.256998764}, // 20468K
			{0.255991437, 0.256997444}, // 20469K
			{0.255990469, 0.256996125}, // 20470K
			{0.255989501, 0.256994805}, // 20471K
			{0.255988533, 0.256993486}, // 20472K
			{0.255987565, 0.256992167}, // 20473K
			{0.255986597, 0.256990848}, // 20474K
			{0.255985629, 0.25698953}, // 20475K
			{0.255984661, 0.256988211}, // 20476K
			{0.255983694, 0.256986893}, // 20477K
			{0.255982726, 0.256985574}, // 20478K
			{0.255981759, 0.256984256}, // 20479K
			{0.255980792, 0.256982938}, // 20480K
			{0.255979825, 0.25698162}, // 20481K
			{0.255978858, 0.256980303}, // 20482K
			{0.255977891, 0.256978985}, // 20483K
			{0.255976924, 0.256977668}, // 20484K
			{0.255975958, 0.25697635}, // 20485K
			{0.255974991, 0.256975033}, // 20486K
			{0.255974025, 0.256973716}, // 20487K
			{0.255973059, 0.256972399}, // 20488K
			{0.255972092, 0.256971083}, // 20489K
			{0.255971126, 0.256969766}, // 20490K
			{0.25597016, 0.25696845}, // 20491K
			{0.255969195, 0.256967133}, // 20492K
			{0.255968229, 0.256965817}, // 20493K
			{0.255967263, 0.256964501}, // 20494K
			{0.255966298, 0.256963185}, // 20495K
			{0.255965332, 0.25696187}, // 20496K
			{0.255964367, 0.256960554}, // 20497K
			{0.255963402, 0.256959239}, // 20498K
			{0.255962437, 0.256957924}, // 20499K
			{0.255961472, 0.256956609}, // 20500K
			{0.255960507, 0.256955294}, // 20501K
			{0.255959542, 0.256953979}, // 20502K
			{0.255958578, 0.256952664}, // 20503K
			{0.255957613, 0.25695135}, // 20504K
			{0.255956649, 0.256950035}, // 20505K
			{0.255955685, 0.256948721}, // 20506K
			{0.25595472, 0.256947407}, // 20507K
			{0.255953756, 0.256946093}, // 20508K
			{0.255952793, 0.256944779}, // 20509K
			{0.255951829, 0.256943466}, // 20510K
			{0.255950865, 0.256942152}, // 20511K
			{0.255949901, 0.256940839}, // 20512K
			{0.255948938, 0.256939525}, // 20513K
			{0.255947975, 0.256938212}, // 20514K
			{0.255947011, 0.256936899}, // 20515K
			{0.255946048, 0.256935587}, // 20516K
			{0.255945085, 0.256934274}, // 20517K
			{0.255944122, 0.256932962}, // 20518K
			{0.255943159, 0.256931649}, // 20519K
			{0.255942197, 0.256930337}, // 20520K
			{0.255941234, 0.256929025}, // 20521K
			{0.255940272, 0.256927713}, // 20522K
			{0.255939309, 0.256926401}, // 20523K
			{0.255938347, 0.25692509}, // 20524K
			{0.255937385, 0.256923778}, // 20525K
			{0.255936423, 0.256922467}, // 20526K
			{0.255935461, 0.256921156}, // 20527K
			{0.255934499, 0.256919845}, // 20528K
			{0.255933537, 0.256918534}, // 20529K
			{0.255932576, 0.256917223}, // 20530K
			{0.255931614, 0.256915912}, // 20531K
			{0.255930653, 0.256914602}, // 20532K
			{0.255929692, 0.256913292}, // 20533K
			{0.25592873, 0.256911981}, // 20534K
			{0.255927769, 0.256910671}, // 20535K
			{0.255926808, 0.256909361}, // 20536K
			{0.255925848, 0.256908052}, // 20537K
			{0.255924887, 0.256906742}, // 20538K
			{0.255923926, 0.256905433}, // 20539K
			{0.255922966, 0.256904123}, // 20540K
			{0.255922005, 0.256902814}, // 20541K
			{0.255921045, 0.256901505}, // 20542K
			{0.255920085, 0.256900196}, // 20543K
			{0.255919125, 0.256898888}, // 20544K
			{0.255918165, 0.256897579}, // 20545K
			{0.255917205, 0.25689627}, // 20546K
			{0.255916246, 0.256894962}, // 20547K
			{0.255915286, 0.256893654}, // 20548K
			{0.255914326, 0.256892346}, // 20549K
			{0.255913367, 0.256891038}, // 20550K
			{0.255912408, 0.25688973}, // 20551K
			{0.255911449, 0.256888423}, // 20552K
			{0.25591049, 0.256887115}, // 20553K
			{0.255909531, 0.256885808}, // 20554K
			{0.255908572, 0.256884501}, // 20555K
			{0.255907613, 0.256883194}, // 20556K
			{0.255906655, 0.256881887}, // 20557K
			{0.255905696, 0.25688058}, // 20558K
			{0.255904738, 0.256879274}, // 20559K
			{0.255903779, 0.256877967}, // 20560K
			{0.255902821, 0.256876661}, // 20561K
			{0.255901863, 0.256875355}, // 20562K
			{0.255900905, 0.256874049}, // 20563K
			{0.255899947, 0.256872743}, // 20564K
			{0.25589899, 0.256871437}, // 20565K
			{0.255898032, 0.256870132}, // 20566K
			{0.255897075, 0.256868826}, // 20567K
			{0.255896117, 0.256867521}, // 20568K
			{0.25589516, 0.256866216}, // 20569K
			{0.255894203, 0.256864911}, // 20570K
			{0.255893246, 0.256863606}, // 20571K
			{0.255892289, 0.256862301}, // 20572K
			{0.255891332, 0.256860997}, // 20573K
			{0.255890375, 0.256859692}, // 20574K
			{0.255889419, 0.256858388}, // 20575K
			{0.255888462, 0.256857084}, // 20576K
			{0.255887506, 0.25685578}, // 20577K
			{0.25588655, 0.256854476}, // 20578K
			{0.255885593, 0.256853172}, // 20579K
			{0.255884637, 0.256851869}, // 20580K
			{0.255883681, 0.256850565}, // 20581K
			{0.255882726, 0.256849262}, // 20582K
			{0.25588177, 0.256847959}, // 20583K
			{0.255880814, 0.256846656}, // 20584K
			{0.255879859, 0.256845353}, // 20585K
			{0.255878903, 0.25684405}, // 20586K
			{0.255877948, 0.256842748}, // 20587K
			{0.255876993, 0.256841445}, // 20588K
			{0.255876038, 0.256840143}, // 20589K
			{0.255875083, 0.256838841}, // 20590K
			{0.255874128, 0.256837539}, // 20591K
			{0.255873173, 0.256836237}, // 20592K
			{0.255872219, 0.256834936}, // 20593K
			{0.255871264, 0.256833634}, // 20594K
			{0.25587031, 0.256832333}, // 20595K
			{0.255869355, 0.256831031}, // 20596K
			{0.255868401, 0.25682973}, // 20597K
			{0.255867447, 0.256828429}, // 20598K
			{0.255866493, 0.256827128}, // 20599K
			{0.255865539, 0.256825828}, // 20600K
			{0.255864586, 0.256824527}, // 20601K
			{0.255863632, 0.256823227}, // 20602K
			{0.255862678, 0.256821926}, // 20603K
			{0.255861725, 0.256820626}, // 20604K
			{0.255860772, 0.256819326}, // 20605K
			{0.255859818, 0.256818026}, // 20606K
			{0.255858865, 0.256816727}, // 20607K
			{0.255857912, 0.256815427}, // 20608K
			{0.25585696, 0.256814128}, // 20609K
			{0.255856007, 0.256812828}, // 20610K
			{0.255855054, 0.256811529}, // 20611K
			{0.255854102, 0.25681023}, // 20612K
			{0.255853149, 0.256808931}, // 20613K
			{0.255852197, 0.256807633}, // 20614K
			{0.255851245, 0.256806334}, // 20615K
			{0.255850293, 0.256805036}, // 20616K
			{0.255849341, 0.256803738}, // 20617K
			{0.255848389, 0.256802439}, // 20618K
			{0.255847437, 0.256801141}, // 20619K
			{0.255846485, 0.256799844}, // 20620K
			{0.255845534, 0.256798546}, // 20621K
			{0.255844582, 0.256797248}, // 20622K
			{0.255843631, 0.256795951}, // 20623K
			{0.25584268, 0.256794654}, // 20624K
			{0.255841729, 0.256793356}, // 20625K
			{0.255840778, 0.256792059}, // 20626K
			{0.255839827, 0.256790763}, // 20627K
			{0.255838876, 0.256789466}, // 20628K
			{0.255837925, 0.256788169}, // 20629K
			{0.255836975, 0.256786873}, // 20630K
			{0.255836024, 0.256785577}, // 20631K
			{0.255835074, 0.25678428}, // 20632K
			{0.255834124, 0.256782984}, // 20633K
			{0.255833174, 0.256781689}, // 20634K
			{0.255832223, 0.256780393}, // 20635K
			{0.255831274, 0.256779097}, // 20636K
			{0.255830324, 0.256777802}, // 20637K
			{0.255829374, 0.256776507}, // 20638K
			{0.255828425, 0.256775211}, // 20639K
			{0.255827475, 0.256773916}, // 20640K
			{0.255826526, 0.256772622}, // 20641K
			{0.255825576, 0.256771327}, // 20642K
			{0.255824627, 0.256770032}, // 20643K
			{0.255823678, 0.256768738}, // 20644K
			{0.255822729, 0.256767443}, // 20645K
			{0.25582178, 0.256766149}, // 20646K
			{0.255820832, 0.256764855}, // 20647K
			{0.255819883, 0.256763561}, // 20648K
			{0.255818935, 0.256762268}, // 20649K
			{0.255817986, 0.256760974}, // 20650K
			{0.255817038, 0.256759681}, // 20651K
			{0.25581609, 0.256758387}, // 20652K
			{0.255815142, 0.256757094}, // 20653K
			{0.255814194, 0.256755801}, // 20654K
			{0.255813246, 0.256754508}, // 20655K
			{0.255812298, 0.256753216}, // 20656K
			{0.255811351, 0.256751923}, // 20657K
			{0.255810403, 0.25675063}, // 20658K
			{0.255809456, 0.256749338}, // 20659K
			{0.255808508, 0.256748046}, // 20660K
			{0.255807561, 0.256746754}, // 20661K
			{0.255806614, 0.256745462}, // 20662K
			{0.255805667, 0.25674417}, // 20663K
			{0.25580472, 0.256742879}, // 20664K
			{0.255803774, 0.256741587}, // 20665K
			{0.255802827, 0.256740296}, // 20666K
			{0.25580188, 0.256739005}, // 20667K
			{0.255800934, 0.256737714}, // 20668K
			{0.255799988, 0.256736423}, // 20669K
			{0.255799042, 0.256735132}, // 20670K
			{0.255798095, 0.256733841}, // 20671K
			{0.255797149, 0.256732551}, // 20672K
			{0.255796204, 0.256731261}, // 20673K
			{0.255795258, 0.25672997}, // 20674K
			{0.255794312, 0.25672868}, // 20675K
			{0.255793367, 0.25672739}, // 20676K
			{0.255792421, 0.256726101}, // 20677K
			{0.255791476, 0.256724811}, // 20678K
			{0.255790531, 0.256723521}, // 20679K
			{0.255789585, 0.256722232}, // 20680K
			{0.25578864, 0.256720943}, // 20681K
			{0.255787696, 0.256719654}, // 20682K
			{0.255786751, 0.256718365}, // 20683K
			{0.255785806, 0.256717076}, // 20684K
			{0.255784861, 0.256715787}, // 20685K
			{0.255783917, 0.256714499}, // 20686K
			{0.255782973, 0.256713211}, // 20687K
			{0.255782028, 0.256711922}, // 20688K
			{0.255781084, 0.256710634}, // 20689K
			{0.25578014, 0.256709346}, // 20690K
			{0.255779196, 0.256708059}, // 20691K
			{0.255778252, 0.256706771}, // 20692K
			{0.255777309, 0.256705483}, // 20693K
			{0.255776365, 0.256704196}, // 20694K
			{0.255775422, 0.256702909}, // 20695K
			{0.255774478, 0.256701622}, // 20696K
			{0.255773535, 0.256700335}, // 20697K
			{0.255772592, 0.256699048}, // 20698K
			{0.255771649, 0.256697761}, // 20699K
			{0.255770706, 0.256696475}, // 20700K
			{0.255769763, 0.256695188}, // 20701K
			{0.25576882, 0.256693902}, // 20702K
			{0.255767878, 0.256692616}, // 20703K
			{0.255766935, 0.25669133}, // 20704K
			{0.255765993, 0.256690044}, // 20705K
			{0.25576505, 0.256688758}, // 20706K
			{0.255764108, 0.256687473}, // 20707K
			{0.255763166, 0.256686187}, // 20708K
			{0.255762224, 0.256684902}, // 20709K
			{0.255761282, 0.256683617}, // 20710K
			{0.25576034, 0.256682332}, // 20711K
			{0.255759399, 0.256681047}, // 20712K
			{0.255758457, 0.256679763}, // 20713K
			{0.255757516, 0.256678478}, // 20714K
			{0.255756574, 0.256677194}, // 20715K
			{0.255755633, 0.256675909}, // 20716K
			{0.255754692, 0.256674625}, // 20717K
			{0.255753751, 0.256673341}, // 20718K
			{0.25575281, 0.256672057}, // 20719K
			{0.255751869, 0.256670773}, // 20720K
			{0.255750929, 0.25666949}, // 20721K
			{0.255749988, 0.256668206}, // 20722K
			{0.255749048, 0.256666923}, // 20723K
			{0.255748107, 0.25666564}, // 20724K
			{0.255747167, 0.256664357}, // 20725K
			{0.255746227, 0.256663074}, // 20726K
			{0.255745287, 0.256661791}, // 20727K
			{0.255744347, 0.256660509}, // 20728K
			{0.255743407, 0.256659226}, // 20729K
			{0.255742467, 0.256657944}, // 20730K
			{0.255741528, 0.256656662}, // 20731K
			{0.255740588, 0.25665538}, // 20732K
			{0.255739649, 0.256654098}, // 20733K
			{0.25573871, 0.256652816}, // 20734K
			{0.25573777, 0.256651534}, // 20735K
			{0.255736831, 0.256650253}, // 20736K
			{0.255735892, 0.256648972}, // 20737K
			{0.255734953, 0.25664769}, // 20738K
			{0.255734015, 0.256646409}, // 20739K
			{0.255733076, 0.256645128}, // 20740K
			{0.255732138, 0.256643848}, // 20741K
			{0.255731199, 0.256642567}, // 20742K
			{0.255730261, 0.256641286}, // 20743K
			{0.255729323, 0.256640006}, // 20744K
			{0.255728384, 0.256638726}, // 20745K
			{0.255727446, 0.256637446}, // 20746K
			{0.255726509, 0.256636166}, // 20747K
			{0.255725571, 0.256634886}, // 20748K
			{0.255724633, 0.256633606}, // 20749K
			{0.255723696, 0.256632327}, // 20750K
			{0.255722758, 0.256631047}, // 20751K
			{0.255721821, 0.256629768}, // 20752K
			{0.255720883, 0.256628489}, // 20753K
			{0.255719946, 0.25662721}, // 20754K
			{0.255719009, 0.256625931}, // 20755K
			{0.255718072, 0.256624652}, // 20756K
			{0.255717136, 0.256623374}, // 20757K
			{0.255716199, 0.256622095}, // 20758K
			{0.255715262, 0.256620817}, // 20759K
			{0.255714326, 0.256619539}, // 20760K
			{0.255713389, 0.256618261}, // 20761K
			{0.255712453, 0.256616983}, // 20762K
			{0.255711517, 0.256615705}, // 20763K
			{0.255710581, 0.256614428}, // 20764K
			{0.255709645, 0.25661315}, // 20765K
			{0.255708709, 0.256611873}, // 20766K
			{0.255707773, 0.256610596}, // 20767K
			{0.255706838, 0.256609319}, // 20768K
			{0.255705902, 0.256608042}, // 20769K
			{0.255704967, 0.256606765}, // 20770K
			{0.255704031, 0.256605489}, // 20771K
			{0.255703096, 0.256604212}, // 20772K
			{0.255702161, 0.256602936}, // 20773K
			{0.255701226, 0.25660166}, // 20774K
			{0.255700291, 0.256600384}, // 20775K
			{0.255699356, 0.256599108}, // 20776K
			{0.255698422, 0.256597832}, // 20777K
			{0.255697487, 0.256596556}, // 20778K
			{0.255696553, 0.256595281}, // 20779K
			{0.255695618, 0.256594005}, // 20780K
			{0.255694684, 0.25659273}, // 20781K
			{0.25569375, 0.256591455}, // 20782K
			{0.255692816, 0.25659018}, // 20783K
			{0.255691882, 0.256588905}, // 20784K
			{0.255690948, 0.256587631}, // 20785K
			{0.255690014, 0.256586356}, // 20786K
			{0.255689081, 0.256585082}, // 20787K
			{0.255688147, 0.256583807}, // 20788K
			{0.255687214, 0.256582533}, // 20789K
			{0.25568628, 0.256581259}, // 20790K
			{0.255685347, 0.256579986}, // 20791K
			{0.255684414, 0.256578712}, // 20792K
			{0.255683481, 0.256577438}, // 20793K
			{0.255682548, 0.256576165}, // 20794K
			{0.255681615, 0.256574892}, // 20795K
			{0.255680683, 0.256573618}, // 20796K
			{0.25567975, 0.256572345}, // 20797K
			{0.255678818, 0.256571073}, // 20798K
			{0.255677885, 0.2565698}, // 20799K
			{0.255676953, 0.256568527}, // 20800K
			{0.255676021, 0.256567255}, // 20801K
			{0.255675089, 0.256565982}, // 20802K
			{0.255674157, 0.25656471}, // 20803K
			{0.255673225, 0.256563438}, // 20804K
			{0.255672294, 0.256562166}, // 20805K
			{0.255671362, 0.256560895}, // 20806K
			{0.255670431, 0.256559623}, // 20807K
			{0.255669499, 0.256558351}, // 20808K
			{0.255668568, 0.25655708}, // 20809K
			{0.255667637, 0.256555809}, // 20810K
			{0.255666706, 0.256554538}, // 20811K
			{0.255665775, 0.256553267}, // 20812K
			{0.255664844, 0.256551996}, // 20813K
			{0.255663913, 0.256550725}, // 20814K
			{0.255662982, 0.256549455}, // 20815K
			{0.255662052, 0.256548185}, // 20816K
			{0.255661122, 0.256546914}, // 20817K
			{0.255660191, 0.256545644}, // 20818K
			{0.255659261, 0.256544374}, // 20819K
			{0.255658331, 0.256543104}, // 20820K
			{0.255657401, 0.256541835}, // 20821K
			{0.255656471, 0.256540565}, // 20822K
			{0.255655541, 0.256539296}, // 20823K
			{0.255654611, 0.256538026}, // 20824K
			{0.255653682, 0.256536757}, // 20825K
			{0.255652752, 0.256535488}, // 20826K
			{0.255651823, 0.256534219}, // 20827K
			{0.255650894, 0.256532951}, // 20828K
			{0.255649965, 0.256531682}, // 20829K
			{0.255649036, 0.256530414}, // 20830K
			{0.255648107, 0.256529145}, // 20831K
			{0.255647178, 0.256527877}, // 20832K
			{0.255646249, 0.256526609}, // 20833K
			{0.25564532, 0.256525341}, // 20834K
			{0.255644392, 0.256524074}, // 20835K
			{0.255643463, 0.256522806}, // 20836K
			{0.255642535, 0.256521538}, // 20837K
			{0.255641607, 0.256520271}, // 20838K
			{0.255640679, 0.256519004}, // 20839K
			{0.255639751, 0.256517737}, // 20840K
			{0.255638823, 0.25651647}, // 20841K
			{0.255637895, 0.256515203}, // 20842K
			{0.255636967, 0.256513936}, // 20843K
			{0.25563604, 0.25651267}, // 20844K
			{0.255635112, 0.256511403}, // 20845K
			{0.255634185, 0.256510137}, // 20846K
			{0.255633258, 0.256508871}, // 20847K
			{0.255632331, 0.256507605}, // 20848K
			{0.255631404, 0.256506339}, // 20849K
			{0.255630477, 0.256505074}, // 20850K
			{0.25562955, 0.256503808}, // 20851K
			{0.255628623, 0.256502543}, // 20852K
			{0.255627696, 0.256501277}, // 20853K
			{0.25562677, 0.256500012}, // 20854K
			{0.255625844, 0.256498747}, // 20855K
			{0.255624917, 0.256497482}, // 20856K
			{0.255623991, 0.256496218}, // 20857K
			{0.255623065, 0.256494953}, // 20858K
			{0.255622139, 0.256493688}, // 20859K
			{0.255621213, 0.256492424}, // 20860K
			{0.255620287, 0.25649116}, // 20861K
			{0.255619362, 0.256489896}, // 20862K
			{0.255618436, 0.256488632}, // 20863K
			{0.255617511, 0.256487368}, // 20864K
			{0.255616585, 0.256486105}, // 20865K
			{0.25561566, 0.256484841}, // 20866K
			{0.255614735, 0.256483578}, // 20867K
			{0.25561381, 0.256482314}, // 20868K
			{0.255612885, 0.256481051}, // 20869K
			{0.25561196, 0.256479788}, // 20870K
			{0.255611035, 0.256478526}, // 20871K
			{0.255610111, 0.256477263}, // 20872K
			{0.255609186, 0.256476}, // 20873K
			{0.255608262, 0.256474738}, // 20874K
			{0.255607337, 0.256473476}, // 20875K
			{0.255606413, 0.256472214}, // 20876K
			{0.255605489, 0.256470952}, // 20877K
			{0.255604565, 0.25646969}, // 20878K
			{0.255603641, 0.256468428}, // 20879K
			{0.255602717, 0.256467166}, // 20880K
			{0.255601794, 0.256465905}, // 20881K
			{0.25560087, 0.256464644}, // 20882K
			{0.255599947, 0.256463382}, // 20883K
			{0.255599023, 0.256462121}, // 20884K
			{0.2555981, 0.25646086}, // 20885K
			{0.255597177, 0.2564596}, // 20886K
			{0.255596254, 0.256458339}, // 20887K
			{0.255595331, 0.256457078}, // 20888K
			{0.255594408, 0.256455818}, // 20889K
			{0.255593485, 0.256454558}, // 20890K
			{0.255592563, 0.256453298}, // 20891K
			{0.25559164, 0.256452038}, // 20892K
			{0.255590718, 0.256450778}, // 20893K
			{0.255589795, 0.256449518}, // 20894K
			{0.255588873, 0.256448259}, // 20895K
			{0.255587951, 0.256446999}, // 20896K
			{0.255587029, 0.25644574}, // 20897K
			{0.255586107, 0.256444481}, // 20898K
			{0.255585185, 0.256443222}, // 20899K
			{0.255584264, 0.256441963}, // 20900K
			{0.255583342, 0.256440704}, // 20901K
			{0.255582421, 0.256439446}, // 20902K
			{0.255581499, 0.256438187}, // 20903K
			{0.255580578, 0.256436929}, // 20904K
			{0.255579657, 0.256435671}, // 20905K
			{0.255578736, 0.256434413}, // 20906K
			{0.255577815, 0.256433155}, // 20907K
			{0.255576894, 0.256431897}, // 20908K
			{0.255575973, 0.256430639}, // 20909K
			{0.255575053, 0.256429382}, // 20910K
			{0.255574132, 0.256428125}, // 20911K
			{0.255573212, 0.256426867}, // 20912K
			{0.255572291, 0.25642561}, // 20913K
			{0.255571371, 0.256424353}, // 20914K
			{0.255570451, 0.256423096}, // 20915K
			{0.255569531, 0.25642184}, // 20916K
			{0.255568611, 0.256420583}, // 20917K
			{0.255567691, 0.256419327}, // 20918K
			{0.255566771, 0.256418071}, // 20919K
			{0.255565852, 0.256416814}, // 20920K
			{0.255564932, 0.256415558}, // 20921K
			{0.255564013, 0.256414303}, // 20922K
			{0.255563094, 0.256413047}, // 20923K
			{0.255562174, 0.256411791}, // 20924K
			{0.255561255, 0.256410536}, // 20925K
			{0.255560336, 0.25640928}, // 20926K
			{0.255559417, 0.256408025}, // 20927K
			{0.255558499, 0.25640677}, // 20928K
			{0.25555758, 0.256405515}, // 20929K
			{0.255556661, 0.25640426}, // 20930K
			{0.255555743, 0.256403006}, // 20931K
			{0.255554825, 0.256401751}, // 20932K
			{0.255553906, 0.256400497}, // 20933K
			{0.255552988, 0.256399243}, // 20934K
			{0.25555207, 0.256397988}, // 20935K
			{0.255551152, 0.256396735}, // 20936K
			{0.255550234, 0.256395481}, // 20937K
			{0.255549317, 0.256394227}, // 20938K
			{0.255548399, 0.256392973}, // 20939K
			{0.255547482, 0.25639172}, // 20940K
			{0.255546564, 0.256390467}, // 20941K
			{0.255545647, 0.256389214}, // 20942K
			{0.25554473, 0.25638796}, // 20943K
			{0.255543813, 0.256386708}, // 20944K
			{0.255542896, 0.256385455}, // 20945K
			{0.255541979, 0.256384202}, // 20946K
			{0.255541062, 0.25638295}, // 20947K
			{0.255540145, 0.256381697}, // 20948K
			{0.255539229, 0.256380445}, // 20949K
			{0.255538312, 0.256379193}, // 20950K
			{0.255537396, 0.256377941}, // 20951K
			{0.255536479, 0.256376689}, // 20952K
			{0.255535563, 0.256375438}, // 20953K
			{0.255534647, 0.256374186}, // 20954K
			{0.255533731, 0.256372935}, // 20955K
			{0.255532815, 0.256371683}, // 20956K
			{0.2555319, 0.256370432}, // 20957K
			{0.255530984, 0.256369181}, // 20958K
			{0.255530068, 0.25636793}, // 20959K
			{0.255529153, 0.25636668}, // 20960K
			{0.255528238, 0.256365429}, // 20961K
			{0.255527322, 0.256364179}, // 20962K
			{0.255526407, 0.256362928}, // 20963K
			{0.255525492, 0.256361678}, // 20964K
			{0.255524577, 0.256360428}, // 20965K
			{0.255523662, 0.256359178}, // 20966K
			{0.255522748, 0.256357928}, // 20967K
			{0.255521833, 0.256356679}, // 20968K
			{0.255520919, 0.256355429}, // 20969K
			{0.255520004, 0.25635418}, // 20970K
			{0.25551909, 0.256352931}, // 20971K
			{0.255518176, 0.256351681}, // 20972K
			{0.255517261, 0.256350432}, // 20973K
			{0.255516347, 0.256349184}, // 20974K
			{0.255515434, 0.256347935}, // 20975K
			{0.25551452, 0.256346686}, // 20976K
			{0.255513606, 0.256345438}, // 20977K
			{0.255512693, 0.25634419}, // 20978K
			{0.255511779, 0.256342941}, // 20979K
			{0.255510866, 0.256341693}, // 20980K
			{0.255509952, 0.256340445}, // 20981K
			{0.255509039, 0.256339198}, // 20982K
			{0.255508126, 0.25633795}, // 20983K
			{0.255507213, 0.256336703}, // 20984K
			{0.2555063, 0.256335455}, // 20985K
			{0.255505388, 0.256334208}, // 20986K
			{0.255504475, 0.256332961}, // 20987K
			{0.255503562, 0.256331714}, // 20988K
			{0.25550265, 0.256330467}, // 20989K
			{0.255501737, 0.25632922}, // 20990K
			{0.255500825, 0.256327974}, // 20991K
			{0.255499913, 0.256326727}, // 20992K
			{0.255499001, 0.256325481}, // 20993K
			{0.255498089, 0.256324235}, // 20994K
			{0.255497177, 0.256322989}, // 20995K
			{0.255496266, 0.256321743}, // 20996K
			{0.255495354, 0.256320497}, // 20997K
			{0.255494442, 0.256319252}, // 20998K
			{0.255493531, 0.256318006}, // 20999K
			{0.25549262, 0.256316761}, // 21000K
			{0.255491708, 0.256315516}, // 21001K
			{0.255490797, 0.25631427}, // 21002K
			{0.255489886, 0.256313026}, // 21003K
			{0.255488975, 0.256311781}, // 21004K
			{0.255488065, 0.256310536}, // 21005K
			{0.255487154, 0.256309291}, // 21006K
			{0.255486243, 0.256308047}, // 21007K
			{0.255485333, 0.256306803}, // 21008K
			{0.255484422, 0.256305559}, // 21009K
			{0.255483512, 0.256304315}, // 21010K
			{0.255482602, 0.256303071}, // 21011K
			{0.255481692, 0.256301827}, // 21012K
			{0.255480782, 0.256300583}, // 21013K
			{0.255479872, 0.25629934}, // 21014K
			{0.255478962, 0.256298097}, // 21015K
			{0.255478052, 0.256296853}, // 21016K
			{0.255477143, 0.25629561}, // 21017K
			{0.255476233, 0.256294367}, // 21018K
			{0.255475324, 0.256293125}, // 21019K
			{0.255474415, 0.256291882}, // 21020K
			{0.255473506, 0.256290639}, // 21021K
			{0.255472597, 0.256289397}, // 21022K
			{0.255471688, 0.256288155}, // 21023K
			{0.255470779, 0.256286912}, // 21024K
			{0.25546987, 0.25628567}, // 21025K
			{0.255468961, 0.256284429}, // 21026K
			{0.255468053, 0.256283187}, // 21027K
			{0.255467144, 0.256281945}, // 21028K
			{0.255466236, 0.256280704}, // 21029K
			{0.255465328, 0.256279462}, // 21030K
			{0.25546442, 0.256278221}, // 21031K
			{0.255463512, 0.25627698}, // 21032K
			{0.255462604, 0.256275739}, // 21033K
			{0.255461696, 0.256274498}, // 21034K
			{0.255460788, 0.256273258}, // 21035K
			{0.25545988, 0.256272017}, // 21036K
			{0.255458973, 0.256270777}, // 21037K
			{0.255458065, 0.256269537}, // 21038K
			{0.255457158, 0.256268296}, // 21039K
			{0.255456251, 0.256267056}, // 21040K
			{0.255455344, 0.256265816}, // 21041K
			{0.255454437, 0.256264577}, // 21042K
			{0.25545353, 0.256263337}, // 21043K
			{0.255452623, 0.256262098}, // 21044K
			{0.255451716, 0.256260858}, // 21045K
			{0.25545081, 0.256259619}, // 21046K
			{0.255449903, 0.25625838}, // 21047K
			{0.255448997, 0.256257141}, // 21048K
			{0.255448091, 0.256255902}, // 21049K
			{0.255447184, 0.256254664}, // 21050K
			{0.255446278, 0.256253425}, // 21051K
			{0.255445372, 0.256252187}, // 21052K
			{0.255444466, 0.256250948}, // 21053K
			{0.255443561, 0.25624971}, // 21054K
			{0.255442655, 0.256248472}, // 21055K
			{0.255441749, 0.256247234}, // 21056K
			{0.255440844, 0.256245997}, // 21057K
			{0.255439938, 0.256244759}, // 21058K
			{0.255439033, 0.256243522}, // 21059K
			{0.255438128, 0.256242284}, // 21060K
			{0.255437223, 0.256241047}, // 21061K
			{0.255436318, 0.25623981}, // 21062K
			{0.255435413, 0.256238573}, // 21063K
			{0.255434508, 0.256237336}, // 21064K
			{0.255433604, 0.256236099}, // 21065K
			{0.255432699, 0.256234863}, // 21066K
			{0.255431794, 0.256233626}, // 21067K
			{0.25543089, 0.25623239}, // 21068K
			{0.255429986, 0.256231154}, // 21069K
			{0.255429082, 0.256229918}, // 21070K
			{0.255428178, 0.256228682}, // 21071K
			{0.255427274, 0.256227446}, // 21072K
			{0.25542637, 0.256226211}, // 21073K
			{0.255425466, 0.256224975}, // 21074K
			{0.255424562, 0.25622374}, // 21075K
			{0.255423659, 0.256222505}, // 21076K
			{0.255422755, 0.25622127}, // 21077K
			{0.255421852, 0.256220035}, // 21078K
			{0.255420949, 0.2562188}, // 21079K
			{0.255420046, 0.256217565}, // 21080K
			{0.255419143, 0.256216331}, // 21081K
			{0.25541824, 0.256215096}, // 21082K
			{0.255417337, 0.256213862}, // 21083K
			{0.255416434, 0.256212628}, // 21084K
			{0.255415531, 0.256211394}, // 21085K
			{0.255414629, 0.25621016}, // 21086K
			{0.255413726, 0.256208926}, // 21087K
			{0.255412824, 0.256207692}, // 21088K
			{0.255411922, 0.256206459}, // 21089K
			{0.25541102, 0.256205225}, // 21090K
			{0.255410118, 0.256203992}, // 21091K
			{0.255409216, 0.256202759}, // 21092K
			{0.255408314, 0.256201526}, // 21093K
			{0.255407412, 0.256200293}, // 21094K
			{0.255406511, 0.256199061}, // 21095K
			{0.255405609, 0.256197828}, // 21096K
			{0.255404708, 0.256196596}, // 21097K
			{0.255403806, 0.256195363}, // 21098K
			{0.255402905, 0.256194131}, // 21099K
			{0.255402004, 0.256192899}, // 21100K
			{0.255401103, 0.256191667}, // 21101K
			{0.255400202, 0.256190435}, // 21102K
			{0.255399301, 0.256189204}, // 21103K
			{0.255398401, 0.256187972}, // 21104K
			{0.2553975, 0.256186741}, // 21105K
			{0.255396599, 0.256185509}, // 21106K
			{0.255395699, 0.256184278}, // 21107K
			{0.255394799, 0.256183047}, // 21108K
			{0.255393898, 0.256181816}, // 21109K
			{0.255392998, 0.256180586}, // 21110K
			{0.255392098, 0.256179355}, // 21111K
			{0.255391198, 0.256178125}, // 21112K
			{0.255390299, 0.256176894}, // 21113K
			{0.255389399, 0.256175664}, // 21114K
			{0.255388499, 0.256174434}, // 21115K
			{0.2553876, 0.256173204}, // 21116K
			{0.2553867, 0.256171974}, // 21117K
			{0.255385801, 0.256170745}, // 21118K
			{0.255384902, 0.256169515}, // 21119K
			{0.255384003, 0.256168286}, // 21120K
			{0.255383104, 0.256167056}, // 21121K
			{0.255382205, 0.256165827}, // 21122K
			{0.255381306, 0.256164598}, // 21123K
			{0.255380407, 0.256163369}, // 21124K
			{0.255379509, 0.256162141}, // 21125K
			{0.25537861, 0.256160912}, // 21126K
			{0.255377712, 0.256159683}, // 21127K
			{0.255376814, 0.256158455}, // 21128K
			{0.255375915, 0.256157227}, // 21129K
			{0.255375017, 0.256155999}, // 21130K
			{0.255374119, 0.256154771}, // 21131K
			{0.255373221, 0.256153543}, // 21132K
			{0.255372324, 0.256152315}, // 21133K
			{0.255371426, 0.256151088}, // 21134K
			{0.255370528, 0.25614986}, // 21135K
			{0.255369631, 0.256148633}, // 21136K
			{0.255368733, 0.256147406}, // 21137K
			{0.255367836, 0.256146179}, // 21138K
			{0.255366939, 0.256144952}, // 21139K
			{0.255366042, 0.256143725}, // 21140K
			{0.255365145, 0.256142498}, // 21141K
			{0.255364248, 0.256141272}, // 21142K
			{0.255363351, 0.256140045}, // 21143K
			{0.255362455, 0.256138819}, // 21144K
			{0.255361558, 0.256137593}, // 21145K
			{0.255360661, 0.256136367}, // 21146K
			{0.255359765, 0.256135141}, // 21147K
			{0.255358869, 0.256133915}, // 21148K
			{0.255357973, 0.25613269}, // 21149K
			{0.255357077, 0.256131464}, // 21150K
			{0.255356181, 0.256130239}, // 21151K
			{0.255355285, 0.256129014}, // 21152K
			{0.255354389, 0.256127789}, // 21153K
			{0.255353493, 0.256126564}, // 21154K
			{0.255352598, 0.256125339}, // 21155K
			{0.255351702, 0.256124114}, // 21156K
			{0.255350807, 0.25612289}, // 21157K
			{0.255349911, 0.256121665}, // 21158K
			{0.255349016, 0.256120441}, // 21159K
			{0.255348121, 0.256119217}, // 21160K
			{0.255347226, 0.256117993}, // 21161K
			{0.255346331, 0.256116769}, // 21162K
			{0.255345437, 0.256115545}, // 21163K
			{0.255344542, 0.256114321}, // 21164K
			{0.255343647, 0.256113098}, // 21165K
			{0.255342753, 0.256111874}, // 21166K
			{0.255341858, 0.256110651}, // 21167K
			{0.255340964, 0.256109428}, // 21168K
			{0.25534007, 0.256108205}, // 21169K
			{0.255339176, 0.256106982}, // 21170K
			{0.255338282, 0.25610576}, // 21171K
			{0.255337388, 0.256104537}, // 21172K
			{0.255336494, 0.256103314}, // 21173K
			{0.255335601, 0.256102092}, // 21174K
			{0.255334707, 0.25610087}, // 21175K
			{0.255333814, 0.256099648}, // 21176K
			{0.25533292, 0.256098426}, // 21177K
			{0.255332027, 0.256097204}, // 21178K
			{0.255331134, 0.256095982}, // 21179K
			{0.255330241, 0.256094761}, // 21180K
			{0.255329348, 0.256093539}, // 21181K
			{0.255328455, 0.256092318}, // 21182K
			{0.255327562, 0.256091097}, // 21183K
			{0.255326669, 0.256089876}, // 21184K
			{0.255325777, 0.256088655}, // 21185K
			{0.255324884, 0.256087434}, // 21186K
			{0.255323992, 0.256086214}, // 21187K
			{0.2553231, 0.256084993}, // 21188K
			{0.255322207, 0.256083773}, // 21189K
			{0.255321315, 0.256082552}, // 21190K
			{0.255320423, 0.256081332}, // 21191K
			{0.255319531, 0.256080112}, // 21192K
			{0.25531864, 0.256078892}, // 21193K
			{0.255317748, 0.256077673}, // 21194K
			{0.255316856, 0.256076453}, // 21195K
			{0.255315965, 0.256075234}, // 21196K
			{0.255315074, 0.256074014}, // 21197K
			{0.255314182, 0.256072795}, // 21198K
			{0.255313291, 0.256071576}, // 21199K
			{0.2553124, 0.256070357}, // 21200K
			{0.255311509, 0.256069138}, // 21201K
			{0.255310618, 0.256067919}, // 21202K
			{0.255309727, 0.256066701}, // 21203K
			{0.255308837, 0.256065483}, // 21204K
			{0.255307946, 0.256064264}, // 21205K
			{0.255307056, 0.256063046}, // 21206K
			{0.255306165, 0.256061828}, // 21207K
			{0.255305275, 0.25606061}, // 21208K
			{0.255304385, 0.256059392}, // 21209K
			{0.255303495, 0.256058175}, // 21210K
			{0.255302605, 0.256056957}, // 21211K
			{0.255301715, 0.25605574}, // 21212K
			{0.255300825, 0.256054522}, // 21213K
			{0.255299935, 0.256053305}, // 21214K
			{0.255299046, 0.256052088}, // 21215K
			{0.255298156, 0.256050871}, // 21216K
			{0.255297267, 0.256049655}, // 21217K
			{0.255296377, 0.256048438}, // 21218K
			{0.255295488, 0.256047222}, // 21219K
			{0.255294599, 0.256046005}, // 21220K
			{0.25529371, 0.256044789}, // 21221K
			{0.255292821, 0.256043573}, // 21222K
			{0.255291932, 0.256042357}, // 21223K
			{0.255291044, 0.256041141}, // 21224K
			{0.255290155, 0.256039925}, // 21225K
			{0.255289267, 0.25603871}, // 21226K
			{0.255288378, 0.256037494}, // 21227K
			{0.25528749, 0.256036279}, // 21228K
			{0.255286602, 0.256035064}, // 21229K
			{0.255285714, 0.256033849}, // 21230K
			{0.255284826, 0.256032634}, // 21231K
			{0.255283938, 0.256031419}, // 21232K
			{0.25528305, 0.256030204}, // 21233K
			{0.255282162, 0.25602899}, // 21234K
			{0.255281274, 0.256027775}, // 21235K
			{0.255280387, 0.256026561}, // 21236K
			{0.2552795, 0.256025347}, // 21237K
			{0.255278612, 0.256024133}, // 21238K
			{0.255277725, 0.256022919}, // 21239K
			{0.255276838, 0.256021705}, // 21240K
			{0.255275951, 0.256020492}, // 21241K
			{0.255275064, 0.256019278}, // 21242K
			{0.255274177, 0.256018065}, // 21243K
			{0.25527329, 0.256016851}, // 21244K
			{0.255272404, 0.256015638}, // 21245K
			{0.255271517, 0.256014425}, // 21246K
			{0.255270631, 0.256013212}, // 21247K
			{0.255269745, 0.256012}, // 21248K
			{0.255268858, 0.256010787}, // 21249K
			{0.255267972, 0.256009575}, // 21250K
			{0.255267086, 0.256008362}, // 21251K
			{0.2552662, 0.25600715}, // 21252K
			{0.255265314, 0.256005938}, // 21253K
			{0.255264429, 0.256004726}, // 21254K
			{0.255263543, 0.256003514}, // 21255K
			{0.255262657, 0.256002302}, // 21256K
			{0.255261772, 0.256001091}, // 21257K
			{0.255260887, 0.255999879}, // 21258K
			{0.255260001, 0.255998668}, // 21259K
			{0.255259116, 0.255997457}, // 21260K
			{0.255258231, 0.255996246}, // 21261K
			{0.255257346, 0.255995035}, // 21262K
			{0.255256461, 0.255993824}, // 21263K
			{0.255255577, 0.255992613}, // 21264K
			{0.255254692, 0.255991403}, // 21265K
			{0.255253807, 0.255990192}, // 21266K
			{0.255252923, 0.255988982}, // 21267K
			{0.255252039, 0.255987772}, // 21268K
			{0.255251154, 0.255986562}, // 21269K
			{0.25525027, 0.255985352}, // 21270K
			{0.255249386, 0.255984142}, // 21271K
			{0.255248502, 0.255982933}, // 21272K
			{0.255247618, 0.255981723}, // 21273K
			{0.255246735, 0.255980514}, // 21274K
			{0.255245851, 0.255979304}, // 21275K
			{0.255244967, 0.255978095}, // 21276K
			{0.255244084, 0.255976886}, // 21277K
			{0.255243201, 0.255975677}, // 21278K
			{0.255242317, 0.255974469}, // 21279K
			{0.255241434, 0.25597326}, // 21280K
			{0.255240551, 0.255972052}, // 21281K
			{0.255239668, 0.255970843}, // 21282K
			{0.255238785, 0.255969635}, // 21283K
			{0.255237902, 0.255968427}, // 21284K
			{0.25523702, 0.255967219}, // 21285K
			{0.255236137, 0.255966011}, // 21286K
			{0.255235255, 0.255964803}, // 21287K
			{0.255234372, 0.255963596}, // 21288K
			{0.25523349, 0.255962388}, // 21289K
			{0.255232608, 0.255961181}, // 21290K
			{0.255231726, 0.255959974}, // 21291K
			{0.255230844, 0.255958767}, // 21292K
			{0.255229962, 0.25595756}, // 21293K
			{0.25522908, 0.255956353}, // 21294K
			{0.255228198, 0.255955146}, // 21295K
			{0.255227317, 0.25595394}, // 21296K
			{0.255226435, 0.255952733}, // 21297K
			{0.255225554, 0.255951527}, // 21298K
			{0.255224672, 0.255950321}, // 21299K
			{0.255223791, 0.255949115}, // 21300K
			{0.25522291, 0.255947909}, // 21301K
			{0.255222029, 0.255946703}, // 21302K
			{0.255221148, 0.255945497}, // 21303K
			{0.255220267, 0.255944292}, // 21304K
			{0.255219387, 0.255943086}, // 21305K
			{0.255218506, 0.255941881}, // 21306K
			{0.255217625, 0.255940676}, // 21307K
			{0.255216745, 0.255939471}, // 21308K
			{0.255215865, 0.255938266}, // 21309K
			{0.255214984, 0.255937061}, // 21310K
			{0.255214104, 0.255935856}, // 21311K
			{0.255213224, 0.255934652}, // 21312K
			{0.255212344, 0.255933447}, // 21313K
			{0.255211464, 0.255932243}, // 21314K
			{0.255210585, 0.255931039}, // 21315K
			{0.255209705, 0.255929835}, // 21316K
			{0.255208825, 0.255928631}, // 21317K
			{0.255207946, 0.255927427}, // 21318K
			{0.255207067, 0.255926224}, // 21319K
			{0.255206187, 0.25592502}, // 21320K
			{0.255205308, 0.255923817}, // 21321K
			{0.255204429, 0.255922614}, // 21322K
			{0.25520355, 0.25592141}, // 21323K
			{0.255202671, 0.255920207}, // 21324K
			{0.255201793, 0.255919005}, // 21325K
			{0.255200914, 0.255917802}, // 21326K
			{0.255200035, 0.255916599}, // 21327K
			{0.255199157, 0.255915397}, // 21328K
			{0.255198278, 0.255914194}, // 21329K
			{0.2551974, 0.255912992}, // 21330K
			{0.255196522, 0.25591179}, // 21331K
			{0.255195644, 0.255910588}, // 21332K
			{0.255194766, 0.255909386}, // 21333K
			{0.255193888, 0.255908185}, // 21334K
			{0.25519301, 0.255906983}, // 21335K
			{0.255192132, 0.255905781}, // 21336K
			{0.255191255, 0.25590458}, // 21337K
			{0.255190377, 0.255903379}, // 21338K
			{0.2551895, 0.255902178}, // 21339K
			{0.255188623, 0.255900977}, // 21340K
			{0.255187745, 0.255899776}, // 21341K
			{0.255186868, 0.255898575}, // 21342K
			{0.255185991, 0.255897375}, // 21343K
			{0.255185114, 0.255896174}, // 21344K
			{0.255184238, 0.255894974}, // 21345K
			{0.255183361, 0.255893774}, // 21346K
			{0.255182484, 0.255892574}, // 21347K
			{0.255181608, 0.255891374}, // 21348K
			{0.255180731, 0.255890174}, // 21349K
			{0.255179855, 0.255888974}, // 21350K
			{0.255178979, 0.255887775}, // 21351K
			{0.255178103, 0.255886575}, // 21352K
			{0.255177226, 0.255885376}, // 21353K
			{0.255176351, 0.255884177}, // 21354K
			{0.255175475, 0.255882978}, // 21355K
			{0.255174599, 0.255881779}, // 21356K
			{0.255173723, 0.25588058}, // 21357K
			{0.255172848, 0.255879381}, // 21358K
			{0.255171972, 0.255878183}, // 21359K
			{0.255171097, 0.255876984}, // 21360K
			{0.255170222, 0.255875786}, // 21361K
			{0.255169346, 0.255874588}, // 21362K
			{0.255168471, 0.25587339}, // 21363K
			{0.255167596, 0.255872192}, // 21364K
			{0.255166721, 0.255870994}, // 21365K
			{0.255165847, 0.255869797}, // 21366K
			{0.255164972, 0.255868599}, // 21367K
			{0.255164097, 0.255867402}, // 21368K
			{0.255163223, 0.255866204}, // 21369K
			{0.255162348, 0.255865007}, // 21370K
			{0.255161474, 0.25586381}, // 21371K
			{0.2551606, 0.255862613}, // 21372K
			{0.255159726, 0.255861417}, // 21373K
			{0.255158852, 0.25586022}, // 21374K
			{0.255157978, 0.255859023}, // 21375K
			{0.255157104, 0.255857827}, // 21376K
			{0.25515623, 0.255856631}, // 21377K
			{0.255155357, 0.255855435}, // 21378K
			{0.255154483, 0.255854239}, // 21379K
			{0.25515361, 0.255853043}, // 21380K
			{0.255152736, 0.255851847}, // 21381K
			{0.255151863, 0.255850651}, // 21382K
			{0.25515099, 0.255849456}, // 21383K
			{0.255150117, 0.25584826}, // 21384K
			{0.255149244, 0.255847065}, // 21385K
			{0.255148371, 0.25584587}, // 21386K
			{0.255147499, 0.255844675}, // 21387K
			{0.255146626, 0.25584348}, // 21388K
			{0.255145753, 0.255842285}, // 21389K
			{0.255144881, 0.255841091}, // 21390K
			{0.255144008, 0.255839896}, // 21391K
			{0.255143136, 0.255838702}, // 21392K
			{0.255142264, 0.255837508}, // 21393K
			{0.255141392, 0.255836314}, // 21394K
			{0.25514052, 0.25583512}, // 21395K
			{0.255139648, 0.255833926}, // 21396K
			{0.255138776, 0.255832732}, // 21397K
			{0.255137905, 0.255831538}, // 21398K
			{0.255137033, 0.255830345}, // 21399K
			{0.255136161, 0.255829152}, // 21400K
			{0.25513529, 0.255827958}, // 21401K
			{0.255134419, 0.255826765}, // 21402K
			{0.255133548, 0.255825572}, // 21403K
			{0.255132676, 0.255824379}, // 21404K
			{0.255131805, 0.255823187}, // 21405K
			{0.255130934, 0.255821994}, // 21406K
			{0.255130064, 0.255820802}, // 21407K
			{0.255129193, 0.255819609}, // 21408K
			{0.255128322, 0.255818417}, // 21409K
			{0.255127452, 0.255817225}, // 21410K
			{0.255126581, 0.255816033}, // 21411K
			{0.255125711, 0.255814841}, // 21412K
			{0.255124841, 0.255813649}, // 21413K
			{0.255123971, 0.255812458}, // 21414K
			{0.2551231, 0.255811266}, // 21415K
			{0.255122231, 0.255810075}, // 21416K
			{0.255121361, 0.255808884}, // 21417K
			{0.255120491, 0.255807693}, // 21418K
			{0.255119621, 0.255806502}, // 21419K
			{0.255118752, 0.255805311}, // 21420K
			{0.255117882, 0.25580412}, // 21421K
			{0.255117013, 0.255802929}, // 21422K
			{0.255116143, 0.255801739}, // 21423K
			{0.255115274, 0.255800549}, // 21424K
			{0.255114405, 0.255799358}, // 21425K
			{0.255113536, 0.255798168}, // 21426K
			{0.255112667, 0.255796978}, // 21427K
			{0.255111798, 0.255795788}, // 21428K
			{0.25511093, 0.255794599}, // 21429K
			{0.255110061, 0.255793409}, // 21430K
			{0.255109193, 0.25579222}, // 21431K
			{0.255108324, 0.25579103}, // 21432K
			{0.255107456, 0.255789841}, // 21433K
			{0.255106588, 0.255788652}, // 21434K
			{0.255105719, 0.255787463}, // 21435K
			{0.255104851, 0.255786274}, // 21436K
			{0.255103983, 0.255785086}, // 21437K
			{0.255103116, 0.255783897}, // 21438K
			{0.255102248, 0.255782709}, // 21439K
			{0.25510138, 0.25578152}, // 21440K
			{0.255100513, 0.255780332}, // 21441K
			{0.255099645, 0.255779144}, // 21442K
			{0.255098778, 0.255777956}, // 21443K
			{0.255097911, 0.255776768}, // 21444K
			{0.255097043, 0.25577558}, // 21445K
			{0.255096176, 0.255774393}, // 21446K
			{0.255095309, 0.255773205}, // 21447K
			{0.255094442, 0.255772018}, // 21448K
			{0.255093576, 0.255770831}, // 21449K
			{0.255092709, 0.255769644}, // 21450K
			{0.255091842, 0.255768457}, // 21451K
			{0.255090976, 0.25576727}, // 21452K
			{0.255090109, 0.255766083}, // 21453K
			{0.255089243, 0.255764897}, // 21454K
			{0.255088377, 0.25576371}, // 21455K
			{0.255087511, 0.255762524}, // 21456K
			{0.255086645, 0.255761338}, // 21457K
			{0.255085779, 0.255760152}, // 21458K
			{0.255084913, 0.255758966}, // 21459K
			{0.255084047, 0.25575778}, // 21460K
			{0.255083181, 0.255756594}, // 21461K
			{0.255082316, 0.255755408}, // 21462K
			{0.25508145, 0.255754223}, // 21463K
			{0.255080585, 0.255753038}, // 21464K
			{0.25507972, 0.255751852}, // 21465K
			{0.255078855, 0.255750667}, // 21466K
			{0.25507799, 0.255749482}, // 21467K
			{0.255077125, 0.255748298}, // 21468K
			{0.25507626, 0.255747113}, // 21469K
			{0.255075395, 0.255745928}, // 21470K
			{0.25507453, 0.255744744}, // 21471K
			{0.255073666, 0.255743559}, // 21472K
			{0.255072801, 0.255742375}, // 21473K
			{0.255071937, 0.255741191}, // 21474K
			{0.255071072, 0.255740007}, // 21475K
			{0.255070208, 0.255738823}, // 21476K
			{0.255069344, 0.25573764}, // 21477K
			{0.25506848, 0.255736456}, // 21478K
			{0.255067616, 0.255735273}, // 21479K
			{0.255066752, 0.255734089}, // 21480K
			{0.255065888, 0.255732906}, // 21481K
			{0.255065025, 0.255731723}, // 21482K
			{0.255064161, 0.25573054}, // 21483K
			{0.255063298, 0.255729357}, // 21484K
			{0.255062434, 0.255728174}, // 21485K
			{0.255061571, 0.255726992}, // 21486K
			{0.255060708, 0.255725809}, // 21487K
			{0.255059845, 0.255724627}, // 21488K
			{0.255058982, 0.255723445}, // 21489K
			{0.255058119, 0.255722263}, // 21490K
			{0.255057256, 0.255721081}, // 21491K
			{0.255056393, 0.255719899}, // 21492K
			{0.255055531, 0.255718717}, // 21493K
			{0.255054668, 0.255717535}, // 21494K
			{0.255053806, 0.255716354}, // 21495K
			{0.255052944, 0.255715173}, // 21496K
			{0.255052081, 0.255713991}, // 21497K
			{0.255051219, 0.25571281}, // 21498K
			{0.255050357, 0.255711629}, // 21499K
			{0.255049495, 0.255710448}, // 21500K
			{0.255048633, 0.255709268}, // 21501K
			{0.255047772, 0.255708087}, // 21502K
			{0.25504691, 0.255706907}, // 21503K
			{0.255046048, 0.255705726}, // 21504K
			{0.255045187, 0.255704546}, // 21505K
			{0.255044326, 0.255703366}, // 21506K
			{0.255043464, 0.255702186}, // 21507K
			{0.255042603, 0.255701006}, // 21508K
			{0.255041742, 0.255699826}, // 21509K
			{0.255040881, 0.255698647}, // 21510K
			{0.25504002, 0.255697467}, // 21511K
			{0.255039159, 0.255696288}, // 21512K
			{0.255038299, 0.255695109}, // 21513K
			{0.255037438, 0.25569393}, // 21514K
			{0.255036577, 0.255692751}, // 21515K
			{0.255035717, 0.255691572}, // 21516K
			{0.255034857, 0.255690393}, // 21517K
			{0.255033996, 0.255689214}, // 21518K
			{0.255033136, 0.255688036}, // 21519K
			{0.255032276, 0.255686857}, // 21520K
			{0.255031416, 0.255685679}, // 21521K
			{0.255030556, 0.255684501}, // 21522K
			{0.255029697, 0.255683323}, // 21523K
			{0.255028837, 0.255682145}, // 21524K
			{0.255027977, 0.255680967}, // 21525K
			{0.255027118, 0.25567979}, // 21526K
			{0.255026259, 0.255678612}, // 21527K
			{0.255025399, 0.255677435}, // 21528K
			{0.25502454, 0.255676258}, // 21529K
			{0.255023681, 0.25567508}, // 21530K
			{0.255022822, 0.255673903}, // 21531K
			{0.255021963, 0.255672726}, // 21532K
			{0.255021104, 0.25567155}, // 21533K
			{0.255020245, 0.255670373}, // 21534K
			{0.255019387, 0.255669197}, // 21535K
			{0.255018528, 0.25566802}, // 21536K
			{0.25501767, 0.255666844}, // 21537K
			{0.255016811, 0.255665668}, // 21538K
			{0.255015953, 0.255664492}, // 21539K
			{0.255015095, 0.255663316}, // 21540K
			{0.255014237, 0.25566214}, // 21541K
			{0.255013379, 0.255660964}, // 21542K
			{0.255012521, 0.255659789}, // 21543K
			{0.255011663, 0.255658613}, // 21544K
			{0.255010806, 0.255657438}, // 21545K
			{0.255009948, 0.255656263}, // 21546K
			{0.255009091, 0.255655088}, // 21547K
			{0.255008233, 0.255653913}, // 21548K
			{0.255007376, 0.255652738}, // 21549K
			{0.255006519, 0.255651563}, // 21550K
			{0.255005661, 0.255650389}, // 21551K
			{0.255004804, 0.255649214}, // 21552K
			{0.255003947, 0.25564804}, // 21553K
			{0.255003091, 0.255646866}, // 21554K
			{0.255002234, 0.255645692}, // 21555K
			{0.255001377, 0.255644518}, // 21556K
			{0.255000521, 0.255643344}, // 21557K
			{0.254999664, 0.25564217}, // 21558K
			{0.254998808, 0.255640997}, // 21559K
			{0.254997952, 0.255639823}, // 21560K
			{0.254997095, 0.25563865}, // 21561K
			{0.254996239, 0.255637477}, // 21562K
			{0.254995383, 0.255636304}, // 21563K
			{0.254994527, 0.255635131}, // 21564K
			{0.254993671, 0.255633958}, // 21565K
			{0.254992816, 0.255632785}, // 21566K
			{0.25499196, 0.255631613}, // 21567K
			{0.254991105, 0.25563044}, // 21568K
			{0.254990249, 0.255629268}, // 21569K
			{0.254989394, 0.255628096}, // 21570K
			{0.254988539, 0.255626924}, // 21571K
			{0.254987683, 0.255625752}, // 21572K
			{0.254986828, 0.25562458}, // 21573K
			{0.254985973, 0.255623408}, // 21574K
			{0.254985119, 0.255622237}, // 21575K
			{0.254984264, 0.255621065}, // 21576K
			{0.254983409, 0.255619894}, // 21577K
			{0.254982554, 0.255618722}, // 21578K
			{0.2549817, 0.255617551}, // 21579K
			{0.254980846, 0.25561638}, // 21580K
			{0.254979991, 0.255615209}, // 21581K
			{0.254979137, 0.255614039}, // 21582K
			{0.254978283, 0.255612868}, // 21583K
			{0.254977429, 0.255611698}, // 21584K
			{0.254976575, 0.255610527}, // 21585K
			{0.254975721, 0.255609357}, // 21586K
			{0.254974867, 0.255608187}, // 21587K
			{0.254974014, 0.255607017}, // 21588K
			{0.25497316, 0.255605847}, // 21589K
			{0.254972307, 0.255604677}, // 21590K
			{0.254971453, 0.255603508}, // 21591K
			{0.2549706, 0.255602338}, // 21592K
			{0.254969747, 0.255601169}, // 21593K
			{0.254968894, 0.255599999}, // 21594K
			{0.254968041, 0.25559883}, // 21595K
			{0.254967188, 0.255597661}, // 21596K
			{0.254966335, 0.255596492}, // 21597K
			{0.254965482, 0.255595323}, // 21598K
			{0.25496463, 0.255594155}, // 21599K
			{0.254963777, 0.255592986}, // 21600K
			{0.254962925, 0.255591818}, // 21601K
			{0.254962072, 0.25559065}, // 21602K
			{0.25496122, 0.255589481}, // 21603K
			{0.254960368, 0.255588313}, // 21604K
			{0.254959516, 0.255587145}, // 21605K
			{0.254958664, 0.255585978}, // 21606K
			{0.254957812, 0.25558481}, // 21607K
			{0.25495696, 0.255583642}, // 21608K
			{0.254956108, 0.255582475}, // 21609K
			{0.254955257, 0.255581308}, // 21610K
			{0.254954405, 0.25558014}, // 21611K
			{0.254953554, 0.255578973}, // 21612K
			{0.254952702, 0.255577806}, // 21613K
			{0.254951851, 0.25557664}, // 21614K
			{0.254951, 0.255575473}, // 21615K
			{0.254950149, 0.255574306}, // 21616K
			{0.254949298, 0.25557314}, // 21617K
			{0.254948447, 0.255571973}, // 21618K
			{0.254947596, 0.255570807}, // 21619K
			{0.254946746, 0.255569641}, // 21620K
			{0.254945895, 0.255568475}, // 21621K
			{0.254945045, 0.255567309}, // 21622K
			{0.254944194, 0.255566143}, // 21623K
			{0.254943344, 0.255564978}, // 21624K
			{0.254942494, 0.255563812}, // 21625K
			{0.254941644, 0.255562647}, // 21626K
			{0.254940794, 0.255561482}, // 21627K
			{0.254939944, 0.255560317}, // 21628K
			{0.254939094, 0.255559152}, // 21629K
			{0.254938244, 0.255557987}, // 21630K
			{0.254937394, 0.255556822}, // 21631K
			{0.254936545, 0.255555657}, // 21632K
			{0.254935695, 0.255554493}, // 21633K
			{0.254934846, 0.255553328}, // 21634K
			{0.254933997, 0.255552164}, // 21635K
			{0.254933148, 0.255551}, // 21636K
			{0.254932299, 0.255549836}, // 21637K
			{0.25493145, 0.255548672}, // 21638K
			{0.254930601, 0.255547508}, // 21639K
			{0.254929752, 0.255546345}, // 21640K
			{0.254928903, 0.255545181}, // 21641K
			{0.254928054, 0.255544018}, // 21642K
			{0.254927206, 0.255542854}, // 21643K
			{0.254926357, 0.255541691}, // 21644K
			{0.254925509, 0.255540528}, // 21645K
			{0.254924661, 0.255539365}, // 21646K
			{0.254923813, 0.255538202}, // 21647K
			{0.254922965, 0.25553704}, // 21648K
			{0.254922117, 0.255535877}, // 21649K
			{0.254921269, 0.255534715}, // 21650K
			{0.254920421, 0.255533552}, // 21651K
			{0.254919573, 0.25553239}, // 21652K
			{0.254918726, 0.255531228}, // 21653K
			{0.254917878, 0.255530066}, // 21654K
			{0.254917031, 0.255528904}, // 21655K
			{0.254916183, 0.255527742}, // 21656K
			{0.254915336, 0.255526581}, // 21657K
			{0.254914489, 0.255525419}, // 21658K
			{0.254913642, 0.255524258}, // 21659K
			{0.254912795, 0.255523097}, // 21660K
			{0.254911948, 0.255521936}, // 21661K
			{0.254911101, 0.255520775}, // 21662K
			{0.254910254, 0.255519614}, // 21663K
			{0.254909408, 0.255518453}, // 21664K
			{0.254908561, 0.255517292}, // 21665K
			{0.254907715, 0.255516132}, // 21666K
			{0.254906869, 0.255514971}, // 21667K
			{0.254906022, 0.255513811}, // 21668K
			{0.254905176, 0.255512651}, // 21669K
			{0.25490433, 0.255511491}, // 21670K
			{0.254903484, 0.255510331}, // 21671K
			{0.254902638, 0.255509171}, // 21672K
			{0.254901793, 0.255508012}, // 21673K
			{0.254900947, 0.255506852}, // 21674K
			{0.254900101, 0.255505693}, // 21675K
			{0.254899256, 0.255504533}, // 21676K
			{0.254898411, 0.255503374}, // 21677K
			{0.254897565, 0.255502215}, // 21678K
			{0.25489672, 0.255501056}, // 21679K
			{0.254895875, 0.255499897}, // 21680K
			{0.25489503, 0.255498739}, // 21681K
			{0.254894185, 0.25549758}, // 21682K
			{0.25489334, 0.255496422}, // 21683K
			{0.254892495, 0.255495263}, // 21684K
			{0.254891651, 0.255494105}, // 21685K
			{0.254890806, 0.255492947}, // 21686K
			{0.254889962, 0.255491789}, // 21687K
			{0.254889117, 0.255490631}, // 21688K
			{0.254888273, 0.255489473}, // 21689K
			{0.254887429, 0.255488316}, // 21690K
			{0.254886585, 0.255487158}, // 21691K
			{0.254885741, 0.255486001}, // 21692K
			{0.254884897, 0.255484844}, // 21693K
			{0.254884053, 0.255483686}, // 21694K
			{0.254883209, 0.255482529}, // 21695K
			{0.254882365, 0.255481372}, // 21696K
			{0.254881522, 0.255480216}, // 21697K
			{0.254880678, 0.255479059}, // 21698K
			{0.254879835, 0.255477903}, // 21699K
			{0.254878992, 0.255476746}, // 21700K
			{0.254878149, 0.25547559}, // 21701K
			{0.254877305, 0.255474434}, // 21702K
			{0.254876462, 0.255473278}, // 21703K
			{0.25487562, 0.255472122}, // 21704K
			{0.254874777, 0.255470966}, // 21705K
			{0.254873934, 0.25546981}, // 21706K
			{0.254873091, 0.255468655}, // 21707K
			{0.254872249, 0.255467499}, // 21708K
			{0.254871406, 0.255466344}, // 21709K
			{0.254870564, 0.255465189}, // 21710K
			{0.254869722, 0.255464033}, // 21711K
			{0.254868879, 0.255462879}, // 21712K
			{0.254868037, 0.255461724}, // 21713K
			{0.254867195, 0.255460569}, // 21714K
			{0.254866353, 0.255459414}, // 21715K
			{0.254865512, 0.25545826}, // 21716K
			{0.25486467, 0.255457105}, // 21717K
			{0.254863828, 0.255455951}, // 21718K
			{0.254862987, 0.255454797}, // 21719K
			{0.254862145, 0.255453643}, // 21720K
			{0.254861304, 0.255452489}, // 21721K
			{0.254860463, 0.255451335}, // 21722K
			{0.254859622, 0.255450182}, // 21723K
			{0.25485878, 0.255449028}, // 21724K
			{0.254857939, 0.255447875}, // 21725K
			{0.254857099, 0.255446722}, // 21726K
			{0.254856258, 0.255445568}, // 21727K
			{0.254855417, 0.255444415}, // 21728K
			{0.254854576, 0.255443262}, // 21729K
			{0.254853736, 0.25544211}, // 21730K
			{0.254852895, 0.255440957}, // 21731K
			{0.254852055, 0.255439804}, // 21732K
			{0.254851215, 0.255438652}, // 21733K
			{0.254850375, 0.2554375}, // 21734K
			{0.254849535, 0.255436347}, // 21735K
			{0.254848695, 0.255435195}, // 21736K
			{0.254847855, 0.255434043}, // 21737K
			{0.254847015, 0.255432891}, // 21738K
			{0.254846175, 0.25543174}, // 21739K
			{0.254845336, 0.255430588}, // 21740K
			{0.254844496, 0.255429437}, // 21741K
			{0.254843657, 0.255428285}, // 21742K
			{0.254842817, 0.255427134}, // 21743K
			{0.254841978, 0.255425983}, // 21744K
			{0.254841139, 0.255424832}, // 21745K
			{0.2548403, 0.255423681}, // 21746K
			{0.254839461, 0.25542253}, // 21747K
			{0.254838622, 0.255421379}, // 21748K
			{0.254837783, 0.255420229}, // 21749K
			{0.254836944, 0.255419078}, // 21750K
			{0.254836106, 0.255417928}, // 21751K
			{0.254835267, 0.255416778}, // 21752K
			{0.254834429, 0.255415628}, // 21753K
			{0.25483359, 0.255414478}, // 21754K
			{0.254832752, 0.255413328}, // 21755K
			{0.254831914, 0.255412178}, // 21756K
			{0.254831076, 0.255411029}, // 21757K
			{0.254830238, 0.255409879}, // 21758K
			{0.2548294, 0.25540873}, // 21759K
			{0.254828562, 0.255407581}, // 21760K
			{0.254827725, 0.255406432}, // 21761K
			{0.254826887, 0.255405283}, // 21762K
			{0.254826049, 0.255404134}, // 21763K
			{0.254825212, 0.255402985}, // 21764K
			{0.254824375, 0.255401837}, // 21765K
			{0.254823537, 0.255400688}, // 21766K
			{0.2548227, 0.25539954}, // 21767K
			{0.254821863, 0.255398391}, // 21768K
			{0.254821026, 0.255397243}, // 21769K
			{0.254820189, 0.255396095}, // 21770K
			{0.254819352, 0.255394947}, // 21771K
			{0.254818516, 0.255393799}, // 21772K
			{0.254817679, 0.255392652}, // 21773K
			{0.254816843, 0.255391504}, // 21774K
			{0.254816006, 0.255390357}, // 21775K
			{0.25481517, 0.25538921}, // 21776K
			{0.254814334, 0.255388062}, // 21777K
			{0.254813497, 0.255386915}, // 21778K
			{0.254812661, 0.255385768}, // 21779K
			{0.254811825, 0.255384621}, // 21780K
			{0.254810989, 0.255383475}, // 21781K
			{0.254810154, 0.255382328}, // 21782K
			{0.254809318, 0.255381182}, // 21783K
			{0.254808482, 0.255380035}, // 21784K
			{0.254807647, 0.255378889}, // 21785K
			{0.254806811, 0.255377743}, // 21786K
			{0.254805976, 0.255376597}, // 21787K
			{0.254805141, 0.255375451}, // 21788K
			{0.254804306, 0.255374305}, // 21789K
			{0.25480347, 0.25537316}, // 21790K
			{0.254802635, 0.255372014}, // 21791K
			{0.254801801, 0.255370869}, // 21792K
			{0.254800966, 0.255369723}, // 21793K
			{0.254800131, 0.255368578}, // 21794K
			{0.254799296, 0.255367433}, // 21795K
			{0.254798462, 0.255366288}, // 21796K
			{0.254797627, 0.255365143}, // 21797K
			{0.254796793, 0.255363999}, // 21798K
			{0.254795959, 0.255362854}, // 21799K
			{0.254795125, 0.25536171}, // 21800K
			{0.254794291, 0.255360565}, // 21801K
			{0.254793457, 0.255359421}, // 21802K
			{0.254792623, 0.255358277}, // 21803K
			{0.254791789, 0.255357133}, // 21804K
			{0.254790955, 0.255355989}, // 21805K
			{0.254790122, 0.255354845}, // 21806K
			{0.254789288, 0.255353702}, // 21807K
			{0.254788455, 0.255352558}, // 21808K
			{0.254787621, 0.255351415}, // 21809K
			{0.254786788, 0.255350271}, // 21810K
			{0.254785955, 0.255349128}, // 21811K
			{0.254785122, 0.255347985}, // 21812K
			{0.254784289, 0.255346842}, // 21813K
			{0.254783456, 0.255345699}, // 21814K
			{0.254782623, 0.255344557}, // 21815K
			{0.25478179, 0.255343414}, // 21816K
			{0.254780958, 0.255342272}, // 21817K
			{0.254780125, 0.255341129}, // 21818K
			{0.254779292, 0.255339987}, // 21819K
			{0.25477846, 0.255338845}, // 21820K
			{0.254777628, 0.255337703}, // 21821K
			{0.254776796, 0.255336561}, // 21822K
			{0.254775964, 0.255335419}, // 21823K
			{0.254775132, 0.255334278}, // 21824K
			{0.2547743, 0.255333136}, // 21825K
			{0.254773468, 0.255331995}, // 21826K
			{0.254772636, 0.255330854}, // 21827K
			{0.254771804, 0.255329713}, // 21828K
			{0.254770973, 0.255328571}, // 21829K
			{0.254770141, 0.255327431}, // 21830K
			{0.25476931, 0.25532629}, // 21831K
			{0.254768479, 0.255325149}, // 21832K
			{0.254767648, 0.255324009}, // 21833K
			{0.254766816, 0.255322868}, // 21834K
			{0.254765985, 0.255321728}, // 21835K
			{0.254765154, 0.255320588}, // 21836K
			{0.254764324, 0.255319447}, // 21837K
			{0.254763493, 0.255318307}, // 21838K
			{0.254762662, 0.255317168}, // 21839K
			{0.254761832, 0.255316028}, // 21840K
			{0.254761001, 0.255314888}, // 21841K
			{0.254760171, 0.255313749}, // 21842K
			{0.25475934, 0.255312609}, // 21843K
			{0.25475851, 0.25531147}, // 21844K
			{0.25475768, 0.255310331}, // 21845K
			{0.25475685, 0.255309192}, // 21846K
			{0.25475602, 0.255308053}, // 21847K
			{0.25475519, 0.255306914}, // 21848K
			{0.254754361, 0.255305776}, // 21849K
			{0.254753531, 0.255304637}, // 21850K
			{0.254752701, 0.255303499}, // 21851K
			{0.254751872, 0.25530236}, // 21852K
			{0.254751042, 0.255301222}, // 21853K
			{0.254750213, 0.255300084}, // 21854K
			{0.254749384, 0.255298946}, // 21855K
			{0.254748555, 0.255297808}, // 21856K
			{0.254747726, 0.25529667}, // 21857K
			{0.254746897, 0.255295533}, // 21858K
			{0.254746068, 0.255294395}, // 21859K
			{0.254745239, 0.255293258}, // 21860K
			{0.25474441, 0.255292121}, // 21861K
			{0.254743582, 0.255290983}, // 21862K
			{0.254742753, 0.255289846}, // 21863K
			{0.254741925, 0.255288709}, // 21864K
			{0.254741097, 0.255287573}, // 21865K
			{0.254740268, 0.255286436}, // 21866K
			{0.25473944, 0.255285299}, // 21867K
			{0.254738612, 0.255284163}, // 21868K
			{0.254737784, 0.255283027}, // 21869K
			{0.254736956, 0.25528189}, // 21870K
			{0.254736128, 0.255280754}, // 21871K
			{0.254735301, 0.255279618}, // 21872K
			{0.254734473, 0.255278482}, // 21873K
			{0.254733646, 0.255277347}, // 21874K
			{0.254732818, 0.255276211}, // 21875K
			{0.254731991, 0.255275076}, // 21876K
			{0.254731164, 0.25527394}, // 21877K
			{0.254730336, 0.255272805}, // 21878K
			{0.254729509, 0.25527167}, // 21879K
			{0.254728682, 0.255270535}, // 21880K
			{0.254727855, 0.2552694}, // 21881K
			{0.254727029, 0.255268265}, // 21882K
			{0.254726202, 0.25526713}, // 21883K
			{0.254725375, 0.255265996}, // 21884K
			{0.254724549, 0.255264861}, // 21885K
			{0.254723722, 0.255263727}, // 21886K
			{0.254722896, 0.255262593}, // 21887K
			{0.25472207, 0.255261459}, // 21888K
			{0.254721243, 0.255260325}, // 21889K
			{0.254720417, 0.255259191}, // 21890K
			{0.254719591, 0.255258057}, // 21891K
			{0.254718765, 0.255256923}, // 21892K
			{0.25471794, 0.25525579}, // 21893K
			{0.254717114, 0.255254656}, // 21894K
			{0.254716288, 0.255253523}, // 21895K
			{0.254715463, 0.25525239}, // 21896K
			{0.254714637, 0.255251257}, // 21897K
			{0.254713812, 0.255250124}, // 21898K
			{0.254712986, 0.255248991}, // 21899K
			{0.254712161, 0.255247859}, // 21900K
			{0.254711336, 0.255246726}, // 21901K
			{0.254710511, 0.255245593}, // 21902K
			{0.254709686, 0.255244461}, // 21903K
			{0.254708861, 0.255243329}, // 21904K
			{0.254708037, 0.255242197}, // 21905K
			{0.254707212, 0.255241065}, // 21906K
			{0.254706387, 0.255239933}, // 21907K
			{0.254705563, 0.255238801}, // 21908K
			{0.254704738, 0.255237669}, // 21909K
			{0.254703914, 0.255236538}, // 21910K
			{0.25470309, 0.255235407}, // 21911K
			{0.254702266, 0.255234275}, // 21912K
			{0.254701442, 0.255233144}, // 21913K
			{0.254700618, 0.255232013}, // 21914K
			{0.254699794, 0.255230882}, // 21915K
			{0.25469897, 0.255229751}, // 21916K
			{0.254698146, 0.25522862}, // 21917K
			{0.254697323, 0.25522749}, // 21918K
			{0.254696499, 0.255226359}, // 21919K
			{0.254695676, 0.255225229}, // 21920K
			{0.254694852, 0.255224099}, // 21921K
			{0.254694029, 0.255222969}, // 21922K
			{0.254693206, 0.255221839}, // 21923K
			{0.254692383, 0.255220709}, // 21924K
			{0.25469156, 0.255219579}, // 21925K
			{0.254690737, 0.255218449}, // 21926K
			{0.254689914, 0.25521732}, // 21927K
			{0.254689092, 0.25521619}, // 21928K
			{0.254688269, 0.255215061}, // 21929K
			{0.254687446, 0.255213932}, // 21930K
			{0.254686624, 0.255212803}, // 21931K
			{0.254685802, 0.255211674}, // 21932K
			{0.254684979, 0.255210545}, // 21933K
			{0.254684157, 0.255209416}, // 21934K
			{0.254683335, 0.255208287}, // 21935K
			{0.254682513, 0.255207159}, // 21936K
			{0.254681691, 0.255206031}, // 21937K
			{0.254680869, 0.255204902}, // 21938K
			{0.254680047, 0.255203774}, // 21939K
			{0.254679226, 0.255202646}, // 21940K
			{0.254678404, 0.255201518}, // 21941K
			{0.254677583, 0.25520039}, // 21942K
			{0.254676761, 0.255199263}, // 21943K
			{0.25467594, 0.255198135}, // 21944K
			{0.254675119, 0.255197008}, // 21945K
			{0.254674298, 0.25519588}, // 21946K
			{0.254673477, 0.255194753}, // 21947K
			{0.254672656, 0.255193626}, // 21948K
			{0.254671835, 0.255192499}, // 21949K
			{0.254671014, 0.255191372}, // 21950K
			{0.254670193, 0.255190245}, // 21951K
			{0.254669373, 0.255189119}, // 21952K
			{0.254668552, 0.255187992}, // 21953K
			{0.254667732, 0.255186866}, // 21954K
			{0.254666911, 0.255185739}, // 21955K
			{0.254666091, 0.255184613}, // 21956K
			{0.254665271, 0.255183487}, // 21957K
			{0.254664451, 0.255182361}, // 21958K
			{0.254663631, 0.255181235}, // 21959K
			{0.254662811, 0.25518011}, // 21960K
			{0.254661991, 0.255178984}, // 21961K
			{0.254661172, 0.255177859}, // 21962K
			{0.254660352, 0.255176733}, // 21963K
			{0.254659532, 0.255175608}, // 21964K
			{0.254658713, 0.255174483}, // 21965K
			{0.254657894, 0.255173358}, // 21966K
			{0.254657074, 0.255172233}, // 21967K
			{0.254656255, 0.255171108}, // 21968K
			{0.254655436, 0.255169983}, // 21969K
			{0.254654617, 0.255168859}, // 21970K
			{0.254653798, 0.255167734}, // 21971K
			{0.254652979, 0.25516661}, // 21972K
			{0.25465216, 0.255165486}, // 21973K
			{0.254651342, 0.255164362}, // 21974K
			{0.254650523, 0.255163238}, // 21975K
			{0.254649705, 0.255162114}, // 21976K
			{0.254648886, 0.25516099}, // 21977K
			{0.254648068, 0.255159866}, // 21978K
			{0.25464725, 0.255158743}, // 21979K
			{0.254646432, 0.255157619}, // 21980K
			{0.254645614, 0.255156496}, // 21981K
			{0.254644796, 0.255155373}, // 21982K
			{0.254643978, 0.25515425}, // 21983K
			{0.25464316, 0.255153127}, // 21984K
			{0.254642342, 0.255152004}, // 21985K
			{0.254641525, 0.255150881}, // 21986K
			{0.254640707, 0.255149759}, // 21987K
			{0.25463989, 0.255148636}, // 21988K
			{0.254639072, 0.255147514}, // 21989K
			{0.254638255, 0.255146392}, // 21990K
			{0.254637438, 0.255145269}, // 21991K
			{0.254636621, 0.255144147}, // 21992K
			{0.254635804, 0.255143026}, // 21993K
			{0.254634987, 0.255141904}, // 21994K
			{0.25463417, 0.255140782}, // 21995K
			{0.254633353, 0.25513966}, // 21996K
			{0.254632537, 0.255138539}, // 21997K
			{0.25463172, 0.255137418}, // 21998K
			{0.254630904, 0.255136296}, // 21999K
			{0.254630087, 0.255135175}, // 22000K
			{0.254629271, 0.255134054}, // 22001K
			{0.254628455, 0.255132933}, // 22002K
			{0.254627639, 0.255131813}, // 22003K
			{0.254626823, 0.255130692}, // 22004K
			{0.254626007, 0.255129572}, // 22005K
			{0.254625191, 0.255128451}, // 22006K
			{0.254624375, 0.255127331}, // 22007K
			{0.25462356, 0.255126211}, // 22008K
			{0.254622744, 0.255125091}, // 22009K
			{0.254621928, 0.255123971}, // 22010K
			{0.254621113, 0.255122851}, // 22011K
			{0.254620298, 0.255121731}, // 22012K
			{0.254619482, 0.255120611}, // 22013K
			{0.254618667, 0.255119492}, // 22014K
			{0.254617852, 0.255118373}, // 22015K
			{0.254617037, 0.255117253}, // 22016K
			{0.254616222, 0.255116134}, // 22017K
			{0.254615408, 0.255115015}, // 22018K
			{0.254614593, 0.255113896}, // 22019K
			{0.254613778, 0.255112777}, // 22020K
			{0.254612964, 0.255111659}, // 22021K
			{0.254612149, 0.25511054}, // 22022K
			{0.254611335, 0.255109422}, // 22023K
			{0.254610521, 0.255108303}, // 22024K
			{0.254609706, 0.255107185}, // 22025K
			{0.254608892, 0.255106067}, // 22026K
			{0.254608078, 0.255104949}, // 22027K
			{0.254607264, 0.255103831}, // 22028K
			{0.25460645, 0.255102713}, // 22029K
			{0.254605637, 0.255101596}, // 22030K
			{0.254604823, 0.255100478}, // 22031K
			{0.254604009, 0.255099361}, // 22032K
			{0.254603196, 0.255098243}, // 22033K
			{0.254602382, 0.255097126}, // 22034K
			{0.254601569, 0.255096009}, // 22035K
			{0.254600756, 0.255094892}, // 22036K
			{0.254599943, 0.255093775}, // 22037K
			{0.25459913, 0.255092658}, // 22038K
			{0.254598317, 0.255091542}, // 22039K
			{0.254597504, 0.255090425}, // 22040K
			{0.254596691, 0.255089309}, // 22041K
			{0.254595878, 0.255088192}, // 22042K
			{0.254595066, 0.255087076}, // 22043K
			{0.254594253, 0.25508596}, // 22044K
			{0.254593441, 0.255084844}, // 22045K
			{0.254592628, 0.255083728}, // 22046K
			{0.254591816, 0.255082613}, // 22047K
			{0.254591004, 0.255081497}, // 22048K
			{0.254590192, 0.255080382}, // 22049K
			{0.25458938, 0.255079266}, // 22050K
			{0.254588568, 0.255078151}, // 22051K
			{0.254587756, 0.255077036}, // 22052K
			{0.254586944, 0.255075921}, // 22053K
			{0.254586133, 0.255074806}, // 22054K
			{0.254585321, 0.255073691}, // 22055K
			{0.254584509, 0.255072576}, // 22056K
			{0.254583698, 0.255071462}, // 22057K
			{0.254582887, 0.255070347}, // 22058K
			{0.254582075, 0.255069233}, // 22059K
			{0.254581264, 0.255068119}, // 22060K
			{0.254580453, 0.255067005}, // 22061K
			{0.254579642, 0.255065891}, // 22062K
			{0.254578831, 0.255064777}, // 22063K
			{0.254578021, 0.255063663}, // 22064K
			{0.25457721, 0.255062549}, // 22065K
			{0.254576399, 0.255061436}, // 22066K
			{0.254575589, 0.255060322}, // 22067K
			{0.254574778, 0.255059209}, // 22068K
			{0.254573968, 0.255058096}, // 22069K
			{0.254573158, 0.255056983}, // 22070K
			{0.254572347, 0.25505587}, // 22071K
			{0.254571537, 0.255054757}, // 22072K
			{0.254570727, 0.255053644}, // 22073K
			{0.254569917, 0.255052531}, // 22074K
			{0.254569107, 0.255051419}, // 22075K
			{0.254568298, 0.255050307}, // 22076K
			{0.254567488, 0.255049194}, // 22077K
			{0.254566678, 0.255048082}, // 22078K
			{0.254565869, 0.25504697}, // 22079K
			{0.254565059, 0.255045858}, // 22080K
			{0.25456425, 0.255044746}, // 22081K
			{0.254563441, 0.255043634}, // 22082K
			{0.254562632, 0.255042523}, // 22083K
			{0.254561823, 0.255041411}, // 22084K
			{0.254561014, 0.2550403}, // 22085K
			{0.254560205, 0.255039189}, // 22086K
			{0.254559396, 0.255038077}, // 22087K
			{0.254558587, 0.255036966}, // 22088K
			{0.254557779, 0.255035855}, // 22089K
			{0.25455697, 0.255034745}, // 22090K
			{0.254556162, 0.255033634}, // 22091K
			{0.254555353, 0.255032523}, // 22092K
			{0.254554545, 0.255031413}, // 22093K
			{0.254553737, 0.255030303}, // 22094K
			{0.254552929, 0.255029192}, // 22095K
			{0.254552121, 0.255028082}, // 22096K
			{0.254551313, 0.255026972}, // 22097K
			{0.254550505, 0.255025862}, // 22098K
			{0.254549697, 0.255024752}, // 22099K
			{0.254548889, 0.255023643}, // 22100K
			{0.254548082, 0.255022533}, // 22101K
			{0.254547274, 0.255021424}, // 22102K
			{0.254546467, 0.255020314}, // 22103K
			{0.254545659, 0.255019205}, // 22104K
			{0.254544852, 0.255018096}, // 22105K
			{0.254544045, 0.255016987}, // 22106K
			{0.254543238, 0.255015878}, // 22107K
			{0.254542431, 0.255014769}, // 22108K
			{0.254541624, 0.255013661}, // 22109K
			{0.254540817, 0.255012552}, // 22110K
			{0.25454001, 0.255011444}, // 22111K
			{0.254539204, 0.255010335}, // 22112K
			{0.254538397, 0.255009227}, // 22113K
			{0.254537591, 0.255008119}, // 22114K
			{0.254536784, 0.255007011}, // 22115K
			{0.254535978, 0.255005903}, // 22116K
			{0.254535172, 0.255004795}, // 22117K
			{0.254534366, 0.255003688}, // 22118K
			{0.254533559, 0.25500258}, // 22119K
			{0.254532754, 0.255001473}, // 22120K
			{0.254531948, 0.255000365}, // 22121K
			{0.254531142, 0.254999258}, // 22122K
			{0.254530336, 0.254998151}, // 22123K
			{0.25452953, 0.254997044}, // 22124K
			{0.254528725, 0.254995937}, // 22125K
			{0.254527919, 0.254994831}, // 22126K
			{0.254527114, 0.254993724}, // 22127K
			{0.254526309, 0.254992617}, // 22128K
			{0.254525504, 0.254991511}, // 22129K
			{0.254524699, 0.254990405}, // 22130K
			{0.254523893, 0.254989298}, // 22131K
			{0.254523089, 0.254988192}, // 22132K
			{0.254522284, 0.254987086}, // 22133K
			{0.254521479, 0.254985981}, // 22134K
			{0.254520674, 0.254984875}, // 22135K
			{0.25451987, 0.254983769}, // 22136K
			{0.254519065, 0.254982664}, // 22137K
			{0.254518261, 0.254981558}, // 22138K
			{0.254517456, 0.254980453}, // 22139K
			{0.254516652, 0.254979348}, // 22140K
			{0.254515848, 0.254978243}, // 22141K
			{0.254515044, 0.254977138}, // 22142K
			{0.25451424, 0.254976033}, // 22143K
			{0.254513436, 0.254974928}, // 22144K
			{0.254512632, 0.254973824}, // 22145K
			{0.254511828, 0.254972719}, // 22146K
			{0.254511025, 0.254971615}, // 22147K
			{0.254510221, 0.254970511}, // 22148K
			{0.254509418, 0.254969406}, // 22149K
			{0.254508614, 0.254968302}, // 22150K
			{0.254507811, 0.254967199}, // 22151K
			{0.254507008, 0.254966095}, // 22152K
			{0.254506205, 0.254964991}, // 22153K
			{0.254505402, 0.254963887}, // 22154K
			{0.254504599, 0.254962784}, // 22155K
			{0.254503796, 0.254961681}, // 22156K
			{0.254502993, 0.254960577}, // 22157K
			{0.25450219, 0.254959474}, // 22158K
			{0.254501388, 0.254958371}, // 22159K
			{0.254500585, 0.254957268}, // 22160K
			{0.254499783, 0.254956165}, // 22161K
			{0.25449898, 0.254955063}, // 22162K
			{0.254498178, 0.25495396}, // 22163K
			{0.254497376, 0.254952858}, // 22164K
			{0.254496574, 0.254951755}, // 22165K
			{0.254495772, 0.254950653}, // 22166K
			{0.25449497, 0.254949551}, // 22167K
			{0.254494168, 0.254948449}, // 22168K
			{0.254493366, 0.254947347}, // 22169K
			{0.254492564, 0.254946245}, // 22170K
			{0.254491763, 0.254945144}, // 22171K
			{0.254490961, 0.254944042}, // 22172K
			{0.25449016, 0.254942941}, // 22173K
			{0.254489358, 0.254941839}, // 22174K
			{0.254488557, 0.254940738}, // 22175K
			{0.254487756, 0.254939637}, // 22176K
			{0.254486955, 0.254938536}, // 22177K
			{0.254486154, 0.254937435}, // 22178K
			{0.254485353, 0.254936334}, // 22179K
			{0.254484552, 0.254935233}, // 22180K
			{0.254483751, 0.254934133}, // 22181K
			{0.254482951, 0.254933032}, // 22182K
			{0.25448215, 0.254931932}, // 22183K
			{0.25448135, 0.254930832}, // 22184K
			{0.254480549, 0.254929732}, // 22185K
			{0.254479749, 0.254928632}, // 22186K
			{0.254478949, 0.254927532}, // 22187K
			{0.254478148, 0.254926432}, // 22188K
			{0.254477348, 0.254925332}, // 22189K
			{0.254476548, 0.254924233}, // 22190K
			{0.254475748, 0.254923133}, // 22191K
			{0.254474949, 0.254922034}, // 22192K
			{0.254474149, 0.254920935}, // 22193K
			{0.254473349, 0.254919836}, // 22194K
			{0.25447255, 0.254918737}, // 22195K
			{0.25447175, 0.254917638}, // 22196K
			{0.254470951, 0.254916539}, // 22197K
			{0.254470152, 0.25491544}, // 22198K
			{0.254469352, 0.254914342}, // 22199K
			{0.254468553, 0.254913243}, // 22200K
			{0.254467754, 0.254912145}, // 22201K
			{0.254466955, 0.254911047}, // 22202K
			{0.254466156, 0.254909949}, // 22203K
			{0.254465357, 0.254908851}, // 22204K
			{0.254464559, 0.254907753}, // 22205K
			{0.25446376, 0.254906655}, // 22206K
			{0.254462962, 0.254905558}, // 22207K
			{0.254462163, 0.25490446}, // 22208K
			{0.254461365, 0.254903363}, // 22209K
			{0.254460566, 0.254902265}, // 22210K
			{0.254459768, 0.254901168}, // 22211K
			{0.25445897, 0.254900071}, // 22212K
			{0.254458172, 0.254898974}, // 22213K
			{0.254457374, 0.254897877}, // 22214K
			{0.254456576, 0.25489678}, // 22215K
			{0.254455778, 0.254895684}, // 22216K
			{0.254454981, 0.254894587}, // 22217K
			{0.254454183, 0.254893491}, // 22218K
			{0.254453386, 0.254892394}, // 22219K
			{0.254452588, 0.254891298}, // 22220K
			{0.254451791, 0.254890202}, // 22221K
			{0.254450994, 0.254889106}, // 22222K
			{0.254450196, 0.25488801}, // 22223K
			{0.254449399, 0.254886914}, // 22224K
			{0.254448602, 0.254885819}, // 22225K
			{0.254447805, 0.254884723}, // 22226K
			{0.254447008, 0.254883628}, // 22227K
			{0.254446212, 0.254882533}, // 22228K
			{0.254445415, 0.254881437}, // 22229K
			{0.254444618, 0.254880342}, // 22230K
			{0.254443822, 0.254879247}, // 22231K
			{0.254443025, 0.254878152}, // 22232K
			{0.254442229, 0.254877058}, // 22233K
			{0.254441433, 0.254875963}, // 22234K
			{0.254440637, 0.254874868}, // 22235K
			{0.254439841, 0.254873774}, // 22236K
			{0.254439045, 0.25487268}, // 22237K
			{0.254438249, 0.254871585}, // 22238K
			{0.254437453, 0.254870491}, // 22239K
			{0.254436657, 0.254869397}, // 22240K
			{0.254435861, 0.254868304}, // 22241K
			{0.254435066, 0.25486721}, // 22242K
			{0.25443427, 0.254866116}, // 22243K
			{0.254433475, 0.254865023}, // 22244K
			{0.25443268, 0.254863929}, // 22245K
			{0.254431884, 0.254862836}, // 22246K
			{0.254431089, 0.254861743}, // 22247K
			{0.254430294, 0.25486065}, // 22248K
			{0.254429499, 0.254859557}, // 22249K
			{0.254428704, 0.254858464}, // 22250K
			{0.254427909, 0.254857371}, // 22251K
			{0.254427115, 0.254856278}, // 22252K
			{0.25442632, 0.254855186}, // 22253K
			{0.254425525, 0.254854093}, // 22254K
			{0.254424731, 0.254853001}, // 22255K
			{0.254423937, 0.254851909}, // 22256K
			{0.254423142, 0.254850817}, // 22257K
			{0.254422348, 0.254849725}, // 22258K
			{0.254421554, 0.254848633}, // 22259K
			{0.25442076, 0.254847541}, // 22260K
			{0.254419966, 0.254846449}, // 22261K
			{0.254419172, 0.254845358}, // 22262K
			{0.254418378, 0.254844266}, // 22263K
			{0.254417584, 0.254843175}, // 22264K
			{0.254416791, 0.254842084}, // 22265K
			{0.254415997, 0.254840993}, // 22266K
			{0.254415204, 0.254839902}, // 22267K
			{0.25441441, 0.254838811}, // 22268K
			{0.254413617, 0.25483772}, // 22269K
			{0.254412824, 0.254836629}, // 22270K
			{0.254412031, 0.254835539}, // 22271K
			{0.254411237, 0.254834448}, // 22272K
			{0.254410444, 0.254833358}, // 22273K
			{0.254409652, 0.254832268}, // 22274K
			{0.254408859, 0.254831178}, // 22275K
			{0.254408066, 0.254830088}, // 22276K
			{0.254407273, 0.254828998}, // 22277K
			{0.254406481, 0.254827908}, // 22278K
			{0.254405688, 0.254826818}, // 22279K
			{0.254404896, 0.254825729}, // 22280K
			{0.254404104, 0.254824639}, // 22281K
			{0.254403311, 0.25482355}, // 22282K
			{0.254402519, 0.254822461}, // 22283K
			{0.254401727, 0.254821372}, // 22284K
			{0.254400935, 0.254820283}, // 22285K
			{0.254400143, 0.254819194}, // 22286K
			{0.254399352, 0.254818105}, // 22287K
			{0.25439856, 0.254817016}, // 22288K
			{0.254397768, 0.254815928}, // 22289K
			{0.254396977, 0.254814839}, // 22290K
			{0.254396185, 0.254813751}, // 22291K
			{0.254395394, 0.254812663}, // 22292K
			{0.254394603, 0.254811575}, // 22293K
			{0.254393811, 0.254810487}, // 22294K
			{0.25439302, 0.254809399}, // 22295K
			{0.254392229, 0.254808311}, // 22296K
			{0.254391438, 0.254807223}, // 22297K
			{0.254390647, 0.254806136}, // 22298K
			{0.254389856, 0.254805048}, // 22299K
			{0.254389066, 0.254803961}, // 22300K
			{0.254388275, 0.254802874}, // 22301K
			{0.254387485, 0.254801787}, // 22302K
			{0.254386694, 0.2548007}, // 22303K
			{0.254385904, 0.254799613}, // 22304K
			{0.254385113, 0.254798526}, // 22305K
			{0.254384323, 0.254797439}, // 22306K
			{0.254383533, 0.254796353}, // 22307K
			{0.254382743, 0.254795266}, // 22308K
			{0.254381953, 0.25479418}, // 22309K
			{0.254381163, 0.254793094}, // 22310K
			{0.254380373, 0.254792007}, // 22311K
			{0.254379584, 0.254790921}, // 22312K
			{0.254378794, 0.254789835}, // 22313K
			{0.254378005, 0.25478875}, // 22314K
			{0.254377215, 0.254787664}, // 22315K
			{0.254376426, 0.254786578}, // 22316K
			{0.254375636, 0.254785493}, // 22317K
			{0.254374847, 0.254784407}, // 22318K
			{0.254374058, 0.254783322}, // 22319K
			{0.254373269, 0.254782237}, // 22320K
			{0.25437248, 0.254781152}, // 22321K
			{0.254371691, 0.254780067}, // 22322K
			{0.254370902, 0.254778982}, // 22323K
			{0.254370114, 0.254777898}, // 22324K
			{0.254369325, 0.254776813}, // 22325K
			{0.254368536, 0.254775728}, // 22326K
			{0.254367748, 0.254774644}, // 22327K
			{0.25436696, 0.25477356}, // 22328K
			{0.254366171, 0.254772476}, // 22329K
			{0.254365383, 0.254771392}, // 22330K
			{0.254364595, 0.254770308}, // 22331K
			{0.254363807, 0.254769224}, // 22332K
			{0.254363019, 0.25476814}, // 22333K
			{0.254362231, 0.254767056}, // 22334K
			{0.254361443, 0.254765973}, // 22335K
			{0.254360656, 0.25476489}, // 22336K
			{0.254359868, 0.254763806}, // 22337K
			{0.25435908, 0.254762723}, // 22338K
			{0.254358293, 0.25476164}, // 22339K
			{0.254357506, 0.254760557}, // 22340K
			{0.254356718, 0.254759474}, // 22341K
			{0.254355931, 0.254758391}, // 22342K
			{0.254355144, 0.254757309}, // 22343K
			{0.254354357, 0.254756226}, // 22344K
			{0.25435357, 0.254755144}, // 22345K
			{0.254352783, 0.254754062}, // 22346K
			{0.254351996, 0.254752979}, // 22347K
			{0.254351209, 0.254751897}, // 22348K
			{0.254350423, 0.254750815}, // 22349K
			{0.254349636, 0.254749733}, // 22350K
			{0.25434885, 0.254748652}, // 22351K
			{0.254348063, 0.25474757}, // 22352K
			{0.254347277, 0.254746488}, // 22353K
			{0.254346491, 0.254745407}, // 22354K
			{0.254345705, 0.254744326}, // 22355K
			{0.254344919, 0.254743244}, // 22356K
			{0.254344133, 0.254742163}, // 22357K
			{0.254343347, 0.254741082}, // 22358K
			{0.254342561, 0.254740001}, // 22359K
			{0.254341775, 0.254738921}, // 22360K
			{0.25434099, 0.25473784}, // 22361K
			{0.254340204, 0.254736759}, // 22362K
			{0.254339419, 0.254735679}, // 22363K
			{0.254338633, 0.254734599}, // 22364K
			{0.254337848, 0.254733518}, // 22365K
			{0.254337063, 0.254732438}, // 22366K
			{0.254336278, 0.254731358}, // 22367K
			{0.254335493, 0.254730278}, // 22368K
			{0.254334708, 0.254729199}, // 22369K
			{0.254333923, 0.254728119}, // 22370K
			{0.254333138, 0.254727039}, // 22371K
			{0.254332353, 0.25472596}, // 22372K
			{0.254331568, 0.254724881}, // 22373K
			{0.254330784, 0.254723801}, // 22374K
			{0.254329999, 0.254722722}, // 22375K
			{0.254329215, 0.254721643}, // 22376K
			{0.254328431, 0.254720564}, // 22377K
			{0.254327646, 0.254719485}, // 22378K
			{0.254326862, 0.254718407}, // 22379K
			{0.254326078, 0.254717328}, // 22380K
			{0.254325294, 0.25471625}, // 22381K
			{0.25432451, 0.254715171}, // 22382K
			{0.254323726, 0.254714093}, // 22383K
			{0.254322943, 0.254713015}, // 22384K
			{0.254322159, 0.254711937}, // 22385K
			{0.254321376, 0.254710859}, // 22386K
			{0.254320592, 0.254709781}, // 22387K
			{0.254319809, 0.254708703}, // 22388K
			{0.254319025, 0.254707626}, // 22389K
			{0.254318242, 0.254706548}, // 22390K
			{0.254317459, 0.254705471}, // 22391K
			{0.254316676, 0.254704393}, // 22392K
			{0.254315893, 0.254703316}, // 22393K
			{0.25431511, 0.254702239}, // 22394K
			{0.254314327, 0.254701162}, // 22395K
			{0.254313544, 0.254700085}, // 22396K
			{0.254312762, 0.254699008}, // 22397K
			{0.254311979, 0.254697932}, // 22398K
			{0.254311197, 0.254696855}, // 22399K
			{0.254310414, 0.254695779}, // 22400K
			{0.254309632, 0.254694703}, // 22401K
			{0.25430885, 0.254693626}, // 22402K
			{0.254308067, 0.25469255}, // 22403K
			{0.254307285, 0.254691474}, // 22404K
			{0.254306503, 0.254690398}, // 22405K
			{0.254305721, 0.254689323}, // 22406K
			{0.254304939, 0.254688247}, // 22407K
			{0.254304158, 0.254687171}, // 22408K
			{0.254303376, 0.254686096}, // 22409K
			{0.254302594, 0.254685021}, // 22410K
			{0.254301813, 0.254683945}, // 22411K
			{0.254301031, 0.25468287}, // 22412K
			{0.25430025, 0.254681795}, // 22413K
			{0.254299469, 0.25468072}, // 22414K
			{0.254298688, 0.254679645}, // 22415K
			{0.254297907, 0.254678571}, // 22416K
			{0.254297125, 0.254677496}, // 22417K
			{0.254296345, 0.254676422}, // 22418K
			{0.254295564, 0.254675347}, // 22419K
			{0.254294783, 0.254674273}, // 22420K
			{0.254294002, 0.254673199}, // 22421K
			{0.254293222, 0.254672125}, // 22422K
			{0.254292441, 0.254671051}, // 22423K
			{0.254291661, 0.254669977}, // 22424K
			{0.25429088, 0.254668903}, // 22425K
			{0.2542901, 0.25466783}, // 22426K
			{0.25428932, 0.254666756}, // 22427K
			{0.25428854, 0.254665683}, // 22428K
			{0.25428776, 0.25466461}, // 22429K
			{0.25428698, 0.254663536}, // 22430K
			{0.2542862, 0.254662463}, // 22431K
			{0.25428542, 0.25466139}, // 22432K
			{0.25428464, 0.254660318}, // 22433K
			{0.254283861, 0.254659245}, // 22434K
			{0.254283081, 0.254658172}, // 22435K
			{0.254282302, 0.2546571}, // 22436K
			{0.254281522, 0.254656027}, // 22437K
			{0.254280743, 0.254654955}, // 22438K
			{0.254279964, 0.254653883}, // 22439K
			{0.254279185, 0.254652811}, // 22440K
			{0.254278405, 0.254651739}, // 22441K
			{0.254277627, 0.254650667}, // 22442K
			{0.254276848, 0.254649595}, // 22443K
			{0.254276069, 0.254648523}, // 22444K
			{0.25427529, 0.254647452}, // 22445K
			{0.254274511, 0.25464638}, // 22446K
			{0.254273733, 0.254645309}, // 22447K
			{0.254272954, 0.254644238}, // 22448K
			{0.254272176, 0.254643166}, // 22449K
			{0.254271398, 0.254642095}, // 22450K
			{0.254270619, 0.254641024}, // 22451K
			{0.254269841, 0.254639954}, // 22452K
			{0.254269063, 0.254638883}, // 22453K
			{0.254268285, 0.254637812}, // 22454K
			{0.254267507, 0.254636742}, // 22455K
			{0.254266729, 0.254635672}, // 22456K
			{0.254265952, 0.254634601}, // 22457K
			{0.254265174, 0.254633531}, // 22458K
			{0.254264396, 0.254632461}, // 22459K
			{0.254263619, 0.254631391}, // 22460K
			{0.254262841, 0.254630321}, // 22461K
			{0.254262064, 0.254629252}, // 22462K
			{0.254261287, 0.254628182}, // 22463K
			{0.25426051, 0.254627112}, // 22464K
			{0.254259733, 0.254626043}, // 22465K
			{0.254258956, 0.254624974}, // 22466K
			{0.254258179, 0.254623904}, // 22467K
			{0.254257402, 0.254622835}, // 22468K
			{0.254256625, 0.254621766}, // 22469K
			{0.254255848, 0.254620697}, // 22470K
			{0.254255072, 0.254619629}, // 22471K
			{0.254254295, 0.25461856}, // 22472K
			{0.254253519, 0.254617492}, // 22473K
			{0.254252742, 0.254616423}, // 22474K
			{0.254251966, 0.254615355}, // 22475K
			{0.25425119, 0.254614286}, // 22476K
			{0.254250414, 0.254613218}, // 22477K
			{0.254249638, 0.25461215}, // 22478K
			{0.254248862, 0.254611082}, // 22479K
			{0.254248086, 0.254610015}, // 22480K
			{0.25424731, 0.254608947}, // 22481K
			{0.254246534, 0.254607879}, // 22482K
			{0.254245759, 0.254606812}, // 22483K
			{0.254244983, 0.254605744}, // 22484K
			{0.254244208, 0.254604677}, // 22485K
			{0.254243432, 0.25460361}, // 22486K
			{0.254242657, 0.254602543}, // 22487K
			{0.254241882, 0.254601476}, // 22488K
			{0.254241107, 0.254600409}, // 22489K
			{0.254240332, 0.254599342}, // 22490K
			{0.254239557, 0.254598276}, // 22491K
			{0.254238782, 0.254597209}, // 22492K
			{0.254238007, 0.254596143}, // 22493K
			{0.254237232, 0.254595077}, // 22494K
			{0.254236457, 0.25459401}, // 22495K
			{0.254235683, 0.254592944}, // 22496K
			{0.254234908, 0.254591878}, // 22497K
			{0.254234134, 0.254590812}, // 22498K
			{0.25423336, 0.254589747}, // 22499K
			{0.254232585, 0.254588681}, // 22500K
			{0.254231811, 0.254587615}, // 22501K
			{0.254231037, 0.25458655}, // 22502K
			{0.254230263, 0.254585485}, // 22503K
			{0.254229489, 0.254584419}, // 22504K
			{0.254228715, 0.254583354}, // 22505K
			{0.254227941, 0.254582289}, // 22506K
			{0.254227168, 0.254581224}, // 22507K
			{0.254226394, 0.25458016}, // 22508K
			{0.254225621, 0.254579095}, // 22509K
			{0.254224847, 0.25457803}, // 22510K
			{0.254224074, 0.254576966}, // 22511K
			{0.254223301, 0.254575901}, // 22512K
			{0.254222527, 0.254574837}, // 22513K
			{0.254221754, 0.254573773}, // 22514K
			{0.254220981, 0.254572709}, // 22515K
			{0.254220208, 0.254571645}, // 22516K
			{0.254219435, 0.254570581}, // 22517K
			{0.254218663, 0.254569517}, // 22518K
			{0.25421789, 0.254568454}, // 22519K
			{0.254217117, 0.25456739}, // 22520K
			{0.254216345, 0.254566327}, // 22521K
			{0.254215572, 0.254565263}, // 22522K
			{0.2542148, 0.2545642}, // 22523K
			{0.254214027, 0.254563137}, // 22524K
			{0.254213255, 0.254562074}, // 22525K
			{0.254212483, 0.254561011}, // 22526K
			{0.254211711, 0.254559948}, // 22527K
			{0.254210939, 0.254558886}, // 22528K
			{0.254210167, 0.254557823}, // 22529K
			{0.254209395, 0.254556761}, // 22530K
			{0.254208624, 0.254555698}, // 22531K
			{0.254207852, 0.254554636}, // 22532K
			{0.25420708, 0.254553574}, // 22533K
			{0.254206309, 0.254552512}, // 22534K
			{0.254205537, 0.25455145}, // 22535K
			{0.254204766, 0.254550388}, // 22536K
			{0.254203995, 0.254549326}, // 22537K
			{0.254203224, 0.254548265}, // 22538K
			{0.254202452, 0.254547203}, // 22539K
			{0.254201681, 0.254546142}, // 22540K
			{0.25420091, 0.254545081}, // 22541K
			{0.25420014, 0.254544019}, // 22542K
			{0.254199369, 0.254542958}, // 22543K
			{0.254198598, 0.254541897}, // 22544K
			{0.254197827, 0.254540837}, // 22545K
			{0.254197057, 0.254539776}, // 22546K
			{0.254196286, 0.254538715}, // 22547K
			{0.254195516, 0.254537655}, // 22548K
			{0.254194746, 0.254536594}, // 22549K
			{0.254193976, 0.254535534}, // 22550K
			{0.254193205, 0.254534474}, // 22551K
			{0.254192435, 0.254533413}, // 22552K
			{0.254191665, 0.254532353}, // 22553K
			{0.254190895, 0.254531294}, // 22554K
			{0.254190126, 0.254530234}, // 22555K
			{0.254189356, 0.254529174}, // 22556K
			{0.254188586, 0.254528114}, // 22557K
			{0.254187817, 0.254527055}, // 22558K
			{0.254187047, 0.254525996}, // 22559K
			{0.254186278, 0.254524936}, // 22560K
			{0.254185508, 0.254523877}, // 22561K
			{0.254184739, 0.254522818}, // 22562K
			{0.25418397, 0.254521759}, // 22563K
			{0.254183201, 0.2545207}, // 22564K
			{0.254182432, 0.254519641}, // 22565K
			{0.254181663, 0.254518583}, // 22566K
			{0.254180894, 0.254517524}, // 22567K
			{0.254180125, 0.254516466}, // 22568K
			{0.254179357, 0.254515407}, // 22569K
			{0.254178588, 0.254514349}, // 22570K
			{0.25417782, 0.254513291}, // 22571K
			{0.254177051, 0.254512233}, // 22572K
			{0.254176283, 0.254511175}, // 22573K
			{0.254175514, 0.254510117}, // 22574K
			{0.254174746, 0.25450906}, // 22575K
			{0.254173978, 0.254508002}, // 22576K
			{0.25417321, 0.254506945}, // 22577K
			{0.254172442, 0.254505887}, // 22578K
			{0.254171674, 0.25450483}, // 22579K
			{0.254170906, 0.254503773}, // 22580K
			{0.254170139, 0.254502716}, // 22581K
			{0.254169371, 0.254501659}, // 22582K
			{0.254168603, 0.254500602}, // 22583K
			{0.254167836, 0.254499545}, // 22584K
			{0.254167068, 0.254498489}, // 22585K
			{0.254166301, 0.254497432}, // 22586K
			{0.254165534, 0.254496376}, // 22587K
			{0.254164767, 0.254495319}, // 22588K
			{0.254164, 0.254494263}, // 22589K
			{0.254163233, 0.254493207}, // 22590K
			{0.254162466, 0.254492151}, // 22591K
			{0.254161699, 0.254491095}, // 22592K
			{0.254160932, 0.254490039}, // 22593K
			{0.254160165, 0.254488984}, // 22594K
			{0.254159399, 0.254487928}, // 22595K
			{0.254158632, 0.254486873}, // 22596K
			{0.254157866, 0.254485817}, // 22597K
			{0.254157099, 0.254484762}, // 22598K
			{0.254156333, 0.254483707}, // 22599K
			{0.254155567, 0.254482652}, // 22600K
			{0.254154801, 0.254481597}, // 22601K
			{0.254154035, 0.254480542}, // 22602K
			{0.254153269, 0.254479487}, // 22603K
			{0.254152503, 0.254478433}, // 22604K
			{0.254151737, 0.254477378}, // 22605K
			{0.254150971, 0.254476324}, // 22606K
			{0.254150206, 0.254475269}, // 22607K
			{0.25414944, 0.254474215}, // 22608K
			{0.254148675, 0.254473161}, // 22609K
			{0.254147909, 0.254472107}, // 22610K
			{0.254147144, 0.254471053}, // 22611K
			{0.254146379, 0.254469999}, // 22612K
			{0.254145613, 0.254468946}, // 22613K
			{0.254144848, 0.254467892}, // 22614K
			{0.254144083, 0.254466839}, // 22615K
			{0.254143318, 0.254465785}, // 22616K
			{0.254142553, 0.254464732}, // 22617K
			{0.254141789, 0.254463679}, // 22618K
			{0.254141024, 0.254462626}, // 22619K
			{0.254140259, 0.254461573}, // 22620K
			{0.254139495, 0.25446052}, // 22621K
			{0.25413873, 0.254459467}, // 22622K
			{0.254137966, 0.254458415}, // 22623K
			{0.254137202, 0.254457362}, // 22624K
			{0.254136437, 0.25445631}, // 22625K
			{0.254135673, 0.254455257}, // 22626K
			{0.254134909, 0.254454205}, // 22627K
			{0.254134145, 0.254453153}, // 22628K
			{0.254133381, 0.254452101}, // 22629K
			{0.254132618, 0.254451049}, // 22630K
			{0.254131854, 0.254449997}, // 22631K
			{0.25413109, 0.254448945}, // 22632K
			{0.254130327, 0.254447894}, // 22633K
			{0.254129563, 0.254446842}, // 22634K
			{0.2541288, 0.254445791}, // 22635K
			{0.254128036, 0.25444474}, // 22636K
			{0.254127273, 0.254443689}, // 22637K
			{0.25412651, 0.254442638}, // 22638K
			{0.254125747, 0.254441587}, // 22639K
			{0.254124984, 0.254440536}, // 22640K
			{0.254124221, 0.254439485}, // 22641K
			{0.254123458, 0.254438434}, // 22642K
			{0.254122695, 0.254437384}, // 22643K
			{0.254121932, 0.254436333}, // 22644K
			{0.25412117, 0.254435283}, // 22645K
			{0.254120407, 0.254434233}, // 22646K
			{0.254119645, 0.254433183}, // 22647K
			{0.254118882, 0.254432133}, // 22648K
			{0.25411812, 0.254431083}, // 22649K
			{0.254117358, 0.254430033}, // 22650K
			{0.254116596, 0.254428983}, // 22651K
			{0.254115833, 0.254427934}, // 22652K
			{0.254115071, 0.254426884}, // 22653K
			{0.25411431, 0.254425835}, // 22654K
			{0.254113548, 0.254424785}, // 22655K
			{0.254112786, 0.254423736}, // 22656K
			{0.254112024, 0.254422687}, // 22657K
			{0.254111263, 0.254421638}, // 22658K
			{0.254110501, 0.254420589}, // 22659K
			{0.25410974, 0.254419541}, // 22660K
			{0.254108978, 0.254418492}, // 22661K
			{0.254108217, 0.254417443}, // 22662K
			{0.254107456, 0.254416395}, // 22663K
			{0.254106695, 0.254415347}, // 22664K
			{0.254105934, 0.254414298}, // 22665K
			{0.254105173, 0.25441325}, // 22666K
			{0.254104412, 0.254412202}, // 22667K
			{0.254103651, 0.254411154}, // 22668K
			{0.25410289, 0.254410106}, // 22669K
			{0.25410213, 0.254409059}, // 22670K
			{0.254101369, 0.254408011}, // 22671K
			{0.254100608, 0.254406964}, // 22672K
			{0.254099848, 0.254405916}, // 22673K
			{0.254099088, 0.254404869}, // 22674K
			{0.254098327, 0.254403822}, // 22675K
			{0.254097567, 0.254402775}, // 22676K
			{0.254096807, 0.254401728}, // 22677K
			{0.254096047, 0.254400681}, // 22678K
			{0.254095287, 0.254399634}, // 22679K
			{0.254094527, 0.254398587}, // 22680K
			{0.254093767, 0.254397541}, // 22681K
			{0.254093008, 0.254396494}, // 22682K
			{0.254092248, 0.254395448}, // 22683K
			{0.254091489, 0.254394402}, // 22684K
			{0.254090729, 0.254393355}, // 22685K
			{0.25408997, 0.254392309}, // 22686K
			{0.25408921, 0.254391263}, // 22687K
			{0.254088451, 0.254390218}, // 22688K
			{0.254087692, 0.254389172}, // 22689K
			{0.254086933, 0.254388126}, // 22690K
			{0.254086174, 0.254387081}, // 22691K
			{0.254085415, 0.254386035}, // 22692K
			{0.254084656, 0.25438499}, // 22693K
			{0.254083897, 0.254383945}, // 22694K
			{0.254083139, 0.2543829}, // 22695K
			{0.25408238, 0.254381854}, // 22696K
			{0.254081622, 0.25438081}, // 22697K
			{0.254080863, 0.254379765}, // 22698K
			{0.254080105, 0.25437872}, // 22699K
			{0.254079346, 0.254377675}, // 22700K
			{0.254078588, 0.254376631}, // 22701K
			{0.25407783, 0.254375587}, // 22702K
			{0.254077072, 0.254374542}, // 22703K
			{0.254076314, 0.254373498}, // 22704K
			{0.254075556, 0.254372454}, // 22705K
			{0.254074798, 0.25437141}, // 22706K
			{0.254074041, 0.254370366}, // 22707K
			{0.254073283, 0.254369322}, // 22708K
			{0.254072525, 0.254368279}, // 22709K
			{0.254071768, 0.254367235}, // 22710K
			{0.25407101, 0.254366192}, // 22711K
			{0.254070253, 0.254365148}, // 22712K
			{0.254069496, 0.254364105}, // 22713K
			{0.254068739, 0.254363062}, // 22714K
			{0.254067981, 0.254362019}, // 22715K
			{0.254067224, 0.254360976}, // 22716K
			{0.254066467, 0.254359933}, // 22717K
			{0.254065711, 0.25435889}, // 22718K
			{0.254064954, 0.254357848}, // 22719K
			{0.254064197, 0.254356805}, // 22720K
			{0.25406344, 0.254355763}, // 22721K
			{0.254062684, 0.25435472}, // 22722K
			{0.254061927, 0.254353678}, // 22723K
			{0.254061171, 0.254352636}, // 22724K
			{0.254060415, 0.254351594}, // 22725K
			{0.254059658, 0.254350552}, // 22726K
			{0.254058902, 0.25434951}, // 22727K
			{0.254058146, 0.254348469}, // 22728K
			{0.25405739, 0.254347427}, // 22729K
			{0.254056634, 0.254346386}, // 22730K
			{0.254055878, 0.254345344}, // 22731K
			{0.254055123, 0.254344303}, // 22732K
			{0.254054367, 0.254343262}, // 22733K
			{0.254053611, 0.254342221}, // 22734K
			{0.254052856, 0.25434118}, // 22735K
			{0.2540521, 0.254340139}, // 22736K
			{0.254051345, 0.254339098}, // 22737K
			{0.254050589, 0.254338057}, // 22738K
			{0.254049834, 0.254337017}, // 22739K
			{0.254049079, 0.254335976}, // 22740K
			{0.254048324, 0.254334936}, // 22741K
			{0.254047569, 0.254333896}, // 22742K
			{0.254046814, 0.254332856}, // 22743K
			{0.254046059, 0.254331816}, // 22744K
			{0.254045304, 0.254330776}, // 22745K
			{0.25404455, 0.254329736}, // 22746K
			{0.254043795, 0.254328696}, // 22747K
			{0.254043041, 0.254327656}, // 22748K
			{0.254042286, 0.254326617}, // 22749K
			{0.254041532, 0.254325577}, // 22750K
			{0.254040777, 0.254324538}, // 22751K
			{0.254040023, 0.254323499}, // 22752K
			{0.254039269, 0.25432246}, // 22753K
			{0.254038515, 0.254321421}, // 22754K
			{0.254037761, 0.254320382}, // 22755K
			{0.254037007, 0.254319343}, // 22756K
			{0.254036253, 0.254318304}, // 22757K
			{0.2540355, 0.254317266}, // 22758K
			{0.254034746, 0.254316227}, // 22759K
			{0.254033992, 0.254315189}, // 22760K
			{0.254033239, 0.254314151}, // 22761K
			{0.254032485, 0.254313112}, // 22762K
			{0.254031732, 0.254312074}, // 22763K
			{0.254030979, 0.254311036}, // 22764K
			{0.254030225, 0.254309998}, // 22765K
			{0.254029472, 0.254308961}, // 22766K
			{0.254028719, 0.254307923}, // 22767K
			{0.254027966, 0.254306885}, // 22768K
			{0.254027213, 0.254305848}, // 22769K
			{0.254026461, 0.25430481}, // 22770K
			{0.254025708, 0.254303773}, // 22771K
			{0.254024955, 0.254302736}, // 22772K
			{0.254024203, 0.254301699}, // 22773K
			{0.25402345, 0.254300662}, // 22774K
			{0.254022698, 0.254299625}, // 22775K
			{0.254021945, 0.254298588}, // 22776K
			{0.254021193, 0.254297552}, // 22777K
			{0.254020441, 0.254296515}, // 22778K
			{0.254019689, 0.254295479}, // 22779K
			{0.254018937, 0.254294442}, // 22780K
			{0.254018185, 0.254293406}, // 22781K
			{0.254017433, 0.25429237}, // 22782K
			{0.254016681, 0.254291334}, // 22783K
			{0.254015929, 0.254290298}, // 22784K
			{0.254015178, 0.254289262}, // 22785K
			{0.254014426, 0.254288227}, // 22786K
			{0.254013675, 0.254287191}, // 22787K
			{0.254012923, 0.254286155}, // 22788K
			{0.254012172, 0.25428512}, // 22789K
			{0.25401142, 0.254284085}, // 22790K
			{0.254010669, 0.254283049}, // 22791K
			{0.254009918, 0.254282014}, // 22792K
			{0.254009167, 0.254280979}, // 22793K
			{0.254008416, 0.254279944}, // 22794K
			{0.254007665, 0.25427891}, // 22795K
			{0.254006915, 0.254277875}, // 22796K
			{0.254006164, 0.25427684}, // 22797K
			{0.254005413, 0.254275806}, // 22798K
			{0.254004663, 0.254274771}, // 22799K
			{0.254003912, 0.254273737}, // 22800K
			{0.254003162, 0.254272703}, // 22801K
			{0.254002411, 0.254271669}, // 22802K
			{0.254001661, 0.254270635}, // 22803K
			{0.254000911, 0.254269601}, // 22804K
			{0.254000161, 0.254268567}, // 22805K
			{0.253999411, 0.254267533}, // 22806K
			{0.253998661, 0.2542665}, // 22807K
			{0.253997911, 0.254265466}, // 22808K
			{0.253997161, 0.254264433}, // 22809K
			{0.253996411, 0.2542634}, // 22810K
			{0.253995662, 0.254262367}, // 22811K
			{0.253994912, 0.254261333}, // 22812K
			{0.253994163, 0.254260301}, // 22813K
			{0.253993413, 0.254259268}, // 22814K
			{0.253992664, 0.254258235}, // 22815K
			{0.253991915, 0.254257202}, // 22816K
			{0.253991166, 0.25425617}, // 22817K
			{0.253990416, 0.254255137}, // 22818K
			{0.253989667, 0.254254105}, // 22819K
			{0.253988918, 0.254253073}, // 22820K
			{0.25398817, 0.25425204}, // 22821K
			{0.253987421, 0.254251008}, // 22822K
			{0.253986672, 0.254249976}, // 22823K
			{0.253985923, 0.254248945}, // 22824K
			{0.253985175, 0.254247913}, // 22825K
			{0.253984426, 0.254246881}, // 22826K
			{0.253983678, 0.25424585}, // 22827K
			{0.25398293, 0.254244818}, // 22828K
			{0.253982181, 0.254243787}, // 22829K
			{0.253981433, 0.254242756}, // 22830K
			{0.253980685, 0.254241725}, // 22831K
			{0.253979937, 0.254240694}, // 22832K
			{0.253979189, 0.254239663}, // 22833K
			{0.253978441, 0.254238632}, // 22834K
			{0.253977694, 0.254237601}, // 22835K
			{0.253976946, 0.25423657}, // 22836K
			{0.253976198, 0.25423554}, // 22837K
			{0.253975451, 0.254234509}, // 22838K
			{0.253974703, 0.254233479}, // 22839K
			{0.253973956, 0.254232449}, // 22840K
			{0.253973208, 0.254231419}, // 22841K
			{0.253972461, 0.254230389}, // 22842K
			{0.253971714, 0.254229359}, // 22843K
			{0.253970967, 0.254228329}, // 22844K
			{0.25397022, 0.254227299}, // 22845K
			{0.253969473, 0.25422627}, // 22846K
			{0.253968726, 0.25422524}, // 22847K
			{0.253967979, 0.254224211}, // 22848K
			{0.253967233, 0.254223182}, // 22849K
			{0.253966486, 0.254222152}, // 22850K
			{0.253965739, 0.254221123}, // 22851K
			{0.253964993, 0.254220094}, // 22852K
			{0.253964246, 0.254219065}, // 22853K
			{0.2539635, 0.254218037}, // 22854K
			{0.253962754, 0.254217008}, // 22855K
			{0.253962008, 0.254215979}, // 22856K
			{0.253961262, 0.254214951}, // 22857K
			{0.253960516, 0.254213922}, // 22858K
			{0.25395977, 0.254212894}, // 22859K
			{0.253959024, 0.254211866}, // 22860K
			{0.253958278, 0.254210838}, // 22861K
			{0.253957532, 0.25420981}, // 22862K
			{0.253956787, 0.254208782}, // 22863K
			{0.253956041, 0.254207754}, // 22864K
			{0.253955296, 0.254206727}, // 22865K
			{0.25395455, 0.254205699}, // 22866K
			{0.253953805, 0.254204672}, // 22867K
			{0.25395306, 0.254203644}, // 22868K
			{0.253952314, 0.254202617}, // 22869K
			{0.253951569, 0.25420159}, // 22870K
			{0.253950824, 0.254200563}, // 22871K
			{0.253950079, 0.254199536}, // 22872K
			{0.253949335, 0.254198509}, // 22873K
			{0.25394859, 0.254197482}, // 22874K
			{0.253947845, 0.254196455}, // 22875K
			{0.2539471, 0.254195429}, // 22876K
			{0.253946356, 0.254194402}, // 22877K
			{0.253945611, 0.254193376}, // 22878K
			{0.253944867, 0.25419235}, // 22879K
			{0.253944123, 0.254191324}, // 22880K
			{0.253943378, 0.254190298}, // 22881K
			{0.253942634, 0.254189272}, // 22882K
			{0.25394189, 0.254188246}, // 22883K
			{0.253941146, 0.25418722}, // 22884K
			{0.253940402, 0.254186194}, // 22885K
			{0.253939658, 0.254185169}, // 22886K
			{0.253938914, 0.254184143}, // 22887K
			{0.253938171, 0.254183118}, // 22888K
			{0.253937427, 0.254182093}, // 22889K
			{0.253936683, 0.254181068}, // 22890K
			{0.25393594, 0.254180042}, // 22891K
			{0.253935196, 0.254179018}, // 22892K
			{0.253934453, 0.254177993}, // 22893K
			{0.25393371, 0.254176968}, // 22894K
			{0.253932967, 0.254175943}, // 22895K
			{0.253932224, 0.254174919}, // 22896K
			{0.253931481, 0.254173894}, // 22897K
			{0.253930738, 0.25417287}, // 22898K
			{0.253929995, 0.254171846}, // 22899K
			{0.253929252, 0.254170822}, // 22900K
			{0.253928509, 0.254169798}, // 22901K
			{0.253927767, 0.254168774}, // 22902K
			{0.253927024, 0.25416775}, // 22903K
			{0.253926281, 0.254166726}, // 22904K
			{0.253925539, 0.254165702}, // 22905K
			{0.253924797, 0.254164679}, // 22906K
			{0.253924054, 0.254163655}, // 22907K
			{0.253923312, 0.254162632}, // 22908K
			{0.25392257, 0.254161609}, // 22909K
			{0.253921828, 0.254160586}, // 22910K
			{0.253921086, 0.254159563}, // 22911K
			{0.253920344, 0.25415854}, // 22912K
			{0.253919602, 0.254157517}, // 22913K
			{0.253918861, 0.254156494}, // 22914K
			{0.253918119, 0.254155472}, // 22915K
			{0.253917377, 0.254154449}, // 22916K
			{0.253916636, 0.254153427}, // 22917K
			{0.253915894, 0.254152404}, // 22918K
			{0.253915153, 0.254151382}, // 22919K
			{0.253914412, 0.25415036}, // 22920K
			{0.253913671, 0.254149338}, // 22921K
			{0.253912929, 0.254148316}, // 22922K
			{0.253912188, 0.254147294}, // 22923K
			{0.253911447, 0.254146272}, // 22924K
			{0.253910706, 0.254145251}, // 22925K
			{0.253909966, 0.254144229}, // 22926K
			{0.253909225, 0.254143208}, // 22927K
			{0.253908484, 0.254142187}, // 22928K
			{0.253907744, 0.254141165}, // 22929K
			{0.253907003, 0.254140144}, // 22930K
			{0.253906263, 0.254139123}, // 22931K
			{0.253905522, 0.254138102}, // 22932K
			{0.253904782, 0.254137081}, // 22933K
			{0.253904042, 0.254136061}, // 22934K
			{0.253903302, 0.25413504}, // 22935K
			{0.253902562, 0.25413402}, // 22936K
			{0.253901822, 0.254132999}, // 22937K
			{0.253901082, 0.254131979}, // 22938K
			{0.253900342, 0.254130959}, // 22939K
			{0.253899602, 0.254129939}, // 22940K
			{0.253898862, 0.254128919}, // 22941K
			{0.253898123, 0.254127899}, // 22942K
			{0.253897383, 0.254126879}, // 22943K
			{0.253896644, 0.254125859}, // 22944K
			{0.253895904, 0.254124839}, // 22945K
			{0.253895165, 0.25412382}, // 22946K
			{0.253894426, 0.254122801}, // 22947K
			{0.253893687, 0.254121781}, // 22948K
			{0.253892947, 0.254120762}, // 22949K
			{0.253892208, 0.254119743}, // 22950K
			{0.25389147, 0.254118724}, // 22951K
			{0.253890731, 0.254117705}, // 22952K
			{0.253889992, 0.254116686}, // 22953K
			{0.253889253, 0.254115667}, // 22954K
			{0.253888515, 0.254114649}, // 22955K
			{0.253887776, 0.25411363}, // 22956K
			{0.253887038, 0.254112612}, // 22957K
			{0.253886299, 0.254111594}, // 22958K
			{0.253885561, 0.254110575}, // 22959K
			{0.253884823, 0.254109557}, // 22960K
			{0.253884084, 0.254108539}, // 22961K
			{0.253883346, 0.254107521}, // 22962K
			{0.253882608, 0.254106504}, // 22963K
			{0.25388187, 0.254105486}, // 22964K
			{0.253881132, 0.254104468}, // 22965K
			{0.253880395, 0.254103451}, // 22966K
			{0.253879657, 0.254102433}, // 22967K
			{0.253878919, 0.254101416}, // 22968K
			{0.253878182, 0.254100399}, // 22969K
			{0.253877444, 0.254099382}, // 22970K
			{0.253876707, 0.254098365}, // 22971K
			{0.253875969, 0.254097348}, // 22972K
			{0.253875232, 0.254096331}, // 22973K
			{0.253874495, 0.254095314}, // 22974K
			{0.253873758, 0.254094298}, // 22975K
			{0.253873021, 0.254093281}, // 22976K
			{0.253872284, 0.254092265}, // 22977K
			{0.253871547, 0.254091248}, // 22978K
			{0.25387081, 0.254090232}, // 22979K
			{0.253870073, 0.254089216}, // 22980K
			{0.253869337, 0.2540882}, // 22981K
			{0.2538686, 0.254087184}, // 22982K
			{0.253867864, 0.254086168}, // 22983K
			{0.253867127, 0.254085152}, // 22984K
			{0.253866391, 0.254084137}, // 22985K
			{0.253865654, 0.254083121}, // 22986K
			{0.253864918, 0.254082106}, // 22987K
			{0.253864182, 0.254081091}, // 22988K
			{0.253863446, 0.254080075}, // 22989K
			{0.25386271, 0.25407906}, // 22990K
			{0.253861974, 0.254078045}, // 22991K
			{0.253861238, 0.25407703}, // 22992K
			{0.253860503, 0.254076015}, // 22993K
			{0.253859767, 0.254075001}, // 22994K
			{0.253859031, 0.254073986}, // 22995K
			{0.253858296, 0.254072972}, // 22996K
			{0.25385756, 0.254071957}, // 22997K
			{0.253856825, 0.254070943}, // 22998K
			{0.25385609, 0.254069929}, // 22999K
			{0.253855354, 0.254068914}, // 23000K
			{0.253854619, 0.2540679}, // 23001K
			{0.253853884, 0.254066887}, // 23002K
			{0.253853149, 0.254065873}, // 23003K
			{0.253852414, 0.254064859}, // 23004K
			{0.253851679, 0.254063845}, // 23005K
			{0.253850944, 0.254062832}, // 23006K
			{0.25385021, 0.254061818}, // 23007K
			{0.253849475, 0.254060805}, // 23008K
			{0.253848741, 0.254059792}, // 23009K
			{0.253848006, 0.254058779}, // 23010K
			{0.253847272, 0.254057766}, // 23011K
			{0.253846537, 0.254056753}, // 23012K
			{0.253845803, 0.25405574}, // 23013K
			{0.253845069, 0.254054727}, // 23014K
			{0.253844335, 0.254053714}, // 23015K
			{0.253843601, 0.254052702}, // 23016K
			{0.253842867, 0.25405169}, // 23017K
			{0.253842133, 0.254050677}, // 23018K
			{0.253841399, 0.254049665}, // 23019K
			{0.253840665, 0.254048653}, // 23020K
			{0.253839932, 0.254047641}, // 23021K
			{0.253839198, 0.254046629}, // 23022K
			{0.253838465, 0.254045617}, // 23023K
			{0.253837731, 0.254044605}, // 23024K
			{0.253836998, 0.254043594}, // 23025K
			{0.253836264, 0.254042582}, // 23026K
			{0.253835531, 0.254041571}, // 23027K
			{0.253834798, 0.254040559}, // 23028K
			{0.253834065, 0.254039548}, // 23029K
			{0.253833332, 0.254038537}, // 23030K
			{0.253832599, 0.254037526}, // 23031K
			{0.253831866, 0.254036515}, // 23032K
			{0.253831134, 0.254035504}, // 23033K
			{0.253830401, 0.254034493}, // 23034K
			{0.253829668, 0.254033483}, // 23035K
			{0.253828936, 0.254032472}, // 23036K
			{0.253828203, 0.254031462}, // 23037K
			{0.253827471, 0.254030451}, // 23038K
			{0.253826738, 0.254029441}, // 23039K
			{0.253826006, 0.254028431}, // 23040K
			{0.253825274, 0.254027421}, // 23041K
			{0.253824542, 0.254026411}, // 23042K
			{0.25382381, 0.254025401}, // 23043K
			{0.253823078, 0.254024391}, // 23044K
			{0.253822346, 0.254023381}, // 23045K
			{0.253821614, 0.254022372}, // 23046K
			{0.253820883, 0.254021362}, // 23047K
			{0.253820151, 0.254020353}, // 23048K
			{0.253819419, 0.254019344}, // 23049K
			{0.253818688, 0.254018335}, // 23050K
			{0.253817957, 0.254017325}, // 23051K
			{0.253817225, 0.254016316}, // 23052K
			{0.253816494, 0.254015308}, // 23053K
			{0.253815763, 0.254014299}, // 23054K
			{0.253815032, 0.25401329}, // 23055K
			{0.253814301, 0.254012282}, // 23056K
			{0.25381357, 0.254011273}, // 23057K
			{0.253812839, 0.254010265}, // 23058K
			{0.253812108, 0.254009256}, // 23059K
			{0.253811377, 0.254008248}, // 23060K
			{0.253810646, 0.25400724}, // 23061K
			{0.253809916, 0.254006232}, // 23062K
			{0.253809185, 0.254005224}, // 23063K
			{0.253808455, 0.254004216}, // 23064K
			{0.253807724, 0.254003209}, // 23065K
			{0.253806994, 0.254002201}, // 23066K
			{0.253806264, 0.254001194}, // 23067K
			{0.253805534, 0.254000186}, // 23068K
			{0.253804804, 0.253999179}, // 23069K
			{0.253804074, 0.253998172}, // 23070K
			{0.253803344, 0.253997165}, // 23071K
			{0.253802614, 0.253996158}, // 23072K
			{0.253801884, 0.253995151}, // 23073K
			{0.253801154, 0.253994144}, // 23074K
			{0.253800425, 0.253993137}, // 23075K
			{0.253799695, 0.253992131}, // 23076K
			{0.253798966, 0.253991124}, // 23077K
			{0.253798236, 0.253990118}, // 23078K
			{0.253797507, 0.253989111}, // 23079K
			{0.253796778, 0.253988105}, // 23080K
			{0.253796048, 0.253987099}, // 23081K
			{0.253795319, 0.253986093}, // 23082K
			{0.25379459, 0.253985087}, // 23083K
			{0.253793861, 0.253984081}, // 23084K
			{0.253793132, 0.253983075}, // 23085K
			{0.253792404, 0.25398207}, // 23086K
			{0.253791675, 0.253981064}, // 23087K
			{0.253790946, 0.253980059}, // 23088K
			{0.253790218, 0.253979054}, // 23089K
			{0.253789489, 0.253978048}, // 23090K
			{0.253788761, 0.253977043}, // 23091K
			{0.253788032, 0.253976038}, // 23092K
			{0.253787304, 0.253975033}, // 23093K
			{0.253786576, 0.253974028}, // 23094K
			{0.253785848, 0.253973024}, // 23095K
			{0.25378512, 0.253972019}, // 23096K
			{0.253784392, 0.253971014}, // 23097K
			{0.253783664, 0.25397001}, // 23098K
			{0.253782936, 0.253969006}, // 23099K
			{0.253782208, 0.253968001}, // 23100K
			{0.25378148, 0.253966997}, // 23101K
			{0.253780753, 0.253965993}, // 23102K
			{0.253780025, 0.253964989}, // 23103K
			{0.253779298, 0.253963985}, // 23104K
			{0.25377857, 0.253962982}, // 23105K
			{0.253777843, 0.253961978}, // 23106K
			{0.253777116, 0.253960974}, // 23107K
			{0.253776388, 0.253959971}, // 23108K
			{0.253775661, 0.253958967}, // 23109K
			{0.253774934, 0.253957964}, // 23110K
			{0.253774207, 0.253956961}, // 23111K
			{0.25377348, 0.253955958}, // 23112K
			{0.253772754, 0.253954955}, // 23113K
			{0.253772027, 0.253953952}, // 23114K
			{0.2537713, 0.253952949}, // 23115K
			{0.253770574, 0.253951947}, // 23116K
			{0.253769847, 0.253950944}, // 23117K
			{0.253769121, 0.253949941}, // 23118K
			{0.253768394, 0.253948939}, // 23119K
			{0.253767668, 0.253947937}, // 23120K
			{0.253766942, 0.253946935}, // 23121K
			{0.253766215, 0.253945932}, // 23122K
			{0.253765489, 0.25394493}, // 23123K
			{0.253764763, 0.253943929}, // 23124K
			{0.253764037, 0.253942927}, // 23125K
			{0.253763312, 0.253941925}, // 23126K
			{0.253762586, 0.253940923}, // 23127K
			{0.25376186, 0.253939922}, // 23128K
			{0.253761134, 0.25393892}, // 23129K
			{0.253760409, 0.253937919}, // 23130K
			{0.253759683, 0.253936918}, // 23131K
			{0.253758958, 0.253935917}, // 23132K
			{0.253758233, 0.253934916}, // 23133K
			{0.253757507, 0.253933915}, // 23134K
			{0.253756782, 0.253932914}, // 23135K
			{0.253756057, 0.253931913}, // 23136K
			{0.253755332, 0.253930913}, // 23137K
			{0.253754607, 0.253929912}, // 23138K
			{0.253753882, 0.253928912}, // 23139K
			{0.253753157, 0.253927911}, // 23140K
			{0.253752433, 0.253926911}, // 23141K
			{0.253751708, 0.253925911}, // 23142K
			{0.253750983, 0.253924911}, // 23143K
			{0.253750259, 0.253923911}, // 23144K
			{0.253749534, 0.253922911}, // 23145K
			{0.25374881, 0.253921911}, // 23146K
			{0.253748086, 0.253920912}, // 23147K
			{0.253747361, 0.253919912}, // 23148K
			{0.253746637, 0.253918912}, // 23149K
			{0.253745913, 0.253917913}, // 23150K
			{0.253745189, 0.253916914}, // 23151K
			{0.253744465, 0.253915915}, // 23152K
			{0.253743741, 0.253914916}, // 23153K
			{0.253743017, 0.253913917}, // 23154K
			{0.253742294, 0.253912918}, // 23155K
			{0.25374157, 0.253911919}, // 23156K
			{0.253740846, 0.25391092}, // 23157K
			{0.253740123, 0.253909922}, // 23158K
			{0.253739399, 0.253908923}, // 23159K
			{0.253738676, 0.253907925}, // 23160K
			{0.253737953, 0.253906926}, // 23161K
			{0.25373723, 0.253905928}, // 23162K
			{0.253736506, 0.25390493}, // 23163K
			{0.253735783, 0.253903932}, // 23164K
			{0.25373506, 0.253902934}, // 23165K
			{0.253734338, 0.253901936}, // 23166K
			{0.253733615, 0.253900939}, // 23167K
			{0.253732892, 0.253899941}, // 23168K
			{0.253732169, 0.253898943}, // 23169K
			{0.253731447, 0.253897946}, // 23170K
			{0.253730724, 0.253896949}, // 23171K
			{0.253730002, 0.253895951}, // 23172K
			{0.253729279, 0.253894954}, // 23173K
			{0.253728557, 0.253893957}, // 23174K
			{0.253727835, 0.25389296}, // 23175K
			{0.253727112, 0.253891963}, // 23176K
			{0.25372639, 0.253890967}, // 23177K
			{0.253725668, 0.25388997}, // 23178K
			{0.253724946, 0.253888973}, // 23179K
			{0.253724224, 0.253887977}, // 23180K
			{0.253723502, 0.253886981}, // 23181K
			{0.253722781, 0.253885984}, // 23182K
			{0.253722059, 0.253884988}, // 23183K
			{0.253721337, 0.253883992}, // 23184K
			{0.253720616, 0.253882996}, // 23185K
			{0.253719894, 0.253882}, // 23186K
			{0.253719173, 0.253881004}, // 23187K
			{0.253718452, 0.253880009}, // 23188K
			{0.253717731, 0.253879013}, // 23189K
			{0.253717009, 0.253878018}, // 23190K
			{0.253716288, 0.253877022}, // 23191K
			{0.253715567, 0.253876027}, // 23192K
			{0.253714846, 0.253875032}, // 23193K
			{0.253714125, 0.253874037}, // 23194K
			{0.253713405, 0.253873042}, // 23195K
			{0.253712684, 0.253872047}, // 23196K
			{0.253711963, 0.253871052}, // 23197K
			{0.253711243, 0.253870057}, // 23198K
			{0.253710522, 0.253869063}, // 23199K
			{0.253709802, 0.253868068}, // 23200K
			{0.253709081, 0.253867074}, // 23201K
			{0.253708361, 0.253866079}, // 23202K
			{0.253707641, 0.253865085}, // 23203K
			{0.253706921, 0.253864091}, // 23204K
			{0.253706201, 0.253863097}, // 23205K
			{0.253705481, 0.253862103}, // 23206K
			{0.253704761, 0.253861109}, // 23207K
			{0.253704041, 0.253860115}, // 23208K
			{0.253703321, 0.253859122}, // 23209K
			{0.253702601, 0.253858128}, // 23210K
			{0.253701882, 0.253857135}, // 23211K
			{0.253701162, 0.253856141}, // 23212K
			{0.253700443, 0.253855148}, // 23213K
			{0.253699723, 0.253854155}, // 23214K
			{0.253699004, 0.253853162}, // 23215K
			{0.253698285, 0.253852169}, // 23216K
			{0.253697566, 0.253851176}, // 23217K
			{0.253696846, 0.253850183}, // 23218K
			{0.253696127, 0.25384919}, // 23219K
			{0.253695408, 0.253848198}, // 23220K
			{0.253694689, 0.253847205}, // 23221K
			{0.253693971, 0.253846213}, // 23222K
			{0.253693252, 0.253845221}, // 23223K
			{0.253692533, 0.253844228}, // 23224K
			{0.253691815, 0.253843236}, // 23225K
			{0.253691096, 0.253842244}, // 23226K
			{0.253690378, 0.253841252}, // 23227K
			{0.253689659, 0.25384026}, // 23228K
			{0.253688941, 0.253839269}, // 23229K
			{0.253688223, 0.253838277}, // 23230K
			{0.253687504, 0.253837286}, // 23231K
			{0.253686786, 0.253836294}, // 23232K
			{0.253686068, 0.253835303}, // 23233K
			{0.25368535, 0.253834312}, // 23234K
			{0.253684632, 0.25383332}, // 23235K
			{0.253683915, 0.253832329}, // 23236K
			{0.253683197, 0.253831338}, // 23237K
			{0.253682479, 0.253830347}, // 23238K
			{0.253681762, 0.253829357}, // 23239K
			{0.253681044, 0.253828366}, // 23240K
			{0.253680327, 0.253827375}, // 23241K
			{0.253679609, 0.253826385}, // 23242K
			{0.253678892, 0.253825395}, // 23243K
			{0.253678175, 0.253824404}, // 23244K
			{0.253677458, 0.253823414}, // 23245K
			{0.25367674, 0.253822424}, // 23246K
			{0.253676023, 0.253821434}, // 23247K
			{0.253675306, 0.253820444}, // 23248K
			{0.25367459, 0.253819454}, // 23249K
			{0.253673873, 0.253818465}, // 23250K
			{0.253673156, 0.253817475}, // 23251K
			{0.253672439, 0.253816485}, // 23252K
			{0.253671723, 0.253815496}, // 23253K
			{0.253671006, 0.253814507}, // 23254K
			{0.25367029, 0.253813517}, // 23255K
			{0.253669573, 0.253812528}, // 23256K
			{0.253668857, 0.253811539}, // 23257K
			{0.253668141, 0.25381055}, // 23258K
			{0.253667425, 0.253809561}, // 23259K
			{0.253666709, 0.253808573}, // 23260K
			{0.253665993, 0.253807584}, // 23261K
			{0.253665277, 0.253806596}, // 23262K
			{0.253664561, 0.253805607}, // 23263K
			{0.253663845, 0.253804619}, // 23264K
			{0.253663129, 0.25380363}, // 23265K
			{0.253662414, 0.253802642}, // 23266K
			{0.253661698, 0.253801654}, // 23267K
			{0.253660983, 0.253800666}, // 23268K
			{0.253660267, 0.253799678}, // 23269K
			{0.253659552, 0.25379869}, // 23270K
			{0.253658837, 0.253797703}, // 23271K
			{0.253658121, 0.253796715}, // 23272K
			{0.253657406, 0.253795728}, // 23273K
			{0.253656691, 0.25379474}, // 23274K
			{0.253655976, 0.253793753}, // 23275K
			{0.253655261, 0.253792766}, // 23276K
			{0.253654546, 0.253791779}, // 23277K
			{0.253653832, 0.253790791}, // 23278K
			{0.253653117, 0.253789805}, // 23279K
			{0.253652402, 0.253788818}, // 23280K
			{0.253651688, 0.253787831}, // 23281K
			{0.253650973, 0.253786844}, // 23282K
			{0.253650259, 0.253785858}, // 23283K
			{0.253649545, 0.253784871}, // 23284K
			{0.25364883, 0.253783885}, // 23285K
			{0.253648116, 0.253782899}, // 23286K
			{0.253647402, 0.253781912}, // 23287K
			{0.253646688, 0.253780926}, // 23288K
			{0.253645974, 0.25377994}, // 23289K
			{0.25364526, 0.253778955}, // 23290K
			{0.253644546, 0.253777969}, // 23291K
			{0.253643832, 0.253776983}, // 23292K
			{0.253643119, 0.253775997}, // 23293K
			{0.253642405, 0.253775012}, // 23294K
			{0.253641691, 0.253774027}, // 23295K
			{0.253640978, 0.253773041}, // 23296K
			{0.253640265, 0.253772056}, // 23297K
			{0.253639551, 0.253771071}, // 23298K
			{0.253638838, 0.253770086}, // 23299K
			{0.253638125, 0.253769101}, // 23300K
			{0.253637412, 0.253768116}, // 23301K
			{0.253636699, 0.253767131}, // 23302K
			{0.253635986, 0.253766147}, // 23303K
			{0.253635273, 0.253765162}, // 23304K
			{0.25363456, 0.253764178}, // 23305K
			{0.253633847, 0.253763193}, // 23306K
			{0.253633134, 0.253762209}, // 23307K
			{0.253632422, 0.253761225}, // 23308K
			{0.253631709, 0.253760241}, // 23309K
			{0.253630997, 0.253759257}, // 23310K
			{0.253630284, 0.253758273}, // 23311K
			{0.253629572, 0.253757289}, // 23312K
			{0.25362886, 0.253756305}, // 23313K
			{0.253628148, 0.253755322}, // 23314K
			{0.253627435, 0.253754338}, // 23315K
			{0.253626723, 0.253753355}, // 23316K
			{0.253626011, 0.253752372}, // 23317K
			{0.253625299, 0.253751388}, // 23318K
			{0.253624588, 0.253750405}, // 23319K
			{0.253623876, 0.253749422}, // 23320K
			{0.253623164, 0.253748439}, // 23321K
			{0.253622453, 0.253747456}, // 23322K
			{0.253621741, 0.253746474}, // 23323K
			{0.25362103, 0.253745491}, // 23324K
			{0.253620318, 0.253744508}, // 23325K
			{0.253619607, 0.253743526}, // 23326K
			{0.253618896, 0.253742544}, // 23327K
			{0.253618184, 0.253741561}, // 23328K
			{0.253617473, 0.253740579}, // 23329K
			{0.253616762, 0.253739597}, // 23330K
			{0.253616051, 0.253738615}, // 23331K
			{0.25361534, 0.253737633}, // 23332K
			{0.25361463, 0.253736651}, // 23333K
			{0.253613919, 0.25373567}, // 23334K
			{0.253613208, 0.253734688}, // 23335K
			{0.253612497, 0.253733707}, // 23336K
			{0.253611787, 0.253732725}, // 23337K
			{0.253611076, 0.253731744}, // 23338K
			{0.253610366, 0.253730763}, // 23339K
			{0.253609656, 0.253729781}, // 23340K
			{0.253608945, 0.2537288}, // 23341K
			{0.253608235, 0.253727819}, // 23342K
			{0.253607525, 0.253726839}, // 23343K
			{0.253606815, 0.253725858}, // 23344K
			{0.253606105, 0.253724877}, // 23345K
			{0.253605395, 0.253723897}, // 23346K
			{0.253604685, 0.253722916}, // 23347K
			{0.253603976, 0.253721936}, // 23348K
			{0.253603266, 0.253720956}, // 23349K
			{0.253602556, 0.253719975}, // 23350K
			{0.253601847, 0.253718995}, // 23351K
			{0.253601137, 0.253718015}, // 23352K
			{0.253600428, 0.253717035}, // 23353K
			{0.253599719, 0.253716056}, // 23354K
			{0.253599009, 0.253715076}, // 23355K
			{0.2535983, 0.253714096}, // 23356K
			{0.253597591, 0.253713117}, // 23357K
			{0.253596882, 0.253712137}, // 23358K
			{0.253596173, 0.253711158}, // 23359K
			{0.253595464, 0.253710179}, // 23360K
			{0.253594755, 0.2537092}, // 23361K
			{0.253594046, 0.25370822}, // 23362K
			{0.253593338, 0.253707241}, // 23363K
			{0.253592629, 0.253706263}, // 23364K
			{0.253591921, 0.253705284}, // 23365K
			{0.253591212, 0.253704305}, // 23366K
			{0.253590504, 0.253703327}, // 23367K
			{0.253589795, 0.253702348}, // 23368K
			{0.253589087, 0.25370137}, // 23369K
			{0.253588379, 0.253700391}, // 23370K
			{0.253587671, 0.253699413}, // 23371K
			{0.253586963, 0.253698435}, // 23372K
			{0.253586255, 0.253697457}, // 23373K
			{0.253585547, 0.253696479}, // 23374K
			{0.253584839, 0.253695501}, // 23375K
			{0.253584131, 0.253694524}, // 23376K
			{0.253583424, 0.253693546}, // 23377K
			{0.253582716, 0.253692568}, // 23378K
			{0.253582008, 0.253691591}, // 23379K
			{0.253581301, 0.253690614}, // 23380K
			{0.253580594, 0.253689636}, // 23381K
			{0.253579886, 0.253688659}, // 23382K
			{0.253579179, 0.253687682}, // 23383K
			{0.253578472, 0.253686705}, // 23384K
			{0.253577765, 0.253685728}, // 23385K
			{0.253577058, 0.253684751}, // 23386K
			{0.253576351, 0.253683775}, // 23387K
			{0.253575644, 0.253682798}, // 23388K
			{0.253574937, 0.253681822}, // 23389K
			{0.25357423, 0.253680845}, // 23390K
			{0.253573523, 0.253679869}, // 23391K
			{0.253572817, 0.253678893}, // 23392K
			{0.25357211, 0.253677917}, // 23393K
			{0.253571404, 0.25367694}, // 23394K
			{0.253570697, 0.253675965}, // 23395K
			{0.253569991, 0.253674989}, // 23396K
			{0.253569285, 0.253674013}, // 23397K
			{0.253568578, 0.253673037}, // 23398K
			{0.253567872, 0.253672062}, // 23399K
			{0.253567166, 0.253671086}, // 23400K
			{0.25356646, 0.253670111}, // 23401K
			{0.253565754, 0.253669136}, // 23402K
			{0.253565048, 0.25366816}, // 23403K
			{0.253564343, 0.253667185}, // 23404K
			{0.253563637, 0.25366621}, // 23405K
			{0.253562931, 0.253665235}, // 23406K
			{0.253562226, 0.253664261}, // 23407K
			{0.25356152, 0.253663286}, // 23408K
			{0.253560815, 0.253662311}, // 23409K
			{0.253560109, 0.253661337}, // 23410K
			{0.253559404, 0.253660362}, // 23411K
			{0.253558699, 0.253659388}, // 23412K
			{0.253557994, 0.253658414}, // 23413K
			{0.253557289, 0.253657439}, // 23414K
			{0.253556584, 0.253656465}, // 23415K
			{0.253555879, 0.253655491}, // 23416K
			{0.253555174, 0.253654517}, // 23417K
			{0.253554469, 0.253653544}, // 23418K
			{0.253553764, 0.25365257}, // 23419K
			{0.25355306, 0.253651596}, // 23420K
			{0.253552355, 0.253650623}, // 23421K
			{0.253551651, 0.253649649}, // 23422K
			{0.253550946, 0.253648676}, // 23423K
			{0.253550242, 0.253647703}, // 23424K
			{0.253549538, 0.25364673}, // 23425K
			{0.253548833, 0.253645757}, // 23426K
			{0.253548129, 0.253644784}, // 23427K
			{0.253547425, 0.253643811}, // 23428K
			{0.253546721, 0.253642838}, // 23429K
			{0.253546017, 0.253641866}, // 23430K
			{0.253545313, 0.253640893}, // 23431K
			{0.253544609, 0.25363992}, // 23432K
			{0.253543906, 0.253638948}, // 23433K
			{0.253543202, 0.253637976}, // 23434K
			{0.253542498, 0.253637004}, // 23435K
			{0.253541795, 0.253636032}, // 23436K
			{0.253541092, 0.25363506}, // 23437K
			{0.253540388, 0.253634088}, // 23438K
			{0.253539685, 0.253633116}, // 23439K
			{0.253538982, 0.253632144}, // 23440K
			{0.253538278, 0.253631172}, // 23441K
			{0.253537575, 0.253630201}, // 23442K
			{0.253536872, 0.253629229}, // 23443K
			{0.253536169, 0.253628258}, // 23444K
			{0.253535466, 0.253627287}, // 23445K
			{0.253534764, 0.253626316}, // 23446K
			{0.253534061, 0.253625345}, // 23447K
			{0.253533358, 0.253624374}, // 23448K
			{0.253532656, 0.253623403}, // 23449K
			{0.253531953, 0.253622432}, // 23450K
			{0.253531251, 0.253621461}, // 23451K
			{0.253530548, 0.253620491}, // 23452K
			{0.253529846, 0.25361952}, // 23453K
			{0.253529144, 0.25361855}, // 23454K
			{0.253528441, 0.253617579}, // 23455K
			{0.253527739, 0.253616609}, // 23456K
			{0.253527037, 0.253615639}, // 23457K
			{0.253526335, 0.253614669}, // 23458K
			{0.253525633, 0.253613699}, // 23459K
			{0.253524932, 0.253612729}, // 23460K
			{0.25352423, 0.253611759}, // 23461K
			{0.253523528, 0.25361079}, // 23462K
			{0.253522826, 0.25360982}, // 23463K
			{0.253522125, 0.253608851}, // 23464K
			{0.253521423, 0.253607881}, // 23465K
			{0.253520722, 0.253606912}, // 23466K
			{0.253520021, 0.253605943}, // 23467K
			{0.253519319, 0.253604973}, // 23468K
			{0.253518618, 0.253604004}, // 23469K
			{0.253517917, 0.253603036}, // 23470K
			{0.253517216, 0.253602067}, // 23471K
			{0.253516515, 0.253601098}, // 23472K
			{0.253515814, 0.253600129}, // 23473K
			{0.253515113, 0.253599161}, // 23474K
			{0.253514412, 0.253598192}, // 23475K
			{0.253513712, 0.253597224}, // 23476K
			{0.253513011, 0.253596256}, // 23477K
			{0.253512311, 0.253595287}, // 23478K
			{0.25351161, 0.253594319}, // 23479K
			{0.25351091, 0.253593351}, // 23480K
			{0.253510209, 0.253592383}, // 23481K
			{0.253509509, 0.253591416}, // 23482K
			{0.253508809, 0.253590448}, // 23483K
			{0.253508109, 0.25358948}, // 23484K
			{0.253507408, 0.253588513}, // 23485K
			{0.253506708, 0.253587545}, // 23486K
			{0.253506009, 0.253586578}, // 23487K
			{0.253505309, 0.253585611}, // 23488K
			{0.253504609, 0.253584643}, // 23489K
			{0.253503909, 0.253583676}, // 23490K
			{0.253503209, 0.253582709}, // 23491K
			{0.25350251, 0.253581742}, // 23492K
			{0.25350181, 0.253580776}, // 23493K
			{0.253501111, 0.253579809}, // 23494K
			{0.253500412, 0.253578842}, // 23495K
			{0.253499712, 0.253577876}, // 23496K
			{0.253499013, 0.253576909}, // 23497K
			{0.253498314, 0.253575943}, // 23498K
			{0.253497615, 0.253574977}, // 23499K
			{0.253496916, 0.253574011}, // 23500K
			{0.253496217, 0.253573045}, // 23501K
			{0.253495518, 0.253572079}, // 23502K
			{0.253494819, 0.253571113}, // 23503K
			{0.25349412, 0.253570147}, // 23504K
			{0.253493421, 0.253569181}, // 23505K
			{0.253492723, 0.253568216}, // 23506K
			{0.253492024, 0.25356725}, // 23507K
			{0.253491326, 0.253566285}, // 23508K
			{0.253490627, 0.25356532}, // 23509K
			{0.253489929, 0.253564354}, // 23510K
			{0.253489231, 0.253563389}, // 23511K
			{0.253488533, 0.253562424}, // 23512K
			{0.253487835, 0.253561459}, // 23513K
			{0.253487136, 0.253560494}, // 23514K
			{0.253486438, 0.25355953}, // 23515K
			{0.253485741, 0.253558565}, // 23516K
			{0.253485043, 0.2535576}, // 23517K
			{0.253484345, 0.253556636}, // 23518K
			{0.253483647, 0.253555671}, // 23519K
			{0.25348295, 0.253554707}, // 23520K
			{0.253482252, 0.253553743}, // 23521K
			{0.253481554, 0.253552779}, // 23522K
			{0.253480857, 0.253551815}, // 23523K
			{0.25348016, 0.253550851}, // 23524K
			{0.253479462, 0.253549887}, // 23525K
			{0.253478765, 0.253548923}, // 23526K
			{0.253478068, 0.25354796}, // 23527K
			{0.253477371, 0.253546996}, // 23528K
			{0.253476674, 0.253546033}, // 23529K
			{0.253475977, 0.253545069}, // 23530K
			{0.25347528, 0.253544106}, // 23531K
			{0.253474583, 0.253543143}, // 23532K
			{0.253473887, 0.25354218}, // 23533K
			{0.25347319, 0.253541217}, // 23534K
			{0.253472493, 0.253540254}, // 23535K
			{0.253471797, 0.253539291}, // 23536K
			{0.2534711, 0.253538328}, // 23537K
			{0.253470404, 0.253537366}, // 23538K
			{0.253469708, 0.253536403}, // 23539K
			{0.253469011, 0.25353544}, // 23540K
			{0.253468315, 0.253534478}, // 23541K
			{0.253467619, 0.253533516}, // 23542K
			{0.253466923, 0.253532554}, // 23543K
			{0.253466227, 0.253531592}, // 23544K
			{0.253465531, 0.25353063}, // 23545K
			{0.253464835, 0.253529668}, // 23546K
			{0.253464139, 0.253528706}, // 23547K
			{0.253463444, 0.253527744}, // 23548K
			{0.253462748, 0.253526783}, // 23549K
			{0.253462053, 0.253525821}, // 23550K
			{0.253461357, 0.25352486}, // 23551K
			{0.253460662, 0.253523898}, // 23552K
			{0.253459966, 0.253522937}, // 23553K
			{0.253459271, 0.253521976}, // 23554K
			{0.253458576, 0.253521015}, // 23555K
			{0.253457881, 0.253520054}, // 23556K
			{0.253457186, 0.253519093}, // 23557K
			{0.253456491, 0.253518132}, // 23558K
			{0.253455796, 0.253517171}, // 23559K
			{0.253455101, 0.253516211}, // 23560K
			{0.253454406, 0.25351525}, // 23561K
			{0.253453711, 0.25351429}, // 23562K
			{0.253453017, 0.253513329}, // 23563K
			{0.253452322, 0.253512369}, // 23564K
			{0.253451628, 0.253511409}, // 23565K
			{0.253450933, 0.253510449}, // 23566K
			{0.253450239, 0.253509489}, // 23567K
			{0.253449544, 0.253508529}, // 23568K
			{0.25344885, 0.253507569}, // 23569K
			{0.253448156, 0.25350661}, // 23570K
			{0.253447462, 0.25350565}, // 23571K
			{0.253446768, 0.25350469}, // 23572K
			{0.253446074, 0.253503731}, // 23573K
			{0.25344538, 0.253502772}, // 23574K
			{0.253444686, 0.253501812}, // 23575K
			{0.253443992, 0.253500853}, // 23576K
			{0.253443299, 0.253499894}, // 23577K
			{0.253442605, 0.253498935}, // 23578K
			{0.253441911, 0.253497976}, // 23579K
			{0.253441218, 0.253497018}, // 23580K
			{0.253440525, 0.253496059}, // 23581K
			{0.253439831, 0.2534951}, // 23582K
			{0.253439138, 0.253494142}, // 23583K
			{0.253438445, 0.253493183}, // 23584K
			{0.253437752, 0.253492225}, // 23585K
			{0.253437059, 0.253491267}, // 23586K
			{0.253436366, 0.253490309}, // 23587K
			{0.253435673, 0.253489351}, // 23588K
			{0.25343498, 0.253488393}, // 23589K
			{0.253434287, 0.253487435}, // 23590K
			{0.253433594, 0.253486477}, // 23591K
			{0.253432902, 0.253485519}, // 23592K
			{0.253432209, 0.253484562}, // 23593K
			{0.253431516, 0.253483604}, // 23594K
			{0.253430824, 0.253482647}, // 23595K
			{0.253430132, 0.25348169}, // 23596K
			{0.253429439, 0.253480732}, // 23597K
			{0.253428747, 0.253479775}, // 23598K
			{0.253428055, 0.253478818}, // 23599K
			{0.253427363, 0.253477861}, // 23600K
			{0.253426671, 0.253476904}, // 23601K
			{0.253425979, 0.253475948}, // 23602K
			{0.253425287, 0.253474991}, // 23603K
			{0.253424595, 0.253474034}, // 23604K
			{0.253423903, 0.253473078}, // 23605K
			{0.253423212, 0.253472121}, // 23606K
			{0.25342252, 0.253471165}, // 23607K
			{0.253421828, 0.253470209}, // 23608K
			{0.253421137, 0.253469253}, // 23609K
			{0.253420445, 0.253468297}, // 23610K
			{0.253419754, 0.253467341}, // 23611K
			{0.253419063, 0.253466385}, // 23612K
			{0.253418372, 0.253465429}, // 23613K
			{0.25341768, 0.253464473}, // 23614K
			{0.253416989, 0.253463518}, // 23615K
			{0.253416298, 0.253462562}, // 23616K
			{0.253415607, 0.253461607}, // 23617K
			{0.253414917, 0.253460652}, // 23618K
			{0.253414226, 0.253459696}, // 23619K
			{0.253413535, 0.253458741}, // 23620K
			{0.253412844, 0.253457786}, // 23621K
			{0.253412154, 0.253456831}, // 23622K
			{0.253411463, 0.253455876}, // 23623K
			{0.253410773, 0.253454922}, // 23624K
			{0.253410082, 0.253453967}, // 23625K
			{0.253409392, 0.253453012}, // 23626K
			{0.253408702, 0.253452058}, // 23627K
			{0.253408012, 0.253451104}, // 23628K
			{0.253407321, 0.253450149}, // 23629K
			{0.253406631, 0.253449195}, // 23630K
			{0.253405941, 0.253448241}, // 23631K
			{0.253405251, 0.253447287}, // 23632K
			{0.253404562, 0.253446333}, // 23633K
			{0.253403872, 0.253445379}, // 23634K
			{0.253403182, 0.253444425}, // 23635K
			{0.253402493, 0.253443472}, // 23636K
			{0.253401803, 0.253442518}, // 23637K
			{0.253401113, 0.253441565}, // 23638K
			{0.253400424, 0.253440611}, // 23639K
			{0.253399735, 0.253439658}, // 23640K
			{0.253399045, 0.253438705}, // 23641K
			{0.253398356, 0.253437752}, // 23642K
			{0.253397667, 0.253436798}, // 23643K
			{0.253396978, 0.253435846}, // 23644K
			{0.253396289, 0.253434893}, // 23645K
			{0.2533956, 0.25343394}, // 23646K
			{0.253394911, 0.253432987}, // 23647K
			{0.253394222, 0.253432035}, // 23648K
			{0.253393533, 0.253431082}, // 23649K
			{0.253392845, 0.25343013}, // 23650K
			{0.253392156, 0.253429177}, // 23651K
			{0.253391468, 0.253428225}, // 23652K
			{0.253390779, 0.253427273}, // 23653K
			{0.253390091, 0.253426321}, // 23654K
			{0.253389402, 0.253425369}, // 23655K
			{0.253388714, 0.253424417}, // 23656K
			{0.253388026, 0.253423465}, // 23657K
			{0.253387338, 0.253422514}, // 23658K
			{0.25338665, 0.253421562}, // 23659K
			{0.253385962, 0.253420611}, // 23660K
			{0.253385274, 0.253419659}, // 23661K
			{0.253384586, 0.253418708}, // 23662K
			{0.253383898, 0.253417757}, // 23663K
			{0.25338321, 0.253416806}, // 23664K
			{0.253382523, 0.253415855}, // 23665K
			{0.253381835, 0.253414904}, // 23666K
			{0.253381148, 0.253413953}, // 23667K
			{0.25338046, 0.253413002}, // 23668K
			{0.253379773, 0.253412051}, // 23669K
			{0.253379085, 0.253411101}, // 23670K
			{0.253378398, 0.25341015}, // 23671K
			{0.253377711, 0.2534092}, // 23672K
			{0.253377024, 0.25340825}, // 23673K
			{0.253376337, 0.253407299}, // 23674K
			{0.25337565, 0.253406349}, // 23675K
			{0.253374963, 0.253405399}, // 23676K
			{0.253374276, 0.253404449}, // 23677K
			{0.253373589, 0.253403499}, // 23678K
			{0.253372903, 0.253402549}, // 23679K
			{0.253372216, 0.2534016}, // 23680K
			{0.253371529, 0.25340065}, // 23681K
			{0.253370843, 0.253399701}, // 23682K
			{0.253370156, 0.253398751}, // 23683K
			{0.25336947, 0.253397802}, // 23684K
			{0.253368784, 0.253396853}, // 23685K
			{0.253368098, 0.253395904}, // 23686K
			{0.253367411, 0.253394955}, // 23687K
			{0.253366725, 0.253394006}, // 23688K
			{0.253366039, 0.253393057}, // 23689K
			{0.253365353, 0.253392108}, // 23690K
			{0.253364667, 0.253391159}, // 23691K
			{0.253363982, 0.253390211}, // 23692K
			{0.253363296, 0.253389262}, // 23693K
			{0.25336261, 0.253388314}, // 23694K
			{0.253361924, 0.253387365}, // 23695K
			{0.253361239, 0.253386417}, // 23696K
			{0.253360553, 0.253385469}, // 23697K
			{0.253359868, 0.253384521}, // 23698K
			{0.253359183, 0.253383573}, // 23699K
			{0.253358497, 0.253382625}, // 23700K
			{0.253357812, 0.253381677}, // 23701K
			{0.253357127, 0.253380729}, // 23702K
			{0.253356442, 0.253379782}, // 23703K
			{0.253355757, 0.253378834}, // 23704K
			{0.253355072, 0.253377887}, // 23705K
			{0.253354387, 0.25337694}, // 23706K
			{0.253353702, 0.253375992}, // 23707K
			{0.253353018, 0.253375045}, // 23708K
			{0.253352333, 0.253374098}, // 23709K
			{0.253351648, 0.253373151}, // 23710K
			{0.253350964, 0.253372204}, // 23711K
			{0.253350279, 0.253371257}, // 23712K
			{0.253349595, 0.253370311}, // 23713K
			{0.253348911, 0.253369364}, // 23714K
			{0.253348226, 0.253368418}, // 23715K
			{0.253347542, 0.253367471}, // 23716K
			{0.253346858, 0.253366525}, // 23717K
			{0.253346174, 0.253365578}, // 23718K
			{0.25334549, 0.253364632}, // 23719K
			{0.253344806, 0.253363686}, // 23720K
			{0.253344122, 0.25336274}, // 23721K
			{0.253343438, 0.253361794}, // 23722K
			{0.253342755, 0.253360849}, // 23723K
			{0.253342071, 0.253359903}, // 23724K
			{0.253341387, 0.253358957}, // 23725K
			{0.253340704, 0.253358012}, // 23726K
			{0.25334002, 0.253357066}, // 23727K
			{0.253339337, 0.253356121}, // 23728K
			{0.253338654, 0.253355175}, // 23729K
			{0.25333797, 0.25335423}, // 23730K
			{0.253337287, 0.253353285}, // 23731K
			{0.253336604, 0.25335234}, // 23732K
			{0.253335921, 0.253351395}, // 23733K
			{0.253335238, 0.25335045}, // 23734K
			{0.253334555, 0.253349506}, // 23735K
			{0.253333872, 0.253348561}, // 23736K
			{0.253333189, 0.253347617}, // 23737K
			{0.253332507, 0.253346672}, // 23738K
			{0.253331824, 0.253345728}, // 23739K
			{0.253331142, 0.253344783}, // 23740K
			{0.253330459, 0.253343839}, // 23741K
			{0.253329777, 0.253342895}, // 23742K
			{0.253329094, 0.253341951}, // 23743K
			{0.253328412, 0.253341007}, // 23744K
			{0.25332773, 0.253340063}, // 23745K
			{0.253327047, 0.25333912}, // 23746K
			{0.253326365, 0.253338176}, // 23747K
			{0.253325683, 0.253337232}, // 23748K
			{0.253325001, 0.253336289}, // 23749K
			{0.253324319, 0.253335345}, // 23750K
			{0.253323638, 0.253334402}, // 23751K
			{0.253322956, 0.253333459}, // 23752K
			{0.253322274, 0.253332516}, // 23753K
			{0.253321592, 0.253331573}, // 23754K
			{0.253320911, 0.25333063}, // 23755K
			{0.253320229, 0.253329687}, // 23756K
			{0.253319548, 0.253328744}, // 23757K
			{0.253318867, 0.253327801}, // 23758K
			{0.253318185, 0.253326859}, // 23759K
			{0.253317504, 0.253325916}, // 23760K
			{0.253316823, 0.253324974}, // 23761K
			{0.253316142, 0.253324032}, // 23762K
			{0.253315461, 0.253323089}, // 23763K
			{0.25331478, 0.253322147}, // 23764K
			{0.253314099, 0.253321205}, // 23765K
			{0.253313418, 0.253320263}, // 23766K
			{0.253312737, 0.253319321}, // 23767K
			{0.253312057, 0.25331838}, // 23768K
			{0.253311376, 0.253317438}, // 23769K
			{0.253310695, 0.253316496}, // 23770K
			{0.253310015, 0.253315555}, // 23771K
			{0.253309334, 0.253314613}, // 23772K
			{0.253308654, 0.253313672}, // 23773K
			{0.253307974, 0.253312731}, // 23774K
			{0.253307294, 0.25331179}, // 23775K
			{0.253306613, 0.253310848}, // 23776K
			{0.253305933, 0.253309907}, // 23777K
			{0.253305253, 0.253308967}, // 23778K
			{0.253304573, 0.253308026}, // 23779K
			{0.253303893, 0.253307085}, // 23780K
			{0.253303214, 0.253306144}, // 23781K
			{0.253302534, 0.253305204}, // 23782K
			{0.253301854, 0.253304263}, // 23783K
			{0.253301175, 0.253303323}, // 23784K
			{0.253300495, 0.253302383}, // 23785K
			{0.253299816, 0.253301443}, // 23786K
			{0.253299136, 0.253300503}, // 23787K
			{0.253298457, 0.253299563}, // 23788K
			{0.253297777, 0.253298623}, // 23789K
			{0.253297098, 0.253297683}, // 23790K
			{0.253296419, 0.253296743}, // 23791K
			{0.25329574, 0.253295803}, // 23792K
			{0.253295061, 0.253294864}, // 23793K
			{0.253294382, 0.253293924}, // 23794K
			{0.253293703, 0.253292985}, // 23795K
			{0.253293024, 0.253292046}, // 23796K
			{0.253292346, 0.253291106}, // 23797K
			{0.253291667, 0.253290167}, // 23798K
			{0.253290988, 0.253289228}, // 23799K
			{0.25329031, 0.253288289}, // 23800K
			{0.253289631, 0.253287351}, // 23801K
			{0.253288953, 0.253286412}, // 23802K
			{0.253288274, 0.253285473}, // 23803K
			{0.253287596, 0.253284534}, // 23804K
			{0.253286918, 0.253283596}, // 23805K
			{0.25328624, 0.253282658}, // 23806K
			{0.253285562, 0.253281719}, // 23807K
			{0.253284884, 0.253280781}, // 23808K
			{0.253284206, 0.253279843}, // 23809K
			{0.253283528, 0.253278905}, // 23810K
			{0.25328285, 0.253277967}, // 23811K
			{0.253282172, 0.253277029}, // 23812K
			{0.253281495, 0.253276091}, // 23813K
			{0.253280817, 0.253275154}, // 23814K
			{0.253280139, 0.253274216}, // 23815K
			{0.253279462, 0.253273278}, // 23816K
			{0.253278784, 0.253272341}, // 23817K
			{0.253278107, 0.253271404}, // 23818K
			{0.25327743, 0.253270466}, // 23819K
			{0.253276753, 0.253269529}, // 23820K
			{0.253276075, 0.253268592}, // 23821K
			{0.253275398, 0.253267655}, // 23822K
			{0.253274721, 0.253266718}, // 23823K
			{0.253274044, 0.253265781}, // 23824K
			{0.253273367, 0.253264845}, // 23825K
			{0.253272691, 0.253263908}, // 23826K
			{0.253272014, 0.253262972}, // 23827K
			{0.253271337, 0.253262035}, // 23828K
			{0.253270661, 0.253261099}, // 23829K
			{0.253269984, 0.253260162}, // 23830K
			{0.253269308, 0.253259226}, // 23831K
			{0.253268631, 0.25325829}, // 23832K
			{0.253267955, 0.253257354}, // 23833K
			{0.253267278, 0.253256418}, // 23834K
			{0.253266602, 0.253255482}, // 23835K
			{0.253265926, 0.253254547}, // 23836K
			{0.25326525, 0.253253611}, // 23837K
			{0.253264574, 0.253252675}, // 23838K
			{0.253263898, 0.25325174}, // 23839K
			{0.253263222, 0.253250805}, // 23840K
			{0.253262546, 0.253249869}, // 23841K
			{0.253261871, 0.253248934}, // 23842K
			{0.253261195, 0.253247999}, // 23843K
			{0.253260519, 0.253247064}, // 23844K
			{0.253259844, 0.253246129}, // 23845K
			{0.253259168, 0.253245194}, // 23846K
			{0.253258493, 0.253244259}, // 23847K
			{0.253257817, 0.253243325}, // 23848K
			{0.253257142, 0.25324239}, // 23849K
			{0.253256467, 0.253241455}, // 23850K
			{0.253255792, 0.253240521}, // 23851K
			{0.253255117, 0.253239587}, // 23852K
			{0.253254442, 0.253238652}, // 23853K
			{0.253253767, 0.253237718}, // 23854K
			{0.253253092, 0.253236784}, // 23855K
			{0.253252417, 0.25323585}, // 23856K
			{0.253251742, 0.253234916}, // 23857K
			{0.253251067, 0.253233982}, // 23858K
			{0.253250393, 0.253233049}, // 23859K
			{0.253249718, 0.253232115}, // 23860K
			{0.253249044, 0.253231182}, // 23861K
			{0.253248369, 0.253230248}, // 23862K
			{0.253247695, 0.253229315}, // 23863K
			{0.253247021, 0.253228381}, // 23864K
			{0.253246346, 0.253227448}, // 23865K
			{0.253245672, 0.253226515}, // 23866K
			{0.253244998, 0.253225582}, // 23867K
			{0.253244324, 0.253224649}, // 23868K
			{0.25324365, 0.253223716}, // 23869K
			{0.253242976, 0.253222784}, // 23870K
			{0.253242302, 0.253221851}, // 23871K
			{0.253241629, 0.253220918}, // 23872K
			{0.253240955, 0.253219986}, // 23873K
			{0.253240281, 0.253219054}, // 23874K
			{0.253239608, 0.253218121}, // 23875K
			{0.253238934, 0.253217189}, // 23876K
			{0.253238261, 0.253216257}, // 23877K
			{0.253237587, 0.253215325}, // 23878K
			{0.253236914, 0.253214393}, // 23879K
			{0.253236241, 0.253213461}, // 23880K
			{0.253235568, 0.253212529}, // 23881K
			{0.253234895, 0.253211597}, // 23882K
			{0.253234222, 0.253210666}, // 23883K
			{0.253233549, 0.253209734}, // 23884K
			{0.253232876, 0.253208803}, // 23885K
			{0.253232203, 0.253207872}, // 23886K
			{0.25323153, 0.25320694}, // 23887K
			{0.253230857, 0.253206009}, // 23888K
			{0.253230185, 0.253205078}, // 23889K
			{0.253229512, 0.253204147}, // 23890K
			{0.25322884, 0.253203216}, // 23891K
			{0.253228167, 0.253202285}, // 23892K
			{0.253227495, 0.253201355}, // 23893K
			{0.253226822, 0.253200424}, // 23894K
			{0.25322615, 0.253199493}, // 23895K
			{0.253225478, 0.253198563}, // 23896K
			{0.253224806, 0.253197633}, // 23897K
			{0.253224134, 0.253196702}, // 23898K
			{0.253223462, 0.253195772}, // 23899K
			{0.25322279, 0.253194842}, // 23900K
			{0.253222118, 0.253193912}, // 23901K
			{0.253221446, 0.253192982}, // 23902K
			{0.253220774, 0.253192052}, // 23903K
			{0.253220103, 0.253191122}, // 23904K
			{0.253219431, 0.253190193}, // 23905K
			{0.25321876, 0.253189263}, // 23906K
			{0.253218088, 0.253188334}, // 23907K
			{0.253217417, 0.253187404}, // 23908K
			{0.253216746, 0.253186475}, // 23909K
			{0.253216074, 0.253185546}, // 23910K
			{0.253215403, 0.253184616}, // 23911K
			{0.253214732, 0.253183687}, // 23912K
			{0.253214061, 0.253182758}, // 23913K
			{0.25321339, 0.253181829}, // 23914K
			{0.253212719, 0.253180901}, // 23915K
			{0.253212048, 0.253179972}, // 23916K
			{0.253211377, 0.253179043}, // 23917K
			{0.253210706, 0.253178115}, // 23918K
			{0.253210036, 0.253177186}, // 23919K
			{0.253209365, 0.253176258}, // 23920K
			{0.253208695, 0.25317533}, // 23921K
			{0.253208024, 0.253174402}, // 23922K
			{0.253207354, 0.253173473}, // 23923K
			{0.253206683, 0.253172545}, // 23924K
			{0.253206013, 0.253171617}, // 23925K
			{0.253205343, 0.25317069}, // 23926K
			{0.253204673, 0.253169762}, // 23927K
			{0.253204003, 0.253168834}, // 23928K
			{0.253203333, 0.253167907}, // 23929K
			{0.253202663, 0.253166979}, // 23930K
			{0.253201993, 0.253166052}, // 23931K
			{0.253201323, 0.253165124}, // 23932K
			{0.253200653, 0.253164197}, // 23933K
			{0.253199984, 0.25316327}, // 23934K
			{0.253199314, 0.253162343}, // 23935K
			{0.253198644, 0.253161416}, // 23936K
			{0.253197975, 0.253160489}, // 23937K
			{0.253197305, 0.253159562}, // 23938K
			{0.253196636, 0.253158636}, // 23939K
			{0.253195967, 0.253157709}, // 23940K
			{0.253195298, 0.253156782}, // 23941K
			{0.253194628, 0.253155856}, // 23942K
			{0.253193959, 0.25315493}, // 23943K
			{0.25319329, 0.253154003}, // 23944K
			{0.253192621, 0.253153077}, // 23945K
			{0.253191952, 0.253152151}, // 23946K
			{0.253191284, 0.253151225}, // 23947K
			{0.253190615, 0.253150299}, // 23948K
			{0.253189946, 0.253149373}, // 23949K
			{0.253189277, 0.253148448}, // 23950K
			{0.253188609, 0.253147522}, // 23951K
			{0.25318794, 0.253146596}, // 23952K
			{0.253187272, 0.253145671}, // 23953K
			{0.253186604, 0.253144745}, // 23954K
			{0.253185935, 0.25314382}, // 23955K
			{0.253185267, 0.253142895}, // 23956K
			{0.253184599, 0.25314197}, // 23957K
			{0.253183931, 0.253141045}, // 23958K
			{0.253183263, 0.25314012}, // 23959K
			{0.253182595, 0.253139195}, // 23960K
			{0.253181927, 0.25313827}, // 23961K
			{0.253181259, 0.253137345}, // 23962K
			{0.253180591, 0.253136421}, // 23963K
			{0.253179923, 0.253135496}, // 23964K
			{0.253179256, 0.253134572}, // 23965K
			{0.253178588, 0.253133647}, // 23966K
			{0.25317792, 0.253132723}, // 23967K
			{0.253177253, 0.253131799}, // 23968K
			{0.253176586, 0.253130875}, // 23969K
			{0.253175918, 0.253129951}, // 23970K
			{0.253175251, 0.253129027}, // 23971K
			{0.253174584, 0.253128103}, // 23972K
			{0.253173917, 0.253127179}, // 23973K
			{0.25317325, 0.253126256}, // 23974K
			{0.253172583, 0.253125332}, // 23975K
			{0.253171916, 0.253124408}, // 23976K
			{0.253171249, 0.253123485}, // 23977K
			{0.253170582, 0.253122562}, // 23978K
			{0.253169915, 0.253121638}, // 23979K
			{0.253169248, 0.253120715}, // 23980K
			{0.253168582, 0.253119792}, // 23981K
			{0.253167915, 0.253118869}, // 23982K
			{0.253167249, 0.253117946}, // 23983K
			{0.253166582, 0.253117024}, // 23984K
			{0.253165916, 0.253116101}, // 23985K
			{0.25316525, 0.253115178}, // 23986K
			{0.253164583, 0.253114256}, // 23987K
			{0.253163917, 0.253113333}, // 23988K
			{0.253163251, 0.253112411}, // 23989K
			{0.253162585, 0.253111489}, // 23990K
			{0.253161919, 0.253110566}, // 23991K
			{0.253161253, 0.253109644}, // 23992K
			{0.253160587, 0.253108722}, // 23993K
			{0.253159922, 0.2531078}, // 23994K
			{0.253159256, 0.253106879}, // 23995K
			{0.25315859, 0.253105957}, // 23996K
			{0.253157925, 0.253105035}, // 23997K
			{0.253157259, 0.253104114}, // 23998K
			{0.253156594, 0.253103192}, // 23999K
			{0.253155928, 0.253102271}, // 24000K
			{0.253155263, 0.253101349}, // 24001K
			{0.253154598, 0.253100428}, // 24002K
			{0.253153933, 0.253099507}, // 24003K
			{0.253153267, 0.253098586}, // 24004K
			{0.253152602, 0.253097665}, // 24005K
			{0.253151937, 0.253096744}, // 24006K
			{0.253151273, 0.253095823}, // 24007K
			{0.253150608, 0.253094902}, // 24008K
			{0.253149943, 0.253093982}, // 24009K
			{0.253149278, 0.253093061}, // 24010K
			{0.253148613, 0.253092141}, // 24011K
			{0.253147949, 0.25309122}, // 24012K
			{0.253147284, 0.2530903}, // 24013K
			{0.25314662, 0.25308938}, // 24014K
			{0.253145955, 0.25308846}, // 24015K
			{0.253145291, 0.25308754}, // 24016K
			{0.253144627, 0.25308662}, // 24017K
			{0.253143963, 0.2530857}, // 24018K
			{0.253143298, 0.25308478}, // 24019K
			{0.253142634, 0.25308386}, // 24020K
			{0.25314197, 0.253082941}, // 24021K
			{0.253141306, 0.253082021}, // 24022K
			{0.253140642, 0.253081102}, // 24023K
			{0.253139979, 0.253080182}, // 24024K
			{0.253139315, 0.253079263}, // 24025K
			{0.253138651, 0.253078344}, // 24026K
			{0.253137987, 0.253077425}, // 24027K
			{0.253137324, 0.253076506}, // 24028K
			{0.25313666, 0.253075587}, // 24029K
			{0.253135997, 0.253074668}, // 24030K
			{0.253135334, 0.253073749}, // 24031K
			{0.25313467, 0.253072831}, // 24032K
			{0.253134007, 0.253071912}, // 24033K
			{0.253133344, 0.253070994}, // 24034K
			{0.253132681, 0.253070075}, // 24035K
			{0.253132018, 0.253069157}, // 24036K
			{0.253131355, 0.253068239}, // 24037K
			{0.253130692, 0.253067321}, // 24038K
			{0.253130029, 0.253066403}, // 24039K
			{0.253129366, 0.253065485}, // 24040K
			{0.253128703, 0.253064567}, // 24041K
			{0.253128041, 0.253063649}, // 24042K
			{0.253127378, 0.253062731}, // 24043K
			{0.253126715, 0.253061814}, // 24044K
			{0.253126053, 0.253060896}, // 24045K
			{0.253125391, 0.253059979}, // 24046K
			{0.253124728, 0.253059061}, // 24047K
			{0.253124066, 0.253058144}, // 24048K
			{0.253123404, 0.253057227}, // 24049K
			{0.253122742, 0.25305631}, // 24050K
			{0.25312208, 0.253055393}, // 24051K
			{0.253121417, 0.253054476}, // 24052K
			{0.253120756, 0.253053559}, // 24053K
			{0.253120094, 0.253052642}, // 24054K
			{0.253119432, 0.253051725}, // 24055K
			{0.25311877, 0.253050809}, // 24056K
			{0.253118108, 0.253049892}, // 24057K
			{0.253117447, 0.253048976}, // 24058K
			{0.253116785, 0.25304806}, // 24059K
			{0.253116124, 0.253047143}, // 24060K
			{0.253115462, 0.253046227}, // 24061K
			{0.253114801, 0.253045311}, // 24062K
			{0.253114139, 0.253044395}, // 24063K
			{0.253113478, 0.253043479}, // 24064K
			{0.253112817, 0.253042563}, // 24065K
			{0.253112156, 0.253041648}, // 24066K
			{0.253111495, 0.253040732}, // 24067K
			{0.253110834, 0.253039816}, // 24068K
			{0.253110173, 0.253038901}, // 24069K
			{0.253109512, 0.253037985}, // 24070K
			{0.253108851, 0.25303707}, // 24071K
			{0.253108191, 0.253036155}, // 24072K
			{0.25310753, 0.25303524}, // 24073K
			{0.253106869, 0.253034325}, // 24074K
			{0.253106209, 0.25303341}, // 24075K
			{0.253105548, 0.253032495}, // 24076K
			{0.253104888, 0.25303158}, // 24077K
			{0.253104227, 0.253030665}, // 24078K
			{0.253103567, 0.253029751}, // 24079K
			{0.253102907, 0.253028836}, // 24080K
			{0.253102247, 0.253027922}, // 24081K
			{0.253101587, 0.253027007}, // 24082K
			{0.253100927, 0.253026093}, // 24083K
			{0.253100267, 0.253025179}, // 24084K
			{0.253099607, 0.253024265}, // 24085K
			{0.253098947, 0.253023351}, // 24086K
			{0.253098287, 0.253022437}, // 24087K
			{0.253097627, 0.253021523}, // 24088K
			{0.253096968, 0.253020609}, // 24089K
			{0.253096308, 0.253019695}, // 24090K
			{0.253095649, 0.253018782}, // 24091K
			{0.253094989, 0.253017868}, // 24092K
			{0.25309433, 0.253016955}, // 24093K
			{0.253093671, 0.253016042}, // 24094K
			{0.253093011, 0.253015128}, // 24095K
			{0.253092352, 0.253014215}, // 24096K
			{0.253091693, 0.253013302}, // 24097K
			{0.253091034, 0.253012389}, // 24098K
			{0.253090375, 0.253011476}, // 24099K
			{0.253089716, 0.253010563}, // 24100K
			{0.253089057, 0.253009651}, // 24101K
			{0.253088398, 0.253008738}, // 24102K
			{0.253087739, 0.253007825}, // 24103K
			{0.253087081, 0.253006913}, // 24104K
			{0.253086422, 0.253006}, // 24105K
			{0.253085764, 0.253005088}, // 24106K
			{0.253085105, 0.253004176}, // 24107K
			{0.253084447, 0.253003264}, // 24108K
			{0.253083788, 0.253002352}, // 24109K
			{0.25308313, 0.25300144}, // 24110K
			{0.253082472, 0.253000528}, // 24111K
			{0.253081814, 0.252999616}, // 24112K
			{0.253081155, 0.252998704}, // 24113K
			{0.253080497, 0.252997793}, // 24114K
			{0.253079839, 0.252996881}, // 24115K
			{0.253079182, 0.25299597}, // 24116K
			{0.253078524, 0.252995058}, // 24117K
			{0.253077866, 0.252994147}, // 24118K
			{0.253077208, 0.252993236}, // 24119K
			{0.25307655, 0.252992324}, // 24120K
			{0.253075893, 0.252991413}, // 24121K
			{0.253075235, 0.252990502}, // 24122K
			{0.253074578, 0.252989592}, // 24123K
			{0.25307392, 0.252988681}, // 24124K
			{0.253073263, 0.25298777}, // 24125K
			{0.253072606, 0.252986859}, // 24126K
			{0.253071949, 0.252985949}, // 24127K
			{0.253071291, 0.252985038}, // 24128K
			{0.253070634, 0.252984128}, // 24129K
			{0.253069977, 0.252983218}, // 24130K
			{0.25306932, 0.252982308}, // 24131K
			{0.253068663, 0.252981398}, // 24132K
			{0.253068007, 0.252980488}, // 24133K
			{0.25306735, 0.252979578}, // 24134K
			{0.253066693, 0.252978668}, // 24135K
			{0.253066036, 0.252977758}, // 24136K
			{0.25306538, 0.252976848}, // 24137K
			{0.253064723, 0.252975939}, // 24138K
			{0.253064067, 0.252975029}, // 24139K
			{0.253063411, 0.25297412}, // 24140K
			{0.253062754, 0.25297321}, // 24141K
			{0.253062098, 0.252972301}, // 24142K
			{0.253061442, 0.252971392}, // 24143K
			{0.253060786, 0.252970483}, // 24144K
			{0.25306013, 0.252969574}, // 24145K
			{0.253059474, 0.252968665}, // 24146K
			{0.253058818, 0.252967756}, // 24147K
			{0.253058162, 0.252966847}, // 24148K
			{0.253057506, 0.252965939}, // 24149K
			{0.25305685, 0.25296503}, // 24150K
			{0.253056194, 0.252964122}, // 24151K
			{0.253055539, 0.252963213}, // 24152K
			{0.253054883, 0.252962305}, // 24153K
			{0.253054228, 0.252961397}, // 24154K
			{0.253053572, 0.252960488}, // 24155K
			{0.253052917, 0.25295958}, // 24156K
			{0.253052262, 0.252958672}, // 24157K
			{0.253051606, 0.252957764}, // 24158K
			{0.253050951, 0.252956857}, // 24159K
			{0.253050296, 0.252955949}, // 24160K
			{0.253049641, 0.252955041}, // 24161K
			{0.253048986, 0.252954134}, // 24162K
			{0.253048331, 0.252953226}, // 24163K
			{0.253047676, 0.252952319}, // 24164K
			{0.253047021, 0.252951411}, // 24165K
			{0.253046367, 0.252950504}, // 24166K
			{0.253045712, 0.252949597}, // 24167K
			{0.253045057, 0.25294869}, // 24168K
			{0.253044403, 0.252947783}, // 24169K
			{0.253043748, 0.252946876}, // 24170K
			{0.253043094, 0.252945969}, // 24171K
			{0.25304244, 0.252945062}, // 24172K
			{0.253041785, 0.252944156}, // 24173K
			{0.253041131, 0.252943249}, // 24174K
			{0.253040477, 0.252942343}, // 24175K
			{0.253039823, 0.252941436}, // 24176K
			{0.253039169, 0.25294053}, // 24177K
			{0.253038515, 0.252939624}, // 24178K
			{0.253037861, 0.252938718}, // 24179K
			{0.253037207, 0.252937812}, // 24180K
			{0.253036553, 0.252936906}, // 24181K
			{0.253035899, 0.252936}, // 24182K
			{0.253035246, 0.252935094}, // 24183K
			{0.253034592, 0.252934188}, // 24184K
			{0.253033939, 0.252933283}, // 24185K
			{0.253033285, 0.252932377}, // 24186K
			{0.253032632, 0.252931472}, // 24187K
			{0.253031978, 0.252930566}, // 24188K
			{0.253031325, 0.252929661}, // 24189K
			{0.253030672, 0.252928756}, // 24190K
			{0.253030019, 0.252927851}, // 24191K
			{0.253029366, 0.252926946}, // 24192K
			{0.253028713, 0.252926041}, // 24193K
			{0.25302806, 0.252925136}, // 24194K
			{0.253027407, 0.252924231}, // 24195K
			{0.253026754, 0.252923326}, // 24196K
			{0.253026101, 0.252922422}, // 24197K
			{0.253025448, 0.252921517}, // 24198K
			{0.253024796, 0.252920613}, // 24199K
			{0.253024143, 0.252919708}, // 24200K
			{0.253023491, 0.252918804}, // 24201K
			{0.253022838, 0.2529179}, // 24202K
			{0.253022186, 0.252916996}, // 24203K
			{0.253021533, 0.252916092}, // 24204K
			{0.253020881, 0.252915188}, // 24205K
			{0.253020229, 0.252914284}, // 24206K
			{0.253019577, 0.25291338}, // 24207K
			{0.253018925, 0.252912476}, // 24208K
			{0.253018273, 0.252911573}, // 24209K
			{0.253017621, 0.252910669}, // 24210K
			{0.253016969, 0.252909766}, // 24211K
			{0.253016317, 0.252908862}, // 24212K
			{0.253015665, 0.252907959}, // 24213K
			{0.253015014, 0.252907056}, // 24214K
			{0.253014362, 0.252906153}, // 24215K
			{0.25301371, 0.25290525}, // 24216K
			{0.253013059, 0.252904347}, // 24217K
			{0.253012407, 0.252903444}, // 24218K
			{0.253011756, 0.252902541}, // 24219K
			{0.253011105, 0.252901639}, // 24220K
			{0.253010453, 0.252900736}, // 24221K
			{0.253009802, 0.252899834}, // 24222K
			{0.253009151, 0.252898931}, // 24223K
			{0.2530085, 0.252898029}, // 24224K
			{0.253007849, 0.252897126}, // 24225K
			{0.253007198, 0.252896224}, // 24226K
			{0.253006547, 0.252895322}, // 24227K
			{0.253005896, 0.25289442}, // 24228K
			{0.253005245, 0.252893518}, // 24229K
			{0.253004595, 0.252892616}, // 24230K
			{0.253003944, 0.252891715}, // 24231K
			{0.253003294, 0.252890813}, // 24232K
			{0.253002643, 0.252889911}, // 24233K
			{0.253001993, 0.25288901}, // 24234K
			{0.253001342, 0.252888108}, // 24235K
			{0.253000692, 0.252887207}, // 24236K
			{0.253000042, 0.252886306}, // 24237K
			{0.252999391, 0.252885405}, // 24238K
			{0.252998741, 0.252884503}, // 24239K
			{0.252998091, 0.252883602}, // 24240K
			{0.252997441, 0.252882702}, // 24241K
			{0.252996791, 0.252881801}, // 24242K
			{0.252996141, 0.2528809}, // 24243K
			{0.252995492, 0.252879999}, // 24244K
			{0.252994842, 0.252879099}, // 24245K
			{0.252994192, 0.252878198}, // 24246K
			{0.252993542, 0.252877298}, // 24247K
			{0.252992893, 0.252876397}, // 24248K
			{0.252992243, 0.252875497}, // 24249K
			{0.252991594, 0.252874597}, // 24250K
			{0.252990945, 0.252873697}, // 24251K
			{0.252990295, 0.252872797}, // 24252K
			{0.252989646, 0.252871897}, // 24253K
			{0.252988997, 0.252870997}, // 24254K
			{0.252988348, 0.252870097}, // 24255K
			{0.252987699, 0.252869198}, // 24256K
			{0.25298705, 0.252868298}, // 24257K
			{0.252986401, 0.252867398}, // 24258K
			{0.252985752, 0.252866499}, // 24259K
			{0.252985103, 0.2528656}, // 24260K
			{0.252984454, 0.2528647}, // 24261K
			{0.252983805, 0.252863801}, // 24262K
			{0.252983157, 0.252862902}, // 24263K
			{0.252982508, 0.252862003}, // 24264K
			{0.25298186, 0.252861104}, // 24265K
			{0.252981211, 0.252860205}, // 24266K
			{0.252980563, 0.252859307}, // 24267K
			{0.252979915, 0.252858408}, // 24268K
			{0.252979266, 0.252857509}, // 24269K
			{0.252978618, 0.252856611}, // 24270K
			{0.25297797, 0.252855712}, // 24271K
			{0.252977322, 0.252854814}, // 24272K
			{0.252976674, 0.252853916}, // 24273K
			{0.252976026, 0.252853018}, // 24274K
			{0.252975378, 0.25285212}, // 24275K
			{0.25297473, 0.252851222}, // 24276K
			{0.252974082, 0.252850324}, // 24277K
			{0.252973435, 0.252849426}, // 24278K
			{0.252972787, 0.252848528}, // 24279K
			{0.25297214, 0.25284763}, // 24280K
			{0.252971492, 0.252846733}, // 24281K
			{0.252970845, 0.252845835}, // 24282K
			{0.252970197, 0.252844938}, // 24283K
			{0.25296955, 0.25284404}, // 24284K
			{0.252968903, 0.252843143}, // 24285K
			{0.252968255, 0.252842246}, // 24286K
			{0.252967608, 0.252841349}, // 24287K
			{0.252966961, 0.252840452}, // 24288K
			{0.252966314, 0.252839555}, // 24289K
			{0.252965667, 0.252838658}, // 24290K
			{0.25296502, 0.252837761}, // 24291K
			{0.252964374, 0.252836865}, // 24292K
			{0.252963727, 0.252835968}, // 24293K
			{0.25296308, 0.252835072}, // 24294K
			{0.252962433, 0.252834175}, // 24295K
			{0.252961787, 0.252833279}, // 24296K
			{0.25296114, 0.252832383}, // 24297K
			{0.252960494, 0.252831486}, // 24298K
			{0.252959848, 0.25283059}, // 24299K
			{0.252959201, 0.252829694}, // 24300K
			{0.252958555, 0.252828798}, // 24301K
			{0.252957909, 0.252827902}, // 24302K
			{0.252957263, 0.252827007}, // 24303K
			{0.252956617, 0.252826111}, // 24304K
			{0.25295597, 0.252825215}, // 24305K
			{0.252955325, 0.25282432}, // 24306K
			{0.252954679, 0.252823424}, // 24307K
			{0.252954033, 0.252822529}, // 24308K
			{0.252953387, 0.252821634}, // 24309K
			{0.252952741, 0.252820739}, // 24310K
			{0.252952096, 0.252819844}, // 24311K
			{0.25295145, 0.252818948}, // 24312K
			{0.252950805, 0.252818054}, // 24313K
			{0.252950159, 0.252817159}, // 24314K
			{0.252949514, 0.252816264}, // 24315K
			{0.252948868, 0.252815369}, // 24316K
			{0.252948223, 0.252814475}, // 24317K
			{0.252947578, 0.25281358}, // 24318K
			{0.252946933, 0.252812686}, // 24319K
			{0.252946288, 0.252811791}, // 24320K
			{0.252945643, 0.252810897}, // 24321K
			{0.252944998, 0.252810003}, // 24322K
			{0.252944353, 0.252809109}, // 24323K
			{0.252943708, 0.252808215}, // 24324K
			{0.252943063, 0.252807321}, // 24325K
			{0.252942418, 0.252806427}, // 24326K
			{0.252941774, 0.252805533}, // 24327K
			{0.252941129, 0.252804639}, // 24328K
			{0.252940485, 0.252803746}, // 24329K
			{0.25293984, 0.252802852}, // 24330K
			{0.252939196, 0.252801959}, // 24331K
			{0.252938552, 0.252801065}, // 24332K
			{0.252937907, 0.252800172}, // 24333K
			{0.252937263, 0.252799279}, // 24334K
			{0.252936619, 0.252798386}, // 24335K
			{0.252935975, 0.252797493}, // 24336K
			{0.252935331, 0.2527966}, // 24337K
			{0.252934687, 0.252795707}, // 24338K
			{0.252934043, 0.252794814}, // 24339K
			{0.252933399, 0.252793921}, // 24340K
			{0.252932755, 0.252793029}, // 24341K
			{0.252932112, 0.252792136}, // 24342K
			{0.252931468, 0.252791244}, // 24343K
			{0.252930824, 0.252790351}, // 24344K
			{0.252930181, 0.252789459}, // 24345K
			{0.252929537, 0.252788567}, // 24346K
			{0.252928894, 0.252787675}, // 24347K
			{0.25292825, 0.252786783}, // 24348K
			{0.252927607, 0.252785891}, // 24349K
			{0.252926964, 0.252784999}, // 24350K
			{0.252926321, 0.252784107}, // 24351K
			{0.252925678, 0.252783215}, // 24352K
			{0.252925035, 0.252782324}, // 24353K
			{0.252924392, 0.252781432}, // 24354K
			{0.252923749, 0.252780541}, // 24355K
			{0.252923106, 0.252779649}, // 24356K
			{0.252922463, 0.252778758}, // 24357K
			{0.25292182, 0.252777867}, // 24358K
			{0.252921178, 0.252776976}, // 24359K
			{0.252920535, 0.252776085}, // 24360K
			{0.252919893, 0.252775194}, // 24361K
			{0.25291925, 0.252774303}, // 24362K
			{0.252918608, 0.252773412}, // 24363K
			{0.252917965, 0.252772521}, // 24364K
			{0.252917323, 0.252771631}, // 24365K
			{0.252916681, 0.25277074}, // 24366K
			{0.252916039, 0.252769849}, // 24367K
			{0.252915396, 0.252768959}, // 24368K
			{0.252914754, 0.252768069}, // 24369K
			{0.252914112, 0.252767179}, // 24370K
			{0.25291347, 0.252766288}, // 24371K
			{0.252912829, 0.252765398}, // 24372K
			{0.252912187, 0.252764508}, // 24373K
			{0.252911545, 0.252763618}, // 24374K
			{0.252910903, 0.252762729}, // 24375K
			{0.252910262, 0.252761839}, // 24376K
			{0.25290962, 0.252760949}, // 24377K
			{0.252908979, 0.25276006}, // 24378K
			{0.252908337, 0.25275917}, // 24379K
			{0.252907696, 0.252758281}, // 24380K
			{0.252907054, 0.252757391}, // 24381K
			{0.252906413, 0.252756502}, // 24382K
			{0.252905772, 0.252755613}, // 24383K
			{0.252905131, 0.252754724}, // 24384K
			{0.25290449, 0.252753835}, // 24385K
			{0.252903849, 0.252752946}, // 24386K
			{0.252903208, 0.252752057}, // 24387K
			{0.252902567, 0.252751168}, // 24388K
			{0.252901926, 0.25275028}, // 24389K
			{0.252901285, 0.252749391}, // 24390K
			{0.252900645, 0.252748503}, // 24391K
			{0.252900004, 0.252747614}, // 24392K
			{0.252899363, 0.252746726}, // 24393K
			{0.252898723, 0.252745837}, // 24394K
			{0.252898082, 0.252744949}, // 24395K
			{0.252897442, 0.252744061}, // 24396K
			{0.252896802, 0.252743173}, // 24397K
			{0.252896161, 0.252742285}, // 24398K
			{0.252895521, 0.252741397}, // 24399K
			{0.252894881, 0.25274051}, // 24400K
			{0.252894241, 0.252739622}, // 24401K
			{0.252893601, 0.252738734}, // 24402K
			{0.252892961, 0.252737847}, // 24403K
			{0.252892321, 0.252736959}, // 24404K
			{0.252891681, 0.252736072}, // 24405K
			{0.252891041, 0.252735185}, // 24406K
			{0.252890402, 0.252734297}, // 24407K
			{0.252889762, 0.25273341}, // 24408K
			{0.252889122, 0.252732523}, // 24409K
			{0.252888483, 0.252731636}, // 24410K
			{0.252887843, 0.252730749}, // 24411K
			{0.252887204, 0.252729863}, // 24412K
			{0.252886565, 0.252728976}, // 24413K
			{0.252885925, 0.252728089}, // 24414K
			{0.252885286, 0.252727203}, // 24415K
			{0.252884647, 0.252726316}, // 24416K
			{0.252884008, 0.25272543}, // 24417K
			{0.252883369, 0.252724544}, // 24418K
			{0.25288273, 0.252723657}, // 24419K
			{0.252882091, 0.252722771}, // 24420K
			{0.252881452, 0.252721885}, // 24421K
			{0.252880813, 0.252720999}, // 24422K
			{0.252880175, 0.252720113}, // 24423K
			{0.252879536, 0.252719227}, // 24424K
			{0.252878897, 0.252718342}, // 24425K
			{0.252878259, 0.252717456}, // 24426K
			{0.25287762, 0.25271657}, // 24427K
			{0.252876982, 0.252715685}, // 24428K
			{0.252876343, 0.2527148}, // 24429K
			{0.252875705, 0.252713914}, // 24430K
			{0.252875067, 0.252713029}, // 24431K
			{0.252874429, 0.252712144}, // 24432K
			{0.25287379, 0.252711259}, // 24433K
			{0.252873152, 0.252710374}, // 24434K
			{0.252872514, 0.252709489}, // 24435K
			{0.252871876, 0.252708604}, // 24436K
			{0.252871239, 0.252707719}, // 24437K
			{0.252870601, 0.252706835}, // 24438K
			{0.252869963, 0.25270595}, // 24439K
			{0.252869325, 0.252705065}, // 24440K
			{0.252868688, 0.252704181}, // 24441K
			{0.25286805, 0.252703297}, // 24442K
			{0.252867412, 0.252702412}, // 24443K
			{0.252866775, 0.252701528}, // 24444K
			{0.252866138, 0.252700644}, // 24445K
			{0.2528655, 0.25269976}, // 24446K
			{0.252864863, 0.252698876}, // 24447K
			{0.252864226, 0.252697992}, // 24448K
			{0.252863589, 0.252697109}, // 24449K
			{0.252862952, 0.252696225}, // 24450K
			{0.252862314, 0.252695341}, // 24451K
			{0.252861678, 0.252694458}, // 24452K
			{0.252861041, 0.252693574}, // 24453K
			{0.252860404, 0.252692691}, // 24454K
			{0.252859767, 0.252691808}, // 24455K
			{0.25285913, 0.252690924}, // 24456K
			{0.252858494, 0.252690041}, // 24457K
			{0.252857857, 0.252689158}, // 24458K
			{0.25285722, 0.252688275}, // 24459K
			{0.252856584, 0.252687392}, // 24460K
			{0.252855947, 0.252686509}, // 24461K
			{0.252855311, 0.252685627}, // 24462K
			{0.252854675, 0.252684744}, // 24463K
			{0.252854039, 0.252683862}, // 24464K
			{0.252853402, 0.252682979}, // 24465K
			{0.252852766, 0.252682097}, // 24466K
			{0.25285213, 0.252681214}, // 24467K
			{0.252851494, 0.252680332}, // 24468K
			{0.252850858, 0.25267945}, // 24469K
			{0.252850222, 0.252678568}, // 24470K
			{0.252849587, 0.252677686}, // 24471K
			{0.252848951, 0.252676804}, // 24472K
			{0.252848315, 0.252675922}, // 24473K
			{0.252847679, 0.25267504}, // 24474K
			{0.252847044, 0.252674159}, // 24475K
			{0.252846408, 0.252673277}, // 24476K
			{0.252845773, 0.252672396}, // 24477K
			{0.252845138, 0.252671514}, // 24478K
			{0.252844502, 0.252670633}, // 24479K
			{0.252843867, 0.252669752}, // 24480K
			{0.252843232, 0.25266887}, // 24481K
			{0.252842597, 0.252667989}, // 24482K
			{0.252841961, 0.252667108}, // 24483K
			{0.252841326, 0.252666227}, // 24484K
			{0.252840691, 0.252665346}, // 24485K
			{0.252840057, 0.252664466}, // 24486K
			{0.252839422, 0.252663585}, // 24487K
			{0.252838787, 0.252662704}, // 24488K
			{0.252838152, 0.252661824}, // 24489K
			{0.252837518, 0.252660943}, // 24490K
			{0.252836883, 0.252660063}, // 24491K
			{0.252836248, 0.252659183}, // 24492K
			{0.252835614, 0.252658302}, // 24493K
			{0.252834979, 0.252657422}, // 24494K
			{0.252834345, 0.252656542}, // 24495K
			{0.252833711, 0.252655662}, // 24496K
			{0.252833077, 0.252654782}, // 24497K
			{0.252832442, 0.252653903}, // 24498K
			{0.252831808, 0.252653023}, // 24499K
			{0.252831174, 0.252652143}, // 24500K
			{0.25283054, 0.252651264}, // 24501K
			{0.252829906, 0.252650384}, // 24502K
			{0.252829272, 0.252649505}, // 24503K
			{0.252828639, 0.252648625}, // 24504K
			{0.252828005, 0.252647746}, // 24505K
			{0.252827371, 0.252646867}, // 24506K
			{0.252826737, 0.252645988}, // 24507K
			{0.252826104, 0.252645109}, // 24508K
			{0.25282547, 0.25264423}, // 24509K
			{0.252824837, 0.252643351}, // 24510K
			{0.252824203, 0.252642472}, // 24511K
			{0.25282357, 0.252641594}, // 24512K
			{0.252822937, 0.252640715}, // 24513K
			{0.252822304, 0.252639837}, // 24514K
			{0.25282167, 0.252638958}, // 24515K
			{0.252821037, 0.25263808}, // 24516K
			{0.252820404, 0.252637202}, // 24517K
			{0.252819771, 0.252636323}, // 24518K
			{0.252819138, 0.252635445}, // 24519K
			{0.252818506, 0.252634567}, // 24520K
			{0.252817873, 0.252633689}, // 24521K
			{0.25281724, 0.252632811}, // 24522K
			{0.252816607, 0.252631934}, // 24523K
			{0.252815975, 0.252631056}, // 24524K
			{0.252815342, 0.252630178}, // 24525K
			{0.25281471, 0.252629301}, // 24526K
			{0.252814077, 0.252628423}, // 24527K
			{0.252813445, 0.252627546}, // 24528K
			{0.252812813, 0.252626669}, // 24529K
			{0.25281218, 0.252625791}, // 24530K
			{0.252811548, 0.252624914}, // 24531K
			{0.252810916, 0.252624037}, // 24532K
			{0.252810284, 0.25262316}, // 24533K
			{0.252809652, 0.252622283}, // 24534K
			{0.25280902, 0.252621406}, // 24535K
			{0.252808388, 0.25262053}, // 24536K
			{0.252807756, 0.252619653}, // 24537K
			{0.252807125, 0.252618776}, // 24538K
			{0.252806493, 0.2526179}, // 24539K
			{0.252805861, 0.252617023}, // 24540K
			{0.25280523, 0.252616147}, // 24541K
			{0.252804598, 0.252615271}, // 24542K
			{0.252803967, 0.252614395}, // 24543K
			{0.252803335, 0.252613518}, // 24544K
			{0.252802704, 0.252612642}, // 24545K
			{0.252802073, 0.252611767}, // 24546K
			{0.252801441, 0.252610891}, // 24547K
			{0.25280081, 0.252610015}, // 24548K
			{0.252800179, 0.252609139}, // 24549K
			{0.252799548, 0.252608264}, // 24550K
			{0.252798917, 0.252607388}, // 24551K
			{0.252798286, 0.252606513}, // 24552K
			{0.252797655, 0.252605637}, // 24553K
			{0.252797024, 0.252604762}, // 24554K
			{0.252796394, 0.252603887}, // 24555K
			{0.252795763, 0.252603011}, // 24556K
			{0.252795132, 0.252602136}, // 24557K
			{0.252794502, 0.252601261}, // 24558K
			{0.252793871, 0.252600387}, // 24559K
			{0.252793241, 0.252599512}, // 24560K
			{0.25279261, 0.252598637}, // 24561K
			{0.25279198, 0.252597762}, // 24562K
			{0.25279135, 0.252596888}, // 24563K
			{0.25279072, 0.252596013}, // 24564K
			{0.252790089, 0.252595139}, // 24565K
			{0.252789459, 0.252594264}, // 24566K
			{0.252788829, 0.25259339}, // 24567K
			{0.252788199, 0.252592516}, // 24568K
			{0.252787569, 0.252591642}, // 24569K
			{0.25278694, 0.252590768}, // 24570K
			{0.25278631, 0.252589894}, // 24571K
			{0.25278568, 0.25258902}, // 24572K
			{0.25278505, 0.252588146}, // 24573K
			{0.252784421, 0.252587273}, // 24574K
			{0.252783791, 0.252586399}, // 24575K
			{0.252783162, 0.252585525}, // 24576K
			{0.252782532, 0.252584652}, // 24577K
			{0.252781903, 0.252583779}, // 24578K
			{0.252781274, 0.252582905}, // 24579K
			{0.252780644, 0.252582032}, // 24580K
			{0.252780015, 0.252581159}, // 24581K
			{0.252779386, 0.252580286}, // 24582K
			{0.252778757, 0.252579413}, // 24583K
			{0.252778128, 0.25257854}, // 24584K
			{0.252777499, 0.252577667}, // 24585K
			{0.25277687, 0.252576794}, // 24586K
			{0.252776241, 0.252575922}, // 24587K
			{0.252775612, 0.252575049}, // 24588K
			{0.252774984, 0.252574177}, // 24589K
			{0.252774355, 0.252573304}, // 24590K
			{0.252773727, 0.252572432}, // 24591K
			{0.252773098, 0.25257156}, // 24592K
			{0.25277247, 0.252570687}, // 24593K
			{0.252771841, 0.252569815}, // 24594K
			{0.252771213, 0.252568943}, // 24595K
			{0.252770584, 0.252568071}, // 24596K
			{0.252769956, 0.252567199}, // 24597K
			{0.252769328, 0.252566328}, // 24598K
			{0.2527687, 0.252565456}, // 24599K
			{0.252768072, 0.252564584}, // 24600K
			{0.252767444, 0.252563713}, // 24601K
			{0.252766816, 0.252562841}, // 24602K
			{0.252766188, 0.25256197}, // 24603K
			{0.25276556, 0.252561099}, // 24604K
			{0.252764932, 0.252560227}, // 24605K
			{0.252764305, 0.252559356}, // 24606K
			{0.252763677, 0.252558485}, // 24607K
			{0.25276305, 0.252557614}, // 24608K
			{0.252762422, 0.252556743}, // 24609K
			{0.252761795, 0.252555872}, // 24610K
			{0.252761167, 0.252555002}, // 24611K
			{0.25276054, 0.252554131}, // 24612K
			{0.252759913, 0.25255326}, // 24613K
			{0.252759285, 0.25255239}, // 24614K
			{0.252758658, 0.252551519}, // 24615K
			{0.252758031, 0.252550649}, // 24616K
			{0.252757404, 0.252549779}, // 24617K
			{0.252756777, 0.252548909}, // 24618K
			{0.25275615, 0.252548039}, // 24619K
			{0.252755523, 0.252547168}, // 24620K
			{0.252754896, 0.252546299}, // 24621K
			{0.25275427, 0.252545429}, // 24622K
			{0.252753643, 0.252544559}, // 24623K
			{0.252753016, 0.252543689}, // 24624K
			{0.25275239, 0.252542819}, // 24625K
			{0.252751763, 0.25254195}, // 24626K
			{0.252751137, 0.25254108}, // 24627K
			{0.25275051, 0.252540211}, // 24628K
			{0.252749884, 0.252539342}, // 24629K
			{0.252749258, 0.252538472}, // 24630K
			{0.252748632, 0.252537603}, // 24631K
			{0.252748005, 0.252536734}, // 24632K
			{0.252747379, 0.252535865}, // 24633K
			{0.252746753, 0.252534996}, // 24634K
			{0.252746127, 0.252534127}, // 24635K
			{0.252745501, 0.252533259}, // 24636K
			{0.252744876, 0.25253239}, // 24637K
			{0.25274425, 0.252531521}, // 24638K
			{0.252743624, 0.252530653}, // 24639K
			{0.252742998, 0.252529784}, // 24640K
			{0.252742373, 0.252528916}, // 24641K
			{0.252741747, 0.252528048}, // 24642K
			{0.252741122, 0.25252718}, // 24643K
			{0.252740496, 0.252526311}, // 24644K
			{0.252739871, 0.252525443}, // 24645K
			{0.252739246, 0.252524575}, // 24646K
			{0.25273862, 0.252523707}, // 24647K
			{0.252737995, 0.25252284}, // 24648K
			{0.25273737, 0.252521972}, // 24649K
			{0.252736745, 0.252521104}, // 24650K
			{0.25273612, 0.252520237}, // 24651K
			{0.252735495, 0.252519369}, // 24652K
			{0.25273487, 0.252518502}, // 24653K
			{0.252734245, 0.252517634}, // 24654K
			{0.25273362, 0.252516767}, // 24655K
			{0.252732996, 0.2525159}, // 24656K
			{0.252732371, 0.252515033}, // 24657K
			{0.252731746, 0.252514166}, // 24658K
			{0.252731122, 0.252513299}, // 24659K
			{0.252730497, 0.252512432}, // 24660K
			{0.252729873, 0.252511565}, // 24661K
			{0.252729248, 0.252510699}, // 24662K
			{0.252728624, 0.252509832}, // 24663K
			{0.252728, 0.252508965}, // 24664K
			{0.252727376, 0.252508099}, // 24665K
			{0.252726751, 0.252507233}, // 24666K
			{0.252726127, 0.252506366}, // 24667K
			{0.252725503, 0.2525055}, // 24668K
			{0.252724879, 0.252504634}, // 24669K
			{0.252724256, 0.252503768}, // 24670K
			{0.252723632, 0.252502902}, // 24671K
			{0.252723008, 0.252502036}, // 24672K
			{0.252722384, 0.25250117}, // 24673K
			{0.25272176, 0.252500304}, // 24674K
			{0.252721137, 0.252499439}, // 24675K
			{0.252720513, 0.252498573}, // 24676K
			{0.25271989, 0.252497707}, // 24677K
			{0.252719266, 0.252496842}, // 24678K
			{0.252718643, 0.252495977}, // 24679K
			{0.25271802, 0.252495111}, // 24680K
			{0.252717396, 0.252494246}, // 24681K
			{0.252716773, 0.252493381}, // 24682K
			{0.25271615, 0.252492516}, // 24683K
			{0.252715527, 0.252491651}, // 24684K
			{0.252714904, 0.252490786}, // 24685K
			{0.252714281, 0.252489921}, // 24686K
			{0.252713658, 0.252489056}, // 24687K
			{0.252713035, 0.252488192}, // 24688K
			{0.252712413, 0.252487327}, // 24689K
			{0.25271179, 0.252486463}, // 24690K
			{0.252711167, 0.252485598}, // 24691K
			{0.252710545, 0.252484734}, // 24692K
			{0.252709922, 0.25248387}, // 24693K
			{0.2527093, 0.252483006}, // 24694K
			{0.252708677, 0.252482141}, // 24695K
			{0.252708055, 0.252481277}, // 24696K
			{0.252707432, 0.252480413}, // 24697K
			{0.25270681, 0.25247955}, // 24698K
			{0.252706188, 0.252478686}, // 24699K
			{0.252705566, 0.252477822}, // 24700K
			{0.252704944, 0.252476958}, // 24701K
			{0.252704322, 0.252476095}, // 24702K
			{0.2527037, 0.252475231}, // 24703K
			{0.252703078, 0.252474368}, // 24704K
			{0.252702456, 0.252473505}, // 24705K
			{0.252701834, 0.252472641}, // 24706K
			{0.252701212, 0.252471778}, // 24707K
			{0.252700591, 0.252470915}, // 24708K
			{0.252699969, 0.252470052}, // 24709K
			{0.252699348, 0.252469189}, // 24710K
			{0.252698726, 0.252468326}, // 24711K
			{0.252698105, 0.252467464}, // 24712K
			{0.252697483, 0.252466601}, // 24713K
			{0.252696862, 0.252465738}, // 24714K
			{0.252696241, 0.252464876}, // 24715K
			{0.25269562, 0.252464013}, // 24716K
			{0.252694998, 0.252463151}, // 24717K
			{0.252694377, 0.252462289}, // 24718K
			{0.252693756, 0.252461426}, // 24719K
			{0.252693135, 0.252460564}, // 24720K
			{0.252692515, 0.252459702}, // 24721K
			{0.252691894, 0.25245884}, // 24722K
			{0.252691273, 0.252457978}, // 24723K
			{0.252690652, 0.252457116}, // 24724K
			{0.252690031, 0.252456255}, // 24725K
			{0.252689411, 0.252455393}, // 24726K
			{0.25268879, 0.252454531}, // 24727K
			{0.25268817, 0.25245367}, // 24728K
			{0.252687549, 0.252452809}, // 24729K
			{0.252686929, 0.252451947}, // 24730K
			{0.252686309, 0.252451086}, // 24731K
			{0.252685688, 0.252450225}, // 24732K
			{0.252685068, 0.252449364}, // 24733K
			{0.252684448, 0.252448502}, // 24734K
			{0.252683828, 0.252447642}, // 24735K
			{0.252683208, 0.252446781}, // 24736K
			{0.252682588, 0.25244592}, // 24737K
			{0.252681968, 0.252445059}, // 24738K
			{0.252681348, 0.252444198}, // 24739K
			{0.252680728, 0.252443338}, // 24740K
			{0.252680109, 0.252442477}, // 24741K
			{0.252679489, 0.252441617}, // 24742K
			{0.252678869, 0.252440757}, // 24743K
			{0.25267825, 0.252439896}, // 24744K
			{0.25267763, 0.252439036}, // 24745K
			{0.252677011, 0.252438176}, // 24746K
			{0.252676392, 0.252437316}, // 24747K
			{0.252675772, 0.252436456}, // 24748K
			{0.252675153, 0.252435596}, // 24749K
			{0.252674534, 0.252434736}, // 24750K
			{0.252673915, 0.252433877}, // 24751K
			{0.252673296, 0.252433017}, // 24752K
			{0.252672677, 0.252432157}, // 24753K
			{0.252672058, 0.252431298}, // 24754K
			{0.252671439, 0.252430439}, // 24755K
			{0.25267082, 0.252429579}, // 24756K
			{0.252670201, 0.25242872}, // 24757K
			{0.252669582, 0.252427861}, // 24758K
			{0.252668964, 0.252427002}, // 24759K
			{0.252668345, 0.252426143}, // 24760K
			{0.252667726, 0.252425284}, // 24761K
			{0.252667108, 0.252424425}, // 24762K
			{0.252666489, 0.252423566}, // 24763K
			{0.252665871, 0.252422707}, // 24764K
			{0.252665253, 0.252421849}, // 24765K
			{0.252664634, 0.25242099}, // 24766K
			{0.252664016, 0.252420132}, // 24767K
			{0.252663398, 0.252419273}, // 24768K
			{0.25266278, 0.252418415}, // 24769K
			{0.252662162, 0.252417557}, // 24770K
			{0.252661544, 0.252416699}, // 24771K
			{0.252660926, 0.252415841}, // 24772K
			{0.252660308, 0.252414983}, // 24773K
			{0.25265969, 0.252414125}, // 24774K
			{0.252659073, 0.252413267}, // 24775K
			{0.252658455, 0.252412409}, // 24776K
			{0.252657837, 0.252411551}, // 24777K
			{0.25265722, 0.252410694}, // 24778K
			{0.252656602, 0.252409836}, // 24779K
			{0.252655985, 0.252408979}, // 24780K
			{0.252655367, 0.252408121}, // 24781K
			{0.25265475, 0.252407264}, // 24782K
			{0.252654133, 0.252406407}, // 24783K
			{0.252653515, 0.25240555}, // 24784K
			{0.252652898, 0.252404693}, // 24785K
			{0.252652281, 0.252403836}, // 24786K
			{0.252651664, 0.252402979}, // 24787K
			{0.252651047, 0.252402122}, // 24788K
			{0.25265043, 0.252401265}, // 24789K
			{0.252649813, 0.252400408}, // 24790K
			{0.252649197, 0.252399552}, // 24791K
			{0.25264858, 0.252398695}, // 24792K
			{0.252647963, 0.252397839}, // 24793K
			{0.252647346, 0.252396982}, // 24794K
			{0.25264673, 0.252396126}, // 24795K
			{0.252646113, 0.25239527}, // 24796K
			{0.252645497, 0.252394414}, // 24797K
			{0.25264488, 0.252393558}, // 24798K
			{0.252644264, 0.252392702}, // 24799K
			{0.252643648, 0.252391846}, // 24800K
			{0.252643032, 0.25239099}, // 24801K
			{0.252642415, 0.252390134}, // 24802K
			{0.252641799, 0.252389279}, // 24803K
			{0.252641183, 0.252388423}, // 24804K
			{0.252640567, 0.252387568}, // 24805K
			{0.252639951, 0.252386712}, // 24806K
			{0.252639335, 0.252385857}, // 24807K
			{0.252638719, 0.252385001}, // 24808K
			{0.252638104, 0.252384146}, // 24809K
			{0.252637488, 0.252383291}, // 24810K
			{0.252636872, 0.252382436}, // 24811K
			{0.252636257, 0.252381581}, // 24812K
			{0.252635641, 0.252380726}, // 24813K
			{0.252635026, 0.252379871}, // 24814K
			{0.25263441, 0.252379017}, // 24815K
			{0.252633795, 0.252378162}, // 24816K
			{0.25263318, 0.252377307}, // 24817K
			{0.252632564, 0.252376453}, // 24818K
			{0.252631949, 0.252375598}, // 24819K
			{0.252631334, 0.252374744}, // 24820K
			{0.252630719, 0.25237389}, // 24821K
			{0.252630104, 0.252373036}, // 24822K
			{0.252629489, 0.252372181}, // 24823K
			{0.252628874, 0.252371327}, // 24824K
			{0.252628259, 0.252370473}, // 24825K
			{0.252627644, 0.25236962}, // 24826K
			{0.25262703, 0.252368766}, // 24827K
			{0.252626415, 0.252367912}, // 24828K
			{0.2526258, 0.252367058}, // 24829K
			{0.252625186, 0.252366205}, // 24830K
			{0.252624571, 0.252365351}, // 24831K
			{0.252623957, 0.252364498}, // 24832K
			{0.252623342, 0.252363644}, // 24833K
			{0.252622728, 0.252362791}, // 24834K
			{0.252622114, 0.252361938}, // 24835K
			{0.2526215, 0.252361085}, // 24836K
			{0.252620885, 0.252360232}, // 24837K
			{0.252620271, 0.252359379}, // 24838K
			{0.252619657, 0.252358526}, // 24839K
			{0.252619043, 0.252357673}, // 24840K
			{0.252618429, 0.25235682}, // 24841K
			{0.252617816, 0.252355968}, // 24842K
			{0.252617202, 0.252355115}, // 24843K
			{0.252616588, 0.252354263}, // 24844K
			{0.252615974, 0.25235341}, // 24845K
			{0.252615361, 0.252352558}, // 24846K
			{0.252614747, 0.252351706}, // 24847K
			{0.252614134, 0.252350853}, // 24848K
			{0.25261352, 0.252350001}, // 24849K
			{0.252612907, 0.252349149}, // 24850K
			{0.252612293, 0.252348297}, // 24851K
			{0.25261168, 0.252347445}, // 24852K
			{0.252611067, 0.252346594}, // 24853K
			{0.252610454, 0.252345742}, // 24854K
			{0.252609841, 0.25234489}, // 24855K
			{0.252609227, 0.252344039}, // 24856K
			{0.252608614, 0.252343187}, // 24857K
			{0.252608002, 0.252342336}, // 24858K
			{0.252607389, 0.252341484}, // 24859K
			{0.252606776, 0.252340633}, // 24860K
			{0.252606163, 0.252339782}, // 24861K
			{0.25260555, 0.252338931}, // 24862K
			{0.252604938, 0.25233808}, // 24863K
			{0.252604325, 0.252337229}, // 24864K
			{0.252603712, 0.252336378}, // 24865K
			{0.2526031, 0.252335527}, // 24866K
			{0.252602488, 0.252334676}, // 24867K
			{0.252601875, 0.252333826}, // 24868K
			{0.252601263, 0.252332975}, // 24869K
			{0.252600651, 0.252332125}, // 24870K
			{0.252600038, 0.252331274}, // 24871K
			{0.252599426, 0.252330424}, // 24872K
			{0.252598814, 0.252329574}, // 24873K
			{0.252598202, 0.252328723}, // 24874K
			{0.25259759, 0.252327873}, // 24875K
			{0.252596978, 0.252327023}, // 24876K
			{0.252596366, 0.252326173}, // 24877K
			{0.252595755, 0.252325323}, // 24878K
			{0.252595143, 0.252324474}, // 24879K
			{0.252594531, 0.252323624}, // 24880K
			{0.25259392, 0.252322774}, // 24881K
			{0.252593308, 0.252321925}, // 24882K
			{0.252592697, 0.252321075}, // 24883K
			{0.252592085, 0.252320226}, // 24884K
			{0.252591474, 0.252319376}, // 24885K
			{0.252590862, 0.252318527}, // 24886K
			{0.252590251, 0.252317678}, // 24887K
			{0.25258964, 0.252316829}, // 24888K
			{0.252589029, 0.25231598}, // 24889K
			{0.252588418, 0.252315131}, // 24890K
			{0.252587807, 0.252314282}, // 24891K
			{0.252587196, 0.252313433}, // 24892K
			{0.252586585, 0.252312584}, // 24893K
			{0.252585974, 0.252311736}, // 24894K
			{0.252585363, 0.252310887}, // 24895K
			{0.252584752, 0.252310039}, // 24896K
			{0.252584141, 0.25230919}, // 24897K
			{0.252583531, 0.252308342}, // 24898K
			{0.25258292, 0.252307494}, // 24899K
			{0.25258231, 0.252306645}, // 24900K
			{0.252581699, 0.252305797}, // 24901K
			{0.252581089, 0.252304949}, // 24902K
			{0.252580478, 0.252304101}, // 24903K
			{0.252579868, 0.252303253}, // 24904K
			{0.252579258, 0.252302406}, // 24905K
			{0.252578648, 0.252301558}, // 24906K
			{0.252578037, 0.25230071}, // 24907K
			{0.252577427, 0.252299863}, // 24908K
			{0.252576817, 0.252299015}, // 24909K
			{0.252576207, 0.252298168}, // 24910K
			{0.252575597, 0.25229732}, // 24911K
			{0.252574988, 0.252296473}, // 24912K
			{0.252574378, 0.252295626}, // 24913K
			{0.252573768, 0.252294779}, // 24914K
			{0.252573158, 0.252293932}, // 24915K
			{0.252572549, 0.252293085}, // 24916K
			{0.252571939, 0.252292238}, // 24917K
			{0.25257133, 0.252291391}, // 24918K
			{0.25257072, 0.252290544}, // 24919K
			{0.252570111, 0.252289698}, // 24920K
			{0.252569502, 0.252288851}, // 24921K
			{0.252568892, 0.252288004}, // 24922K
			{0.252568283, 0.252287158}, // 24923K
			{0.252567674, 0.252286312}, // 24924K
			{0.252567065, 0.252285465}, // 24925K
			{0.252566456, 0.252284619}, // 24926K
			{0.252565847, 0.252283773}, // 24927K
			{0.252565238, 0.252282927}, // 24928K
			{0.252564629, 0.252282081}, // 24929K
			{0.25256402, 0.252281235}, // 24930K
			{0.252563411, 0.252280389}, // 24931K
			{0.252562803, 0.252279543}, // 24932K
			{0.252562194, 0.252278698}, // 24933K
			{0.252561585, 0.252277852}, // 24934K
			{0.252560977, 0.252277007}, // 24935K
			{0.252560368, 0.252276161}, // 24936K
			{0.25255976, 0.252275316}, // 24937K
			{0.252559152, 0.25227447}, // 24938K
			{0.252558543, 0.252273625}, // 24939K
			{0.252557935, 0.25227278}, // 24940K
			{0.252557327, 0.252271935}, // 24941K
			{0.252556719, 0.25227109}, // 24942K
			{0.252556111, 0.252270245}, // 24943K
			{0.252555503, 0.2522694}, // 24944K
			{0.252554895, 0.252268556}, // 24945K
			{0.252554287, 0.252267711}, // 24946K
			{0.252553679, 0.252266866}, // 24947K
			{0.252553071, 0.252266022}, // 24948K
			{0.252552463, 0.252265177}, // 24949K
			{0.252551856, 0.252264333}, // 24950K
			{0.252551248, 0.252263489}, // 24951K
			{0.25255064, 0.252262644}, // 24952K
			{0.252550033, 0.2522618}, // 24953K
			{0.252549425, 0.252260956}, // 24954K
			{0.252548818, 0.252260112}, // 24955K
			{0.252548211, 0.252259268}, // 24956K
			{0.252547603, 0.252258424}, // 24957K
			{0.252546996, 0.252257581}, // 24958K
			{0.252546389, 0.252256737}, // 24959K
			{0.252545782, 0.252255893}, // 24960K
			{0.252545175, 0.25225505}, // 24961K
			{0.252544568, 0.252254206}, // 24962K
			{0.252543961, 0.252253363}, // 24963K
			{0.252543354, 0.252252519}, // 24964K
			{0.252542747, 0.252251676}, // 24965K
			{0.25254214, 0.252250833}, // 24966K
			{0.252541534, 0.25224999}, // 24967K
			{0.252540927, 0.252249147}, // 24968K
			{0.25254032, 0.252248304}, // 24969K
			{0.252539714, 0.252247461}, // 24970K
			{0.252539107, 0.252246618}, // 24971K
			{0.252538501, 0.252245776}, // 24972K
			{0.252537894, 0.252244933}, // 24973K
			{0.252537288, 0.25224409}, // 24974K
			{0.252536682, 0.252243248}, // 24975K
			{0.252536076, 0.252242406}, // 24976K
			{0.252535469, 0.252241563}, // 24977K
			{0.252534863, 0.252240721}, // 24978K
			{0.252534257, 0.252239879}, // 24979K
			{0.252533651, 0.252239037}, // 24980K
			{0.252533045, 0.252238195}, // 24981K
			{0.25253244, 0.252237353}, // 24982K
			{0.252531834, 0.252236511}, // 24983K
			{0.252531228, 0.252235669}, // 24984K
			{0.252530622, 0.252234827}, // 24985K
			{0.252530017, 0.252233986}, // 24986K
			{0.252529411, 0.252233144}, // 24987K
			{0.252528805, 0.252232303}, // 24988K
			{0.2525282, 0.252231461}, // 24989K
			{0.252527595, 0.25223062}, // 24990K
			{0.252526989, 0.252229779}, // 24991K
			{0.252526384, 0.252228937}, // 24992K
			{0.252525779, 0.252228096}, // 24993K
			{0.252525173, 0.252227255}, // 24994K
			{0.252524568, 0.252226414}, // 24995K
			{0.252523963, 0.252225573}, // 24996K
			{0.252523358, 0.252224732}, // 24997K
			{0.252522753, 0.252223892}, // 24998K
			{0.252522148, 0.252223051}, // 24999K
			{0.252521543, 0.25222221}, // 25000K
		};
	}
}
