// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __honmon_h__
#define __honmon_h__

#include "bfile.h"
#include "dict.h"

struct ATTR {
  bool bold:1;
  bool italic:1;
  bool hidden:1;
  bool hankaku:1;
  bool superscript:1;
  bool subscript:1;
  bool widechar:1;
  int underline:4;
  int color:8;

  bool notText:1;
  //  bool ctrl:1;
  //  bool voice:1;
  //  bool pict:1;
  //  bool movie:1;

  int id;
  ATTR();
  ATTR(const ATTR& attr);
};

class DICCHAR {
  word code;
  ATTR attr;
  TAG tag;

  void DicCharCopy(const DICCHAR& ch);

 public:
  DICCHAR(int ch=0,ATTR a=ATTR(),TAG t=TAG(0,0));

  DICCHAR(const DICCHAR& ch);
  ~DICCHAR();
  const DICCHAR& operator= (const DICCHAR& ch);

  const ATTR& Attr() const { return attr; };
  bool Attr(const ATTR& a) { attr=a; return true; };
  int Code() const { return int(code); };
  bool Code(int ch) { code=word(ch); return true; };
  const TAG& Tag() const { return tag; };
  bool Tag(const TAG& t) { tag=t; return true; };
  word Hankaku() const;
  std::string Euc() const;
};

typedef std::basic_string<DICCHAR> DICSTRING;

class DICLINE {
  TAG head;
  TAG prev;
  TAG next;
  DICSTRING text;
  word currentMargin;
  ATTR currentAttr;
  DICTIONARY* dict;
  BlockIO* file;
  TAG currentPoint;
  TAG currentTag;
  bool isNotEOF;
  int marginSplit;

  bool DecodeDecorate(int ch,DICCHAR& chr,DICSTRING& txt,bool& l);
  bool DecodeDecorate0X(int,DICCHAR&,DICSTRING&,bool&);
  bool DecodeDecorate1X(int,DICCHAR&,DICSTRING&,bool&);
  bool DecodeDecorate2X(int,DICCHAR&,DICSTRING&,bool&);
  bool DecodeDecorate35X(int,DICCHAR&,DICSTRING&,bool&);
  bool DecodeDecorateEFX(int,DICCHAR&,DICSTRING&,bool&);

public:
  DICLINE(DICTIONARY* dct=NULL,const TAG& hed=TAG(0,0));
  //  DICLINE(const DICLINE& dline);
  ~DICLINE();

  bool GetLine(DICTIONARY* dct=NULL,const TAG& t=TAG(0,0));
  word Margin() const { return currentMargin; };
  const std::basic_string<DICCHAR>& txt() const { return text; };
};

#endif
