// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <cstdarg>
#include <cstdio>
#include "debug.h"

/*
const int Debug::LOW_LEVEL_FILE;
const int Debug::FILE_CACHE;
const int Debug::CATALOG_DECODE;
const int Debug::GAIJI_DECODE;
const int Debug::INDEX_DECODE;
const int Debug::DICTIONARY;
const int Debug::DISPLAY;
const int Debug::MULTIMEDIA;
const int Debug::WARNINGS;
const int Debug::VERBOSE;
const int Debug::TEMP;
const int Debug::ALL;
const int Debug::DEFAULT;
*/

int Debug::level;

//
// Message Output Routines
//
#ifdef DEBUG
void Debug::DebugOut(int lv,const char *fmt, ...) {
  if ((lv & (level & ~VERBOSE))!=0) {
    if ((lv & VERBOSE)!=0 && (level & VERBOSE)==0) return;

    va_list ap;
    va_start(ap,fmt);
    vfprintf(stderr,fmt,ap);
    va_end(ap);
  }
}
#else
void Debug::DebugOut(int lv,const char *fmt, ...) {
};
#endif

void Debug::ErrorOut(const char *fmt, ...) {
  va_list ap;
  va_start(ap,fmt);
  vfprintf(stderr,fmt,ap);
  va_end(ap);
}

