// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __codeconv_h__
#define __codeconv_h__

#include "def.h"

#ifdef HAVE_STRING

#ifndef INC_STRING
#define INC_STRING
#include <string>
#ifdef NEED_BASTRING_CC
#include <std/bastring.cc>
#endif
#endif

#else
#error You need STL.
#endif

#ifdef USE_ICONV
#include <iconv.h>
#endif

struct CODE_CONV_MODE {
  byte convertKatakana;
  byte convertEikomoji;
  byte convertKigou;
  byte convertChouon;
  byte convertSokuon;
  byte convertYouon;
  byte convertKomoji;
  byte convertDakuon;
  byte convertHandakuon;
  bool Setup(byte* adrs);
  CODE_CONV_MODE(byte* adrs=NULL) { Setup(adrs); };
};

struct CODECONV {
  static EUC_STRING Jis2Euc(const JIS_STRING& jisStr);
  static EUC_STRING Jis2Euc2(const JIS_STRING& jisStr);
  static JIS_STRING Euc2Jis(const EUC_STRING& eucStr);
  static JIS_STRING JisUpcase(const JIS_STRING& jisStr);
  static JIS_STRING RevJis(const JIS_STRING& jisStr);
  static JIS_STRING ConvertForCompare(const JIS_STRING& jisStr,
				      const CODE_CONV_MODE& convMode);
  static int CompareKana(const JIS_STRING& jisStr1,
			 const JIS_STRING& jisStr2);

  static bool isKana(const JIS_STRING& jisStr);
  static NATIVE_STRING codeset;
  static void Initialize();

private:
  static bool initialized;

#ifdef USE_ICONV
public:
  static iconv_t ec;
  static iconv_t ce;
  static iconv_t eu;
  static iconv_t ue;
  static NATIVE_STRING EUCToCurrent(const std::string& s);
  static EUC_STRING CurrentToEUC(const std::string& s);
  static UTF8_STRING EUCToUTF8(const std::string& s);
  static EUC_STRING UTF8ToEUC(const std::string& s);
  static UNKNOWN_STRING IConvInternal(iconv_t xcd,const UNKNOWN_STRING& s);
private:
  static bool InitIConv();
#endif
};

#ifdef USE_ICONV
inline NATIVE_STRING _EC(const EUC_STRING& s){ 
  return CODECONV::EUCToCurrent(s); };
inline EUC_STRING _CE(const NATIVE_STRING& s){ 
  return CODECONV::CurrentToEUC(s); };
inline UTF8_STRING _EU(const EUC_STRING& s){ return CODECONV::EUCToUTF8(s); };
inline EUC_STRING _UE(const UTF8_STRING& s){ return CODECONV::UTF8ToEUC(s); };
#else
inline NATIVE_STRING _EC(const EUC_STRING& s){ return s; };
inline EUC_STRING _CE(const NATIVE_STRING& s){ return s; };
inline UTF8_STRING _EU(const EUC_STRING& s){ return s; };
inline EUC_STRING _UE(const UTF8_STRING& s){ return s; };
#endif
inline EUC_STRING _JE(const JIS_STRING& s){ return CODECONV::Jis2Euc(s); };
inline EUC_STRING _JE2(const JIS_STRING& s){ return CODECONV::Jis2Euc2(s); };
inline JIS_STRING _EJ(const EUC_STRING& s){ return CODECONV::Euc2Jis(s); };

#endif
