// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 2001 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "gui.h"
#include "global.h"

#include <netdb.h>

#include <gtk/gtkwidget.h>

GtkWidget* dictTreeHead=NULL;
GtkWidget* booklist;

GtkWidget* editEntryHead=NULL;

static bool ok_EditEntry;
static bool ok_BookList;

static gboolean DestroyBookList(GtkWidget* w,int ok){
  ok_BookList = (ok!=0);
  gtk_main_quit();
  return false;
}

static gboolean DestroyEditEntry(GtkWidget* w,int ok){
  gtk_main_quit();
  if (ok!=0) ok_EditEntry=true; else ok_EditEntry=false;
  return false;
}


static void EditOneEntry(GtkWidget* widget, GtkCList* clist,bool newFlag){
  NATIVE_STRING path;
  NATIVE_STRING name;
  
  NATIVE_STRING ndtphost;
  NATIVE_STRING ndtpport;
  
  NATIVE_STRING filepath;
  

  gtk_clist_freeze(clist);

  editEntryHead=gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW(editEntryHead),true);
  GtkWidget* vbox=GTK_DIALOG(editEntryHead)->vbox;

  GtkWidget* hbox0=gtk_hbox_new(false,10);
  GtkWidget* label0=gtk_label_new(_("title"));
  GtkWidget* title=gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox0),label0,FALSE,FALSE,10);
  gtk_box_pack_start(GTK_BOX(hbox0),title,TRUE,TRUE,10);
  gtk_box_pack_start_defaults(GTK_BOX(vbox),hbox0);
  GtkWidget* frame=gtk_frame_new(_("Dictionary Path"));
  gtk_widget_show(frame);
  gtk_container_set_border_width(GTK_CONTAINER(frame),15);

  gtk_box_pack_start_defaults(GTK_BOX(vbox),frame);

  GtkWidget* vbox_f=gtk_vbox_new(false,10);
  gtk_container_add(GTK_CONTAINER(frame),vbox_f);
  GtkWidget* hbox1=gtk_hbox_new(false,10);
  GtkWidget* label1=gtk_label_new(_("Path"));
  GtkWidget* radio1=gtk_radio_button_new_with_label(NULL,_("file"));
  GtkWidget* path1=gtk_entry_new_with_max_length(100);
  GtkWidget* button1=gtk_button_new_with_label(_("browse"));
  gtk_box_pack_start(GTK_BOX(hbox1),radio1,FALSE,FALSE,3);
  gtk_box_pack_start(GTK_BOX(hbox1),label1,FALSE,FALSE,3);
  gtk_box_pack_start(GTK_BOX(hbox1),path1,TRUE,TRUE,3);
  gtk_box_pack_start(GTK_BOX(hbox1),button1,FALSE,FALSE,3);
  gtk_box_pack_start_defaults(GTK_BOX(vbox_f),hbox1);

  GtkWidget* hbox2=gtk_hbox_new(FALSE,10);
  GtkWidget* radio2=gtk_radio_button_new_with_label(
	      gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)),_("ndtp"));
  GtkWidget* label2_1=gtk_label_new(_("Server"));
  GtkWidget* path2_1=gtk_entry_new_with_max_length(100);
  GtkWidget* port2_1=gtk_entry_new_with_max_length(8);
  GtkWidget* path2_2=gtk_entry_new_with_max_length(100);
  GtkWidget* button2=gtk_button_new_with_label(_("browse"));
  GtkWidget* toggle2=gtk_check_button_new_with_label(_("EB"));
  gtk_box_pack_start(GTK_BOX(hbox2),radio2,FALSE,FALSE,3);
  gtk_box_pack_start(GTK_BOX(hbox2),label2_1,FALSE,FALSE,3);
  gtk_box_pack_start(GTK_BOX(hbox2),path2_1,TRUE,TRUE,3); 
  gtk_box_pack_start_defaults(GTK_BOX(hbox2),gtk_label_new(":"));
  gtk_box_pack_start(GTK_BOX(hbox2),port2_1,FALSE,FALSE,3);
  gtk_widget_set_usize(GTK_WIDGET(port2_1),50,25);
  gtk_box_pack_start(GTK_BOX(hbox2),gtk_label_new(_("Path")),FALSE,FALSE,1);
  gtk_box_pack_start(GTK_BOX(hbox2),path2_2,TRUE,TRUE,3);
  gtk_box_pack_start(GTK_BOX(hbox2),button2,FALSE,FALSE,3);
  gtk_box_pack_start(GTK_BOX(hbox2),toggle2,FALSE,FALSE,3);
  gtk_box_pack_start_defaults(GTK_BOX(vbox_f),hbox2);

  GtkWidget* para=gtk_vbox_new(false,0);
  GtkWidget* para1=gtk_hbox_new(false,0);

  GtkObject* adj_p1=gtk_adjustment_new(0.0,-5.0,20.0,1.0,5.0,5.0);
  GtkWidget* hbox_p1=gtk_hbox_new(false,0);
  GtkWidget* label_p1=gtk_label_new(_("char-offset"));
  GtkWidget* entry_p1=gtk_spin_button_new(GTK_ADJUSTMENT(adj_p1),1.0,0);
  gtk_box_pack_start(GTK_BOX(hbox_p1),label_p1,FALSE,FALSE,10);
  gtk_box_pack_start(GTK_BOX(hbox_p1),entry_p1,FALSE,FALSE,10);
  gtk_box_pack_start_defaults(GTK_BOX(para1),hbox_p1);

  GtkObject* adj_p2=gtk_adjustment_new(0.0,-5.0,20.0,1.0,5.0,5.0);
  GtkWidget* hbox_p2=gtk_hbox_new(false,0);
  GtkWidget* label_p2=gtk_label_new(_("char-extend"));
  GtkWidget* entry_p2=gtk_spin_button_new(GTK_ADJUSTMENT(adj_p2),1.0,0);
  gtk_box_pack_start(GTK_BOX(hbox_p2),label_p2,FALSE,FALSE,10);
  gtk_box_pack_start(GTK_BOX(hbox_p2),entry_p2,FALSE,FALSE,10);
  gtk_box_pack_start_defaults(GTK_BOX(para1),hbox_p2);

  GtkObject* adj_p3=gtk_adjustment_new(0.0,-5.0,20.0,1.0,5.0,5.0);
  GtkWidget* hbox_p3=gtk_hbox_new(false,0);
  GtkWidget* label_p3=gtk_label_new(_("gaiji-offset"));
  GtkWidget* entry_p3=gtk_spin_button_new(GTK_ADJUSTMENT(adj_p3),1.0,0);
  gtk_box_pack_start(GTK_BOX(hbox_p3),label_p3,FALSE,FALSE,10);
  gtk_box_pack_start(GTK_BOX(hbox_p3),entry_p3,FALSE,FALSE,10);
  gtk_box_pack_start_defaults(GTK_BOX(para1),hbox_p3);


  GtkWidget* button_p4=
    gtk_check_button_new_with_label(_("auto image display"));
  gtk_box_pack_start_defaults(GTK_BOX(para1),button_p4);

  gtk_box_pack_start_defaults(GTK_BOX(para),para1);

  GtkWidget* button_p5=gtk_check_button_new_with_label(_("disable book"));
  gtk_box_pack_start_defaults(GTK_BOX(para),button_p5);

  GtkWidget* hbox_p5=gtk_hbox_new(false,0);
  GtkWidget* vbox_p5=gtk_vbox_new(false,0);
  GtkWidget* hbox_p5_1=gtk_hbox_new(false,0);
  GtkWidget* hbox_p5_2=gtk_hbox_new(false,0);
  GtkWidget* label_p5=gtk_label_new(_("disable subbook"));
  gtk_box_pack_start(GTK_BOX(hbox_p5),label_p5,FALSE,FALSE,10);
  gtk_box_pack_start(GTK_BOX(hbox_p5),vbox_p5,FALSE,FALSE,10);
  gtk_box_pack_start_defaults(GTK_BOX(vbox_p5),hbox_p5_1);
  gtk_box_pack_start_defaults(GTK_BOX(vbox_p5),hbox_p5_2);
  GtkWidget* disable_subbook[16];
  for(int i=0;i<16;i++){
    char buf[6];
    sprintf(buf,"%3d",i+1);
    disable_subbook[i]=gtk_check_button_new_with_label(buf);
    if (i<8){
      gtk_box_pack_start(GTK_BOX(hbox_p5_1),disable_subbook[i],FALSE,FALSE,10);
    } else {
      gtk_box_pack_start(GTK_BOX(hbox_p5_2),disable_subbook[i],FALSE,FALSE,10);
    }
  }
  gtk_box_pack_start_defaults(GTK_BOX(para),hbox_p5);

  gtk_box_pack_start_defaults(GTK_BOX(vbox),para);

  GtkWidget* buttons=GTK_DIALOG(editEntryHead)->action_area;
  GtkWidget* okButton=gtk_button_new_with_label(_("Ok"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),okButton);
  gtk_signal_connect(GTK_OBJECT(okButton),"clicked",
		     (GtkSignalFunc)DestroyEditEntry,(gpointer)1);
  GtkWidget* cancelButton=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),cancelButton);
  gtk_signal_connect(GTK_OBJECT(cancelButton),"clicked",
		     (GtkSignalFunc)DestroyEditEntry,(gpointer)0);
  GTK_WIDGET_SET_FLAGS(okButton, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS(cancelButton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(okButton);

  gtk_widget_show (vbox);

  gtk_widget_show_all(editEntryHead);


  if (!newFlag && clist->selection){
    int row=GPOINTER_TO_INT(clist->selection->data);
    gchar* buf;
    gtk_clist_get_text(clist,row,1,&buf);
    gtk_entry_set_text(GTK_ENTRY(title),buf);
    gtk_clist_get_text(clist,row,2,&buf);
    if (strncmp(buf,"ndtp:",5)==0){
      // NDTP
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio2),TRUE);
      buf+=5;
      while(*buf=='/') ++buf;
      char* ndtppath=strdup(buf);
      if (ndtppath==NULL) throw "Out of memory!";
      char* pathstr=strchr(ndtppath,'/');
      if (pathstr==NULL){
	pathstr="";
      } else {
	*(pathstr++)=0;
      }
      char* portstr=strchr(ndtppath,':');
      if (portstr!=NULL) {
	*(portstr++)=0;
      } else {
	portstr="ndtp";
      }
      char* optstr=strchr(pathstr,'#');
      if (optstr!=NULL){
	*(optstr++)=0;
	if (strcasecmp(optstr,"eb")==0){
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle2),TRUE);
	} else {
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle2),FALSE);
	}
      }
      gtk_entry_set_text(GTK_ENTRY(path2_1),ndtppath);
      struct servent* srv=getservbyname(portstr,"tcp");
      if (srv!=NULL){
	gtk_entry_set_text(GTK_ENTRY(port2_1),portstr);
      } else {
	gtk_entry_set_text(GTK_ENTRY(port2_1),"2010");
      }
      gtk_entry_set_text(GTK_ENTRY(path2_2),pathstr);
      free(ndtppath);
    } else {
      // FILE
      if (strncmp(buf,"file:",5)==0) buf+=5;
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1),TRUE);
      gtk_entry_set_text(GTK_ENTRY(path1),buf);
    }
    gtk_clist_get_text(clist,row,3,&buf);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p1),gfloat(atoi(buf)));
    gtk_clist_get_text(clist,row,4,&buf);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p2),gfloat(atoi(buf)));
    gtk_clist_get_text(clist,row,5,&buf);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p3),gfloat(atoi(buf)));
    gtk_clist_get_text(clist,row,6,&buf);
    if (*buf=='1'){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p4),TRUE);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p4),FALSE);
    }
    gtk_clist_get_text(clist,row,7,&buf);
    if (*buf=='1'){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p5),TRUE);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p5),FALSE);
    }
    gtk_clist_get_text(clist,row,8,&buf);
    if (strlen(buf)==16) {
      for(int i=0;i<16;i++) {
	gtk_toggle_button_set_active
	  (GTK_TOGGLE_BUTTON(disable_subbook[i]),buf[i]=='1');
      }
    } 
  } else if (newFlag) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1),TRUE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p4),TRUE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_p5),FALSE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p1),0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p1),3.0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(entry_p1),3.0);
    gtk_entry_set_text(GTK_ENTRY(port2_1),"ndtp");
  }
    

  ok_EditEntry=false;

  gtk_main();
  gtk_clist_thaw(clist);

  int row=-1;

  if (!ok_EditEntry) goto ret;

  if (newFlag) {
    gchar *datalist[9];
    for(int i=0;i<9;i++) {
      datalist[i]=(gchar*)(alloca(1));
      datalist[i][0]=0;
    }
    gtk_clist_append(GTK_CLIST(booklist),datalist);
    row=GTK_CLIST(booklist)->rows-1;
    if (row<0) goto ret;
    char buf[8];
    sprintf(buf,"%03d",row+1);
    gtk_clist_set_text(clist,row,0,buf);
  } else if (!newFlag && clist->selection){
    row=GPOINTER_TO_INT(clist->selection->data);
  } else {
    goto ret;
  }
  if (row<0) goto ret;
  gtk_clist_set_text(clist,row,1,gtk_entry_get_text(GTK_ENTRY(title)));

  char buf[cTmpLength];
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1))) {
    strcpy(buf,"file:");
    strcat(buf,gtk_entry_get_text(GTK_ENTRY(path1)));
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio2))) {
    strcpy(buf,"ndtp://");
    strcat(buf,gtk_entry_get_text(GTK_ENTRY(path2_1)));
    strcat(buf,":");
    strcat(buf,gtk_entry_get_text(GTK_ENTRY(port2_1)));
    if (gtk_entry_get_text(GTK_ENTRY(path2_2))[0]!='/') {
      strcat(buf,"/");
    }
    strcat(buf,gtk_entry_get_text(GTK_ENTRY(path2_2)));
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle2))) {
      strcat(buf,"#EB");
    }
  } else {
    strcpy(buf,"????:");
  }
  gtk_clist_set_text(clist,row,2,buf);

  sprintf(buf,"%d",atoi(gtk_entry_get_text(GTK_ENTRY(entry_p1))));
  gtk_clist_set_text(clist,row,3,buf);
  sprintf(buf,"%d",atoi(gtk_entry_get_text(GTK_ENTRY(entry_p2))));
  gtk_clist_set_text(clist,row,4,buf);
  sprintf(buf,"%d",atoi(gtk_entry_get_text(GTK_ENTRY(entry_p3))));
  gtk_clist_set_text(clist,row,5,buf);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button_p4))) {
    gtk_clist_set_text(clist,row,6,"1");
  } else {
    gtk_clist_set_text(clist,row,6,"0");
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button_p5))) {
    gtk_clist_set_text(clist,row,7,"1");
  } else {
    gtk_clist_set_text(clist,row,7,"0");
  }
  buf[16]=0;
  for(int i=0;i<16;i++){
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(disable_subbook[i]))) {
      buf[i]='1';
    } else {
      buf[i]='0';
    }
  }
  gtk_clist_set_text(clist,row,8,buf);

 ret:
  if (editEntryHead != NULL) 
    gtk_widget_destroy(editEntryHead);
};

static void EditEntry(GtkWidget* widget, GtkCList* clist){
  EditOneEntry(widget, clist, false);
}

static void NewEntry(GtkWidget* widget, GtkCList* clist){
  EditOneEntry(widget, clist, true);
}

static void RemoveSelection(GtkWidget *widget, GtkCList *clist){
  gtk_clist_freeze (clist);
  while (clist->selection) {
    gint row=GPOINTER_TO_INT(clist->selection->data);
    gtk_clist_remove(clist,row);
  }
  gtk_clist_thaw (clist);

}

void CreateDictionaryTree(){
  static char* title[]={
    N_("number"),
    N_("name"),
    N_("path"),
    N_("char-offset"),
    N_("char-extend"),
    N_("gaiji-offset"),
    N_("auto-image-display"),
    N_("disable"),
    N_("disable-subbook"),
  };
  const int nTitles=sizeof(title)/sizeof(char*);
  static char* ititle[nTitles];
  static bool initialized=false;

  if (!initialized){
    char** tp=title;
    char** tp2=ititle;
    for(int i=0;i<nTitles;i++){
      *tp2++=strdup(_(*tp++));
    }
    initialized=true;
  }

  dictTreeHead=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(dictTreeHead),true);
  gtk_window_set_transient_for(GTK_WINDOW(dictTreeHead),
			       GTK_WINDOW(mainWindow));


  GtkWidget* vbox=gtk_vbox_new(false,10);
  GtkWidget* scroll=gtk_scrolled_window_new(NULL,NULL);
  gtk_container_set_border_width(GTK_CONTAINER(scroll),5);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scroll),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_ALWAYS);

  booklist=gtk_clist_new_with_titles(nTitles,ititle);
  gtk_clist_set_reorderable(GTK_CLIST(booklist),TRUE);
  gtk_clist_columns_autosize(GTK_CLIST(booklist));

  gtk_clist_set_column_auto_resize (GTK_CLIST(booklist),0,TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST(booklist),1,TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST(booklist),2,TRUE);

  for(int i=3;i<nTitles;i++){
    gtk_clist_set_column_visibility (GTK_CLIST(booklist),i,FALSE);
  }

  gtk_widget_set_usize (GTK_WIDGET(booklist),300,300);

  char *datalist[nTitles];
  for(int i=0;i<nTitles;i++) {
    datalist[i]=static_cast<char *>(alloca(cTmpLength+1));
    datalist[i][0]=0;
  }
  int count=0;

  for(std::vector<BOOK>::iterator i=catalogs.books.begin();
      i!=catalogs.books.end();++i){
    sprintf(datalist[0],"%03d",++count);
    strcpy(datalist[1],(*i).title.c_str());
    strcpy(datalist[2],(*i).path.c_str());
    snprintf(datalist[3],cTmpLength,"%3d",(*i).charOffset);
    snprintf(datalist[4],cTmpLength,"%3d",(*i).charExtend);
    snprintf(datalist[5],cTmpLength,"%3d",(*i).gaijiOffset);
    snprintf(datalist[6],cTmpLength,"%1d",(*i).autoImage);
    snprintf(datalist[7],cTmpLength,"%1d",(*i).disable);
    snprintf(datalist[8],cTmpLength,"%s",(*i).disableSubbook.c_str());
    gtk_clist_append(GTK_CLIST(booklist),datalist);
  } 

  gtk_container_add(GTK_CONTAINER(scroll),booklist);
  gtk_box_pack_start_defaults(GTK_BOX(vbox),scroll);


  GtkWidget* buttons=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(buttons), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttons), 5);
  GtkWidget* newButton=gtk_button_new_with_label(_("New"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),newButton);
  gtk_signal_connect(GTK_OBJECT(newButton),"clicked",
		     (GtkSignalFunc)NewEntry,
		     (gpointer)booklist);
  GtkWidget* editButton=gtk_button_new_with_label(_("Edit"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),editButton);
  gtk_signal_connect(GTK_OBJECT(editButton),"clicked",
		     (GtkSignalFunc)EditEntry,
		     (gpointer)booklist);
  GtkWidget* removeButton=gtk_button_new_with_label(_("Remove"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),removeButton);
  gtk_signal_connect(GTK_OBJECT(removeButton),"clicked",
		     (GtkSignalFunc)RemoveSelection,
		     (gpointer)booklist);
  GtkWidget* okButton=gtk_button_new_with_label(_("Ok"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),okButton);
  gtk_signal_connect(GTK_OBJECT(okButton),"clicked",
		     (GtkSignalFunc)DestroyBookList,(gpointer)1);
  GtkWidget* cancelButton=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start_defaults(GTK_BOX(buttons),cancelButton);
  gtk_signal_connect(GTK_OBJECT(cancelButton),"clicked",
		     (GtkSignalFunc)DestroyBookList,(gpointer)0);
  GTK_WIDGET_SET_FLAGS(okButton, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS(cancelButton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(okButton);


  gtk_box_pack_end(GTK_BOX(vbox),buttons,FALSE,FALSE,0);
  gtk_widget_show (vbox);

  gtk_container_add(GTK_CONTAINER(dictTreeHead),vbox);
  gtk_widget_show_all(dictTreeHead);

  ok_BookList=false;
  gtk_main();

  if (ok_BookList) {
    catalogs.books.clear();

    char *data[nTitles];
    int n=GTK_CLIST(booklist)->rows;
    for(int i=0;i<n;i++){
      for(int j=0;j<GTK_CLIST(booklist)->columns;j++){
	gtk_clist_get_text(GTK_CLIST(booklist),i,j,data+j);
      }
      catalogs.Append(NATIVE_STRING(data[2]),NATIVE_STRING(data[1]),
		      atoi(data[3]),atoi(data[5]),atoi(data[4]),
		      atoi(data[6])!=0,
		      atoi(data[7])!=0,
		      NATIVE_STRING(data[8]));
    }
    SetDicMenu();
  }

  if (dictTreeHead!=NULL) {
    gtk_widget_destroy(dictTreeHead);
    dictTreeHead=NULL;
  }
}

