

#include <stdio.h>
#include <stdlib.h>
#include <ctapi.h>



int main( int argc, char **argv){
  unsigned char dad, sad, rsp[258];
  unsigned short ctn=0, lr;
  unsigned char apdu[256];
  unsigned int alen;
  char ret;
  int i;

  /* Initialise CT-API library */
  ret=CT_init(ctn, 1);
  printf( "CT_init: %d\n", ret);
  if (ret!=CT_API_RV_OK )
    return 1;

  /* RESET CT */
  dad=CT;
  sad=HOST;
  alen=0;
  apdu[alen++]=0x20;
  apdu[alen++]=0x11;
  apdu[alen++]=0x00;
  apdu[alen++]=0x00;
  apdu[alen++]=0x00;
  lr=sizeof(rsp);
  ret=CT_data(ctn, &dad, &sad, alen, apdu,
              &lr, rsp);
  printf("CT_data: %d\n", ret);
  if( ret!=CT_API_RV_OK ) return( 1 );
  printf( "    sad: %d, dad: %d, rsp:", sad, dad );
  for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
  printf( "\n" );

  /* REQUEST ICC (timeout 20s) */
  dad=CT;
  sad=HOST;
  alen=0;
  apdu[alen++]=0x20;
  apdu[alen++]=0x12;
  apdu[alen++]=0x01;
  apdu[alen++]=0x01;
  apdu[alen++]=0x01;
  apdu[alen++]=0x14;
  apdu[alen++]=0x00;
  lr=sizeof(rsp);
  ret=CT_data( ctn, &dad, &sad,
              alen, apdu, 
              &lr, rsp );
  printf( "CT_data: %d\n", ret );
  if(ret!=CT_API_RV_OK)
    return(1);
  printf("    sad: %d, dad: %d, rsp:", sad, dad );
  for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
  printf( "\n" );

  /* modify pin */
#if 1
  dad=CT;
  sad=HOST;
  alen=0;
  apdu[alen++]=0x20;
  apdu[alen++]=0x19;
  apdu[alen++]=0x01;
  apdu[alen++]=0x00;
  apdu[alen++]=0x1a;
  apdu[alen++]=0x52;
  apdu[alen++]=0x18;
  apdu[alen++]=0x01;
  apdu[alen++]=0x06;
  apdu[alen++]=0x0e;
  apdu[alen++]=0x00;
  apdu[alen++]=0x24;
  apdu[alen++]=0x00;
  apdu[alen++]=0x90;
  apdu[alen++]=0x10;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  lr=sizeof(rsp);
#else

  /* verify pin */
  dad=CT;
  sad=HOST;
  alen=0;
  apdu[alen++]=0x20;
  apdu[alen++]=0x18;
  apdu[alen++]=0x01;
  apdu[alen++]=0x00;
  apdu[alen++]=0x11;
  apdu[alen++]=0x52;
  apdu[alen++]=0x0f;
  apdu[alen++]=0x01;
  apdu[alen++]=0x06;
  apdu[alen++]=0x00;
  apdu[alen++]=0x20;
  apdu[alen++]=0x00;
  apdu[alen++]=0x90;
  apdu[alen++]=0x08;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  apdu[alen++]=0x20;
  lr=sizeof(rsp);
#endif

  ret=CT_data( ctn, &dad, &sad,
              alen, apdu, 
              &lr, rsp );
  printf( "CT_data: %d\n", ret );
  if(ret!=CT_API_RV_OK)
    return(1);
  printf("    sad: %d, dad: %d, rsp:", sad, dad );
  for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
  printf( "\n" );

  return 0;
}







