/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: ctapi_config.c 22 2006-10-13 10:27:17Z martin $
    begin       : Mon Aug 14 2006
    copyright   : (C) 2006 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>

#include "ctapi_config_l.h"



static CYBERJACK_CONFIG *_ctapi_config=0;



static int _readConfig(FILE *f, CYBERJACK_CONFIG *cfg) {
  char lbuf[256];

  while(!feof(f)) {
    char *p;
    char *varName;
    char *value;
    unsigned int len;

    lbuf[0]=0;
    if (0==fgets(lbuf, sizeof(lbuf), f)) {
      if (ferror(f)) {
        fprintf(stderr, "CYBERJACK: fgets: %s\n", strerror(errno));
        return -1;
      }
    }

    len=strlen(lbuf);
    if (len<1)
      continue;

    if (lbuf[len-1]=='\n' || lbuf[-1]=='\r') {
      lbuf[len-1]=0;
      len--;
    }
    if (len<1)
      continue;

    /*fprintf(stderr, "CYBERJACK: Data is \"%s\"\n", lbuf);*/
    p=strchr(lbuf, '#');
    if (p)
      *p=0;
    p=lbuf;
    /* skip blanks */
    while(*p && isspace(*p))
      p++;
    if (!*p)
      continue;

    /* extract var name */
    varName=p;
    while(*p && !isspace(*p) && *p!='=')
      p++;
    if (!*p)
      /* unexpected end of line */
      continue;
    if (*p!='=') {
      /* found end of var name */
      *p=0;
      p++;
      /* skip blanks */
      while(*p && isspace(*p))
        p++;
    }
    if (*p!='=')
      /* missing equation mark */
      continue;
    *p=0;
    p++;

    /* skip blanks */
    while(*p && isspace(*p))
      p++;
    if (!*p)
      /* no value */
      continue;
    value=p;
    p++;
    /* get end of value */
    while(*p && !isspace(*p))
      p++;
    if (*p)
      *p=0;

    /* handle key value pair */
    /*fprintf(stderr, "CYBERJACK: Handling [%s]=[%s]\n", varName, value);*/
    if (strcasecmp(varName, "flags")==0) {
      unsigned int j;

      if (1==sscanf(value, "%i", &j)) {
        cfg->flags=j;
      }
      else {
        fprintf(stderr, "CYBERJACK: Bad value for flags: \"%s\"", value);
      }
    }
    else if (strcasecmp(varName, "debugFile")==0) {
      if (strlen(value)<sizeof(cfg->debugFile))
        strcpy(cfg->debugFile, value);
    }
    /* add more variables here */
    else {
      fprintf(stderr,
	      "CYBERJACK: Unknown variable \"%s\" in config file\n",
	      value);
    }
  } /* while !feof */

  return 0;
}



static int config_read_file(CYBERJACK_CONFIG *cfg) {
  FILE *f;

  f=fopen(CYBERJACK_CONFIG_FILE, "r");
  if (f) {
    int rv;

    rv=_readConfig(f, cfg);
    fclose(f);
    if (rv)
      return rv;
  }
  return 0;
}



int config_init() {
  /* init CTAPI configuration */
  _ctapi_config=(CYBERJACK_CONFIG*)malloc(sizeof(CYBERJACK_CONFIG));
  if (!_ctapi_config) {
    cjctapi_log("not enough memory available\n");
    return -1;
  }
  memset(_ctapi_config, 0, sizeof(CYBERJACK_CONFIG));

  strcpy(_ctapi_config->debugFile, "/tmp/cj.log");
  _ctapi_config->flags=CT_FLAGS_DEFAULT;

  if (getenv("CJCTAPI_NO_KEYBEEP"))
    _ctapi_config->flags|=CT_FLAGS_NO_BEEP;
  if (getenv("CJCTAPI_ECOM_KERNEL"))
    _ctapi_config->flags|=CT_FLAGS_ECOM_KERNEL;

  config_read_file(_ctapi_config);
  return 0;
}



void config_fini() {
  if (_ctapi_config) {
    free(_ctapi_config);
    _ctapi_config=0;
  }
}



unsigned int config_get_flags() {
  if (!_ctapi_config)
    return 0;
  return _ctapi_config->flags;
}



const char *config_get_debug_filename() {
  if (!_ctapi_config)
    return 0;
  if (_ctapi_config->debugFile[0]==0)
    return 0;
  return _ctapi_config->debugFile;
}




