
%define PACK_VER 1

%define dist 
%define disttag 
%define distver     

%define readers_dir %{_libdir}/readers

# set this to 1 for hotplug-only systems (like FC4)
%define use_hotplug 0
%define use_udev 0


Name:		ctapi-cyberjack
Summary:	CT-API 1.1 driver for REINER SCT cyberjack USB chipcard reader
Version:	2.0.14
Release:        %{PACK_VER}.%{disttag}%{distver}
License: 	LGPL
Packager:       Martin Preuss <martin@libchipcard.de>
URL:            http://www.reiner-sct.de/
Group: 		System Environment/Libraries
Source: 	%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-root
Requires:	udev
BuildRequires:  readline-devel
Prereq:         /sbin/ldconfig


%package ifd
Summary:	cyberjack PC/SC IFD handler for pcsc-lite
Requires:	%{name} = %{version}
Group:		System Environment/Libraries
Conflicts:	pcsc-cyberjack

%description ifd
REINER SCT cyberJack pinpad/e-com USB user space driver

This package includes the PC/SC IFD handler driver for the cyberJack
pinpad/e-com USB chipcard reader.

On SuSE systems it replaces the package "pcsc-cyberjack".


#%package devel
#Summary:	Development files for libctapi-cyberjack
#Requires:	%{name} = %{version}
#Group:		Development/Libraries

%description
REINER SCT cyberJack pinpad/e-com USB user space driver

This package includes the CT-API driver for the cyberJack pinpad/e-com
USB chipcard reader.

This package changes the permissions of the device to grant access to users of
the group "cyberjack".

Therefore you should add all users which are to access the reader to the
group "cyberjack".

For more information regarding installation under Linux see the README.txt
in the documentation directory, esp. regarding compatibility with host
controllers.

For more information about the reader, software updates and a shop see
http://www.reiner-sct.com/

#%description devel
#Development files for libctapi-cyberjack

%prep
%setup -q

%build
%configure --disable-static --sysconfdir="%{_sysconfdir}" --with-usbdropdir=""
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
test -d $RPM_BUILD_ROOT/%{readers_dir} || mkdir $RPM_BUILD_ROOT/%{readers_dir}
cp $RPM_BUILD_ROOT/%{_libdir}/libctapi-cyberjack.so $RPM_BUILD_ROOT/%{readers_dir}
cp $RPM_BUILD_ROOT/%{_libdir}/libctapi-cyberjack.so.* $RPM_BUILD_ROOT/%{readers_dir}
rm $RPM_BUILD_ROOT/%{_libdir}/libctapi-cyberjack.la
rm $RPM_BUILD_ROOT//ifd-cyberjack.bundle/Contents/Linux/ifd-cyberjack.la

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%pre
groupadd -r cyberjack 2>/dev/null || :

%files
%defattr(0644,root,root)

%doc COPYRIGHT.GPL COPYRIGHT.LGPL doc/README.pdf doc/README.html doc/README.txt MAKEUSBDEV tools/ctshrc.example

# hotplug (not needed for newer systems)
#%attr(0755,root,root) %{_sysconfdir}/hotplug.d/usb/usbcyberjack
#%{_sysconfdir}/hotplug/usb/cyberjack.usermap

# CT-API
%{readers_dir}/libctapi-cyberjack.so
%{readers_dir}/libctapi-cyberjack.so.*
%{_libdir}/libctapi-cyberjack.so
%{_libdir}/libctapi-cyberjack.so.*
%attr(0755,root,root) %{_bindir}/cjgeldkarte
%attr(0755,root,root) %{_bindir}/ctsh
%{_sysconfdir}/cyberjack.conf.default


%if %use_hotplug
%attr(0755,root,root) %{_sysconfdir}/hotplug/usb/usbcyberjack
%{_sysconfdir}/hotplug/usb/cyberjack.usermap
%else
%{_sysconfdir}/*
%endif

%if %use_udev
%attr(0755,root,root) /sbin/udev.cyberjack.sh
%endif


# PC/SC
%files ifd
/ifd-cyberjack.bundle/*

#%files devel
%defattr(0644,root,root)
#%{_includedir}/ctapi.h


%changelog -n ctapi-cyberjack
* Wed Aug 09 2006 - Martin Preuss <martin@libchipcard.de>
+ ctapi-cyberjack-2.0.10-2
- modified specfile to create RPMs for any RPM-based system
- now uses autotools

* Mon May 30 2005 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.9-1
- add pcsc-lite 'dropdir' compatible PC/SC driver

* Wed Mar 02 2005 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.8-1
- fix double-free bug
- update support email address to reflect current one
- fix 'make install' target
- add '-lusb' to libcyberjack_ifd (Martin Preuss)

* Sun Jan 30 2005 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.6-1
- add magic to automatically put current version number in specfile
- add 0x800 e-com direct-ttyUSBx open hack
- fix initialization errors (Martin Preuss)
- simplified Makefile System (Martin Preuss)
- Added make target "install" (Martin Preuss)
- Fixed the name of the CTAPI driver loaded by "cjgeldkarte"
- Fix typos in README.xml

* Sun Dec 19 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.5-1
- add functionality to beep at keypress
- introduce CJCTAPI_NO_KEYBEEP environment variable

* Wed Nov 17 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.4-2
- add x86_64 -fPIC patch for pcsc
- add x86_64 64bit data type patch

* Tue Nov 16 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.4-1
- fixes: gcc-2.95 compile, cjgeldkarte-getopt, SIGSEGV / ctapiClose

* Tue Nov 02 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.2-1
- fix libusb linking dependency

* Wed Aug 25 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.1-1
- Bugfixes in REINER-SCT driver for pinpad_a

* Fri Aug 13 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.0-0beta1
- final new usb ProductID (0x300) for pp_a
- Include build of pcsc library
- Include ctsh
- Include static library into -devel

* Wed Aug 11 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.0-0beta
- Update to new major release including pinpad_a support
- New dual driver shared library architecture

* Tue Mar 18 2003 - Matthias Bruestle <m@mbsks.franken.de>
- Devices are created, when not present.

* Sun May 03 2002 - Matthias Bruestle <m@mbsks.franken.de>
- Added ctsh.

* Fri Dec 21 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added cjgeldkarte.

* Fri Dec 14 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added some polish.

* Sat Dec 01 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added PC/SC IFD handler.

* Sun Aug 26 2001 - mge@suse.de
- adopted package to SuSE build system

* Sun Jun 03 2001 - Matthias Bruestle <m@mbsks.franken.de
- First version of the SPEC file.
