/*
 * rpn.c
 */

#include <stdio.h>

double val;

extern double pop(void);
extern void push(double);

extern int getsym(void);

int main(void)
{
	int sym;
	double x, y;

	while ((sym = getsym()) != EOF) {
		switch (sym) {
		case '9':
			push(val);
			break;
		case '+':
			push(pop() + pop());
			break;
		case '-':
			x = pop();
			push(x - pop());
			break;
		case '*':
			push(pop() * pop());
			break;
		case '/':
			x = pop();
			push(x / pop());
			break;
		case 'c':
			push(-pop());
			break;
		case '.':
			printf("%f\n", pop());
			break;
		case '<':
			x = pop();
			y = pop();
			push(x);
			push(y);
			break;
		default:
			fprintf(stderr, "Unknown '%c'\n", sym);
			return 1;
		}

	}
	return 0;
}
