/*
 * Decompiled with CFR 0.152.
 */
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.util.GetOpt;

class LDAPTool {
    protected static int m_ldapport = 389;
    protected static String m_binddn = null;
    protected static String m_ldaphost = "localhost";
    protected static String m_passwd = null;
    protected static int m_version = 3;
    protected static int m_debugLevel = 0;
    protected static int m_hopLimit = 10;
    protected static boolean m_referrals = true;
    protected static LDAPConnection m_client = null;
    protected static boolean m_justShow = false;
    protected static boolean m_verbose = false;
    protected static boolean m_ordinary = false;
    protected static LDAPControl m_proxyControl = null;

    LDAPTool() {
    }

    protected static GetOpt extractParameters(String string, String[] stringArray) {
        GetOpt getOpt = new GetOpt("vnRMD:h:O:p:w:d:V:y:" + string, stringArray);
        if (getOpt.hasOption('n')) {
            m_justShow = true;
        }
        if (getOpt.hasOption('v')) {
            m_verbose = true;
        }
        if (getOpt.hasOption('R')) {
            m_referrals = false;
        }
        if (getOpt.hasOption('D')) {
            m_binddn = getOpt.getOptionParam('D');
        }
        if (getOpt.hasOption('h')) {
            m_ldaphost = getOpt.getOptionParam('h');
        }
        if (getOpt.hasOption('p')) {
            try {
                m_ldapport = Integer.parseInt(getOpt.getOptionParam('p'));
            }
            catch (NumberFormatException numberFormatException) {
                m_ldapport = 389;
            }
        }
        if (getOpt.hasOption('O')) {
            try {
                m_hopLimit = Integer.parseInt(getOpt.getOptionParam('O'));
            }
            catch (NumberFormatException numberFormatException) {
                m_hopLimit = 10;
            }
        }
        if (getOpt.hasOption('d')) {
            try {
                m_debugLevel = Integer.parseInt(getOpt.getOptionParam('d'));
            }
            catch (NumberFormatException numberFormatException) {
                m_debugLevel = 0;
            }
        }
        if (getOpt.hasOption('V')) {
            try {
                m_version = Integer.parseInt(getOpt.getOptionParam('V'));
            }
            catch (NumberFormatException numberFormatException) {
                m_version = 3;
            }
        }
        if (getOpt.hasOption('w')) {
            m_passwd = getOpt.getOptionParam('w');
        }
        if (getOpt.hasOption('y')) {
            m_proxyControl = new LDAPProxiedAuthControl(getOpt.getOptionParam('y'), true);
        }
        if (getOpt.hasOption('M')) {
            m_ordinary = true;
        }
        return getOpt;
    }

    protected static void setDefaultReferralCredentials(LDAPConstraints lDAPConstraints) {
        LDAPRebind lDAPRebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String string, int n) {
                return new LDAPRebindAuth(m_client.getAuthenticationDN(), m_client.getAuthenticationPassword());
            }
        };
        lDAPConstraints.setReferrals(true);
        lDAPConstraints.setRebindProc(lDAPRebind);
    }
}

