/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private File manifestFile;
    private Manifest manifest;
    private Manifest execManifest;
    private boolean buildFileManifest = false;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void setJarfile(File file) {
        super.setZipfile(file);
    }

    public void addConfiguredManifest(Manifest manifest) throws ManifestException {
        if (this.manifest == null) {
            this.manifest = this.getDefaultManifest();
        }
        this.manifest.merge(manifest);
        this.buildFileManifest = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setManifest(File file) {
        if (!file.exists()) {
            throw new BuildException("Manifest file: " + file + " does not exist.", this.getLocation());
        }
        this.manifestFile = file;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                Manifest manifest = new Manifest(fileInputStream);
                if (this.manifest == null) {
                    this.manifest = this.getDefaultManifest();
                }
                this.manifest.merge(manifest);
            }
            catch (ManifestException manifestException) {
                this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
                throw new BuildException("Invalid Manifest: " + file, manifestException, this.getLocation());
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: " + file, iOException);
            }
            Object var6_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    public void addMetainf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("META-INF/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        try {
            if (this.manifest == null) {
                this.execManifest = null;
            } else {
                this.execManifest = new Manifest();
                this.execManifest.merge(this.manifest);
            }
            this.zipDir(null, zipOutputStream, "META-INF/");
            super.initZipOutputStream(zipOutputStream);
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }

    private Manifest getDefaultManifest() {
        try {
            String string = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                throw new BuildException("Could not find default manifest: " + string);
            }
            return new Manifest(inputStream);
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Default manifest is invalid !!");
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read default manifest", iOException);
        }
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.execManifest == null) {
            this.execManifest = this.getDefaultManifest();
        }
        Enumeration enumeration = this.execManifest.getWarnings();
        while (enumeration.hasMoreElements()) {
            this.log("Manifest warning: " + (String)enumeration.nextElement(), 1);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        this.execManifest.write(printWriter);
        printWriter.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.zipFile(byteArrayInputStream, zipOutputStream, "META-INF/MANIFEST.MF", System.currentTimeMillis());
        super.finalizeZipOutputStream(zipOutputStream);
    }

    private void zipManifestEntry(InputStream inputStream) throws IOException {
        try {
            if (this.execManifest == null) {
                this.execManifest = new Manifest(inputStream);
            } else if (this.isAddingNewFiles()) {
                this.execManifest.merge(new Manifest(inputStream));
            }
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (!string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            super.zipFile(file, zipOutputStream, string);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.zipManifestEntry(fileInputStream);
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: " + file, iOException);
            }
            Object var7_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l) throws IOException {
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            try {
                this.zipManifestEntry(inputStream);
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: ", iOException);
            }
        } else {
            super.zipFile(inputStream, zipOutputStream, string, l);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUpToDate(FileScanner[] var1_1, File var2_2) throws BuildException {
        block15: {
            block16: {
                block14: {
                    if (!this.buildFileManifest && this.manifestFile != null) {
                        if (this.manifestFile.lastModified() <= var2_2.lastModified()) return super.isUpToDate(var1_1, var2_2);
                        return false;
                    }
                    var3_3 = null;
                    try {
                        try {
                            var3_3 = new ZipFile(var2_2);
                            var4_4 = var3_3.getEntry("META-INF/MANIFEST.MF");
                            if (var4_4 == null) {
                                this.log("Updating jar since the current jar has no manifest", 3);
                                var5_6 = false;
                                var8_9 = null;
                                if (var3_3 == null) return var5_6;
                                break block14;
                            }
                            var5_7 = new Manifest(var3_3.getInputStream(var4_4));
                            if (this.manifest == null) {
                                this.manifest = this.getDefaultManifest();
                            }
                            if (var5_7.equals(this.manifest)) break block15;
                            this.log("Updating jar since jar manifest has changed", 3);
                            var6_19 = false;
                            break block16;
                        }
                        catch (Exception var4_5) {
                            this.log("Updating jar since cannot read current jar manifest: " + var4_5.getClass().getName() + var4_5.getMessage(), 3);
                            var5_8 = false;
                            var8_12 = null;
                            if (var3_3 == null) return var5_8;
                            try {
                                var3_3.close();
                                return var5_8;
                            }
                            catch (IOException var9_17) {
                                // empty catch block
                            }
                            return var5_8;
                        }
                    }
                    catch (Throwable var7_20) {
                        var8_13 = null;
                        if (var3_3 == null) throw var7_20;
                        ** try [egrp 2[TRYBLOCK] [2 : 182->189)] { 
lbl41:
                        // 1 sources

                        var3_3.close();
                        throw var7_20;
lbl43:
                        // 1 sources

                        catch (IOException var9_18) {
                            // empty catch block
                        }
                        throw var7_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 182->189)] { 
lbl48:
                // 1 sources

                var3_3.close();
                return var5_6;
lbl50:
                // 1 sources

                catch (IOException var9_14) {
                    // empty catch block
                }
                return var5_6;
            }
            var8_10 = null;
            if (var3_3 == null) return var6_19;
            ** try [egrp 2[TRYBLOCK] [2 : 182->189)] { 
lbl57:
            // 1 sources

            var3_3.close();
            return var6_19;
lbl59:
            // 1 sources

            catch (IOException var9_15) {
                // empty catch block
            }
            return var6_19;
        }
        var8_11 = null;
        if (var3_3 == null) return super.isUpToDate(var1_1, var2_2);
        try {}
        catch (IOException var9_16) {}
        var3_3.close();
        return super.isUpToDate(var1_1, var2_2);
        return super.isUpToDate(var1_1, var2_2);
    }

    protected boolean createEmptyZip(File file) {
        return false;
    }

    protected void cleanUp() {
        super.cleanUp();
    }
}

