/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import java.util.Hashtable;
import org.exolab.adaptx.util.List;
import org.exolab.adaptx.xml.AttributeListImpl;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathParser;
import org.exolab.adaptx.xslt.ActionIterator;
import org.exolab.adaptx.xslt.ActionTemplate;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.XSLText;
import org.exolab.adaptx.xslt.util.ActionTemplateImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;

public class XSLObject {
    private static final String DEFAULT_NAME = "xsl:element";
    private static final String DEFAULT_NS_DECL = "xmlns";
    private static final String PREFIX_NS_DECL = "xmlns:";
    public static final short APPLY_IMPORTS = 0;
    public static final short APPLY_TEMPLATES = 1;
    public static final short ARG = 2;
    public static final short ATTRIBUTE = 3;
    public static final short ATTRIBUTE_SET = 4;
    public static final short CALL_TEMPLATE = 5;
    public static final short CDATA = 6;
    public static final short CHOOSE = 7;
    public static final short COMMENT = 8;
    public static final short CONTENTS = 9;
    public static final short COPY = 10;
    public static final short COPY_OF = 11;
    public static final short ELEMENT = 12;
    public static final short FOR_EACH = 13;
    public static final short FUNCTIONS = 14;
    public static final short ID = 15;
    public static final short IF = 16;
    public static final short IMPORT = 17;
    public static final short INCLUDE = 18;
    public static final short KEY = 19;
    public static final short LITERAL = 20;
    public static final short LOCALE = 21;
    public static final short MESSAGE = 22;
    public static final short NUMBER = 23;
    public static final short OTHERWISE = 24;
    public static final short OUTPUT = 25;
    public static final short PARAM = 26;
    public static final short PI = 27;
    public static final short PRESERVE_SPACE = 28;
    public static final short SORT = 29;
    public static final short STRIP_SPACE = 30;
    public static final short STYLESHEET = 31;
    public static final short TEMPLATE = 32;
    public static final short TEXT = 33;
    public static final short VALUE_OF = 34;
    public static final short VARIABLE = 35;
    public static final short WHEN = 36;
    public static final short WITH_PARAM = 37;
    public static final short ENTITY_REF = 38;
    public static final short SCRIPT = 39;
    private static final short MAX_TYPE = 40;
    private short type = (short)20;
    private ActionTemplateImpl actions = null;
    private AttributeListImpl attributes = null;
    private List readOnlyAttrs = null;
    private boolean allowActions = true;
    private XSLTStylesheet parentStylesheet = null;
    private XSLObject parent = null;
    private String typeName = "xsl:element";
    private Hashtable namespaces = null;
    private static final Hashtable typeNames = XSLObject.buildNameHash();
    private static final XPathParser _parser = new XPathParser();

    static {
        _parser.setUseErrorExpr(true);
    }

    public XSLObject(short s) {
        this.type = s;
        this.typeName = XSLObject.getNameFromType(s);
        this.attributes = new AttributeListImpl(5);
        this.actions = new ActionTemplateImpl();
        this.readOnlyAttrs = new List(0);
        this.namespaces = new Hashtable(3);
    }

    public boolean appendAction(XSLObject xSLObject) {
        if (!this.allowActions) {
            return false;
        }
        if (this.handleAction(xSLObject)) {
            return true;
        }
        if (!this.actions.addAction(xSLObject)) {
            return false;
        }
        xSLObject.setParent(this);
        return true;
    }

    public void appendText(String string) {
        XSLText xSLText;
        if (!this.allowActions) {
            return;
        }
        XSLObject xSLObject = this.actions.lastAction();
        if (xSLObject != null && xSLObject.getType() == 33 && !(xSLText = (XSLText)xSLObject).disableOutputEscaping()) {
            xSLText.appendText(string);
            return;
        }
        xSLText = new XSLText(string);
        this.actions.addAction(xSLText);
        xSLText.setParent(this);
    }

    public void appendText(char[] cArray, int n, int n2) {
        XSLText xSLText;
        if (!this.allowActions) {
            return;
        }
        XSLObject xSLObject = this.actions.lastAction();
        if (xSLObject != null && xSLObject.getType() == 33 && !(xSLText = (XSLText)xSLObject).disableOutputEscaping()) {
            xSLText.appendText(cArray, n, n2);
            return;
        }
        xSLText = new XSLText();
        xSLText.appendText(cArray, n, n2);
        this.actions.addAction(xSLText);
        xSLText.setParent(this);
    }

    private static Hashtable buildNameHash() {
        Hashtable<String, Short> hashtable = new Hashtable<String, Short>();
        short s = 0;
        while (s < 40) {
            hashtable.put(XSLObject.getNameFromType(s), new Short(s));
            s = (short)(s + 1);
        }
        hashtable.put("transform", new Short(31));
        return hashtable;
    }

    protected void copyActions(XSLObject xSLObject) {
        ActionTemplate actionTemplate = xSLObject.getActions();
        if (actionTemplate.size() > 0) {
            ActionIterator actionIterator = actionTemplate.actions();
            while (actionIterator.hasNext()) {
                this.appendAction(actionIterator.next());
            }
        }
    }

    protected void copyAttributes(XSLObject xSLObject) {
        xSLObject.copyAttributesInto(this.attributes);
    }

    protected void copyAttributesInto(AttributeListImpl attributeListImpl) {
        if (attributeListImpl == null) {
            return;
        }
        int n = this.attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            attributeListImpl.addAttribute(this.attributes.getName(n2), this.attributes.getValue(n2));
            ++n2;
        }
    }

    protected final XPathExpression createExpression(String string) throws XPathException {
        return _parser.createExpression(string);
    }

    protected final XPathExpression createSelectExpression(String string) throws XPathException {
        return _parser.createSelectExpression(string);
    }

    public ActionTemplate getActions() {
        return this.actions;
    }

    public String getAttribute(String string) {
        if (string != null) {
            return this.attributes.getValue(string);
        }
        return null;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    private static String getNameFromType(short s) {
        switch (s) {
            case 0: {
                return "apply-imports";
            }
            case 1: {
                return "apply-templates";
            }
            case 3: {
                return "attribute";
            }
            case 4: {
                return "attribute-set";
            }
            case 5: {
                return "call-template";
            }
            case 6: {
                return "cdata";
            }
            case 7: {
                return "choose";
            }
            case 8: {
                return "comment";
            }
            case 10: {
                return "copy";
            }
            case 11: {
                return "copy-of";
            }
            case 12: {
                return "element";
            }
            case 38: {
                return "entity-ref";
            }
            case 13: {
                return "for-each";
            }
            case 14: {
                return "functions";
            }
            case 15: {
                return "id";
            }
            case 16: {
                return "if";
            }
            case 17: {
                return "import";
            }
            case 18: {
                return "include";
            }
            case 19: {
                return "key";
            }
            case 21: {
                return "locale";
            }
            case 22: {
                return "message";
            }
            case 23: {
                return "number";
            }
            case 24: {
                return "otherwise";
            }
            case 25: {
                return "output";
            }
            case 26: {
                return "param";
            }
            case 27: {
                return "processing-instruction";
            }
            case 28: {
                return "preserve-space";
            }
            case 29: {
                return "sort";
            }
            case 30: {
                return "strip-space";
            }
            case 31: {
                return "stylesheet";
            }
            case 32: {
                return "template";
            }
            case 33: {
                return "text";
            }
            case 34: {
                return "value-of";
            }
            case 35: {
                return "variable";
            }
            case 36: {
                return "when";
            }
            case 37: {
                return "with-param";
            }
            case 39: {
                return "script";
            }
        }
        return DEFAULT_NAME;
    }

    public XSLObject getNearestAncestor(short s) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getType() == s) {
            return this.parent;
        }
        return this.parent.getNearestAncestor(s);
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 9: {
                return XSLObject.getNodeValue(((Document)node).getDocumentElement());
            }
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    stringBuffer.append(XSLObject.getNodeValue(nodeList.item(n)));
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 1: {
                return XSLObject.getText((Element)node);
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: 
            case 4: {
                return ((Text)node).getData();
            }
            case 8: {
                return ((Comment)node).getData();
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
        }
        return "";
    }

    protected XSLObject getParent() {
        return this.parent;
    }

    public XSLTStylesheet getStylesheet() {
        if (this.type == 31) {
            return (XSLTStylesheet)this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getStylesheet();
    }

    public static String getText(Element element) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    if (n == 1) {
                        return ((Text)node).getData();
                    }
                    stringBuffer.append(((Text)node).getData());
                    break;
                }
                case 1: {
                    if (n == 1) {
                        return XSLObject.getText((Element)node);
                    }
                    stringBuffer.append(XSLObject.getText((Element)node));
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final short getType() {
        return this.type;
    }

    public static short getTypeFromName(String string) {
        Short s = (Short)typeNames.get(string);
        if (s == null) {
            return 20;
        }
        return s;
    }

    public String getTypeName() {
        return this.typeName;
    }

    protected boolean handleAction(XSLObject xSLObject) {
        return false;
    }

    protected void makeAttrReadOnly(String string) {
        this.readOnlyAttrs.add(string);
    }

    public String resolveNamespace(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if ((string2 = (String)this.namespaces.get(string)) != null) {
            return string2;
        }
        if (this.parent != null) {
            return this.parent.resolveNamespace(string);
        }
        return null;
    }

    public void setAllowActions(boolean bl) {
        this.allowActions = bl;
    }

    public void setAttribute(String string, String string2) throws XSLException {
        if (string != null && string2 != null) {
            if (string.equals(DEFAULT_NS_DECL)) {
                this.namespaces.put("", string2);
                this.attributes.addAttribute(string, string2);
            } else if (string.startsWith(PREFIX_NS_DECL)) {
                String string3 = string.substring(PREFIX_NS_DECL.length());
                this.namespaces.put(string3, string2);
                this.attributes.addAttribute(string, string2);
            } else {
                if (this.readOnlyAttrs.contains(string)) {
                    StringBuffer stringBuffer = new StringBuffer("The attribute '");
                    stringBuffer.append(string);
                    stringBuffer.append("' has been set to read only for this ");
                    stringBuffer.append(this.getTypeName());
                    stringBuffer.append(" and cannot be changed.");
                    throw new XSLException(stringBuffer.toString());
                }
                this.attributes.addAttribute(string, string2);
            }
        }
    }

    protected void setParent(XSLObject xSLObject) {
        this.parent = xSLObject;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }
}

