/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.AttributeExpr;
import org.exolab.adaptx.xpath.engine.AxisIdentifier;
import org.exolab.adaptx.xpath.engine.ElementExpr;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.FilterBase;
import org.exolab.adaptx.xpath.engine.NodeExpression;

class LocationStep
extends FilterBase {
    public static final short ANCESTORS_AXIS = 0;
    public static final short ANCESTORS_OR_SELF_AXIS = 1;
    public static final short ATTRIBUTES_AXIS = 2;
    public static final short CHILDREN_AXIS = 3;
    public static final short DESCENDANTS_AXIS = 4;
    public static final short DESCENDANTS_OR_SELF_AXIS = 5;
    public static final short FOLLOWING_AXIS = 6;
    public static final short FOLLOWING_SIBLINGS_AXIS = 7;
    public static final short PARENT_AXIS = 8;
    public static final short PRECEDING_AXIS = 9;
    public static final short PRECEDING_SIBLINGS_AXIS = 10;
    public static final short SELF_AXIS = 11;
    public static final short NAMESPACE_AXIS = 12;
    private static final String AXIS_SEPARATOR = "::";
    private short axisIdentifier = (short)3;
    private NodeExpression nodeExpr = null;
    private ErrorExpr error = null;

    protected LocationStep(int n) {
        super(n);
    }

    protected LocationStep(int n, short s) {
        super(n);
        this.axisIdentifier = s;
    }

    protected LocationStep(ErrorExpr errorExpr) {
        super(0);
        this.error = errorExpr;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode;
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        if ((xPathNode = xPathContext.getNode()) == null || this.nodeExpr == null) {
            return xPathContext.newNodeSet();
        }
        NodeSet nodeSet = null;
        switch (this.axisIdentifier) {
            case 0: {
                nodeSet = AxisIdentifier.fromAncestors(this.nodeExpr, xPathContext);
                break;
            }
            case 1: {
                nodeSet = AxisIdentifier.fromAncestorsOrSelf(this.nodeExpr, xPathContext);
                break;
            }
            case 2: {
                nodeSet = AxisIdentifier.fromAttributes(this.nodeExpr, xPathContext);
                break;
            }
            case 12: {
                nodeSet = AxisIdentifier.fromNamespaces(this.nodeExpr, xPathContext);
                break;
            }
            case 4: {
                nodeSet = AxisIdentifier.fromDescendants(this.nodeExpr, xPathContext);
                break;
            }
            case 5: {
                nodeSet = AxisIdentifier.fromDescendantsOrSelf(this.nodeExpr, xPathContext);
                break;
            }
            case 6: {
                nodeSet = AxisIdentifier.fromFollowing(this.nodeExpr, xPathContext);
                break;
            }
            case 7: {
                nodeSet = AxisIdentifier.fromFollowingSiblings(this.nodeExpr, xPathContext);
                break;
            }
            case 8: {
                nodeSet = AxisIdentifier.fromParent(this.nodeExpr, xPathContext);
                break;
            }
            case 9: {
                nodeSet = AxisIdentifier.fromPreceding(this.nodeExpr, xPathContext);
                break;
            }
            case 10: {
                nodeSet = AxisIdentifier.fromPrecedingSiblings(this.nodeExpr, xPathContext);
                break;
            }
            case 11: {
                nodeSet = AxisIdentifier.fromSelf(this.nodeExpr, xPathContext);
                break;
            }
            default: {
                nodeSet = AxisIdentifier.fromChildren(this.nodeExpr, xPathContext);
            }
        }
        if (this.hasPredicates()) {
            this.evaluatePredicates(nodeSet, xPathContext);
        }
        return nodeSet;
    }

    public short getAxisIdentifier() {
        return this.axisIdentifier;
    }

    public double getDefaultPriority() {
        if (this.nodeExpr == null) {
            return -0.5;
        }
        double d = -0.5;
        switch (this.nodeExpr.getNodeExprType()) {
            case 8: {
                d = 0.0;
                break;
            }
            case 2: {
                d = ((ElementExpr)this.nodeExpr).getDefaultPriority();
                break;
            }
            case 1: {
                d = ((AttributeExpr)this.nodeExpr).getDefaultPriority();
                break;
            }
        }
        if (this.getPredicate() != null) {
            d = 0.5;
        }
        return d;
    }

    public short getExprType() {
        return 7;
    }

    protected NodeExpression getNodeExpr() {
        return this.nodeExpr;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (this.nodeExpr == null) {
            return false;
        }
        if (this.hasPredicates()) {
            NodeSet nodeSet = (NodeSet)this.evaluate(xPathContext);
            return nodeSet.contains(xPathNode);
        }
        return this.nodeExpr.matches(xPathNode, xPathContext);
    }

    public void setAxisIdentifier(short s) {
        this.axisIdentifier = s;
    }

    protected void setNodeExpr(NodeExpression nodeExpression) {
        this.nodeExpr = nodeExpression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        switch (this.axisIdentifier) {
            case 0: {
                stringBuffer.append("ancestor");
                break;
            }
            case 1: {
                stringBuffer.append("ancestor-or-self");
                break;
            }
            case 2: {
                stringBuffer.append("attribute");
                break;
            }
            case 4: {
                stringBuffer.append("descendant");
                break;
            }
            case 5: {
                stringBuffer.append("descendant-or-self");
                break;
            }
            case 6: {
                stringBuffer.append("following");
                break;
            }
            case 7: {
                stringBuffer.append("following-sibling");
                break;
            }
            case 8: {
                stringBuffer.append("parent");
                break;
            }
            case 9: {
                stringBuffer.append("preceding");
                break;
            }
            case 10: {
                stringBuffer.append("preceding-sibling");
                break;
            }
            case 11: {
                stringBuffer.append("self");
                break;
            }
            case 12: {
                stringBuffer.append("namespace");
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            stringBuffer.append(AXIS_SEPARATOR);
        }
        if (this.nodeExpr == null) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(this.nodeExpr.toString());
            stringBuffer.append(super.toString());
        }
        return stringBuffer.toString();
    }
}

