/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import org.exolab.adaptx.xpath.VariableSet;
import org.exolab.adaptx.xpath.VariableSetImpl;
import org.exolab.adaptx.xpath.XPathResult;

public final class ScopedVariableSet {
    public static final int DEFAULT_SIZE = 7;
    private int _top = 0;
    private VariableSetImpl[] _variableSets = null;

    public ScopedVariableSet() {
        this(7);
    }

    public ScopedVariableSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size must be non negative");
        }
        if (n == 0) {
            this._top = -1;
            return;
        }
        this._variableSets = new VariableSetImpl[n];
        VariableSetImpl variableSetImpl = null;
        int n2 = 0;
        while (n2 < n) {
            this._variableSets[n2] = new VariableSetImpl(variableSetImpl);
            variableSetImpl = this._variableSets[n2];
            ++n2;
        }
    }

    public void add() {
        if (this._variableSets == null) {
            this._variableSets = new VariableSetImpl[1];
            this._variableSets[0] = new VariableSetImpl();
            this._top = 0;
        } else {
            ++this._top;
            if (this._top == this._variableSets.length) {
                VariableSetImpl[] variableSetImplArray = this._variableSets;
                this._variableSets = new VariableSetImpl[this._variableSets.length + 1];
                int n = 0;
                while (n < variableSetImplArray.length) {
                    this._variableSets[n] = variableSetImplArray[n];
                    ++n;
                }
                this._variableSets[this._top] = new VariableSetImpl(this._variableSets[this._top - 1]);
            }
        }
    }

    public VariableSet current() {
        if (this._variableSets == null) {
            return null;
        }
        return this._variableSets[this._top];
    }

    public XPathResult getVariable(String string) {
        if (this._variableSets == null) {
            return null;
        }
        return this._variableSets[this._top].getVariable(string);
    }

    public void remove() {
        if (this._top <= 0) {
            return;
        }
        this._variableSets[this._top].clear();
        --this._top;
    }

    public void setVariable(String string, XPathResult xPathResult) {
        if (this._variableSets == null) {
            this.add();
        }
        this._variableSets[this._top].setVariable(string, xPathResult);
    }
}

