/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.StringResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.FunctionCall;

public class XMLNamesFunctionCall
extends FunctionCall {
    public static final short LOCAL_PART = 1;
    public static final short NAME = 2;
    public static final short NAMESPACE = 3;
    private short fType = (short)2;

    public XMLNamesFunctionCall() {
        super("name");
    }

    public XMLNamesFunctionCall(short s) {
        super(XMLNamesFunctionCall.getFunctionName(s));
        this.fType = s;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathResult xPathResult;
        XPathNode xPathNode = xPathContext.getNode();
        Object var3_3 = null;
        if (this.getParameterCount() == 1 && (xPathResult = this.getParameter(0).evaluate(xPathContext)).getResultType() == 3) {
            NodeSet nodeSet = (NodeSet)xPathResult;
            xPathNode = nodeSet.size() > 0 ? nodeSet.item(0) : null;
        }
        if (xPathNode != null && (xPathNode.getNodeType() == 1 || xPathNode.getNodeType() == 2)) {
            switch (this.fType) {
                case 1: {
                    return new StringResult(xPathNode.getLocalName());
                }
                case 3: {
                    return new StringResult(xPathNode.getNamespaceURI());
                }
            }
            return new StringResult(xPathNode.getLocalName());
        }
        return StringResult.EMPTY;
    }

    private static String getFunctionName(short s) {
        switch (s) {
            case 1: {
                return "local-part";
            }
            case 3: {
                return "namespace";
            }
        }
        return "name";
    }

    private static String getLocalPart(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static String getNameSpace(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }
}

