/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.BinaryExpr;

class SubtractionExpr
extends BinaryExpr {
    public SubtractionExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        double d = 0.0;
        XPathExpression xPathExpression = this.getLeftSide();
        XPathExpression xPathExpression2 = this.getRightSide();
        if (xPathExpression == null || xPathExpression2 == null) {
            return NumberResult.NaN;
        }
        XPathResult xPathResult = xPathExpression2.evaluate(xPathContext);
        XPathResult xPathResult2 = xPathExpression.evaluate(xPathContext);
        return new NumberResult(xPathResult2.numberValue() - xPathResult.numberValue());
    }

    public short getExprType() {
        return 4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        XPathExpression xPathExpression = this.getLeftSide();
        if (xPathExpression != null) {
            stringBuffer.append(xPathExpression.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" - ");
        xPathExpression = this.getRightSide();
        if (xPathExpression != null) {
            stringBuffer.append(xPathExpression.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

