/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml.parser;

import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesParser
implements DOMParser {
    private org.apache.xerces.parsers.DOMParser parser = null;
    private boolean validate = false;
    private boolean initialized = false;

    public DOMParser copyInstance() {
        XercesParser xercesParser = new XercesParser();
        xercesParser.validate = this.validate;
        return xercesParser;
    }

    public Document createDocument() {
        return new DocumentImpl();
    }

    private void init() {
        this.parser = new org.apache.xerces.parsers.DOMParser();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", this.validate);
        }
        catch (Exception exception) {}
    }

    public Document readDocument(URILocation uRILocation, ErrorObserver errorObserver) {
        if (!this.initialized) {
            this.init();
        }
        Document document = null;
        try {
            InputSource inputSource = new InputSource(uRILocation.getReader());
            inputSource.setSystemId(uRILocation.getAbsoluteURI());
            this.parser.parse(inputSource);
            document = this.parser.getDocument();
        }
        catch (IOException iOException) {
            String string = "error while trying to read document '";
            string = String.valueOf(string) + uRILocation.getAbsoluteURI() + "';\n " + iOException.toString();
            if (errorObserver != null) {
                errorObserver.receiveError(string, 0);
            } else {
                System.out.println(string);
            }
        }
        catch (SAXException sAXException) {
            String string = "error while trying to read document '";
            string = String.valueOf(string) + uRILocation.getAbsoluteURI() + "';\n " + sAXException.getMessage();
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                string = String.valueOf(string) + "\n   -- error occured at line ";
                string = String.valueOf(string) + sAXParseException.getLineNumber();
                string = String.valueOf(string) + ", column " + sAXParseException.getColumnNumber();
            }
            if (errorObserver != null) {
                errorObserver.receiveError(string, 0);
            }
            System.out.println(string);
        }
        return document;
    }

    public void setDocumentType(Document document, String string) {
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
        this.initialized = false;
    }
}

