/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.util;

import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.util.List;

public abstract class ErrorObserverAdapter
implements ErrorObserver {
    private List _errorObservers = null;

    public void addErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        if (this._errorObservers == null) {
            this._errorObservers = new List(3);
            this._errorObservers.add(errorObserver);
        } else if (!this._errorObservers.contains(errorObserver)) {
            this._errorObservers.add(errorObserver);
        }
    }

    public void receiveError(Exception exception) {
        this.receiveError(exception, 1);
    }

    public void receiveError(Exception exception, int n) {
        if (this._errorObservers != null) {
            int n2 = 0;
            while (n2 < this._errorObservers.size()) {
                ErrorObserver errorObserver = (ErrorObserver)this._errorObservers.get(n2);
                errorObserver.receiveError(exception, n);
                ++n2;
            }
        }
    }

    public void receiveError(Exception exception, String string) {
        this.receiveError(exception, string, 1);
    }

    public void receiveError(Exception exception, String string, int n) {
        if (this._errorObservers != null) {
            int n2 = 0;
            while (n2 < this._errorObservers.size()) {
                ErrorObserver errorObserver = (ErrorObserver)this._errorObservers.get(n2);
                errorObserver.receiveError(exception, string, n);
                ++n2;
            }
        }
    }

    public void receiveError(String string) {
        this.receiveError(string, 1);
    }

    public void receiveError(String string, int n) {
        if (this._errorObservers != null) {
            int n2 = 0;
            while (n2 < this._errorObservers.size()) {
                ErrorObserver errorObserver = (ErrorObserver)this._errorObservers.get(n2);
                errorObserver.receiveError(string, n);
                ++n2;
            }
        }
    }

    public void removeAllErrorObservers() {
        if (this._errorObservers != null) {
            this._errorObservers.clear();
        }
    }

    public void removeErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        if (this._errorObservers != null) {
            this._errorObservers.remove(errorObserver);
        }
    }
}

