/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2006  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <dbus/dbus-glib.h>

#include "device.h"

#define BLUETOOTH_DEVICE_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE((obj), \
				BLUETOOTH_TYPE_DEVICE, BluetoothDevicePrivate))

typedef struct _BluetoothDevicePrivate BluetoothDevicePrivate;

struct _BluetoothDevicePrivate {
	gchar *address;
	gchar *name;
};

G_DEFINE_TYPE(BluetoothDevice, bluetooth_device, G_TYPE_OBJECT)

static void bluetooth_device_init(BluetoothDevice *self)
{
	BluetoothDevicePrivate *priv = BLUETOOTH_DEVICE_GET_PRIVATE(self);

	priv->address = NULL;
	priv->name = NULL;
}

static void bluetooth_device_finalize(GObject *object)
{
	BluetoothDevicePrivate *priv = BLUETOOTH_DEVICE_GET_PRIVATE(object);

	g_free(priv->name);
	g_free(priv->address);
}

enum {
	PROP_0,
	PROP_NAME
};

static void bluetooth_device_set_property(GObject *object, guint prop_id,
					const GValue *value, GParamSpec *pspec)
{
	BluetoothDevicePrivate *priv = BLUETOOTH_DEVICE_GET_PRIVATE(object);

	switch (prop_id) {
	case PROP_NAME:
		if (priv->name)
			g_free(priv->name);
		priv->name = g_strdup(g_value_get_string(value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void bluetooth_device_get_property(GObject *object, guint prop_id,
					GValue *value, GParamSpec *pspec)
{
	BluetoothDevicePrivate *priv = BLUETOOTH_DEVICE_GET_PRIVATE(object);

	switch (prop_id) {
	case PROP_NAME:
		g_value_set_string(value, priv->name);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void bluetooth_device_class_init(BluetoothDeviceClass *klass)
{
	g_type_class_add_private(klass, sizeof(BluetoothDevicePrivate));

	G_OBJECT_CLASS(klass)->finalize = bluetooth_device_finalize;

	G_OBJECT_CLASS(klass)->set_property = bluetooth_device_set_property;
	G_OBJECT_CLASS(klass)->get_property = bluetooth_device_get_property;

	g_object_class_install_property(G_OBJECT_CLASS(klass),
				PROP_NAME, g_param_spec_string("name",
					NULL, NULL, NULL, G_PARAM_READWRITE));
}

BluetoothDevice *bluetooth_device_new(void)
{
	return g_object_new(BLUETOOTH_TYPE_DEVICE, NULL);
}
