#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple update tests
# Copyright © 2004 Aaron Bentley <aaron.bentley@utoronto.ca>
#
# This file is licensed under the General Public License v2, or at your
# preference, any later version.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

test_class "apply-changeset"
setup_with_patch_1 ()
{
  setup_with_trivial_archives
  tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hw-2
  tla my-default-archive jane@example.com--2003
  tla commit -d hw-2 -s "Need a changeset"
}

begin_test_savectx "apply-changeset in a working tree"
setup_with_patch_1
cd hw-2
tla get-changeset jane@example.com--2003/hello-world--mainline--1.0--patch-1
tla undo -n jane@example.com--2003/hello-world--mainline--1.0--base-0
tla apply-changeset hello-world--mainline--1.0--patch-1.patches
cd ..
end_test_savectx
