/* file-diffs.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/exception.h"
#include "hackerlab/fs/file-names.h"
#include "hackerlab/char/str.h"
#include "hackerlab/vu/safe.h"
#include "hackerlab/char/pika-escaping-utils.h"
#include "libarch/diffs.h"
#include "libarch/cached-inventory.h"
#include "libarch/local-cache.h"
#include "libarch/inv-ids.h"
#include "libarch/file-diffs.h"



int
arch_file_get_or_diff (int out_fd, int chatter_fd, arch_project_tree_t * tree, t_uchar * mod_loc, t_uchar * archive, t_uchar * revision, int diff, int new_is_null, int escape_classes)
{
  t_uchar * mod_path = 0;
  t_uchar * id = 0;
  t_uchar * cached_tree = 0;
  rel_table index = 0;
  int x;
  t_uchar * orig_loc = 0;
  t_uchar * orig_path = 0;
  int status = 2;

  mod_path = file_name_in_vicinity (0, tree->root, mod_loc);
  safe_chdir (tree->root);
  id = arch_inventory_id (tree, mod_loc, 0); /* mod_loc is tree relative */

  cached_tree = arch_find_or_make_local_copy (chatter_fd, tree, 0, 0, archive, revision);
  if (!cached_tree)
    {
      safe_printfmt (2, "arch_file_diffs: tree not found in cache for comparison -- %s/%s\n", archive, revision);
    }

  /* RBC 20050320 I suspect there is a bug here w.r.t cached tree usage */
    {
      arch_project_tree_t * tree;
      tree = arch_project_tree_new (talloc_context, cached_tree);
      index = arch_cached_index (tree);
      arch_project_tree_delete (tree);
    }
  
  for (x = 0; x < rel_n_records (index); ++x)
    {
      if (!str_cmp (id, index[x][1]))
        {
          orig_loc = str_save (0, index[x][0]);
          orig_path = file_name_in_vicinity (0, cached_tree, index[x][0]);
          break;
        }
    }

  if (!orig_path && !new_is_null)
    {
      safe_printfmt (out_fd, "new file (not present in %s/%s)\n", archive, revision);
      status = 1;
    }
  else
    {
      if (diff)
        {
          status = arch_invoke_diff (out_fd, orig_path ? orig_path : (t_uchar *)"/dev/null", orig_loc, mod_path, mod_loc, 0, 0);
        }
      else
        {
          t_uchar * escaped_tmp;
          escaped_tmp = pika_save_escape_iso8859_1 (0, 0, escape_classes, orig_path ? orig_path : (t_uchar *)"/dev/null");
          safe_printfmt (out_fd, "%s\n", escaped_tmp);
          status = 0;
          lim_free (0, escaped_tmp);
        }
    }


  lim_free (0, mod_path);
  lim_free (0, id);
  lim_free (0, cached_tree);
  rel_free_table (index);
  lim_free (0, orig_loc);
  lim_free (0, orig_path);

  return status;
}



/* tag: Tom Lord Fri May 30 20:19:00 2003 (file-diffs.c)
 */
