/* cached-inventory.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/exception.h"
#include "hackerlab/fs/file-names.h"
#include "hackerlab/vu/safe.h"
#include "libfsutils/rmrf.h"
#include "libfsutils/tmp-files.h"
#include "libarch/invent.h"
#include "libarch/changeset-utils.h"
#include "libarch/cached-inventory.h"



rel_table
arch_cached_index (arch_project_tree_t * tree)
{
  t_uchar * inventory_path = 0;
  rel_table answer = 0;

  inventory_path = file_name_in_vicinity (0, tree->root, ",,index");

  if (!safe_access (inventory_path, F_OK))
    {
      answer = arch_read_changeset_index (inventory_path);
      rel_sort_table_by_field (0, answer, 1);
    }
  else
    {
      t_uchar * tmp = 0;
      int out_fd = -1;

      answer = arch_source_inventory (tree, 1, 0, 0);
      rel_sort_table_by_field (0, answer, 1);

      tmp = talloc_tmp_file_name (talloc_context, tree->root, ",,index");
      rmrf_file (tmp);

      out_fd = safe_open (tmp, O_WRONLY | O_CREAT | O_EXCL, 0444);
      rel_print_table (out_fd, answer);
      safe_close (out_fd);

      safe_rename (tmp, inventory_path);

      talloc_free (tmp);
    }


  lim_free (0, inventory_path);
  return answer;
}



/* tag: Tom Lord Fri May 30 20:13:03 2003 (cached-inventory.c)
 */
