/*\ XMMS - Cross-platform multimedia player
|*| Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas,
|*|                             Thomas Nilsson and 4Front Technologies
|*|
|*| CD audio data input plugin by Willem Monsuwe (willem@stack.nl)
|*|
|*| This program is free software; you can redistribute it and/or modify
|*| it under the terms of the GNU General Public License as published by
|*| the Free Software Foundation; either version 2 of the License, or
|*| (at your option) any later version.
|*|
|*| This program is distributed in the hope that it will be useful,
|*| but WITHOUT ANY WARRANTY; without even the implied warranty of
|*| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*| GNU General Public License for more details.
|*|
|*| You should have received a copy of the GNU General Public License
|*| along with this program; if not, write to the Free Software
|*| Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\*/

/*\
|*|  File info box
\*/

#include "cdread.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>

static GtkWidget *info_win, *info_table, *title_entry, *scroll_win;
static GtkWidget *info_trk_label[100], *info_trk_entry[100];
static GtkObject *info_win_vadj;
static gint info_ntrk;
static guint32 info_discid;

static void
cd_file_info_ok_cb(GtkWidget *w, gpointer data)
{
	struct cd_struct *cd;
	CD_LOCK();
	cd = cd_list;
	while (cd) {
		gint i;
		gchar **tt;
		if (info_discid != cd->id) {
			cd = cd->next;
			continue;
		}
		TT_LOCK();
		tt = cd->ttitle + cd->first_trk;
		for (i = info_ntrk; --i >= 0; ) {
			if (tt[i]) g_free(tt[i]);
			tt[i] = g_strdup(gtk_entry_get_text(
						GTK_ENTRY(info_trk_entry[i])));
		}
		if (cd->dtitle) g_free(cd->dtitle);
		cd->dtitle = g_strdup(gtk_entry_get_text(
						GTK_ENTRY(title_entry)));
		cddb_write_file(cd);
		TT_UNLOCK();
		playlist_dirty(cd->device);
		break;
	}
	if (!cd) {
		show_dialog("Could not write CD Database file:\n"
					"Disc Changed !");
	}
	CD_UNLOCK();

	gtk_widget_hide(info_win);
}

static void
cd_file_info_get_it_cb(GtkWidget *w, gpointer data)
{
	struct cd_struct *cd;
	CD_LOCK();
	cd = cd_list;
	while (cd) {
		if (info_discid != cd->id) {
			cd = cd->next;
			continue;
		}
		mkdir(cd_cfg.cddb_dir, 0755);
		cddb_server_get(cd, g_strdup_printf("%s/%08x",
				cd_cfg.cddb_dir, cd->id), TRUE);
		break;
	}
	CD_UNLOCK();
}

static void
cd_entry_focus(GtkWidget *w, gpointer data)
{
	GtkAdjustment *a = GTK_ADJUSTMENT(info_win_vadj);
	if ((a->value > w->allocation.y) || ((a->value + a->page_size) <
	     (w->allocation.y + w->allocation.height))) {
		float v = w->allocation.y - (a->page_size / 2);
		if (v < a->lower) v = a->lower;
		if (v > (a->upper - a->page_size)) v = a->upper - a->page_size;
		gtk_adjustment_set_value(a, v);
	}
}

void
cd_file_info(gchar *f)
{
	gint i;
	struct cd_struct *cd;
	gchar **tt;
	gint nt;

	CD_LOCK();
	cd = cd_list;
	while (cd) {
		if (!memcmp(cd->device, f, strlen(cd->device)))
			break;
		cd = cd->next;
	}
	if (!cd) {
		CD_UNLOCK();
		return;
	}
	TT_LOCK();
	info_discid = cd->id;
	if (!info_win) {
		GtkWidget *trks_frame, *vbox, *title_frame;
		GtkObject *hadj;
		GtkWidget *go_get_it;
		GtkWidget *bbox, *ok, *cancel;

		info_ntrk = 0;

		/*\ Otherwise it won't have resize bars. Shitty. \*/
		info_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_signal_connect(GTK_OBJECT(info_win), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &info_win);
		gtk_window_set_title(GTK_WINDOW(info_win), "CD DataBase");
		gtk_window_set_policy(GTK_WINDOW(info_win),
					FALSE, TRUE, TRUE);
		gtk_window_set_position(GTK_WINDOW(info_win),
					GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(info_win), 10);

		vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_add(GTK_CONTAINER(info_win), vbox);

		title_frame = gtk_frame_new("Title:");
		gtk_box_pack_start(GTK_BOX(vbox), title_frame,
						FALSE, FALSE, 0);

		title_entry = gtk_entry_new();
		gtk_container_add(GTK_CONTAINER(title_frame), title_entry);

		gtk_widget_show(title_entry);
		gtk_widget_show(title_frame);

		trks_frame = gtk_frame_new("Tracks:");
		gtk_box_pack_start(GTK_BOX(vbox), trks_frame,
						TRUE, TRUE, 0);

		hadj = gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.1);
		info_win_vadj = gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.1);
		scroll_win = gtk_scrolled_window_new(GTK_ADJUSTMENT(hadj),
					GTK_ADJUSTMENT(info_win_vadj));
		gtk_container_add(GTK_CONTAINER(trks_frame), scroll_win);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_win),
					GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		/*\ Numbers guessed offhand \*/
		gtk_widget_set_usize(scroll_win, 300, 250);

		info_table = gtk_table_new(0, 2, FALSE);
		gtk_container_set_border_width(GTK_CONTAINER(info_table), 5);
		gtk_scrolled_window_add_with_viewport(
				GTK_SCROLLED_WINDOW(scroll_win), info_table);

		gtk_widget_show(info_table);
		gtk_widget_show(scroll_win);
		gtk_widget_show(trks_frame);

		go_get_it = gtk_button_new_with_label("Get entry from server");
		gtk_signal_connect(GTK_OBJECT(go_get_it), "clicked",
				GTK_SIGNAL_FUNC(cd_file_info_get_it_cb), NULL);
		gtk_box_pack_start(GTK_BOX(vbox), go_get_it, FALSE, FALSE, 0);
		gtk_widget_show(go_get_it);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox),
						GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label("Save");
		gtk_signal_connect(GTK_OBJECT(ok), "clicked",
				GTK_SIGNAL_FUNC(cd_file_info_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);

		cancel = gtk_button_new_with_label("Cancel");
		gtk_signal_connect_object(GTK_OBJECT(cancel),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_hide),
				GTK_OBJECT(info_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);
		gtk_widget_grab_default(cancel);

		gtk_widget_show(bbox);
		gtk_widget_show(vbox);
	}
	nt = (cd->last_trk - cd->first_trk) + 1;
	if (nt > info_ntrk) {
		for (i = info_ntrk; i < nt; i++) {
			gchar buf[10];
			sprintf(buf, "%d", i + 1);
			info_trk_label[i] = gtk_label_new(buf);
			info_trk_entry[i] = gtk_entry_new();
			gtk_table_attach(GTK_TABLE(info_table),
					info_trk_label[i], 0, 1, i, i + 1,
					GTK_FILL, GTK_FILL, 5, 0);
			gtk_table_attach(GTK_TABLE(info_table),
					info_trk_entry[i], 1, 2, i, i + 1,
					GTK_EXPAND|GTK_FILL, GTK_FILL, 5, 0);
			gtk_signal_connect(GTK_OBJECT(info_trk_label[i]),
					"focus_in_event",
					GTK_SIGNAL_FUNC(cd_entry_focus), 0);
			gtk_signal_connect(GTK_OBJECT(info_trk_entry[i]),
					"focus_in_event",
					GTK_SIGNAL_FUNC(cd_entry_focus), 0);
			gtk_widget_show(info_trk_label[i]);
			gtk_widget_show(info_trk_entry[i]);
			gtk_misc_set_alignment(GTK_MISC(info_trk_label[i]),
						1.0, 0.5);
		}
	} else {
		for (i = nt; i < info_ntrk; i++) {
			gtk_widget_destroy(info_trk_label[i]);
			gtk_widget_destroy(info_trk_entry[i]);
		}
	}
	info_ntrk = nt;
	tt = cd->ttitle + cd->first_trk;
	for (i = 0; i < info_ntrk; i++)
		gtk_entry_set_text(GTK_ENTRY(info_trk_entry[i]),
					tt[i] ? tt[i] : "");
	gtk_entry_set_text(GTK_ENTRY(title_entry),
				cd->dtitle ? cd->dtitle : "");
	TT_UNLOCK();
	CD_UNLOCK();

	gtk_widget_show(info_win);
}

void
cddb_reread(void)
{
	struct cd_struct *cd;
	CD_LOCK();
	cd = cd_list;
	while (cd) {
		cd->id = 0xff; /*\ Force a reread \*/
		cd_read_cddb(cd, FALSE);
		playlist_dirty(cd->device);
		if ((info_discid == cd->id) &&
				(cd->dtitle) && (cd->dtitle[0])) {
			gint i;
			gchar **tt;

			TT_LOCK();
			tt = cd->ttitle + cd->first_trk;
			GDK_THREADS_ENTER();
			for (i = 0; i < info_ntrk; i++)
				gtk_entry_set_text(GTK_ENTRY(info_trk_entry[i]),
							tt[i] ? tt[i] : "");
			gtk_entry_set_text(GTK_ENTRY(title_entry),
				cd->dtitle ? cd->dtitle : "");
			GDK_THREADS_LEAVE();
			TT_UNLOCK();
		}
		cd = cd->next;
	}
	CD_UNLOCK();
	mainwin_set_info_text();
}
