;;;
;;; Copyright (c) 2003-2006 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

(define hangul2-rule
  '(
((("E" ))("ㄸ"))
((("E" "h" ))("또"))
((("E" "h" "d" ))("똥"))
((("E" "h" "f" ))("똘"))
((("E" "h" "k" ))("똬"))
((("E" "h" "k" "f" ))("똴"))
((("E" "h" "l" ))("뙤"))
((("E" "h" "l" "s" ))("뙨"))
((("E" "h" "o" ))("뙈"))
((("E" "h" "r" ))("똑"))
((("E" "h" "s" ))("똔"))
((("E" "j" ))("떠"))
((("E" "j" "T" ))("떴"))
((("E" "j" "a" ))("떰"))
((("E" "j" "d" ))("떵"))
((("E" "j" "f" ))("떨"))
((("E" "j" "f" "a" ))("떪"))
((("E" "j" "f" "q" ))("떫"))
((("E" "j" "g" ))("떻"))
((("E" "j" "q" ))("떱"))
((("E" "j" "r" ))("떡"))
((("E" "j" "s" ))("떤"))
((("E" "j" "t" ))("떳"))
((("E" "k" ))("따"))
((("E" "k" "T" ))("땄"))
((("E" "k" "a" ))("땀"))
((("E" "k" "d" ))("땅"))
((("E" "k" "f" ))("딸"))
((("E" "k" "g" ))("땋"))
((("E" "k" "q" ))("땁"))
((("E" "k" "r" ))("딱"))
((("E" "k" "s" ))("딴"))
((("E" "k" "t" ))("땃"))
((("E" "l" ))("띠"))
((("E" "l" "a" ))("띰"))
((("E" "l" "d" ))("띵"))
((("E" "l" "f" ))("띨"))
((("E" "l" "q" ))("띱"))
((("E" "l" "s" ))("띤"))
((("E" "l" "t" ))("띳"))
((("E" "m" ))("뜨"))
((("E" "m" "a" ))("뜸"))
((("E" "m" "e" ))("뜯"))
((("E" "m" "f" ))("뜰"))
((("E" "m" "l" ))("띄"))
((("E" "m" "l" "a" ))("띔"))
((("E" "m" "l" "f" ))("띌"))
((("E" "m" "l" "q" ))("띕"))
((("E" "m" "l" "s" ))("띈"))
((("E" "m" "q" ))("뜹"))
((("E" "m" "r" ))("뜩"))
((("E" "m" "s" ))("뜬"))
((("E" "m" "t" ))("뜻"))
((("E" "n" ))("뚜"))
((("E" "n" "a" ))("뚬"))
((("E" "n" "d" ))("뚱"))
((("E" "n" "f" ))("뚤"))
((("E" "n" "f" "g" ))("뚫"))
((("E" "n" "l" ))("뛰"))
((("E" "n" "l" "a" ))("뜀"))
((("E" "n" "l" "d" ))("뜅"))
((("E" "n" "l" "f" ))("뛸"))
((("E" "n" "l" "q" ))("뜁"))
((("E" "n" "l" "s" ))("뛴"))
((("E" "n" "p" ))("뛔"))
((("E" "n" "r" ))("뚝"))
((("E" "n" "s" ))("뚠"))
((("E" "o" ))("때"))
((("E" "o" "T" ))("땠"))
((("E" "o" "a" ))("땜"))
((("E" "o" "d" ))("땡"))
((("E" "o" "f" ))("땔"))
((("E" "o" "q" ))("땝"))
((("E" "o" "r" ))("땍"))
((("E" "o" "s" ))("땐"))
((("E" "o" "t" ))("땟"))
((("E" "p" ))("떼"))
((("E" "p" "T" ))("뗐"))
((("E" "p" "a" ))("뗌"))
((("E" "p" "d" ))("뗑"))
((("E" "p" "f" ))("뗄"))
((("E" "p" "q" ))("뗍"))
((("E" "p" "r" ))("떽"))
((("E" "p" "s" ))("뗀"))
((("E" "p" "t" ))("뗏"))
((("E" "u" ))("뗘"))
((("E" "u" "T" ))("뗬"))
((("H" "." ))("ㆍ"))
((("H" "." "l" ))("ㆎ"))
((("H" "D" ))("ㆀ"))
((("H" "G" ))("ㆅ"))
((("H" "Q" "d" ))("ㅹ"))
((("H" "S" ))("ㅥ"))
((("H" "T" ))("ㅿ"))
((("H" "a" "T" ))("ㅰ"))
((("H" "a" "d" ))("ㅱ"))
((("H" "a" "q" ))("ㅮ"))
((("H" "a" "t" ))("ㅯ"))
((("H" "b" "P" ))("ㆋ"))
((("H" "b" "l" ))("ㆌ"))
((("H" "b" "u" ))("ㆊ"))
((("H" "d" ))("ㆁ"))
((("H" "d" "T" ))("ㆃ"))
((("H" "d" "w" ))("ㆂ"))
((("H" "f" "G" ))("ㅭ"))
((("H" "f" "T" ))("ㅬ"))
((("H" "f" "e" ))("ㅪ"))
((("H" "f" "q" "t" ))("ㅫ"))
((("H" "f" "r" "t" ))("ㅩ"))
((("H" "g" ))("ㆆ"))
((("H" "q" "d" ))("ㅸ"))
((("H" "q" "e" ))("ㅳ"))
((("H" "q" "r" ))("ㅲ"))
((("H" "q" "t" "e" ))("ㅵ"))
((("H" "q" "t" "r" ))("ㅴ"))
((("H" "q" "w" ))("ㅶ"))
((("H" "q" "x" ))("ㅷ"))
((("H" "s" "T" ))("ㅨ"))
((("H" "s" "e" ))("ㅦ"))
((("H" "s" "t" ))("ㅧ"))
((("H" "t" "e" ))("ㅼ"))
((("H" "t" "q" ))("ㅽ"))
((("H" "t" "r" ))("ㅺ"))
((("H" "t" "s" ))("ㅻ"))
((("H" "t" "w" ))("ㅾ"))
((("H" "v" "d" ))("ㆄ"))
((("H" "y" "O" ))("ㆈ"))
((("H" "y" "i" ))("ㆇ"))
((("H" "y" "l" ))("ㆉ"))
((("O" ))("ㅒ"))
((("O" "T" ))("쟀"))
((("O" "a" ))("잼"))
((("O" "d" ))("쟁"))
((("O" "f" ))("잴"))
((("O" "q" ))("잽"))
((("O" "r" ))("잭"))
((("O" "s" ))("잰"))
((("O" "t" ))("잿"))
((("P" ))("ㅖ"))
((("Q" ))("ㅃ"))
((("Q" "b" ))("쀼"))
((("Q" "b" "d" ))("쁑"))
((("Q" "h" ))("뽀"))
((("Q" "h" "a" ))("뽐"))
((("Q" "h" "d" ))("뽕"))
((("Q" "h" "f" ))("뽈"))
((("Q" "h" "l" ))("뾔"))
((("Q" "h" "q" ))("뽑"))
((("Q" "h" "r" ))("뽁"))
((("Q" "h" "s" ))("뽄"))
((("Q" "i" ))("뺘"))
((("Q" "i" "a" ))("뺨"))
((("Q" "i" "r" ))("뺙"))
((("Q" "j" ))("뻐"))
((("Q" "j" "T" ))("뻤"))
((("Q" "j" "a" ))("뻠"))
((("Q" "j" "d" ))("뻥"))
((("Q" "j" "e" ))("뻗"))
((("Q" "j" "f" ))("뻘"))
((("Q" "j" "r" ))("뻑"))
((("Q" "j" "s" ))("뻔"))
((("Q" "j" "t" ))("뻣"))
((("Q" "k" ))("빠"))
((("Q" "k" "T" ))("빴"))
((("Q" "k" "a" ))("빰"))
((("Q" "k" "d" ))("빵"))
((("Q" "k" "f" ))("빨"))
((("Q" "k" "f" "a" ))("빪"))
((("Q" "k" "g" ))("빻"))
((("Q" "k" "q" ))("빱"))
((("Q" "k" "r" ))("빡"))
((("Q" "k" "s" ))("빤"))
((("Q" "k" "t" ))("빳"))
((("Q" "l" ))("삐"))
((("Q" "l" "a" ))("삠"))
((("Q" "l" "d" ))("삥"))
((("Q" "l" "f" ))("삘"))
((("Q" "l" "q" ))("삡"))
((("Q" "l" "r" ))("삑"))
((("Q" "l" "s" ))("삔"))
((("Q" "l" "t" ))("삣"))
((("Q" "m" ))("쁘"))
((("Q" "m" "a" ))("쁨"))
((("Q" "m" "f" ))("쁠"))
((("Q" "m" "q" ))("쁩"))
((("Q" "m" "s" ))("쁜"))
((("Q" "n" ))("뿌"))
((("Q" "n" "a" ))("뿜"))
((("Q" "n" "d" ))("뿡"))
((("Q" "n" "f" ))("뿔"))
((("Q" "n" "r" ))("뿍"))
((("Q" "n" "s" ))("뿐"))
((("Q" "n" "t" ))("뿟"))
((("Q" "o" ))("빼"))
((("Q" "o" "T" ))("뺐"))
((("Q" "o" "a" ))("뺌"))
((("Q" "o" "d" ))("뺑"))
((("Q" "o" "f" ))("뺄"))
((("Q" "o" "q" ))("뺍"))
((("Q" "o" "r" ))("빽"))
((("Q" "o" "s" ))("뺀"))
((("Q" "o" "t" ))("뺏"))
((("Q" "p" ))("뻬"))
((("Q" "p" "d" ))("뼁"))
((("Q" "u" ))("뼈"))
((("Q" "u" "T" ))("뼜"))
((("Q" "u" "a" ))("뼘"))
((("Q" "u" "d" ))("뼝"))
((("Q" "u" "q" ))("뼙"))
((("Q" "u" "r" ))("뼉"))
((("Q" "u" "t" ))("뼛"))
((("Q" "y" ))("뾰"))
((("Q" "y" "d" ))("뿅"))
((("R" ))("ㄲ"))
((("R" "P" ))("꼐"))
((("R" "b" ))("뀨"))
((("R" "h" ))("꼬"))
((("R" "h" "a" ))("꼼"))
((("R" "h" "c" ))("꽃"))
((("R" "h" "d" ))("꽁"))
((("R" "h" "f" ))("꼴"))
((("R" "h" "k" ))("꽈"))
((("R" "h" "k" "T" ))("꽜"))
((("R" "h" "k" "d" ))("꽝"))
((("R" "h" "k" "f" ))("꽐"))
((("R" "h" "k" "r" ))("꽉"))
((("R" "h" "l" ))("꾀"))
((("R" "h" "l" "a" ))("꾐"))
((("R" "h" "l" "d" ))("꾕"))
((("R" "h" "l" "f" ))("꾈"))
((("R" "h" "l" "q" ))("꾑"))
((("R" "h" "l" "s" ))("꾄"))
((("R" "h" "o" ))("꽤"))
((("R" "h" "o" "d" ))("꽹"))
((("R" "h" "o" "r" ))("꽥"))
((("R" "h" "q" ))("꼽"))
((("R" "h" "r" ))("꼭"))
((("R" "h" "s" ))("꼰"))
((("R" "h" "s" "g" ))("꼲"))
((("R" "h" "t" ))("꼿"))
((("R" "h" "w" ))("꽂"))
((("R" "i" ))("꺄"))
((("R" "i" "f" ))("꺌"))
((("R" "i" "r" ))("꺅"))
((("R" "j" ))("꺼"))
((("R" "j" "R" ))("꺾"))
((("R" "j" "T" ))("껐"))
((("R" "j" "a" ))("껌"))
((("R" "j" "d" ))("껑"))
((("R" "j" "f" ))("껄"))
((("R" "j" "q" ))("껍"))
((("R" "j" "r" ))("꺽"))
((("R" "j" "s" ))("껀"))
((("R" "j" "t" ))("껏"))
((("R" "k" ))("까"))
((("R" "k" "R" ))("깎"))
((("R" "k" "T" ))("깠"))
((("R" "k" "a" ))("깜"))
((("R" "k" "d" ))("깡"))
((("R" "k" "f" ))("깔"))
((("R" "k" "f" "a" ))("깖"))
((("R" "k" "q" ))("깝"))
((("R" "k" "r" ))("깍"))
((("R" "k" "s" ))("깐"))
((("R" "k" "t" ))("깟"))
((("R" "k" "x" ))("깥"))
((("R" "l" ))("끼"))
((("R" "l" "a" ))("낌"))
((("R" "l" "d" ))("낑"))
((("R" "l" "f" ))("낄"))
((("R" "l" "q" ))("낍"))
((("R" "l" "r" ))("끽"))
((("R" "l" "s" ))("낀"))
((("R" "l" "t" ))("낏"))
((("R" "m" ))("끄"))
((("R" "m" "a" ))("끔"))
((("R" "m" "d" ))("끙"))
((("R" "m" "f" ))("끌"))
((("R" "m" "f" "a" ))("끎"))
((("R" "m" "f" "g" ))("끓"))
((("R" "m" "q" ))("끕"))
((("R" "m" "r" ))("끅"))
((("R" "m" "s" ))("끈"))
((("R" "m" "s" "g" ))("끊"))
((("R" "m" "t" ))("끗"))
((("R" "m" "x" ))("끝"))
((("R" "n" ))("꾸"))
((("R" "n" "a" ))("꿈"))
((("R" "n" "d" ))("꿍"))
((("R" "n" "f" ))("꿀"))
((("R" "n" "f" "g" ))("꿇"))
((("R" "n" "j" ))("꿔"))
((("R" "n" "j" "T" ))("꿨"))
((("R" "n" "j" "d" ))("꿩"))
((("R" "n" "j" "f" ))("꿜"))
((("R" "n" "l" ))("뀌"))
((("R" "n" "l" "a" ))("뀜"))
((("R" "n" "l" "f" ))("뀔"))
((("R" "n" "l" "q" ))("뀝"))
((("R" "n" "l" "s" ))("뀐"))
((("R" "n" "p" ))("꿰"))
((("R" "n" "p" "T" ))("뀄"))
((("R" "n" "p" "a" ))("뀀"))
((("R" "n" "p" "f" ))("꿸"))
((("R" "n" "p" "q" ))("뀁"))
((("R" "n" "p" "r" ))("꿱"))
((("R" "n" "p" "s" ))("꿴"))
((("R" "n" "q" ))("꿉"))
((("R" "n" "r" ))("꾹"))
((("R" "n" "s" ))("꾼"))
((("R" "n" "t" ))("꿋"))
((("R" "n" "w" ))("꿎"))
((("R" "o" ))("깨"))
((("R" "o" "T" ))("깼"))
((("R" "o" "a" ))("깸"))
((("R" "o" "d" ))("깽"))
((("R" "o" "f" ))("깰"))
((("R" "o" "q" ))("깹"))
((("R" "o" "r" ))("깩"))
((("R" "o" "s" ))("깬"))
((("R" "o" "t" ))("깻"))
((("R" "p" ))("께"))
((("R" "p" "a" ))("껨"))
((("R" "p" "d" ))("껭"))
((("R" "p" "r" ))("껙"))
((("R" "p" "s" ))("껜"))
((("R" "p" "t" ))("껫"))
((("R" "u" ))("껴"))
((("R" "u" "T" ))("꼈"))
((("R" "u" "f" ))("껼"))
((("R" "u" "s" ))("껸"))
((("R" "u" "t" ))("꼇"))
((("R" "u" "x" ))("꼍"))
((("R" "y" ))("꾜"))
((("S" "%" ))("‰"))
((("S" "A" ))("Å"))
((("S" "C" ))("℃"))
((("S" "C" "/" ))("￠"))
((("S" "C" "o" ))("㏇"))
((("S" "F" ))("℉"))
((("S" "N" "o" ))("№"))
((("S" "P" ))("￡"))
((("S" "T" "M" ))("™"))
((("S" "T" "e" "l" ))("℡"))
((("S" "W" ))("￦"))
((("S" "Y" ))("￥"))
((("S" "a" "m" ))("㏂"))
((("S" "k" "s" ))("㉿"))
((("S" "p" "m" ))("㏘"))
((("S" "w" "n" ))("㈜"))
((("T" ))("ㅆ"))
((("T" "P" "s" ))("쏀"))
((("T" "b" "d" ))("쓩"))
((("T" "h" ))("쏘"))
((("T" "h" "a" ))("쏨"))
((("T" "h" "d" ))("쏭"))
((("T" "h" "e" ))("쏟"))
((("T" "h" "f" ))("쏠"))
((("T" "h" "f" "a" ))("쏢"))
((("T" "h" "k" ))("쏴"))
((("T" "h" "k" "T" ))("쐈"))
((("T" "h" "k" "r" ))("쏵"))
((("T" "h" "k" "s" ))("쏸"))
((("T" "h" "l" ))("쐬"))
((("T" "h" "l" "a" ))("쐼"))
((("T" "h" "l" "f" ))("쐴"))
((("T" "h" "l" "q" ))("쐽"))
((("T" "h" "l" "s" ))("쐰"))
((("T" "h" "o" ))("쐐"))
((("T" "h" "o" "T" ))("쐤"))
((("T" "h" "q" ))("쏩"))
((("T" "h" "r" ))("쏙"))
((("T" "h" "s" ))("쏜"))
((("T" "i" "d" ))("썅"))
((("T" "j" ))("써"))
((("T" "j" "T" ))("썼"))
((("T" "j" "a" ))("썸"))
((("T" "j" "d" ))("썽"))
((("T" "j" "f" ))("썰"))
((("T" "j" "f" "a" ))("썲"))
((("T" "j" "q" ))("썹"))
((("T" "j" "r" ))("썩"))
((("T" "j" "s" ))("썬"))
((("T" "k" ))("싸"))
((("T" "k" "T" ))("쌌"))
((("T" "k" "a" ))("쌈"))
((("T" "k" "d" ))("쌍"))
((("T" "k" "f" ))("쌀"))
((("T" "k" "g" ))("쌓"))
((("T" "k" "q" ))("쌉"))
((("T" "k" "r" ))("싹"))
((("T" "k" "r" "t" ))("싻"))
((("T" "k" "s" ))("싼"))
((("T" "l" ))("씨"))
((("T" "l" "a" ))("씸"))
((("T" "l" "d" ))("씽"))
((("T" "l" "f" ))("씰"))
((("T" "l" "q" ))("씹"))
((("T" "l" "r" ))("씩"))
((("T" "l" "s" ))("씬"))
((("T" "l" "t" ))("씻"))
((("T" "m" ))("쓰"))
((("T" "m" "a" ))("씀"))
((("T" "m" "f" ))("쓸"))
((("T" "m" "f" "a" ))("쓺"))
((("T" "m" "f" "g" ))("쓿"))
((("T" "m" "l" ))("씌"))
((("T" "m" "l" "a" ))("씜"))
((("T" "m" "l" "f" ))("씔"))
((("T" "m" "l" "s" ))("씐"))
((("T" "m" "q" ))("씁"))
((("T" "m" "r" ))("쓱"))
((("T" "m" "s" ))("쓴"))
((("T" "n" ))("쑤"))
((("T" "n" "a" ))("쑴"))
((("T" "n" "d" ))("쑹"))
((("T" "n" "f" ))("쑬"))
((("T" "n" "j" ))("쒀"))
((("T" "n" "j" "T" ))("쒔"))
((("T" "n" "l" ))("쒸"))
((("T" "n" "l" "s" ))("쒼"))
((("T" "n" "p" ))("쒜"))
((("T" "n" "q" ))("쑵"))
((("T" "n" "r" ))("쑥"))
((("T" "n" "s" ))("쑨"))
((("T" "o" ))("쌔"))
((("T" "o" "T" ))("쌨"))
((("T" "o" "a" ))("쌤"))
((("T" "o" "d" ))("쌩"))
((("T" "o" "f" ))("쌜"))
((("T" "o" "q" ))("쌥"))
((("T" "o" "r" ))("쌕"))
((("T" "o" "s" ))("쌘"))
((("T" "p" ))("쎄"))
((("T" "p" "f" ))("쎌"))
((("T" "p" "s" ))("쎈"))
((("T" "y" ))("쑈"))
((("W" ))("ㅉ"))
((("W" "b" ))("쮸"))
((("W" "h" ))("쪼"))
((("W" "h" "a" ))("쫌"))
((("W" "h" "c" ))("쫓"))
((("W" "h" "d" ))("쫑"))
((("W" "h" "f" ))("쫄"))
((("W" "h" "k" ))("쫘"))
((("W" "h" "k" "T" ))("쫬"))
((("W" "h" "k" "f" ))("쫠"))
((("W" "h" "k" "r" ))("쫙"))
((("W" "h" "l" ))("쬐"))
((("W" "h" "l" "a" ))("쬠"))
((("W" "h" "l" "f" ))("쬘"))
((("W" "h" "l" "q" ))("쬡"))
((("W" "h" "l" "s" ))("쬔"))
((("W" "h" "o" ))("쫴"))
((("W" "h" "o" "T" ))("쬈"))
((("W" "h" "q" ))("쫍"))
((("W" "h" "r" ))("쪽"))
((("W" "h" "s" ))("쫀"))
((("W" "h" "t" ))("쫏"))
((("W" "i" ))("쨔"))
((("W" "i" "d" ))("쨩"))
((("W" "i" "s" ))("쨘"))
((("W" "j" ))("쩌"))
((("W" "j" "T" ))("쩠"))
((("W" "j" "a" ))("쩜"))
((("W" "j" "d" ))("쩡"))
((("W" "j" "f" ))("쩔"))
((("W" "j" "q" ))("쩝"))
((("W" "j" "r" ))("쩍"))
((("W" "j" "s" ))("쩐"))
((("W" "j" "t" ))("쩟"))
((("W" "k" ))("짜"))
((("W" "k" "T" ))("짰"))
((("W" "k" "a" ))("짬"))
((("W" "k" "d" ))("짱"))
((("W" "k" "f" ))("짤"))
((("W" "k" "f" "q" ))("짧"))
((("W" "k" "q" ))("짭"))
((("W" "k" "r" ))("짝"))
((("W" "k" "s" ))("짠"))
((("W" "k" "s" "g" ))("짢"))
((("W" "k" "t" ))("짯"))
((("W" "l" ))("찌"))
((("W" "l" "a" ))("찜"))
((("W" "l" "d" ))("찡"))
((("W" "l" "f" ))("찔"))
((("W" "l" "g" ))("찧"))
((("W" "l" "q" ))("찝"))
((("W" "l" "r" ))("찍"))
((("W" "l" "s" ))("찐"))
((("W" "l" "w" ))("찢"))
((("W" "m" ))("쯔"))
((("W" "m" "a" ))("쯤"))
((("W" "m" "d" ))("쯩"))
((("W" "m" "t" ))("쯧"))
((("W" "n" ))("쭈"))
((("W" "n" "a" ))("쭘"))
((("W" "n" "d" ))("쭝"))
((("W" "n" "f" ))("쭐"))
((("W" "n" "j" ))("쭤"))
((("W" "n" "j" "T" ))("쭸"))
((("W" "n" "j" "d" ))("쭹"))
((("W" "n" "l" ))("쮜"))
((("W" "n" "q" ))("쭙"))
((("W" "n" "r" ))("쭉"))
((("W" "n" "s" ))("쭌"))
((("W" "o" ))("째"))
((("W" "o" "T" ))("쨌"))
((("W" "o" "a" ))("쨈"))
((("W" "o" "d" ))("쨍"))
((("W" "o" "f" ))("쨀"))
((("W" "o" "q" ))("쨉"))
((("W" "o" "r" ))("짹"))
((("W" "o" "s" ))("짼"))
((("W" "o" "t" ))("쨋"))
((("W" "p" ))("쩨"))
((("W" "p" "d" ))("쩽"))
((("W" "u" ))("쪄"))
((("W" "u" "T" ))("쪘"))
((("W" "y" "d" ))("쭁"))
((("Z" ))("）"))
((("Z" "!" ))("！"))
((("Z" "#" ))("＃"))
((("Z" "$" ))("＄"))
((("Z" "%" ))("％"))
((("Z" "&" ))("＆"))
((("Z" "'" ))("＇"))
((("Z" "(" ))("（"))
((("Z" "*" ))("＊"))
((("Z" "+" ))("＋"))
((("Z" "," ))("，"))
((("Z" "-" ))("－"))
((("Z" "." ))("．"))
((("Z" "/" ))("／"))
((("Z" "0" ))("０"))
((("Z" "1" ))("１"))
((("Z" "2" ))("２"))
((("Z" "3" ))("３"))
((("Z" "4" ))("４"))
((("Z" "5" ))("５"))
((("Z" "6" ))("６"))
((("Z" "7" ))("７"))
((("Z" "8" ))("８"))
((("Z" "9" ))("９"))
((("Z" ":" ))("："))
((("Z" ";" ))("；"))
((("Z" "<" ))("＜"))
((("Z" "=" ))("＝"))
((("Z" ">" ))("＞"))
((("Z" "?" ))("？"))
((("Z" "@" ))("＠"))
((("Z" "A" ))("Ａ"))
((("Z" "B" ))("Ｂ"))
((("Z" "C" ))("Ｃ"))
((("Z" "D" ))("Ｄ"))
((("Z" "E" ))("Ｅ"))
((("Z" "F" ))("Ｆ"))
((("Z" "G" ))("Ｇ"))
((("Z" "H" ))("Ｈ"))
((("Z" "I" ))("Ｉ"))
((("Z" "J" ))("Ｊ"))
((("Z" "K" ))("Ｋ"))
((("Z" "L" ))("Ｌ"))
((("Z" "M" ))("Ｍ"))
((("Z" "N" ))("Ｎ"))
((("Z" "O" ))("Ｏ"))
((("Z" "P" ))("Ｐ"))
((("Z" "Q" ))("Ｑ"))
((("Z" "R" ))("Ｒ"))
((("Z" "S" ))("Ｓ"))
((("Z" "T" ))("Ｔ"))
((("Z" "U" ))("Ｕ"))
((("Z" "V" ))("Ｖ"))
((("Z" "W" ))("Ｗ"))
((("Z" "X" ))("Ｘ"))
((("Z" "Y" ))("Ｙ"))
((("Z" "Z" ))("Ｚ"))
((("Z" "[" ))("［"))
((("Z" "\\" ))("?"))
((("Z" "]" ))("］"))
((("Z" "^" ))("＾"))
((("Z" "^" "-" ))("￣"))
((("Z" "_" ))("＿"))
((("Z" "`" ))("｀"))
((("Z" "a" ))("ａ"))
((("Z" "b" ))("ｂ"))
((("Z" "c" ))("ｃ"))
((("Z" "d" ))("ｄ"))
((("Z" "e" ))("ｅ"))
((("Z" "f" ))("ｆ"))
((("Z" "g" ))("ｇ"))
((("Z" "h" ))("ｈ"))
((("Z" "i" ))("ｉ"))
((("Z" "j" ))("ｊ"))
((("Z" "k" ))("ｋ"))
((("Z" "l" ))("ｌ"))
((("Z" "m" ))("ｍ"))
((("Z" "n" ))("ｎ"))
((("Z" "o" ))("ｏ"))
((("Z" "p" ))("ｐ"))
((("Z" "q" ))("ｑ"))
((("Z" "r" ))("ｒ"))
((("Z" "s" ))("ｓ"))
((("Z" "t" ))("ｔ"))
((("Z" "u" ))("ｕ"))
((("Z" "v" ))("ｖ"))
((("Z" "w" ))("ｗ"))
((("Z" "x" ))("ｘ"))
((("Z" "y" ))("ｙ"))
((("Z" "z" ))("ｚ"))
((("Z" "{" ))("｛"))
((("Z" "|" ))("｜"))
((("Z" "}" ))("｝"))
((("a" ))("ㅁ"))
((("a" "P" ))("몌"))
((("a" "b" ))("뮤"))
((("a" "b" "a" ))("뮴"))
((("a" "b" "f" ))("뮬"))
((("a" "b" "s" ))("뮨"))
((("a" "b" "t" ))("뮷"))
((("a" "h" ))("모"))
((("a" "h" "a" ))("몸"))
((("a" "h" "d" ))("몽"))
((("a" "h" "f" ))("몰"))
((("a" "h" "f" "a" ))("몲"))
((("a" "h" "k" ))("뫄"))
((("a" "h" "k" "T" ))("뫘"))
((("a" "h" "k" "d" ))("뫙"))
((("a" "h" "k" "s" ))("뫈"))
((("a" "h" "l" ))("뫼"))
((("a" "h" "l" "d" ))("묑"))
((("a" "h" "l" "f" ))("묄"))
((("a" "h" "l" "q" ))("묍"))
((("a" "h" "l" "s" ))("묀"))
((("a" "h" "l" "t" ))("묏"))
((("a" "h" "q" ))("몹"))
((("a" "h" "r" ))("목"))
((("a" "h" "r" "t" ))("몫"))
((("a" "h" "s" ))("몬"))
((("a" "h" "t" ))("못"))
((("a" "i" ))("먀"))
((("a" "i" "d" ))("먕"))
((("a" "i" "f" ))("먈"))
((("a" "i" "r" ))("먁"))
((("a" "j" ))("머"))
((("a" "j" "a" ))("멈"))
((("a" "j" "d" ))("멍"))
((("a" "j" "f" ))("멀"))
((("a" "j" "f" "a" ))("멂"))
((("a" "j" "g" ))("멓"))
((("a" "j" "q" ))("멉"))
((("a" "j" "r" ))("먹"))
((("a" "j" "s" ))("먼"))
((("a" "j" "t" ))("멋"))
((("a" "j" "w" ))("멎"))
((("a" "k" ))("마"))
((("a" "k" "a" ))("맘"))
((("a" "k" "d" ))("망"))
((("a" "k" "e" ))("맏"))
((("a" "k" "f" ))("말"))
((("a" "k" "f" "a" ))("맒"))
((("a" "k" "f" "r" ))("맑"))
((("a" "k" "g" ))("맣"))
((("a" "k" "q" ))("맙"))
((("a" "k" "r" ))("막"))
((("a" "k" "s" ))("만"))
((("a" "k" "s" "g" ))("많"))
((("a" "k" "t" ))("맛"))
((("a" "k" "w" ))("맞"))
((("a" "k" "x" ))("맡"))
((("a" "l" ))("미"))
((("a" "l" "T" ))("밌"))
((("a" "l" "a" ))("밈"))
((("a" "l" "c" ))("및"))
((("a" "l" "d" ))("밍"))
((("a" "l" "e" ))("믿"))
((("a" "l" "f" ))("밀"))
((("a" "l" "f" "a" ))("밂"))
((("a" "l" "q" ))("밉"))
((("a" "l" "r" ))("믹"))
((("a" "l" "s" ))("민"))
((("a" "l" "t" ))("밋"))
((("a" "l" "x" ))("밑"))
((("a" "m" ))("므"))
((("a" "m" "a" ))("믐"))
((("a" "m" "f" ))("믈"))
((("a" "m" "s" ))("믄"))
((("a" "m" "t" ))("믓"))
((("a" "n" ))("무"))
((("a" "n" "R" ))("묶"))
((("a" "n" "a" ))("뭄"))
((("a" "n" "d" ))("뭉"))
((("a" "n" "e" ))("묻"))
((("a" "n" "f" ))("물"))
((("a" "n" "f" "a" ))("묾"))
((("a" "n" "f" "r" ))("묽"))
((("a" "n" "g" ))("뭏"))
((("a" "n" "j" ))("뭐"))
((("a" "n" "j" "f" ))("뭘"))
((("a" "n" "j" "q" ))("뭡"))
((("a" "n" "j" "s" ))("뭔"))
((("a" "n" "j" "t" ))("뭣"))
((("a" "n" "l" ))("뮈"))
((("a" "n" "l" "f" ))("뮐"))
((("a" "n" "l" "s" ))("뮌"))
((("a" "n" "p" ))("뭬"))
((("a" "n" "q" ))("뭅"))
((("a" "n" "r" ))("묵"))
((("a" "n" "s" ))("문"))
((("a" "n" "t" ))("뭇"))
((("a" "n" "x" ))("뭍"))
((("a" "o" ))("매"))
((("a" "o" "T" ))("맸"))
((("a" "o" "a" ))("맴"))
((("a" "o" "d" ))("맹"))
((("a" "o" "f" ))("맬"))
((("a" "o" "q" ))("맵"))
((("a" "o" "r" ))("맥"))
((("a" "o" "s" ))("맨"))
((("a" "o" "t" ))("맷"))
((("a" "o" "w" ))("맺"))
((("a" "p" ))("메"))
((("a" "p" "T" ))("멨"))
((("a" "p" "a" ))("멤"))
((("a" "p" "d" ))("멩"))
((("a" "p" "f" ))("멜"))
((("a" "p" "q" ))("멥"))
((("a" "p" "r" ))("멕"))
((("a" "p" "s" ))("멘"))
((("a" "p" "t" ))("멧"))
((("a" "u" ))("며"))
((("a" "u" "T" ))("몄"))
((("a" "u" "c" ))("몇"))
((("a" "u" "d" ))("명"))
((("a" "u" "f" ))("멸"))
((("a" "u" "r" ))("멱"))
((("a" "u" "s" ))("면"))
((("a" "u" "t" ))("몃"))
((("a" "y" ))("묘"))
((("a" "y" "f" ))("묠"))
((("a" "y" "q" ))("묩"))
((("a" "y" "s" ))("묜"))
((("a" "y" "t" ))("묫"))
((("b" ))("ㅠ"))
((("c" ))("ㅊ"))
((("c" "P" ))("쳬"))
((("c" "P" "d" ))("촁"))
((("c" "P" "s" ))("쳰"))
((("c" "b" ))("츄"))
((("c" "b" "a" ))("츔"))
((("c" "b" "d" ))("츙"))
((("c" "b" "f" ))("츌"))
((("c" "b" "s" ))("츈"))
((("c" "h" ))("초"))
((("c" "h" "a" ))("촘"))
((("c" "h" "d" ))("총"))
((("c" "h" "f" ))("촐"))
((("c" "h" "k" ))("촤"))
((("c" "h" "k" "d" ))("촹"))
((("c" "h" "k" "f" ))("촬"))
((("c" "h" "k" "s" ))("촨"))
((("c" "h" "l" ))("최"))
((("c" "h" "l" "a" ))("쵬"))
((("c" "h" "l" "d" ))("쵱"))
((("c" "h" "l" "f" ))("쵤"))
((("c" "h" "l" "q" ))("쵭"))
((("c" "h" "l" "s" ))("쵠"))
((("c" "h" "l" "t" ))("쵯"))
((("c" "h" "q" ))("촙"))
((("c" "h" "r" ))("촉"))
((("c" "h" "s" ))("촌"))
((("c" "h" "t" ))("촛"))
((("c" "i" ))("챠"))
((("c" "i" "a" ))("챰"))
((("c" "i" "d" ))("챵"))
((("c" "i" "f" ))("챨"))
((("c" "i" "s" ))("챤"))
((("c" "i" "s" "g" ))("챦"))
((("c" "j" ))("처"))
((("c" "j" "T" ))("첬"))
((("c" "j" "a" ))("첨"))
((("c" "j" "d" ))("청"))
((("c" "j" "f" ))("철"))
((("c" "j" "q" ))("첩"))
((("c" "j" "r" ))("척"))
((("c" "j" "s" ))("천"))
((("c" "j" "t" ))("첫"))
((("c" "k" ))("차"))
((("c" "k" "T" ))("찼"))
((("c" "k" "a" ))("참"))
((("c" "k" "d" ))("창"))
((("c" "k" "f" ))("찰"))
((("c" "k" "q" ))("찹"))
((("c" "k" "r" ))("착"))
((("c" "k" "s" ))("찬"))
((("c" "k" "s" "g" ))("찮"))
((("c" "k" "t" ))("찻"))
((("c" "k" "w" ))("찾"))
((("c" "l" ))("치"))
((("c" "l" "a" ))("침"))
((("c" "l" "d" ))("칭"))
((("c" "l" "e" ))("칟"))
((("c" "l" "f" ))("칠"))
((("c" "l" "f" "r" ))("칡"))
((("c" "l" "q" ))("칩"))
((("c" "l" "r" ))("칙"))
((("c" "l" "s" ))("친"))
((("c" "l" "t" ))("칫"))
((("c" "m" ))("츠"))
((("c" "m" "a" ))("츰"))
((("c" "m" "d" ))("층"))
((("c" "m" "f" ))("츨"))
((("c" "m" "q" ))("츱"))
((("c" "m" "r" ))("측"))
((("c" "m" "s" ))("츤"))
((("c" "m" "t" ))("츳"))
((("c" "n" ))("추"))
((("c" "n" "a" ))("춤"))
((("c" "n" "d" ))("충"))
((("c" "n" "f" ))("출"))
((("c" "n" "j" ))("춰"))
((("c" "n" "j" "T" ))("췄"))
((("c" "n" "l" ))("취"))
((("c" "n" "l" "a" ))("췸"))
((("c" "n" "l" "d" ))("췽"))
((("c" "n" "l" "f" ))("췰"))
((("c" "n" "l" "q" ))("췹"))
((("c" "n" "l" "s" ))("췬"))
((("c" "n" "l" "t" ))("췻"))
((("c" "n" "p" ))("췌"))
((("c" "n" "p" "s" ))("췐"))
((("c" "n" "q" ))("춥"))
((("c" "n" "r" ))("축"))
((("c" "n" "s" ))("춘"))
((("c" "n" "t" ))("춧"))
((("c" "o" ))("채"))
((("c" "o" "T" ))("챘"))
((("c" "o" "a" ))("챔"))
((("c" "o" "d" ))("챙"))
((("c" "o" "f" ))("챌"))
((("c" "o" "q" ))("챕"))
((("c" "o" "r" ))("책"))
((("c" "o" "s" ))("챈"))
((("c" "o" "t" ))("챗"))
((("c" "p" ))("체"))
((("c" "p" "a" ))("쳄"))
((("c" "p" "d" ))("쳉"))
((("c" "p" "f" ))("첼"))
((("c" "p" "q" ))("쳅"))
((("c" "p" "r" ))("첵"))
((("c" "p" "s" ))("첸"))
((("c" "p" "t" ))("쳇"))
((("c" "u" ))("쳐"))
((("c" "u" "T" ))("쳤"))
((("c" "u" "s" ))("쳔"))
((("c" "y" ))("쵸"))
((("c" "y" "a" ))("춈"))
((("d" ))("ㅇ"))
((("d" "O" ))("얘"))
((("d" "O" "f" ))("얠"))
((("d" "O" "q" ))("얩"))
((("d" "O" "s" ))("얜"))
((("d" "P" ))("예"))
((("d" "P" "T" ))("옜"))
((("d" "P" "a" ))("옘"))
((("d" "P" "f" ))("옐"))
((("d" "P" "q" ))("옙"))
((("d" "P" "s" ))("옌"))
((("d" "P" "t" ))("옛"))
((("d" "b" ))("유"))
((("d" "b" "a" ))("윰"))
((("d" "b" "c" ))("윷"))
((("d" "b" "d" ))("융"))
((("d" "b" "f" ))("율"))
((("d" "b" "q" ))("윱"))
((("d" "b" "r" ))("육"))
((("d" "b" "s" ))("윤"))
((("d" "b" "t" ))("윳"))
((("d" "h" ))("오"))
((("d" "h" "a" ))("옴"))
((("d" "h" "c" ))("옻"))
((("d" "h" "d" ))("옹"))
((("d" "h" "f" ))("올"))
((("d" "h" "f" "a" ))("옮"))
((("d" "h" "f" "g" ))("옳"))
((("d" "h" "f" "r" ))("옭"))
((("d" "h" "f" "t" ))("옰"))
((("d" "h" "k" ))("와"))
((("d" "h" "k" "T" ))("왔"))
((("d" "h" "k" "a" ))("왐"))
((("d" "h" "k" "d" ))("왕"))
((("d" "h" "k" "f" ))("왈"))
((("d" "h" "k" "q" ))("왑"))
((("d" "h" "k" "r" ))("왁"))
((("d" "h" "k" "s" ))("완"))
((("d" "h" "k" "t" ))("왓"))
((("d" "h" "l" ))("외"))
((("d" "h" "l" "a" ))("욈"))
((("d" "h" "l" "d" ))("욍"))
((("d" "h" "l" "f" ))("욀"))
((("d" "h" "l" "q" ))("욉"))
((("d" "h" "l" "r" ))("왹"))
((("d" "h" "l" "s" ))("왼"))
((("d" "h" "l" "t" ))("욋"))
((("d" "h" "o" ))("왜"))
((("d" "h" "o" "a" ))("왬"))
((("d" "h" "o" "d" ))("왱"))
((("d" "h" "o" "r" ))("왝"))
((("d" "h" "o" "s" ))("왠"))
((("d" "h" "o" "t" ))("왯"))
((("d" "h" "q" ))("옵"))
((("d" "h" "r" ))("옥"))
((("d" "h" "s" ))("온"))
((("d" "h" "t" ))("옷"))
((("d" "i" ))("야"))
((("d" "i" "a" ))("얌"))
((("d" "i" "d" ))("양"))
((("d" "i" "f" ))("얄"))
((("d" "i" "f" "q" ))("얇"))
((("d" "i" "g" ))("얗"))
((("d" "i" "q" ))("얍"))
((("d" "i" "r" ))("약"))
((("d" "i" "s" ))("얀"))
((("d" "i" "t" ))("얏"))
((("d" "i" "x" ))("얕"))
((("d" "j" ))("어"))
((("d" "j" "T" ))("었"))
((("d" "j" "a" ))("엄"))
((("d" "j" "d" ))("엉"))
((("d" "j" "e" ))("얻"))
((("d" "j" "f" ))("얼"))
((("d" "j" "f" "a" ))("얾"))
((("d" "j" "f" "r" ))("얽"))
((("d" "j" "q" ))("업"))
((("d" "j" "q" "t" ))("없"))
((("d" "j" "r" ))("억"))
((("d" "j" "s" ))("언"))
((("d" "j" "s" "w" ))("얹"))
((("d" "j" "t" ))("엇"))
((("d" "j" "v" ))("엎"))
((("d" "j" "w" ))("엊"))
((("d" "j" "z" ))("엌"))
((("d" "k" ))("아"))
((("d" "k" "T" ))("았"))
((("d" "k" "a" ))("암"))
((("d" "k" "d" ))("앙"))
((("d" "k" "f" ))("알"))
((("d" "k" "f" "a" ))("앎"))
((("d" "k" "f" "g" ))("앓"))
((("d" "k" "f" "r" ))("앍"))
((("d" "k" "q" ))("압"))
((("d" "k" "r" ))("악"))
((("d" "k" "s" ))("안"))
((("d" "k" "s" "g" ))("않"))
((("d" "k" "s" "w" ))("앉"))
((("d" "k" "t" ))("앗"))
((("d" "k" "v" ))("앞"))
((("d" "k" "x" ))("앝"))
((("d" "l" ))("이"))
((("d" "l" "T" ))("있"))
((("d" "l" "a" ))("임"))
((("d" "l" "d" ))("잉"))
((("d" "l" "f" ))("일"))
((("d" "l" "f" "a" ))("읾"))
((("d" "l" "f" "g" ))("잃"))
((("d" "l" "f" "r" ))("읽"))
((("d" "l" "q" ))("입"))
((("d" "l" "r" ))("익"))
((("d" "l" "s" ))("인"))
((("d" "l" "t" ))("잇"))
((("d" "l" "v" ))("잎"))
((("d" "l" "w" ))("잊"))
((("d" "m" ))("으"))
((("d" "m" "a" ))("음"))
((("d" "m" "c" ))("읓"))
((("d" "m" "d" ))("응"))
((("d" "m" "f" ))("을"))
((("d" "m" "f" "v" ))("읊"))
((("d" "m" "g" ))("읗"))
((("d" "m" "l" ))("의"))
((("d" "m" "l" "a" ))("읨"))
((("d" "m" "l" "f" ))("읠"))
((("d" "m" "l" "s" ))("읜"))
((("d" "m" "l" "t" ))("읫"))
((("d" "m" "q" ))("읍"))
((("d" "m" "r" ))("윽"))
((("d" "m" "s" ))("은"))
((("d" "m" "t" ))("읏"))
((("d" "m" "v" ))("읖"))
((("d" "m" "w" ))("읒"))
((("d" "m" "x" ))("읕"))
((("d" "m" "z" ))("읔"))
((("d" "n" ))("우"))
((("d" "n" "a" ))("움"))
((("d" "n" "d" ))("웅"))
((("d" "n" "f" ))("울"))
((("d" "n" "f" "a" ))("욺"))
((("d" "n" "f" "r" ))("욹"))
((("d" "n" "j" ))("워"))
((("d" "n" "j" "T" ))("웠"))
((("d" "n" "j" "a" ))("웜"))
((("d" "n" "j" "d" ))("웡"))
((("d" "n" "j" "f" ))("월"))
((("d" "n" "j" "q" ))("웝"))
((("d" "n" "j" "r" ))("웍"))
((("d" "n" "j" "s" ))("원"))
((("d" "n" "l" ))("위"))
((("d" "n" "l" "a" ))("윔"))
((("d" "n" "l" "d" ))("윙"))
((("d" "n" "l" "f" ))("윌"))
((("d" "n" "l" "q" ))("윕"))
((("d" "n" "l" "r" ))("윅"))
((("d" "n" "l" "s" ))("윈"))
((("d" "n" "l" "t" ))("윗"))
((("d" "n" "p" ))("웨"))
((("d" "n" "p" "a" ))("웸"))
((("d" "n" "p" "d" ))("웽"))
((("d" "n" "p" "f" ))("웰"))
((("d" "n" "p" "q" ))("웹"))
((("d" "n" "p" "r" ))("웩"))
((("d" "n" "p" "s" ))("웬"))
((("d" "n" "q" ))("웁"))
((("d" "n" "r" ))("욱"))
((("d" "n" "s" ))("운"))
((("d" "n" "t" ))("웃"))
((("d" "o" ))("애"))
((("d" "o" "T" ))("앴"))
((("d" "o" "a" ))("앰"))
((("d" "o" "d" ))("앵"))
((("d" "o" "f" ))("앨"))
((("d" "o" "q" ))("앱"))
((("d" "o" "r" ))("액"))
((("d" "o" "s" ))("앤"))
((("d" "o" "t" ))("앳"))
((("d" "p" ))("에"))
((("d" "p" "a" ))("엠"))
((("d" "p" "d" ))("엥"))
((("d" "p" "f" ))("엘"))
((("d" "p" "q" ))("엡"))
((("d" "p" "r" ))("엑"))
((("d" "p" "s" ))("엔"))
((("d" "p" "t" ))("엣"))
((("d" "u" ))("여"))
((("d" "u" "R" ))("엮"))
((("d" "u" "T" ))("였"))
((("d" "u" "a" ))("염"))
((("d" "u" "d" ))("영"))
((("d" "u" "f" ))("열"))
((("d" "u" "f" "a" ))("엶"))
((("d" "u" "f" "q" ))("엷"))
((("d" "u" "g" ))("옇"))
((("d" "u" "q" ))("엽"))
((("d" "u" "q" "t" ))("엾"))
((("d" "u" "r" ))("역"))
((("d" "u" "s" ))("연"))
((("d" "u" "t" ))("엿"))
((("d" "u" "v" ))("옆"))
((("d" "u" "x" ))("옅"))
((("d" "y" ))("요"))
((("d" "y" "a" ))("욤"))
((("d" "y" "d" ))("용"))
((("d" "y" "f" ))("욜"))
((("d" "y" "q" ))("욥"))
((("d" "y" "r" ))("욕"))
((("d" "y" "s" ))("욘"))
((("d" "y" "t" ))("욧"))
((("e" ))("ㄷ"))
((("e" "P" ))("뎨"))
((("e" "P" "s" ))("뎬"))
((("e" "b" ))("듀"))
((("e" "b" "a" ))("듐"))
((("e" "b" "d" ))("듕"))
((("e" "b" "f" ))("듈"))
((("e" "b" "s" ))("듄"))
((("e" "h" ))("도"))
((("e" "h" "a" ))("돔"))
((("e" "h" "c" ))("돛"))
((("e" "h" "d" ))("동"))
((("e" "h" "e" ))("돋"))
((("e" "h" "f" ))("돌"))
((("e" "h" "f" "a" ))("돎"))
((("e" "h" "f" "t" ))("돐"))
((("e" "h" "k" ))("돠"))
((("e" "h" "k" "f" ))("돨"))
((("e" "h" "k" "s" ))("돤"))
((("e" "h" "l" ))("되"))
((("e" "h" "l" "a" ))("됨"))
((("e" "h" "l" "f" ))("될"))
((("e" "h" "l" "q" ))("됩"))
((("e" "h" "l" "s" ))("된"))
((("e" "h" "l" "t" ))("됫"))
((("e" "h" "o" ))("돼"))
((("e" "h" "o" "T" ))("됐"))
((("e" "h" "q" ))("돕"))
((("e" "h" "r" ))("독"))
((("e" "h" "s" ))("돈"))
((("e" "h" "t" ))("돗"))
((("e" "h" "x" ))("돝"))
((("e" "i" ))("댜"))
((("e" "j" ))("더"))
((("e" "j" "R" ))("덖"))
((("e" "j" "a" ))("덤"))
((("e" "j" "c" ))("덫"))
((("e" "j" "d" ))("덩"))
((("e" "j" "e" ))("덛"))
((("e" "j" "f" ))("덜"))
((("e" "j" "f" "a" ))("덞"))
((("e" "j" "f" "q" ))("덟"))
((("e" "j" "q" ))("덥"))
((("e" "j" "r" ))("덕"))
((("e" "j" "s" ))("던"))
((("e" "j" "t" ))("덧"))
((("e" "j" "v" ))("덮"))
((("e" "k" ))("다"))
((("e" "k" "R" ))("닦"))
((("e" "k" "T" ))("닸"))
((("e" "k" "a" ))("담"))
((("e" "k" "c" ))("닻"))
((("e" "k" "d" ))("당"))
((("e" "k" "e" ))("닫"))
((("e" "k" "f" ))("달"))
((("e" "k" "f" "a" ))("닮"))
((("e" "k" "f" "g" ))("닳"))
((("e" "k" "f" "q" ))("닯"))
((("e" "k" "f" "r" ))("닭"))
((("e" "k" "g" ))("닿"))
((("e" "k" "q" ))("답"))
((("e" "k" "r" ))("닥"))
((("e" "k" "s" ))("단"))
((("e" "k" "t" ))("닷"))
((("e" "k" "w" ))("닺"))
((("e" "l" ))("디"))
((("e" "l" "T" ))("딨"))
((("e" "l" "a" ))("딤"))
((("e" "l" "d" ))("딩"))
((("e" "l" "e" ))("딛"))
((("e" "l" "f" ))("딜"))
((("e" "l" "q" ))("딥"))
((("e" "l" "r" ))("딕"))
((("e" "l" "s" ))("딘"))
((("e" "l" "t" ))("딧"))
((("e" "l" "w" ))("딪"))
((("e" "m" ))("드"))
((("e" "m" "a" ))("듬"))
((("e" "m" "d" ))("등"))
((("e" "m" "e" ))("듣"))
((("e" "m" "f" ))("들"))
((("e" "m" "f" "a" ))("듦"))
((("e" "m" "l" ))("듸"))
((("e" "m" "q" ))("듭"))
((("e" "m" "r" ))("득"))
((("e" "m" "s" ))("든"))
((("e" "m" "t" ))("듯"))
((("e" "n" ))("두"))
((("e" "n" "a" ))("둠"))
((("e" "n" "d" ))("둥"))
((("e" "n" "f" ))("둘"))
((("e" "n" "j" ))("둬"))
((("e" "n" "j" "T" ))("뒀"))
((("e" "n" "l" ))("뒤"))
((("e" "n" "l" "d" ))("뒹"))
((("e" "n" "l" "f" ))("뒬"))
((("e" "n" "l" "q" ))("뒵"))
((("e" "n" "l" "s" ))("뒨"))
((("e" "n" "l" "t" ))("뒷"))
((("e" "n" "p" ))("뒈"))
((("e" "n" "p" "d" ))("뒝"))
((("e" "n" "q" ))("둡"))
((("e" "n" "r" ))("둑"))
((("e" "n" "s" ))("둔"))
((("e" "n" "t" ))("둣"))
((("e" "o" ))("대"))
((("e" "o" "T" ))("댔"))
((("e" "o" "a" ))("댐"))
((("e" "o" "d" ))("댕"))
((("e" "o" "f" ))("댈"))
((("e" "o" "q" ))("댑"))
((("e" "o" "r" ))("댁"))
((("e" "o" "s" ))("댄"))
((("e" "o" "t" ))("댓"))
((("e" "p" ))("데"))
((("e" "p" "T" ))("뎄"))
((("e" "p" "a" ))("뎀"))
((("e" "p" "d" ))("뎅"))
((("e" "p" "f" ))("델"))
((("e" "p" "q" ))("뎁"))
((("e" "p" "r" ))("덱"))
((("e" "p" "s" ))("덴"))
((("e" "p" "t" ))("뎃"))
((("e" "u" ))("뎌"))
((("e" "u" "T" ))("뎠"))
((("e" "u" "d" ))("뎡"))
((("e" "u" "f" ))("뎔"))
((("e" "u" "s" ))("뎐"))
((("e" "y" ))("됴"))
((("f" ))("ㄹ"))
((("f" "P" ))("례"))
((("f" "P" "q" ))("롑"))
((("f" "P" "s" ))("롄"))
((("f" "P" "t" ))("롓"))
((("f" "b" ))("류"))
((("f" "b" "a" ))("륨"))
((("f" "b" "d" ))("륭"))
((("f" "b" "f" ))("률"))
((("f" "b" "q" ))("륩"))
((("f" "b" "r" ))("륙"))
((("f" "b" "s" ))("륜"))
((("f" "b" "t" ))("륫"))
((("f" "h" ))("로"))
((("f" "h" "a" ))("롬"))
((("f" "h" "d" ))("롱"))
((("f" "h" "f" ))("롤"))
((("f" "h" "k" ))("롸"))
((("f" "h" "k" "d" ))("뢍"))
((("f" "h" "k" "s" ))("롼"))
((("f" "h" "l" ))("뢰"))
((("f" "h" "l" "a" ))("룀"))
((("f" "h" "l" "d" ))("룅"))
((("f" "h" "l" "f" ))("뢸"))
((("f" "h" "l" "q" ))("룁"))
((("f" "h" "l" "s" ))("뢴"))
((("f" "h" "l" "t" ))("룃"))
((("f" "h" "o" "T" ))("뢨"))
((("f" "h" "q" ))("롭"))
((("f" "h" "r" ))("록"))
((("f" "h" "s" ))("론"))
((("f" "h" "t" ))("롯"))
((("f" "i" ))("랴"))
((("f" "i" "d" ))("량"))
((("f" "i" "r" ))("략"))
((("f" "i" "s" ))("랸"))
((("f" "i" "t" ))("럇"))
((("f" "j" ))("러"))
((("f" "j" "T" ))("렀"))
((("f" "j" "a" ))("럼"))
((("f" "j" "d" ))("렁"))
((("f" "j" "f" ))("럴"))
((("f" "j" "g" ))("렇"))
((("f" "j" "q" ))("럽"))
((("f" "j" "r" ))("럭"))
((("f" "j" "s" ))("런"))
((("f" "j" "t" ))("럿"))
((("f" "k" ))("라"))
((("f" "k" "T" ))("랐"))
((("f" "k" "a" ))("람"))
((("f" "k" "d" ))("랑"))
((("f" "k" "f" ))("랄"))
((("f" "k" "g" ))("랗"))
((("f" "k" "q" ))("랍"))
((("f" "k" "r" ))("락"))
((("f" "k" "s" ))("란"))
((("f" "k" "t" ))("랏"))
((("f" "k" "v" ))("랖"))
((("f" "k" "w" ))("랒"))
((("f" "l" ))("리"))
((("f" "l" "a" ))("림"))
((("f" "l" "d" ))("링"))
((("f" "l" "f" ))("릴"))
((("f" "l" "q" ))("립"))
((("f" "l" "r" ))("릭"))
((("f" "l" "s" ))("린"))
((("f" "l" "t" ))("릿"))
((("f" "m" ))("르"))
((("f" "m" "a" ))("름"))
((("f" "m" "d" ))("릉"))
((("f" "m" "f" ))("를"))
((("f" "m" "q" ))("릅"))
((("f" "m" "r" ))("륵"))
((("f" "m" "s" ))("른"))
((("f" "m" "t" ))("릇"))
((("f" "m" "v" ))("릎"))
((("f" "m" "w" ))("릊"))
((("f" "m" "x" ))("릍"))
((("f" "n" ))("루"))
((("f" "n" "a" ))("룸"))
((("f" "n" "d" ))("룽"))
((("f" "n" "f" ))("룰"))
((("f" "n" "j" ))("뤄"))
((("f" "n" "j" "T" ))("뤘"))
((("f" "n" "l" ))("뤼"))
((("f" "n" "l" "a" ))("륌"))
((("f" "n" "l" "d" ))("륑"))
((("f" "n" "l" "f" ))("륄"))
((("f" "n" "l" "r" ))("뤽"))
((("f" "n" "l" "s" ))("륀"))
((("f" "n" "l" "t" ))("륏"))
((("f" "n" "p" ))("뤠"))
((("f" "n" "q" ))("룹"))
((("f" "n" "r" ))("룩"))
((("f" "n" "s" ))("룬"))
((("f" "n" "t" ))("룻"))
((("f" "o" ))("래"))
((("f" "o" "T" ))("랬"))
((("f" "o" "a" ))("램"))
((("f" "o" "d" ))("랭"))
((("f" "o" "f" ))("랠"))
((("f" "o" "q" ))("랩"))
((("f" "o" "r" ))("랙"))
((("f" "o" "s" ))("랜"))
((("f" "o" "t" ))("랫"))
((("f" "p" ))("레"))
((("f" "p" "a" ))("렘"))
((("f" "p" "d" ))("렝"))
((("f" "p" "f" ))("렐"))
((("f" "p" "q" ))("렙"))
((("f" "p" "r" ))("렉"))
((("f" "p" "s" ))("렌"))
((("f" "p" "t" ))("렛"))
((("f" "u" ))("려"))
((("f" "u" "T" ))("렸"))
((("f" "u" "a" ))("렴"))
((("f" "u" "d" ))("령"))
((("f" "u" "f" ))("렬"))
((("f" "u" "q" ))("렵"))
((("f" "u" "r" ))("력"))
((("f" "u" "s" ))("련"))
((("f" "u" "t" ))("렷"))
((("f" "y" ))("료"))
((("f" "y" "d" ))("룡"))
((("f" "y" "f" ))("룔"))
((("f" "y" "q" ))("룝"))
((("f" "y" "s" ))("룐"))
((("f" "y" "t" ))("룟"))
((("g" ))("ㅎ"))
((("g" "P" ))("혜"))
((("g" "P" "f" ))("혤"))
((("g" "P" "q" ))("혭"))
((("g" "P" "s" ))("혠"))
((("g" "b" ))("휴"))
((("g" "b" "a" ))("흄"))
((("g" "b" "d" ))("흉"))
((("g" "b" "f" ))("휼"))
((("g" "b" "r" ))("휵"))
((("g" "b" "s" ))("휸"))
((("g" "b" "t" ))("흇"))
((("g" "h" ))("호"))
((("g" "h" "a" ))("홈"))
((("g" "h" "d" ))("홍"))
((("g" "h" "f" ))("홀"))
((("g" "h" "f" "x" ))("홅"))
((("g" "h" "k" ))("화"))
((("g" "h" "k" "d" ))("황"))
((("g" "h" "k" "f" ))("활"))
((("g" "h" "k" "r" ))("확"))
((("g" "h" "k" "s" ))("환"))
((("g" "h" "k" "t" ))("홧"))
((("g" "h" "l" ))("회"))
((("g" "h" "l" "d" ))("횡"))
((("g" "h" "l" "f" ))("횔"))
((("g" "h" "l" "q" ))("횝"))
((("g" "h" "l" "r" ))("획"))
((("g" "h" "l" "s" ))("횐"))
((("g" "h" "l" "t" ))("횟"))
((("g" "h" "o" ))("홰"))
((("g" "h" "o" "d" ))("횅"))
((("g" "h" "o" "r" ))("홱"))
((("g" "h" "o" "s" ))("홴"))
((("g" "h" "o" "t" ))("횃"))
((("g" "h" "q" ))("홉"))
((("g" "h" "r" ))("혹"))
((("g" "h" "s" ))("혼"))
((("g" "h" "t" ))("홋"))
((("g" "h" "x" ))("홑"))
((("g" "i" ))("햐"))
((("g" "i" "d" ))("향"))
((("g" "j" ))("허"))
((("g" "j" "a" ))("험"))
((("g" "j" "d" ))("헝"))
((("g" "j" "f" ))("헐"))
((("g" "j" "f" "a" ))("헒"))
((("g" "j" "q" ))("헙"))
((("g" "j" "r" ))("헉"))
((("g" "j" "s" ))("헌"))
((("g" "j" "t" ))("헛"))
((("g" "k" ))("하"))
((("g" "k" "a" ))("함"))
((("g" "k" "d" ))("항"))
((("g" "k" "f" ))("할"))
((("g" "k" "f" "x" ))("핥"))
((("g" "k" "q" ))("합"))
((("g" "k" "r" ))("학"))
((("g" "k" "s" ))("한"))
((("g" "k" "t" ))("핫"))
((("g" "l" ))("히"))
((("g" "l" "a" ))("힘"))
((("g" "l" "d" ))("힝"))
((("g" "l" "f" ))("힐"))
((("g" "l" "q" ))("힙"))
((("g" "l" "r" ))("힉"))
((("g" "l" "s" ))("힌"))
((("g" "l" "t" ))("힛"))
((("g" "m" ))("흐"))
((("g" "m" "a" ))("흠"))
((("g" "m" "d" ))("흥"))
((("g" "m" "e" ))("흗"))
((("g" "m" "f" ))("흘"))
((("g" "m" "f" "r" ))("흙"))
((("g" "m" "l" ))("희"))
((("g" "m" "l" "a" ))("흼"))
((("g" "m" "l" "d" ))("힁"))
((("g" "m" "l" "f" ))("흴"))
((("g" "m" "l" "q" ))("흽"))
((("g" "m" "l" "s" ))("흰"))
((("g" "m" "q" ))("흡"))
((("g" "m" "r" ))("흑"))
((("g" "m" "s" ))("흔"))
((("g" "m" "s" "g" ))("흖"))
((("g" "m" "t" ))("흣"))
((("g" "m" "x" ))("흩"))
((("g" "n" ))("후"))
((("g" "n" "a" ))("훔"))
((("g" "n" "d" ))("훙"))
((("g" "n" "f" ))("훌"))
((("g" "n" "f" "x" ))("훑"))
((("g" "n" "j" ))("훠"))
((("g" "n" "j" "a" ))("훰"))
((("g" "n" "j" "d" ))("훵"))
((("g" "n" "j" "f" ))("훨"))
((("g" "n" "j" "s" ))("훤"))
((("g" "n" "l" ))("휘"))
((("g" "n" "l" "a" ))("휨"))
((("g" "n" "l" "d" ))("휭"))
((("g" "n" "l" "f" ))("휠"))
((("g" "n" "l" "q" ))("휩"))
((("g" "n" "l" "r" ))("휙"))
((("g" "n" "l" "s" ))("휜"))
((("g" "n" "l" "t" ))("휫"))
((("g" "n" "p" ))("훼"))
((("g" "n" "p" "d" ))("휑"))
((("g" "n" "p" "f" ))("휄"))
((("g" "n" "p" "r" ))("훽"))
((("g" "n" "p" "s" ))("휀"))
((("g" "n" "r" ))("훅"))
((("g" "n" "s" ))("훈"))
((("g" "n" "t" ))("훗"))
((("g" "o" ))("해"))
((("g" "o" "T" ))("했"))
((("g" "o" "a" ))("햄"))
((("g" "o" "d" ))("행"))
((("g" "o" "f" ))("핼"))
((("g" "o" "q" ))("햅"))
((("g" "o" "r" ))("핵"))
((("g" "o" "s" ))("핸"))
((("g" "o" "t" ))("햇"))
((("g" "p" ))("헤"))
((("g" "p" "a" ))("헴"))
((("g" "p" "d" ))("헹"))
((("g" "p" "f" ))("헬"))
((("g" "p" "q" ))("헵"))
((("g" "p" "r" ))("헥"))
((("g" "p" "s" ))("헨"))
((("g" "p" "t" ))("헷"))
((("g" "u" ))("혀"))
((("g" "u" "T" ))("혔"))
((("g" "u" "a" ))("혐"))
((("g" "u" "d" ))("형"))
((("g" "u" "f" ))("혈"))
((("g" "u" "q" ))("협"))
((("g" "u" "r" ))("혁"))
((("g" "u" "s" ))("현"))
((("g" "u" "t" ))("혓"))
((("g" "y" ))("효"))
((("g" "y" "f" ))("횰"))
((("g" "y" "q" ))("횹"))
((("g" "y" "s" ))("횬"))
((("g" "y" "t" ))("횻"))
((("h" ))("ㅗ"))
((("i" ))("ㅑ"))
((("j" ))("ㅓ"))
((("k" ))("ㅏ"))
((("l" ))("ㅣ"))
((("m" ))("ㅡ"))
((("n" ))("ㅜ"))
((("o" ))("ㅐ"))
((("p" ))("ㅔ"))
((("q" ))("ㅂ"))
((("q" "P" ))("볘"))
((("q" "P" "s" ))("볜"))
((("q" "b" ))("뷰"))
((("q" "b" "a" ))("븀"))
((("q" "b" "d" ))("븅"))
((("q" "b" "f" ))("뷸"))
((("q" "b" "s" ))("뷴"))
((("q" "b" "t" ))("븃"))
((("q" "h" ))("보"))
((("q" "h" "R" ))("볶"))
((("q" "h" "a" ))("봄"))
((("q" "h" "d" ))("봉"))
((("q" "h" "f" ))("볼"))
((("q" "h" "k" ))("봐"))
((("q" "h" "k" "T" ))("봤"))
((("q" "h" "k" "s" ))("봔"))
((("q" "h" "l" ))("뵈"))
((("q" "h" "l" "a" ))("뵘"))
((("q" "h" "l" "f" ))("뵐"))
((("q" "h" "l" "q" ))("뵙"))
((("q" "h" "l" "r" ))("뵉"))
((("q" "h" "l" "s" ))("뵌"))
((("q" "h" "o" ))("봬"))
((("q" "h" "o" "T" ))("뵀"))
((("q" "h" "q" ))("봅"))
((("q" "h" "r" ))("복"))
((("q" "h" "s" ))("본"))
((("q" "h" "t" ))("봇"))
((("q" "i" ))("뱌"))
((("q" "i" "q" ))("뱝"))
((("q" "i" "r" ))("뱍"))
((("q" "i" "s" ))("뱐"))
((("q" "j" ))("버"))
((("q" "j" "a" ))("범"))
((("q" "j" "d" ))("벙"))
((("q" "j" "e" ))("벋"))
((("q" "j" "f" ))("벌"))
((("q" "j" "f" "a" ))("벎"))
((("q" "j" "q" ))("법"))
((("q" "j" "r" ))("벅"))
((("q" "j" "s" ))("번"))
((("q" "j" "t" ))("벗"))
((("q" "j" "w" ))("벚"))
((("q" "k" ))("바"))
((("q" "k" "R" ))("밖"))
((("q" "k" "a" ))("밤"))
((("q" "k" "d" ))("방"))
((("q" "k" "e" ))("받"))
((("q" "k" "f" ))("발"))
((("q" "k" "f" "a" ))("밞"))
((("q" "k" "f" "q" ))("밟"))
((("q" "k" "f" "r" ))("밝"))
((("q" "k" "q" ))("밥"))
((("q" "k" "r" ))("박"))
((("q" "k" "r" "t" ))("밗"))
((("q" "k" "s" ))("반"))
((("q" "k" "t" ))("밧"))
((("q" "k" "x" ))("밭"))
((("q" "l" ))("비"))
((("q" "l" "a" ))("빔"))
((("q" "l" "c" ))("빛"))
((("q" "l" "d" ))("빙"))
((("q" "l" "f" ))("빌"))
((("q" "l" "f" "a" ))("빎"))
((("q" "l" "q" ))("빕"))
((("q" "l" "r" ))("빅"))
((("q" "l" "s" ))("빈"))
((("q" "l" "t" ))("빗"))
((("q" "l" "w" ))("빚"))
((("q" "m" ))("브"))
((("q" "m" "a" ))("븜"))
((("q" "m" "f" ))("블"))
((("q" "m" "q" ))("븝"))
((("q" "m" "r" ))("븍"))
((("q" "m" "s" ))("븐"))
((("q" "m" "t" ))("븟"))
((("q" "n" ))("부"))
((("q" "n" "a" ))("붐"))
((("q" "n" "d" ))("붕"))
((("q" "n" "e" ))("붇"))
((("q" "n" "f" ))("불"))
((("q" "n" "f" "a" ))("붊"))
((("q" "n" "f" "r" ))("붉"))
((("q" "n" "j" ))("붜"))
((("q" "n" "j" "T" ))("붰"))
((("q" "n" "j" "f" ))("붤"))
((("q" "n" "l" ))("뷔"))
((("q" "n" "l" "d" ))("뷩"))
((("q" "n" "l" "f" ))("뷜"))
((("q" "n" "l" "r" ))("뷕"))
((("q" "n" "l" "s" ))("뷘"))
((("q" "n" "p" ))("붸"))
((("q" "n" "q" ))("붑"))
((("q" "n" "r" ))("북"))
((("q" "n" "s" ))("분"))
((("q" "n" "t" ))("붓"))
((("q" "n" "v" ))("붚"))
((("q" "n" "x" ))("붙"))
((("q" "o" ))("배"))
((("q" "o" "T" ))("뱄"))
((("q" "o" "a" ))("뱀"))
((("q" "o" "d" ))("뱅"))
((("q" "o" "f" ))("밸"))
((("q" "o" "q" ))("뱁"))
((("q" "o" "r" ))("백"))
((("q" "o" "s" ))("밴"))
((("q" "o" "t" ))("뱃"))
((("q" "o" "x" ))("뱉"))
((("q" "p" ))("베"))
((("q" "p" "T" ))("벴"))
((("q" "p" "a" ))("벰"))
((("q" "p" "d" ))("벵"))
((("q" "p" "e" ))("벧"))
((("q" "p" "f" ))("벨"))
((("q" "p" "q" ))("벱"))
((("q" "p" "r" ))("벡"))
((("q" "p" "s" ))("벤"))
((("q" "p" "t" ))("벳"))
((("q" "u" ))("벼"))
((("q" "u" "T" ))("볐"))
((("q" "u" "d" ))("병"))
((("q" "u" "f" ))("별"))
((("q" "u" "q" ))("볍"))
((("q" "u" "r" ))("벽"))
((("q" "u" "s" ))("변"))
((("q" "u" "t" ))("볏"))
((("q" "u" "x" ))("볕"))
((("q" "y" ))("뵤"))
((("q" "y" "s" ))("뵨"))
((("r" ))("ㄱ"))
((("r" "O" ))("걔"))
((("r" "O" "f" ))("걜"))
((("r" "O" "s" ))("걘"))
((("r" "P" ))("계"))
((("r" "P" "f" ))("곌"))
((("r" "P" "q" ))("곕"))
((("r" "P" "s" ))("곈"))
((("r" "P" "t" ))("곗"))
((("r" "b" ))("규"))
((("r" "b" "f" ))("귤"))
((("r" "b" "s" ))("균"))
((("r" "h" ))("고"))
((("r" "h" "a" ))("곰"))
((("r" "h" "d" ))("공"))
((("r" "h" "e" ))("곧"))
((("r" "h" "f" ))("골"))
((("r" "h" "f" "a" ))("곪"))
((("r" "h" "f" "g" ))("곯"))
((("r" "h" "f" "t" ))("곬"))
((("r" "h" "k" ))("과"))
((("r" "h" "k" "a" ))("괌"))
((("r" "h" "k" "d" ))("광"))
((("r" "h" "k" "f" ))("괄"))
((("r" "h" "k" "f" "a" ))("괆"))
((("r" "h" "k" "q" ))("괍"))
((("r" "h" "k" "r" ))("곽"))
((("r" "h" "k" "s" ))("관"))
((("r" "h" "k" "t" ))("괏"))
((("r" "h" "l" ))("괴"))
((("r" "h" "l" "a" ))("굄"))
((("r" "h" "l" "d" ))("굉"))
((("r" "h" "l" "f" ))("괼"))
((("r" "h" "l" "q" ))("굅"))
((("r" "h" "l" "r" ))("괵"))
((("r" "h" "l" "s" ))("괸"))
((("r" "h" "l" "t" ))("굇"))
((("r" "h" "o" ))("괘"))
((("r" "h" "o" "T" ))("괬"))
((("r" "h" "o" "d" ))("괭"))
((("r" "h" "o" "f" ))("괠"))
((("r" "h" "o" "q" ))("괩"))
((("r" "h" "o" "s" ))("괜"))
((("r" "h" "q" ))("곱"))
((("r" "h" "r" ))("곡"))
((("r" "h" "s" ))("곤"))
((("r" "h" "t" ))("곳"))
((("r" "h" "w" ))("곶"))
((("r" "i" ))("갸"))
((("r" "i" "d" ))("걍"))
((("r" "i" "f" ))("걀"))
((("r" "i" "r" ))("갹"))
((("r" "i" "s" ))("갼"))
((("r" "i" "t" ))("걋"))
((("r" "j" ))("거"))
((("r" "j" "T" ))("겄"))
((("r" "j" "a" ))("검"))
((("r" "j" "d" ))("겅"))
((("r" "j" "e" ))("걷"))
((("r" "j" "f" ))("걸"))
((("r" "j" "f" "a" ))("걺"))
((("r" "j" "g" ))("겋"))
((("r" "j" "q" ))("겁"))
((("r" "j" "r" ))("걱"))
((("r" "j" "s" ))("건"))
((("r" "j" "t" ))("것"))
((("r" "j" "v" ))("겊"))
((("r" "j" "w" ))("겆"))
((("r" "j" "x" ))("겉"))
((("r" "k" ))("가"))
((("r" "k" "T" ))("갔"))
((("r" "k" "a" ))("감"))
((("r" "k" "c" ))("갗"))
((("r" "k" "d" ))("강"))
((("r" "k" "e" ))("갇"))
((("r" "k" "f" ))("갈"))
((("r" "k" "f" "a" ))("갊"))
((("r" "k" "f" "r" ))("갉"))
((("r" "k" "g" ))("갛"))
((("r" "k" "q" ))("갑"))
((("r" "k" "q" "t" ))("값"))
((("r" "k" "r" ))("각"))
((("r" "k" "s" ))("간"))
((("r" "k" "t" ))("갓"))
((("r" "k" "v" ))("갚"))
((("r" "k" "w" ))("갖"))
((("r" "k" "x" ))("같"))
((("r" "l" ))("기"))
((("r" "l" "a" ))("김"))
((("r" "l" "d" ))("깅"))
((("r" "l" "e" ))("긷"))
((("r" "l" "f" ))("길"))
((("r" "l" "f" "a" ))("긺"))
((("r" "l" "q" ))("깁"))
((("r" "l" "r" ))("긱"))
((("r" "l" "s" ))("긴"))
((("r" "l" "t" ))("깃"))
((("r" "l" "v" ))("깊"))
((("r" "l" "w" ))("깆"))
((("r" "m" ))("그"))
((("r" "m" "a" ))("금"))
((("r" "m" "d" ))("긍"))
((("r" "m" "e" ))("귿"))
((("r" "m" "f" ))("글"))
((("r" "m" "f" "r" ))("긁"))
((("r" "m" "l" ))("긔"))
((("r" "m" "q" ))("급"))
((("r" "m" "r" ))("극"))
((("r" "m" "s" ))("근"))
((("r" "m" "t" ))("긋"))
((("r" "n" ))("구"))
((("r" "n" "a" ))("굼"))
((("r" "n" "d" ))("궁"))
((("r" "n" "e" ))("굳"))
((("r" "n" "f" ))("굴"))
((("r" "n" "f" "a" ))("굶"))
((("r" "n" "f" "g" ))("굻"))
((("r" "n" "f" "r" ))("굵"))
((("r" "n" "j" ))("궈"))
((("r" "n" "j" "T" ))("궜"))
((("r" "n" "j" "d" ))("궝"))
((("r" "n" "j" "f" ))("궐"))
((("r" "n" "j" "r" ))("궉"))
((("r" "n" "j" "s" ))("권"))
((("r" "n" "l" ))("귀"))
((("r" "n" "l" "a" ))("귐"))
((("r" "n" "l" "f" ))("귈"))
((("r" "n" "l" "q" ))("귑"))
((("r" "n" "l" "r" ))("귁"))
((("r" "n" "l" "s" ))("귄"))
((("r" "n" "l" "t" ))("귓"))
((("r" "n" "p" ))("궤"))
((("r" "n" "p" "t" ))("궷"))
((("r" "n" "q" ))("굽"))
((("r" "n" "r" ))("국"))
((("r" "n" "s" ))("군"))
((("r" "n" "t" ))("굿"))
((("r" "n" "w" ))("궂"))
((("r" "o" ))("개"))
((("r" "o" "T" ))("갰"))
((("r" "o" "a" ))("갬"))
((("r" "o" "d" ))("갱"))
((("r" "o" "f" ))("갤"))
((("r" "o" "q" ))("갭"))
((("r" "o" "r" ))("객"))
((("r" "o" "s" ))("갠"))
((("r" "o" "t" ))("갯"))
((("r" "p" ))("게"))
((("r" "p" "T" ))("겠"))
((("r" "p" "a" ))("겜"))
((("r" "p" "d" ))("겡"))
((("r" "p" "f" ))("겔"))
((("r" "p" "q" ))("겝"))
((("r" "p" "s" ))("겐"))
((("r" "p" "t" ))("겟"))
((("r" "u" ))("겨"))
((("r" "u" "R" ))("겪"))
((("r" "u" "T" ))("겼"))
((("r" "u" "a" ))("겸"))
((("r" "u" "d" ))("경"))
((("r" "u" "e" ))("겯"))
((("r" "u" "f" ))("결"))
((("r" "u" "q" ))("겹"))
((("r" "u" "r" ))("격"))
((("r" "u" "s" ))("견"))
((("r" "u" "t" ))("겻"))
((("r" "u" "x" ))("곁"))
((("r" "y" ))("교"))
((("r" "y" "f" ))("굘"))
((("r" "y" "q" ))("굡"))
((("r" "y" "s" ))("굔"))
((("r" "y" "t" ))("굣"))
((("s" ))("ㄴ"))
((("s" "P" ))("녜"))
((("s" "P" "s" ))("녠"))
((("s" "b" ))("뉴"))
((("s" "b" "a" ))("늄"))
((("s" "b" "d" ))("늉"))
((("s" "b" "f" ))("뉼"))
((("s" "b" "q" ))("늅"))
((("s" "b" "r" ))("뉵"))
((("s" "h" ))("노"))
((("s" "h" "a" ))("놈"))
((("s" "h" "d" ))("농"))
((("s" "h" "f" ))("놀"))
((("s" "h" "f" "a" ))("놂"))
((("s" "h" "g" ))("놓"))
((("s" "h" "k" ))("놔"))
((("s" "h" "k" "T" ))("놨"))
((("s" "h" "k" "f" ))("놜"))
((("s" "h" "k" "s" ))("놘"))
((("s" "h" "l" ))("뇌"))
((("s" "h" "l" "a" ))("뇜"))
((("s" "h" "l" "f" ))("뇔"))
((("s" "h" "l" "q" ))("뇝"))
((("s" "h" "l" "s" ))("뇐"))
((("s" "h" "l" "t" ))("뇟"))
((("s" "h" "q" ))("놉"))
((("s" "h" "r" ))("녹"))
((("s" "h" "s" ))("논"))
((("s" "h" "t" ))("놋"))
((("s" "h" "v" ))("높"))
((("s" "i" ))("냐"))
((("s" "i" "a" ))("냠"))
((("s" "i" "d" ))("냥"))
((("s" "i" "f" ))("냘"))
((("s" "i" "r" ))("냑"))
((("s" "i" "s" ))("냔"))
((("s" "j" ))("너"))
((("s" "j" "T" ))("넜"))
((("s" "j" "a" ))("넘"))
((("s" "j" "d" ))("넝"))
((("s" "j" "f" ))("널"))
((("s" "j" "f" "a" ))("넒"))
((("s" "j" "f" "q" ))("넓"))
((("s" "j" "g" ))("넣"))
((("s" "j" "q" ))("넙"))
((("s" "j" "r" ))("넉"))
((("s" "j" "r" "t" ))("넋"))
((("s" "j" "s" ))("넌"))
((("s" "j" "t" ))("넛"))
((("s" "k" ))("나"))
((("s" "k" "R" ))("낚"))
((("s" "k" "T" ))("났"))
((("s" "k" "a" ))("남"))
((("s" "k" "c" ))("낯"))
((("s" "k" "d" ))("낭"))
((("s" "k" "e" ))("낟"))
((("s" "k" "f" ))("날"))
((("s" "k" "f" "a" ))("낢"))
((("s" "k" "f" "r" ))("낡"))
((("s" "k" "g" ))("낳"))
((("s" "k" "q" ))("납"))
((("s" "k" "r" ))("낙"))
((("s" "k" "s" ))("난"))
((("s" "k" "t" ))("낫"))
((("s" "k" "w" ))("낮"))
((("s" "k" "x" ))("낱"))
((("s" "l" ))("니"))
((("s" "l" "a" ))("님"))
((("s" "l" "d" ))("닝"))
((("s" "l" "f" ))("닐"))
((("s" "l" "f" "a" ))("닒"))
((("s" "l" "q" ))("닙"))
((("s" "l" "r" ))("닉"))
((("s" "l" "s" ))("닌"))
((("s" "l" "t" ))("닛"))
((("s" "l" "v" ))("닢"))
((("s" "m" ))("느"))
((("s" "m" "a" ))("늠"))
((("s" "m" "d" ))("능"))
((("s" "m" "f" ))("늘"))
((("s" "m" "f" "a" ))("늚"))
((("s" "m" "f" "r" ))("늙"))
((("s" "m" "l" ))("늬"))
((("s" "m" "l" "f" ))("늴"))
((("s" "m" "l" "s" ))("늰"))
((("s" "m" "q" ))("늡"))
((("s" "m" "r" ))("늑"))
((("s" "m" "s" ))("는"))
((("s" "m" "t" ))("늣"))
((("s" "m" "v" ))("늪"))
((("s" "m" "w" ))("늦"))
((("s" "n" ))("누"))
((("s" "n" "a" ))("눔"))
((("s" "n" "d" ))("눙"))
((("s" "n" "e" ))("눋"))
((("s" "n" "f" ))("눌"))
((("s" "n" "j" ))("눠"))
((("s" "n" "j" "T" ))("눴"))
((("s" "n" "l" ))("뉘"))
((("s" "n" "l" "a" ))("뉨"))
((("s" "n" "l" "f" ))("뉠"))
((("s" "n" "l" "q" ))("뉩"))
((("s" "n" "l" "s" ))("뉜"))
((("s" "n" "p" ))("눼"))
((("s" "n" "q" ))("눕"))
((("s" "n" "r" ))("눅"))
((("s" "n" "s" ))("눈"))
((("s" "n" "t" ))("눗"))
((("s" "o" ))("내"))
((("s" "o" "T" ))("냈"))
((("s" "o" "a" ))("냄"))
((("s" "o" "d" ))("냉"))
((("s" "o" "f" ))("낼"))
((("s" "o" "q" ))("냅"))
((("s" "o" "r" ))("낵"))
((("s" "o" "s" ))("낸"))
((("s" "o" "t" ))("냇"))
((("s" "p" ))("네"))
((("s" "p" "T" ))("넸"))
((("s" "p" "a" ))("넴"))
((("s" "p" "d" ))("넹"))
((("s" "p" "f" ))("넬"))
((("s" "p" "q" ))("넵"))
((("s" "p" "r" ))("넥"))
((("s" "p" "s" ))("넨"))
((("s" "p" "t" ))("넷"))
((("s" "u" ))("녀"))
((("s" "u" "T" ))("녔"))
((("s" "u" "a" ))("념"))
((("s" "u" "d" ))("녕"))
((("s" "u" "f" ))("녈"))
((("s" "u" "q" ))("녑"))
((("s" "u" "r" ))("녁"))
((("s" "u" "s" ))("년"))
((("s" "u" "z" ))("녘"))
((("s" "y" ))("뇨"))
((("s" "y" "d" ))("뇽"))
((("s" "y" "f" ))("뇰"))
((("s" "y" "q" ))("뇹"))
((("s" "y" "r" ))("뇩"))
((("s" "y" "s" ))("뇬"))
((("s" "y" "t" ))("뇻"))
((("t" ))("ㅅ"))
((("t" "O" ))("섀"))
((("t" "O" "a" ))("섐"))
((("t" "O" "d" ))("섕"))
((("t" "O" "f" ))("섈"))
((("t" "O" "s" ))("섄"))
((("t" "P" ))("셰"))
((("t" "P" "d" ))("솅"))
((("t" "P" "f" ))("셸"))
((("t" "P" "s" ))("셴"))
((("t" "b" ))("슈"))
((("t" "b" "a" ))("슘"))
((("t" "b" "d" ))("슝"))
((("t" "b" "f" ))("슐"))
((("t" "b" "r" ))("슉"))
((("t" "b" "t" ))("슛"))
((("t" "h" ))("소"))
((("t" "h" "R" ))("솎"))
((("t" "h" "a" ))("솜"))
((("t" "h" "d" ))("송"))
((("t" "h" "f" ))("솔"))
((("t" "h" "f" "a" ))("솖"))
((("t" "h" "k" ))("솨"))
((("t" "h" "k" "d" ))("솽"))
((("t" "h" "k" "f" ))("솰"))
((("t" "h" "k" "r" ))("솩"))
((("t" "h" "k" "s" ))("솬"))
((("t" "h" "l" ))("쇠"))
((("t" "h" "l" "a" ))("쇰"))
((("t" "h" "l" "f" ))("쇨"))
((("t" "h" "l" "q" ))("쇱"))
((("t" "h" "l" "s" ))("쇤"))
((("t" "h" "l" "t" ))("쇳"))
((("t" "h" "o" ))("쇄"))
((("t" "h" "o" "T" ))("쇘"))
((("t" "h" "o" "a" ))("쇔"))
((("t" "h" "o" "f" ))("쇌"))
((("t" "h" "o" "s" ))("쇈"))
((("t" "h" "o" "t" ))("쇗"))
((("t" "h" "q" ))("솝"))
((("t" "h" "r" ))("속"))
((("t" "h" "s" ))("손"))
((("t" "h" "t" ))("솟"))
((("t" "h" "x" ))("솥"))
((("t" "i" ))("샤"))
((("t" "i" "a" ))("샴"))
((("t" "i" "d" ))("샹"))
((("t" "i" "f" ))("샬"))
((("t" "i" "q" ))("샵"))
((("t" "i" "r" ))("샥"))
((("t" "i" "s" ))("샨"))
((("t" "i" "t" ))("샷"))
((("t" "j" ))("서"))
((("t" "j" "R" ))("섞"))
((("t" "j" "T" ))("섰"))
((("t" "j" "a" ))("섬"))
((("t" "j" "d" ))("성"))
((("t" "j" "e" ))("섣"))
((("t" "j" "f" ))("설"))
((("t" "j" "f" "a" ))("섦"))
((("t" "j" "f" "q" ))("섧"))
((("t" "j" "q" ))("섭"))
((("t" "j" "r" ))("석"))
((("t" "j" "r" "t" ))("섟"))
((("t" "j" "s" ))("선"))
((("t" "j" "t" ))("섯"))
((("t" "j" "v" ))("섶"))
((("t" "k" ))("사"))
((("t" "k" "T" ))("샀"))
((("t" "k" "a" ))("삼"))
((("t" "k" "d" ))("상"))
((("t" "k" "e" ))("삳"))
((("t" "k" "f" ))("살"))
((("t" "k" "f" "a" ))("삶"))
((("t" "k" "f" "r" ))("삵"))
((("t" "k" "q" ))("삽"))
((("t" "k" "r" ))("삭"))
((("t" "k" "r" "t" ))("삯"))
((("t" "k" "s" ))("산"))
((("t" "k" "t" ))("삿"))
((("t" "k" "x" ))("샅"))
((("t" "l" ))("시"))
((("t" "l" "a" ))("심"))
((("t" "l" "d" ))("싱"))
((("t" "l" "e" ))("싣"))
((("t" "l" "f" ))("실"))
((("t" "l" "f" "g" ))("싫"))
((("t" "l" "q" ))("십"))
((("t" "l" "r" ))("식"))
((("t" "l" "s" ))("신"))
((("t" "l" "t" ))("싯"))
((("t" "l" "v" ))("싶"))
((("t" "m" ))("스"))
((("t" "m" "a" ))("슴"))
((("t" "m" "d" ))("승"))
((("t" "m" "f" ))("슬"))
((("t" "m" "f" "r" ))("슭"))
((("t" "m" "q" ))("습"))
((("t" "m" "r" ))("슥"))
((("t" "m" "s" ))("슨"))
((("t" "m" "t" ))("슷"))
((("t" "n" ))("수"))
((("t" "n" "a" ))("숨"))
((("t" "n" "c" ))("숯"))
((("t" "n" "d" ))("숭"))
((("t" "n" "e" ))("숟"))
((("t" "n" "f" ))("술"))
((("t" "n" "j" ))("숴"))
((("t" "n" "j" "T" ))("쉈"))
((("t" "n" "l" ))("쉬"))
((("t" "n" "l" "a" ))("쉼"))
((("t" "n" "l" "d" ))("슁"))
((("t" "n" "l" "f" ))("쉴"))
((("t" "n" "l" "q" ))("쉽"))
((("t" "n" "l" "r" ))("쉭"))
((("t" "n" "l" "s" ))("쉰"))
((("t" "n" "l" "t" ))("쉿"))
((("t" "n" "p" ))("쉐"))
((("t" "n" "p" "a" ))("쉠"))
((("t" "n" "p" "d" ))("쉥"))
((("t" "n" "p" "f" ))("쉘"))
((("t" "n" "p" "r" ))("쉑"))
((("t" "n" "p" "s" ))("쉔"))
((("t" "n" "q" ))("숩"))
((("t" "n" "r" ))("숙"))
((("t" "n" "s" ))("순"))
((("t" "n" "t" ))("숫"))
((("t" "n" "v" ))("숲"))
((("t" "n" "x" ))("숱"))
((("t" "o" ))("새"))
((("t" "o" "T" ))("샜"))
((("t" "o" "a" ))("샘"))
((("t" "o" "d" ))("생"))
((("t" "o" "f" ))("샐"))
((("t" "o" "q" ))("샙"))
((("t" "o" "r" ))("색"))
((("t" "o" "s" ))("샌"))
((("t" "o" "t" ))("샛"))
((("t" "p" ))("세"))
((("t" "p" "T" ))("셌"))
((("t" "p" "a" ))("셈"))
((("t" "p" "d" ))("셍"))
((("t" "p" "f" ))("셀"))
((("t" "p" "q" ))("셉"))
((("t" "p" "r" ))("섹"))
((("t" "p" "s" ))("센"))
((("t" "p" "t" ))("셋"))
((("t" "u" ))("셔"))
((("t" "u" "T" ))("셨"))
((("t" "u" "a" ))("셤"))
((("t" "u" "d" ))("셩"))
((("t" "u" "f" ))("셜"))
((("t" "u" "q" ))("셥"))
((("t" "u" "r" ))("셕"))
((("t" "u" "s" ))("션"))
((("t" "u" "t" ))("셧"))
((("t" "y" ))("쇼"))
((("t" "y" "a" ))("숌"))
((("t" "y" "d" ))("숑"))
((("t" "y" "f" ))("숄"))
((("t" "y" "q" ))("숍"))
((("t" "y" "r" ))("쇽"))
((("t" "y" "s" ))("숀"))
((("t" "y" "t" ))("숏"))
((("u" ))("ㅕ"))
((("v" ))("ㅍ"))
((("v" "P" ))("폐"))
((("v" "P" "f" ))("폘"))
((("v" "P" "q" ))("폡"))
((("v" "P" "t" ))("폣"))
((("v" "b" ))("퓨"))
((("v" "b" "a" ))("퓸"))
((("v" "b" "d" ))("퓽"))
((("v" "b" "f" ))("퓰"))
((("v" "b" "s" ))("퓬"))
((("v" "b" "t" ))("퓻"))
((("v" "h" ))("포"))
((("v" "h" "a" ))("폼"))
((("v" "h" "d" ))("퐁"))
((("v" "h" "f" ))("폴"))
((("v" "h" "k" ))("퐈"))
((("v" "h" "k" "d" ))("퐝"))
((("v" "h" "l" ))("푀"))
((("v" "h" "l" "s" ))("푄"))
((("v" "h" "q" ))("폽"))
((("v" "h" "r" ))("폭"))
((("v" "h" "s" ))("폰"))
((("v" "h" "t" ))("폿"))
((("v" "i" ))("퍄"))
((("v" "i" "r" ))("퍅"))
((("v" "j" ))("퍼"))
((("v" "j" "T" ))("펐"))
((("v" "j" "a" ))("펌"))
((("v" "j" "d" ))("펑"))
((("v" "j" "f" ))("펄"))
((("v" "j" "q" ))("펍"))
((("v" "j" "r" ))("퍽"))
((("v" "j" "s" ))("펀"))
((("v" "j" "t" ))("펏"))
((("v" "k" ))("파"))
((("v" "k" "R" ))("팎"))
((("v" "k" "T" ))("팠"))
((("v" "k" "a" ))("팜"))
((("v" "k" "d" ))("팡"))
((("v" "k" "f" ))("팔"))
((("v" "k" "f" "a" ))("팖"))
((("v" "k" "q" ))("팝"))
((("v" "k" "r" ))("팍"))
((("v" "k" "s" ))("판"))
((("v" "k" "t" ))("팟"))
((("v" "k" "x" ))("팥"))
((("v" "l" ))("피"))
((("v" "l" "a" ))("핌"))
((("v" "l" "d" ))("핑"))
((("v" "l" "f" ))("필"))
((("v" "l" "q" ))("핍"))
((("v" "l" "r" ))("픽"))
((("v" "l" "s" ))("핀"))
((("v" "l" "t" ))("핏"))
((("v" "m" ))("프"))
((("v" "m" "a" ))("픔"))
((("v" "m" "f" ))("플"))
((("v" "m" "q" ))("픕"))
((("v" "m" "s" ))("픈"))
((("v" "m" "t" ))("픗"))
((("v" "n" ))("푸"))
((("v" "n" "a" ))("품"))
((("v" "n" "d" ))("풍"))
((("v" "n" "e" ))("푿"))
((("v" "n" "f" ))("풀"))
((("v" "n" "f" "a" ))("풂"))
((("v" "n" "j" ))("풔"))
((("v" "n" "j" "d" ))("풩"))
((("v" "n" "l" ))("퓌"))
((("v" "n" "l" "a" ))("퓜"))
((("v" "n" "l" "f" ))("퓔"))
((("v" "n" "l" "s" ))("퓐"))
((("v" "n" "l" "t" ))("퓟"))
((("v" "n" "q" ))("풉"))
((("v" "n" "r" ))("푹"))
((("v" "n" "s" ))("푼"))
((("v" "n" "t" ))("풋"))
((("v" "o" ))("패"))
((("v" "o" "T" ))("팼"))
((("v" "o" "a" ))("팸"))
((("v" "o" "d" ))("팽"))
((("v" "o" "f" ))("팰"))
((("v" "o" "q" ))("팹"))
((("v" "o" "r" ))("팩"))
((("v" "o" "s" ))("팬"))
((("v" "o" "t" ))("팻"))
((("v" "p" ))("페"))
((("v" "p" "a" ))("펨"))
((("v" "p" "d" ))("펭"))
((("v" "p" "f" ))("펠"))
((("v" "p" "q" ))("펩"))
((("v" "p" "r" ))("펙"))
((("v" "p" "s" ))("펜"))
((("v" "p" "t" ))("펫"))
((("v" "u" ))("펴"))
((("v" "u" "T" ))("폈"))
((("v" "u" "a" ))("폄"))
((("v" "u" "d" ))("평"))
((("v" "u" "f" ))("펼"))
((("v" "u" "q" ))("폅"))
((("v" "u" "s" ))("편"))
((("v" "y" ))("표"))
((("v" "y" "f" ))("푤"))
((("v" "y" "q" ))("푭"))
((("v" "y" "s" ))("푠"))
((("v" "y" "t" ))("푯"))
((("w" ))("ㅈ"))
((("w" "O" ))("쟤"))
((("w" "O" "f" ))("쟬"))
((("w" "O" "s" ))("쟨"))
((("w" "P" ))("졔"))
((("w" "b" ))("쥬"))
((("w" "b" "a" ))("쥼"))
((("w" "b" "f" ))("쥴"))
((("w" "b" "s" ))("쥰"))
((("w" "h" ))("조"))
((("w" "h" "a" ))("좀"))
((("w" "h" "c" ))("좇"))
((("w" "h" "d" ))("종"))
((("w" "h" "f" ))("졸"))
((("w" "h" "f" "a" ))("졺"))
((("w" "h" "g" ))("좋"))
((("w" "h" "k" ))("좌"))
((("w" "h" "k" "d" ))("좡"))
((("w" "h" "k" "f" ))("좔"))
((("w" "h" "k" "q" ))("좝"))
((("w" "h" "k" "r" ))("좍"))
((("w" "h" "k" "t" ))("좟"))
((("w" "h" "l" ))("죄"))
((("w" "h" "l" "a" ))("죔"))
((("w" "h" "l" "d" ))("죙"))
((("w" "h" "l" "f" ))("죌"))
((("w" "h" "l" "q" ))("죕"))
((("w" "h" "l" "s" ))("죈"))
((("w" "h" "l" "t" ))("죗"))
((("w" "h" "o" ))("좨"))
((("w" "h" "o" "T" ))("좼"))
((("w" "h" "o" "d" ))("좽"))
((("w" "h" "q" ))("좁"))
((("w" "h" "r" ))("족"))
((("w" "h" "s" ))("존"))
((("w" "h" "t" ))("좃"))
((("w" "h" "w" ))("좆"))
((("w" "i" ))("쟈"))
((("w" "i" "a" ))("쟘"))
((("w" "i" "d" ))("쟝"))
((("w" "i" "f" ))("쟐"))
((("w" "i" "r" ))("쟉"))
((("w" "i" "s" ))("쟌"))
((("w" "i" "s" "g" ))("쟎"))
((("w" "j" ))("저"))
((("w" "j" "a" ))("점"))
((("w" "j" "d" ))("정"))
((("w" "j" "f" ))("절"))
((("w" "j" "f" "a" ))("젊"))
((("w" "j" "q" ))("접"))
((("w" "j" "r" ))("적"))
((("w" "j" "s" ))("전"))
((("w" "j" "t" ))("젓"))
((("w" "j" "w" ))("젖"))
((("w" "k" ))("자"))
((("w" "k" "T" ))("잤"))
((("w" "k" "a" ))("잠"))
((("w" "k" "d" ))("장"))
((("w" "k" "e" ))("잗"))
((("w" "k" "f" ))("잘"))
((("w" "k" "f" "a" ))("잚"))
((("w" "k" "q" ))("잡"))
((("w" "k" "r" ))("작"))
((("w" "k" "s" ))("잔"))
((("w" "k" "s" "g" ))("잖"))
((("w" "k" "t" ))("잣"))
((("w" "k" "w" ))("잦"))
((("w" "l" ))("지"))
((("w" "l" "a" ))("짐"))
((("w" "l" "d" ))("징"))
((("w" "l" "e" ))("짇"))
((("w" "l" "f" ))("질"))
((("w" "l" "f" "a" ))("짊"))
((("w" "l" "q" ))("집"))
((("w" "l" "r" ))("직"))
((("w" "l" "s" ))("진"))
((("w" "l" "t" ))("짓"))
((("w" "l" "v" ))("짚"))
((("w" "l" "w" ))("짖"))
((("w" "l" "x" ))("짙"))
((("w" "m" ))("즈"))
((("w" "m" "a" ))("즘"))
((("w" "m" "d" ))("증"))
((("w" "m" "f" ))("즐"))
((("w" "m" "q" ))("즙"))
((("w" "m" "r" ))("즉"))
((("w" "m" "s" ))("즌"))
((("w" "m" "t" ))("즛"))
((("w" "n" ))("주"))
((("w" "n" "a" ))("줌"))
((("w" "n" "d" ))("중"))
((("w" "n" "f" ))("줄"))
((("w" "n" "f" "a" ))("줆"))
((("w" "n" "f" "r" ))("줅"))
((("w" "n" "j" ))("줘"))
((("w" "n" "j" "T" ))("줬"))
((("w" "n" "l" ))("쥐"))
((("w" "n" "l" "a" ))("쥠"))
((("w" "n" "l" "f" ))("쥘"))
((("w" "n" "l" "q" ))("쥡"))
((("w" "n" "l" "r" ))("쥑"))
((("w" "n" "l" "s" ))("쥔"))
((("w" "n" "l" "t" ))("쥣"))
((("w" "n" "p" ))("줴"))
((("w" "n" "q" ))("줍"))
((("w" "n" "r" ))("죽"))
((("w" "n" "s" ))("준"))
((("w" "n" "t" ))("줏"))
((("w" "o" ))("재"))
((("w" "o" "T" ))("쟀"))
((("w" "o" "a" ))("잼"))
((("w" "o" "d" ))("쟁"))
((("w" "o" "f" ))("잴"))
((("w" "o" "q" ))("잽"))
((("w" "o" "r" ))("잭"))
((("w" "o" "s" ))("잰"))
((("w" "o" "t" ))("잿"))
((("w" "p" ))("제"))
((("w" "p" "a" ))("젬"))
((("w" "p" "d" ))("젱"))
((("w" "p" "f" ))("젤"))
((("w" "p" "q" ))("젭"))
((("w" "p" "r" ))("젝"))
((("w" "p" "s" ))("젠"))
((("w" "p" "t" ))("젯"))
((("w" "u" ))("져"))
((("w" "u" "T" ))("졌"))
((("w" "u" "a" ))("졈"))
((("w" "u" "d" ))("졍"))
((("w" "u" "f" ))("졀"))
((("w" "u" "q" ))("졉"))
((("w" "u" "s" ))("젼"))
((("w" "y" ))("죠"))
((("w" "y" "d" ))("죵"))
((("w" "y" "r" ))("죡"))
((("w" "y" "s" ))("죤"))
((("x" ))("ㅌ"))
((("x" "P" ))("톄"))
((("x" "P" "s" ))("톈"))
((("x" "b" ))("튜"))
((("x" "b" "a" ))("튬"))
((("x" "b" "d" ))("튱"))
((("x" "b" "f" ))("튤"))
((("x" "b" "s" ))("튠"))
((("x" "h" ))("토"))
((("x" "h" "a" ))("톰"))
((("x" "h" "d" ))("통"))
((("x" "h" "f" ))("톨"))
((("x" "h" "k" ))("톼"))
((("x" "h" "k" "s" ))("퇀"))
((("x" "h" "l" ))("퇴"))
((("x" "h" "l" "d" ))("툉"))
((("x" "h" "l" "s" ))("퇸"))
((("x" "h" "l" "t" ))("툇"))
((("x" "h" "o" ))("퇘"))
((("x" "h" "q" ))("톱"))
((("x" "h" "r" ))("톡"))
((("x" "h" "s" ))("톤"))
((("x" "h" "t" ))("톳"))
((("x" "h" "v" ))("톺"))
((("x" "i" ))("탸"))
((("x" "i" "d" ))("턍"))
((("x" "j" ))("터"))
((("x" "j" "T" ))("텄"))
((("x" "j" "a" ))("텀"))
((("x" "j" "d" ))("텅"))
((("x" "j" "f" ))("털"))
((("x" "j" "f" "a" ))("턺"))
((("x" "j" "q" ))("텁"))
((("x" "j" "r" ))("턱"))
((("x" "j" "s" ))("턴"))
((("x" "j" "t" ))("텃"))
((("x" "k" ))("타"))
((("x" "k" "T" ))("탔"))
((("x" "k" "a" ))("탐"))
((("x" "k" "d" ))("탕"))
((("x" "k" "f" ))("탈"))
((("x" "k" "f" "r" ))("탉"))
((("x" "k" "q" ))("탑"))
((("x" "k" "r" ))("탁"))
((("x" "k" "s" ))("탄"))
((("x" "k" "t" ))("탓"))
((("x" "l" ))("티"))
((("x" "l" "a" ))("팀"))
((("x" "l" "d" ))("팅"))
((("x" "l" "f" ))("틸"))
((("x" "l" "q" ))("팁"))
((("x" "l" "r" ))("틱"))
((("x" "l" "s" ))("틴"))
((("x" "l" "t" ))("팃"))
((("x" "m" ))("트"))
((("x" "m" "a" ))("틈"))
((("x" "m" "e" ))("튿"))
((("x" "m" "f" ))("틀"))
((("x" "m" "f" "a" ))("틂"))
((("x" "m" "l" ))("틔"))
((("x" "m" "l" "a" ))("틤"))
((("x" "m" "l" "f" ))("틜"))
((("x" "m" "l" "q" ))("틥"))
((("x" "m" "l" "s" ))("틘"))
((("x" "m" "q" ))("틉"))
((("x" "m" "r" ))("특"))
((("x" "m" "s" ))("튼"))
((("x" "m" "t" ))("틋"))
((("x" "n" ))("투"))
((("x" "n" "a" ))("툼"))
((("x" "n" "d" ))("퉁"))
((("x" "n" "f" ))("툴"))
((("x" "n" "j" ))("퉈"))
((("x" "n" "j" "T" ))("퉜"))
((("x" "n" "l" ))("튀"))
((("x" "n" "l" "a" ))("튐"))
((("x" "n" "l" "d" ))("튕"))
((("x" "n" "l" "f" ))("튈"))
((("x" "n" "l" "q" ))("튑"))
((("x" "n" "l" "r" ))("튁"))
((("x" "n" "l" "s" ))("튄"))
((("x" "n" "p" ))("퉤"))
((("x" "n" "q" ))("툽"))
((("x" "n" "r" ))("툭"))
((("x" "n" "s" ))("툰"))
((("x" "n" "t" ))("툿"))
((("x" "o" ))("태"))
((("x" "o" "T" ))("탰"))
((("x" "o" "a" ))("탬"))
((("x" "o" "d" ))("탱"))
((("x" "o" "f" ))("탤"))
((("x" "o" "q" ))("탭"))
((("x" "o" "r" ))("택"))
((("x" "o" "s" ))("탠"))
((("x" "o" "t" ))("탯"))
((("x" "p" ))("테"))
((("x" "p" "a" ))("템"))
((("x" "p" "d" ))("텡"))
((("x" "p" "f" ))("텔"))
((("x" "p" "q" ))("텝"))
((("x" "p" "r" ))("텍"))
((("x" "p" "s" ))("텐"))
((("x" "p" "t" ))("텟"))
((("x" "u" ))("텨"))
((("x" "u" "T" ))("텼"))
((("x" "u" "s" ))("텬"))
((("x" "y" ))("툐"))
((("y" ))("ㅛ"))
((("z" ))("ㅋ"))
((("z" "P" ))("켸"))
((("z" "b" ))("큐"))
((("z" "b" "a" ))("큠"))
((("z" "b" "f" ))("큘"))
((("z" "b" "s" ))("큔"))
((("z" "h" ))("코"))
((("z" "h" "a" ))("콤"))
((("z" "h" "d" ))("콩"))
((("z" "h" "f" ))("콜"))
((("z" "h" "k" ))("콰"))
((("z" "h" "k" "a" ))("쾀"))
((("z" "h" "k" "d" ))("쾅"))
((("z" "h" "k" "f" ))("콸"))
((("z" "h" "k" "r" ))("콱"))
((("z" "h" "k" "s" ))("콴"))
((("z" "h" "l" ))("쾨"))
((("z" "h" "l" "f" ))("쾰"))
((("z" "h" "o" ))("쾌"))
((("z" "h" "o" "d" ))("쾡"))
((("z" "h" "q" ))("콥"))
((("z" "h" "r" ))("콕"))
((("z" "h" "s" ))("콘"))
((("z" "h" "t" ))("콧"))
((("z" "i" ))("캬"))
((("z" "i" "d" ))("컁"))
((("z" "i" "r" ))("캭"))
((("z" "j" ))("커"))
((("z" "j" "T" ))("컸"))
((("z" "j" "a" ))("컴"))
((("z" "j" "d" ))("컹"))
((("z" "j" "e" ))("컫"))
((("z" "j" "f" ))("컬"))
((("z" "j" "q" ))("컵"))
((("z" "j" "r" ))("컥"))
((("z" "j" "s" ))("컨"))
((("z" "j" "t" ))("컷"))
((("z" "k" ))("카"))
((("z" "k" "a" ))("캄"))
((("z" "k" "d" ))("캉"))
((("z" "k" "f" ))("칼"))
((("z" "k" "q" ))("캅"))
((("z" "k" "r" ))("칵"))
((("z" "k" "s" ))("칸"))
((("z" "k" "t" ))("캇"))
((("z" "l" ))("키"))
((("z" "l" "a" ))("킴"))
((("z" "l" "d" ))("킹"))
((("z" "l" "f" ))("킬"))
((("z" "l" "q" ))("킵"))
((("z" "l" "r" ))("킥"))
((("z" "l" "s" ))("킨"))
((("z" "l" "t" ))("킷"))
((("z" "m" ))("크"))
((("z" "m" "a" ))("큼"))
((("z" "m" "d" ))("킁"))
((("z" "m" "f" ))("클"))
((("z" "m" "q" ))("큽"))
((("z" "m" "r" ))("큭"))
((("z" "m" "s" ))("큰"))
((("z" "n" ))("쿠"))
((("z" "n" "a" ))("쿰"))
((("z" "n" "d" ))("쿵"))
((("z" "n" "f" ))("쿨"))
((("z" "n" "j" ))("쿼"))
((("z" "n" "j" "d" ))("퀑"))
((("z" "n" "j" "f" ))("퀄"))
((("z" "n" "j" "s" ))("퀀"))
((("z" "n" "l" ))("퀴"))
((("z" "n" "l" "a" ))("큄"))
((("z" "n" "l" "d" ))("큉"))
((("z" "n" "l" "f" ))("퀼"))
((("z" "n" "l" "q" ))("큅"))
((("z" "n" "l" "r" ))("퀵"))
((("z" "n" "l" "s" ))("퀸"))
((("z" "n" "l" "t" ))("큇"))
((("z" "n" "p" ))("퀘"))
((("z" "n" "p" "d" ))("퀭"))
((("z" "n" "q" ))("쿱"))
((("z" "n" "r" ))("쿡"))
((("z" "n" "s" ))("쿤"))
((("z" "n" "t" ))("쿳"))
((("z" "o" ))("캐"))
((("z" "o" "T" ))("캤"))
((("z" "o" "a" ))("캠"))
((("z" "o" "d" ))("캥"))
((("z" "o" "f" ))("캘"))
((("z" "o" "q" ))("캡"))
((("z" "o" "r" ))("캑"))
((("z" "o" "s" ))("캔"))
((("z" "o" "t" ))("캣"))
((("z" "p" ))("케"))
((("z" "p" "a" ))("켐"))
((("z" "p" "d" ))("켕"))
((("z" "p" "f" ))("켈"))
((("z" "p" "q" ))("켑"))
((("z" "p" "r" ))("켁"))
((("z" "p" "s" ))("켄"))
((("z" "p" "t" ))("켓"))
((("z" "u" ))("켜"))
((("z" "u" "T" ))("켰"))
((("z" "u" "a" ))("켬"))
((("z" "u" "d" ))("켱"))
((("z" "u" "f" ))("켤"))
((("z" "u" "q" ))("켭"))
((("z" "u" "s" ))("켠"))
((("z" "u" "t" ))("켯"))
((("z" "y" ))("쿄"))
))
