/*
 * ogg_mod.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "modules.h"

static int parse_ogg(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br);

static Module OGG = {
        .ext     = ".ogg",
        .cmd     = "ogg123",
        .pos     = "-k",
        .dev     = "-d",
        .opt     = "-v",
        .postype = SECONDS,
        .parse   = &parse_ogg,
        .infos   = NULL
};


void register_ogg()
{
        register_module(&OGG);
}


static int parse_ogg(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br)
{
        int r = 0;
        char *t = strstr(datas, "Time:");

        if (t == datas)
        {
                char  total[30];
                float bitrate;
                int   cs, rcs;
                r = sscanf(datas,
                        "Time: %d:%d.%d [%d:%d.%d] of %s , Bitrate: %f",
                        mins, secs, &cs, rms, rss, &rcs, total, &bitrate);
                *br = (int) bitrate;
                *frame = 0;
        }


        return (r == 8);
}

