/**************************************************
 timemachine.c -- Copyright(c) 1999,2003 Jiro SEKIBA <jir@hello.to>
 **************************************************/

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define BUF 512

void usage(char *name)
{
  printf("%s ver %s Copyright(c) 1999,2003 Jiro SEKIBA <jir@hello.to>\n",name,VERSION);
  printf("Usage: %s [-y year][-m month][-d day][-H hour][-M minutes]\n");
  printf("                    [-S seconds] -p program [args...]\n",name);
  printf("Usage: %s [-s +/- seconds] -p program [args...]\n",name);
  printf("Usage: %s [-u s seconds since 1st Jan 1970] -p program [args...]\n\n",name);
  printf("options \t args       \t    description\n");
  printf("  -y    \t year       \t specify trip year(>1970)\n");
  printf("  -m    \t month      \t specify trip month(1-12)\n");
  printf("  -d    \t day        \t specify trip day(1-31)\n");
  printf("  -H    \t hour       \t specify trip hour(0-23)\n");
  printf("  -M    \t minutes    \t specify trip minutes(0-59)\n");
  printf("  -S    \t seconds    \t specify trip seconds(0-59)\n");
  printf("  -u    \t +seconds   \t specify trip seconds since 1st Jan 1970\n");
  printf("  -s    \t +/-seconds \t specify trip seconds since now\n");
}


int toint(char *str)
{
  int ret;
  char **error=NULL;
  ret = strtol(str,error,0);
  if(error)
  {
    ret = -1;
  }
  return ret;
}

time_t parse_arg(int argc, char *argv[])
{
  int c;
  int year=-1,month=-1,mday=-1;
  int hour=-1,min=-1,sec=-1;
  int abs_sec=0, utc_sec=-1;
  int error = -1;
  time_t now = 0;
  time_t ret = 0;
  time_t trip_time;
  struct tm *tm_trip = NULL;

  while((c = getopt(argc,argv,"y:m:d:H:M:S:u:s:ph")) != -1)
  {
    switch(c)
    {
      case 'y':
          year = toint(optarg);
          break;
      case 'm':
          month = toint(optarg);
          break;
      case 'd':
          mday = toint(optarg);
          break;
      case 'H':
          hour = toint(optarg);
          break;
      case 'M':
          min = toint(optarg);
          break;
      case 'S':
          sec = toint(optarg);
          break;
      case 'u':
          utc_sec = toint(optarg);
          break;
      case 's':
          abs_sec = toint(optarg);
          break;
      case 'p':
          error = 0;
          goto end_while;
          break;
      case 'h':
      case '?':
      default:
          usage(argv[0]);
          exit(1);
    }
  }
  end_while:

  if(error)
  {
    usage(argv[0]);
    exit(1);
  }

  now = time(NULL);
  tm_trip = localtime(&now);

  if( 1900 < year)
      tm_trip->tm_year = year - 1900;
  if( 1<= month && month <=12)
      tm_trip->tm_mon = month - 1;
  if( 1<= mday && mday <= 31 )
      tm_trip->tm_mday = mday;
  if( 0<= hour && hour <= 23)
      tm_trip->tm_hour = hour;
  if( 0<= min && min <= 59)
      tm_trip->tm_min = min;
  if( 0<= sec && sec <= 59 ) 
      tm_trip->tm_sec = sec;

  trip_time = mktime(tm_trip);
  ret = trip_time - now;

  if(0<=utc_sec)
    ret = utc_sec  - now;

  if(abs_sec)
    ret = abs_sec;

  return ret;
}

int main(int argc, char *argv[])
{
  char env_tm_time[BUF];
  char env_ld_preload[BUF];
  char *t;
  time_t tm_date = 0;


  sprintf(env_tm_time,"%li",(long)time(NULL));
  t = getenv("TM_DATE");
  if(t) sprintf(env_tm_time,"%s",t);

  tm_date = parse_arg(argc,argv);
  sprintf(env_tm_time,"TM_DATE=%li",(long)tm_date);
  putenv(env_tm_time);
  
  sprintf(env_ld_preload,"LD_PRELOAD=libtimemachine.so");
  putenv(env_ld_preload);

  if(optind < argc )
      return execvp(argv[optind],&argv[optind]);
  else
      usage(argv[0]);
  return 1;
}
