/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTEVENT_H_
#define SCIMBRIDGEAGENTEVENT_H_

#include "scim-bridge.h"

enum scim_bridge_agent_event_code_t
{
    ALLOC_IMCONTEXT_EVENT,
    BEEP_EVENT,
    CLIENT_CLOSED_EVENT,
    CLIENT_OPENED_EVENT,
    CHANGE_FACTORY_EVENT,
    COMMIT_EVENT,
    CURSOR_LOCATION_CHANGED_EVENT,
    DELETE_SURROUNDING_TEXT_EVENT,
    FILTER_KEY_EVENT,
    FORWARD_KEY_EVENT,
    FOCUS_CHANGED_EVENT,
    FREE_IMCONTEXT_EVENT,
    GET_SURROUNDING_TEXT_EVENT,
    IMCONTEXT_ALLOCATED_EVENT,
    IMCONTEXT_FREED_EVENT,
    KEY_HANDLED_EVENT,
    QUIT_EVENT,
    RESET_IMCONTEXT_EVENT,
    PANEL_PENDING_EVENT,
    SET_PREEDIT_ENABLED_EVENT,
    SET_PREEDIT_SHOWN_EVENT,
    SET_PREEDIT_CURSOR_POSITION_EVENT,
    SET_PREEDIT_STRING_EVENT,
    SET_PREEDIT_ATTRIBUTES_EVENT,
    SURROUNDING_TEXT_DELETED_EVENT,
    SURROUNDING_TEXT_GOTTEN_EVENT,
    UPDATE_PREEDIT_EVENT,
};

class ScimBridgeAgentEvent
{

    public:

        virtual ~ScimBridgeAgentEvent ();

        scim_bridge_agent_event_code_t get_code () const;

    protected:

        ScimBridgeAgentEvent (scim_bridge_agent_event_code_t new_code);

    private:

        const scim_bridge_agent_event_code_t code;

};
#endif                                            /*SCIMBRIDGEAGENTEVENT_H_*/
